#include <iostream>
#include <vector>
#include <list>
#include <map>

#include <rumba/arghandler.h>
#include <rumba/exception.h>
#include <rumba/parse.h>
#include <rumba/loadVols.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/matrix.hpp>
#include <rumba/matrixio.h>


using namespace RUMBA;

void usage()
{
	std::cerr << "Usage: matrix-trace -i infile -o outfile\n";
}

/********** If we had special args, here would be the place for them...
Argument myArgs [] = {
	Argument()
};
*********** But we don't...*******************************************/

int main(int argc,char** argv)
{
	std::string infile , outfile;
	try {
		ArgHandler argh ( argc , argv );
		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}
		argh.arg ( "infile" , infile );
		argh.arg ( "outfile" , outfile );
	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
	//	std::cerr << "Error in argument: " << s.error() << std::endl;
	}
	catch (Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl;
	}

	double result = trace( manifoldMatrixReadHack( infile.c_str() ) );
	if ( outfile.empty() ) std::cout <<result<<std::endl;
	else 
	{
		std::ofstream fout( outfile.c_str() );
		fout<<result<<std::endl;
	}
}
