//rumbaview colorbar.h

#ifndef COLORBAR_H
#define COLORBAR_H
#include <utility>

#include <qframe.h>
#include <qpainter.h>
#include <qimage.h>

#include "colormap.h"

/**
  *@author Giorgio Grasso, Ben Bly, Donovan Rebbechi
  */

class ColorBar : public QFrame  {
	Q_OBJECT
public: 
	typedef std::pair<double,double> dPoint;
	ColorBar(QWidget *parent=0, dPoint scale = dPoint(0,1));
	~ColorBar();
	void setColormap(const RUMBA::Colormap*);
	void showBar();

signals:
	void changeThreshold(int t, int T);

protected:
	virtual void enterEvent(QEvent *qee);
	virtual void mousePressEvent(QMouseEvent *qme);
	virtual void mouseReleaseEvent(QMouseEvent *qme);
	virtual void mouseMoveEvent(QMouseEvent *qme);
	virtual void resizeEvent(QResizeEvent *qre);
	virtual void paintEvent(QPaintEvent *qpe);
	virtual void keyPressEvent(QKeyEvent *qke);

private:
	QWidget *p;
	QImage *cmap_image, *image;
	QPainter *painter;
	const RUMBA::Colormap *colormap;
	int min, max;
	bool move_min, move_max;
	dPoint Scale;
};

#endif
