#include <rumba/rumba_system.h>
#include <rumba/parse.h>
#include <rumba/exception.h>

#include "colormaplist.h"

#include "config.h"

#include "grey.xpm"
#include "hotmetal.xpm"


using namespace RUMBA;
using namespace std;

namespace
{
void initPath(string& rumbaview_path)
{
	const char* tmp_rumba_path = rumba_getenv("RUMBA_COLORMAP");
	if (tmp_rumba_path == NULL)
	{
		rumbaview_path = RUMBA_PREFIX;
		rumbaview_path += "/share/rumbaview/";
	}
	else
		rumbaview_path = tmp_rumba_path;
}

void loadColorMaps(vector<Colormap>& v)
{
//	v.clear();

	static Colormap grey_map ( (const char**) grey, "grey");
	static Colormap hotmetal_map( (const char**) hotmetal, "hotmetal");

	v.push_back(grey_map);
	v.push_back(hotmetal_map);


	list<string> files = ls(getPath());
	for (list<string>::iterator it = files.begin(); it!= files.end(); ++it)
		if (fileExtension(*it) == ".xpm")
		{
			cerr << "loading colormap:"<<it->c_str()<<":"<<endl;
			v.push_back(Colormap(it->c_str()));
		}
}


}

const string& RUMBA::getPath()
{
	static string rumbaview_path;
	if (rumbaview_path.empty())
		initPath(rumbaview_path);
	return rumbaview_path;
}

vector<Colormap> & RUMBA::colorMapList()
{
	static vector<Colormap> v;
	if (v.empty())
	{
	// reload colormaps each time list is requested!
		loadColorMaps(v);
		if (v.empty())
			throw RUMBA::Exception (
"Fatal: no colormaps found. Make sure your software is installed correctly,\n" 
"or set your RUMBA_COLORMAP environment variable");
	}
	return v;
}

