<!-- file * -->
<!-- struct AboutDialog -->
The `AboutDialog` offers a simple way to display information about
a program like its logo, name, copyright, website and license. It is
also possible to give credits to the authors, documenters, translators
and artists who have worked on the program. An about dialog is typically
opened when the user selects the `About` option from the `Help` menu.
All parts of the dialog are optional.

About dialogs often contain links and email addresses. `AboutDialog`
displays these as clickable links. By default, it calls `gtk_show_uri_on_window`
when a user clicks one. The behaviour can be overridden with the
`AboutDialog::activate-link` signal.

To specify a person with an email address, use a string like
"Edgar Allan Poe <edgar\@poe.com>". To specify a website with a title,
use a string like "GTK+ team http://www.gtk.org".

To make constructing a `AboutDialog` as convenient as possible, you can
use the function `gtk_show_about_dialog` which constructs and shows a dialog
and keeps it around so that it can be shown again.

Note that GTK+ sets a default title of `_("About %s")` on the dialog
window (where \%s is replaced by the name of the application, but in
order to ensure proper translation of the title, applications should
set the title property explicitly when constructing a `AboutDialog`,
as shown in the following example:

```C
gtk_show_about_dialog (NULL,
                       "program-name", "ExampleCode",
                       "logo", example_logo,
                       "title" _("About ExampleCode"),
                       NULL);
```

It is also possible to show a `AboutDialog` like any other `Dialog`,
e.g. using `DialogExt::run`. In this case, you might need to know that
the “Close” button returns the `ResponseType::Cancel` response id.

# Implements

[`AboutDialogExt`](trait.AboutDialogExt.html), [`DialogExt`](trait.DialogExt.html), [`GtkWindowExt`](trait.GtkWindowExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait AboutDialogExt -->
Trait containing all `AboutDialog` methods.

# Implementors

[`AboutDialog`](struct.AboutDialog.html)
<!-- impl AboutDialog::fn new -->
Creates a new `AboutDialog`.

# Returns

a newly created `AboutDialog`
<!-- trait AboutDialogExt::fn add_credit_section -->
Creates a new section in the Credits page.
## `section_name`
The name of the section
## `people`
The people who belong to that section
<!-- trait AboutDialogExt::fn get_artists -->
Returns the string which are displayed in the artists tab
of the secondary credits dialog.

# Returns

A
 `None`-terminated string array containing the artists. The array is
 owned by the about dialog and must not be modified.
<!-- trait AboutDialogExt::fn get_authors -->
Returns the string which are displayed in the authors tab
of the secondary credits dialog.

# Returns

A
 `None`-terminated string array containing the authors. The array is
 owned by the about dialog and must not be modified.
<!-- trait AboutDialogExt::fn get_comments -->
Returns the comments string.

# Returns

The comments. The string is owned by the about
 dialog and must not be modified.
<!-- trait AboutDialogExt::fn get_copyright -->
Returns the copyright string.

# Returns

The copyright string. The string is owned by the about
 dialog and must not be modified.
<!-- trait AboutDialogExt::fn get_documenters -->
Returns the string which are displayed in the documenters
tab of the secondary credits dialog.

# Returns

A
 `None`-terminated string array containing the documenters. The
 array is owned by the about dialog and must not be modified.
<!-- trait AboutDialogExt::fn get_license -->
Returns the license information.

# Returns

The license information. The string is owned by the about
 dialog and must not be modified.
<!-- trait AboutDialogExt::fn get_license_type -->
Retrieves the license set using `AboutDialogExt::set_license_type`

# Returns

a `License` value
<!-- trait AboutDialogExt::fn get_logo -->
Returns the pixbuf displayed as logo in the about dialog.

# Returns

the pixbuf displayed as logo. The
 pixbuf is owned by the about dialog. If you want to keep a
 reference to it, you have to call `gobject::ObjectExt::ref` on it.
<!-- trait AboutDialogExt::fn get_logo_icon_name -->
Returns the icon name displayed as logo in the about dialog.

# Returns

the icon name displayed as logo. The string is
 owned by the dialog. If you want to keep a reference
 to it, you have to call `g_strdup` on it.
<!-- trait AboutDialogExt::fn get_program_name -->
Returns the program name displayed in the about dialog.

# Returns

The program name. The string is owned by the about
 dialog and must not be modified.
<!-- trait AboutDialogExt::fn get_translator_credits -->
Returns the translator credits string which is displayed
in the translators tab of the secondary credits dialog.

# Returns

The translator credits string. The string is
 owned by the about dialog and must not be modified.
<!-- trait AboutDialogExt::fn get_version -->
Returns the version string.

# Returns

The version string. The string is owned by the about
 dialog and must not be modified.
<!-- trait AboutDialogExt::fn get_website -->
Returns the website URL.

# Returns

The website URL. The string is owned by the about
 dialog and must not be modified.
<!-- trait AboutDialogExt::fn get_website_label -->
Returns the label used for the website link.

# Returns

The label used for the website link. The string is
 owned by the about dialog and must not be modified.
<!-- trait AboutDialogExt::fn get_wrap_license -->
Returns whether the license text in `self` is
automatically wrapped.

# Returns

`true` if the license text is wrapped
<!-- trait AboutDialogExt::fn set_artists -->
Sets the strings which are displayed in the artists tab
of the secondary credits dialog.
## `artists`
a `None`-terminated array of strings
<!-- trait AboutDialogExt::fn set_authors -->
Sets the strings which are displayed in the authors tab
of the secondary credits dialog.
## `authors`
a `None`-terminated array of strings
<!-- trait AboutDialogExt::fn set_comments -->
Sets the comments string to display in the about dialog.
This should be a short string of one or two lines.
## `comments`
a comments string
<!-- trait AboutDialogExt::fn set_copyright -->
Sets the copyright string to display in the about dialog.
This should be a short string of one or two lines.
## `copyright`
the copyright string
<!-- trait AboutDialogExt::fn set_documenters -->
Sets the strings which are displayed in the documenters tab
of the secondary credits dialog.
## `documenters`
a `None`-terminated array of strings
<!-- trait AboutDialogExt::fn set_license -->
Sets the license information to be displayed in the secondary
license dialog. If `license` is `None`, the license button is
hidden.
## `license`
the license information or `None`
<!-- trait AboutDialogExt::fn set_license_type -->
Sets the license of the application showing the `self` dialog from a
list of known licenses.

This function overrides the license set using
`AboutDialogExt::set_license`.
## `license_type`
the type of license
<!-- trait AboutDialogExt::fn set_logo -->
Sets the pixbuf to be displayed as logo in the about dialog.
If it is `None`, the default window icon set with
`Window::set_default_icon` will be used.
## `logo`
a `gdk_pixbuf::Pixbuf`, or `None`
<!-- trait AboutDialogExt::fn set_logo_icon_name -->
Sets the pixbuf to be displayed as logo in the about dialog.
If it is `None`, the default window icon set with
`Window::set_default_icon` will be used.
## `icon_name`
an icon name, or `None`
<!-- trait AboutDialogExt::fn set_program_name -->
Sets the name to display in the about dialog.
If this is not set, it defaults to `g_get_application_name`.
## `name`
the program name
<!-- trait AboutDialogExt::fn set_translator_credits -->
Sets the translator credits string which is displayed in
the translators tab of the secondary credits dialog.

The intended use for this string is to display the translator
of the language which is currently used in the user interface.
Using `gettext`, a simple way to achieve that is to mark the
string for translation:

```C
 gtk_about_dialog_set_translator_credits (about,
                                          _("translator-credits"));
```
It is a good idea to use the customary msgid “translator-credits” for this
purpose, since translators will already know the purpose of that msgid, and
since `AboutDialog` will detect if “translator-credits” is untranslated
and hide the tab.
## `translator_credits`
the translator credits
<!-- trait AboutDialogExt::fn set_version -->
Sets the version string to display in the about dialog.
## `version`
the version string
<!-- trait AboutDialogExt::fn set_website -->
Sets the URL to use for the website link.
## `website`
a URL string starting with "http://"
<!-- trait AboutDialogExt::fn set_website_label -->
Sets the label to be used for the website link.
## `website_label`
the label used for the website link
<!-- trait AboutDialogExt::fn set_wrap_license -->
Sets whether the license text in `self` is
automatically wrapped.
## `wrap_license`
whether to wrap the license
<!-- trait AboutDialogExt::fn connect_activate_link -->
The signal which gets emitted to activate a URI.
Applications may connect to it to override the default behaviour,
which is to call `gtk_show_uri_on_window`.
## `uri`
the URI that is activated

# Returns

`true` if the link has been activated
<!-- trait AboutDialogExt::fn get_property_artists -->
The people who contributed artwork to the program, as a `None`-terminated
array of strings. Each string may contain email addresses and URLs, which
will be displayed as links, see the introduction for more details.
<!-- trait AboutDialogExt::fn set_property_artists -->
The people who contributed artwork to the program, as a `None`-terminated
array of strings. Each string may contain email addresses and URLs, which
will be displayed as links, see the introduction for more details.
<!-- trait AboutDialogExt::fn get_property_authors -->
The authors of the program, as a `None`-terminated array of strings.
Each string may contain email addresses and URLs, which will be displayed
as links, see the introduction for more details.
<!-- trait AboutDialogExt::fn set_property_authors -->
The authors of the program, as a `None`-terminated array of strings.
Each string may contain email addresses and URLs, which will be displayed
as links, see the introduction for more details.
<!-- trait AboutDialogExt::fn get_property_comments -->
Comments about the program. This string is displayed in a label
in the main dialog, thus it should be a short explanation of
the main purpose of the program, not a detailed list of features.
<!-- trait AboutDialogExt::fn set_property_comments -->
Comments about the program. This string is displayed in a label
in the main dialog, thus it should be a short explanation of
the main purpose of the program, not a detailed list of features.
<!-- trait AboutDialogExt::fn get_property_copyright -->
Copyright information for the program.
<!-- trait AboutDialogExt::fn set_property_copyright -->
Copyright information for the program.
<!-- trait AboutDialogExt::fn get_property_documenters -->
The people documenting the program, as a `None`-terminated array of strings.
Each string may contain email addresses and URLs, which will be displayed
as links, see the introduction for more details.
<!-- trait AboutDialogExt::fn set_property_documenters -->
The people documenting the program, as a `None`-terminated array of strings.
Each string may contain email addresses and URLs, which will be displayed
as links, see the introduction for more details.
<!-- trait AboutDialogExt::fn get_property_license -->
The license of the program. This string is displayed in a
text view in a secondary dialog, therefore it is fine to use
a long multi-paragraph text. Note that the text is only wrapped
in the text view if the "wrap-license" property is set to `true`;
otherwise the text itself must contain the intended linebreaks.
When setting this property to a non-`None` value, the
`AboutDialog:license-type` property is set to `License::Custom`
as a side effect.
<!-- trait AboutDialogExt::fn set_property_license -->
The license of the program. This string is displayed in a
text view in a secondary dialog, therefore it is fine to use
a long multi-paragraph text. Note that the text is only wrapped
in the text view if the "wrap-license" property is set to `true`;
otherwise the text itself must contain the intended linebreaks.
When setting this property to a non-`None` value, the
`AboutDialog:license-type` property is set to `License::Custom`
as a side effect.
<!-- trait AboutDialogExt::fn get_property_license-type -->
The license of the program, as a value of the `License` enumeration.

The `AboutDialog` will automatically fill out a standard disclaimer
and link the user to the appropriate online resource for the license
text.

If `License::Unknown` is used, the link used will be the same
specified in the `AboutDialog:website` property.

If `License::Custom` is used, the current contents of the
`AboutDialog:license` property are used.

For any other `License` value, the contents of the
`AboutDialog:license` property are also set by this property as
a side effect.
<!-- trait AboutDialogExt::fn set_property_license-type -->
The license of the program, as a value of the `License` enumeration.

The `AboutDialog` will automatically fill out a standard disclaimer
and link the user to the appropriate online resource for the license
text.

If `License::Unknown` is used, the link used will be the same
specified in the `AboutDialog:website` property.

If `License::Custom` is used, the current contents of the
`AboutDialog:license` property are used.

For any other `License` value, the contents of the
`AboutDialog:license` property are also set by this property as
a side effect.
<!-- trait AboutDialogExt::fn get_property_logo -->
A logo for the about box. If it is `None`, the default window icon
set with `Window::set_default_icon` will be used.
<!-- trait AboutDialogExt::fn set_property_logo -->
A logo for the about box. If it is `None`, the default window icon
set with `Window::set_default_icon` will be used.
<!-- trait AboutDialogExt::fn get_property_logo-icon-name -->
A named icon to use as the logo for the about box. This property
overrides the `AboutDialog:logo` property.
<!-- trait AboutDialogExt::fn set_property_logo-icon-name -->
A named icon to use as the logo for the about box. This property
overrides the `AboutDialog:logo` property.
<!-- trait AboutDialogExt::fn get_property_program-name -->
The name of the program.
If this is not set, it defaults to `g_get_application_name`.
<!-- trait AboutDialogExt::fn set_property_program-name -->
The name of the program.
If this is not set, it defaults to `g_get_application_name`.
<!-- trait AboutDialogExt::fn get_property_translator-credits -->
Credits to the translators. This string should be marked as translatable.
The string may contain email addresses and URLs, which will be displayed
as links, see the introduction for more details.
<!-- trait AboutDialogExt::fn set_property_translator-credits -->
Credits to the translators. This string should be marked as translatable.
The string may contain email addresses and URLs, which will be displayed
as links, see the introduction for more details.
<!-- trait AboutDialogExt::fn get_property_version -->
The version of the program.
<!-- trait AboutDialogExt::fn set_property_version -->
The version of the program.
<!-- trait AboutDialogExt::fn get_property_website -->
The URL for the link to the website of the program.
This should be a string starting with "http://.
<!-- trait AboutDialogExt::fn set_property_website -->
The URL for the link to the website of the program.
This should be a string starting with "http://.
<!-- trait AboutDialogExt::fn get_property_website-label -->
The label for the link to the website of the program.
<!-- trait AboutDialogExt::fn set_property_website-label -->
The label for the link to the website of the program.
<!-- trait AboutDialogExt::fn get_property_wrap-license -->
Whether to wrap the text in the license dialog.
<!-- trait AboutDialogExt::fn set_property_wrap-license -->
Whether to wrap the text in the license dialog.
<!-- struct AccelGroup -->
A `AccelGroup` represents a group of keyboard accelerators,
typically attached to a toplevel `Window` (with
`GtkWindowExt::add_accel_group`). Usually you won’t need to create a
`AccelGroup` directly; instead, when using `UIManager`, GTK+
automatically sets up the accelerators for your menus in the ui
manager’s `AccelGroup`.

Note that “accelerators” are different from
“mnemonics”. Accelerators are shortcuts for
activating a menu item; they appear alongside the menu item they’re a
shortcut for. For example “Ctrl+Q” might appear alongside the “Quit”
menu item. Mnemonics are shortcuts for GUI elements such as text
entries or buttons; they appear as underlined characters. See
`Label::new_with_mnemonic`. Menu items can have both accelerators
and mnemonics, of course.

# Implements

[`AccelGroupExt`](trait.AccelGroupExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait AccelGroupExt -->
Trait containing all `AccelGroup` methods.

# Implementors

[`AccelGroup`](struct.AccelGroup.html)
<!-- impl AccelGroup::fn new -->
Creates a new `AccelGroup`.

# Returns

a new `AccelGroup` object
<!-- impl AccelGroup::fn from_accel_closure -->
Finds the `AccelGroup` to which `closure` is connected;
see `AccelGroupExt::connect`.
## `closure`
a `gobject::Closure`

# Returns

the `AccelGroup` to which `closure`
 is connected, or `None`
<!-- trait AccelGroupExt::fn activate -->
Finds the first accelerator in `self` that matches
`accel_key` and `accel_mods`, and activates it.
## `accel_quark`
the quark for the accelerator name
## `acceleratable`
the `gobject::Object`, usually a `Window`, on which
 to activate the accelerator
## `accel_key`
accelerator keyval from a key event
## `accel_mods`
keyboard state mask from a key event

# Returns

`true` if an accelerator was activated and handled
 this keypress
<!-- trait AccelGroupExt::fn connect -->
Installs an accelerator in this group. When `self` is being
activated in response to a call to `gtk_accel_groups_activate`,
`closure` will be invoked if the `accel_key` and `accel_mods` from
`gtk_accel_groups_activate` match those of this connection.

The signature used for the `closure` is that of ``GtkAccelGroupActivate``.

Note that, due to implementation details, a single closure can
only be connected to one accelerator group.
## `accel_key`
key value of the accelerator
## `accel_mods`
modifier combination of the accelerator
## `accel_flags`
a flag mask to configure this accelerator
## `closure`
closure to be executed upon accelerator activation
<!-- trait AccelGroupExt::fn connect_by_path -->
Installs an accelerator in this group, using an accelerator path
to look up the appropriate key and modifiers (see
`AccelMap::add_entry`). When `self` is being activated
in response to a call to `gtk_accel_groups_activate`, `closure` will
be invoked if the `accel_key` and `accel_mods` from
`gtk_accel_groups_activate` match the key and modifiers for the path.

The signature used for the `closure` is that of ``GtkAccelGroupActivate``.

Note that `accel_path` string will be stored in a `glib::Quark`. Therefore,
if you pass a static string, you can save some memory by interning it
first with `g_intern_static_string`.
## `accel_path`
path used for determining key and modifiers
## `closure`
closure to be executed upon accelerator activation
<!-- trait AccelGroupExt::fn disconnect -->
Removes an accelerator previously installed through
`AccelGroupExt::connect`.

Since 2.20 `closure` can be `None`.
## `closure`
the closure to remove from this accelerator
 group, or `None` to remove all closures

# Returns

`true` if the closure was found and got disconnected
<!-- trait AccelGroupExt::fn disconnect_key -->
Removes an accelerator previously installed through
`AccelGroupExt::connect`.
## `accel_key`
key value of the accelerator
## `accel_mods`
modifier combination of the accelerator

# Returns

`true` if there was an accelerator which could be
 removed, `false` otherwise
<!-- trait AccelGroupExt::fn find -->
Finds the first entry in an accelerator group for which
`find_func` returns `true` and returns its `AccelKey`.
## `find_func`
a function to filter the entries
 of `self` with
## `data`
data to pass to `find_func`

# Returns

the key of the first entry passing
 `find_func`. The key is owned by GTK+ and must not be freed.
<!-- trait AccelGroupExt::fn get_is_locked -->
Locks are added and removed using `AccelGroupExt::lock` and
`AccelGroupExt::unlock`.

# Returns

`true` if there are 1 or more locks on the `self`,
 `false` otherwise.
<!-- trait AccelGroupExt::fn get_modifier_mask -->
Gets a `gdk::ModifierType` representing the mask for this
`self`. For example, `gdk::ModifierType::ControlMask`, `gdk::ModifierType::ShiftMask`, etc.

# Returns

the modifier mask for this accel group.
<!-- trait AccelGroupExt::fn lock -->
Locks the given accelerator group.

Locking an acelerator group prevents the accelerators contained
within it to be changed during runtime. Refer to
`AccelMap::change_entry` about runtime accelerator changes.

If called more than once, `self` remains locked until
`AccelGroupExt::unlock` has been called an equivalent number
of times.
<!-- trait AccelGroupExt::fn query -->
Queries an accelerator group for all entries matching `accel_key`
and `accel_mods`.
## `accel_key`
key value of the accelerator
## `accel_mods`
modifier combination of the accelerator
## `n_entries`
location to return the number
 of entries found, or `None`

# Returns

an array of
 `n_entries` `AccelGroupEntry` elements, or `None`. The array
 is owned by GTK+ and must not be freed.
<!-- trait AccelGroupExt::fn unlock -->
Undoes the last call to `AccelGroupExt::lock` on this `self`.
<!-- trait AccelGroupExt::fn connect_accel_activate -->
The accel-activate signal is an implementation detail of
`AccelGroup` and not meant to be used by applications.
## `acceleratable`
the object on which the accelerator was activated
## `keyval`
the accelerator keyval
## `modifier`
the modifier combination of the accelerator

# Returns

`true` if the accelerator was activated
<!-- trait AccelGroupExt::fn connect_accel_changed -->
The accel-changed signal is emitted when an entry
is added to or removed from the accel group.

Widgets like `AccelLabel` which display an associated
accelerator should connect to this signal, and rebuild
their visual representation if the `accel_closure` is theirs.
## `keyval`
the accelerator keyval
## `modifier`
the modifier combination of the accelerator
## `accel_closure`
the `gobject::Closure` of the accelerator
<!-- struct ActionBar -->
`ActionBar` is designed to present contextual actions. It is
expected to be displayed below the content and expand horizontally
to fill the area.

It allows placing children at the start or the end. In addition, it
contains an internal centered box which is centered with respect to
the full width of the box, even if the children at either side take
up different amounts of space.

# CSS nodes

`ActionBar` has a single CSS node with name actionbar.

Feature: `v3_12`

# Implements

[`ActionBarExt`](trait.ActionBarExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait ActionBarExt -->
Trait containing all `ActionBar` methods.

Feature: `v3_12`

# Implementors

[`ActionBar`](struct.ActionBar.html)
<!-- impl ActionBar::fn new -->
Creates a new `ActionBar` widget.

Feature: `v3_12`


# Returns

a new `ActionBar`
<!-- trait ActionBarExt::fn get_center_widget -->
Retrieves the center bar widget of the bar.

Feature: `v3_12`


# Returns

the center `Widget` or `None`.
<!-- trait ActionBarExt::fn pack_end -->
Adds `child` to `self`, packed with reference to the
end of the `self`.

Feature: `v3_12`

## `child`
the `Widget` to be added to `self`
<!-- trait ActionBarExt::fn pack_start -->
Adds `child` to `self`, packed with reference to the
start of the `self`.

Feature: `v3_12`

## `child`
the `Widget` to be added to `self`
<!-- trait ActionBarExt::fn set_center_widget -->
Sets the center widget for the `ActionBar`.

Feature: `v3_12`

## `center_widget`
a widget to use for the center
<!-- struct Actionable -->
This interface provides a convenient way of associating widgets with
actions on a `ApplicationWindow` or `Application`.

It primarily consists of two properties: `Actionable:action-name`
and `Actionable:action-target`. There are also some convenience APIs
for setting these properties.

The action will be looked up in action groups that are found among
the widgets ancestors. Most commonly, these will be the actions with
the “win.” or “app.” prefix that are associated with the `ApplicationWindow`
or `Application`, but other action groups that are added with
`WidgetExt::insert_action_group` will be consulted as well.

# Implements

[`ActionableExt`](trait.ActionableExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait ActionableExt -->
Trait containing all `Actionable` methods.

# Implementors

[`Actionable`](struct.Actionable.html), [`Button`](struct.Button.html), [`CheckButton`](struct.CheckButton.html), [`CheckMenuItem`](struct.CheckMenuItem.html), [`ColorButton`](struct.ColorButton.html), [`FontButton`](struct.FontButton.html), [`ImageMenuItem`](struct.ImageMenuItem.html), [`LinkButton`](struct.LinkButton.html), [`MenuButton`](struct.MenuButton.html), [`MenuItem`](struct.MenuItem.html), [`MenuToolButton`](struct.MenuToolButton.html), [`ModelButton`](struct.ModelButton.html), [`RadioButton`](struct.RadioButton.html), [`RadioMenuItem`](struct.RadioMenuItem.html), [`RadioToolButton`](struct.RadioToolButton.html), [`ScaleButton`](struct.ScaleButton.html), [`SeparatorMenuItem`](struct.SeparatorMenuItem.html), [`Switch`](struct.Switch.html), [`ToggleButton`](struct.ToggleButton.html), [`ToggleToolButton`](struct.ToggleToolButton.html), [`ToolButton`](struct.ToolButton.html), [`VolumeButton`](struct.VolumeButton.html)
<!-- trait ActionableExt::fn get_action_name -->
Gets the action name for `self`.

See `Actionable::set_action_name` for more information.

# Returns

the action name, or `None` if none is set
<!-- trait ActionableExt::fn get_action_target_value -->
Gets the current target value of `self`.

See `Actionable::set_action_target_value` for more information.

# Returns

the current target value
<!-- trait ActionableExt::fn set_action_name -->
Specifies the name of the action with which this widget should be
associated. If `action_name` is `None` then the widget will be
unassociated from any previous action.

Usually this function is used when the widget is located (or will be
located) within the hierarchy of a `ApplicationWindow`.

Names are of the form “win.save” or “app.quit” for actions on the
containing `ApplicationWindow` or its associated `Application`,
respectively. This is the same form used for actions in the `gio::Menu`
associated with the window.
## `action_name`
an action name, or `None`
<!-- trait ActionableExt::fn set_action_target -->
Sets the target of an actionable widget.

This is a convenience function that calls `glib::Variant::new` for
`format_string` and uses the result to call
`Actionable::set_action_target_value`.

If you are setting a string-valued target and want to set the action
name at the same time, you can use
gtk_actionable_set_detailed_action_name ().
## `format_string`
a GVariant format string
<!-- trait ActionableExt::fn set_action_target_value -->
Sets the target value of an actionable widget.

If `target_value` is `None` then the target value is unset.

The target value has two purposes. First, it is used as the
parameter to activation of the action associated with the
`Actionable` widget. Second, it is used to determine if the widget
should be rendered as “active” — the widget is active if the state
is equal to the given target.

Consider the example of associating a set of buttons with a `gio::Action`
with string state in a typical “radio button” situation. Each button
will be associated with the same action, but with a different target
value for that action. Clicking on a particular button will activate
the action with the target of that button, which will typically cause
the action’s state to change to that value. Since the action’s state
is now equal to the target value of the button, the button will now
be rendered as active (and the other buttons, with different targets,
rendered inactive).
## `target_value`
a `glib::Variant` to set as the target value, or `None`
<!-- trait ActionableExt::fn set_detailed_action_name -->
Sets the action-name and associated string target value of an
actionable widget.

This allows for the effect of both `Actionable::set_action_name`
and `Actionable::set_action_target_value` in the common case that
the target is string-valued.

`detailed_action_name` is a string of the form
`"action::target"` where `action`
is the action name and `target` is the string to use
as the target.
## `detailed_action_name`
the detailed action name
<!-- struct Adjustment -->
The `Adjustment` object represents a value which has an associated lower
and upper bound, together with step and page increments, and a page size.
It is used within several GTK+ widgets, including `SpinButton`, `Viewport`,
and `Range` (which is a base class for `Scrollbar` and `Scale`).

The `Adjustment` object does not update the value itself. Instead
it is left up to the owner of the `Adjustment` to control the value.

# Implements

[`AdjustmentExt`](trait.AdjustmentExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait AdjustmentExt -->
Trait containing all `Adjustment` methods.

# Implementors

[`Adjustment`](struct.Adjustment.html)
<!-- impl Adjustment::fn new -->
Creates a new `Adjustment`.
## `value`
the initial value
## `lower`
the minimum value
## `upper`
the maximum value
## `step_increment`
the step increment
## `page_increment`
the page increment
## `page_size`
the page size

# Returns

a new `Adjustment`
<!-- trait AdjustmentExt::fn changed -->
Emits a `Adjustment::changed` signal from the `Adjustment`.
This is typically called by the owner of the `Adjustment` after it has
changed any of the `Adjustment` properties other than the value.

# Deprecated since 3.18

GTK+ emits `Adjustment::changed` itself whenever any
 of the properties (other than value) change
<!-- trait AdjustmentExt::fn clamp_page -->
Updates the `Adjustment:value` property to ensure that the range
between `lower` and `upper` is in the current page (i.e. between
`Adjustment:value` and `Adjustment:value` + `Adjustment:page-size`).
If the range is larger than the page size, then only the start of it will
be in the current page.

A `Adjustment::value-changed` signal will be emitted if the value is changed.
## `lower`
the lower value
## `upper`
the upper value
<!-- trait AdjustmentExt::fn configure -->
Sets all properties of the adjustment at once.

Use this function to avoid multiple emissions of the
`Adjustment::changed` signal. See `AdjustmentExt::set_lower`
for an alternative way of compressing multiple emissions of
`Adjustment::changed` into one.
## `value`
the new value
## `lower`
the new minimum value
## `upper`
the new maximum value
## `step_increment`
the new step increment
## `page_increment`
the new page increment
## `page_size`
the new page size
<!-- trait AdjustmentExt::fn get_lower -->
Retrieves the minimum value of the adjustment.

# Returns

The current minimum value of the adjustment
<!-- trait AdjustmentExt::fn get_minimum_increment -->
Gets the smaller of step increment and page increment.

# Returns

the minimum increment of `self`
<!-- trait AdjustmentExt::fn get_page_increment -->
Retrieves the page increment of the adjustment.

# Returns

The current page increment of the adjustment
<!-- trait AdjustmentExt::fn get_page_size -->
Retrieves the page size of the adjustment.

# Returns

The current page size of the adjustment
<!-- trait AdjustmentExt::fn get_step_increment -->
Retrieves the step increment of the adjustment.

# Returns

The current step increment of the adjustment.
<!-- trait AdjustmentExt::fn get_upper -->
Retrieves the maximum value of the adjustment.

# Returns

The current maximum value of the adjustment
<!-- trait AdjustmentExt::fn get_value -->
Gets the current value of the adjustment.
See `AdjustmentExt::set_value`.

# Returns

The current value of the adjustment
<!-- trait AdjustmentExt::fn set_lower -->
Sets the minimum value of the adjustment.

When setting multiple adjustment properties via their individual
setters, multiple `Adjustment::changed` signals will be emitted.
However, since the emission of the `Adjustment::changed` signal
is tied to the emission of the `gobject::Object::notify` signals of the changed
properties, it’s possible to compress the `Adjustment::changed`
signals into one by calling `gobject::ObjectExt::freeze_notify` and
`gobject::ObjectExt::thaw_notify` around the calls to the individual setters.

Alternatively, using a single `gobject::ObjectExt::set` for all the properties
to change, or using `AdjustmentExt::configure` has the same effect
of compressing `Adjustment::changed` emissions.
## `lower`
the new minimum value
<!-- trait AdjustmentExt::fn set_page_increment -->
Sets the page increment of the adjustment.

See `AdjustmentExt::set_lower` about how to compress multiple
emissions of the `Adjustment::changed` signal when setting
multiple adjustment properties.
## `page_increment`
the new page increment
<!-- trait AdjustmentExt::fn set_page_size -->
Sets the page size of the adjustment.

See `AdjustmentExt::set_lower` about how to compress multiple
emissions of the `Adjustment`::changed signal when setting
multiple adjustment properties.
## `page_size`
the new page size
<!-- trait AdjustmentExt::fn set_step_increment -->
Sets the step increment of the adjustment.

See `AdjustmentExt::set_lower` about how to compress multiple
emissions of the `Adjustment::changed` signal when setting
multiple adjustment properties.
## `step_increment`
the new step increment
<!-- trait AdjustmentExt::fn set_upper -->
Sets the maximum value of the adjustment.

Note that values will be restricted by `upper - page-size`
if the page-size property is nonzero.

See `AdjustmentExt::set_lower` about how to compress multiple
emissions of the `Adjustment::changed` signal when setting
multiple adjustment properties.
## `upper`
the new maximum value
<!-- trait AdjustmentExt::fn set_value -->
Sets the `Adjustment` value. The value is clamped to lie between
`Adjustment:lower` and `Adjustment:upper`.

Note that for adjustments which are used in a `Scrollbar`, the
effective range of allowed values goes from `Adjustment:lower` to
`Adjustment:upper` - `Adjustment:page-size`.
## `value`
the new value
<!-- trait AdjustmentExt::fn value_changed -->
Emits a `Adjustment::value-changed` signal from the `Adjustment`.
This is typically called by the owner of the `Adjustment` after it has
changed the `Adjustment:value` property.

# Deprecated since 3.18

GTK+ emits `Adjustment::value-changed` itself whenever
 the value changes
<!-- trait AdjustmentExt::fn connect_changed -->
Emitted when one or more of the `Adjustment` properties have been
changed, other than the `Adjustment:value` property.
<!-- trait AdjustmentExt::fn connect_value_changed -->
Emitted when the `Adjustment:value` property has been changed.
<!-- trait AdjustmentExt::fn get_property_lower -->
The minimum value of the adjustment.
<!-- trait AdjustmentExt::fn set_property_lower -->
The minimum value of the adjustment.
<!-- trait AdjustmentExt::fn get_property_page-increment -->
The page increment of the adjustment.
<!-- trait AdjustmentExt::fn set_property_page-increment -->
The page increment of the adjustment.
<!-- trait AdjustmentExt::fn get_property_page-size -->
The page size of the adjustment.
Note that the page-size is irrelevant and should be set to zero
if the adjustment is used for a simple scalar value, e.g. in a
`SpinButton`.
<!-- trait AdjustmentExt::fn set_property_page-size -->
The page size of the adjustment.
Note that the page-size is irrelevant and should be set to zero
if the adjustment is used for a simple scalar value, e.g. in a
`SpinButton`.
<!-- trait AdjustmentExt::fn get_property_step-increment -->
The step increment of the adjustment.
<!-- trait AdjustmentExt::fn set_property_step-increment -->
The step increment of the adjustment.
<!-- trait AdjustmentExt::fn get_property_upper -->
The maximum value of the adjustment.
Note that values will be restricted by
`upper - page-size` if the page-size
property is nonzero.
<!-- trait AdjustmentExt::fn set_property_upper -->
The maximum value of the adjustment.
Note that values will be restricted by
`upper - page-size` if the page-size
property is nonzero.
<!-- trait AdjustmentExt::fn get_property_value -->
The value of the adjustment.
<!-- trait AdjustmentExt::fn set_property_value -->
The value of the adjustment.
<!-- enum Align -->
Controls how a widget deals with extra space in a single (x or y)
dimension.

Alignment only matters if the widget receives a “too large” allocation,
for example if you packed the widget with the `Widget:expand`
flag inside a `Box`, then the widget might get extra space. If
you have for example a 16x16 icon inside a 32x32 space, the icon
could be scaled and stretched, it could be centered, or it could be
positioned to one side of the space.

Note that in horizontal context `Align::Start` and `Align::End`
are interpreted relative to text direction.

GTK_ALIGN_BASELINE support for it is optional for containers and widgets, and
it is only supported for vertical alignment. When its not supported by
a child or a container it is treated as `Align::Fill`.
<!-- enum Align::variant Fill -->
stretch to fill all space if possible, center if
 no meaningful way to stretch
<!-- enum Align::variant Start -->
snap to left or top side, leaving space on right
 or bottom
<!-- enum Align::variant End -->
snap to right or bottom side, leaving space on left
 or top
<!-- enum Align::variant Center -->
center natural width of widget inside the
 allocation
<!-- enum Align::variant Baseline -->
align the widget according to the baseline. Since 3.10.
<!-- struct Alignment -->
`[Deprecated since 3.14]` The `Alignment` widget controls the alignment and size of its child widget.
It has four settings: xscale, yscale, xalign, and yalign.

The scale settings are used to specify how much the child widget should
expand to fill the space allocated to the `Alignment`.
The values can range from 0 (meaning the child doesn’t expand at all) to
1 (meaning the child expands to fill all of the available space).

The align settings are used to place the child widget within the available
area. The values range from 0 (top or left) to 1 (bottom or right).
Of course, if the scale settings are both set to 1, the alignment settings
have no effect.

`Alignment` has been deprecated in 3.14 and should not be used in
newly-written code. The desired effect can be achieved by using the
`Widget:halign`, `Widget:valign` and `Widget:margin` properties on the
child widget.

# Implements

[`AlignmentExt`](trait.AlignmentExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait AlignmentExt -->
`[Deprecated since 3.14]` Trait containing all `Alignment` methods.

# Implementors

[`Alignment`](struct.Alignment.html)
<!-- impl Alignment::fn new -->
Creates a new `Alignment`.

# Deprecated since 3.14

Use `Widget` alignment and margin properties
## `xalign`
the horizontal alignment of the child widget, from 0 (left) to 1
 (right).
## `yalign`
the vertical alignment of the child widget, from 0 (top) to 1
 (bottom).
## `xscale`
the amount that the child widget expands horizontally to fill up
 unused space, from 0 to 1.
 A value of 0 indicates that the child widget should never expand.
 A value of 1 indicates that the child widget will expand to fill all of the
 space allocated for the `Alignment`.
## `yscale`
the amount that the child widget expands vertically to fill up
 unused space, from 0 to 1. The values are similar to `xscale`.

# Returns

the new `Alignment`
<!-- trait AlignmentExt::fn get_padding -->
Gets the padding on the different sides of the widget.
See gtk_alignment_set_padding ().

# Deprecated since 3.14

Use `Widget` alignment and margin properties
## `padding_top`
location to store the padding for
 the top of the widget, or `None`
## `padding_bottom`
location to store the padding
 for the bottom of the widget, or `None`
## `padding_left`
location to store the padding
 for the left of the widget, or `None`
## `padding_right`
location to store the padding
 for the right of the widget, or `None`
<!-- trait AlignmentExt::fn set -->
Sets the `Alignment` values.

# Deprecated since 3.14

Use `Widget` alignment and margin properties
## `xalign`
the horizontal alignment of the child widget, from 0 (left) to 1
 (right).
## `yalign`
the vertical alignment of the child widget, from 0 (top) to 1
 (bottom).
## `xscale`
the amount that the child widget expands horizontally to fill up
 unused space, from 0 to 1.
 A value of 0 indicates that the child widget should never expand.
 A value of 1 indicates that the child widget will expand to fill all of the
 space allocated for the `Alignment`.
## `yscale`
the amount that the child widget expands vertically to fill up
 unused space, from 0 to 1. The values are similar to `xscale`.
<!-- trait AlignmentExt::fn set_padding -->
Sets the padding on the different sides of the widget.
The padding adds blank space to the sides of the widget. For instance,
this can be used to indent the child widget towards the right by adding
padding on the left.

# Deprecated since 3.14

Use `Widget` alignment and margin properties
## `padding_top`
the padding at the top of the widget
## `padding_bottom`
the padding at the bottom of the widget
## `padding_left`
the padding at the left of the widget
## `padding_right`
the padding at the right of the widget.
<!-- trait AlignmentExt::fn get_property_bottom-padding -->
The padding to insert at the bottom of the widget.

# Deprecated since 3.14

Use `WidgetExt::set_margin_bottom` instead
<!-- trait AlignmentExt::fn set_property_bottom-padding -->
The padding to insert at the bottom of the widget.

# Deprecated since 3.14

Use `WidgetExt::set_margin_bottom` instead
<!-- trait AlignmentExt::fn get_property_left-padding -->
The padding to insert at the left of the widget.

# Deprecated since 3.14

Use `WidgetExt::set_margin_start` instead
<!-- trait AlignmentExt::fn set_property_left-padding -->
The padding to insert at the left of the widget.

# Deprecated since 3.14

Use `WidgetExt::set_margin_start` instead
<!-- trait AlignmentExt::fn get_property_right-padding -->
The padding to insert at the right of the widget.

# Deprecated since 3.14

Use `WidgetExt::set_margin_end` instead
<!-- trait AlignmentExt::fn set_property_right-padding -->
The padding to insert at the right of the widget.

# Deprecated since 3.14

Use `WidgetExt::set_margin_end` instead
<!-- trait AlignmentExt::fn get_property_top-padding -->
The padding to insert at the top of the widget.

# Deprecated since 3.14

Use `WidgetExt::set_margin_top` instead
<!-- trait AlignmentExt::fn set_property_top-padding -->
The padding to insert at the top of the widget.

# Deprecated since 3.14

Use `WidgetExt::set_margin_top` instead
<!-- trait AlignmentExt::fn get_property_xalign -->
Horizontal position of child in available space. A value of 0.0
will flush the child left (or right, in RTL locales); a value
of 1.0 will flush the child right (or left, in RTL locales).

# Deprecated since 3.14

Use `WidgetExt::set_halign` on the child instead
<!-- trait AlignmentExt::fn set_property_xalign -->
Horizontal position of child in available space. A value of 0.0
will flush the child left (or right, in RTL locales); a value
of 1.0 will flush the child right (or left, in RTL locales).

# Deprecated since 3.14

Use `WidgetExt::set_halign` on the child instead
<!-- trait AlignmentExt::fn get_property_xscale -->
If available horizontal space is bigger than needed, how much
of it to use for the child. A value of 0.0 means none; a value
of 1.0 means all.

# Deprecated since 3.14

Use `WidgetExt::set_hexpand` on the child instead
<!-- trait AlignmentExt::fn set_property_xscale -->
If available horizontal space is bigger than needed, how much
of it to use for the child. A value of 0.0 means none; a value
of 1.0 means all.

# Deprecated since 3.14

Use `WidgetExt::set_hexpand` on the child instead
<!-- trait AlignmentExt::fn get_property_yalign -->
Vertical position of child in available space. A value of 0.0
will flush the child to the top; a value of 1.0 will flush the
child to the bottom.

# Deprecated since 3.14

Use `WidgetExt::set_valign` on the child instead
<!-- trait AlignmentExt::fn set_property_yalign -->
Vertical position of child in available space. A value of 0.0
will flush the child to the top; a value of 1.0 will flush the
child to the bottom.

# Deprecated since 3.14

Use `WidgetExt::set_valign` on the child instead
<!-- trait AlignmentExt::fn get_property_yscale -->
If available vertical space is bigger than needed, how much
of it to use for the child. A value of 0.0 means none; a value
of 1.0 means all.

# Deprecated since 3.14

Use `WidgetExt::set_vexpand` on the child instead
<!-- trait AlignmentExt::fn set_property_yscale -->
If available vertical space is bigger than needed, how much
of it to use for the child. A value of 0.0 means none; a value
of 1.0 means all.

# Deprecated since 3.14

Use `WidgetExt::set_vexpand` on the child instead
<!-- struct AppChooser -->
`AppChooser` is an interface that can be implemented by widgets which
allow the user to choose an application (typically for the purpose of
opening a file). The main objects that implement this interface are
`AppChooserWidget`, `AppChooserDialog` and `AppChooserButton`.

Applications are represented by GIO `gio::AppInfo` objects here.
GIO has a concept of recommended and fallback applications for a
given content type. Recommended applications are those that claim
to handle the content type itself, while fallback also includes
applications that handle a more generic content type. GIO also
knows the default and last-used application for a given content
type. The `AppChooserWidget` provides detailed control over
whether the shown list of applications should include default,
recommended or fallback applications.

To obtain the application that has been selected in a `AppChooser`,
use `AppChooser::get_app_info`.

# Implements

[`AppChooserExt`](trait.AppChooserExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait AppChooserExt -->
Trait containing all `AppChooser` methods.

# Implementors

[`AppChooserDialog`](struct.AppChooserDialog.html), [`AppChooserWidget`](struct.AppChooserWidget.html), [`AppChooser`](struct.AppChooser.html)
<!-- trait AppChooserExt::fn get_app_info -->
Returns the currently selected application.

# Returns

a `gio::AppInfo` for the currently selected
 application, or `None` if none is selected. Free with `gobject::ObjectExt::unref`
<!-- trait AppChooserExt::fn get_content_type -->
Returns the current value of the `AppChooser:content-type` property.

# Returns

the content type of `self`. Free with `g_free`
<!-- trait AppChooserExt::fn refresh -->
Reloads the list of applications.
<!-- trait AppChooserExt::fn get_property_content-type -->
The content type of the `AppChooser` object.

See [GContentType][gio-GContentType]
for more information about content types.
<!-- trait AppChooserExt::fn set_property_content-type -->
The content type of the `AppChooser` object.

See [GContentType][gio-GContentType]
for more information about content types.
<!-- struct AppChooserDialog -->
`AppChooserDialog` shows a `AppChooserWidget` inside a `Dialog`.

Note that `AppChooserDialog` does not have any interesting methods
of its own. Instead, you should get the embedded `AppChooserWidget`
using `AppChooserDialogExt::get_widget` and call its methods if
the generic `AppChooser` interface is not sufficient for your needs.

To set the heading that is shown above the `AppChooserWidget`,
use `AppChooserDialogExt::set_heading`.

# Implements

[`AppChooserDialogExt`](trait.AppChooserDialogExt.html), [`DialogExt`](trait.DialogExt.html), [`GtkWindowExt`](trait.GtkWindowExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`AppChooserExt`](trait.AppChooserExt.html)
<!-- trait AppChooserDialogExt -->
Trait containing all `AppChooserDialog` methods.

# Implementors

[`AppChooserDialog`](struct.AppChooserDialog.html)
<!-- impl AppChooserDialog::fn new -->
Creates a new `AppChooserDialog` for the provided `gio::File`,
to allow the user to select an application for it.
## `parent`
a `Window`, or `None`
## `flags`
flags for this dialog
## `file`
a `gio::File`

# Returns

a newly created `AppChooserDialog`
<!-- impl AppChooserDialog::fn new_for_content_type -->
Creates a new `AppChooserDialog` for the provided content type,
to allow the user to select an application for it.
## `parent`
a `Window`, or `None`
## `flags`
flags for this dialog
## `content_type`
a content type string

# Returns

a newly created `AppChooserDialog`
<!-- trait AppChooserDialogExt::fn get_heading -->
Returns the text to display at the top of the dialog.

# Returns

the text to display at the top of the dialog, or `None`, in which
 case a default text is displayed
<!-- trait AppChooserDialogExt::fn get_widget -->
Returns the `AppChooserWidget` of this dialog.

# Returns

the `AppChooserWidget` of `self`
<!-- trait AppChooserDialogExt::fn set_heading -->
Sets the text to display at the top of the dialog.
If the heading is not set, the dialog displays a default text.
## `heading`
a string containing Pango markup
<!-- trait AppChooserDialogExt::fn get_property_gfile -->
The GFile used by the `AppChooserDialog`.
The dialog's `AppChooserWidget` content type will be guessed from the
file, if present.
<!-- trait AppChooserDialogExt::fn set_property_gfile -->
The GFile used by the `AppChooserDialog`.
The dialog's `AppChooserWidget` content type will be guessed from the
file, if present.
<!-- trait AppChooserDialogExt::fn get_property_heading -->
The text to show at the top of the dialog.
The string may contain Pango markup.
<!-- trait AppChooserDialogExt::fn set_property_heading -->
The text to show at the top of the dialog.
The string may contain Pango markup.
<!-- struct AppChooserWidget -->
`AppChooserWidget` is a widget for selecting applications.
It is the main building block for `AppChooserDialog`. Most
applications only need to use the latter; but you can use
this widget as part of a larger widget if you have special needs.

`AppChooserWidget` offers detailed control over what applications
are shown, using the
`AppChooserWidget:show-default`,
`AppChooserWidget:show-recommended`,
`AppChooserWidget:show-fallback`,
`AppChooserWidget:show-other` and
`AppChooserWidget:show-all`
properties. See the `AppChooser` documentation for more information
about these groups of applications.

To keep track of the selected application, use the
`AppChooserWidget::application-selected` and `AppChooserWidget::application-activated` signals.

# CSS nodes

`AppChooserWidget` has a single CSS node with name appchooser.

# Implements

[`AppChooserWidgetExt`](trait.AppChooserWidgetExt.html), [`BoxExt`](trait.BoxExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`OrientableExt`](trait.OrientableExt.html), [`AppChooserExt`](trait.AppChooserExt.html)
<!-- trait AppChooserWidgetExt -->
Trait containing all `AppChooserWidget` methods.

# Implementors

[`AppChooserWidget`](struct.AppChooserWidget.html)
<!-- impl AppChooserWidget::fn new -->
Creates a new `AppChooserWidget` for applications
that can handle content of the given type.
## `content_type`
the content type to show applications for

# Returns

a newly created `AppChooserWidget`
<!-- trait AppChooserWidgetExt::fn get_default_text -->
Returns the text that is shown if there are not applications
that can handle the content type.

# Returns

the value of `AppChooserWidget:default-text`
<!-- trait AppChooserWidgetExt::fn get_show_all -->
Returns the current value of the `AppChooserWidget:show-all`
property.

# Returns

the value of `AppChooserWidget:show-all`
<!-- trait AppChooserWidgetExt::fn get_show_default -->
Returns the current value of the `AppChooserWidget:show-default`
property.

# Returns

the value of `AppChooserWidget:show-default`
<!-- trait AppChooserWidgetExt::fn get_show_fallback -->
Returns the current value of the `AppChooserWidget:show-fallback`
property.

# Returns

the value of `AppChooserWidget:show-fallback`
<!-- trait AppChooserWidgetExt::fn get_show_other -->
Returns the current value of the `AppChooserWidget:show-other`
property.

# Returns

the value of `AppChooserWidget:show-other`
<!-- trait AppChooserWidgetExt::fn get_show_recommended -->
Returns the current value of the `AppChooserWidget:show-recommended`
property.

# Returns

the value of `AppChooserWidget:show-recommended`
<!-- trait AppChooserWidgetExt::fn set_default_text -->
Sets the text that is shown if there are not applications
that can handle the content type.
## `text`
the new value for `AppChooserWidget:default-text`
<!-- trait AppChooserWidgetExt::fn set_show_all -->
Sets whether the app chooser should show all applications
in a flat list.
## `setting`
the new value for `AppChooserWidget:show-all`
<!-- trait AppChooserWidgetExt::fn set_show_default -->
Sets whether the app chooser should show the default handler
for the content type in a separate section.
## `setting`
the new value for `AppChooserWidget:show-default`
<!-- trait AppChooserWidgetExt::fn set_show_fallback -->
Sets whether the app chooser should show related applications
for the content type in a separate section.
## `setting`
the new value for `AppChooserWidget:show-fallback`
<!-- trait AppChooserWidgetExt::fn set_show_other -->
Sets whether the app chooser should show applications
which are unrelated to the content type.
## `setting`
the new value for `AppChooserWidget:show-other`
<!-- trait AppChooserWidgetExt::fn set_show_recommended -->
Sets whether the app chooser should show recommended applications
for the content type in a separate section.
## `setting`
the new value for `AppChooserWidget:show-recommended`
<!-- trait AppChooserWidgetExt::fn connect_application_activated -->
Emitted when an application item is activated from the widget's list.

This usually happens when the user double clicks an item, or an item
is selected and the user presses one of the keys Space, Shift+Space,
Return or Enter.
## `application`
the activated `gio::AppInfo`
<!-- trait AppChooserWidgetExt::fn connect_application_selected -->
Emitted when an application item is selected from the widget's list.
## `application`
the selected `gio::AppInfo`
<!-- trait AppChooserWidgetExt::fn connect_populate_popup -->
Emitted when a context menu is about to popup over an application item.
Clients can insert menu items into the provided `Menu` object in the
callback of this signal; the context menu will be shown over the item
if at least one item has been added to the menu.
## `menu`
the `Menu` to populate
## `application`
the current `gio::AppInfo`
<!-- trait AppChooserWidgetExt::fn get_property_default-text -->
The `AppChooserWidget:default-text` property determines the text
that appears in the widget when there are no applications for the
given content type.
See also `AppChooserWidgetExt::set_default_text`.
<!-- trait AppChooserWidgetExt::fn set_property_default-text -->
The `AppChooserWidget:default-text` property determines the text
that appears in the widget when there are no applications for the
given content type.
See also `AppChooserWidgetExt::set_default_text`.
<!-- trait AppChooserWidgetExt::fn get_property_show-all -->
If the `AppChooserWidget:show-all` property is `true`, the app
chooser presents all applications in a single list, without
subsections for default, recommended or related applications.
<!-- trait AppChooserWidgetExt::fn set_property_show-all -->
If the `AppChooserWidget:show-all` property is `true`, the app
chooser presents all applications in a single list, without
subsections for default, recommended or related applications.
<!-- trait AppChooserWidgetExt::fn get_property_show-default -->
The ::show-default property determines whether the app chooser
should show the default handler for the content type in a
separate section. If `false`, the default handler is listed
among the recommended applications.
<!-- trait AppChooserWidgetExt::fn set_property_show-default -->
The ::show-default property determines whether the app chooser
should show the default handler for the content type in a
separate section. If `false`, the default handler is listed
among the recommended applications.
<!-- trait AppChooserWidgetExt::fn get_property_show-fallback -->
The `AppChooserWidget:show-fallback` property determines whether
the app chooser should show a section for fallback applications.
If `false`, the fallback applications are listed among the other
applications.
<!-- trait AppChooserWidgetExt::fn set_property_show-fallback -->
The `AppChooserWidget:show-fallback` property determines whether
the app chooser should show a section for fallback applications.
If `false`, the fallback applications are listed among the other
applications.
<!-- trait AppChooserWidgetExt::fn get_property_show-other -->
The `AppChooserWidget:show-other` property determines whether
the app chooser should show a section for other applications.
<!-- trait AppChooserWidgetExt::fn set_property_show-other -->
The `AppChooserWidget:show-other` property determines whether
the app chooser should show a section for other applications.
<!-- trait AppChooserWidgetExt::fn get_property_show-recommended -->
The `AppChooserWidget:show-recommended` property determines
whether the app chooser should show a section for recommended
applications. If `false`, the recommended applications are listed
among the other applications.
<!-- trait AppChooserWidgetExt::fn set_property_show-recommended -->
The `AppChooserWidget:show-recommended` property determines
whether the app chooser should show a section for recommended
applications. If `false`, the recommended applications are listed
among the other applications.
<!-- struct Application -->
`Application` is a class that handles many important aspects
of a GTK+ application in a convenient fashion, without enforcing
a one-size-fits-all application model.

Currently, `Application` handles GTK+ initialization, application
uniqueness, session management, provides some basic scriptability and
desktop shell integration by exporting actions and menus and manages a
list of toplevel windows whose life-cycle is automatically tied to the
life-cycle of your application.

While `Application` works fine with plain ``GtkWindows``, it is recommended
to use it together with `ApplicationWindow`.

When GDK threads are enabled, `Application` will acquire the GDK
lock when invoking actions that arrive from other processes. The GDK
lock is not touched for local action invocations. In order to have
actions invoked in a predictable context it is therefore recommended
that the GDK lock be held while invoking actions locally with
`gio::ActionGroup::activate_action`. The same applies to actions
associated with `ApplicationWindow` and to the “activate” and
“open” `gio::Application` methods.

## Automatic resources ## {`automatic`-resources}

`Application` will automatically load menus from the `Builder`
resource located at "gtk/menus.ui", relative to the application's
resource base path (see `gio::ApplicationExt::set_resource_base_path`). The
menu with the ID "app-menu" is taken as the application's app menu
and the menu with the ID "menubar" is taken as the application's
menubar. Additional menus (most interesting submenus) can be named
and accessed via `GtkApplicationExt::get_menu_by_id` which allows for
dynamic population of a part of the menu structure.

If the resources "gtk/menus-appmenu.ui" or "gtk/menus-traditional.ui" are
present then these files will be used in preference, depending on the value
of `GtkApplicationExt::prefers_app_menu`. If the resource "gtk/menus-common.ui"
is present it will be loaded as well. This is useful for storing items that
are referenced from both "gtk/menus-appmenu.ui" and
"gtk/menus-traditional.ui".

It is also possible to provide the menus manually using
`GtkApplicationExt::set_app_menu` and `GtkApplicationExt::set_menubar`.

`Application` will also automatically setup an icon search path for
the default icon theme by appending "icons" to the resource base
path. This allows your application to easily store its icons as
resources. See `IconThemeExt::add_resource_path` for more
information.

If there is a resource located at "gtk/help-overlay.ui" which
defines a `ShortcutsWindow` with ID "help_overlay" then `Application`
associates an instance of this shortcuts window with each
`ApplicationWindow` and sets up keyboard accelerators (Control-F1
and Control-?) to open it. To create a menu item that displays the
shortcuts window, associate the item with the action win.show-help-overlay.

## A simple application ## {`gtkapplication`}

[A simple example](https://git.gnome.org/browse/gtk+/tree/examples/bp/bloatpad.c)

`Application` optionally registers with a session manager
of the users session (if you set the `Application:register-session`
property) and offers various functionality related to the session
life-cycle.

An application can block various ways to end the session with
the `GtkApplicationExt::inhibit` function. Typical use cases for
this kind of inhibiting are long-running, uninterruptible operations,
such as burning a CD or performing a disk backup. The session
manager may not honor the inhibitor, but it can be expected to
inform the user about the negative consequences of ending the
session while inhibitors are present.

## See Also ## {`seealso`}
[HowDoI: Using `Application`](https://wiki.gnome.org/HowDoI/`Application`),
[Getting Started with GTK+: Basics](https://developer.gnome.org/gtk3/stable/gtk-getting-started.html`id`-1.2.3.3)

# Implements

[`GtkApplicationExt`](trait.GtkApplicationExt.html), [`gio::ApplicationExt`](../gio/trait.ApplicationExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`gio::ActionGroupExt`](../gio/trait.ActionGroupExt.html), [`gio::ActionMapExt`](../gio/trait.ActionMapExt.html)
<!-- trait GtkApplicationExt -->
Trait containing all `Application` methods.

# Implementors

[`Application`](struct.Application.html)
<!-- impl Application::fn new -->
Creates a new `Application` instance.

When using `Application`, it is not necessary to call `gtk_init`
manually. It is called as soon as the application gets registered as
the primary instance.

Concretely, `gtk_init` is called in the default handler for the
`gio::Application::startup` signal. Therefore, `Application` subclasses should
chain up in their `gio::Application::startup` handler before using any GTK+ API.

Note that commandline arguments are not passed to `gtk_init`.
All GTK+ functionality that is available via commandline arguments
can also be achieved by setting suitable environment variables
such as `G_DEBUG`, so this should not be a big
problem. If you absolutely must support GTK+ commandline arguments,
you can explicitly call `gtk_init` before creating the application
instance.

If non-`None`, the application ID must be valid. See
`gio::Application::id_is_valid`.

If no application ID is given then some features (most notably application
uniqueness) will be disabled. A null application ID is only allowed with
GTK+ 3.6 or later.
## `application_id`
The application ID.
## `flags`
the application flags

# Returns

a new `Application` instance
<!-- trait GtkApplicationExt::fn add_accelerator -->
Installs an accelerator that will cause the named action
to be activated when the key combination specificed by `accelerator`
is pressed.

`accelerator` must be a string that can be parsed by `gtk_accelerator_parse`,
e.g. "`<Primary>`q" or “`<Control>``<Alt>`p”.

`action_name` must be the name of an action as it would be used
in the app menu, i.e. actions that have been added to the application
are referred to with an “app.” prefix, and window-specific actions
with a “win.” prefix.

`Application` also extracts accelerators out of “accel” attributes
in the `GMenuModels` passed to `GtkApplicationExt::set_app_menu` and
`GtkApplicationExt::set_menubar`, which is usually more convenient
than calling this function for each accelerator.

# Deprecated since 3.14

Use `GtkApplicationExt::set_accels_for_action` instead
## `accelerator`
accelerator string
## `action_name`
the name of the action to activate
## `parameter`
parameter to pass when activating the action,
 or `None` if the action does not accept an activation parameter
<!-- trait GtkApplicationExt::fn add_window -->
Adds a window to `self`.

This call can only happen after the `self` has started;
typically, you should add new application windows in response
to the emission of the `gio::Application::activate` signal.

This call is equivalent to setting the `Window:application`
property of `window` to `self`.

Normally, the connection between the application and the window
will remain until the window is destroyed, but you can explicitly
remove it with `GtkApplicationExt::remove_window`.

GTK+ will keep the `self` running as long as it has
any windows.
## `window`
a `Window`
<!-- trait GtkApplicationExt::fn get_accels_for_action -->
Gets the accelerators that are currently associated with
the given action.

Feature: `v3_12`

## `detailed_action_name`
a detailed action name, specifying an action
 and target to obtain accelerators for

# Returns

accelerators for `detailed_action_name`, as
 a `None`-terminated array. Free with `g_strfreev` when no longer needed
<!-- trait GtkApplicationExt::fn get_actions_for_accel -->
Returns the list of actions (possibly empty) that `accel` maps to.
Each item in the list is a detailed action name in the usual form.

This might be useful to discover if an accel already exists in
order to prevent installation of a conflicting accelerator (from
an accelerator editor or a plugin system, for example). Note that
having more than one action per accelerator may not be a bad thing
and might make sense in cases where the actions never appear in the
same context.

In case there are no actions for a given accelerator, an empty array
is returned. `None` is never returned.

It is a programmer error to pass an invalid accelerator string.
If you are unsure, check it with `gtk_accelerator_parse` first.

Feature: `v3_14`

## `accel`
an accelerator that can be parsed by `gtk_accelerator_parse`

# Returns

a `None`-terminated array of actions for `accel`
<!-- trait GtkApplicationExt::fn get_active_window -->
Gets the “active” window for the application.

The active window is the one that was most recently focused (within
the application). This window may not have the focus at the moment
if another application has it — this is just the most
recently-focused window within this application.

Feature: `v3_6`


# Returns

the active window, or `None` if
 there isn't one.
<!-- trait GtkApplicationExt::fn get_app_menu -->
Returns the menu model that has been set with
`GtkApplicationExt::set_app_menu`.

# Returns

the application menu of `self`
 or `None` if no application menu has been set.
<!-- trait GtkApplicationExt::fn get_menu_by_id -->
Gets a menu from automatically loaded resources.
See [Automatic resources][automatic-resources]
for more information.

Feature: `v3_14`

## `id`
the id of the menu to look up

# Returns

Gets the menu with the
 given id from the automatically loaded resources
<!-- trait GtkApplicationExt::fn get_menubar -->
Returns the menu model that has been set with
`GtkApplicationExt::set_menubar`.

# Returns

the menubar for windows of `self`
<!-- trait GtkApplicationExt::fn get_window_by_id -->
Returns the `ApplicationWindow` with the given ID.

The ID of a `ApplicationWindow` can be retrieved with
`ApplicationWindowExt::get_id`.

Feature: `v3_6`

## `id`
an identifier number

# Returns

the window with ID `id`, or
 `None` if there is no window with this ID
<!-- trait GtkApplicationExt::fn get_windows -->
Gets a list of the ``GtkWindows`` associated with `self`.

The list is sorted by most recently focused window, such that the first
element is the currently focused window. (Useful for choosing a parent
for a transient window.)

The list that is returned should not be modified in any way. It will
only remain valid until the next focus change or window creation or
deletion.

# Returns

a `glib::List` of `Window`
<!-- trait GtkApplicationExt::fn inhibit -->
Inform the session manager that certain types of actions should be
inhibited. This is not guaranteed to work on all platforms and for
all types of actions.

Applications should invoke this method when they begin an operation
that should not be interrupted, such as creating a CD or DVD. The
types of actions that may be blocked are specified by the `flags`
parameter. When the application completes the operation it should
call `GtkApplicationExt::uninhibit` to remove the inhibitor. Note that
an application can have multiple inhibitors, and all of them must
be individually removed. Inhibitors are also cleared when the
application exits.

Applications should not expect that they will always be able to block
the action. In most cases, users will be given the option to force
the action to take place.

Reasons should be short and to the point.

If `window` is given, the session manager may point the user to
this window to find out more about why the action is inhibited.
## `window`
a `Window`, or `None`
## `flags`
what types of actions should be inhibited
## `reason`
a short, human-readable string that explains
 why these operations are inhibited

# Returns

A non-zero cookie that is used to uniquely identify this
 request. It should be used as an argument to `GtkApplicationExt::uninhibit`
 in order to remove the request. If the platform does not support
 inhibiting or the request failed for some reason, 0 is returned.
<!-- trait GtkApplicationExt::fn is_inhibited -->
Determines if any of the actions specified in `flags` are
currently inhibited (possibly by another application).
## `flags`
what types of actions should be queried

# Returns

`true` if any of the actions specified in `flags` are inhibited
<!-- trait GtkApplicationExt::fn list_action_descriptions -->
Lists the detailed action names which have associated accelerators.
See `GtkApplicationExt::set_accels_for_action`.

Feature: `v3_12`


# Returns

a `None`-terminated array of strings,
 free with `g_strfreev` when done
<!-- trait GtkApplicationExt::fn prefers_app_menu -->
Determines if the desktop environment in which the application is
running would prefer an application menu be shown.

If this function returns `true` then the application should call
`GtkApplicationExt::set_app_menu` with the contents of an application
menu, which will be shown by the desktop environment. If it returns
`false` then you should consider using an alternate approach, such as
a menubar.

The value returned by this function is purely advisory and you are
free to ignore it. If you call `GtkApplicationExt::set_app_menu` even
if the desktop environment doesn't support app menus, then a fallback
will be provided.

Applications are similarly free not to set an app menu even if the
desktop environment wants to show one. In that case, a fallback will
also be created by the desktop environment (GNOME, for example, uses
a menu with only a "Quit" item in it).

The value returned by this function never changes. Once it returns a
particular value, it is guaranteed to always return the same value.

You may only call this function after the application has been
registered and after the base startup handler has run. You're most
likely to want to use this from your own startup handler. It may
also make sense to consult this function while constructing UI (in
activate, open or an action activation handler) in order to determine
if you should show a gear menu or not.

This function will return `false` on Mac OS and a default app menu
will be created automatically with the "usual" contents of that menu
typical to most Mac OS applications. If you call
`GtkApplicationExt::set_app_menu` anyway, then this menu will be
replaced with your own.

Feature: `v3_14`


# Returns

`true` if you should set an app menu
<!-- trait GtkApplicationExt::fn remove_accelerator -->
Removes an accelerator that has been previously added
with `GtkApplicationExt::add_accelerator`.

# Deprecated since 3.14

Use `GtkApplicationExt::set_accels_for_action` instead
## `action_name`
the name of the action to activate
## `parameter`
parameter to pass when activating the action,
 or `None` if the action does not accept an activation parameter
<!-- trait GtkApplicationExt::fn remove_window -->
Remove a window from `self`.

If `window` belongs to `self` then this call is equivalent to
setting the `Window:application` property of `window` to
`None`.

The application may stop running as a result of a call to this
function.
## `window`
a `Window`
<!-- trait GtkApplicationExt::fn set_accels_for_action -->
Sets zero or more keyboard accelerators that will trigger the
given action. The first item in `accels` will be the primary
accelerator, which may be displayed in the UI.

To remove all accelerators for an action, use an empty, zero-terminated
array for `accels`.

For the `detailed_action_name`, see `gio::Action::parse_detailed_name` and
`gio::Action::print_detailed_name`.

Feature: `v3_12`

## `detailed_action_name`
a detailed action name, specifying an action
 and target to associate accelerators with
## `accels`
a list of accelerators in the format
 understood by `gtk_accelerator_parse`
<!-- trait GtkApplicationExt::fn set_app_menu -->
Sets or unsets the application menu for `self`.

This can only be done in the primary instance of the application,
after it has been registered. `gio::Application::startup` is a good place
to call this.

The application menu is a single menu containing items that typically
impact the application as a whole, rather than acting on a specific
window or document. For example, you would expect to see
“Preferences” or “Quit” in an application menu, but not “Save” or
“Print”.

If supported, the application menu will be rendered by the desktop
environment.

Use the base `gio::ActionMap` interface to add actions, to respond to the user
selecting these menu items.
## `app_menu`
a `gio::MenuModel`, or `None`
<!-- trait GtkApplicationExt::fn set_menubar -->
Sets or unsets the menubar for windows of `self`.

This is a menubar in the traditional sense.

This can only be done in the primary instance of the application,
after it has been registered. `gio::Application::startup` is a good place
to call this.

Depending on the desktop environment, this may appear at the top of
each window, or at the top of the screen. In some environments, if
both the application menu and the menubar are set, the application
menu will be presented as if it were the first item of the menubar.
Other environments treat the two as completely separate — for example,
the application menu may be rendered by the desktop shell while the
menubar (if set) remains in each individual window.

Use the base `gio::ActionMap` interface to add actions, to respond to the
user selecting these menu items.
## `menubar`
a `gio::MenuModel`, or `None`
<!-- trait GtkApplicationExt::fn uninhibit -->
Removes an inhibitor that has been established with `GtkApplicationExt::inhibit`.
Inhibitors are also cleared when the application exits.
## `cookie`
a cookie that was returned by `GtkApplicationExt::inhibit`
<!-- trait GtkApplicationExt::fn connect_window_added -->
Emitted when a `Window` is added to `application` through
`GtkApplicationExt::add_window`.
## `window`
the newly-added `Window`
<!-- trait GtkApplicationExt::fn connect_window_removed -->
Emitted when a `Window` is removed from `application`,
either as a side-effect of being destroyed or explicitly
through `GtkApplicationExt::remove_window`.
## `window`
the `Window` that is being removed
<!-- trait GtkApplicationExt::fn get_property_register-session -->
Set this property to `true` to register with the session manager.
<!-- trait GtkApplicationExt::fn set_property_register-session -->
Set this property to `true` to register with the session manager.
<!-- struct ApplicationWindow -->
`ApplicationWindow` is a `Window` subclass that offers some
extra functionality for better integration with `Application`
features. Notably, it can handle both the application menu as well
as the menubar. See `GtkApplicationExt::set_app_menu` and
`GtkApplicationExt::set_menubar`.

This class implements the `gio::ActionGroup` and `gio::ActionMap` interfaces,
to let you add window-specific actions that will be exported by the
associated `Application`, together with its application-wide
actions. Window-specific actions are prefixed with the “win.”
prefix and application-wide actions are prefixed with the “app.”
prefix. Actions must be addressed with the prefixed name when
referring to them from a `gio::MenuModel`.

Note that widgets that are placed inside a `ApplicationWindow`
can also activate these actions, if they implement the
`Actionable` interface.

As with `Application`, the GDK lock will be acquired when
processing actions arriving from other processes and should therefore
be held when activating actions locally (if GDK threads are enabled).

The settings `Settings:gtk-shell-shows-app-menu` and
`Settings:gtk-shell-shows-menubar` tell GTK+ whether the
desktop environment is showing the application menu and menubar
models outside the application as part of the desktop shell.
For instance, on OS X, both menus will be displayed remotely;
on Windows neither will be. gnome-shell (starting with version 3.4)
will display the application menu, but not the menubar.

If the desktop environment does not display the menubar, then
`ApplicationWindow` will automatically show a `MenuBar` for it.
This behaviour can be overridden with the `ApplicationWindow:show-menubar`
property. If the desktop environment does not display the application
menu, then it will automatically be included in the menubar or in the
windows client-side decorations.

## A `ApplicationWindow` with a menubar


```C
app = gtk_application_new ();

builder = gtk_builder_new_from_string (
    "<interface>"
    "  <menu id='menubar'>"
    "    <submenu label='_Edit'>"
    "      <item label='_Copy' action='win.copy'/>"
    "      <item label='_Paste' action='win.paste'/>"
    "    </submenu>"
    "  </menu>"
    "</interface>",
    -1);

menubar = G_MENU_MODEL (gtk_builder_get_object (builder,
                                                "menubar"));
gtk_application_set_menubar (G_APPLICATION (app), menubar);
g_object_unref (builder);

...

window = gtk_application_window_new (app);
```

## Handling fallback yourself

[A simple example](https://git.gnome.org/browse/gtk+/tree/examples/sunny.c)

The XML format understood by `Builder` for `gio::MenuModel` consists
of a toplevel `<menu>` element, which contains one or more `<item>`
elements. Each `<item>` element contains `<attribute>` and `<link>`
elements with a mandatory name attribute. `<link>` elements have the
same content model as `<menu>`. Instead of `<link name="submenu>` or
`<link name="section">`, you can use `<submenu>` or `<section>`
elements.

Attribute values can be translated using gettext, like other `Builder`
content. `<attribute>` elements can be marked for translation with a
`translatable="yes"` attribute. It is also possible to specify message
context and translator comments, using the context and comments attributes.
To make use of this, the `Builder` must have been given the gettext
domain to use.

The following attributes are used when constructing menu items:
- "label": a user-visible string to display
- "action": the prefixed name of the action to trigger
- "target": the parameter to use when activating the action
- "icon" and "verb-icon": names of icons that may be displayed
- "submenu-action": name of an action that may be used to determine
 if a submenu can be opened
- "hidden-when": a string used to determine when the item will be hidden.
 Possible values include "action-disabled", "action-missing", "macos-menubar".

The following attributes are used when constructing sections:
- "label": a user-visible string to use as section heading
- "display-hint": a string used to determine special formatting for the section.
 Possible values include "horizontal-buttons".
- "text-direction": a string used to determine the `TextDirection` to use
 when "display-hint" is set to "horizontal-buttons". Possible values
 include "rtl", "ltr", and "none".

The following attributes are used when constructing submenus:
- "label": a user-visible string to display
- "icon": icon name to display

# Implements

[`ApplicationWindowExt`](trait.ApplicationWindowExt.html), [`GtkWindowExt`](trait.GtkWindowExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`gio::ActionGroupExt`](../gio/trait.ActionGroupExt.html), [`gio::ActionMapExt`](../gio/trait.ActionMapExt.html)
<!-- trait ApplicationWindowExt -->
Trait containing all `ApplicationWindow` methods.

# Implementors

[`ApplicationWindow`](struct.ApplicationWindow.html)
<!-- impl ApplicationWindow::fn new -->
Creates a new `ApplicationWindow`.
## `application`
a `Application`

# Returns

a newly created `ApplicationWindow`
<!-- trait ApplicationWindowExt::fn get_help_overlay -->
Gets the `ShortcutsWindow` that has been set up with
a prior call to `ApplicationWindowExt::set_help_overlay`.

Feature: `v3_20`


# Returns

the help overlay associated with `self`, or `None`
<!-- trait ApplicationWindowExt::fn get_id -->
Returns the unique ID of the window. If the window has not yet been added to
a `Application`, returns `0`.

Feature: `v3_6`


# Returns

the unique ID for `self`, or `0` if the window
 has not yet been added to a `Application`
<!-- trait ApplicationWindowExt::fn get_show_menubar -->
Returns whether the window will display a menubar for the app menu
and menubar as needed.

# Returns

`true` if `self` will display a menubar when needed
<!-- trait ApplicationWindowExt::fn set_help_overlay -->
Associates a shortcuts window with the application window, and
sets up an action with the name win.show-help-overlay to present
it.

`self` takes resposibility for destroying `help_overlay`.

Feature: `v3_20`

## `help_overlay`
a `ShortcutsWindow`
<!-- trait ApplicationWindowExt::fn set_show_menubar -->
Sets whether the window will display a menubar for the app menu
and menubar as needed.
## `show_menubar`
whether to show a menubar when needed
<!-- trait ApplicationWindowExt::fn get_property_show-menubar -->
If this property is `true`, the window will display a menubar
that includes the app menu and menubar, unless these are
shown by the desktop shell. See `GtkApplicationExt::set_app_menu`
and `GtkApplicationExt::set_menubar`.

If `false`, the window will not display a menubar, regardless
of whether the desktop shell is showing the menus or not.
<!-- trait ApplicationWindowExt::fn set_property_show-menubar -->
If this property is `true`, the window will display a menubar
that includes the app menu and menubar, unless these are
shown by the desktop shell. See `GtkApplicationExt::set_app_menu`
and `GtkApplicationExt::set_menubar`.

If `false`, the window will not display a menubar, regardless
of whether the desktop shell is showing the menus or not.
<!-- struct Arrow -->
`[Deprecated since 3.14]` `Arrow` should be used to draw simple arrows that need to point in
one of the four cardinal directions (up, down, left, or right). The
style of the arrow can be one of shadow in, shadow out, etched in, or
etched out. Note that these directions and style types may be
amended in versions of GTK+ to come.

`Arrow` will fill any space alloted to it, but since it is inherited
from `Misc`, it can be padded and/or aligned, to fill exactly the
space the programmer desires.

Arrows are created with a call to `Arrow::new`. The direction or
style of an arrow can be changed after creation by using `ArrowExt::set`.

`Arrow` has been deprecated; you can simply use a `Image` with a
suitable icon name, such as “pan-down-symbolic“. When replacing
`Arrow` by an image, pay attention to the fact that `Arrow` is
doing automatic flipping between `ArrowType::Left` and `ArrowType::Right`,
depending on the text direction. To get the same effect with an image,
use the icon names “pan-start-symbolic“ and “pan-end-symbolic“, which
react to the text direction.

# Implements

[`ArrowExt`](trait.ArrowExt.html), [`MiscExt`](trait.MiscExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait ArrowExt -->
`[Deprecated since 3.14]` Trait containing all `Arrow` methods.

# Implementors

[`Arrow`](struct.Arrow.html)
<!-- impl Arrow::fn new -->
Creates a new `Arrow` widget.

# Deprecated since 3.14

Use a `Image` with a suitable icon.
## `arrow_type`
a valid `ArrowType`.
## `shadow_type`
a valid `ShadowType`.

# Returns

the new `Arrow` widget.
<!-- trait ArrowExt::fn set -->
Sets the direction and style of the `Arrow`, `self`.

# Deprecated since 3.14

Use a `Image` with a suitable icon.
## `arrow_type`
a valid `ArrowType`.
## `shadow_type`
a valid `ShadowType`.
<!-- enum ArrowType -->
Used to indicate the direction in which an arrow should point.
<!-- enum ArrowType::variant Up -->
Represents an upward pointing arrow.
<!-- enum ArrowType::variant Down -->
Represents a downward pointing arrow.
<!-- enum ArrowType::variant Left -->
Represents a left pointing arrow.
<!-- enum ArrowType::variant Right -->
Represents a right pointing arrow.
<!-- enum ArrowType::variant None -->
No arrow. Since 2.10.
<!-- struct AspectFrame -->
The `AspectFrame` is useful when you want
pack a widget so that it can resize but always retains
the same aspect ratio. For instance, one might be
drawing a small preview of a larger image. `AspectFrame`
derives from `Frame`, so it can draw a label and
a frame around the child. The frame will be
“shrink-wrapped” to the size of the child.

# CSS nodes

`AspectFrame` uses a CSS node with name frame.

# Implements

[`AspectFrameExt`](trait.AspectFrameExt.html), [`FrameExt`](trait.FrameExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait AspectFrameExt -->
Trait containing all `AspectFrame` methods.

# Implementors

[`AspectFrame`](struct.AspectFrame.html)
<!-- impl AspectFrame::fn new -->
Create a new `AspectFrame`.
## `label`
Label text.
## `xalign`
Horizontal alignment of the child within the allocation of
 the `AspectFrame`. This ranges from 0.0 (left aligned)
 to 1.0 (right aligned)
## `yalign`
Vertical alignment of the child within the allocation of
 the `AspectFrame`. This ranges from 0.0 (top aligned)
 to 1.0 (bottom aligned)
## `ratio`
The desired aspect ratio.
## `obey_child`
If `true`, `ratio` is ignored, and the aspect
 ratio is taken from the requistion of the child.

# Returns

the new `AspectFrame`.
<!-- trait AspectFrameExt::fn set -->
Set parameters for an existing `AspectFrame`.
## `xalign`
Horizontal alignment of the child within the allocation of
 the `AspectFrame`. This ranges from 0.0 (left aligned)
 to 1.0 (right aligned)
## `yalign`
Vertical alignment of the child within the allocation of
 the `AspectFrame`. This ranges from 0.0 (top aligned)
 to 1.0 (bottom aligned)
## `ratio`
The desired aspect ratio.
## `obey_child`
If `true`, `ratio` is ignored, and the aspect
 ratio is taken from the requistion of the child.
<!-- struct Assistant -->
A `Assistant` is a widget used to represent a generally complex
operation splitted in several steps, guiding the user through its
pages and controlling the page flow to collect the necessary data.

The design of `Assistant` is that it controls what buttons to show
and to make sensitive, based on what it knows about the page sequence
and the [type][`AssistantPageType`] of each page,
in addition to state information like the page
[completion][gtk-assistant-set-page-complete]
and [committed][gtk-assistant-commit] status.

If you have a case that doesn’t quite fit in ``GtkAssistants`` way of
handling buttons, you can use the `AssistantPageType::Custom` page
type and handle buttons yourself.

# `Assistant` as `Buildable`

The `Assistant` implementation of the `Buildable` interface
exposes the `action_area` as internal children with the name
“action_area”.

To add pages to an assistant in `Builder`, simply add it as a
child to the `Assistant` object, and set its child properties
as necessary.

# CSS nodes

`Assistant` has a single CSS node with the name assistant.

# Implements

[`AssistantExt`](trait.AssistantExt.html), [`GtkWindowExt`](trait.GtkWindowExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait AssistantExt -->
Trait containing all `Assistant` methods.

# Implementors

[`Assistant`](struct.Assistant.html)
<!-- impl Assistant::fn new -->
Creates a new `Assistant`.

# Returns

a newly created `Assistant`
<!-- trait AssistantExt::fn add_action_widget -->
Adds a widget to the action area of a `Assistant`.
## `child`
a `Widget`
<!-- trait AssistantExt::fn append_page -->
Appends a page to the `self`.
## `page`
a `Widget`

# Returns

the index (starting at 0) of the inserted page
<!-- trait AssistantExt::fn commit -->
Erases the visited page history so the back button is not
shown on the current page, and removes the cancel button
from subsequent pages.

Use this when the information provided up to the current
page is hereafter deemed permanent and cannot be modified
or undone. For example, showing a progress page to track
a long-running, unreversible operation after the user has
clicked apply on a confirmation page.
<!-- trait AssistantExt::fn get_current_page -->
Returns the page number of the current page.

# Returns

The index (starting from 0) of the current
 page in the `self`, or -1 if the `self` has no pages,
 or no current page.
<!-- trait AssistantExt::fn get_n_pages -->
Returns the number of pages in the `self`

# Returns

the number of pages in the `self`
<!-- trait AssistantExt::fn get_nth_page -->
Returns the child widget contained in page number `page_num`.
## `page_num`
the index of a page in the `self`,
 or -1 to get the last page

# Returns

the child widget, or `None`
 if `page_num` is out of bounds
<!-- trait AssistantExt::fn get_page_complete -->
Gets whether `page` is complete.
## `page`
a page of `self`

# Returns

`true` if `page` is complete.
<!-- trait AssistantExt::fn get_page_has_padding -->
Gets whether page has padding.

Feature: `v3_18`

## `page`
a page of `self`

# Returns

`true` if `page` has padding
<!-- trait AssistantExt::fn get_page_header_image -->
Gets the header image for `page`.

# Deprecated since 3.2

Since GTK+ 3.2, a header is no longer shown;
 add your header decoration to the page content instead.
## `page`
a page of `self`

# Returns

the header image for `page`,
 or `None` if there’s no header image for the page
<!-- trait AssistantExt::fn get_page_side_image -->
Gets the side image for `page`.

# Deprecated since 3.2

Since GTK+ 3.2, sidebar images are not
 shown anymore.
## `page`
a page of `self`

# Returns

the side image for `page`,
 or `None` if there’s no side image for the page
<!-- trait AssistantExt::fn get_page_title -->
Gets the title for `page`.
## `page`
a page of `self`

# Returns

the title for `page`
<!-- trait AssistantExt::fn get_page_type -->
Gets the page type of `page`.
## `page`
a page of `self`

# Returns

the page type of `page`
<!-- trait AssistantExt::fn insert_page -->
Inserts a page in the `self` at a given position.
## `page`
a `Widget`
## `position`
the index (starting at 0) at which to insert the page,
 or -1 to append the page to the `self`

# Returns

the index (starting from 0) of the inserted page
<!-- trait AssistantExt::fn next_page -->
Navigate to the next page.

It is a programming error to call this function when
there is no next page.

This function is for use when creating pages of the
`AssistantPageType::Custom` type.
<!-- trait AssistantExt::fn prepend_page -->
Prepends a page to the `self`.
## `page`
a `Widget`

# Returns

the index (starting at 0) of the inserted page
<!-- trait AssistantExt::fn previous_page -->
Navigate to the previous visited page.

It is a programming error to call this function when
no previous page is available.

This function is for use when creating pages of the
`AssistantPageType::Custom` type.
<!-- trait AssistantExt::fn remove_action_widget -->
Removes a widget from the action area of a `Assistant`.
## `child`
a `Widget`
<!-- trait AssistantExt::fn remove_page -->
Removes the `page_num`’s page from `self`.
## `page_num`
the index of a page in the `self`,
 or -1 to remove the last page
<!-- trait AssistantExt::fn set_current_page -->
Switches the page to `page_num`.

Note that this will only be necessary in custom buttons,
as the `self` flow can be set with
`AssistantExt::set_forward_page_func`.
## `page_num`
index of the page to switch to, starting from 0.
 If negative, the last page will be used. If greater
 than the number of pages in the `self`, nothing
 will be done.
<!-- trait AssistantExt::fn set_forward_page_func -->
Sets the page forwarding function to be `page_func`.

This function will be used to determine what will be
the next page when the user presses the forward button.
Setting `page_func` to `None` will make the assistant to
use the default forward function, which just goes to the
next visible page.
## `page_func`
the ``GtkAssistantPageFunc``, or `None`
 to use the default one
## `data`
user data for `page_func`
## `destroy`
destroy notifier for `data`
<!-- trait AssistantExt::fn set_page_complete -->
Sets whether `page` contents are complete.

This will make `self` update the buttons state
to be able to continue the task.
## `page`
a page of `self`
## `complete`
the completeness status of the page
<!-- trait AssistantExt::fn set_page_has_padding -->
Sets whether the assistant is adding padding around
the page.

Feature: `v3_18`

## `page`
a page of `self`
## `has_padding`
whether this page has padding
<!-- trait AssistantExt::fn set_page_header_image -->
Sets a header image for `page`.

# Deprecated since 3.2

Since GTK+ 3.2, a header is no longer shown;
 add your header decoration to the page content instead.
## `page`
a page of `self`
## `pixbuf`
the new header image `page`
<!-- trait AssistantExt::fn set_page_side_image -->
Sets a side image for `page`.

This image used to be displayed in the side area of the assistant
when `page` is the current page.

# Deprecated since 3.2

Since GTK+ 3.2, sidebar images are not
 shown anymore.
## `page`
a page of `self`
## `pixbuf`
the new side image `page`
<!-- trait AssistantExt::fn set_page_title -->
Sets a title for `page`.

The title is displayed in the header area of the assistant
when `page` is the current page.
## `page`
a page of `self`
## `title`
the new title for `page`
<!-- trait AssistantExt::fn set_page_type -->
Sets the page type for `page`.

The page type determines the page behavior in the `self`.
## `page`
a page of `self`
## `type_`
the new type for `page`
<!-- trait AssistantExt::fn update_buttons_state -->
Forces `self` to recompute the buttons state.

GTK+ automatically takes care of this in most situations,
e.g. when the user goes to a different page, or when the
visibility or completeness of a page changes.

One situation where it can be necessary to call this
function is when changing a value on the current page
affects the future page flow of the assistant.
<!-- trait AssistantExt::fn connect_apply -->
The ::apply signal is emitted when the apply button is clicked.

The default behavior of the `Assistant` is to switch to the page
after the current page, unless the current page is the last one.

A handler for the ::apply signal should carry out the actions for
which the wizard has collected data. If the action takes a long time
to complete, you might consider putting a page of type
`AssistantPageType::Progress` after the confirmation page and handle
this operation within the `Assistant::prepare` signal of the progress
page.
<!-- trait AssistantExt::fn connect_cancel -->
The ::cancel signal is emitted when then the cancel button is clicked.
<!-- trait AssistantExt::fn connect_close -->
The ::close signal is emitted either when the close button of
a summary page is clicked, or when the apply button in the last
page in the flow (of type `AssistantPageType::Confirm`) is clicked.
<!-- trait AssistantExt::fn connect_prepare -->
The ::prepare signal is emitted when a new page is set as the
assistant's current page, before making the new page visible.

A handler for this signal can do any preparations which are
necessary before showing `page`.
## `page`
the current page
<!-- trait AssistantExt::fn get_property_use-header-bar -->
`true` if the assistant uses a `HeaderBar` for action buttons
instead of the action-area.

For technical reasons, this property is declared as an integer
property, but you should only set it to `true` or `false`.

Feature: `v3_12`

<!-- trait AssistantExt::fn set_property_use-header-bar -->
`true` if the assistant uses a `HeaderBar` for action buttons
instead of the action-area.

For technical reasons, this property is declared as an integer
property, but you should only set it to `true` or `false`.

Feature: `v3_12`

<!-- enum AssistantPageType -->
An enum for determining the page role inside the `Assistant`. It's
used to handle buttons sensitivity and visibility.

Note that an assistant needs to end its page flow with a page of type
`AssistantPageType::Confirm`, `AssistantPageType::Summary` or
`AssistantPageType::Progress` to be correct.

The Cancel button will only be shown if the page isn’t “committed”.
See `AssistantExt::commit` for details.
<!-- enum AssistantPageType::variant Content -->
The page has regular contents. Both the
 Back and forward buttons will be shown.
<!-- enum AssistantPageType::variant Intro -->
The page contains an introduction to the
 assistant task. Only the Forward button will be shown if there is a
 next page.
<!-- enum AssistantPageType::variant Confirm -->
The page lets the user confirm or deny the
 changes. The Back and Apply buttons will be shown.
<!-- enum AssistantPageType::variant Summary -->
The page informs the user of the changes
 done. Only the Close button will be shown.
<!-- enum AssistantPageType::variant Progress -->
Used for tasks that take a long time to
 complete, blocks the assistant until the page is marked as complete.
 Only the back button will be shown.
<!-- enum AssistantPageType::variant Custom -->
Used for when other page types are not
 appropriate. No buttons will be shown, and the application must
 add its own buttons through `AssistantExt::add_action_widget`.
<!-- enum BaselinePosition -->
Whenever a container has some form of natural row it may align
children in that row along a common typographical baseline. If
the amount of verical space in the row is taller than the total
requested height of the baseline-aligned children then it can use a
`BaselinePosition` to select where to put the baseline inside the
extra availible space.
<!-- enum BaselinePosition::variant Top -->
Align the baseline at the top
<!-- enum BaselinePosition::variant Center -->
Center the baseline
<!-- enum BaselinePosition::variant Bottom -->
Align the baseline at the bottom

Feature: `v3_10`

<!-- struct Bin -->
The `Bin` widget is a container with just one child.
It is not very useful itself, but it is useful for deriving subclasses,
since it provides common code needed for handling a single child widget.

Many GTK+ widgets are subclasses of `Bin`, including `Window`,
`Button`, `Frame`, `HandleBox` or `ScrolledWindow`.

# Implements

[`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait BinExt -->
Trait containing all `Bin` methods.

# Implementors

[`ActionBar`](struct.ActionBar.html), [`Alignment`](struct.Alignment.html), [`Bin`](struct.Bin.html), [`Button`](struct.Button.html), [`ComboBox`](struct.ComboBox.html), [`EventBox`](struct.EventBox.html), [`Expander`](struct.Expander.html), [`FlowBoxChild`](struct.FlowBoxChild.html), [`Frame`](struct.Frame.html), [`ListBoxRow`](struct.ListBoxRow.html), [`MenuItem`](struct.MenuItem.html), [`Overlay`](struct.Overlay.html), [`Popover`](struct.Popover.html), [`Revealer`](struct.Revealer.html), [`ScrolledWindow`](struct.ScrolledWindow.html), [`SearchBar`](struct.SearchBar.html), [`StackSidebar`](struct.StackSidebar.html), [`ToolItem`](struct.ToolItem.html), [`Viewport`](struct.Viewport.html), [`Window`](struct.Window.html)
<!-- trait BinExt::fn get_child -->
Gets the child of the `Bin`, or `None` if the bin contains
no child widget. The returned widget does not have a reference
added, so you do not need to unref it.

# Returns

the child of `self`, or `None` if it does
not have a child.
<!-- struct Box -->
The `Box` widget organizes child widgets into a rectangular area.

The rectangular area of a `Box` is organized into either a single row
or a single column of child widgets depending upon the orientation.
Thus, all children of a `Box` are allocated one dimension in common,
which is the height of a row, or the width of a column.

`Box` uses a notion of packing. Packing refers
to adding widgets with reference to a particular position in a
`Container`. For a `Box`, there are two reference positions: the
start and the end of the box.
For a vertical `Box`, the start is defined as the top of the box and
the end is defined as the bottom. For a horizontal `Box` the start
is defined as the left side and the end is defined as the right side.

Use repeated calls to `BoxExt::pack_start` to pack widgets into a
`Box` from start to end. Use `BoxExt::pack_end` to add widgets from
end to start. You may intersperse these calls and add widgets from
both ends of the same `Box`.

Because `Box` is a `Container`, you may also use `ContainerExt::add`
to insert widgets into the box, and they will be packed with the default
values for expand and fill child properties. Use `ContainerExt::remove`
to remove widgets from the `Box`.

Use `BoxExt::set_homogeneous` to specify whether or not all children
of the `Box` are forced to get the same amount of space.

Use `BoxExt::set_spacing` to determine how much space will be
minimally placed between all children in the `Box`. Note that
spacing is added between the children, while
padding added by `BoxExt::pack_start` or `BoxExt::pack_end` is added
on either side of the widget it belongs to.

Use `BoxExt::reorder_child` to move a `Box` child to a different
place in the box.

Use `BoxExt::set_child_packing` to reset the expand,
fill and padding child properties.
Use `BoxExt::query_child_packing` to query these fields.

Note that a single-row or single-column `Grid` provides exactly
the same functionality as `Box`.

# CSS nodes

`Box` uses a single CSS node with name box.

In horizontal orientation, the nodes of the children are always arranged
from left to right. So :first-child will always select the leftmost child,
regardless of text direction.

# Implements

[`BoxExt`](trait.BoxExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`OrientableExt`](trait.OrientableExt.html)
<!-- trait BoxExt -->
Trait containing all `Box` methods.

# Implementors

[`AppChooserWidget`](struct.AppChooserWidget.html), [`Box`](struct.Box.html), [`ButtonBox`](struct.ButtonBox.html), [`ColorChooserWidget`](struct.ColorChooserWidget.html), [`FileChooserButton`](struct.FileChooserButton.html), [`FileChooserWidget`](struct.FileChooserWidget.html), [`FontChooserWidget`](struct.FontChooserWidget.html), [`InfoBar`](struct.InfoBar.html), [`RecentChooserWidget`](struct.RecentChooserWidget.html), [`StackSwitcher`](struct.StackSwitcher.html), [`Statusbar`](struct.Statusbar.html)
<!-- impl Box::fn new -->
Creates a new `Box`.
## `orientation`
the box’s orientation.
## `spacing`
the number of pixels to place by default between children.

# Returns

a new `Box`.
<!-- trait BoxExt::fn get_baseline_position -->
Gets the value set by `BoxExt::set_baseline_position`.

Feature: `v3_10`


# Returns

the baseline position
<!-- trait BoxExt::fn get_center_widget -->
Retrieves the center widget of the box.

Feature: `v3_12`


# Returns

the center widget
 or `None` in case no center widget is set.
<!-- trait BoxExt::fn get_homogeneous -->
Returns whether the box is homogeneous (all children are the
same size). See `BoxExt::set_homogeneous`.

# Returns

`true` if the box is homogeneous.
<!-- trait BoxExt::fn get_spacing -->
Gets the value set by `BoxExt::set_spacing`.

# Returns

spacing between children
<!-- trait BoxExt::fn pack_end -->
Adds `child` to `self`, packed with reference to the end of `self`.
The `child` is packed after (away from end of) any other child
packed with reference to the end of `self`.
## `child`
the `Widget` to be added to `self`
## `expand`
`true` if the new child is to be given extra space allocated
 to `self`. The extra space will be divided evenly between all children
 of `self` that use this option
## `fill`
`true` if space given to `child` by the `expand` option is
 actually allocated to `child`, rather than just padding it. This
 parameter has no effect if `expand` is set to `false`. A child is
 always allocated the full height of a horizontal `Box` and the full width
 of a vertical `Box`. This option affects the other dimension
## `padding`
extra space in pixels to put between this child and its
 neighbors, over and above the global amount specified by
 `Box:spacing` property. If `child` is a widget at one of the
 reference ends of `self`, then `padding` pixels are also put between
 `child` and the reference edge of `self`
<!-- trait BoxExt::fn pack_start -->
Adds `child` to `self`, packed with reference to the start of `self`.
The `child` is packed after any other child packed with reference
to the start of `self`.
## `child`
the `Widget` to be added to `self`
## `expand`
`true` if the new child is to be given extra space allocated
 to `self`. The extra space will be divided evenly between all children
 that use this option
## `fill`
`true` if space given to `child` by the `expand` option is
 actually allocated to `child`, rather than just padding it. This
 parameter has no effect if `expand` is set to `false`. A child is
 always allocated the full height of a horizontal `Box` and the full width
 of a vertical `Box`. This option affects the other dimension
## `padding`
extra space in pixels to put between this child and its
 neighbors, over and above the global amount specified by
 `Box:spacing` property. If `child` is a widget at one of the
 reference ends of `self`, then `padding` pixels are also put between
 `child` and the reference edge of `self`
<!-- trait BoxExt::fn query_child_packing -->
Obtains information about how `child` is packed into `self`.
## `child`
the `Widget` of the child to query
## `expand`
pointer to return location for expand child
 property
## `fill`
pointer to return location for fill child
 property
## `padding`
pointer to return location for padding
 child property
## `pack_type`
pointer to return location for pack-type
 child property
<!-- trait BoxExt::fn reorder_child -->
Moves `child` to a new `position` in the list of `self` children.
The list contains widgets packed `PackType::Start`
as well as widgets packed `PackType::End`, in the order that these
widgets were added to `self`.

A widget’s position in the `self` children list determines where
the widget is packed into `self`. A child widget at some position
in the list will be packed just after all other widgets of the
same packing type that appear earlier in the list.
## `child`
the `Widget` to move
## `position`
the new position for `child` in the list of children
 of `self`, starting from 0. If negative, indicates the end of
 the list
<!-- trait BoxExt::fn set_baseline_position -->
Sets the baseline position of a box. This affects
only horizontal boxes with at least one baseline aligned
child. If there is more vertical space available than requested,
and the baseline is not allocated by the parent then
`position` is used to allocate the baseline wrt the
extra space available.

Feature: `v3_10`

## `position`
a `BaselinePosition`
<!-- trait BoxExt::fn set_center_widget -->
Sets a center widget; that is a child widget that will be
centered with respect to the full width of the box, even
if the children at either side take up different amounts
of space.

Feature: `v3_12`

## `widget`
the widget to center
<!-- trait BoxExt::fn set_child_packing -->
Sets the way `child` is packed into `self`.
## `child`
the `Widget` of the child to set
## `expand`
the new value of the expand child property
## `fill`
the new value of the fill child property
## `padding`
the new value of the padding child property
## `pack_type`
the new value of the pack-type child property
<!-- trait BoxExt::fn set_homogeneous -->
Sets the `Box:homogeneous` property of `self`, controlling
whether or not all children of `self` are given equal space
in the box.
## `homogeneous`
a boolean value, `true` to create equal allotments,
 `false` for variable allotments
<!-- trait BoxExt::fn set_spacing -->
Sets the `Box:spacing` property of `self`, which is the
number of pixels to place between children of `self`.
## `spacing`
the number of pixels to put between children
<!-- struct Buildable -->
`Buildable` allows objects to extend and customize their deserialization
from [`Builder` UI descriptions][BUILDER-UI].
The interface includes methods for setting names and properties of objects,
parsing custom tags and constructing child objects.

The `Buildable` interface is implemented by all widgets and
many of the non-widget objects that are provided by GTK+. The
main user of this interface is `Builder`. There should be
very little need for applications to call any of these functions directly.

An object only needs to implement this interface if it needs to extend the
`Builder` format or run any extra routines at deserialization time.

# Implements

[`BuildableExt`](trait.BuildableExt.html)
<!-- trait BuildableExt -->
Trait containing all `Buildable` methods.

# Implementors

[`AboutDialog`](struct.AboutDialog.html), [`ActionBar`](struct.ActionBar.html), [`Alignment`](struct.Alignment.html), [`AppChooserDialog`](struct.AppChooserDialog.html), [`AppChooserWidget`](struct.AppChooserWidget.html), [`ApplicationWindow`](struct.ApplicationWindow.html), [`Arrow`](struct.Arrow.html), [`AspectFrame`](struct.AspectFrame.html), [`Assistant`](struct.Assistant.html), [`Bin`](struct.Bin.html), [`Box`](struct.Box.html), [`Buildable`](struct.Buildable.html), [`ButtonBox`](struct.ButtonBox.html), [`Button`](struct.Button.html), [`Calendar`](struct.Calendar.html), [`CellAreaBox`](struct.CellAreaBox.html), [`CellArea`](struct.CellArea.html), [`CheckButton`](struct.CheckButton.html), [`CheckMenuItem`](struct.CheckMenuItem.html), [`ColorButton`](struct.ColorButton.html), [`ColorChooserDialog`](struct.ColorChooserDialog.html), [`ColorChooserWidget`](struct.ColorChooserWidget.html), [`ComboBoxText`](struct.ComboBoxText.html), [`ComboBox`](struct.ComboBox.html), [`Container`](struct.Container.html), [`Dialog`](struct.Dialog.html), [`DrawingArea`](struct.DrawingArea.html), [`EntryCompletion`](struct.EntryCompletion.html), [`Entry`](struct.Entry.html), [`EventBox`](struct.EventBox.html), [`Expander`](struct.Expander.html), [`FileChooserButton`](struct.FileChooserButton.html), [`FileChooserDialog`](struct.FileChooserDialog.html), [`FileChooserWidget`](struct.FileChooserWidget.html), [`FileFilter`](struct.FileFilter.html), [`Fixed`](struct.Fixed.html), [`FlowBoxChild`](struct.FlowBoxChild.html), [`FlowBox`](struct.FlowBox.html), [`FontButton`](struct.FontButton.html), [`FontChooserDialog`](struct.FontChooserDialog.html), [`FontChooserWidget`](struct.FontChooserWidget.html), [`Frame`](struct.Frame.html), [`GLArea`](struct.GLArea.html), [`Grid`](struct.Grid.html), [`HeaderBar`](struct.HeaderBar.html), [`IconFactory`](struct.IconFactory.html), [`IconView`](struct.IconView.html), [`ImageMenuItem`](struct.ImageMenuItem.html), [`Image`](struct.Image.html), [`InfoBar`](struct.InfoBar.html), [`Label`](struct.Label.html), [`Layout`](struct.Layout.html), [`LevelBar`](struct.LevelBar.html), [`LinkButton`](struct.LinkButton.html), [`ListBoxRow`](struct.ListBoxRow.html), [`ListBox`](struct.ListBox.html), [`ListStore`](struct.ListStore.html), [`MenuBar`](struct.MenuBar.html), [`MenuButton`](struct.MenuButton.html), [`MenuItem`](struct.MenuItem.html), [`MenuShell`](struct.MenuShell.html), [`MenuToolButton`](struct.MenuToolButton.html), [`Menu`](struct.Menu.html), [`MessageDialog`](struct.MessageDialog.html), [`Misc`](struct.Misc.html), [`ModelButton`](struct.ModelButton.html), [`Notebook`](struct.Notebook.html), [`Overlay`](struct.Overlay.html), [`Paned`](struct.Paned.html), [`PlacesSidebar`](struct.PlacesSidebar.html), [`PopoverMenu`](struct.PopoverMenu.html), [`Popover`](struct.Popover.html), [`ProgressBar`](struct.ProgressBar.html), [`RadioButton`](struct.RadioButton.html), [`RadioMenuItem`](struct.RadioMenuItem.html), [`RadioToolButton`](struct.RadioToolButton.html), [`Range`](struct.Range.html), [`RecentChooserDialog`](struct.RecentChooserDialog.html), [`RecentChooserWidget`](struct.RecentChooserWidget.html), [`RecentFilter`](struct.RecentFilter.html), [`Revealer`](struct.Revealer.html), [`ScaleButton`](struct.ScaleButton.html), [`Scale`](struct.Scale.html), [`Scrollbar`](struct.Scrollbar.html), [`ScrolledWindow`](struct.ScrolledWindow.html), [`SearchBar`](struct.SearchBar.html), [`SearchEntry`](struct.SearchEntry.html), [`SeparatorMenuItem`](struct.SeparatorMenuItem.html), [`SeparatorToolItem`](struct.SeparatorToolItem.html), [`Separator`](struct.Separator.html), [`ShortcutsWindow`](struct.ShortcutsWindow.html), [`SizeGroup`](struct.SizeGroup.html), [`SpinButton`](struct.SpinButton.html), [`Spinner`](struct.Spinner.html), [`StackSidebar`](struct.StackSidebar.html), [`StackSwitcher`](struct.StackSwitcher.html), [`Stack`](struct.Stack.html), [`Statusbar`](struct.Statusbar.html), [`Switch`](struct.Switch.html), [`TextTagTable`](struct.TextTagTable.html), [`TextView`](struct.TextView.html), [`ToggleButton`](struct.ToggleButton.html), [`ToggleToolButton`](struct.ToggleToolButton.html), [`ToolButton`](struct.ToolButton.html), [`ToolItemGroup`](struct.ToolItemGroup.html), [`ToolItem`](struct.ToolItem.html), [`ToolPalette`](struct.ToolPalette.html), [`Toolbar`](struct.Toolbar.html), [`TreeStore`](struct.TreeStore.html), [`TreeViewColumn`](struct.TreeViewColumn.html), [`TreeView`](struct.TreeView.html), [`Viewport`](struct.Viewport.html), [`VolumeButton`](struct.VolumeButton.html), [`Widget`](struct.Widget.html), [`Window`](struct.Window.html)
<!-- trait BuildableExt::fn add_child -->
Adds a child to `self`. `type_` is an optional string
describing how the child should be added.
## `builder`
a `Builder`
## `child`
child to add
## `type_`
kind of child or `None`
<!-- trait BuildableExt::fn construct_child -->
Constructs a child of `self` with the name `name`.

`Builder` calls this function if a “constructor” has been
specified in the UI definition.
## `builder`
`Builder` used to construct this object
## `name`
name of child to construct

# Returns

the constructed child
<!-- trait BuildableExt::fn custom_finished -->
This is similar to `Buildable::parser_finished` but is
called once for each custom tag handled by the `self`.
## `builder`
a `Builder`
## `child`
child object or `None` for non-child tags
## `tagname`
the name of the tag
## `data`
user data created in custom_tag_start
<!-- trait BuildableExt::fn custom_tag_end -->
This is called at the end of each custom element handled by
the buildable.
## `builder`
`Builder` used to construct this object
## `child`
child object or `None` for non-child tags
## `tagname`
name of tag
## `data`
user data that will be passed in to parser functions
<!-- trait BuildableExt::fn custom_tag_start -->
This is called for each unknown element under `<child>`.
## `builder`
a `Builder` used to construct this object
## `child`
child object or `None` for non-child tags
## `tagname`
name of tag
## `parser`
a `glib::MarkupParser` to fill in
## `data`
return location for user data that will be passed in
 to parser functions

# Returns

`true` if a object has a custom implementation, `false`
 if it doesn't.
<!-- trait BuildableExt::fn get_internal_child -->
Get the internal child called `childname` of the `self` object.
## `builder`
a `Builder`
## `childname`
name of child

# Returns

the internal child of the buildable object
<!-- trait BuildableExt::fn get_name -->
Gets the name of the `self` object.

`Builder` sets the name based on the
[`Builder` UI definition][BUILDER-UI]
used to construct the `self`.

# Returns

the name set with `Buildable::set_name`
<!-- trait BuildableExt::fn parser_finished -->
Called when the builder finishes the parsing of a
[`Builder` UI definition][BUILDER-UI].
Note that this will be called once for each time
`Builder::add_from_file` or `BuilderExt::add_from_string`
is called on a builder.
## `builder`
a `Builder`
<!-- trait BuildableExt::fn set_buildable_property -->
Sets the property name `name` to `value` on the `self` object.
## `builder`
a `Builder`
## `name`
name of property
## `value`
value of property
<!-- trait BuildableExt::fn set_name -->
Sets the name of the `self` object.
## `name`
name to set
<!-- struct Builder -->
A `Builder` is an auxiliary object that reads textual descriptions
of a user interface and instantiates the described objects. To create
a `Builder` from a user interface description, call
`Builder::new_from_file`, `Builder::new_from_resource` or
`Builder::new_from_string`.

In the (unusual) case that you want to add user interface
descriptions from multiple sources to the same `Builder` you can
call `Builder::new` to get an empty builder and populate it by
(multiple) calls to `Builder::add_from_file`,
`BuilderExt::add_from_resource` or `BuilderExt::add_from_string`.

A `Builder` holds a reference to all objects that it has constructed
and drops these references when it is finalized. This finalization can
cause the destruction of non-widget objects or widgets which are not
contained in a toplevel window. For toplevel windows constructed by a
builder, it is the responsibility of the user to call `WidgetExt::destroy`
to get rid of them and all the widgets they contain.

The functions `Builder::get_object` and `BuilderExt::get_objects`
can be used to access the widgets in the interface by the names assigned
to them inside the UI description. Toplevel windows returned by these
functions will stay around until the user explicitly destroys them
with `WidgetExt::destroy`. Other widgets will either be part of a
larger hierarchy constructed by the builder (in which case you should
not have to worry about their lifecycle), or without a parent, in which
case they have to be added to some container to make use of them.
Non-widget objects need to be reffed with `gobject::ObjectExt::ref` to keep them
beyond the lifespan of the builder.

The function `BuilderExt::connect_signals` and variants thereof can be
used to connect handlers to the named signals in the description.

# `Builder` UI Definitions # {`BUILDER`-UI}

`Builder` parses textual descriptions of user interfaces which are
specified in an XML format which can be roughly described by the
RELAX NG schema below. We refer to these descriptions as “`Builder`
UI definitions” or just “UI definitions” if the context is clear.
Do not confuse `Builder` UI Definitions with
[`UIManager` UI Definitions][XML-UI], which are more limited in scope.
It is common to use `.ui` as the filename extension for files containing
`Builder` UI definitions.

[RELAX NG Compact Syntax](https://git.gnome.org/browse/gtk+/tree/gtk/gtkbuilder.rnc)

The toplevel element is `<interface>`. It optionally takes a “domain”
attribute, which will make the builder look for translated strings
using `dgettext` in the domain specified. This can also be done by
calling `BuilderExt::set_translation_domain` on the builder.
Objects are described by `<object>` elements, which can contain
`<property>` elements to set properties, `<signal>` elements which
connect signals to handlers, and `<child>` elements, which describe
child objects (most often widgets inside a container, but also e.g.
actions in an action group, or columns in a tree model). A `<child>`
element contains an `<object>` element which describes the child object.
The target toolkit version(s) are described by `<requires>` elements,
the “lib” attribute specifies the widget library in question (currently
the only supported value is “gtk+”) and the “version” attribute specifies
the target version in the form “`<major>`.`<minor>`”. The builder will error
out if the version requirements are not met.

Typically, the specific kind of object represented by an `<object>`
element is specified by the “class” attribute. If the type has not
been loaded yet, GTK+ tries to find the `get_type` function from the
class name by applying heuristics. This works in most cases, but if
necessary, it is possible to specify the name of the `get_type` function
explictly with the "type-func" attribute. As a special case, `Builder`
allows to use an object that has been constructed by a `UIManager` in
another part of the UI definition by specifying the id of the `UIManager`
in the “constructor” attribute and the name of the object in the “id”
attribute.

Objects may be given a name with the “id” attribute, which allows the
application to retrieve them from the builder with `Builder::get_object`.
An id is also necessary to use the object as property value in other
parts of the UI definition. GTK+ reserves ids starting and ending
with ___ (3 underscores) for its own purposes.

Setting properties of objects is pretty straightforward with the
`<property>` element: the “name” attribute specifies the name of the
property, and the content of the element specifies the value.
If the “translatable” attribute is set to a true value, GTK+ uses
`gettext` (or `dgettext` if the builder has a translation domain set)
to find a translation for the value. This happens before the value
is parsed, so it can be used for properties of any type, but it is
probably most useful for string properties. It is also possible to
specify a context to disambiguate short strings, and comments which
may help the translators.

`Builder` can parse textual representations for the most common
property types: characters, strings, integers, floating-point numbers,
booleans (strings like “TRUE”, “t”, “yes”, “y”, “1” are interpreted
as `true`, strings like “FALSE”, “f”, “no”, “n”, “0” are interpreted
as `false`), enumerations (can be specified by their name, nick or
integer value), flags (can be specified by their name, nick, integer
value, optionally combined with “|”, e.g. “GTK_VISIBLE|GTK_REALIZED”)
and colors (in a format understood by `gdk::RGBA::parse`).

GVariants can be specified in the format understood by `glib::Variant::parse`,
and pixbufs can be specified as a filename of an image file to load.

Objects can be referred to by their name and by default refer to
objects declared in the local xml fragment and objects exposed via
`BuilderExt::expose_object`. In general, `Builder` allows forward
references to objects — declared in the local xml; an object doesn’t
have to be constructed before it can be referred to. The exception
to this rule is that an object has to be constructed before it can
be used as the value of a construct-only property.

It is also possible to bind a property value to another object's
property value using the attributes
"bind-source" to specify the source object of the binding,
"bind-property" to specify the source property and optionally
"bind-flags" to specify the binding flags
Internally builder implement this using GBinding objects.
For more information see `gobject::ObjectExt::bind_property`

Signal handlers are set up with the `<signal>` element. The “name”
attribute specifies the name of the signal, and the “handler” attribute
specifies the function to connect to the signal. By default, GTK+ tries
to find the handler using `gmodule::Module::symbol`, but this can be changed by
passing a custom ``GtkBuilderConnectFunc`` to
`BuilderExt::connect_signals_full`. The remaining attributes, “after”,
“swapped” and “object”, have the same meaning as the corresponding
parameters of the `g_signal_connect_object` or
`g_signal_connect_data` functions. A “last_modification_time”
attribute is also allowed, but it does not have a meaning to the
builder.

Sometimes it is necessary to refer to widgets which have implicitly
been constructed by GTK+ as part of a composite widget, to set
properties on them or to add further children (e.g. the `vbox` of
a `Dialog`). This can be achieved by setting the “internal-child”
propery of the `<child>` element to a true value. Note that `Builder`
still requires an `<object>` element for the internal child, even if it
has already been constructed.

A number of widgets have different places where a child can be added
(e.g. tabs vs. page content in notebooks). This can be reflected in
a UI definition by specifying the “type” attribute on a `<child>`
The possible values for the “type” attribute are described in the
sections describing the widget-specific portions of UI definitions.

# A `Builder` UI Definition


```text
<interface>
  <object class="GtkDialog" id="dialog1">
    <child internal-child="vbox">
      <object class="GtkBox" id="vbox1">
        <property name="border-width">10</property>
        <child internal-child="action_area">
          <object class="GtkButtonBox" id="hbuttonbox1">
            <property name="border-width">20</property>
            <child>
              <object class="GtkButton" id="ok_button">
                <property name="label">gtk-ok</property>
                <property name="use-stock">TRUE</property>
                <signal name="clicked" handler="ok_button_clicked"/>
              </object>
            </child>
          </object>
        </child>
      </object>
    </child>
  </object>
</interface>
```

Beyond this general structure, several object classes define their
own XML DTD fragments for filling in the ANY placeholders in the DTD
above. Note that a custom element in a `<child>` element gets parsed by
the custom tag handler of the parent object, while a custom element in
an `<object>` element gets parsed by the custom tag handler of the object.

These XML fragments are explained in the documentation of the
respective objects.

Additionally, since 3.10 a special `<template>` tag has been added
to the format allowing one to define a widget class’s components.
See the [`Widget` documentation][composite-templates] for details.

# Implements

[`BuilderExt`](trait.BuilderExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait BuilderExt -->
Trait containing all `Builder` methods.

# Implementors

[`Builder`](struct.Builder.html)
<!-- impl Builder::fn new -->
Creates a new empty builder object.

This function is only useful if you intend to make multiple calls
to `Builder::add_from_file`, `BuilderExt::add_from_resource`
or `BuilderExt::add_from_string` in order to merge multiple UI
descriptions into a single builder.

Most users will probably want to use `Builder::new_from_file`,
`Builder::new_from_resource` or `Builder::new_from_string`.

# Returns

a new (empty) `Builder` object
<!-- impl Builder::fn new_from_file -->
Builds the [`Builder` UI definition][BUILDER-UI]
in the file `filename`.

If there is an error opening the file or parsing the description then
the program will be aborted. You should only ever attempt to parse
user interface descriptions that are shipped as part of your program.

Feature: `v3_10`

## `filename`
filename of user interface description file

# Returns

a `Builder` containing the described interface
<!-- impl Builder::fn new_from_resource -->
Builds the [`Builder` UI definition][BUILDER-UI]
at `resource_path`.

If there is an error locating the resource or parsing the
description, then the program will be aborted.

Feature: `v3_10`

## `resource_path`
a `gio::Resource` resource path

# Returns

a `Builder` containing the described interface
<!-- impl Builder::fn new_from_string -->
Builds the user interface described by `string` (in the
[`Builder` UI definition][BUILDER-UI] format).

If `string` is `None`-terminated, then `length` should be -1.
If `length` is not -1, then it is the length of `string`.

If there is an error parsing `string` then the program will be
aborted. You should not attempt to parse user interface description
from untrusted sources.

Feature: `v3_10`

## `string`
a user interface (XML) description
## `length`
the length of `string`, or -1

# Returns

a `Builder` containing the interface described by `string`
<!-- trait BuilderExt::fn add_callback_symbol -->
Adds the `callback_symbol` to the scope of `self` under the given `callback_name`.

Using this function overrides the behavior of `BuilderExt::connect_signals`
for any callback symbols that are added. Using this method allows for better
encapsulation as it does not require that callback symbols be declared in
the global namespace.

Feature: `v3_10`

## `callback_name`
The name of the callback, as expected in the XML
## `callback_symbol`
The callback pointer
<!-- trait BuilderExt::fn add_callback_symbols -->
A convenience function to add many callbacks instead of calling
`BuilderExt::add_callback_symbol` for each symbol.

Feature: `v3_10`

## `first_callback_name`
The name of the callback, as expected in the XML
## `first_callback_symbol`
The callback pointer
<!-- trait BuilderExt::fn add_from_file -->
Parses a file containing a [`Builder` UI definition][BUILDER-UI]
and merges it with the current contents of `self`.

Most users will probably want to use `Builder::new_from_file`.

If an error occurs, 0 will be returned and `error` will be assigned a
`glib::Error` from the `GTK_BUILDER_ERROR`, `G_MARKUP_ERROR` or `G_FILE_ERROR`
domain.

It’s not really reasonable to attempt to handle failures of this
call. You should not use this function with untrusted files (ie:
files that are not part of your application). Broken `Builder`
files can easily crash your program, and it’s possible that memory
was leaked leading up to the reported failure. The only reasonable
thing to do when an error is detected is to call `g_error`.
## `filename`
the name of the file to parse

# Returns

A positive value on success, 0 if an error occurred
<!-- trait BuilderExt::fn add_from_resource -->
Parses a resource file containing a [`Builder` UI definition][BUILDER-UI]
and merges it with the current contents of `self`.

Most users will probably want to use `Builder::new_from_resource`.

If an error occurs, 0 will be returned and `error` will be assigned a
`glib::Error` from the `GTK_BUILDER_ERROR`, `G_MARKUP_ERROR` or `G_RESOURCE_ERROR`
domain.

It’s not really reasonable to attempt to handle failures of this
call. The only reasonable thing to do when an error is detected is
to call `g_error`.
## `resource_path`
the path of the resource file to parse

# Returns

A positive value on success, 0 if an error occurred
<!-- trait BuilderExt::fn add_from_string -->
Parses a string containing a [`Builder` UI definition][BUILDER-UI]
and merges it with the current contents of `self`.

Most users will probably want to use `Builder::new_from_string`.

Upon errors 0 will be returned and `error` will be assigned a
`glib::Error` from the `GTK_BUILDER_ERROR`, `G_MARKUP_ERROR` or
`G_VARIANT_PARSE_ERROR` domain.

It’s not really reasonable to attempt to handle failures of this
call. The only reasonable thing to do when an error is detected is
to call `g_error`.
## `buffer`
the string to parse
## `length`
the length of `buffer` (may be -1 if `buffer` is nul-terminated)

# Returns

A positive value on success, 0 if an error occurred
<!-- trait BuilderExt::fn add_objects_from_file -->
Parses a file containing a [`Builder` UI definition][BUILDER-UI]
building only the requested objects and merges
them with the current contents of `self`.

Upon errors 0 will be returned and `error` will be assigned a
`glib::Error` from the `GTK_BUILDER_ERROR`, `G_MARKUP_ERROR` or `G_FILE_ERROR`
domain.

If you are adding an object that depends on an object that is not
its child (for instance a `TreeView` that depends on its
`TreeModel`), you have to explicitly list all of them in `object_ids`.
## `filename`
the name of the file to parse
## `object_ids`
nul-terminated array of objects to build

# Returns

A positive value on success, 0 if an error occurred
<!-- trait BuilderExt::fn add_objects_from_resource -->
Parses a resource file containing a [`Builder` UI definition][BUILDER-UI]
building only the requested objects and merges
them with the current contents of `self`.

Upon errors 0 will be returned and `error` will be assigned a
`glib::Error` from the `GTK_BUILDER_ERROR`, `G_MARKUP_ERROR` or `G_RESOURCE_ERROR`
domain.

If you are adding an object that depends on an object that is not
its child (for instance a `TreeView` that depends on its
`TreeModel`), you have to explicitly list all of them in `object_ids`.
## `resource_path`
the path of the resource file to parse
## `object_ids`
nul-terminated array of objects to build

# Returns

A positive value on success, 0 if an error occurred
<!-- trait BuilderExt::fn add_objects_from_string -->
Parses a string containing a [`Builder` UI definition][BUILDER-UI]
building only the requested objects and merges
them with the current contents of `self`.

Upon errors 0 will be returned and `error` will be assigned a
`glib::Error` from the `GTK_BUILDER_ERROR` or `G_MARKUP_ERROR` domain.

If you are adding an object that depends on an object that is not
its child (for instance a `TreeView` that depends on its
`TreeModel`), you have to explicitly list all of them in `object_ids`.
## `buffer`
the string to parse
## `length`
the length of `buffer` (may be -1 if `buffer` is nul-terminated)
## `object_ids`
nul-terminated array of objects to build

# Returns

A positive value on success, 0 if an error occurred
<!-- trait BuilderExt::fn connect_signals -->
This method is a simpler variation of `BuilderExt::connect_signals_full`.
It uses symbols explicitly added to `self` with prior calls to
`BuilderExt::add_callback_symbol`. In the case that symbols are not
explicitly added; it uses `gmodule::Module`’s introspective features (by opening the module `None`)
to look at the application’s symbol table. From here it tries to match
the signal handler names given in the interface description with
symbols in the application and connects the signals. Note that this
function can only be called once, subsequent calls will do nothing.

Note that unless `BuilderExt::add_callback_symbol` is called for
all signal callbacks which are referenced by the loaded XML, this
function will require that `gmodule::Module` be supported on the platform.

If you rely on `gmodule::Module` support to lookup callbacks in the symbol table,
the following details should be noted:

When compiling applications for Windows, you must declare signal callbacks
with `G_MODULE_EXPORT`, or they will not be put in the symbol table.
On Linux and Unices, this is not necessary; applications should instead
be compiled with the -Wl,--export-dynamic CFLAGS, and linked against
gmodule-export-2.0.
## `user_data`
user data to pass back with all signals
<!-- trait BuilderExt::fn connect_signals_full -->
This function can be thought of the interpreted language binding
version of `BuilderExt::connect_signals`, except that it does not
require GModule to function correctly.
## `func`
the function used to connect the signals
## `user_data`
arbitrary data that will be passed to the connection function
<!-- trait BuilderExt::fn expose_object -->
Add `object` to the `self` object pool so it can be referenced just like any
other object built by builder.

Feature: `v3_8`

## `name`
the name of the object exposed to the builder
## `object`
the object to expose
<!-- trait BuilderExt::fn extend_with_template -->
Main private entry point for building composite container
components from template XML.

This is exported purely to let gtk-builder-tool validate
templates, applications have no need to call this function.
## `widget`
the widget that is being extended
## `template_type`
the type that the template is for
## `buffer`
the string to parse
## `length`
the length of `buffer` (may be -1 if `buffer` is nul-terminated)

# Returns

A positive value on success, 0 if an error occurred
<!-- trait BuilderExt::fn get_application -->
Gets the `Application` associated with the builder.

The `Application` is used for creating action proxies as requested
from XML that the builder is loading.

By default, the builder uses the default application: the one from
`gio::Application::get_default`. If you want to use another application
for constructing proxies, use `BuilderExt::set_application`.

Feature: `v3_10`


# Returns

the application being used by the builder,
 or `None`
<!-- trait BuilderExt::fn get_object -->
Gets the object named `name`. Note that this function does not
increment the reference count of the returned object.
## `name`
name of object to get

# Returns

the object named `name` or `None` if
 it could not be found in the object tree.
<!-- trait BuilderExt::fn get_objects -->
Gets all objects that have been constructed by `self`. Note that
this function does not increment the reference counts of the returned
objects.

# Returns

a newly-allocated `glib::SList` containing all the objects
 constructed by the `Builder` instance. It should be freed by
 `glib::SList::free`
<!-- trait BuilderExt::fn get_translation_domain -->
Gets the translation domain of `self`.

# Returns

the translation domain. This string is owned
by the builder object and must not be modified or freed.
<!-- trait BuilderExt::fn get_type_from_name -->
Looks up a type by name, using the virtual function that
`Builder` has for that purpose. This is mainly used when
implementing the `Buildable` interface on a type.
## `type_name`
type name to lookup

# Returns

the `glib::Type` found for `type_name` or `G_TYPE_INVALID`
 if no type was found
<!-- trait BuilderExt::fn lookup_callback_symbol -->
Fetches a symbol previously added to `self`
with `BuilderExt::add_callback_symbols`

This function is intended for possible use in language bindings
or for any case that one might be cusomizing signal connections
using `BuilderExt::connect_signals_full`

Feature: `v3_10`

## `callback_name`
The name of the callback

# Returns

The callback symbol in `self` for `callback_name`, or `None`
<!-- trait BuilderExt::fn set_application -->
Sets the application associated with `self`.

You only need this function if there is more than one `gio::Application`
in your process. `application` cannot be `None`.

Feature: `v3_10`

## `application`
a `Application`
<!-- trait BuilderExt::fn set_translation_domain -->
Sets the translation domain of `self`.
See `Builder:translation-domain`.
## `domain`
the translation domain or `None`
<!-- trait BuilderExt::fn value_from_string -->
This function demarshals a value from a string. This function
calls `gobject::Value::init` on the `value` argument, so it need not be
initialised beforehand.

This function can handle char, uchar, boolean, int, uint, long,
ulong, enum, flags, float, double, string, `gdk::Color`, `gdk::RGBA` and
`Adjustment` type values. Support for `Widget` type values is
still to come.

Upon errors `false` will be returned and `error` will be assigned a
`glib::Error` from the `GTK_BUILDER_ERROR` domain.
## `pspec`
the `gobject::ParamSpec` for the property
## `string`
the string representation of the value
## `value`
the `gobject::Value` to store the result in

# Returns

`true` on success
<!-- trait BuilderExt::fn value_from_string_type -->
Like `BuilderExt::value_from_string`, this function demarshals
a value from a string, but takes a `glib::Type` instead of `gobject::ParamSpec`.
This function calls `gobject::Value::init` on the `value` argument, so it
need not be initialised beforehand.

Upon errors `false` will be returned and `error` will be assigned a
`glib::Error` from the `GTK_BUILDER_ERROR` domain.
## `type_`
the `glib::Type` of the value
## `string`
the string representation of the value
## `value`
the `gobject::Value` to store the result in

# Returns

`true` on success
<!-- trait BuilderExt::fn get_property_translation-domain -->
The translation domain used when translating property values that
have been marked as translatable in interface descriptions.
If the translation domain is `None`, `Builder` uses `gettext`,
otherwise `g_dgettext`.
<!-- trait BuilderExt::fn set_property_translation-domain -->
The translation domain used when translating property values that
have been marked as translatable in interface descriptions.
If the translation domain is `None`, `Builder` uses `gettext`,
otherwise `g_dgettext`.
<!-- enum BuilderError -->
Error codes that identify various errors that can occur while using
`Builder`.
<!-- enum BuilderError::variant InvalidTypeFunction -->
A type-func attribute didn’t name
 a function that returns a `glib::Type`.
<!-- enum BuilderError::variant UnhandledTag -->
The input contained a tag that `Builder`
 can’t handle.
<!-- enum BuilderError::variant MissingAttribute -->
An attribute that is required by
 `Builder` was missing.
<!-- enum BuilderError::variant InvalidAttribute -->
`Builder` found an attribute that
 it doesn’t understand.
<!-- enum BuilderError::variant InvalidTag -->
`Builder` found a tag that
 it doesn’t understand.
<!-- enum BuilderError::variant MissingPropertyValue -->
A required property value was
 missing.
<!-- enum BuilderError::variant InvalidValue -->
`Builder` couldn’t parse
 some attribute value.
<!-- enum BuilderError::variant VersionMismatch -->
The input file requires a newer version
 of GTK+.
<!-- enum BuilderError::variant DuplicateId -->
An object id occurred twice.
<!-- enum BuilderError::variant ObjectTypeRefused -->
A specified object type is of the same type or
 derived from the type of the composite class being extended with builder XML.
<!-- enum BuilderError::variant TemplateMismatch -->
The wrong type was specified in a composite class’s template XML
<!-- enum BuilderError::variant InvalidProperty -->
The specified property is unknown for the object class.
<!-- enum BuilderError::variant InvalidSignal -->
The specified signal is unknown for the object class.
<!-- enum BuilderError::variant InvalidId -->
An object id is unknown
<!-- struct Button -->
The `Button` widget is generally used to trigger a callback function that is
called when the button is pressed. The various signals and how to use them
are outlined below.

The `Button` widget can hold any valid child widget. That is, it can hold
almost any other standard `Widget`. The most commonly used child is the
`Label`.

# CSS nodes

`Button` has a single CSS node with name button. The node will get the
style classes .image-button or .text-button, if the content is just an
image or label, respectively. It may also receive the .flat style class.

Other style classes that are commonly used with `Button` include
.suggested-action and .destructive-action. In special cases, buttons
can be made round by adding the .circular style class.

Button-like widgets like `ToggleButton`, `MenuButton`, `VolumeButton`,
`LockButton`, `ColorButton`, `FontButton` or `FileChooserButton` use
style classes such as .toggle, .popup, .scale, .lock, .color, .font, .file
to differentiate themselves from a plain `Button`.

# Implements

[`ButtonExt`](trait.ButtonExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`ActionableExt`](trait.ActionableExt.html)
<!-- trait ButtonExt -->
Trait containing all `Button` methods.

# Implementors

[`Button`](struct.Button.html), [`ColorButton`](struct.ColorButton.html), [`FontButton`](struct.FontButton.html), [`LinkButton`](struct.LinkButton.html), [`ModelButton`](struct.ModelButton.html), [`ScaleButton`](struct.ScaleButton.html), [`ToggleButton`](struct.ToggleButton.html)
<!-- impl Button::fn new -->
Creates a new `Button` widget. To add a child widget to the button,
use `ContainerExt::add`.

# Returns

The newly created `Button` widget.
<!-- impl Button::fn new_from_icon_name -->
Creates a new button containing an icon from the current icon theme.

If the icon name isn’t known, a “broken image” icon will be
displayed instead. If the current icon theme is changed, the icon
will be updated appropriately.

This function is a convenience wrapper around `Button::new` and
`ButtonExt::set_image`.

Feature: `v3_10`

## `icon_name`
an icon name or `None`
## `size`
an icon size (`IconSize`)

# Returns

a new `Button` displaying the themed icon
<!-- impl Button::fn new_from_stock -->
Creates a new `Button` containing the image and text from a stock item.
Some stock ids have preprocessor macros like `GTK_STOCK_OK` and
`GTK_STOCK_APPLY`.

If `stock_id` is unknown, then it will be treated as a mnemonic
label (as for `Button::new_with_mnemonic`).

# Deprecated since 3.10

Use `Button::new_with_label` instead.
## `stock_id`
the name of the stock item

# Returns

a new `Button`
<!-- impl Button::fn new_with_label -->
Creates a `Button` widget with a `Label` child containing the given
text.
## `label`
The text you want the `Label` to hold.

# Returns

The newly created `Button` widget.
<!-- impl Button::fn new_with_mnemonic -->
Creates a new `Button` containing a label.
If characters in `label` are preceded by an underscore, they are underlined.
If you need a literal underscore character in a label, use “__” (two
underscores). The first underlined character represents a keyboard
accelerator called a mnemonic.
Pressing Alt and that key activates the button.
## `label`
The text of the button, with an underscore in front of the
 mnemonic character

# Returns

a new `Button`
<!-- trait ButtonExt::fn clicked -->
Emits a `Button::clicked` signal to the given `Button`.
<!-- trait ButtonExt::fn enter -->
Emits a `Button::enter` signal to the given `Button`.

# Deprecated since 2.20

Use the `Widget::enter-notify-event` signal.
<!-- trait ButtonExt::fn get_alignment -->
Gets the alignment of the child in the button.

# Deprecated since 3.14

Access the child widget directly if you need to control
its alignment.
## `xalign`
return location for horizontal alignment
## `yalign`
return location for vertical alignment
<!-- trait ButtonExt::fn get_always_show_image -->
Returns whether the button will ignore the `Settings:gtk-button-images`
setting and always show the image, if available.

Feature: `v3_6`


# Returns

`true` if the button will always show the image
<!-- trait ButtonExt::fn get_event_window -->
Returns the button’s event window if it is realized, `None` otherwise.
This function should be rarely needed.

# Returns

`self`’s event window.
<!-- trait ButtonExt::fn get_focus_on_click -->
Returns whether the button grabs focus when it is clicked with the mouse.
See `ButtonExt::set_focus_on_click`.

# Deprecated since 3.20

Use `WidgetExt::get_focus_on_click` instead

# Returns

`true` if the button grabs focus when it is clicked with
 the mouse.
<!-- trait ButtonExt::fn get_image -->
Gets the widget that is currenty set as the image of `self`.
This may have been explicitly set by `ButtonExt::set_image`
or constructed by `Button::new_from_stock`.

# Returns

a `Widget` or `None` in case
 there is no image
<!-- trait ButtonExt::fn get_image_position -->
Gets the position of the image relative to the text
inside the button.

# Returns

the position
<!-- trait ButtonExt::fn get_label -->
Fetches the text from the label of the button, as set by
`ButtonExt::set_label`. If the label text has not
been set the return value will be `None`. This will be the
case if you create an empty button with `Button::new` to
use as a container.

# Returns

The text of the label widget. This string is owned
by the widget and must not be modified or freed.
<!-- trait ButtonExt::fn get_relief -->
Returns the current relief style of the given `Button`.

# Returns

The current `ReliefStyle`
<!-- trait ButtonExt::fn get_use_stock -->
Returns whether the button label is a stock item.

# Deprecated since 3.10


# Returns

`true` if the button label is used to
 select a stock item instead of being
 used directly as the label text.
<!-- trait ButtonExt::fn get_use_underline -->
Returns whether an embedded underline in the button label indicates a
mnemonic. See gtk_button_set_use_underline ().

# Returns

`true` if an embedded underline in the button label
 indicates the mnemonic accelerator keys.
<!-- trait ButtonExt::fn leave -->
Emits a `Button::leave` signal to the given `Button`.

# Deprecated since 2.20

Use the `Widget::leave-notify-event` signal.
<!-- trait ButtonExt::fn pressed -->
Emits a `Button::pressed` signal to the given `Button`.

# Deprecated since 2.20

Use the `Widget::button-press-event` signal.
<!-- trait ButtonExt::fn released -->
Emits a `Button::released` signal to the given `Button`.

# Deprecated since 2.20

Use the `Widget::button-release-event` signal.
<!-- trait ButtonExt::fn set_alignment -->
Sets the alignment of the child. This property has no effect unless
the child is a `Misc` or a `Alignment`.

# Deprecated since 3.14

Access the child widget directly if you need to control
its alignment.
## `xalign`
the horizontal position of the child, 0.0 is left aligned,
 1.0 is right aligned
## `yalign`
the vertical position of the child, 0.0 is top aligned,
 1.0 is bottom aligned
<!-- trait ButtonExt::fn set_always_show_image -->
If `true`, the button will ignore the `Settings:gtk-button-images`
setting and always show the image, if available.

Use this property if the button would be useless or hard to use
without the image.

Feature: `v3_6`

## `always_show`
`true` if the menuitem should always show the image
<!-- trait ButtonExt::fn set_focus_on_click -->
Sets whether the button will grab focus when it is clicked with the mouse.
Making mouse clicks not grab focus is useful in places like toolbars where
you don’t want the keyboard focus removed from the main area of the
application.

# Deprecated since 3.20

Use `WidgetExt::set_focus_on_click` instead
## `focus_on_click`
whether the button grabs focus when clicked with the mouse
<!-- trait ButtonExt::fn set_image -->
Set the image of `self` to the given widget. The image will be
displayed if the label text is `None` or if
`Button:always-show-image` is `true`. You don’t have to call
`WidgetExt::show` on `image` yourself.
## `image`
a widget to set as the image for the button
<!-- trait ButtonExt::fn set_image_position -->
Sets the position of the image relative to the text
inside the button.
## `position`
the position
<!-- trait ButtonExt::fn set_label -->
Sets the text of the label of the button to `str`. This text is
also used to select the stock item if `ButtonExt::set_use_stock`
is used.

This will also clear any previously set labels.
## `label`
a string
<!-- trait ButtonExt::fn set_relief -->
Sets the relief style of the edges of the given `Button` widget.
Two styles exist, `ReliefStyle::Normal` and `ReliefStyle::None`.
The default style is, as one can guess, `ReliefStyle::Normal`.
The deprecated value `ReliefStyle::Half` behaves the same as
`ReliefStyle::Normal`.
## `relief`
The `ReliefStyle` as described above
<!-- trait ButtonExt::fn set_use_stock -->
If `true`, the label set on the button is used as a
stock id to select the stock item for the button.

# Deprecated since 3.10

## `use_stock`
`true` if the button should use a stock item
<!-- trait ButtonExt::fn set_use_underline -->
If true, an underline in the text of the button label indicates
the next character should be used for the mnemonic accelerator key.
## `use_underline`
`true` if underlines in the text indicate mnemonics
<!-- trait ButtonExt::fn connect_activate -->
The ::activate signal on `Button` is an action signal and
emitting it causes the button to animate press then release.
Applications should never connect to this signal, but use the
`Button::clicked` signal.
<!-- trait ButtonExt::fn connect_clicked -->
Emitted when the button has been activated (pressed and released).
<!-- trait ButtonExt::fn connect_enter -->
Emitted when the pointer enters the button.

# Deprecated since 2.8

Use the `Widget::enter-notify-event` signal.
<!-- trait ButtonExt::fn connect_leave -->
Emitted when the pointer leaves the button.

# Deprecated since 2.8

Use the `Widget::leave-notify-event` signal.
<!-- trait ButtonExt::fn connect_pressed -->
Emitted when the button is pressed.

# Deprecated since 2.8

Use the `Widget::button-press-event` signal.
<!-- trait ButtonExt::fn connect_released -->
Emitted when the button is released.

# Deprecated since 2.8

Use the `Widget::button-release-event` signal.
<!-- trait ButtonExt::fn get_property_always-show-image -->
If `true`, the button will ignore the `Settings:gtk-button-images`
setting and always show the image, if available.

Use this property if the button would be useless or hard to use
without the image.

Feature: `v3_6`

<!-- trait ButtonExt::fn set_property_always-show-image -->
If `true`, the button will ignore the `Settings:gtk-button-images`
setting and always show the image, if available.

Use this property if the button would be useless or hard to use
without the image.

Feature: `v3_6`

<!-- trait ButtonExt::fn get_property_image -->
The child widget to appear next to the button text.
<!-- trait ButtonExt::fn set_property_image -->
The child widget to appear next to the button text.
<!-- trait ButtonExt::fn get_property_image-position -->
The position of the image relative to the text inside the button.
<!-- trait ButtonExt::fn set_property_image-position -->
The position of the image relative to the text inside the button.
<!-- trait ButtonExt::fn get_property_xalign -->
If the child of the button is a `Misc` or `Alignment`, this property
can be used to control its horizontal alignment. 0.0 is left aligned,
1.0 is right aligned.

# Deprecated since 3.14

Access the child widget directly if you need to control
its alignment.
<!-- trait ButtonExt::fn set_property_xalign -->
If the child of the button is a `Misc` or `Alignment`, this property
can be used to control its horizontal alignment. 0.0 is left aligned,
1.0 is right aligned.

# Deprecated since 3.14

Access the child widget directly if you need to control
its alignment.
<!-- trait ButtonExt::fn get_property_yalign -->
If the child of the button is a `Misc` or `Alignment`, this property
can be used to control its vertical alignment. 0.0 is top aligned,
1.0 is bottom aligned.

# Deprecated since 3.14

Access the child widget directly if you need to control
its alignment.
<!-- trait ButtonExt::fn set_property_yalign -->
If the child of the button is a `Misc` or `Alignment`, this property
can be used to control its vertical alignment. 0.0 is top aligned,
1.0 is bottom aligned.

# Deprecated since 3.14

Access the child widget directly if you need to control
its alignment.
<!-- struct ButtonBox -->


# Implements

[`ButtonBoxExt`](trait.ButtonBoxExt.html), [`BoxExt`](trait.BoxExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`OrientableExt`](trait.OrientableExt.html)
<!-- trait ButtonBoxExt -->
Trait containing all `ButtonBox` methods.

# Implementors

[`ButtonBox`](struct.ButtonBox.html)
<!-- impl ButtonBox::fn new -->
Creates a new `ButtonBox`.
## `orientation`
the box's orientation.

# Returns

a new `ButtonBox`.
<!-- trait ButtonBoxExt::fn get_child_non_homogeneous -->
Returns whether the child is exempted from homogenous
sizing.
## `child`
a child of `self`

# Returns

`true` if the child is not subject to homogenous sizing
<!-- trait ButtonBoxExt::fn get_child_secondary -->
Returns whether `child` should appear in a secondary group of children.
## `child`
a child of `self`

# Returns

whether `child` should appear in a secondary group of children.
<!-- trait ButtonBoxExt::fn get_layout -->
Retrieves the method being used to arrange the buttons in a button box.

# Returns

the method used to lay out buttons in `self`.
<!-- trait ButtonBoxExt::fn set_child_non_homogeneous -->
Sets whether the child is exempted from homogeous sizing.
## `child`
a child of `self`
## `non_homogeneous`
the new value
<!-- trait ButtonBoxExt::fn set_child_secondary -->
Sets whether `child` should appear in a secondary group of children.
A typical use of a secondary child is the help button in a dialog.

This group appears after the other children if the style
is `ButtonBoxStyle::Start`, `ButtonBoxStyle::Spread` or
`ButtonBoxStyle::Edge`, and before the other children if the style
is `ButtonBoxStyle::End`. For horizontal button boxes, the definition
of before/after depends on direction of the widget (see
`WidgetExt::set_direction`). If the style is `ButtonBoxStyle::Start`
or `ButtonBoxStyle::End`, then the secondary children are aligned at
the other end of the button box from the main children. For the
other styles, they appear immediately next to the main children.
## `child`
a child of `self`
## `is_secondary`
if `true`, the `child` appears in a secondary group of the
 button box.
<!-- trait ButtonBoxExt::fn set_layout -->
Changes the way buttons are arranged in their container.
## `layout_style`
the new layout style
<!-- enum ButtonBoxStyle -->
Used to dictate the style that a `ButtonBox` uses to layout the buttons it
contains.
<!-- enum ButtonBoxStyle::variant Spread -->
Buttons are evenly spread across the box.
<!-- enum ButtonBoxStyle::variant Edge -->
Buttons are placed at the edges of the box.
<!-- enum ButtonBoxStyle::variant Start -->
Buttons are grouped towards the start of the box,
 (on the left for a HBox, or the top for a VBox).
<!-- enum ButtonBoxStyle::variant End -->
Buttons are grouped towards the end of the box,
 (on the right for a HBox, or the bottom for a VBox).
<!-- enum ButtonBoxStyle::variant Center -->
Buttons are centered in the box. Since 2.12.
<!-- enum ButtonBoxStyle::variant Expand -->
Buttons expand to fill the box. This entails giving
 buttons a "linked" appearance, making button sizes homogeneous, and
 setting spacing to 0 (same as calling `BoxExt::set_homogeneous` and
 `BoxExt::set_spacing` manually). Since 3.12.
<!-- enum ButtonRole -->
The role specifies the desired appearance of a `ModelButton`.
<!-- enum ButtonRole::variant Normal -->
A plain button
<!-- enum ButtonRole::variant Check -->
A check button
<!-- enum ButtonRole::variant Radio -->
A radio button
<!-- enum ButtonsType -->
Prebuilt sets of buttons for the dialog. If
none of these choices are appropriate, simply use `ButtonsType::None`
then call `DialogExt::add_buttons`.

> Please note that `ButtonsType::Ok`, `ButtonsType::YesNo`
> and `ButtonsType::OkCancel` are discouraged by the
> [GNOME Human Interface Guidelines](http://library.gnome.org/devel/hig-book/stable/).
<!-- enum ButtonsType::variant None -->
no buttons at all
<!-- enum ButtonsType::variant Ok -->
an OK button
<!-- enum ButtonsType::variant Close -->
a Close button
<!-- enum ButtonsType::variant Cancel -->
a Cancel button
<!-- enum ButtonsType::variant YesNo -->
Yes and No buttons
<!-- enum ButtonsType::variant OkCancel -->
OK and Cancel buttons
<!-- struct Calendar -->
`Calendar` is a widget that displays a Gregorian calendar, one month
at a time. It can be created with `Calendar::new`.

The month and year currently displayed can be altered with
`CalendarExt::select_month`. The exact day can be selected from the
displayed month using `CalendarExt::select_day`.

To place a visual marker on a particular day, use `CalendarExt::mark_day`
and to remove the marker, `CalendarExt::unmark_day`. Alternative, all
marks can be cleared with `CalendarExt::clear_marks`.

The way in which the calendar itself is displayed can be altered using
`CalendarExt::set_display_options`.

The selected date can be retrieved from a `Calendar` using
`CalendarExt::get_date`.

Users should be aware that, although the Gregorian calendar is the
legal calendar in most countries, it was adopted progressively
between 1582 and 1929. Display before these dates is likely to be
historically incorrect.

# Implements

[`CalendarExt`](trait.CalendarExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait CalendarExt -->
Trait containing all `Calendar` methods.

# Implementors

[`Calendar`](struct.Calendar.html)
<!-- impl Calendar::fn new -->
Creates a new calendar, with the current date being selected.

# Returns

a newly `Calendar` widget
<!-- trait CalendarExt::fn clear_marks -->
Remove all visual markers.
<!-- trait CalendarExt::fn get_date -->
Obtains the selected date from a `Calendar`.
## `year`
location to store the year as a decimal
 number (e.g. 2011), or `None`
## `month`
location to store the month number
 (between 0 and 11), or `None`
## `day`
location to store the day number (between
 1 and 31), or `None`
<!-- trait CalendarExt::fn get_day_is_marked -->
Returns if the `day` of the `self` is already marked.
## `day`
the day number between 1 and 31.

# Returns

whether the day is marked.
<!-- trait CalendarExt::fn get_detail_height_rows -->
Queries the height of detail cells, in rows.
See `Calendar:detail-width-chars`.

# Returns

The height of detail cells, in rows.
<!-- trait CalendarExt::fn get_detail_width_chars -->
Queries the width of detail cells, in characters.
See `Calendar:detail-width-chars`.

# Returns

The width of detail cells, in characters.
<!-- trait CalendarExt::fn get_display_options -->
Returns the current display options of `self`.

# Returns

the display options.
<!-- trait CalendarExt::fn mark_day -->
Places a visual marker on a particular day.
## `day`
the day number to mark between 1 and 31.
<!-- trait CalendarExt::fn select_day -->
Selects a day from the current month.
## `day`
the day number between 1 and 31, or 0 to unselect
 the currently selected day.
<!-- trait CalendarExt::fn select_month -->
Shifts the calendar to a different month.
## `month`
a month number between 0 and 11.
## `year`
the year the month is in.
<!-- trait CalendarExt::fn set_detail_func -->
Installs a function which provides Pango markup with detail information
for each day. Examples for such details are holidays or appointments. That
information is shown below each day when `Calendar:show-details` is set.
A tooltip containing with full detail information is provided, if the entire
text should not fit into the details area, or if `Calendar:show-details`
is not set.

The size of the details area can be restricted by setting the
`Calendar:detail-width-chars` and `Calendar:detail-height-rows`
properties.
## `func`
a function providing details for each day.
## `data`
data to pass to `func` invokations.
## `destroy`
a function for releasing `data`.
<!-- trait CalendarExt::fn set_detail_height_rows -->
Updates the height of detail cells.
See `Calendar:detail-height-rows`.
## `rows`
detail height in rows.
<!-- trait CalendarExt::fn set_detail_width_chars -->
Updates the width of detail cells.
See `Calendar:detail-width-chars`.
## `chars`
detail width in characters.
<!-- trait CalendarExt::fn set_display_options -->
Sets display options (whether to display the heading and the month
headings).
## `flags`
the display options to set
<!-- trait CalendarExt::fn unmark_day -->
Removes the visual marker from a particular day.
## `day`
the day number to unmark between 1 and 31.
<!-- trait CalendarExt::fn connect_day_selected -->
Emitted when the user selects a day.
<!-- trait CalendarExt::fn connect_day_selected_double_click -->
Emitted when the user double-clicks a day.
<!-- trait CalendarExt::fn connect_month_changed -->
Emitted when the user clicks a button to change the selected month on a
calendar.
<!-- trait CalendarExt::fn connect_next_month -->
Emitted when the user switched to the next month.
<!-- trait CalendarExt::fn connect_next_year -->
Emitted when user switched to the next year.
<!-- trait CalendarExt::fn connect_prev_month -->
Emitted when the user switched to the previous month.
<!-- trait CalendarExt::fn connect_prev_year -->
Emitted when user switched to the previous year.
<!-- trait CalendarExt::fn get_property_day -->
The selected day (as a number between 1 and 31, or 0
to unselect the currently selected day).
This property gets initially set to the current day.
<!-- trait CalendarExt::fn set_property_day -->
The selected day (as a number between 1 and 31, or 0
to unselect the currently selected day).
This property gets initially set to the current day.
<!-- trait CalendarExt::fn get_property_detail-height-rows -->
Height of a detail cell, in rows.
A value of 0 allows any width. See `CalendarExt::set_detail_func`.
<!-- trait CalendarExt::fn set_property_detail-height-rows -->
Height of a detail cell, in rows.
A value of 0 allows any width. See `CalendarExt::set_detail_func`.
<!-- trait CalendarExt::fn get_property_detail-width-chars -->
Width of a detail cell, in characters.
A value of 0 allows any width. See `CalendarExt::set_detail_func`.
<!-- trait CalendarExt::fn set_property_detail-width-chars -->
Width of a detail cell, in characters.
A value of 0 allows any width. See `CalendarExt::set_detail_func`.
<!-- trait CalendarExt::fn get_property_month -->
The selected month (as a number between 0 and 11).
This property gets initially set to the current month.
<!-- trait CalendarExt::fn set_property_month -->
The selected month (as a number between 0 and 11).
This property gets initially set to the current month.
<!-- trait CalendarExt::fn get_property_no-month-change -->
Determines whether the selected month can be changed.
<!-- trait CalendarExt::fn set_property_no-month-change -->
Determines whether the selected month can be changed.
<!-- trait CalendarExt::fn get_property_show-day-names -->
Determines whether day names are displayed.
<!-- trait CalendarExt::fn set_property_show-day-names -->
Determines whether day names are displayed.
<!-- trait CalendarExt::fn get_property_show-details -->
Determines whether details are shown directly in the widget, or if they are
available only as tooltip. When this property is set days with details are
marked.
<!-- trait CalendarExt::fn set_property_show-details -->
Determines whether details are shown directly in the widget, or if they are
available only as tooltip. When this property is set days with details are
marked.
<!-- trait CalendarExt::fn get_property_show-heading -->
Determines whether a heading is displayed.
<!-- trait CalendarExt::fn set_property_show-heading -->
Determines whether a heading is displayed.
<!-- trait CalendarExt::fn get_property_show-week-numbers -->
Determines whether week numbers are displayed.
<!-- trait CalendarExt::fn set_property_show-week-numbers -->
Determines whether week numbers are displayed.
<!-- trait CalendarExt::fn get_property_year -->
The selected year.
This property gets initially set to the current year.
<!-- trait CalendarExt::fn set_property_year -->
The selected year.
This property gets initially set to the current year.
<!-- struct CellArea -->
The `CellArea` is an abstract class for `CellLayout` widgets
(also referred to as "layouting widgets") to interface with an
arbitrary number of ``GtkCellRenderers`` and interact with the user
for a given `TreeModel` row.

The cell area handles events, focus navigation, drawing and
size requests and allocations for a given row of data.

Usually users dont have to interact with the `CellArea` directly
unless they are implementing a cell-layouting widget themselves.

# Requesting area sizes

As outlined in
[`Widget`’s geometry management section][geometry-management],
GTK+ uses a height-for-width
geometry management system to compute the sizes of widgets and user
interfaces. `CellArea` uses the same semantics to calculate the
size of an area for an arbitrary number of `TreeModel` rows.

When requesting the size of a cell area one needs to calculate
the size for a handful of rows, and this will be done differently by
different layouting widgets. For instance a `TreeViewColumn`
always lines up the areas from top to bottom while a `IconView`
on the other hand might enforce that all areas received the same
width and wrap the areas around, requesting height for more cell
areas when allocated less width.

It’s also important for areas to maintain some cell
alignments with areas rendered for adjacent rows (cells can
appear “columnized” inside an area even when the size of
cells are different in each row). For this reason the `CellArea`
uses a `CellAreaContext` object to store the alignments
and sizes along the way (as well as the overall largest minimum
and natural size for all the rows which have been calculated
with the said context).

The `CellAreaContext` is an opaque object specific to the
`CellArea` which created it (see `CellAreaExt::create_context`).
The owning cell-layouting widget can create as many contexts as
it wishes to calculate sizes of rows which should receive the
same size in at least one orientation (horizontally or vertically),
However, it’s important that the same `CellAreaContext` which
was used to request the sizes for a given `TreeModel` row be
used when rendering or processing events for that row.

In order to request the width of all the rows at the root level
of a `TreeModel` one would do the following:


```C
GtkTreeIter iter;
gint        minimum_width;
gint        natural_width;

valid = gtk_tree_model_get_iter_first (model, &iter);
while (valid)
  {
    gtk_cell_area_apply_attributes (area, model, &iter, FALSE, FALSE);
    gtk_cell_area_get_preferred_width (area, context, widget, NULL, NULL);

    valid = gtk_tree_model_iter_next (model, &iter);
  }
gtk_cell_area_context_get_preferred_width (context, &minimum_width, &natural_width);
```

Note that in this example it’s not important to observe the
returned minimum and natural width of the area for each row
unless the cell-layouting object is actually interested in the
widths of individual rows. The overall width is however stored
in the accompanying `CellAreaContext` object and can be consulted
at any time.

This can be useful since `CellLayout` widgets usually have to
support requesting and rendering rows in treemodels with an
exceedingly large amount of rows. The `CellLayout` widget in
that case would calculate the required width of the rows in an
idle or timeout source (see `g_timeout_add`) and when the widget
is requested its actual width in `WidgetClass.get_preferred_width`()
it can simply consult the width accumulated so far in the
`CellAreaContext` object.

A simple example where rows are rendered from top to bottom and
take up the full width of the layouting widget would look like:


```C
static void
foo_get_preferred_width (GtkWidget       *widget,
                         gint            *minimum_size,
                         gint            *natural_size)
{
  Foo        *foo  = FOO (widget);
  FooPrivate *priv = foo->priv;

  foo_ensure_at_least_one_handfull_of_rows_have_been_requested (foo);

  gtk_cell_area_context_get_preferred_width (priv->context, minimum_size, natural_size);
}
```

In the above example the Foo widget has to make sure that some
row sizes have been calculated (the amount of rows that Foo judged
was appropriate to request space for in a single timeout iteration)
before simply returning the amount of space required by the area via
the `CellAreaContext`.

Requesting the height for width (or width for height) of an area is
a similar task except in this case the `CellAreaContext` does not
store the data (actually, it does not know how much space the layouting
widget plans to allocate it for every row. It’s up to the layouting
widget to render each row of data with the appropriate height and
width which was requested by the `CellArea`).

In order to request the height for width of all the rows at the
root level of a `TreeModel` one would do the following:


```C
GtkTreeIter iter;
gint        minimum_height;
gint        natural_height;
gint        full_minimum_height = 0;
gint        full_natural_height = 0;

valid = gtk_tree_model_get_iter_first (model, &iter);
while (valid)
  {
    gtk_cell_area_apply_attributes (area, model, &iter, FALSE, FALSE);
    gtk_cell_area_get_preferred_height_for_width (area, context, widget,
                                                  width, &minimum_height, &natural_height);

    if (width_is_for_allocation)
       cache_row_height (&iter, minimum_height, natural_height);

    full_minimum_height += minimum_height;
    full_natural_height += natural_height;

    valid = gtk_tree_model_iter_next (model, &iter);
  }
```

Note that in the above example we would need to cache the heights
returned for each row so that we would know what sizes to render the
areas for each row. However we would only want to really cache the
heights if the request is intended for the layouting widgets real
allocation.

In some cases the layouting widget is requested the height for an
arbitrary for_width, this is a special case for layouting widgets
who need to request size for tens of thousands of rows. For this
case it’s only important that the layouting widget calculate
one reasonably sized chunk of rows and return that height
synchronously. The reasoning here is that any layouting widget is
at least capable of synchronously calculating enough height to fill
the screen height (or scrolled window height) in response to a single
call to `WidgetClass.get_preferred_height_for_width`(). Returning
a perfect height for width that is larger than the screen area is
inconsequential since after the layouting receives an allocation
from a scrolled window it simply continues to drive the scrollbar
values while more and more height is required for the row heights
that are calculated in the background.

# Rendering Areas

Once area sizes have been aquired at least for the rows in the
visible area of the layouting widget they can be rendered at
`WidgetClass.draw`() time.

A crude example of how to render all the rows at the root level
runs as follows:


```C
GtkAllocation allocation;
GdkRectangle  cell_area = { 0, };
GtkTreeIter   iter;
gint          minimum_width;
gint          natural_width;

gtk_widget_get_allocation (widget, &allocation);
cell_area.width = allocation.width;

valid = gtk_tree_model_get_iter_first (model, &iter);
while (valid)
  {
    cell_area.height = get_cached_height_for_row (&iter);

    gtk_cell_area_apply_attributes (area, model, &iter, FALSE, FALSE);
    gtk_cell_area_render (area, context, widget, cr,
                          &cell_area, &cell_area, state_flags, FALSE);

    cell_area.y += cell_area.height;

    valid = gtk_tree_model_iter_next (model, &iter);
  }
```

Note that the cached height in this example really depends on how
the layouting widget works. The layouting widget might decide to
give every row its minimum or natural height or, if the model content
is expected to fit inside the layouting widget without scrolling, it
would make sense to calculate the allocation for each row at
`Widget::size-allocate` time using `gtk_distribute_natural_allocation`.

# Handling Events and Driving Keyboard Focus

Passing events to the area is as simple as handling events on any
normal widget and then passing them to the `CellAreaExt::event`
API as they come in. Usually `CellArea` is only interested in
button events, however some customized derived areas can be implemented
who are interested in handling other events. Handling an event can
trigger the `CellArea::focus-changed` signal to fire; as well as
`CellArea::add-editable` in the case that an editable cell was
clicked and needs to start editing. You can call
`CellAreaExt::stop_editing` at any time to cancel any cell editing
that is currently in progress.

The `CellArea` drives keyboard focus from cell to cell in a way
similar to `Widget`. For layouting widgets that support giving
focus to cells it’s important to remember to pass `CellRendererState::Focused`
to the area functions for the row that has focus and to tell the
area to paint the focus at render time.

Layouting widgets that accept focus on cells should implement the
`WidgetClass.focus`() virtual method. The layouting widget is always
responsible for knowing where `TreeModel` rows are rendered inside
the widget, so at `WidgetClass.focus`() time the layouting widget
should use the `CellArea` methods to navigate focus inside the area
and then observe the `DirectionType` to pass the focus to adjacent
rows and areas.

A basic example of how the `WidgetClass.focus`() virtual method
should be implemented:


```C
static gboolean
foo_focus (GtkWidget       *widget,
           GtkDirectionType direction)
{
  Foo        *foo  = FOO (widget);
  FooPrivate *priv = foo->priv;
  gint        focus_row;
  gboolean    have_focus = FALSE;

  focus_row = priv->focus_row;

  if (!gtk_widget_has_focus (widget))
    gtk_widget_grab_focus (widget);

  valid = gtk_tree_model_iter_nth_child (priv->model, &iter, NULL, priv->focus_row);
  while (valid)
    {
      gtk_cell_area_apply_attributes (priv->area, priv->model, &iter, FALSE, FALSE);

      if (gtk_cell_area_focus (priv->area, direction))
        {
           priv->focus_row = focus_row;
           have_focus = TRUE;
           break;
        }
      else
        {
          if (direction == GTK_DIR_RIGHT ||
              direction == GTK_DIR_LEFT)
            break;
          else if (direction == GTK_DIR_UP ||
                   direction == GTK_DIR_TAB_BACKWARD)
           {
              if (focus_row == 0)
                break;
              else
               {
                  focus_row--;
                  valid = gtk_tree_model_iter_nth_child (priv->model, &iter, NULL, focus_row);
               }
            }
          else
            {
              if (focus_row == last_row)
                break;
              else
                {
                  focus_row++;
                  valid = gtk_tree_model_iter_next (priv->model, &iter);
                }
            }
        }
    }
    return have_focus;
}
```

Note that the layouting widget is responsible for matching the
`DirectionType` values to the way it lays out its cells.

# Cell Properties

The `CellArea` introduces cell properties for ``GtkCellRenderers``
in very much the same way that `Container` introduces
[child properties][child-properties]
for ``GtkWidgets``. This provides some general interfaces for defining
the relationship cell areas have with their cells. For instance in a
`CellAreaBox` a cell might “expand” and receive extra space when
the area is allocated more than its full natural request, or a cell
might be configured to “align” with adjacent rows which were requested
and rendered with the same `CellAreaContext`.

Use `CellAreaClass::install_cell_property` to install cell
properties for a cell area class and `CellAreaClass::find_cell_property`
or `CellAreaClass::list_cell_properties` to get information about
existing cell properties.

To set the value of a cell property, use `CellArea::cell_set_property`,
`CellAreaExt::cell_set` or `CellAreaExt::cell_set_valist`. To obtain
the value of a cell property, use `CellArea::cell_get_property`,
`CellAreaExt::cell_get` or `CellAreaExt::cell_get_valist`.

# Implements

[`CellAreaExt`](trait.CellAreaExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`CellLayoutExt`](trait.CellLayoutExt.html)
<!-- trait CellAreaExt -->
Trait containing all `CellArea` methods.

# Implementors

[`CellAreaBox`](struct.CellAreaBox.html), [`CellArea`](struct.CellArea.html)
<!-- trait CellAreaExt::fn activate -->
Activates `self`, usually by activating the currently focused
cell, however some subclasses which embed widgets in the area
can also activate a widget if it currently has the focus.
## `context`
the `CellAreaContext` in context with the current row data
## `widget`
the `Widget` that `self` is rendering on
## `cell_area`
the size and location of `self` relative to `widget`’s allocation
## `flags`
the `CellRendererState` flags for `self` for this row of data.
## `edit_only`
if `true` then only cell renderers that are `CellRendererMode::Editable`
 will be activated.

# Returns

Whether `self` was successfully activated.
<!-- trait CellAreaExt::fn activate_cell -->
This is used by `CellArea` subclasses when handling events
to activate cells, the base `CellArea` class activates cells
for keyboard events for free in its own `CellArea`->`activate`
implementation.
## `widget`
the `Widget` that `self` is rendering onto
## `renderer`
the `CellRenderer` in `self` to activate
## `event`
the ``GdkEvent`` for which cell activation should occur
## `cell_area`
the `gdk::Rectangle` in `widget` relative coordinates
 of `renderer` for the current row.
## `flags`
the `CellRendererState` for `renderer`

# Returns

whether cell activation was successful
<!-- trait CellAreaExt::fn add -->
Adds `renderer` to `self` with the default child cell properties.
## `renderer`
the `CellRenderer` to add to `self`
<!-- trait CellAreaExt::fn add_focus_sibling -->
Adds `sibling` to `renderer`’s focusable area, focus will be drawn
around `renderer` and all of its siblings if `renderer` can
focus for a given row.

Events handled by focus siblings can also activate the given
focusable `renderer`.
## `renderer`
the `CellRenderer` expected to have focus
## `sibling`
the `CellRenderer` to add to `renderer`’s focus area
<!-- trait CellAreaExt::fn add_with_properties -->
Adds `renderer` to `self`, setting cell properties at the same time.
See `CellAreaExt::add` and `CellAreaExt::cell_set` for more details.
## `renderer`
a `CellRenderer` to be placed inside `self`
## `first_prop_name`
the name of the first cell property to set
<!-- trait CellAreaExt::fn apply_attributes -->
Applies any connected attributes to the renderers in
`self` by pulling the values from `tree_model`.
## `tree_model`
the `TreeModel` to pull values from
## `iter`
the `TreeIter` in `tree_model` to apply values for
## `is_expander`
whether `iter` has children
## `is_expanded`
whether `iter` is expanded in the view and
 children are visible
<!-- trait CellAreaExt::fn attribute_connect -->
Connects an `attribute` to apply values from `column` for the
`TreeModel` in use.
## `renderer`
the `CellRenderer` to connect an attribute for
## `attribute`
the attribute name
## `column`
the `TreeModel` column to fetch attribute values from
<!-- trait CellAreaExt::fn attribute_disconnect -->
Disconnects `attribute` for the `renderer` in `self` so that
attribute will no longer be updated with values from the
model.
## `renderer`
the `CellRenderer` to disconnect an attribute for
## `attribute`
the attribute name
<!-- trait CellAreaExt::fn attribute_get_column -->
Returns the model column that an attribute has been mapped to,
or -1 if the attribute is not mapped.

Feature: `v3_14`

## `renderer`
a `CellRenderer`
## `attribute`
an attribute on the renderer

# Returns

the model column, or -1
<!-- trait CellAreaExt::fn cell_get -->
Gets the values of one or more cell properties for `renderer` in `self`.
## `renderer`
a `CellRenderer` which is inside `self`
## `first_prop_name`
the name of the first cell property to get
<!-- trait CellAreaExt::fn cell_get_property -->
Gets the value of a cell property for `renderer` in `self`.
## `renderer`
a `CellRenderer` inside `self`
## `property_name`
the name of the property to get
## `value`
a location to return the value
<!-- trait CellAreaExt::fn cell_get_valist -->
Gets the values of one or more cell properties for `renderer` in `self`.
## `renderer`
a `CellRenderer` inside `self`
## `first_property_name`
the name of the first property to get
## `var_args`
return location for the first property, followed
 optionally by more name/return location pairs, followed by `None`
<!-- trait CellAreaExt::fn cell_set -->
Sets one or more cell properties for `cell` in `self`.
## `renderer`
a `CellRenderer` which is a cell inside `self`
## `first_prop_name`
the name of the first cell property to set
<!-- trait CellAreaExt::fn cell_set_property -->
Sets a cell property for `renderer` in `self`.
## `renderer`
a `CellRenderer` inside `self`
## `property_name`
the name of the cell property to set
## `value`
the value to set the cell property to
<!-- trait CellAreaExt::fn cell_set_valist -->
Sets one or more cell properties for `renderer` in `self`.
## `renderer`
a `CellRenderer` which inside `self`
## `first_property_name`
the name of the first cell property to set
## `var_args`
a `None`-terminated list of property names and values, starting
 with `first_prop_name`
<!-- trait CellAreaExt::fn copy_context -->
This is sometimes needed for cases where rows need to share
alignments in one orientation but may be separately grouped
in the opposing orientation.

For instance, `IconView` creates all icons (rows) to have
the same width and the cells theirin to have the same
horizontal alignments. However each row of icons may have
a separate collective height. `IconView` uses this to
request the heights of each row based on a context which
was already used to request all the row widths that are
to be displayed.
## `context`
the `CellAreaContext` to copy

# Returns

a newly created `CellAreaContext` copy of `context`.
<!-- trait CellAreaExt::fn create_context -->
Creates a `CellAreaContext` to be used with `self` for
all purposes. `CellAreaContext` stores geometry information
for rows for which it was operated on, it is important to use
the same context for the same row of data at all times (i.e.
one should render and handle events with the same `CellAreaContext`
which was used to request the size of those rows of data).

# Returns

a newly created `CellAreaContext` which can be used with `self`.
<!-- trait CellAreaExt::fn event -->
Delegates event handling to a `CellArea`.
## `context`
the `CellAreaContext` for this row of data.
## `widget`
the `Widget` that `self` is rendering to
## `event`
the ``GdkEvent`` to handle
## `cell_area`
the `widget` relative coordinates for `self`
## `flags`
the `CellRendererState` for `self` in this row.

# Returns

`true` if the event was handled by `self`.
<!-- trait CellAreaExt::fn focus -->
This should be called by the `self`’s owning layout widget
when focus is to be passed to `self`, or moved within `self`
for a given `direction` and row data.

Implementing `CellArea` classes should implement this
method to receive and navigate focus in its own way particular
to how it lays out cells.
## `direction`
the `DirectionType`

# Returns

`true` if focus remains inside `self` as a result of this call.
<!-- trait CellAreaExt::fn foreach -->
Calls `callback` for every `CellRenderer` in `self`.
## `callback`
the ``GtkCellCallback`` to call
## `callback_data`
user provided data pointer
<!-- trait CellAreaExt::fn foreach_alloc -->
Calls `callback` for every `CellRenderer` in `self` with the
allocated rectangle inside `cell_area`.
## `context`
the `CellAreaContext` for this row of data.
## `widget`
the `Widget` that `self` is rendering to
## `cell_area`
the `widget` relative coordinates and size for `self`
## `background_area`
the `widget` relative coordinates of the background area
## `callback`
the ``GtkCellAllocCallback`` to call
## `callback_data`
user provided data pointer
<!-- trait CellAreaExt::fn get_cell_allocation -->
Derives the allocation of `renderer` inside `self` if `self`
were to be renderered in `cell_area`.
## `context`
the `CellAreaContext` used to hold sizes for `self`.
## `widget`
the `Widget` that `self` is rendering on
## `renderer`
the `CellRenderer` to get the allocation for
## `cell_area`
the whole allocated area for `self` in `widget`
 for this row
## `allocation`
where to store the allocation for `renderer`
<!-- trait CellAreaExt::fn get_cell_at_position -->
Gets the `CellRenderer` at `x` and `y` coordinates inside `self` and optionally
returns the full cell allocation for it inside `cell_area`.
## `context`
the `CellAreaContext` used to hold sizes for `self`.
## `widget`
the `Widget` that `self` is rendering on
## `cell_area`
the whole allocated area for `self` in `widget`
 for this row
## `x`
the x position
## `y`
the y position
## `alloc_area`
where to store the inner allocated area of the
 returned cell renderer, or `None`.

# Returns

the `CellRenderer` at `x` and `y`.
<!-- trait CellAreaExt::fn get_current_path_string -->
Gets the current `TreePath` string for the currently
applied `TreeIter`, this is implicitly updated when
`CellAreaExt::apply_attributes` is called and can be
used to interact with renderers from `CellArea`
subclasses.

# Returns

The current `TreePath` string for the current
attributes applied to `self`. This string belongs to the area and
should not be freed.
<!-- trait CellAreaExt::fn get_edit_widget -->
Gets the `CellEditable` widget currently used
to edit the currently edited cell.

# Returns

The currently active `CellEditable` widget
<!-- trait CellAreaExt::fn get_edited_cell -->
Gets the `CellRenderer` in `self` that is currently
being edited.

# Returns

The currently edited `CellRenderer`
<!-- trait CellAreaExt::fn get_focus_cell -->
Retrieves the currently focused cell for `self`

# Returns

the currently focused cell in `self`.
<!-- trait CellAreaExt::fn get_focus_from_sibling -->
Gets the `CellRenderer` which is expected to be focusable
for which `renderer` is, or may be a sibling.

This is handy for `CellArea` subclasses when handling events,
after determining the renderer at the event location it can
then chose to activate the focus cell for which the event
cell may have been a sibling.
## `renderer`
the `CellRenderer`

# Returns

the `CellRenderer` for which `renderer`
 is a sibling, or `None`.
<!-- trait CellAreaExt::fn get_focus_siblings -->
Gets the focus sibling cell renderers for `renderer`.
## `renderer`
the `CellRenderer` expected to have focus

# Returns

A `glib::List` of ``GtkCellRenderers``.
 The returned list is internal and should not be freed.
<!-- trait CellAreaExt::fn get_preferred_height -->
Retrieves a cell area’s initial minimum and natural height.

`self` will store some geometrical information in `context` along the way;
when requesting sizes over an arbitrary number of rows, it’s not important
to check the `minimum_height` and `natural_height` of this call but rather to
consult `CellAreaContextExt::get_preferred_height` after a series of
requests.
## `context`
the `CellAreaContext` to perform this request with
## `widget`
the `Widget` where `self` will be rendering
## `minimum_height`
location to store the minimum height, or `None`
## `natural_height`
location to store the natural height, or `None`
<!-- trait CellAreaExt::fn get_preferred_height_for_width -->
Retrieves a cell area’s minimum and natural height if it would be given
the specified `width`.

`self` stores some geometrical information in `context` along the way
while calling `CellAreaExt::get_preferred_width`. It’s important to
perform a series of `CellAreaExt::get_preferred_width` requests with
`context` first and then call `CellAreaExt::get_preferred_height_for_width`
on each cell area individually to get the height for width of each
fully requested row.

If at some point, the width of a single row changes, it should be
requested with `CellAreaExt::get_preferred_width` again and then
the full width of the requested rows checked again with
`CellAreaContextExt::get_preferred_width`.
## `context`
the `CellAreaContext` which has already been requested for widths.
## `widget`
the `Widget` where `self` will be rendering
## `width`
the width for which to check the height of this area
## `minimum_height`
location to store the minimum height, or `None`
## `natural_height`
location to store the natural height, or `None`
<!-- trait CellAreaExt::fn get_preferred_width -->
Retrieves a cell area’s initial minimum and natural width.

`self` will store some geometrical information in `context` along the way;
when requesting sizes over an arbitrary number of rows, it’s not important
to check the `minimum_width` and `natural_width` of this call but rather to
consult `CellAreaContextExt::get_preferred_width` after a series of
requests.
## `context`
the `CellAreaContext` to perform this request with
## `widget`
the `Widget` where `self` will be rendering
## `minimum_width`
location to store the minimum width, or `None`
## `natural_width`
location to store the natural width, or `None`
<!-- trait CellAreaExt::fn get_preferred_width_for_height -->
Retrieves a cell area’s minimum and natural width if it would be given
the specified `height`.

`self` stores some geometrical information in `context` along the way
while calling `CellAreaExt::get_preferred_height`. It’s important to
perform a series of `CellAreaExt::get_preferred_height` requests with
`context` first and then call `CellAreaExt::get_preferred_width_for_height`
on each cell area individually to get the height for width of each
fully requested row.

If at some point, the height of a single row changes, it should be
requested with `CellAreaExt::get_preferred_height` again and then
the full height of the requested rows checked again with
`CellAreaContextExt::get_preferred_height`.
## `context`
the `CellAreaContext` which has already been requested for widths.
## `widget`
the `Widget` where `self` will be rendering
## `height`
the height for which to check the width of this area
## `minimum_width`
location to store the minimum width, or `None`
## `natural_width`
location to store the natural width, or `None`
<!-- trait CellAreaExt::fn get_request_mode -->
Gets whether the area prefers a height-for-width layout
or a width-for-height layout.

# Returns

The `SizeRequestMode` preferred by `self`.
<!-- trait CellAreaExt::fn has_renderer -->
Checks if `self` contains `renderer`.
## `renderer`
the `CellRenderer` to check

# Returns

`true` if `renderer` is in the `self`.
<!-- trait CellAreaExt::fn inner_cell_area -->
This is a convenience function for `CellArea` implementations
to get the inner area where a given `CellRenderer` will be
rendered. It removes any padding previously added by `CellAreaExt::request_renderer`.
## `widget`
the `Widget` that `self` is rendering onto
## `cell_area`
the `widget` relative coordinates where one of `self`’s cells
 is to be placed
## `inner_area`
the return location for the inner cell area
<!-- trait CellAreaExt::fn is_activatable -->
Returns whether the area can do anything when activated,
after applying new attributes to `self`.

# Returns

whether `self` can do anything when activated.
<!-- trait CellAreaExt::fn is_focus_sibling -->
Returns whether `sibling` is one of `renderer`’s focus siblings
(see `CellAreaExt::add_focus_sibling`).
## `renderer`
the `CellRenderer` expected to have focus
## `sibling`
the `CellRenderer` to check against `renderer`’s sibling list

# Returns

`true` if `sibling` is a focus sibling of `renderer`
<!-- trait CellAreaExt::fn remove -->
Removes `renderer` from `self`.
## `renderer`
the `CellRenderer` to remove from `self`
<!-- trait CellAreaExt::fn remove_focus_sibling -->
Removes `sibling` from `renderer`’s focus sibling list
(see `CellAreaExt::add_focus_sibling`).
## `renderer`
the `CellRenderer` expected to have focus
## `sibling`
the `CellRenderer` to remove from `renderer`’s focus area
<!-- trait CellAreaExt::fn render -->
Renders `self`’s cells according to `self`’s layout onto `widget` at
the given coordinates.
## `context`
the `CellAreaContext` for this row of data.
## `widget`
the `Widget` that `self` is rendering to
## `cr`
the `cairo::Context` to render with
## `background_area`
the `widget` relative coordinates for `self`’s background
## `cell_area`
the `widget` relative coordinates for `self`
## `flags`
the `CellRendererState` for `self` in this row.
## `paint_focus`
whether `self` should paint focus on focused cells for focused rows or not.
<!-- trait CellAreaExt::fn request_renderer -->
This is a convenience function for `CellArea` implementations
to request size for cell renderers. It’s important to use this
function to request size and then use `CellAreaExt::inner_cell_area`
at render and event time since this function will add padding
around the cell for focus painting.
## `renderer`
the `CellRenderer` to request size for
## `orientation`
the `Orientation` in which to request size
## `widget`
the `Widget` that `self` is rendering onto
## `for_size`
the allocation contextual size to request for, or -1 if
the base request for the orientation is to be returned.
## `minimum_size`
location to store the minimum size, or `None`
## `natural_size`
location to store the natural size, or `None`
<!-- trait CellAreaExt::fn set_focus_cell -->
Explicitly sets the currently focused cell to `renderer`.

This is generally called by implementations of
`CellAreaClass.focus`() or `CellAreaClass.event`(),
however it can also be used to implement functions such
as `TreeViewExt::set_cursor_on_cell`.
## `renderer`
the `CellRenderer` to give focus to
<!-- trait CellAreaExt::fn stop_editing -->
Explicitly stops the editing of the currently edited cell.

If `canceled` is `true`, the currently edited cell renderer
will emit the ::editing-canceled signal, otherwise the
the ::editing-done signal will be emitted on the current
edit widget.

See `CellAreaExt::get_edited_cell` and `CellAreaExt::get_edit_widget`.
## `canceled`
whether editing was canceled.
<!-- trait CellAreaExt::fn connect_add_editable -->
Indicates that editing has started on `renderer` and that `editable`
should be added to the owning cell-layouting widget at `cell_area`.
## `renderer`
the `CellRenderer` that started the edited
## `editable`
the `CellEditable` widget to add
## `cell_area`
the `Widget` relative `gdk::Rectangle` coordinates
 where `editable` should be added
## `path`
the `TreePath` string this edit was initiated for
<!-- trait CellAreaExt::fn connect_apply_attributes -->
This signal is emitted whenever applying attributes to `area` from `model`
## `model`
the `TreeModel` to apply the attributes from
## `iter`
the `TreeIter` indicating which row to apply the attributes of
## `is_expander`
whether the view shows children for this row
## `is_expanded`
whether the view is currently showing the children of this row
<!-- trait CellAreaExt::fn connect_focus_changed -->
Indicates that focus changed on this `area`. This signal
is emitted either as a result of focus handling or event
handling.

It's possible that the signal is emitted even if the
currently focused renderer did not change, this is
because focus may change to the same renderer in the
same cell area for a different row of data.
## `renderer`
the `CellRenderer` that has focus
## `path`
the current `TreePath` string set for `area`
<!-- trait CellAreaExt::fn connect_remove_editable -->
Indicates that editing finished on `renderer` and that `editable`
should be removed from the owning cell-layouting widget.
## `renderer`
the `CellRenderer` that finished editeding
## `editable`
the `CellEditable` widget to remove
<!-- trait CellAreaExt::fn get_property_edit-widget -->
The widget currently editing the edited cell

This property is read-only and only changes as
a result of a call `CellAreaExt::activate_cell`.
<!-- trait CellAreaExt::fn get_property_edited-cell -->
The cell in the area that is currently edited

This property is read-only and only changes as
a result of a call `CellAreaExt::activate_cell`.
<!-- trait CellAreaExt::fn get_property_focus-cell -->
The cell in the area that currently has focus
<!-- trait CellAreaExt::fn set_property_focus-cell -->
The cell in the area that currently has focus
<!-- struct CellAreaBox -->
The `CellAreaBox` renders cell renderers into a row or a column
depending on its `Orientation`.

`CellAreaBox` uses a notion of packing. Packing
refers to adding cell renderers with reference to a particular position
in a `CellAreaBox`. There are two reference positions: the
start and the end of the box.
When the `CellAreaBox` is oriented in the `Orientation::Vertical`
orientation, the start is defined as the top of the box and the end is
defined as the bottom. In the `Orientation::Horizontal` orientation
start is defined as the left side and the end is defined as the right
side.

Alignments of ``GtkCellRenderers`` rendered in adjacent rows can be
configured by configuring the `CellAreaBox` align child cell property
with `CellArea::cell_set_property` or by specifying the "align"
argument to `CellAreaBoxExt::pack_start` and `CellAreaBoxExt::pack_end`.

# Implements

[`CellAreaBoxExt`](trait.CellAreaBoxExt.html), [`CellAreaExt`](trait.CellAreaExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`CellLayoutExt`](trait.CellLayoutExt.html), [`OrientableExt`](trait.OrientableExt.html)
<!-- trait CellAreaBoxExt -->
Trait containing all `CellAreaBox` methods.

# Implementors

[`CellAreaBox`](struct.CellAreaBox.html)
<!-- impl CellAreaBox::fn new -->
Creates a new `CellAreaBox`.

# Returns

a newly created `CellAreaBox`
<!-- trait CellAreaBoxExt::fn get_spacing -->
Gets the spacing added between cell renderers.

# Returns

the space added between cell renderers in `self`.
<!-- trait CellAreaBoxExt::fn pack_end -->
Adds `renderer` to `self`, packed with reference to the end of `self`.

The `renderer` is packed after (away from end of) any other
`CellRenderer` packed with reference to the end of `self`.
## `renderer`
the `CellRenderer` to add
## `expand`
whether `renderer` should receive extra space when the area receives
more than its natural size
## `align`
whether `renderer` should be aligned in adjacent rows
## `fixed`
whether `renderer` should have the same size in all rows
<!-- trait CellAreaBoxExt::fn pack_start -->
Adds `renderer` to `self`, packed with reference to the start of `self`.

The `renderer` is packed after any other `CellRenderer` packed
with reference to the start of `self`.
## `renderer`
the `CellRenderer` to add
## `expand`
whether `renderer` should receive extra space when the area receives
more than its natural size
## `align`
whether `renderer` should be aligned in adjacent rows
## `fixed`
whether `renderer` should have the same size in all rows
<!-- trait CellAreaBoxExt::fn set_spacing -->
Sets the spacing to add between cell renderers in `self`.
## `spacing`
the space to add between ``GtkCellRenderers``
<!-- trait CellAreaBoxExt::fn get_property_spacing -->
The amount of space to reserve between cells.
<!-- trait CellAreaBoxExt::fn set_property_spacing -->
The amount of space to reserve between cells.
<!-- struct CellAreaContext -->
The `CellAreaContext` object is created by a given `CellArea`
implementation via its `CellAreaClass.create_context`() virtual
method and is used to store cell sizes and alignments for a series of
`TreeModel` rows that are requested and rendered in the same context.

`CellLayout` widgets can create any number of contexts in which to
request and render groups of data rows. However, it’s important that the
same context which was used to request sizes for a given `TreeModel`
row also be used for the same row when calling other `CellArea` APIs
such as `CellAreaExt::render` and `CellAreaExt::event`.

# Implements

[`CellAreaContextExt`](trait.CellAreaContextExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait CellAreaContextExt -->
Trait containing all `CellAreaContext` methods.

# Implementors

[`CellAreaContext`](struct.CellAreaContext.html)
<!-- trait CellAreaContextExt::fn allocate -->
Allocates a width and/or a height for all rows which are to be
rendered with `self`.

Usually allocation is performed only horizontally or sometimes
vertically since a group of rows are usually rendered side by
side vertically or horizontally and share either the same width
or the same height. Sometimes they are allocated in both horizontal
and vertical orientations producing a homogeneous effect of the
rows. This is generally the case for `TreeView` when
`TreeView:fixed-height-mode` is enabled.

Since 3.0
## `width`
the allocated width for all `TreeModel` rows rendered
 with `self`, or -1.
## `height`
the allocated height for all `TreeModel` rows rendered
 with `self`, or -1.
<!-- trait CellAreaContextExt::fn get_allocation -->
Fetches the current allocation size for `self`.

If the context was not allocated in width or height, or if the
context was recently reset with `CellAreaContextExt::reset`,
the returned value will be -1.
## `width`
location to store the allocated width, or `None`
## `height`
location to store the allocated height, or `None`
<!-- trait CellAreaContextExt::fn get_area -->
Fetches the `CellArea` this `self` was created by.

This is generally unneeded by layouting widgets; however,
it is important for the context implementation itself to
fetch information about the area it is being used for.

For instance at `CellAreaContextClass.allocate`() time
it’s important to know details about any cell spacing
that the `CellArea` is configured with in order to
compute a proper allocation.

# Returns

the `CellArea` this context was created by.
<!-- trait CellAreaContextExt::fn get_preferred_height -->
Gets the accumulative preferred height for all rows which have been
requested with this context.

After `CellAreaContextExt::reset` is called and/or before ever
requesting the size of a `CellArea`, the returned values are 0.
## `minimum_height`
location to store the minimum height,
 or `None`
## `natural_height`
location to store the natural height,
 or `None`
<!-- trait CellAreaContextExt::fn get_preferred_height_for_width -->
Gets the accumulative preferred height for `width` for all rows
which have been requested for the same said `width` with this context.

After `CellAreaContextExt::reset` is called and/or before ever
requesting the size of a `CellArea`, the returned values are -1.
## `width`
a proposed width for allocation
## `minimum_height`
location to store the minimum height,
 or `None`
## `natural_height`
location to store the natural height,
 or `None`
<!-- trait CellAreaContextExt::fn get_preferred_width -->
Gets the accumulative preferred width for all rows which have been
requested with this context.

After `CellAreaContextExt::reset` is called and/or before ever
requesting the size of a `CellArea`, the returned values are 0.
## `minimum_width`
location to store the minimum width,
 or `None`
## `natural_width`
location to store the natural width,
 or `None`
<!-- trait CellAreaContextExt::fn get_preferred_width_for_height -->
Gets the accumulative preferred width for `height` for all rows which
have been requested for the same said `height` with this context.

After `CellAreaContextExt::reset` is called and/or before ever
requesting the size of a `CellArea`, the returned values are -1.
## `height`
a proposed height for allocation
## `minimum_width`
location to store the minimum width,
 or `None`
## `natural_width`
location to store the natural width,
 or `None`
<!-- trait CellAreaContextExt::fn push_preferred_height -->
Causes the minimum and/or natural height to grow if the new
proposed sizes exceed the current minimum and natural height.

This is used by `CellAreaContext` implementations during
the request process over a series of `TreeModel` rows to
progressively push the requested height over a series of
`CellAreaExt::get_preferred_height` requests.
## `minimum_height`
the proposed new minimum height for `self`
## `natural_height`
the proposed new natural height for `self`
<!-- trait CellAreaContextExt::fn push_preferred_width -->
Causes the minimum and/or natural width to grow if the new
proposed sizes exceed the current minimum and natural width.

This is used by `CellAreaContext` implementations during
the request process over a series of `TreeModel` rows to
progressively push the requested width over a series of
`CellAreaExt::get_preferred_width` requests.
## `minimum_width`
the proposed new minimum width for `self`
## `natural_width`
the proposed new natural width for `self`
<!-- trait CellAreaContextExt::fn reset -->
Resets any previously cached request and allocation
data.

When underlying `TreeModel` data changes its
important to reset the context if the content
size is allowed to shrink. If the content size
is only allowed to grow (this is usually an option
for views rendering large data stores as a measure
of optimization), then only the row that changed
or was inserted needs to be (re)requested with
`CellAreaExt::get_preferred_width`.

When the new overall size of the context requires
that the allocated size changes (or whenever this
allocation changes at all), the variable row
sizes need to be re-requested for every row.

For instance, if the rows are displayed all with
the same width from top to bottom then a change
in the allocated width necessitates a recalculation
of all the displayed row heights using
`CellAreaExt::get_preferred_height_for_width`.

Since 3.0
<!-- trait CellAreaContextExt::fn get_property_area -->
The `CellArea` this context was created by
<!-- trait CellAreaContextExt::fn set_property_area -->
The `CellArea` this context was created by
<!-- trait CellAreaContextExt::fn get_property_minimum-height -->
The minimum height for the `CellArea` in this context
for all `TreeModel` rows that this context was requested
for using `CellAreaExt::get_preferred_height`.
<!-- trait CellAreaContextExt::fn get_property_minimum-width -->
The minimum width for the `CellArea` in this context
for all `TreeModel` rows that this context was requested
for using `CellAreaExt::get_preferred_width`.
<!-- trait CellAreaContextExt::fn get_property_natural-height -->
The natural height for the `CellArea` in this context
for all `TreeModel` rows that this context was requested
for using `CellAreaExt::get_preferred_height`.
<!-- trait CellAreaContextExt::fn get_property_natural-width -->
The natural width for the `CellArea` in this context
for all `TreeModel` rows that this context was requested
for using `CellAreaExt::get_preferred_width`.
<!-- struct CellEditable -->
The `CellEditable` interface must be implemented for widgets to be usable
when editing the contents of a `TreeView` cell.

# Implements

[`CellEditableExt`](trait.CellEditableExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait CellEditableExt -->
Trait containing all `CellEditable` methods.

# Implementors

[`CellEditable`](struct.CellEditable.html), [`ComboBoxText`](struct.ComboBoxText.html), [`ComboBox`](struct.ComboBox.html), [`Entry`](struct.Entry.html), [`SearchEntry`](struct.SearchEntry.html), [`SpinButton`](struct.SpinButton.html)
<!-- trait CellEditableExt::fn editing_done -->
Emits the `CellEditable::editing-done` signal.
<!-- trait CellEditableExt::fn remove_widget -->
Emits the `CellEditable::remove-widget` signal.
<!-- trait CellEditableExt::fn start_editing -->
Begins editing on a `self`. `event` is the ``GdkEvent`` that began
the editing process. It may be `None`, in the instance that editing was
initiated through programatic means.
## `event`
A ``GdkEvent``, or `None`
<!-- trait CellEditableExt::fn connect_editing_done -->
This signal is a sign for the cell renderer to update its
value from the `cell_editable`.

Implementations of `CellEditable` are responsible for
emitting this signal when they are done editing, e.g.
`Entry` is emitting it when the user presses Enter.

`CellEditable::editing_done` is a convenience method
for emitting `CellEditable::editing-done`.
<!-- trait CellEditableExt::fn connect_remove_widget -->
This signal is meant to indicate that the cell is finished
editing, and the widget may now be destroyed.

Implementations of `CellEditable` are responsible for
emitting this signal when they are done editing. It must
be emitted after the `CellEditable::editing-done` signal,
to give the cell renderer a chance to update the cell's value
before the widget is removed.

`CellEditable::remove_widget` is a convenience method
for emitting `CellEditable::remove-widget`.
<!-- trait CellEditableExt::fn get_property_editing-canceled -->
Indicates whether editing on the cell has been canceled.
<!-- trait CellEditableExt::fn set_property_editing-canceled -->
Indicates whether editing on the cell has been canceled.
<!-- struct CellLayout -->
`CellLayout` is an interface to be implemented by all objects which
want to provide a `TreeViewColumn` like API for packing cells,
setting attributes and data funcs.

One of the notable features provided by implementations of
`CellLayout` are attributes. Attributes let you set the properties
in flexible ways. They can just be set to constant values like regular
properties. But they can also be mapped to a column of the underlying
tree model with `CellLayout::set_attributes`, which means that the value
of the attribute can change from cell to cell as they are rendered by
the cell renderer. Finally, it is possible to specify a function with
`CellLayout::set_cell_data_func` that is called to determine the
value of the attribute for each cell that is rendered.

# `GtkCellLayouts` as `Buildable`

Implementations of `CellLayout` which also implement the `Buildable`
interface (`CellView`, `IconView`, `ComboBox`,
`EntryCompletion`, `TreeViewColumn`) accept `CellRenderer` objects
as `<child>` elements in UI definitions. They support a custom `<attributes>`
element for their children, which can contain multiple `<attribute>`
elements. Each `<attribute>` element has a name attribute which specifies
a property of the cell renderer; the content of the element is the
attribute value.

This is an example of a UI definition fragment specifying attributes:

```C
combo = g_object_new (GTK_TYPE_COMBO_BOX, "cell-area", my_cell_area, NULL);
```

to use a custom cell area with a combo box. But construct properties
are only initialized after instance `init`
functions have run, which means that using functions which rely on
the existence of the cell area in your subclass’ `init` function will
cause the default cell area to be instantiated. In this case, a provided
construct property value will be ignored (with a warning, to alert
you to the problem).


```C
static void
my_combo_box_init (MyComboBox *b)
{
  GtkCellRenderer *cell;

  cell = gtk_cell_renderer_pixbuf_new ();
  // The following call causes the default cell area for combo boxes,
  // a GtkCellAreaBox, to be instantiated
  gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (b), cell, FALSE);
  ...
}

GtkWidget *
my_combo_box_new (GtkCellArea *area)
{
  // This call is going to cause a warning about area being ignored
  return g_object_new (MY_TYPE_COMBO_BOX, "cell-area", area, NULL);
}
```

If supporting alternative cell areas with your derived widget is
not important, then this does not have to concern you. If you want
to support alternative cell areas, you can do so by moving the
problematic calls out of `init` and into a `constructor`
for your class.

# Implements

[`CellLayoutExt`](trait.CellLayoutExt.html)
<!-- trait CellLayoutExt -->
Trait containing all `CellLayout` methods.

# Implementors

[`CellAreaBox`](struct.CellAreaBox.html), [`CellArea`](struct.CellArea.html), [`CellLayout`](struct.CellLayout.html), [`ComboBoxText`](struct.ComboBoxText.html), [`ComboBox`](struct.ComboBox.html), [`EntryCompletion`](struct.EntryCompletion.html), [`IconView`](struct.IconView.html), [`TreeViewColumn`](struct.TreeViewColumn.html)
<!-- trait CellLayoutExt::fn add_attribute -->
Adds an attribute mapping to the list in `self`.

The `column` is the column of the model to get a value from, and the
`attribute` is the parameter on `cell` to be set from the value. So for
example if column 2 of the model contains strings, you could have the
“text” attribute of a `CellRendererText` get its values from column 2.
## `cell`
a `CellRenderer`
## `attribute`
an attribute on the renderer
## `column`
the column position on the model to get the attribute from
<!-- trait CellLayoutExt::fn clear -->
Unsets all the mappings on all renderers on `self` and
removes all renderers from `self`.
<!-- trait CellLayoutExt::fn clear_attributes -->
Clears all existing attributes previously set with
`CellLayout::set_attributes`.
## `cell`
a `CellRenderer` to clear the attribute mapping on
<!-- trait CellLayoutExt::fn get_area -->
Returns the underlying `CellArea` which might be `self`
if called on a `CellArea` or might be `None` if no `CellArea`
is used by `self`.

# Returns

the cell area used by `self`,
or `None` in case no cell area is used.
<!-- trait CellLayoutExt::fn get_cells -->
Returns the cell renderers which have been added to `self`.

# Returns


 a list of cell renderers. The list, but not the renderers has
 been newly allocated and should be freed with `glib::List::free`
 when no longer needed.
<!-- trait CellLayoutExt::fn pack_end -->
Adds the `cell` to the end of `self`. If `expand` is `false`, then the
`cell` is allocated no more space than it needs. Any unused space is
divided evenly between cells for which `expand` is `true`.

Note that reusing the same cell renderer is not supported.
## `cell`
a `CellRenderer`
## `expand`
`true` if `cell` is to be given extra space allocated to `self`
<!-- trait CellLayoutExt::fn pack_start -->
Packs the `cell` into the beginning of `self`. If `expand` is `false`,
then the `cell` is allocated no more space than it needs. Any unused space
is divided evenly between cells for which `expand` is `true`.

Note that reusing the same cell renderer is not supported.
## `cell`
a `CellRenderer`
## `expand`
`true` if `cell` is to be given extra space allocated to `self`
<!-- trait CellLayoutExt::fn reorder -->
Re-inserts `cell` at `position`.

Note that `cell` has already to be packed into `self`
for this to function properly.
## `cell`
a `CellRenderer` to reorder
## `position`
new position to insert `cell` at
<!-- trait CellLayoutExt::fn set_attributes -->
Sets the attributes in list as the attributes of `self`.

The attributes should be in attribute/column order, as in
`CellLayout::add_attribute`. All existing attributes are
removed, and replaced with the new attributes.
## `cell`
a `CellRenderer`
<!-- trait CellLayoutExt::fn set_cell_data_func -->
Sets the ``GtkCellLayoutDataFunc`` to use for `self`.

This function is used instead of the standard attributes mapping
for setting the column value, and should set the value of `self`’s
cell renderer(s) as appropriate.

`func` may be `None` to remove a previously set function.
## `cell`
a `CellRenderer`
## `func`
the ``GtkCellLayoutDataFunc`` to use, or `None`
## `func_data`
user data for `func`
## `destroy`
destroy notify for `func_data`
<!-- struct CellRenderer -->
The `CellRenderer` is a base class of a set of objects used for
rendering a cell to a `cairo::Context`. These objects are used primarily by
the `TreeView` widget, though they aren’t tied to them in any
specific way. It is worth noting that `CellRenderer` is not a
`Widget` and cannot be treated as such.

The primary use of a `CellRenderer` is for drawing a certain graphical
elements on a `cairo::Context`. Typically, one cell renderer is used to
draw many cells on the screen. To this extent, it isn’t expected that a
CellRenderer keep any permanent state around. Instead, any state is set
just prior to use using `GObjects` property system. Then, the
cell is measured using `CellRenderer::get_size`. Finally, the cell
is rendered in the correct location using `CellRendererExt::render`.

There are a number of rules that must be followed when writing a new
`CellRenderer`. First and foremost, it’s important that a certain set
of properties will always yield a cell renderer of the same size,
barring a `Style` change. The `CellRenderer` also has a number of
generic properties that are expected to be honored by all children.

Beyond merely rendering a cell, cell renderers can optionally
provide active user interface elements. A cell renderer can be
“activatable” like `CellRendererToggle`,
which toggles when it gets activated by a mouse click, or it can be
“editable” like `CellRendererText`, which
allows the user to edit the text using a `Entry`.
To make a cell renderer activatable or editable, you have to
implement the `CellRendererClass.activate` or
`CellRendererClass.start_editing` virtual functions, respectively.

Many properties of `CellRenderer` and its subclasses have a
corresponding “set” property, e.g. “cell-background-set” corresponds
to “cell-background”. These “set” properties reflect whether a property
has been set or not. You should not set them independently.

# Implements

[`CellRendererExt`](trait.CellRendererExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait CellRendererExt -->
Trait containing all `CellRenderer` methods.

# Implementors

[`CellRendererPixbuf`](struct.CellRendererPixbuf.html), [`CellRendererProgress`](struct.CellRendererProgress.html), [`CellRendererSpinner`](struct.CellRendererSpinner.html), [`CellRendererText`](struct.CellRendererText.html), [`CellRendererToggle`](struct.CellRendererToggle.html), [`CellRenderer`](struct.CellRenderer.html)
<!-- trait CellRendererExt::fn activate -->
Passes an activate event to the cell renderer for possible processing.
Some cell renderers may use events; for example, `CellRendererToggle`
toggles when it gets a mouse click.
## `event`
a ``GdkEvent``
## `widget`
widget that received the event
## `path`
widget-dependent string representation of the event location;
 e.g. for `TreeView`, a string representation of `TreePath`
## `background_area`
background area as passed to `CellRendererExt::render`
## `cell_area`
cell area as passed to `CellRendererExt::render`
## `flags`
render flags

# Returns

`true` if the event was consumed/handled
<!-- trait CellRendererExt::fn get_aligned_area -->
Gets the aligned area used by `self` inside `cell_area`. Used for finding
the appropriate edit and focus rectangle.
## `widget`
the `Widget` this cell will be rendering to
## `flags`
render flags
## `cell_area`
cell area which would be passed to `CellRendererExt::render`
## `aligned_area`
the return location for the space inside `cell_area`
 that would acually be used to render.
<!-- trait CellRendererExt::fn get_alignment -->
Fills in `xalign` and `yalign` with the appropriate values of `self`.
## `xalign`
location to fill in with the x alignment of the cell, or `None`
## `yalign`
location to fill in with the y alignment of the cell, or `None`
<!-- trait CellRendererExt::fn get_fixed_size -->
Fills in `width` and `height` with the appropriate size of `self`.
## `width`
location to fill in with the fixed width of the cell, or `None`
## `height`
location to fill in with the fixed height of the cell, or `None`
<!-- trait CellRendererExt::fn get_padding -->
Fills in `xpad` and `ypad` with the appropriate values of `self`.
## `xpad`
location to fill in with the x padding of the cell, or `None`
## `ypad`
location to fill in with the y padding of the cell, or `None`
<!-- trait CellRendererExt::fn get_preferred_height -->
Retreives a renderer’s natural size when rendered to `widget`.
## `widget`
the `Widget` this cell will be rendering to
## `minimum_size`
location to store the minimum size, or `None`
## `natural_size`
location to store the natural size, or `None`
<!-- trait CellRendererExt::fn get_preferred_height_for_width -->
Retreives a cell renderers’s minimum and natural height if it were rendered to
`widget` with the specified `width`.
## `widget`
the `Widget` this cell will be rendering to
## `width`
the size which is available for allocation
## `minimum_height`
location for storing the minimum size, or `None`
## `natural_height`
location for storing the preferred size, or `None`
<!-- trait CellRendererExt::fn get_preferred_size -->
Retrieves the minimum and natural size of a cell taking
into account the widget’s preference for height-for-width management.
## `widget`
the `Widget` this cell will be rendering to
## `minimum_size`
location for storing the minimum size, or `None`
## `natural_size`
location for storing the natural size, or `None`
<!-- trait CellRendererExt::fn get_preferred_width -->
Retreives a renderer’s natural size when rendered to `widget`.
## `widget`
the `Widget` this cell will be rendering to
## `minimum_size`
location to store the minimum size, or `None`
## `natural_size`
location to store the natural size, or `None`
<!-- trait CellRendererExt::fn get_preferred_width_for_height -->
Retreives a cell renderers’s minimum and natural width if it were rendered to
`widget` with the specified `height`.
## `widget`
the `Widget` this cell will be rendering to
## `height`
the size which is available for allocation
## `minimum_width`
location for storing the minimum size, or `None`
## `natural_width`
location for storing the preferred size, or `None`
<!-- trait CellRendererExt::fn get_request_mode -->
Gets whether the cell renderer prefers a height-for-width layout
or a width-for-height layout.

# Returns

The `SizeRequestMode` preferred by this renderer.
<!-- trait CellRendererExt::fn get_sensitive -->
Returns the cell renderer’s sensitivity.

# Returns

`true` if the cell renderer is sensitive
<!-- trait CellRendererExt::fn get_size -->
Obtains the width and height needed to render the cell. Used by view
widgets to determine the appropriate size for the cell_area passed to
`CellRendererExt::render`. If `cell_area` is not `None`, fills in the
x and y offsets (if set) of the cell relative to this location.

Please note that the values set in `width` and `height`, as well as those
in `x_offset` and `y_offset` are inclusive of the xpad and ypad properties.

# Deprecated since 3.0

Use `CellRendererExt::get_preferred_size` instead.
## `widget`
the widget the renderer is rendering to
## `cell_area`
The area a cell will be allocated, or `None`
## `x_offset`
location to return x offset of cell relative to `cell_area`, or `None`
## `y_offset`
location to return y offset of cell relative to `cell_area`, or `None`
## `width`
location to return width needed to render a cell, or `None`
## `height`
location to return height needed to render a cell, or `None`
<!-- trait CellRendererExt::fn get_state -->
Translates the cell renderer state to `StateFlags`,
based on the cell renderer and widget sensitivity, and
the given `CellRendererState`.
## `widget`
a `Widget`, or `None`
## `cell_state`
cell renderer state

# Returns

the widget state flags applying to `self`
<!-- trait CellRendererExt::fn get_visible -->
Returns the cell renderer’s visibility.

# Returns

`true` if the cell renderer is visible
<!-- trait CellRendererExt::fn is_activatable -->
Checks whether the cell renderer can do something when activated.

# Returns

`true` if the cell renderer can do anything when activated
<!-- trait CellRendererExt::fn render -->
Invokes the virtual render function of the `CellRenderer`. The three
passed-in rectangles are areas in `cr`. Most renderers will draw within
`cell_area`; the xalign, yalign, xpad, and ypad fields of the `CellRenderer`
should be honored with respect to `cell_area`. `background_area` includes the
blank space around the cell, and also the area containing the tree expander;
so the `background_area` rectangles for all cells tile to cover the entire
`window`.
## `cr`
a cairo context to draw to
## `widget`
the widget owning `window`
## `background_area`
entire cell area (including tree expanders and maybe
 padding on the sides)
## `cell_area`
area normally rendered by a cell renderer
## `flags`
flags that affect rendering
<!-- trait CellRendererExt::fn set_alignment -->
Sets the renderer’s alignment within its available space.
## `xalign`
the x alignment of the cell renderer
## `yalign`
the y alignment of the cell renderer
<!-- trait CellRendererExt::fn set_fixed_size -->
Sets the renderer size to be explicit, independent of the properties set.
## `width`
the width of the cell renderer, or -1
## `height`
the height of the cell renderer, or -1
<!-- trait CellRendererExt::fn set_padding -->
Sets the renderer’s padding.
## `xpad`
the x padding of the cell renderer
## `ypad`
the y padding of the cell renderer
<!-- trait CellRendererExt::fn set_sensitive -->
Sets the cell renderer’s sensitivity.
## `sensitive`
the sensitivity of the cell
<!-- trait CellRendererExt::fn set_visible -->
Sets the cell renderer’s visibility.
## `visible`
the visibility of the cell
<!-- trait CellRendererExt::fn start_editing -->
Passes an activate event to the cell renderer for possible processing.
## `event`
a ``GdkEvent``
## `widget`
widget that received the event
## `path`
widget-dependent string representation of the event location;
 e.g. for `TreeView`, a string representation of `TreePath`
## `background_area`
background area as passed to `CellRendererExt::render`
## `cell_area`
cell area as passed to `CellRendererExt::render`
## `flags`
render flags

# Returns

A new `CellEditable`, or `None`
<!-- trait CellRendererExt::fn stop_editing -->
Informs the cell renderer that the editing is stopped.
If `canceled` is `true`, the cell renderer will emit the
`CellRenderer::editing-canceled` signal.

This function should be called by cell renderer implementations
in response to the `CellEditable::editing-done` signal of
`CellEditable`.
## `canceled`
`true` if the editing has been canceled
<!-- trait CellRendererExt::fn connect_editing_canceled -->
This signal gets emitted when the user cancels the process of editing a
cell. For example, an editable cell renderer could be written to cancel
editing when the user presses Escape.

See also: `CellRendererExt::stop_editing`.
<!-- trait CellRendererExt::fn connect_editing_started -->
This signal gets emitted when a cell starts to be edited.
The intended use of this signal is to do special setup
on `editable`, e.g. adding a `EntryCompletion` or setting
up additional columns in a `ComboBox`.

Note that GTK+ doesn't guarantee that cell renderers will
continue to use the same kind of widget for editing in future
releases, therefore you should check the type of `editable`
before doing any specific setup, as in the following example:

```C
static void
text_editing_started (GtkCellRenderer *cell,
                      GtkCellEditable *editable,
                      const gchar     *path,
                      gpointer         data)
{
  if (GTK_IS_ENTRY (editable))
    {
      GtkEntry *entry = GTK_ENTRY (editable);
      
      // ... create a GtkEntryCompletion
      
      gtk_entry_set_completion (entry, completion);
    }
}
```
## `editable`
the `CellEditable`
## `path`
the path identifying the edited cell
<!-- trait CellRendererExt::fn get_property_cell-background-gdk -->
Cell background as a `gdk::Color`

# Deprecated since 3.4

Use `CellRenderer:cell-background-rgba` instead.
<!-- trait CellRendererExt::fn set_property_cell-background-gdk -->
Cell background as a `gdk::Color`

# Deprecated since 3.4

Use `CellRenderer:cell-background-rgba` instead.
<!-- trait CellRendererExt::fn get_property_cell-background-rgba -->
Cell background as a `gdk::RGBA`
<!-- trait CellRendererExt::fn set_property_cell-background-rgba -->
Cell background as a `gdk::RGBA`
<!-- struct CellRendererAccel -->
`CellRendererAccel` displays a keyboard accelerator (i.e. a key
combination like `Control + a`). If the cell renderer is editable,
the accelerator can be changed by simply typing the new combination.

The `CellRendererAccel` cell renderer was added in GTK+ 2.10.

# Implements

[`CellRendererAccelExt`](trait.CellRendererAccelExt.html), [`CellRendererTextExt`](trait.CellRendererTextExt.html), [`CellRendererExt`](trait.CellRendererExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait CellRendererAccelExt -->
Trait containing all `CellRendererAccel` methods.

# Implementors

[`CellRendererAccel`](struct.CellRendererAccel.html)
<!-- impl CellRendererAccel::fn new -->
Creates a new `CellRendererAccel`.

# Returns

the new cell renderer
<!-- trait CellRendererAccelExt::fn connect_accel_cleared -->
Gets emitted when the user has removed the accelerator.
## `path_string`
the path identifying the row of the edited cell
<!-- trait CellRendererAccelExt::fn connect_accel_edited -->
Gets emitted when the user has selected a new accelerator.
## `path_string`
the path identifying the row of the edited cell
## `accel_key`
the new accelerator keyval
## `accel_mods`
the new acclerator modifier mask
## `hardware_keycode`
the keycode of the new accelerator
<!-- trait CellRendererAccelExt::fn get_property_accel-key -->
The keyval of the accelerator.
<!-- trait CellRendererAccelExt::fn set_property_accel-key -->
The keyval of the accelerator.
<!-- trait CellRendererAccelExt::fn get_property_accel-mode -->
Determines if the edited accelerators are GTK+ accelerators. If
they are, consumed modifiers are suppressed, only accelerators
accepted by GTK+ are allowed, and the accelerators are rendered
in the same way as they are in menus.

If the mode is set to `CellRendererAccelMode::ModifierTap`
then bare modifiers can be set as accelerators by tapping (ie:
pressing and immediately releasing) them.
<!-- trait CellRendererAccelExt::fn set_property_accel-mode -->
Determines if the edited accelerators are GTK+ accelerators. If
they are, consumed modifiers are suppressed, only accelerators
accepted by GTK+ are allowed, and the accelerators are rendered
in the same way as they are in menus.

If the mode is set to `CellRendererAccelMode::ModifierTap`
then bare modifiers can be set as accelerators by tapping (ie:
pressing and immediately releasing) them.
<!-- trait CellRendererAccelExt::fn get_property_accel-mods -->
The modifier mask of the accelerator.
<!-- trait CellRendererAccelExt::fn set_property_accel-mods -->
The modifier mask of the accelerator.
<!-- trait CellRendererAccelExt::fn get_property_keycode -->
The hardware keycode of the accelerator. Note that the hardware keycode is
only relevant if the key does not have a keyval. Normally, the keyboard
configuration should assign keyvals to all keys.
<!-- trait CellRendererAccelExt::fn set_property_keycode -->
The hardware keycode of the accelerator. Note that the hardware keycode is
only relevant if the key does not have a keyval. Normally, the keyboard
configuration should assign keyvals to all keys.
<!-- enum CellRendererAccelMode -->
Determines if the edited accelerators are GTK+ accelerators. If
they are, consumed modifiers are suppressed, only accelerators
accepted by GTK+ are allowed, and the accelerators are rendered
in the same way as they are in menus.
<!-- enum CellRendererAccelMode::variant Gtk -->
GTK+ accelerators mode
<!-- enum CellRendererAccelMode::variant Other -->
Other accelerator mode
GTK_CELL_RENDERER_ACCEL_MODE_MODIFIER_TAP: Bare modifiers mode
<!-- struct CellRendererCombo -->
`CellRendererCombo` renders text in a cell like `CellRendererText` from
which it is derived. But while `CellRendererText` offers a simple entry to
edit the text, `CellRendererCombo` offers a `ComboBox`
widget to edit the text. The values to display in the combo box are taken from
the tree model specified in the `CellRendererCombo:model` property.

The combo cell renderer takes care of adding a text cell renderer to the combo
box and sets it to display the column specified by its
`CellRendererCombo:text-column` property. Further properties of the combo box
can be set in a handler for the `CellRenderer::editing-started` signal.

The `CellRendererCombo` cell renderer was added in GTK+ 2.6.

# Implements

[`CellRendererComboExt`](trait.CellRendererComboExt.html), [`CellRendererTextExt`](trait.CellRendererTextExt.html), [`CellRendererExt`](trait.CellRendererExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait CellRendererComboExt -->
Trait containing all `CellRendererCombo` methods.

# Implementors

[`CellRendererCombo`](struct.CellRendererCombo.html)
<!-- impl CellRendererCombo::fn new -->
Creates a new `CellRendererCombo`.
Adjust how text is drawn using object properties.
Object properties can be set globally (with `gobject::ObjectExt::set`).
Also, with `TreeViewColumn`, you can bind a property to a value
in a `TreeModel`. For example, you can bind the “text” property
on the cell renderer to a string value in the model, thus rendering
a different string in each row of the `TreeView`.

# Returns

the new cell renderer
<!-- trait CellRendererComboExt::fn connect_changed -->
This signal is emitted each time after the user selected an item in
the combo box, either by using the mouse or the arrow keys. Contrary
to `ComboBox`, `CellRendererCombo`::changed is not emitted for
changes made to a selected item in the entry. The argument `new_iter`
corresponds to the newly selected item in the combo box and it is relative
to the `TreeModel` set via the model property on `CellRendererCombo`.

Note that as soon as you change the model displayed in the tree view,
the tree view will immediately cease the editing operating. This
means that you most probably want to refrain from changing the model
until the combo cell renderer emits the edited or editing_canceled signal.
## `path_string`
a string of the path identifying the edited cell
 (relative to the tree view model)
## `new_iter`
the new iter selected in the combo box
 (relative to the combo box model)
<!-- trait CellRendererComboExt::fn get_property_has-entry -->
If `true`, the cell renderer will include an entry and allow to enter
values other than the ones in the popup list.
<!-- trait CellRendererComboExt::fn set_property_has-entry -->
If `true`, the cell renderer will include an entry and allow to enter
values other than the ones in the popup list.
<!-- trait CellRendererComboExt::fn get_property_model -->
Holds a tree model containing the possible values for the combo box.
Use the text_column property to specify the column holding the values.
<!-- trait CellRendererComboExt::fn set_property_model -->
Holds a tree model containing the possible values for the combo box.
Use the text_column property to specify the column holding the values.
<!-- trait CellRendererComboExt::fn get_property_text-column -->
Specifies the model column which holds the possible values for the
combo box.

Note that this refers to the model specified in the model property,
not the model backing the tree view to which
this cell renderer is attached.

`CellRendererCombo` automatically adds a text cell renderer for
this column to its combo box.
<!-- trait CellRendererComboExt::fn set_property_text-column -->
Specifies the model column which holds the possible values for the
combo box.

Note that this refers to the model specified in the model property,
not the model backing the tree view to which
this cell renderer is attached.

`CellRendererCombo` automatically adds a text cell renderer for
this column to its combo box.
<!-- enum CellRendererMode -->
Identifies how the user can interact with a particular cell.
<!-- enum CellRendererMode::variant Inert -->
The cell is just for display
 and cannot be interacted with. Note that this doesn’t mean that eg. the
 row being drawn can’t be selected -- just that a particular element of
 it cannot be individually modified.
<!-- enum CellRendererMode::variant Activatable -->
The cell can be clicked.
<!-- enum CellRendererMode::variant Editable -->
The cell can be edited or otherwise modified.
<!-- struct CellRendererPixbuf -->
A `CellRendererPixbuf` can be used to render an image in a cell. It allows
to render either a given `gdk_pixbuf::Pixbuf` (set via the
`CellRendererPixbuf:pixbuf` property) or a named icon (set via the
`CellRendererPixbuf:icon-name` property).

To support the tree view, `CellRendererPixbuf` also supports rendering two
alternative pixbufs, when the `CellRenderer:is-expander` property is `true`.
If the `CellRenderer:is-expanded` property is `true` and the
`CellRendererPixbuf:pixbuf-expander-open` property is set to a pixbuf, it
renders that pixbuf, if the `CellRenderer:is-expanded` property is `false`
and the `CellRendererPixbuf:pixbuf-expander-closed` property is set to a
pixbuf, it renders that one.

# Implements

[`CellRendererPixbufExt`](trait.CellRendererPixbufExt.html), [`CellRendererExt`](trait.CellRendererExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait CellRendererPixbufExt -->
Trait containing all `CellRendererPixbuf` methods.

# Implementors

[`CellRendererPixbuf`](struct.CellRendererPixbuf.html)
<!-- impl CellRendererPixbuf::fn new -->
Creates a new `CellRendererPixbuf`. Adjust rendering
parameters using object properties. Object properties can be set
globally (with `gobject::ObjectExt::set`). Also, with `TreeViewColumn`, you
can bind a property to a value in a `TreeModel`. For example, you
can bind the “pixbuf” property on the cell renderer to a pixbuf value
in the model, thus rendering a different image in each row of the
`TreeView`.

# Returns

the new cell renderer
<!-- trait CellRendererPixbufExt::fn get_property_follow-state -->
Specifies whether the rendered pixbuf should be colorized
according to the `CellRendererState`.

# Deprecated since 3.16

Cell renderers always follow state.
<!-- trait CellRendererPixbufExt::fn set_property_follow-state -->
Specifies whether the rendered pixbuf should be colorized
according to the `CellRendererState`.

# Deprecated since 3.16

Cell renderers always follow state.
<!-- trait CellRendererPixbufExt::fn get_property_gicon -->
The GIcon representing the icon to display.
If the icon theme is changed, the image will be updated
automatically.
<!-- trait CellRendererPixbufExt::fn set_property_gicon -->
The GIcon representing the icon to display.
If the icon theme is changed, the image will be updated
automatically.
<!-- trait CellRendererPixbufExt::fn get_property_icon-name -->
The name of the themed icon to display.
This property only has an effect if not overridden by "stock_id"
or "pixbuf" properties.
<!-- trait CellRendererPixbufExt::fn set_property_icon-name -->
The name of the themed icon to display.
This property only has an effect if not overridden by "stock_id"
or "pixbuf" properties.
<!-- trait CellRendererPixbufExt::fn get_property_stock-id -->

# Deprecated since 3.10

Use `CellRendererPixbuf:icon-name` instead.
<!-- trait CellRendererPixbufExt::fn set_property_stock-id -->

# Deprecated since 3.10

Use `CellRendererPixbuf:icon-name` instead.
<!-- struct CellRendererProgress -->
`CellRendererProgress` renders a numeric value as a progress par in a cell.
Additionally, it can display a text on top of the progress bar.

The `CellRendererProgress` cell renderer was added in GTK+ 2.6.

# Implements

[`CellRendererProgressExt`](trait.CellRendererProgressExt.html), [`CellRendererExt`](trait.CellRendererExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`OrientableExt`](trait.OrientableExt.html)
<!-- trait CellRendererProgressExt -->
Trait containing all `CellRendererProgress` methods.

# Implementors

[`CellRendererProgress`](struct.CellRendererProgress.html)
<!-- impl CellRendererProgress::fn new -->
Creates a new `CellRendererProgress`.

# Returns

the new cell renderer
<!-- trait CellRendererProgressExt::fn get_property_pulse -->
Setting this to a non-negative value causes the cell renderer to
enter "activity mode", where a block bounces back and forth to
indicate that some progress is made, without specifying exactly how
much.

Each increment of the property causes the block to move by a little
bit.

To indicate that the activity has not started yet, set the property
to zero. To indicate completion, set the property to `G_MAXINT`.
<!-- trait CellRendererProgressExt::fn set_property_pulse -->
Setting this to a non-negative value causes the cell renderer to
enter "activity mode", where a block bounces back and forth to
indicate that some progress is made, without specifying exactly how
much.

Each increment of the property causes the block to move by a little
bit.

To indicate that the activity has not started yet, set the property
to zero. To indicate completion, set the property to `G_MAXINT`.
<!-- trait CellRendererProgressExt::fn get_property_text -->
The "text" property determines the label which will be drawn
over the progress bar. Setting this property to `None` causes the default
label to be displayed. Setting this property to an empty string causes
no label to be displayed.
<!-- trait CellRendererProgressExt::fn set_property_text -->
The "text" property determines the label which will be drawn
over the progress bar. Setting this property to `None` causes the default
label to be displayed. Setting this property to an empty string causes
no label to be displayed.
<!-- trait CellRendererProgressExt::fn get_property_text-xalign -->
The "text-xalign" property controls the horizontal alignment of the
text in the progress bar. Valid values range from 0 (left) to 1
(right). Reserved for RTL layouts.
<!-- trait CellRendererProgressExt::fn set_property_text-xalign -->
The "text-xalign" property controls the horizontal alignment of the
text in the progress bar. Valid values range from 0 (left) to 1
(right). Reserved for RTL layouts.
<!-- trait CellRendererProgressExt::fn get_property_text-yalign -->
The "text-yalign" property controls the vertical alignment of the
text in the progress bar. Valid values range from 0 (top) to 1
(bottom).
<!-- trait CellRendererProgressExt::fn set_property_text-yalign -->
The "text-yalign" property controls the vertical alignment of the
text in the progress bar. Valid values range from 0 (top) to 1
(bottom).
<!-- trait CellRendererProgressExt::fn get_property_value -->
The "value" property determines the percentage to which the
progress bar will be "filled in".
<!-- trait CellRendererProgressExt::fn set_property_value -->
The "value" property determines the percentage to which the
progress bar will be "filled in".
<!-- struct CellRendererSpin -->
`CellRendererSpin` renders text in a cell like `CellRendererText` from
which it is derived. But while `CellRendererText` offers a simple entry to
edit the text, `CellRendererSpin` offers a `SpinButton` widget. Of course,
that means that the text has to be parseable as a floating point number.

The range of the spinbutton is taken from the adjustment property of the
cell renderer, which can be set explicitly or mapped to a column in the
tree model, like all properties of cell renders. `CellRendererSpin`
also has properties for the `CellRendererSpin:climb-rate` and the number
of `CellRendererSpin:digits` to display. Other `SpinButton` properties
can be set in a handler for the `CellRenderer::editing-started` signal.

The `CellRendererSpin` cell renderer was added in GTK+ 2.10.

# Implements

[`CellRendererSpinExt`](trait.CellRendererSpinExt.html), [`CellRendererTextExt`](trait.CellRendererTextExt.html), [`CellRendererExt`](trait.CellRendererExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait CellRendererSpinExt -->
Trait containing all `CellRendererSpin` methods.

# Implementors

[`CellRendererSpin`](struct.CellRendererSpin.html)
<!-- impl CellRendererSpin::fn new -->
Creates a new `CellRendererSpin`.

# Returns

a new `CellRendererSpin`
<!-- trait CellRendererSpinExt::fn get_property_adjustment -->
The adjustment that holds the value of the spinbutton.
This must be non-`None` for the cell renderer to be editable.
<!-- trait CellRendererSpinExt::fn set_property_adjustment -->
The adjustment that holds the value of the spinbutton.
This must be non-`None` for the cell renderer to be editable.
<!-- trait CellRendererSpinExt::fn get_property_climb-rate -->
The acceleration rate when you hold down a button.
<!-- trait CellRendererSpinExt::fn set_property_climb-rate -->
The acceleration rate when you hold down a button.
<!-- trait CellRendererSpinExt::fn get_property_digits -->
The number of decimal places to display.
<!-- trait CellRendererSpinExt::fn set_property_digits -->
The number of decimal places to display.
<!-- struct CellRendererSpinner -->
`CellRendererSpinner` renders a spinning animation in a cell, very
similar to `Spinner`. It can often be used as an alternative
to a `CellRendererProgress` for displaying indefinite activity,
instead of actual progress.

To start the animation in a cell, set the `CellRendererSpinner:active`
property to `true` and increment the `CellRendererSpinner:pulse` property
at regular intervals. The usual way to set the cell renderer properties
for each cell is to bind them to columns in your tree model using e.g.
`TreeViewColumn::add_attribute`.

# Implements

[`CellRendererSpinnerExt`](trait.CellRendererSpinnerExt.html), [`CellRendererExt`](trait.CellRendererExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait CellRendererSpinnerExt -->
Trait containing all `CellRendererSpinner` methods.

# Implementors

[`CellRendererSpinner`](struct.CellRendererSpinner.html)
<!-- impl CellRendererSpinner::fn new -->
Returns a new cell renderer which will show a spinner to indicate
activity.

# Returns

a new `CellRenderer`
<!-- trait CellRendererSpinnerExt::fn get_property_pulse -->
Pulse of the spinner. Increment this value to draw the next frame of the
spinner animation. Usually, you would update this value in a timeout.

By default, the `Spinner` widget draws one full cycle of the animation,
consisting of 12 frames, in 750 milliseconds.
<!-- trait CellRendererSpinnerExt::fn set_property_pulse -->
Pulse of the spinner. Increment this value to draw the next frame of the
spinner animation. Usually, you would update this value in a timeout.

By default, the `Spinner` widget draws one full cycle of the animation,
consisting of 12 frames, in 750 milliseconds.
<!-- trait CellRendererSpinnerExt::fn get_property_size -->
The `IconSize` value that specifies the size of the rendered spinner.
<!-- trait CellRendererSpinnerExt::fn set_property_size -->
The `IconSize` value that specifies the size of the rendered spinner.
<!-- struct CellRendererText -->
A `CellRendererText` renders a given text in its cell, using the font, color and
style information provided by its properties. The text will be ellipsized if it is
too long and the `CellRendererText:ellipsize` property allows it.

If the `CellRenderer:mode` is `CellRendererMode::Editable`,
the `CellRendererText` allows to edit its text using an entry.

# Implements

[`CellRendererTextExt`](trait.CellRendererTextExt.html), [`CellRendererExt`](trait.CellRendererExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait CellRendererTextExt -->
Trait containing all `CellRendererText` methods.

# Implementors

[`CellRendererAccel`](struct.CellRendererAccel.html), [`CellRendererCombo`](struct.CellRendererCombo.html), [`CellRendererSpin`](struct.CellRendererSpin.html), [`CellRendererText`](struct.CellRendererText.html)
<!-- impl CellRendererText::fn new -->
Creates a new `CellRendererText`. Adjust how text is drawn using
object properties. Object properties can be
set globally (with `gobject::ObjectExt::set`). Also, with `TreeViewColumn`,
you can bind a property to a value in a `TreeModel`. For example,
you can bind the “text” property on the cell renderer to a string
value in the model, thus rendering a different string in each row
of the `TreeView`

# Returns

the new cell renderer
<!-- trait CellRendererTextExt::fn set_fixed_height_from_font -->
Sets the height of a renderer to explicitly be determined by the “font” and
“y_pad” property set on it. Further changes in these properties do not
affect the height, so they must be accompanied by a subsequent call to this
function. Using this function is unflexible, and should really only be used
if calculating the size of a cell is too slow (ie, a massive number of cells
displayed). If `number_of_rows` is -1, then the fixed height is unset, and
the height is determined by the properties again.
## `number_of_rows`
Number of rows of text each cell renderer is allocated, or -1
<!-- trait CellRendererTextExt::fn connect_edited -->
This signal is emitted after `renderer` has been edited.

It is the responsibility of the application to update the model
and store `new_text` at the position indicated by `path`.
## `path`
the path identifying the edited cell
## `new_text`
the new text
<!-- trait CellRendererTextExt::fn get_property_alignment -->
Specifies how to align the lines of text with respect to each other.

Note that this property describes how to align the lines of text in
case there are several of them. The "xalign" property of `CellRenderer`,
on the other hand, sets the horizontal alignment of the whole text.
<!-- trait CellRendererTextExt::fn set_property_alignment -->
Specifies how to align the lines of text with respect to each other.

Note that this property describes how to align the lines of text in
case there are several of them. The "xalign" property of `CellRenderer`,
on the other hand, sets the horizontal alignment of the whole text.
<!-- trait CellRendererTextExt::fn get_property_background-gdk -->
Background color as a `gdk::Color`

# Deprecated since 3.4

Use `CellRendererText:background-rgba` instead.
<!-- trait CellRendererTextExt::fn set_property_background-gdk -->
Background color as a `gdk::Color`

# Deprecated since 3.4

Use `CellRendererText:background-rgba` instead.
<!-- trait CellRendererTextExt::fn get_property_background-rgba -->
Background color as a `gdk::RGBA`
<!-- trait CellRendererTextExt::fn set_property_background-rgba -->
Background color as a `gdk::RGBA`
<!-- trait CellRendererTextExt::fn get_property_ellipsize -->
Specifies the preferred place to ellipsize the string, if the cell renderer
does not have enough room to display the entire string. Setting it to
`pango::EllipsizeMode::None` turns off ellipsizing. See the wrap-width property
for another way of making the text fit into a given width.
<!-- trait CellRendererTextExt::fn set_property_ellipsize -->
Specifies the preferred place to ellipsize the string, if the cell renderer
does not have enough room to display the entire string. Setting it to
`pango::EllipsizeMode::None` turns off ellipsizing. See the wrap-width property
for another way of making the text fit into a given width.
<!-- trait CellRendererTextExt::fn get_property_foreground-gdk -->
Foreground color as a `gdk::Color`

# Deprecated since 3.4

Use `CellRendererText:foreground-rgba` instead.
<!-- trait CellRendererTextExt::fn set_property_foreground-gdk -->
Foreground color as a `gdk::Color`

# Deprecated since 3.4

Use `CellRendererText:foreground-rgba` instead.
<!-- trait CellRendererTextExt::fn get_property_foreground-rgba -->
Foreground color as a `gdk::RGBA`
<!-- trait CellRendererTextExt::fn set_property_foreground-rgba -->
Foreground color as a `gdk::RGBA`
<!-- trait CellRendererTextExt::fn get_property_max-width-chars -->
The desired maximum width of the cell, in characters. If this property
is set to -1, the width will be calculated automatically.

For cell renderers that ellipsize or wrap text; this property
controls the maximum reported width of the cell. The
cell should not receive any greater allocation unless it is
set to expand in its `CellLayout` and all of the cell's siblings
have received their natural width.
<!-- trait CellRendererTextExt::fn set_property_max-width-chars -->
The desired maximum width of the cell, in characters. If this property
is set to -1, the width will be calculated automatically.

For cell renderers that ellipsize or wrap text; this property
controls the maximum reported width of the cell. The
cell should not receive any greater allocation unless it is
set to expand in its `CellLayout` and all of the cell's siblings
have received their natural width.
<!-- trait CellRendererTextExt::fn get_property_placeholder-text -->
The text that will be displayed in the `CellRenderer` if
`CellRendererText:editable` is `true` and the cell is empty.

Since 3.6
<!-- trait CellRendererTextExt::fn set_property_placeholder-text -->
The text that will be displayed in the `CellRenderer` if
`CellRendererText:editable` is `true` and the cell is empty.

Since 3.6
<!-- trait CellRendererTextExt::fn get_property_width-chars -->
The desired width of the cell, in characters. If this property is set to
-1, the width will be calculated automatically, otherwise the cell will
request either 3 characters or the property value, whichever is greater.
<!-- trait CellRendererTextExt::fn set_property_width-chars -->
The desired width of the cell, in characters. If this property is set to
-1, the width will be calculated automatically, otherwise the cell will
request either 3 characters or the property value, whichever is greater.
<!-- trait CellRendererTextExt::fn get_property_wrap-mode -->
Specifies how to break the string into multiple lines, if the cell
renderer does not have enough room to display the entire string.
This property has no effect unless the wrap-width property is set.
<!-- trait CellRendererTextExt::fn set_property_wrap-mode -->
Specifies how to break the string into multiple lines, if the cell
renderer does not have enough room to display the entire string.
This property has no effect unless the wrap-width property is set.
<!-- trait CellRendererTextExt::fn get_property_wrap-width -->
Specifies the minimum width at which the text is wrapped. The wrap-mode property can
be used to influence at what character positions the line breaks can be placed.
Setting wrap-width to -1 turns wrapping off.
<!-- trait CellRendererTextExt::fn set_property_wrap-width -->
Specifies the minimum width at which the text is wrapped. The wrap-mode property can
be used to influence at what character positions the line breaks can be placed.
Setting wrap-width to -1 turns wrapping off.
<!-- struct CellRendererToggle -->
`CellRendererToggle` renders a toggle button in a cell. The
button is drawn as a radio or a checkbutton, depending on the
`CellRendererToggle:radio` property.
When activated, it emits the `CellRendererToggle::toggled` signal.

# Implements

[`CellRendererToggleExt`](trait.CellRendererToggleExt.html), [`CellRendererExt`](trait.CellRendererExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait CellRendererToggleExt -->
Trait containing all `CellRendererToggle` methods.

# Implementors

[`CellRendererToggle`](struct.CellRendererToggle.html)
<!-- impl CellRendererToggle::fn new -->
Creates a new `CellRendererToggle`. Adjust rendering
parameters using object properties. Object properties can be set
globally (with `gobject::ObjectExt::set`). Also, with `TreeViewColumn`, you
can bind a property to a value in a `TreeModel`. For example, you
can bind the “active” property on the cell renderer to a boolean value
in the model, thus causing the check button to reflect the state of
the model.

# Returns

the new cell renderer
<!-- trait CellRendererToggleExt::fn get_activatable -->
Returns whether the cell renderer is activatable. See
`CellRendererToggleExt::set_activatable`.

# Returns

`true` if the cell renderer is activatable.
<!-- trait CellRendererToggleExt::fn get_active -->
Returns whether the cell renderer is active. See
`CellRendererToggleExt::set_active`.

# Returns

`true` if the cell renderer is active.
<!-- trait CellRendererToggleExt::fn get_radio -->
Returns whether we’re rendering radio toggles rather than checkboxes.

# Returns

`true` if we’re rendering radio toggles rather than checkboxes
<!-- trait CellRendererToggleExt::fn set_activatable -->
Makes the cell renderer activatable.
## `setting`
the value to set.
<!-- trait CellRendererToggleExt::fn set_active -->
Activates or deactivates a cell renderer.
## `setting`
the value to set.
<!-- trait CellRendererToggleExt::fn set_radio -->
If `radio` is `true`, the cell renderer renders a radio toggle
(i.e. a toggle in a group of mutually-exclusive toggles).
If `false`, it renders a check toggle (a standalone boolean option).
This can be set globally for the cell renderer, or changed just
before rendering each cell in the model (for `TreeView`, you set
up a per-row setting using `TreeViewColumn` to associate model
columns with cell renderer properties).
## `radio`
`true` to make the toggle look like a radio button
<!-- trait CellRendererToggleExt::fn connect_toggled -->
The ::toggled signal is emitted when the cell is toggled.

It is the responsibility of the application to update the model
with the correct value to store at `path`. Often this is simply the
opposite of the value currently stored at `path`.
## `path`
string representation of `TreePath` describing the
 event location
<!-- struct CheckButton -->
A `CheckButton` places a discrete `ToggleButton` next to a widget,
(usually a `Label`). See the section on `ToggleButton` widgets for
more information about toggle/check buttons.

The important signal ( `ToggleButton::toggled` ) is also inherited from
`ToggleButton`.

# CSS nodes


```plain
checkbutton
├── check
╰── <child>
```

A `CheckButton` with indicator (see `ToggleButtonExt::set_mode`) has a
main CSS node with name checkbutton and a subnode with name check.


```plain
button.check
├── check
╰── <child>
```

A `CheckButton` without indicator changes the name of its main node
to button and adds a .check style class to it. The subnode is invisible
in this case.

# Implements

[`ToggleButtonExt`](trait.ToggleButtonExt.html), [`ButtonExt`](trait.ButtonExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`ActionableExt`](trait.ActionableExt.html)
<!-- impl CheckButton::fn new -->
Creates a new `CheckButton`.

# Returns

a `Widget`.
<!-- impl CheckButton::fn new_with_label -->
Creates a new `CheckButton` with a `Label` to the right of it.
## `label`
the text for the check button.

# Returns

a `Widget`.
<!-- impl CheckButton::fn new_with_mnemonic -->
Creates a new `CheckButton` containing a label. The label
will be created using `Label::new_with_mnemonic`, so underscores
in `label` indicate the mnemonic for the check button.
## `label`
The text of the button, with an underscore in front of the
 mnemonic character

# Returns

a new `CheckButton`
<!-- struct CheckMenuItem -->
A `CheckMenuItem` is a menu item that maintains the state of a boolean
value in addition to a `MenuItem` usual role in activating application
code.

A check box indicating the state of the boolean value is displayed
at the left side of the `MenuItem`. Activating the `MenuItem`
toggles the value.

# CSS nodes


```plain
menuitem
├── check.left
╰── <child>
```

`CheckMenuItem` has a main CSS node with name menuitem, and a subnode
with name check, which gets the .left or .right style class.

# Implements

[`CheckMenuItemExt`](trait.CheckMenuItemExt.html), [`MenuItemExt`](trait.MenuItemExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`ActionableExt`](trait.ActionableExt.html)
<!-- trait CheckMenuItemExt -->
Trait containing all `CheckMenuItem` methods.

# Implementors

[`CheckMenuItem`](struct.CheckMenuItem.html), [`RadioMenuItem`](struct.RadioMenuItem.html)
<!-- impl CheckMenuItem::fn new -->
Creates a new `CheckMenuItem`.

# Returns

a new `CheckMenuItem`.
<!-- impl CheckMenuItem::fn new_with_label -->
Creates a new `CheckMenuItem` with a label.
## `label`
the string to use for the label.

# Returns

a new `CheckMenuItem`.
<!-- impl CheckMenuItem::fn new_with_mnemonic -->
Creates a new `CheckMenuItem` containing a label. The label
will be created using `Label::new_with_mnemonic`, so underscores
in `label` indicate the mnemonic for the menu item.
## `label`
The text of the button, with an underscore in front of the
 character

# Returns

a new `CheckMenuItem`
<!-- trait CheckMenuItemExt::fn get_active -->
Returns whether the check menu item is active. See
gtk_check_menu_item_set_active ().

# Returns

`true` if the menu item is checked.
<!-- trait CheckMenuItemExt::fn get_draw_as_radio -->
Returns whether `self` looks like a `RadioMenuItem`

# Returns

Whether `self` looks like a `RadioMenuItem`
<!-- trait CheckMenuItemExt::fn get_inconsistent -->
Retrieves the value set by `CheckMenuItemExt::set_inconsistent`.

# Returns

`true` if inconsistent
<!-- trait CheckMenuItemExt::fn set_active -->
Sets the active state of the menu item’s check box.
## `is_active`
boolean value indicating whether the check box is active.
<!-- trait CheckMenuItemExt::fn set_draw_as_radio -->
Sets whether `self` is drawn like a `RadioMenuItem`
## `draw_as_radio`
whether `self` is drawn like a `RadioMenuItem`
<!-- trait CheckMenuItemExt::fn set_inconsistent -->
If the user has selected a range of elements (such as some text or
spreadsheet cells) that are affected by a boolean setting, and the
current values in that range are inconsistent, you may want to
display the check in an “in between” state. This function turns on
“in between” display. Normally you would turn off the inconsistent
state again if the user explicitly selects a setting. This has to be
done manually, `CheckMenuItemExt::set_inconsistent` only affects
visual appearance, it doesn’t affect the semantics of the widget.
## `setting`
`true` to display an “inconsistent” third state check
<!-- trait CheckMenuItemExt::fn toggled -->
Emits the `CheckMenuItem::toggled` signal.
<!-- trait CheckMenuItemExt::fn connect_toggled -->
This signal is emitted when the state of the check box is changed.

A signal handler can use `CheckMenuItemExt::get_active`
to discover the new state.
<!-- struct Clipboard -->
The `Clipboard` object represents a clipboard of data shared
between different processes or between different widgets in
the same process. Each clipboard is identified by a name encoded as a
`gdk::Atom`. (Conversion to and from strings can be done with
`gdk::Atom_::intern` and `gdk::Atom_::name`.) The default clipboard
corresponds to the “CLIPBOARD” atom; another commonly used clipboard
is the “PRIMARY” clipboard, which, in X, traditionally contains
the currently selected text.

To support having a number of different formats on the clipboard
at the same time, the clipboard mechanism allows providing
callbacks instead of the actual data. When you set the contents
of the clipboard, you can either supply the data directly (via
functions like `ClipboardExt::set_text`), or you can supply a
callback to be called at a later time when the data is needed (via
`ClipboardExt::set_with_data` or `ClipboardExt::set_with_owner`.)
Providing a callback also avoids having to make copies of the data
when it is not needed.

`ClipboardExt::set_with_data` and `ClipboardExt::set_with_owner`
are quite similar; the choice between the two depends mostly on
which is more convenient in a particular situation.
The former is most useful when you want to have a blob of data
with callbacks to convert it into the various data types that you
advertise. When the `clear_func` you provided is called, you
simply free the data blob. The latter is more useful when the
contents of clipboard reflect the internal state of a `gobject::Object`
(As an example, for the PRIMARY clipboard, when an entry widget
provides the clipboard’s contents the contents are simply the
text within the selected region.) If the contents change, the
entry widget can call `ClipboardExt::set_with_owner` to update
the timestamp for clipboard ownership, without having to worry
about `clear_func` being called.

Requesting the data from the clipboard is essentially
asynchronous. If the contents of the clipboard are provided within
the same process, then a direct function call will be made to
retrieve the data, but if they are provided by another process,
then the data needs to be retrieved from the other process, which
may take some time. To avoid blocking the user interface, the call
to request the selection, `ClipboardExt::request_contents` takes a
callback that will be called when the contents are received (or
when the request fails.) If you don’t want to deal with providing
a separate callback, you can also use `ClipboardExt::wait_for_contents`.
What this does is run the GLib main loop recursively waiting for
the contents. This can simplify the code flow, but you still have
to be aware that other callbacks in your program can be called
while this recursive mainloop is running.

Along with the functions to get the clipboard contents as an
arbitrary data chunk, there are also functions to retrieve
it as text, `ClipboardExt::request_text` and
`ClipboardExt::wait_for_text`. These functions take care of
determining which formats are advertised by the clipboard
provider, asking for the clipboard in the best available format
and converting the results into the UTF-8 encoding. (The standard
form for representing strings in GTK+.)

# Implements

[`ClipboardExt`](trait.ClipboardExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait ClipboardExt -->
Trait containing all `Clipboard` methods.

# Implementors

[`Clipboard`](struct.Clipboard.html)
<!-- impl Clipboard::fn get -->
Returns the clipboard object for the given selection.
See `Clipboard::get_for_display` for complete details.
## `selection`
a `gdk::Atom` which identifies the clipboard to use

# Returns

the appropriate clipboard object. If no clipboard
 already exists, a new one will be created. Once a clipboard
 object has been created, it is persistent and, since it is
 owned by GTK+, must not be freed or unreffed.
<!-- impl Clipboard::fn get_default -->
Returns the default clipboard object for use with cut/copy/paste menu items
and keyboard shortcuts.

Feature: `v3_16`

## `display`
the `gdk::Display` for which the clipboard is to be retrieved.

# Returns

the default clipboard object.
<!-- impl Clipboard::fn get_for_display -->
Returns the clipboard object for the given selection.
Cut/copy/paste menu items and keyboard shortcuts should use
the default clipboard, returned by passing `GDK_SELECTION_CLIPBOARD` for `selection`.
(`GDK_NONE` is supported as a synonym for GDK_SELECTION_CLIPBOARD
for backwards compatibility reasons.)
The currently-selected object or text should be provided on the clipboard
identified by `GDK_SELECTION_PRIMARY`. Cut/copy/paste menu items
conceptually copy the contents of the `GDK_SELECTION_PRIMARY` clipboard
to the default clipboard, i.e. they copy the selection to what the
user sees as the clipboard.

(Passing `GDK_NONE` is the same as using `gdk_atom_intern
("CLIPBOARD", FALSE)`.

See the
[FreeDesktop Clipboard Specification](http://www.freedesktop.org/Standards/clipboards-spec)
for a detailed discussion of the “CLIPBOARD” vs. “PRIMARY”
selections under the X window system. On Win32 the
`GDK_SELECTION_PRIMARY` clipboard is essentially ignored.)

It’s possible to have arbitrary named clipboards; if you do invent
new clipboards, you should prefix the selection name with an
underscore (because the ICCCM requires that nonstandard atoms are
underscore-prefixed), and namespace it as well. For example,
if your application called “Foo” has a special-purpose
clipboard, you might call it “_FOO_SPECIAL_CLIPBOARD”.
## `display`
the `gdk::Display` for which the clipboard is to be retrieved or created.
## `selection`
a `gdk::Atom` which identifies the clipboard to use.

# Returns

the appropriate clipboard object. If no
 clipboard already exists, a new one will be created. Once a clipboard
 object has been created, it is persistent and, since it is owned by
 GTK+, must not be freed or unrefd.
<!-- trait ClipboardExt::fn clear -->
Clears the contents of the clipboard. Generally this should only
be called between the time you call `ClipboardExt::set_with_owner`
or `ClipboardExt::set_with_data`,
and when the `clear_func` you supplied is called. Otherwise, the
clipboard may be owned by someone else.
<!-- trait ClipboardExt::fn get_display -->
Gets the `gdk::Display` associated with `self`

# Returns

the `gdk::Display` associated with `self`
<!-- trait ClipboardExt::fn get_owner -->
If the clipboard contents callbacks were set with
`ClipboardExt::set_with_owner`, and the `ClipboardExt::set_with_data` or
`ClipboardExt::clear` has not subsequently called, returns the owner set
by `ClipboardExt::set_with_owner`.

# Returns

the owner of the clipboard, if any;
 otherwise `None`.
<!-- trait ClipboardExt::fn get_selection -->
Gets the selection that this clipboard is for.

Feature: `v3_22`


# Returns

the selection
<!-- trait ClipboardExt::fn request_contents -->
Requests the contents of clipboard as the given target.
When the results of the result are later received the supplied callback
will be called.
## `target`
an atom representing the form into which the clipboard
 owner should convert the selection.
## `callback`
A function to call when the results are received
 (or the retrieval fails). If the retrieval fails the length field of
 `selection_data` will be negative.
## `user_data`
user data to pass to `callback`
<!-- trait ClipboardExt::fn request_image -->
Requests the contents of the clipboard as image. When the image is
later received, it will be converted to a `gdk_pixbuf::Pixbuf`, and
`callback` will be called.

The `pixbuf` parameter to `callback` will contain the resulting
`gdk_pixbuf::Pixbuf` if the request succeeded, or `None` if it failed. This
could happen for various reasons, in particular if the clipboard
was empty or if the contents of the clipboard could not be
converted into an image.
## `callback`
a function to call when the image is received,
 or the retrieval fails. (It will always be called one way or the other.)
## `user_data`
user data to pass to `callback`.
<!-- trait ClipboardExt::fn request_rich_text -->
Requests the contents of the clipboard as rich text. When the rich
text is later received, `callback` will be called.

The `text` parameter to `callback` will contain the resulting rich
text if the request succeeded, or `None` if it failed. The `length`
parameter will contain `text`’s length. This function can fail for
various reasons, in particular if the clipboard was empty or if the
contents of the clipboard could not be converted into rich text form.
## `buffer`
a `TextBuffer`
## `callback`
a function to call when the text is received,
 or the retrieval fails. (It will always be called one way or the other.)
## `user_data`
user data to pass to `callback`.
<!-- trait ClipboardExt::fn request_targets -->
Requests the contents of the clipboard as list of supported targets.
When the list is later received, `callback` will be called.

The `targets` parameter to `callback` will contain the resulting targets if
the request succeeded, or `None` if it failed.
## `callback`
a function to call when the targets are
 received, or the retrieval fails. (It will always be called
 one way or the other.)
## `user_data`
user data to pass to `callback`.
<!-- trait ClipboardExt::fn request_text -->
Requests the contents of the clipboard as text. When the text is
later received, it will be converted to UTF-8 if necessary, and
`callback` will be called.

The `text` parameter to `callback` will contain the resulting text if
the request succeeded, or `None` if it failed. This could happen for
various reasons, in particular if the clipboard was empty or if the
contents of the clipboard could not be converted into text form.
## `callback`
a function to call when the text is received,
 or the retrieval fails. (It will always be called one way or the other.)
## `user_data`
user data to pass to `callback`.
<!-- trait ClipboardExt::fn request_uris -->
Requests the contents of the clipboard as URIs. When the URIs are
later received `callback` will be called.

The `uris` parameter to `callback` will contain the resulting array of
URIs if the request succeeded, or `None` if it failed. This could happen
for various reasons, in particular if the clipboard was empty or if the
contents of the clipboard could not be converted into URI form.
## `callback`
a function to call when the URIs are received,
 or the retrieval fails. (It will always be called one way or the other.)
## `user_data`
user data to pass to `callback`.
<!-- trait ClipboardExt::fn set_can_store -->
Hints that the clipboard data should be stored somewhere when the
application exits or when gtk_clipboard_store () is called.

This value is reset when the clipboard owner changes.
Where the clipboard data is stored is platform dependent,
see gdk_display_store_clipboard () for more information.
## `targets`
array containing
 information about which forms should be stored or `None`
 to indicate that all forms should be stored.
## `n_targets`
number of elements in `targets`
<!-- trait ClipboardExt::fn set_image -->
Sets the contents of the clipboard to the given `gdk_pixbuf::Pixbuf`.
GTK+ will take responsibility for responding for requests
for the image, and for converting the image into the
requested format.
## `pixbuf`
a `gdk_pixbuf::Pixbuf`
<!-- trait ClipboardExt::fn set_text -->
Sets the contents of the clipboard to the given UTF-8 string. GTK+ will
make a copy of the text and take responsibility for responding
for requests for the text, and for converting the text into
the requested format.
## `text`
a UTF-8 string.
## `len`
length of `text`, in bytes, or -1, in which case
 the length will be determined with `strlen`.
<!-- trait ClipboardExt::fn set_with_data -->
Virtually sets the contents of the specified clipboard by providing
a list of supported formats for the clipboard data and a function
to call to get the actual data when it is requested.
## `targets`
array containing information
 about the available forms for the clipboard data
## `n_targets`
number of elements in `targets`
## `get_func`
function to call to get the actual clipboard data
## `clear_func`
when the clipboard contents are set again,
 this function will be called, and `get_func` will not be subsequently
 called.
## `user_data`
user data to pass to `get_func` and `clear_func`.

# Returns

`true` if setting the clipboard data succeeded.
 If setting the clipboard data failed the provided callback
 functions will be ignored.
<!-- trait ClipboardExt::fn set_with_owner -->
Virtually sets the contents of the specified clipboard by providing
a list of supported formats for the clipboard data and a function
to call to get the actual data when it is requested.

The difference between this function and `ClipboardExt::set_with_data`
is that instead of an generic `user_data` pointer, a `gobject::Object` is passed
in.
## `targets`
array containing information
 about the available forms for the clipboard data
## `n_targets`
number of elements in `targets`
## `get_func`
function to call to get the actual clipboard data
## `clear_func`
when the clipboard contents are set again,
 this function will be called, and `get_func` will not be subsequently
 called
## `owner`
an object that “owns” the data. This object will be passed
 to the callbacks when called

# Returns

`true` if setting the clipboard data succeeded.
 If setting the clipboard data failed the provided callback
 functions will be ignored.
<!-- trait ClipboardExt::fn store -->
Stores the current clipboard data somewhere so that it will stay
around after the application has quit.
<!-- trait ClipboardExt::fn wait_for_contents -->
Requests the contents of the clipboard using the given target.
This function waits for the data to be received using the main
loop, so events, timeouts, etc, may be dispatched during the wait.
## `target`
an atom representing the form into which the clipboard
 owner should convert the selection.

# Returns

a newly-allocated `SelectionData` object or `None`
 if retrieving the given target failed. If non-`None`,
 this value must be freed with `SelectionData::free`
 when you are finished with it.
<!-- trait ClipboardExt::fn wait_for_image -->
Requests the contents of the clipboard as image and converts
the result to a `gdk_pixbuf::Pixbuf`. This function waits for
the data to be received using the main loop, so events,
timeouts, etc, may be dispatched during the wait.

# Returns

a newly-allocated `gdk_pixbuf::Pixbuf`
 object which must be disposed with `gobject::ObjectExt::unref`, or
 `None` if retrieving the selection data failed. (This could
 happen for various reasons, in particular if the clipboard
 was empty or if the contents of the clipboard could not be
 converted into an image.)
<!-- trait ClipboardExt::fn wait_for_rich_text -->
Requests the contents of the clipboard as rich text. This function
waits for the data to be received using the main loop, so events,
timeouts, etc, may be dispatched during the wait.
## `buffer`
a `TextBuffer`
## `format`
return location for the format of the returned data
## `length`
return location for the length of the returned data

# Returns

a
 newly-allocated binary block of data which must be
 freed with `g_free`, or `None` if retrieving the
 selection data failed. (This could happen for various
 reasons, in particular if the clipboard was empty or
 if the contents of the clipboard could not be
 converted into text form.)
<!-- trait ClipboardExt::fn wait_for_targets -->
Returns a list of targets that are present on the clipboard, or `None`
if there aren’t any targets available. The returned list must be
freed with `g_free`.
This function waits for the data to be received using the main
loop, so events, timeouts, etc, may be dispatched during the wait.
## `targets`
location
 to store an array of targets. The result stored here must
 be freed with `g_free`.
## `n_targets`
location to store number of items in `targets`.

# Returns

`true` if any targets are present on the clipboard,
 otherwise `false`.
<!-- trait ClipboardExt::fn wait_for_text -->
Requests the contents of the clipboard as text and converts
the result to UTF-8 if necessary. This function waits for
the data to be received using the main loop, so events,
timeouts, etc, may be dispatched during the wait.

# Returns

a newly-allocated UTF-8 string which must
 be freed with `g_free`, or `None` if retrieving
 the selection data failed. (This could happen
 for various reasons, in particular if the
 clipboard was empty or if the contents of the
 clipboard could not be converted into text form.)
<!-- trait ClipboardExt::fn wait_for_uris -->
Requests the contents of the clipboard as URIs. This function waits
for the data to be received using the main loop, so events,
timeouts, etc, may be dispatched during the wait.

# Returns


 a newly-allocated `None`-terminated array of strings which must
 be freed with `g_strfreev`, or `None` if retrieving the
 selection data failed. (This could happen for various reasons,
 in particular if the clipboard was empty or if the contents of
 the clipboard could not be converted into URI form.)
<!-- trait ClipboardExt::fn wait_is_image_available -->
Test to see if there is an image available to be pasted
This is done by requesting the TARGETS atom and checking
if it contains any of the supported image targets. This function
waits for the data to be received using the main loop, so events,
timeouts, etc, may be dispatched during the wait.

This function is a little faster than calling
`ClipboardExt::wait_for_image` since it doesn’t need to retrieve
the actual image data.

# Returns

`true` is there is an image available, `false` otherwise.
<!-- trait ClipboardExt::fn wait_is_rich_text_available -->
Test to see if there is rich text available to be pasted
This is done by requesting the TARGETS atom and checking
if it contains any of the supported rich text targets. This function
waits for the data to be received using the main loop, so events,
timeouts, etc, may be dispatched during the wait.

This function is a little faster than calling
`ClipboardExt::wait_for_rich_text` since it doesn’t need to retrieve
the actual text.
## `buffer`
a `TextBuffer`

# Returns

`true` is there is rich text available, `false` otherwise.
<!-- trait ClipboardExt::fn wait_is_target_available -->
Checks if a clipboard supports pasting data of a given type. This
function can be used to determine if a “Paste” menu item should be
insensitive or not.

If you want to see if there’s text available on the clipboard, use
gtk_clipboard_wait_is_text_available () instead.
## `target`
A `gdk::Atom` indicating which target to look for.

# Returns

`true` if the target is available, `false` otherwise.
<!-- trait ClipboardExt::fn wait_is_text_available -->
Test to see if there is text available to be pasted
This is done by requesting the TARGETS atom and checking
if it contains any of the supported text targets. This function
waits for the data to be received using the main loop, so events,
timeouts, etc, may be dispatched during the wait.

This function is a little faster than calling
`ClipboardExt::wait_for_text` since it doesn’t need to retrieve
the actual text.

# Returns

`true` is there is text available, `false` otherwise.
<!-- trait ClipboardExt::fn wait_is_uris_available -->
Test to see if there is a list of URIs available to be pasted
This is done by requesting the TARGETS atom and checking
if it contains the URI targets. This function
waits for the data to be received using the main loop, so events,
timeouts, etc, may be dispatched during the wait.

This function is a little faster than calling
`ClipboardExt::wait_for_uris` since it doesn’t need to retrieve
the actual URI data.

# Returns

`true` is there is an URI list available, `false` otherwise.
<!-- trait ClipboardExt::fn connect_owner_change -->
The ::owner-change signal is emitted when GTK+ receives an
event that indicates that the ownership of the selection
associated with `clipboard` has changed.
## `event`
the `gdk::EventOwnerChange` event
<!-- struct ColorButton -->
The `ColorButton` is a button which displays the currently selected
color and allows to open a color selection dialog to change the color.
It is suitable widget for selecting a color in a preference dialog.

# CSS nodes

`ColorButton` has a single CSS node with name button. To differentiate
it from a plain `Button`, it gets the .color style class.

# Implements

[`ColorButtonExt`](trait.ColorButtonExt.html), [`ButtonExt`](trait.ButtonExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`ActionableExt`](trait.ActionableExt.html), [`ColorChooserExt`](trait.ColorChooserExt.html)
<!-- trait ColorButtonExt -->
Trait containing all `ColorButton` methods.

# Implementors

[`ColorButton`](struct.ColorButton.html)
<!-- impl ColorButton::fn new -->
Creates a new color button.

This returns a widget in the form of a small button containing
a swatch representing the current selected color. When the button
is clicked, a color-selection dialog will open, allowing the user
to select a color. The swatch will be updated to reflect the new
color when the user finishes.

# Returns

a new color button
<!-- impl ColorButton::fn new_with_color -->
Creates a new color button.

# Deprecated since 3.4

Use `ColorButton::new_with_rgba` instead.
## `color`
A `gdk::Color` to set the current color with

# Returns

a new color button
<!-- impl ColorButton::fn new_with_rgba -->
Creates a new color button.
## `rgba`
A `gdk::RGBA` to set the current color with

# Returns

a new color button
<!-- trait ColorButtonExt::fn get_alpha -->
Returns the current alpha value.

# Deprecated since 3.4

Use `ColorChooser::get_rgba` instead.

# Returns

an integer between 0 and 65535
<!-- trait ColorButtonExt::fn get_color -->
Sets `color` to be the current color in the `ColorButton` widget.

# Deprecated since 3.4

Use `ColorChooser::get_rgba` instead.
## `color`
a `gdk::Color` to fill in with the current color
<!-- trait ColorButtonExt::fn get_rgba -->
Sets `rgba` to be the current color in the `ColorButton` widget.

# Deprecated since 3.4

Use `ColorChooser::get_rgba` instead.
## `rgba`
a `gdk::RGBA` to fill in with the current color
<!-- trait ColorButtonExt::fn get_title -->
Gets the title of the color selection dialog.

# Returns

An internal string, do not free the return value
<!-- trait ColorButtonExt::fn get_use_alpha -->
Does the color selection dialog use the alpha channel ?

# Deprecated since 3.4

Use `ColorChooser::get_use_alpha` instead.

# Returns

`true` if the color sample uses alpha channel, `false` if not
<!-- trait ColorButtonExt::fn set_alpha -->
Sets the current opacity to be `alpha`.

# Deprecated since 3.4

Use `ColorChooser::set_rgba` instead.
## `alpha`
an integer between 0 and 65535
<!-- trait ColorButtonExt::fn set_color -->
Sets the current color to be `color`.

# Deprecated

Use `ColorChooser::set_rgba` instead.
## `color`
A `gdk::Color` to set the current color with
<!-- trait ColorButtonExt::fn set_rgba -->
Sets the current color to be `rgba`.

# Deprecated since 3.4

Use `ColorChooser::set_rgba` instead.
## `rgba`
a `gdk::RGBA` to set the current color with
<!-- trait ColorButtonExt::fn set_title -->
Sets the title for the color selection dialog.
## `title`
String containing new window title
<!-- trait ColorButtonExt::fn set_use_alpha -->
Sets whether or not the color button should use the alpha channel.

# Deprecated since 3.4

Use `ColorChooser::set_use_alpha` instead.
## `use_alpha`
`true` if color button should use alpha channel, `false` if not
<!-- trait ColorButtonExt::fn connect_color_set -->
The ::color-set signal is emitted when the user selects a color.
When handling this signal, use `ColorButton::get_rgba` to
find out which color was just selected.

Note that this signal is only emitted when the user
changes the color. If you need to react to programmatic color changes
as well, use the notify::color signal.
<!-- trait ColorButtonExt::fn get_property_alpha -->
The selected opacity value (0 fully transparent, 65535 fully opaque).
<!-- trait ColorButtonExt::fn set_property_alpha -->
The selected opacity value (0 fully transparent, 65535 fully opaque).
<!-- trait ColorButtonExt::fn get_property_color -->
The selected color.

# Deprecated since 3.4

Use `ColorButton:rgba` instead.
<!-- trait ColorButtonExt::fn set_property_color -->
The selected color.

# Deprecated since 3.4

Use `ColorButton:rgba` instead.
<!-- trait ColorButtonExt::fn get_property_rgba -->
The RGBA color.
<!-- trait ColorButtonExt::fn set_property_rgba -->
The RGBA color.
<!-- trait ColorButtonExt::fn get_property_show-editor -->
Set this property to `true` to skip the palette
in the dialog and go directly to the color editor.

This property should be used in cases where the palette
in the editor would be redundant, such as when the color
button is already part of a palette.

Feature: `v3_20`

<!-- trait ColorButtonExt::fn set_property_show-editor -->
Set this property to `true` to skip the palette
in the dialog and go directly to the color editor.

This property should be used in cases where the palette
in the editor would be redundant, such as when the color
button is already part of a palette.

Feature: `v3_20`

<!-- trait ColorButtonExt::fn get_property_title -->
The title of the color selection dialog
<!-- trait ColorButtonExt::fn set_property_title -->
The title of the color selection dialog
<!-- trait ColorButtonExt::fn get_property_use-alpha -->
If this property is set to `true`, the color swatch on the button is
rendered against a checkerboard background to show its opacity and
the opacity slider is displayed in the color selection dialog.
<!-- trait ColorButtonExt::fn set_property_use-alpha -->
If this property is set to `true`, the color swatch on the button is
rendered against a checkerboard background to show its opacity and
the opacity slider is displayed in the color selection dialog.
<!-- struct ColorChooser -->
`ColorChooser` is an interface that is implemented by widgets
for choosing colors. Depending on the situation, colors may be
allowed to have alpha (translucency).

In GTK+, the main widgets that implement this interface are
`ColorChooserWidget`, `ColorChooserDialog` and `ColorButton`.

# Implements

[`ColorChooserExt`](trait.ColorChooserExt.html)
<!-- trait ColorChooserExt -->
Trait containing all `ColorChooser` methods.

# Implementors

[`ColorButton`](struct.ColorButton.html), [`ColorChooserDialog`](struct.ColorChooserDialog.html), [`ColorChooserWidget`](struct.ColorChooserWidget.html), [`ColorChooser`](struct.ColorChooser.html)
<!-- trait ColorChooserExt::fn add_palette -->
Adds a palette to the color chooser. If `orientation` is horizontal,
the colors are grouped in rows, with `colors_per_line` colors
in each row. If `horizontal` is `false`, the colors are grouped
in columns instead.

The default color palette of `ColorChooserWidget` has
27 colors, organized in columns of 3 colors. The default gray
palette has 9 grays in a single row.

The layout of the color chooser widget works best when the
palettes have 9-10 columns.

Calling this function for the first time has the
side effect of removing the default color and gray palettes
from the color chooser.

If `colors` is `None`, removes all previously added palettes.
## `orientation`
`Orientation::Horizontal` if the palette should
 be displayed in rows, `Orientation::Vertical` for columns
## `colors_per_line`
the number of colors to show in each row/column
## `n_colors`
the total number of elements in `colors`
## `colors`
the colors of the palette, or `None`
<!-- trait ColorChooserExt::fn get_rgba -->
Gets the currently-selected color.
## `color`
a `gdk::RGBA` to fill in with the current color
<!-- trait ColorChooserExt::fn get_use_alpha -->
Returns whether the color chooser shows the alpha channel.

# Returns

`true` if the color chooser uses the alpha channel,
 `false` if not
<!-- trait ColorChooserExt::fn set_rgba -->
Sets the color.
## `color`
the new color
<!-- trait ColorChooserExt::fn set_use_alpha -->
Sets whether or not the color chooser should use the alpha channel.
## `use_alpha`
`true` if color chooser should use alpha channel, `false` if not
<!-- trait ColorChooserExt::fn connect_color_activated -->
Emitted when a color is activated from the color chooser.
This usually happens when the user clicks a color swatch,
or a color is selected and the user presses one of the keys
Space, Shift+Space, Return or Enter.
## `color`
the color
<!-- trait ColorChooserExt::fn get_property_rgba -->
The ::rgba property contains the currently selected color,
as a `gdk::RGBA` struct. The property can be set to change
the current selection programmatically.
<!-- trait ColorChooserExt::fn set_property_rgba -->
The ::rgba property contains the currently selected color,
as a `gdk::RGBA` struct. The property can be set to change
the current selection programmatically.
<!-- trait ColorChooserExt::fn get_property_use-alpha -->
When ::use-alpha is `true`, colors may have alpha (translucency)
information. When it is `false`, the `gdk::RGBA` struct obtained
via the `ColorChooser:rgba` property will be forced to have
alpha == 1.

Implementations are expected to show alpha by rendering the color
over a non-uniform background (like a checkerboard pattern).
<!-- trait ColorChooserExt::fn set_property_use-alpha -->
When ::use-alpha is `true`, colors may have alpha (translucency)
information. When it is `false`, the `gdk::RGBA` struct obtained
via the `ColorChooser:rgba` property will be forced to have
alpha == 1.

Implementations are expected to show alpha by rendering the color
over a non-uniform background (like a checkerboard pattern).
<!-- struct ColorChooserDialog -->
The `ColorChooserDialog` widget is a dialog for choosing
a color. It implements the `ColorChooser` interface.

# Implements

[`ColorChooserDialogExt`](trait.ColorChooserDialogExt.html), [`DialogExt`](trait.DialogExt.html), [`GtkWindowExt`](trait.GtkWindowExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`ColorChooserExt`](trait.ColorChooserExt.html)
<!-- trait ColorChooserDialogExt -->
Trait containing all `ColorChooserDialog` methods.

# Implementors

[`ColorChooserDialog`](struct.ColorChooserDialog.html)
<!-- impl ColorChooserDialog::fn new -->
Creates a new `ColorChooserDialog`.
## `title`
Title of the dialog, or `None`
## `parent`
Transient parent of the dialog, or `None`

# Returns

a new `ColorChooserDialog`
<!-- struct ColorChooserWidget -->
The `ColorChooserWidget` widget lets the user select a
color. By default, the chooser presents a predefined palette
of colors, plus a small number of settable custom colors.
It is also possible to select a different color with the
single-color editor. To enter the single-color editing mode,
use the context menu of any color of the palette, or use the
'+' button to add a new custom color.

The chooser automatically remembers the last selection, as well
as custom colors.

To change the initially selected color, use `ColorChooser::set_rgba`.
To get the selected color use `ColorChooser::get_rgba`.

The `ColorChooserWidget` is used in the `ColorChooserDialog`
to provide a dialog for selecting colors.

# CSS names

`ColorChooserWidget` has a single CSS node with name colorchooser.

# Implements

[`ColorChooserWidgetExt`](trait.ColorChooserWidgetExt.html), [`BoxExt`](trait.BoxExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`OrientableExt`](trait.OrientableExt.html), [`ColorChooserExt`](trait.ColorChooserExt.html)
<!-- trait ColorChooserWidgetExt -->
Trait containing all `ColorChooserWidget` methods.

# Implementors

[`ColorChooserWidget`](struct.ColorChooserWidget.html)
<!-- impl ColorChooserWidget::fn new -->
Creates a new `ColorChooserWidget`.

# Returns

a new `ColorChooserWidget`
<!-- trait ColorChooserWidgetExt::fn get_property_show-editor -->
The ::show-editor property is `true` when the color chooser
is showing the single-color editor. It can be set to switch
the color chooser into single-color editing mode.
<!-- trait ColorChooserWidgetExt::fn set_property_show-editor -->
The ::show-editor property is `true` when the color chooser
is showing the single-color editor. It can be set to switch
the color chooser into single-color editing mode.
<!-- struct ComboBox -->
A `ComboBox` is a widget that allows the user to choose from a list of
valid choices. The `ComboBox` displays the selected choice. When
activated, the `ComboBox` displays a popup which allows the user to
make a new choice. The style in which the selected value is displayed,
and the style of the popup is determined by the current theme. It may
be similar to a Windows-style combo box.

The `ComboBox` uses the model-view pattern; the list of valid choices
is specified in the form of a tree model, and the display of the choices
can be adapted to the data in the model by using cell renderers, as you
would in a tree view. This is possible since `ComboBox` implements the
`CellLayout` interface. The tree model holding the valid choices is
not restricted to a flat list, it can be a real tree, and the popup will
reflect the tree structure.

To allow the user to enter values not in the model, the “has-entry”
property allows the `ComboBox` to contain a `Entry`. This entry
can be accessed by calling `BinExt::get_child` on the combo box.

For a simple list of textual choices, the model-view API of `ComboBox`
can be a bit overwhelming. In this case, `ComboBoxText` offers a
simple alternative. Both `ComboBox` and `ComboBoxText` can contain
an entry.

# CSS nodes


```plain
combobox
├── box.linked
│   ╰── button.combo
│       ╰── box
│           ├── cellview
│           ╰── arrow
╰── window.popup
```

A normal combobox contains a box with the .linked class, a button
with the .combo class and inside those buttons, there are a cellview and
an arrow.


```plain
combobox
├── box.linked
│   ├── entry.combo
│   ╰── button.combo
│       ╰── box
│           ╰── arrow
╰── window.popup
```

A `ComboBox` with an entry has a single CSS node with name combobox. It
contains a box with the .linked class. That box contains an entry and a
button, both with the .combo class added.
The button also contains another node with name arrow.

# Implements

[`ComboBoxExt`](trait.ComboBoxExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`CellEditableExt`](trait.CellEditableExt.html), [`CellLayoutExt`](trait.CellLayoutExt.html)
<!-- trait ComboBoxExt -->
Trait containing all `ComboBox` methods.

# Implementors

[`ComboBoxText`](struct.ComboBoxText.html), [`ComboBox`](struct.ComboBox.html)
<!-- impl ComboBox::fn new -->
Creates a new empty `ComboBox`.

# Returns

A new `ComboBox`.
<!-- impl ComboBox::fn new_with_area -->
Creates a new empty `ComboBox` using `area` to layout cells.
## `area`
the `CellArea` to use to layout cell renderers

# Returns

A new `ComboBox`.
<!-- impl ComboBox::fn new_with_area_and_entry -->
Creates a new empty `ComboBox` with an entry.

The new combo box will use `area` to layout cells.
## `area`
the `CellArea` to use to layout cell renderers

# Returns

A new `ComboBox`.
<!-- impl ComboBox::fn new_with_entry -->
Creates a new empty `ComboBox` with an entry.

# Returns

A new `ComboBox`.
<!-- impl ComboBox::fn new_with_model -->
Creates a new `ComboBox` with the model initialized to `model`.
## `model`
A `TreeModel`.

# Returns

A new `ComboBox`.
<!-- impl ComboBox::fn new_with_model_and_entry -->
Creates a new empty `ComboBox` with an entry
and with the model initialized to `model`.
## `model`
A `TreeModel`

# Returns

A new `ComboBox`
<!-- trait ComboBoxExt::fn get_active -->
Returns the index of the currently active item, or -1 if there’s no
active item. If the model is a non-flat treemodel, and the active item
is not an immediate child of the root of the tree, this function returns
`gtk_tree_path_get_indices (path)[0]`, where
`path` is the `TreePath` of the active item.

# Returns

An integer which is the index of the currently active item,
 or -1 if there’s no active item.
<!-- trait ComboBoxExt::fn get_active_id -->
Returns the ID of the active row of `self`. This value is taken
from the active row and the column specified by the `ComboBox:id-column`
property of `self` (see `ComboBoxExt::set_id_column`).

The returned value is an interned string which means that you can
compare the pointer by value to other interned strings and that you
must not free it.

If the `ComboBox:id-column` property of `self` is not set, or if
no row is active, or if the active row has a `None` ID value, then `None`
is returned.

# Returns

the ID of the active row, or `None`
<!-- trait ComboBoxExt::fn get_active_iter -->
Sets `iter` to point to the current active item, if it exists.
## `iter`
The uninitialized `TreeIter`

# Returns

`true`, if `iter` was set
<!-- trait ComboBoxExt::fn get_add_tearoffs -->
Gets the current value of the :add-tearoffs property.

# Deprecated since 3.10


# Returns

the current value of the :add-tearoffs property.
<!-- trait ComboBoxExt::fn get_button_sensitivity -->
Returns whether the combo box sets the dropdown button
sensitive or not when there are no items in the model.

# Returns

`SensitivityType::On` if the dropdown button
 is sensitive when the model is empty, `SensitivityType::Off`
 if the button is always insensitive or
 `SensitivityType::Auto` if it is only sensitive as long as
 the model has one item to be selected.
<!-- trait ComboBoxExt::fn get_column_span_column -->
Returns the column with column span information for `self`.

# Returns

the column span column.
<!-- trait ComboBoxExt::fn get_entry_text_column -->
Returns the column which `self` is using to get the strings
from to display in the internal entry.

# Returns

A column in the data source model of `self`.
<!-- trait ComboBoxExt::fn get_focus_on_click -->
Returns whether the combo box grabs focus when it is clicked
with the mouse. See `ComboBoxExt::set_focus_on_click`.

# Deprecated since 3.20

Use `WidgetExt::get_focus_on_click` instead

# Returns

`true` if the combo box grabs focus when it is
 clicked with the mouse.
<!-- trait ComboBoxExt::fn get_has_entry -->
Returns whether the combo box has an entry.

# Returns

whether there is an entry in `self`.
<!-- trait ComboBoxExt::fn get_id_column -->
Returns the column which `self` is using to get string IDs
for values from.

# Returns

A column in the data source model of `self`.
<!-- trait ComboBoxExt::fn get_model -->
Returns the `TreeModel` which is acting as data source for `self`.

# Returns

A `TreeModel` which was passed
 during construction.
<!-- trait ComboBoxExt::fn get_popup_accessible -->
Gets the accessible object corresponding to the combo box’s popup.

This function is mostly intended for use by accessibility technologies;
applications should have little use for it.

# Returns

the accessible object corresponding
 to the combo box’s popup.
<!-- trait ComboBoxExt::fn get_popup_fixed_width -->
Gets whether the popup uses a fixed width matching
the allocated width of the combo box.

# Returns

`true` if the popup uses a fixed width
<!-- trait ComboBoxExt::fn get_row_separator_func -->
Returns the current row separator function.

# Returns

the current row separator function.
<!-- trait ComboBoxExt::fn get_row_span_column -->
Returns the column with row span information for `self`.

# Returns

the row span column.
<!-- trait ComboBoxExt::fn get_title -->
Gets the current title of the menu in tearoff mode. See
`ComboBoxExt::set_add_tearoffs`.

# Deprecated since 3.10


# Returns

the menu’s title in tearoff mode. This is an internal copy of the
string which must not be freed.
<!-- trait ComboBoxExt::fn get_wrap_width -->
Returns the wrap width which is used to determine the number of columns
for the popup menu. If the wrap width is larger than 1, the combo box
is in table mode.

# Returns

the wrap width.
<!-- trait ComboBoxExt::fn popdown -->
Hides the menu or dropdown list of `self`.

This function is mostly intended for use by accessibility technologies;
applications should have little use for it.
<!-- trait ComboBoxExt::fn popup -->
Pops up the menu or dropdown list of `self`.

This function is mostly intended for use by accessibility technologies;
applications should have little use for it.

Before calling this, `self` must be mapped, or nothing will happen.
<!-- trait ComboBoxExt::fn popup_for_device -->
Pops up the menu or dropdown list of `self`, the popup window
will be grabbed so only `device` and its associated pointer/keyboard
are the only ``GdkDevices`` able to send events to it.
## `device`
a `gdk::Device`
<!-- trait ComboBoxExt::fn set_active -->
Sets the active item of `self` to be the item at `index`.
## `index_`
An index in the model passed during construction, or -1 to have
no active item
<!-- trait ComboBoxExt::fn set_active_id -->
Changes the active row of `self` to the one that has an ID equal to
`active_id`, or unsets the active row if `active_id` is `None`. Rows having
a `None` ID string cannot be made active by this function.

If the `ComboBox:id-column` property of `self` is unset or if no
row has the given ID then the function does nothing and returns `false`.
## `active_id`
the ID of the row to select, or `None`

# Returns

`true` if a row with a matching ID was found. If a `None`
 `active_id` was given to unset the active row, the function
 always returns `true`.
<!-- trait ComboBoxExt::fn set_active_iter -->
Sets the current active item to be the one referenced by `iter`, or
unsets the active item if `iter` is `None`.
## `iter`
The `TreeIter`, or `None`
<!-- trait ComboBoxExt::fn set_add_tearoffs -->
Sets whether the popup menu should have a tearoff
menu item.

# Deprecated since 3.10

## `add_tearoffs`
`true` to add tearoff menu items
<!-- trait ComboBoxExt::fn set_button_sensitivity -->
Sets whether the dropdown button of the combo box should be
always sensitive (`SensitivityType::On`), never sensitive (`SensitivityType::Off`)
or only if there is at least one item to display (`SensitivityType::Auto`).
## `sensitivity`
specify the sensitivity of the dropdown button
<!-- trait ComboBoxExt::fn set_column_span_column -->
Sets the column with column span information for `self` to be
`column_span`. The column span column contains integers which indicate
how many columns an item should span.
## `column_span`
A column in the model passed during construction
<!-- trait ComboBoxExt::fn set_entry_text_column -->
Sets the model column which `self` should use to get strings from
to be `text_column`. The column `text_column` in the model of `self`
must be of type `G_TYPE_STRING`.

This is only relevant if `self` has been created with
`ComboBox:has-entry` as `true`.
## `text_column`
A column in `model` to get the strings from for
 the internal entry
<!-- trait ComboBoxExt::fn set_focus_on_click -->
Sets whether the combo box will grab focus when it is clicked with
the mouse. Making mouse clicks not grab focus is useful in places
like toolbars where you don’t want the keyboard focus removed from
the main area of the application.

# Deprecated since 3.20

Use `WidgetExt::set_focus_on_click` instead
## `focus_on_click`
whether the combo box grabs focus when clicked
 with the mouse
<!-- trait ComboBoxExt::fn set_id_column -->
Sets the model column which `self` should use to get string IDs
for values from. The column `id_column` in the model of `self`
must be of type `G_TYPE_STRING`.
## `id_column`
A column in `model` to get string IDs for values from
<!-- trait ComboBoxExt::fn set_model -->
Sets the model used by `self` to be `model`. Will unset a previously set
model (if applicable). If model is `None`, then it will unset the model.

Note that this function does not clear the cell renderers, you have to
call `CellLayout::clear` yourself if you need to set up different
cell renderers for the new model.
## `model`
A `TreeModel`
<!-- trait ComboBoxExt::fn set_popup_fixed_width -->
Specifies whether the popup’s width should be a fixed width
matching the allocated width of the combo box.
## `fixed`
whether to use a fixed popup width
<!-- trait ComboBoxExt::fn set_row_separator_func -->
Sets the row separator function, which is used to determine
whether a row should be drawn as a separator. If the row separator
function is `None`, no separators are drawn. This is the default value.
## `func`
a ``GtkTreeViewRowSeparatorFunc``
## `data`
user data to pass to `func`, or `None`
## `destroy`
destroy notifier for `data`, or `None`
<!-- trait ComboBoxExt::fn set_row_span_column -->
Sets the column with row span information for `self` to be `row_span`.
The row span column contains integers which indicate how many rows
an item should span.
## `row_span`
A column in the model passed during construction.
<!-- trait ComboBoxExt::fn set_title -->
Sets the menu’s title in tearoff mode.

# Deprecated since 3.10

## `title`
a title for the menu in tearoff mode
<!-- trait ComboBoxExt::fn set_wrap_width -->
Sets the wrap width of `self` to be `width`. The wrap width is basically
the preferred number of columns when you want the popup to be layed out
in a table.
## `width`
Preferred number of columns
<!-- trait ComboBoxExt::fn connect_changed -->
The changed signal is emitted when the active
item is changed. The can be due to the user selecting
a different item from the list, or due to a
call to `ComboBoxExt::set_active_iter`.
It will also be emitted while typing into the entry of a combo box
with an entry.
<!-- trait ComboBoxExt::fn connect_format_entry_text -->
For combo boxes that are created with an entry (See `ComboBox`:has-entry).

A signal which allows you to change how the text displayed in a combo box's
entry is displayed.

Connect a signal handler which returns an allocated string representing
`path`. That string will then be used to set the text in the combo box's entry.
The default signal handler uses the text from the `ComboBox`::entry-text-column
model column.

Here's an example signal handler which fetches data from the model and
displays it in the entry.

```C
static gchar*
format_entry_text_callback (GtkComboBox *combo,
                            const gchar *path,
                            gpointer     user_data)
{
  GtkTreeIter iter;
  GtkTreeModel model;
  gdouble      value;

  model = gtk_combo_box_get_model (combo);

  gtk_tree_model_get_iter_from_string (model, &iter, path);
  gtk_tree_model_get (model, &iter,
                      THE_DOUBLE_VALUE_COLUMN, &value,
                      -1);

  return g_strdup_printf ("%g", value);
}
```
## `path`
the `TreePath` string from the combo box's current model to format text for

# Returns

a newly allocated string representing `path`
for the current `ComboBox` model.
<!-- trait ComboBoxExt::fn connect_move_active -->
The ::move-active signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to move the active selection.
## `scroll_type`
a `ScrollType`
<!-- trait ComboBoxExt::fn connect_popdown -->
The ::popdown signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to popdown the combo box list.

The default bindings for this signal are Alt+Up and Escape.
<!-- trait ComboBoxExt::fn connect_popup -->
The ::popup signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to popup the combo box list.

The default binding for this signal is Alt+Down.
<!-- trait ComboBoxExt::fn get_property_active -->
The item which is currently active. If the model is a non-flat treemodel,
and the active item is not an immediate child of the root of the tree,
this property has the value
`gtk_tree_path_get_indices (path)[0]`,
where `path` is the `TreePath` of the active item.
<!-- trait ComboBoxExt::fn set_property_active -->
The item which is currently active. If the model is a non-flat treemodel,
and the active item is not an immediate child of the root of the tree,
this property has the value
`gtk_tree_path_get_indices (path)[0]`,
where `path` is the `TreePath` of the active item.
<!-- trait ComboBoxExt::fn get_property_active-id -->
The value of the ID column of the active row.
<!-- trait ComboBoxExt::fn set_property_active-id -->
The value of the ID column of the active row.
<!-- trait ComboBoxExt::fn get_property_add-tearoffs -->
The add-tearoffs property controls whether generated menus
have tearoff menu items.

Note that this only affects menu style combo boxes.

# Deprecated since 3.10

<!-- trait ComboBoxExt::fn set_property_add-tearoffs -->
The add-tearoffs property controls whether generated menus
have tearoff menu items.

Note that this only affects menu style combo boxes.

# Deprecated since 3.10

<!-- trait ComboBoxExt::fn get_property_button-sensitivity -->
Whether the dropdown button is sensitive when
the model is empty.
<!-- trait ComboBoxExt::fn set_property_button-sensitivity -->
Whether the dropdown button is sensitive when
the model is empty.
<!-- trait ComboBoxExt::fn get_property_cell-area -->
The `CellArea` used to layout cell renderers for this combo box.

If no area is specified when creating the combo box with `ComboBox::new_with_area`
a horizontally oriented `CellAreaBox` will be used.
<!-- trait ComboBoxExt::fn set_property_cell-area -->
The `CellArea` used to layout cell renderers for this combo box.

If no area is specified when creating the combo box with `ComboBox::new_with_area`
a horizontally oriented `CellAreaBox` will be used.
<!-- trait ComboBoxExt::fn get_property_column-span-column -->
If this is set to a non-negative value, it must be the index of a column
of type `G_TYPE_INT` in the model.

The values of that column are used to determine how many columns a value
in the list will span.
<!-- trait ComboBoxExt::fn set_property_column-span-column -->
If this is set to a non-negative value, it must be the index of a column
of type `G_TYPE_INT` in the model.

The values of that column are used to determine how many columns a value
in the list will span.
<!-- trait ComboBoxExt::fn get_property_entry-text-column -->
The column in the combo box's model to associate with strings from the entry
if the combo was created with `ComboBox:has-entry` = `true`.
<!-- trait ComboBoxExt::fn set_property_entry-text-column -->
The column in the combo box's model to associate with strings from the entry
if the combo was created with `ComboBox:has-entry` = `true`.
<!-- trait ComboBoxExt::fn get_property_has-entry -->
Whether the combo box has an entry.
<!-- trait ComboBoxExt::fn set_property_has-entry -->
Whether the combo box has an entry.
<!-- trait ComboBoxExt::fn get_property_has-frame -->
The has-frame property controls whether a frame
is drawn around the entry.
<!-- trait ComboBoxExt::fn set_property_has-frame -->
The has-frame property controls whether a frame
is drawn around the entry.
<!-- trait ComboBoxExt::fn get_property_id-column -->
The column in the combo box's model that provides string
IDs for the values in the model, if != -1.
<!-- trait ComboBoxExt::fn set_property_id-column -->
The column in the combo box's model that provides string
IDs for the values in the model, if != -1.
<!-- trait ComboBoxExt::fn get_property_model -->
The model from which the combo box takes the values shown
in the list.
<!-- trait ComboBoxExt::fn set_property_model -->
The model from which the combo box takes the values shown
in the list.
<!-- trait ComboBoxExt::fn get_property_popup-fixed-width -->
Whether the popup's width should be a fixed width matching the
allocated width of the combo box.
<!-- trait ComboBoxExt::fn set_property_popup-fixed-width -->
Whether the popup's width should be a fixed width matching the
allocated width of the combo box.
<!-- trait ComboBoxExt::fn get_property_popup-shown -->
Whether the combo boxes dropdown is popped up.
Note that this property is mainly useful, because
it allows you to connect to notify::popup-shown.
<!-- trait ComboBoxExt::fn get_property_row-span-column -->
If this is set to a non-negative value, it must be the index of a column
of type `G_TYPE_INT` in the model.

The values of that column are used to determine how many rows a value in
the list will span. Therefore, the values in the model column pointed to
by this property must be greater than zero and not larger than wrap-width.
<!-- trait ComboBoxExt::fn set_property_row-span-column -->
If this is set to a non-negative value, it must be the index of a column
of type `G_TYPE_INT` in the model.

The values of that column are used to determine how many rows a value in
the list will span. Therefore, the values in the model column pointed to
by this property must be greater than zero and not larger than wrap-width.
<!-- trait ComboBoxExt::fn get_property_tearoff-title -->
A title that may be displayed by the window manager
when the popup is torn-off.

# Deprecated since 3.10

<!-- trait ComboBoxExt::fn set_property_tearoff-title -->
A title that may be displayed by the window manager
when the popup is torn-off.

# Deprecated since 3.10

<!-- trait ComboBoxExt::fn get_property_wrap-width -->
If wrap-width is set to a positive value, the list will be
displayed in multiple columns, the number of columns is
determined by wrap-width.
<!-- trait ComboBoxExt::fn set_property_wrap-width -->
If wrap-width is set to a positive value, the list will be
displayed in multiple columns, the number of columns is
determined by wrap-width.
<!-- struct ComboBoxText -->
A `ComboBoxText` is a simple variant of `ComboBox` that hides
the model-view complexity for simple text-only use cases.

To create a `ComboBoxText`, use `ComboBoxText::new` or
`ComboBoxText::new_with_entry`.

You can add items to a `ComboBoxText` with
`ComboBoxTextExt::append_text`, `ComboBoxTextExt::insert_text`
or `ComboBoxTextExt::prepend_text` and remove options with
`ComboBoxTextExt::remove`.

If the `ComboBoxText` contains an entry (via the “has-entry” property),
its contents can be retrieved using `ComboBoxTextExt::get_active_text`.
The entry itself can be accessed by calling `BinExt::get_child` on the
combo box.

You should not call `ComboBoxExt::set_model` or attempt to pack more cells
into this combo box via its `CellLayout` interface.

# `ComboBoxText` as `Buildable`

The `ComboBoxText` implementation of the `Buildable` interface supports
adding items directly using the `<items>` element and specifying `<item>`
elements for each item. Each `<item>` element can specify the “id”
corresponding to the appended text and also supports the regular
translation attributes “translatable”, “context” and “comments”.

Here is a UI definition fragment specifying `ComboBoxText` items:

```plain
combobox
╰── box.linked
    ├── entry.combo
    ├── button.combo
    ╰── window.popup
```

`ComboBoxText` has a single CSS node with name combobox. It adds
the style class .combo to the main CSS nodes of its entry and button
children, and the .linked class to the node of its internal box.

# Implements

[`ComboBoxTextExt`](trait.ComboBoxTextExt.html), [`ComboBoxExt`](trait.ComboBoxExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`CellEditableExt`](trait.CellEditableExt.html), [`CellLayoutExt`](trait.CellLayoutExt.html)
<!-- trait ComboBoxTextExt -->
Trait containing all `ComboBoxText` methods.

# Implementors

[`ComboBoxText`](struct.ComboBoxText.html)
<!-- impl ComboBoxText::fn new -->
Creates a new `ComboBoxText`, which is a `ComboBox` just displaying
strings.

# Returns

A new `ComboBoxText`
<!-- impl ComboBoxText::fn new_with_entry -->
Creates a new `ComboBoxText`, which is a `ComboBox` just displaying
strings. The combo box created by this function has an entry.

# Returns

a new `ComboBoxText`
<!-- trait ComboBoxTextExt::fn append -->
Appends `text` to the list of strings stored in `self`.
If `id` is non-`None` then it is used as the ID of the row.

This is the same as calling `ComboBoxTextExt::insert` with a
position of -1.
## `id`
a string ID for this value, or `None`
## `text`
A string
<!-- trait ComboBoxTextExt::fn append_text -->
Appends `text` to the list of strings stored in `self`.

This is the same as calling `ComboBoxTextExt::insert_text` with a
position of -1.
## `text`
A string
<!-- trait ComboBoxTextExt::fn get_active_text -->
Returns the currently active string in `self`, or `None`
if none is selected. If `self` contains an entry, this
function will return its contents (which will not necessarily
be an item from the list).

# Returns

a newly allocated string containing the
 currently active text. Must be freed with `g_free`.
<!-- trait ComboBoxTextExt::fn insert -->
Inserts `text` at `position` in the list of strings stored in `self`.
If `id` is non-`None` then it is used as the ID of the row. See
`ComboBox:id-column`.

If `position` is negative then `text` is appended.
## `position`
An index to insert `text`
## `id`
a string ID for this value, or `None`
## `text`
A string to display
<!-- trait ComboBoxTextExt::fn insert_text -->
Inserts `text` at `position` in the list of strings stored in `self`.

If `position` is negative then `text` is appended.

This is the same as calling `ComboBoxTextExt::insert` with a `None`
ID string.
## `position`
An index to insert `text`
## `text`
A string
<!-- trait ComboBoxTextExt::fn prepend -->
Prepends `text` to the list of strings stored in `self`.
If `id` is non-`None` then it is used as the ID of the row.

This is the same as calling `ComboBoxTextExt::insert` with a
position of 0.
## `id`
a string ID for this value, or `None`
## `text`
a string
<!-- trait ComboBoxTextExt::fn prepend_text -->
Prepends `text` to the list of strings stored in `self`.

This is the same as calling `ComboBoxTextExt::insert_text` with a
position of 0.
## `text`
A string
<!-- trait ComboBoxTextExt::fn remove -->
Removes the string at `position` from `self`.
## `position`
Index of the item to remove
<!-- trait ComboBoxTextExt::fn remove_all -->
Removes all the text entries from the combo box.
<!-- struct Container -->
A GTK+ user interface is constructed by nesting widgets inside widgets.
Container widgets are the inner nodes in the resulting tree of widgets:
they contain other widgets. So, for example, you might have a `Window`
containing a `Frame` containing a `Label`. If you wanted an image instead
of a textual label inside the frame, you might replace the `Label` widget
with a `Image` widget.

There are two major kinds of container widgets in GTK+. Both are subclasses
of the abstract `Container` base class.

The first type of container widget has a single child widget and derives
from `Bin`. These containers are decorators, which
add some kind of functionality to the child. For example, a `Button` makes
its child into a clickable button; a `Frame` draws a frame around its child
and a `Window` places its child widget inside a top-level window.

The second type of container can have more than one child; its purpose is to
manage layout. This means that these containers assign
sizes and positions to their children. For example, a `HBox` arranges its
children in a horizontal row, and a `Grid` arranges the widgets it contains
in a two-dimensional grid.

For implementations of `Container` the virtual method `ContainerClass.forall`()
is always required, since it's used for drawing and other internal operations
on the children.
If the `Container` implementation expect to have non internal children
it's needed to implement both `ContainerClass.add`() and `ContainerClass.remove`().
If the `Container` implementation has internal children, they should be added
with `WidgetExt::set_parent` on `init` and removed with `WidgetExt::unparent`
in the `WidgetClass.destroy`() implementation.
See more about implementing custom widgets at https://wiki.gnome.org/HowDoI/CustomWidgets

# Height for width geometry management

GTK+ uses a height-for-width (and width-for-height) geometry management system.
Height-for-width means that a widget can change how much vertical space it needs,
depending on the amount of horizontal space that it is given (and similar for
width-for-height).

There are some things to keep in mind when implementing container widgets
that make use of GTK+’s height for width geometry management system. First,
it’s important to note that a container must prioritize one of its
dimensions, that is to say that a widget or container can only have a
`SizeRequestMode` that is `SizeRequestMode::HeightForWidth` or
`SizeRequestMode::WidthForHeight`. However, every widget and container
must be able to respond to the APIs for both dimensions, i.e. even if a
widget has a request mode that is height-for-width, it is possible that
its parent will request its sizes using the width-for-height APIs.

To ensure that everything works properly, here are some guidelines to follow
when implementing height-for-width (or width-for-height) containers.

Each request mode involves 2 virtual methods. Height-for-width apis run
through `WidgetExt::get_preferred_width` and then through `WidgetExt::get_preferred_height_for_width`.
When handling requests in the opposite `SizeRequestMode` it is important that
every widget request at least enough space to display all of its content at all times.

When `WidgetExt::get_preferred_height` is called on a container that is height-for-width,
the container must return the height for its minimum width. This is easily achieved by
simply calling the reverse apis implemented for itself as follows:


```C
static void
foo_container_get_preferred_height (GtkWidget *widget,
                                    gint *min_height,
                                    gint *nat_height)
{
   if (i_am_in_height_for_width_mode)
     {
       gint min_width;

       GTK_WIDGET_GET_CLASS (widget)->get_preferred_width (widget,
                                                           &min_width,
                                                           NULL);
       GTK_WIDGET_GET_CLASS (widget)->get_preferred_height_for_width
                                                          (widget,
                                                           min_width,
                                                           min_height,
                                                           nat_height);
     }
   else
     {
       ... many containers support both request modes, execute the
       real width-for-height request here by returning the
       collective heights of all widgets that are stacked
       vertically (or whatever is appropriate for this container)
       ...
     }
}
```

Similarly, when `WidgetExt::get_preferred_width_for_height` is called for a container or widget
that is height-for-width, it then only needs to return the base minimum width like so:


```C
static void
foo_container_get_preferred_width_for_height (GtkWidget *widget,
                                              gint for_height,
                                              gint *min_width,
                                              gint *nat_width)
{
   if (i_am_in_height_for_width_mode)
     {
       GTK_WIDGET_GET_CLASS (widget)->get_preferred_width (widget,
                                                           min_width,
                                                           nat_width);
     }
   else
     {
       ... execute the real width-for-height request here based on
       the required width of the children collectively if the
       container were to be allocated the said height ...
     }
}
```

Height for width requests are generally implemented in terms of a virtual allocation
of widgets in the input orientation. Assuming an height-for-width request mode, a container
would implement the `get_preferred_height_for_width` virtual function by first calling
`WidgetExt::get_preferred_width` for each of its children.

For each potential group of children that are lined up horizontally, the values returned by
`WidgetExt::get_preferred_width` should be collected in an array of `RequestedSize` structures.
Any child spacing should be removed from the input `for_width` and then the collective size should be
allocated using the `gtk_distribute_natural_allocation` convenience function.

The container will then move on to request the preferred height for each child by using
`WidgetExt::get_preferred_height_for_width` and using the sizes stored in the `RequestedSize` array.

To allocate a height-for-width container, it’s again important
to consider that a container must prioritize one dimension over the other. So if
a container is a height-for-width container it must first allocate all widgets horizontally
using a `RequestedSize` array and `gtk_distribute_natural_allocation` and then add any
extra space (if and where appropriate) for the widget to expand.

After adding all the expand space, the container assumes it was allocated sufficient
height to fit all of its content. At this time, the container must use the total horizontal sizes
of each widget to request the height-for-width of each of its children and store the requests in a
`RequestedSize` array for any widgets that stack vertically (for tabular containers this can
be generalized into the heights and widths of rows and columns).
The vertical space must then again be distributed using `gtk_distribute_natural_allocation`
while this time considering the allocated height of the widget minus any vertical spacing
that the container adds. Then vertical expand space should be added where appropriate and available
and the container should go on to actually allocating the child widgets.

See [`Widget`’s geometry management section][geometry-management]
to learn more about implementing height-for-width geometry management for widgets.

# Child properties

`Container` introduces child properties.
These are object properties that are not specific
to either the container or the contained widget, but rather to their relation.
Typical examples of child properties are the position or pack-type of a widget
which is contained in a `Box`.

Use `ContainerClass::install_child_property` to install child properties
for a container class and `ContainerClass::find_child_property` or
`ContainerClass::list_child_properties` to get information about existing
child properties.

To set the value of a child property, use `Container::child_set_property`,
`ContainerExt::child_set` or `ContainerExt::child_set_valist`.
To obtain the value of a child property, use
`Container::child_get_property`, `ContainerExt::child_get` or
`ContainerExt::child_get_valist`. To emit notification about child property
changes, use `WidgetExt::child_notify`.

# `Container` as `Buildable`

The `Container` implementation of the `Buildable` interface supports
a `<packing>` element for children, which can contain multiple `<property>`
elements that specify child properties for the child.

Since 2.16, child properties can also be marked as translatable using
the same “translatable”, “comments” and “context” attributes that are used
for regular properties.

Since 3.16, containers can have a `<focus-chain>` element containing multiple
`<widget>` elements, one for each child that should be added to the focus
chain. The ”name” attribute gives the id of the widget.

An example of these properties in UI definitions:

```text
<object class="GtkBox">
  <child>
    <object class="GtkEntry" id="entry1"/>
    <packing>
      <property name="pack-type">start</property>
    </packing>
  </child>
  <child>
    <object class="GtkEntry" id="entry2"/>
  </child>
  <focus-chain>
    <widget name="entry1"/>
    <widget name="entry2"/>
  </focus-chain>
</object>
```

# Implements

[`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait ContainerExt -->
Trait containing all `Container` methods.

# Implementors

[`Bin`](struct.Bin.html), [`Box`](struct.Box.html), [`Container`](struct.Container.html), [`Fixed`](struct.Fixed.html), [`FlowBox`](struct.FlowBox.html), [`Grid`](struct.Grid.html), [`HeaderBar`](struct.HeaderBar.html), [`IconView`](struct.IconView.html), [`Layout`](struct.Layout.html), [`ListBox`](struct.ListBox.html), [`MenuShell`](struct.MenuShell.html), [`Notebook`](struct.Notebook.html), [`Paned`](struct.Paned.html), [`Stack`](struct.Stack.html), [`TextView`](struct.TextView.html), [`ToolItemGroup`](struct.ToolItemGroup.html), [`ToolPalette`](struct.ToolPalette.html), [`Toolbar`](struct.Toolbar.html), [`TreeView`](struct.TreeView.html)
<!-- trait ContainerExt::fn add -->
Adds `widget` to `self`. Typically used for simple containers
such as `Window`, `Frame`, or `Button`; for more complicated
layout containers such as `Box` or `Grid`, this function will
pick default packing parameters that may not be correct. So
consider functions such as `BoxExt::pack_start` and
`GridExt::attach` as an alternative to `ContainerExt::add` in
those cases. A widget may be added to only one container at a time;
you can’t place the same widget inside two different containers.

Note that some containers, such as `ScrolledWindow` or `ListBox`,
may add intermediate children between the added widget and the
container.
## `widget`
a widget to be placed inside `self`
<!-- trait ContainerExt::fn add_with_properties -->
Adds `widget` to `self`, setting child properties at the same time.
See `ContainerExt::add` and `ContainerExt::child_set` for more details.
## `widget`
a widget to be placed inside `self`
## `first_prop_name`
the name of the first child property to set
<!-- trait ContainerExt::fn child_get -->
Gets the values of one or more child properties for `child` and `self`.
## `child`
a widget which is a child of `self`
## `first_prop_name`
the name of the first property to get
<!-- trait ContainerExt::fn child_get_property -->
Gets the value of a child property for `child` and `self`.
## `child`
a widget which is a child of `self`
## `property_name`
the name of the property to get
## `value`
a location to return the value
<!-- trait ContainerExt::fn child_get_valist -->
Gets the values of one or more child properties for `child` and `self`.
## `child`
a widget which is a child of `self`
## `first_property_name`
the name of the first property to get
## `var_args`
return location for the first property, followed
 optionally by more name/return location pairs, followed by `None`
<!-- trait ContainerExt::fn child_notify -->
Emits a `Widget::child-notify` signal for the
[child property][child-properties]
`child_property` on the child.

This is an analogue of `gobject::ObjectExt::notify` for child properties.

Also see `WidgetExt::child_notify`.
## `child`
the child widget
## `child_property`
the name of a child property installed on
 the class of `self`
<!-- trait ContainerExt::fn child_notify_by_pspec -->
Emits a `Widget::child-notify` signal for the
[child property][child-properties] specified by
`pspec` on the child.

This is an analogue of `gobject::ObjectExt::notify_by_pspec` for child properties.

Feature: `v3_18`

## `child`
the child widget
## `pspec`
the `gobject::ParamSpec` of a child property instealled on
 the class of `self`
<!-- trait ContainerExt::fn child_set -->
Sets one or more child properties for `child` and `self`.
## `child`
a widget which is a child of `self`
## `first_prop_name`
the name of the first property to set
<!-- trait ContainerExt::fn child_set_property -->
Sets a child property for `child` and `self`.
## `child`
a widget which is a child of `self`
## `property_name`
the name of the property to set
## `value`
the value to set the property to
<!-- trait ContainerExt::fn child_set_valist -->
Sets one or more child properties for `child` and `self`.
## `child`
a widget which is a child of `self`
## `first_property_name`
the name of the first property to set
## `var_args`
a `None`-terminated list of property names and values, starting
 with `first_prop_name`
<!-- trait ContainerExt::fn child_type -->
Returns the type of the children supported by the container.

Note that this may return `G_TYPE_NONE` to indicate that no more
children can be added, e.g. for a `Paned` which already has two
children.

# Returns

a `glib::Type`.
<!-- trait ContainerExt::fn forall -->
Invokes `callback` on each direct child of `self`, including
children that are considered “internal” (implementation details
of the container). “Internal” children generally weren’t added
by the user of the container, but were added by the container
implementation itself.

Most applications should use `ContainerExt::foreach`, rather
than `ContainerExt::forall`.
## `callback`
a callback
## `callback_data`
callback user data
<!-- trait ContainerExt::fn foreach -->
Invokes `callback` on each non-internal child of `self`.
See `ContainerExt::forall` for details on what constitutes
an “internal” child. For all practical purposes, this function
should iterate over precisely those child widgets that were
added to the container by the application with explicit `add`
calls.

Most applications should use `ContainerExt::foreach`,
rather than `ContainerExt::forall`.
## `callback`
a callback
## `callback_data`
callback user data
<!-- trait ContainerExt::fn get_border_width -->
Retrieves the border width of the container. See
`ContainerExt::set_border_width`.

# Returns

the current border width
<!-- trait ContainerExt::fn get_children -->
Returns the container’s non-internal children. See
`ContainerExt::forall` for details on what constitutes an "internal" child.

# Returns

a newly-allocated list of the container’s non-internal children.
<!-- trait ContainerExt::fn get_focus_chain -->
Retrieves the focus chain of the container, if one has been
set explicitly. If no focus chain has been explicitly
set, GTK+ computes the focus chain based on the positions
of the children. In that case, GTK+ stores `None` in
`focusable_widgets` and returns `false`.
## `focusable_widgets`
location
 to store the focus chain of the
 container, or `None`. You should free this list
 using `glib::List::free` when you are done with it, however
 no additional reference count is added to the
 individual widgets in the focus chain.

# Returns

`true` if the focus chain of the container
has been set explicitly.
<!-- trait ContainerExt::fn get_focus_child -->
Returns the current focus child widget inside `self`. This is not the
currently focused widget. That can be obtained by calling
`GtkWindowExt::get_focus`.

# Returns

The child widget which will receive the
 focus inside `self` when the `self` is focused,
 or `None` if none is set.
<!-- trait ContainerExt::fn get_focus_hadjustment -->
Retrieves the horizontal focus adjustment for the container. See
gtk_container_set_focus_hadjustment ().

# Returns

the horizontal focus adjustment, or `None` if
 none has been set.
<!-- trait ContainerExt::fn get_focus_vadjustment -->
Retrieves the vertical focus adjustment for the container. See
`ContainerExt::set_focus_vadjustment`.

# Returns

the vertical focus adjustment, or
 `None` if none has been set.
<!-- trait ContainerExt::fn get_path_for_child -->
Returns a newly created widget path representing all the widget hierarchy
from the toplevel down to and including `child`.
## `child`
a child of `self`

# Returns

A newly created `WidgetPath`
<!-- trait ContainerExt::fn get_resize_mode -->
Returns the resize mode for the container. See
gtk_container_set_resize_mode ().

# Deprecated since 3.12

Resize modes are deprecated. They aren’t necessary
 anymore since frame clocks and might introduce obscure bugs if
 used.

# Returns

the current resize mode
<!-- trait ContainerExt::fn propagate_draw -->
When a container receives a call to the draw function, it must send
synthetic `Widget::draw` calls to all children that don’t have their
own ``GdkWindows``. This function provides a convenient way of doing this.
A container, when it receives a call to its `Widget::draw` function,
calls `ContainerExt::propagate_draw` once for each child, passing in
the `cr` the container received.

`ContainerExt::propagate_draw` takes care of translating the origin of `cr`,
and deciding whether the draw needs to be sent to the child. It is a
convenient and optimized way of getting the same effect as calling
`WidgetExt::draw` on the child directly.

In most cases, a container can simply either inherit the
`Widget::draw` implementation from `Container`, or do some drawing
and then chain to the ::draw implementation from `Container`.
## `child`
a child of `self`
## `cr`
Cairo context as passed to the container. If you want to use `cr`
 in container’s draw function, consider using `cairo_save` and
 `cairo_restore` before calling this function.
<!-- trait ContainerExt::fn remove -->
Removes `widget` from `self`. `widget` must be inside `self`.
Note that `self` will own a reference to `widget`, and that this
may be the last reference held; so removing a widget from its
container can destroy that widget. If you want to use `widget`
again, you need to add a reference to it before removing it from
a container, using `gobject::ObjectExt::ref`. If you don’t want to use `widget`
again it’s usually more efficient to simply destroy it directly
using `WidgetExt::destroy` since this will remove it from the
container and help break any circular reference count cycles.
## `widget`
a current child of `self`
<!-- trait ContainerExt::fn resize_children -->

# Deprecated since 3.10

<!-- trait ContainerExt::fn set_border_width -->
Sets the border width of the container.

The border width of a container is the amount of space to leave
around the outside of the container. The only exception to this is
`Window`; because toplevel windows can’t leave space outside,
they leave the space inside. The border is added on all sides of
the container. To add space to only one side, use a specific
`Widget:margin` property on the child widget, for example
`Widget:margin-top`.
## `border_width`
amount of blank space to leave outside
 the container. Valid values are in the range 0-65535 pixels.
<!-- trait ContainerExt::fn set_focus_chain -->
Sets a focus chain, overriding the one computed automatically by GTK+.

In principle each widget in the chain should be a descendant of the
container, but this is not enforced by this method, since it’s allowed
to set the focus chain before you pack the widgets, or have a widget
in the chain that isn’t always packed. The necessary checks are done
when the focus chain is actually traversed.
## `focusable_widgets`

 the new focus chain
<!-- trait ContainerExt::fn set_focus_child -->
Sets, or unsets if `child` is `None`, the focused child of `self`.

This function emits the `Container`::set_focus_child signal of
`self`. Implementations of `Container` can override the
default behaviour by overriding the class closure of this signal.

This is function is mostly meant to be used by widgets. Applications can use
`WidgetExt::grab_focus` to manually set the focus to a specific widget.
## `child`
a `Widget`, or `None`
<!-- trait ContainerExt::fn set_focus_hadjustment -->
Hooks up an adjustment to focus handling in a container, so when a child
of the container is focused, the adjustment is scrolled to show that
widget. This function sets the horizontal alignment.
See `ScrolledWindowExt::get_hadjustment` for a typical way of obtaining
the adjustment and `ContainerExt::set_focus_vadjustment` for setting
the vertical adjustment.

The adjustments have to be in pixel units and in the same coordinate
system as the allocation for immediate children of the container.
## `adjustment`
an adjustment which should be adjusted when the focus is
 moved among the descendents of `self`
<!-- trait ContainerExt::fn set_focus_vadjustment -->
Hooks up an adjustment to focus handling in a container, so when a
child of the container is focused, the adjustment is scrolled to
show that widget. This function sets the vertical alignment. See
`ScrolledWindowExt::get_vadjustment` for a typical way of obtaining
the adjustment and `ContainerExt::set_focus_hadjustment` for setting
the horizontal adjustment.

The adjustments have to be in pixel units and in the same coordinate
system as the allocation for immediate children of the container.
## `adjustment`
an adjustment which should be adjusted when the focus
 is moved among the descendents of `self`
<!-- trait ContainerExt::fn set_reallocate_redraws -->
Sets the `reallocate_redraws` flag of the container to the given value.

Containers requesting reallocation redraws get automatically
redrawn if any of their children changed allocation.

# Deprecated since 3.14

Call `WidgetExt::queue_draw` in your size_allocate handler.
## `needs_redraws`
the new value for the container’s `reallocate_redraws` flag
<!-- trait ContainerExt::fn set_resize_mode -->
Sets the resize mode for the container.

The resize mode of a container determines whether a resize request
will be passed to the container’s parent, queued for later execution
or executed immediately.

# Deprecated since 3.12

Resize modes are deprecated. They aren’t necessary
 anymore since frame clocks and might introduce obscure bugs if
 used.
## `resize_mode`
the new resize mode
<!-- trait ContainerExt::fn unset_focus_chain -->
Removes a focus chain explicitly set with `ContainerExt::set_focus_chain`.
<!-- enum CornerType -->
Specifies which corner a child widget should be placed in when packed into
a `ScrolledWindow`. This is effectively the opposite of where the scroll
bars are placed.
<!-- enum CornerType::variant TopLeft -->
Place the scrollbars on the right and bottom of the
 widget (default behaviour).
<!-- enum CornerType::variant BottomLeft -->
Place the scrollbars on the top and right of the
 widget.
<!-- enum CornerType::variant TopRight -->
Place the scrollbars on the left and bottom of the
 widget.
<!-- enum CornerType::variant BottomRight -->
Place the scrollbars on the top and left of the
 widget.
<!-- struct CssProvider -->
`CssProvider` is an object implementing the `StyleProvider` interface.
It is able to parse [CSS-like][css-overview] input in order to style widgets.

An application can make GTK+ parse a specific CSS style sheet by calling
`CssProviderExt::load_from_file` or `CssProviderExt::load_from_resource`
and adding the provider with `StyleContextExt::add_provider` or
`StyleContext::add_provider_for_screen`.

In addition, certain files will be read when GTK+ is initialized. First, the
file `$XDG_CONFIG_HOME/gtk-3.0/gtk.css` is loaded if it exists. Then, GTK+
loads the first existing file among
`XDG_DATA_HOME/themes/theme-name/gtk-VERSION/gtk.css`,
`$HOME/.themes/theme-name/gtk-VERSION/gtk.css`,
`$XDG_DATA_DIRS/themes/theme-name/gtk-VERSION/gtk.css` and
`DATADIR/share/themes/THEME/gtk-VERSION/gtk.css`, where `THEME` is the name of
the current theme (see the `Settings:gtk-theme-name` setting), `DATADIR`
is the prefix configured when GTK+ was compiled (unless overridden by the
`GTK_DATA_PREFIX` environment variable), and `VERSION` is the GTK+ version number.
If no file is found for the current version, GTK+ tries older versions all the
way back to 3.0.

In the same way, GTK+ tries to load a gtk-keys.css file for the current
key theme, as defined by `Settings:gtk-key-theme-name`.

# Implements

[`CssProviderExt`](trait.CssProviderExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`StyleProviderExt`](trait.StyleProviderExt.html)
<!-- trait CssProviderExt -->
Trait containing all `CssProvider` methods.

# Implementors

[`CssProvider`](struct.CssProvider.html)
<!-- impl CssProvider::fn new -->
Returns a newly created `CssProvider`.

# Returns

A new `CssProvider`
<!-- impl CssProvider::fn get_default -->
Returns the provider containing the style settings used as a
fallback for all widgets.

# Returns

The provider used for fallback styling.
 This memory is owned by GTK+, and you must not free it.
<!-- impl CssProvider::fn get_named -->
Loads a theme from the usual theme paths
## `name`
A theme name
## `variant`
variant to load, for example, "dark", or
 `None` for the default

# Returns

a `CssProvider` with the theme loaded.
 This memory is owned by GTK+, and you must not free it.
<!-- trait CssProviderExt::fn load_from_data -->
Loads `data` into `self`, and by doing so clears any previously loaded
information.
## `data`
CSS data loaded in memory
## `length`
the length of `data` in bytes, or -1 for NUL terminated strings. If
 `length` is not -1, the code will assume it is not NUL terminated and will
 potentially do a copy.

# Returns

`true`. The return value is deprecated and `false` will only be
 returned for backwards compatibility reasons if an `error` is not
 `None` and a loading error occurred. To track errors while loading
 CSS, connect to the `CssProvider::parsing-error` signal.
<!-- trait CssProviderExt::fn load_from_file -->
Loads the data contained in `file` into `self`, making it
clear any previously loaded information.
## `file`
`gio::File` pointing to a file to load

# Returns

`true`. The return value is deprecated and `false` will only be
 returned for backwards compatibility reasons if an `error` is not
 `None` and a loading error occurred. To track errors while loading
 CSS, connect to the `CssProvider::parsing-error` signal.
<!-- trait CssProviderExt::fn load_from_path -->
Loads the data contained in `path` into `self`, making it clear
any previously loaded information.
## `path`
the path of a filename to load, in the GLib filename encoding

# Returns

`true`. The return value is deprecated and `false` will only be
 returned for backwards compatibility reasons if an `error` is not
 `None` and a loading error occurred. To track errors while loading
 CSS, connect to the `CssProvider::parsing-error` signal.
<!-- trait CssProviderExt::fn load_from_resource -->
Loads the data contained in the resource at `resource_path` into
the `CssProvider`, clearing any previously loaded information.

To track errors while loading CSS, connect to the
`CssProvider::parsing-error` signal.

Feature: `v3_16`

## `resource_path`
a `gio::Resource` resource path
<!-- trait CssProviderExt::fn to_string -->
Converts the `self` into a string representation in CSS
format.

Using `CssProviderExt::load_from_data` with the return value
from this function on a new provider created with
`CssProvider::new` will basically create a duplicate of
this `self`.

# Returns

a new string representing the `self`.
<!-- trait CssProviderExt::fn connect_parsing_error -->
Signals that a parsing error occurred. the `path`, `line` and `position`
describe the actual location of the error as accurately as possible.

Parsing errors are never fatal, so the parsing will resume after
the error. Errors may however cause parts of the given
data or even all of it to not be parsed at all. So it is a useful idea
to check that the parsing succeeds by connecting to this signal.

Note that this signal may be emitted at any time as the css provider
may opt to defer parsing parts or all of the input to a later time
than when a loading function was called.
## `section`
section the error happened in
## `error`
The parsing error
<!-- enum CssProviderError -->
Error codes for `GTK_CSS_PROVIDER_ERROR`.
<!-- enum CssProviderError::variant Failed -->
Failed.
<!-- enum CssProviderError::variant Syntax -->
Syntax error.
<!-- enum CssProviderError::variant Import -->
Import error.
<!-- enum CssProviderError::variant Name -->
Name error.
<!-- enum CssProviderError::variant Deprecated -->
Deprecation error.
<!-- enum CssProviderError::variant UnknownValue -->
Unknown value.
<!-- struct CssSection -->
Defines a part of a CSS document. Because sections are nested into
one another, you can use `CssSection::get_parent` to get the
containing region.
<!-- impl CssSection::fn get_end_line -->
Returns the line in the CSS document where this section end.
The line number is 0-indexed, so the first line of the document
will return 0.
This value may change in future invocations of this function if
`self` is not yet parsed completely. This will for example
happen in the `CssProvider`::parsing-error signal.
The end position and line may be identical to the start
position and line for sections which failed to parse anything
successfully.

# Returns

the line number
<!-- impl CssSection::fn get_end_position -->
Returns the offset in bytes from the start of the current line
returned via `CssSection::get_end_line`.
This value may change in future invocations of this function if
`self` is not yet parsed completely. This will for example
happen in the `CssProvider`::parsing-error signal.
The end position and line may be identical to the start
position and line for sections which failed to parse anything
successfully.

# Returns

the offset in bytes from the start of the line.
<!-- impl CssSection::fn get_file -->
Gets the file that `self` was parsed from. If no such file exists,
for example because the CSS was loaded via
`CssProviderExt::load_from_data`(), then `None` is returned.

# Returns

the `gio::File` that `self` was parsed from
 or `None` if `self` was parsed from other data
<!-- impl CssSection::fn get_parent -->
Gets the parent section for the given `self`. The parent section is
the section that contains this `self`. A special case are sections of
type `CssSectionType::Document`. Their parent will either be `None`
if they are the original CSS document that was loaded by
`CssProviderExt::load_from_file` or a section of type
`CssSectionType::Import` if it was loaded with an import rule from
a different file.

# Returns

the parent section or `None` if none
<!-- impl CssSection::fn get_section_type -->
Gets the type of information that `self` describes.

# Returns

the type of `self`
<!-- impl CssSection::fn get_start_line -->
Returns the line in the CSS document where this section starts.
The line number is 0-indexed, so the first line of the document
will return 0.

# Returns

the line number
<!-- impl CssSection::fn get_start_position -->
Returns the offset in bytes from the start of the current line
returned via `CssSection::get_start_line`.

# Returns

the offset in bytes from the start of the line.
<!-- impl CssSection::fn ref -->
Increments the reference count on `self`.

# Returns

`self` itself.
<!-- impl CssSection::fn unref -->
Decrements the reference count on `self`, freeing the
structure if the reference count reaches 0.
<!-- enum CssSectionType -->
The different types of sections indicate parts of a CSS document as
parsed by GTK’s CSS parser. They are oriented towards the
[CSS Grammar](http://www.w3.org/TR/CSS21/grammar.html),
but may contain extensions.

More types might be added in the future as the parser incorporates
more features.
<!-- enum CssSectionType::variant Document -->
The section describes a complete document.
 This section time is the only one where `CssSection::get_parent`
 might return `None`.
<!-- enum CssSectionType::variant Import -->
The section defines an import rule.
<!-- enum CssSectionType::variant ColorDefinition -->
The section defines a color. This
 is a GTK extension to CSS.
<!-- enum CssSectionType::variant BindingSet -->
The section defines a binding set. This
 is a GTK extension to CSS.
<!-- enum CssSectionType::variant Ruleset -->
The section defines a CSS ruleset.
<!-- enum CssSectionType::variant Selector -->
The section defines a CSS selector.
<!-- enum CssSectionType::variant Declaration -->
The section defines the declaration of
 a CSS variable.
<!-- enum CssSectionType::variant Value -->
The section defines the value of a CSS declaration.
<!-- enum CssSectionType::variant Keyframes -->
The section defines keyframes. See [CSS
 Animations](http://dev.w3.org/csswg/css3-animations/`keyframes`) for details. Since 3.6
<!-- enum DeleteType -->
See also: `Entry::delete-from-cursor`.
<!-- enum DeleteType::variant Chars -->
Delete characters.
<!-- enum DeleteType::variant WordEnds -->
Delete only the portion of the word to the
 left/right of cursor if we’re in the middle of a word.
<!-- enum DeleteType::variant Words -->
Delete words.
<!-- enum DeleteType::variant DisplayLines -->
Delete display-lines. Display-lines
 refers to the visible lines, with respect to to the current line
 breaks. As opposed to paragraphs, which are defined by line
 breaks in the input.
<!-- enum DeleteType::variant DisplayLineEnds -->
Delete only the portion of the
 display-line to the left/right of cursor.
<!-- enum DeleteType::variant ParagraphEnds -->
Delete to the end of the
 paragraph. Like C-k in Emacs (or its reverse).
<!-- enum DeleteType::variant Paragraphs -->
Delete entire line. Like C-k in pico.
<!-- enum DeleteType::variant Whitespace -->
Delete only whitespace. Like M-\ in Emacs.
<!-- struct Dialog -->
Dialog boxes are a convenient way to prompt the user for a small amount
of input, e.g. to display a message, ask a question, or anything else
that does not require extensive effort on the user’s part.

GTK+ treats a dialog as a window split vertically. The top section is a
`VBox`, and is where widgets such as a `Label` or a `Entry` should
be packed. The bottom area is known as the
“action area”. This is generally used for
packing buttons into the dialog which may perform functions such as
cancel, ok, or apply.

`Dialog` boxes are created with a call to `Dialog::new` or
`Dialog::new_with_buttons`. `Dialog::new_with_buttons` is
recommended; it allows you to set the dialog title, some convenient
flags, and add simple buttons.

If “dialog” is a newly created dialog, the two primary areas of the
window can be accessed through `DialogExt::get_content_area` and
`DialogExt::get_action_area`, as can be seen from the example below.

A “modal” dialog (that is, one which freezes the rest of the application
from user input), can be created by calling `GtkWindowExt::set_modal` on the
dialog. Use the GTK_WINDOW() macro to cast the widget returned from
`Dialog::new` into a `Window`. When using `Dialog::new_with_buttons`
you can also pass the `DialogFlags::Modal` flag to make a dialog modal.

If you add buttons to `Dialog` using `Dialog::new_with_buttons`,
`DialogExt::add_button`, `DialogExt::add_buttons`, or
`DialogExt::add_action_widget`, clicking the button will emit a signal
called `Dialog::response` with a response ID that you specified. GTK+
will never assign a meaning to positive response IDs; these are entirely
user-defined. But for convenience, you can use the response IDs in the
`ResponseType` enumeration (these all have values less than zero). If
a dialog receives a delete event, the `Dialog::response` signal will
be emitted with a response ID of `ResponseType::DeleteEvent`.

If you want to block waiting for a dialog to return before returning
control flow to your code, you can call `DialogExt::run`. This function
enters a recursive main loop and waits for the user to respond to the
dialog, returning the response ID corresponding to the button the user
clicked.

For the simple dialog in the following example, in reality you’d probably
use `MessageDialog` to save yourself some effort. But you’d need to
create the dialog contents manually if you had more than a simple message
in the dialog.

An example for simple `Dialog` usage:

```C
// Function to open a dialog box with a message
void
quick_message (GtkWindow *parent, gchar *message)
{
 GtkWidget *dialog, *label, *content_area;
 GtkDialogFlags flags;

 // Create the widgets
 flags = GTK_DIALOG_DESTROY_WITH_PARENT;
 dialog = gtk_dialog_new_with_buttons ("Message",
                                       parent,
                                       flags,
                                       _("_OK"),
                                       GTK_RESPONSE_NONE,
                                       NULL);
 content_area = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
 label = gtk_label_new (message);

 // Ensure that the dialog box is destroyed when the user responds

 g_signal_connect_swapped (dialog,
                           "response",
                           G_CALLBACK (gtk_widget_destroy),
                           dialog);

 // Add the label, and show everything we’ve added

 gtk_container_add (GTK_CONTAINER (content_area), label);
 gtk_widget_show_all (dialog);
}
```

# `Dialog` as `Buildable`

The `Dialog` implementation of the `Buildable` interface exposes the
`vbox` and `action_area` as internal children with the names “vbox” and
“action_area”.

`Dialog` supports a custom `<action-widgets>` element, which can contain
multiple `<action-widget>` elements. The “response” attribute specifies a
numeric response, and the content of the element is the id of widget
(which should be a child of the dialogs `action_area`). To mark a response
as default, set the “default“ attribute of the `<action-widget>` element
to true.

`Dialog` supports adding action widgets by specifying “action“ as
the “type“ attribute of a `<child>` element. The widget will be added
either to the action area or the headerbar of the dialog, depending
on the “use-header-bar“ property. The response id has to be associated
with the action widget using the `<action-widgets>` element.

An example of a `Dialog` UI definition fragment:

```text
<object class="GtkDialog" id="dialog1">
  <child type="action">
    <object class="GtkButton" id="button_cancel"/>
  </child>
  <child type="action">
    <object class="GtkButton" id="button_ok">
      <property name="can-default">True</property>
    </object>
  </child>
  <action-widgets>
    <action-widget response="cancel">button_cancel</action-widget>
    <action-widget response="ok" default="true">button_ok</action-widget>
  </action-widgets>
</object>
```

# Implements

[`DialogExt`](trait.DialogExt.html), [`GtkWindowExt`](trait.GtkWindowExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait DialogExt -->
Trait containing all `Dialog` methods.

# Implementors

[`AboutDialog`](struct.AboutDialog.html), [`AppChooserDialog`](struct.AppChooserDialog.html), [`ColorChooserDialog`](struct.ColorChooserDialog.html), [`Dialog`](struct.Dialog.html), [`FileChooserDialog`](struct.FileChooserDialog.html), [`FontChooserDialog`](struct.FontChooserDialog.html), [`MessageDialog`](struct.MessageDialog.html), [`RecentChooserDialog`](struct.RecentChooserDialog.html)
<!-- impl Dialog::fn new -->
Creates a new dialog box.

Widgets should not be packed into this `Window`
directly, but into the `vbox` and `action_area`, as described above.

# Returns

the new dialog as a `Widget`
<!-- impl Dialog::fn new_with_buttons -->
Creates a new `Dialog` with title `title` (or `None` for the default
title; see `GtkWindowExt::set_title`) and transient parent `parent` (or
`None` for none; see `GtkWindowExt::set_transient_for`). The `flags`
argument can be used to make the dialog modal (`DialogFlags::Modal`)
and/or to have it destroyed along with its transient parent
(`DialogFlags::DestroyWithParent`). After `flags`, button
text/response ID pairs should be listed, with a `None` pointer ending
the list. Button text can be arbitrary text. A response ID can be
any positive number, or one of the values in the `ResponseType`
enumeration. If the user clicks one of these dialog buttons,
`Dialog` will emit the `Dialog::response` signal with the corresponding
response ID. If a `Dialog` receives the `Widget::delete-event` signal,
it will emit ::response with a response ID of `ResponseType::DeleteEvent`.
However, destroying a dialog does not emit the ::response signal;
so be careful relying on ::response when using the
`DialogFlags::DestroyWithParent` flag. Buttons are from left to right,
so the first button in the list will be the leftmost button in the dialog.

Here’s a simple example:

```C
 GtkWidget *dialog;
 GtkDialogFlags flags = GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT;
 dialog = gtk_dialog_new_with_buttons ("My dialog",
                                       main_app_window,
                                       flags,
                                       _("_OK"),
                                       GTK_RESPONSE_ACCEPT,
                                       _("_Cancel"),
                                       GTK_RESPONSE_REJECT,
                                       NULL);
```
## `title`
Title of the dialog, or `None`
## `parent`
Transient parent of the dialog, or `None`
## `flags`
from `DialogFlags`
## `first_button_text`
text to go in first button, or `None`

# Returns

a new `Dialog`
<!-- trait DialogExt::fn add_action_widget -->
Adds an activatable widget to the action area of a `Dialog`,
connecting a signal handler that will emit the `Dialog::response`
signal on the dialog when the widget is activated. The widget is
appended to the end of the dialog’s action area. If you want to add a
non-activatable widget, simply pack it into the `action_area` field
of the `Dialog` struct.
## `child`
an activatable widget
## `response_id`
response ID for `child`
<!-- trait DialogExt::fn add_button -->
Adds a button with the given text and sets things up so that
clicking the button will emit the `Dialog::response` signal with
the given `response_id`. The button is appended to the end of the
dialog’s action area. The button widget is returned, but usually
you don’t need it.
## `button_text`
text of button
## `response_id`
response ID for the button

# Returns

the `Button` widget that was added
<!-- trait DialogExt::fn add_buttons -->
Adds more buttons, same as calling `DialogExt::add_button`
repeatedly. The variable argument list should be `None`-terminated
as with `Dialog::new_with_buttons`. Each button must have both
text and response ID.
## `first_button_text`
button text
<!-- trait DialogExt::fn get_action_area -->
Returns the action area of `self`.

# Deprecated since 3.12

Direct access to the action area
 is discouraged; use `DialogExt::add_button`, etc.

# Returns

the action area
<!-- trait DialogExt::fn get_content_area -->
Returns the content area of `self`.

# Returns

the content area `Box`.
<!-- trait DialogExt::fn get_header_bar -->
Returns the header bar of `self`. Note that the
headerbar is only used by the dialog if the
`Dialog:use-header-bar` property is `true`.

Feature: `v3_12`


# Returns

the header bar
<!-- trait DialogExt::fn get_response_for_widget -->
Gets the response id of a widget in the action area
of a dialog.
## `widget`
a widget in the action area of `self`

# Returns

the response id of `widget`, or `ResponseType::None`
 if `widget` doesn’t have a response id set.
<!-- trait DialogExt::fn get_widget_for_response -->
Gets the widget button that uses the given response ID in the action area
of a dialog.
## `response_id`
the response ID used by the `self` widget

# Returns

the `widget` button that uses the given
 `response_id`, or `None`.
<!-- trait DialogExt::fn response -->
Emits the `Dialog::response` signal with the given response ID.
Used to indicate that the user has responded to the dialog in some way;
typically either you or `DialogExt::run` will be monitoring the
::response signal and take appropriate action.
## `response_id`
response ID
<!-- trait DialogExt::fn run -->
Blocks in a recursive main loop until the `self` either emits the
`Dialog::response` signal, or is destroyed. If the dialog is
destroyed during the call to `DialogExt::run`, `DialogExt::run` returns
`ResponseType::None`. Otherwise, it returns the response ID from the
::response signal emission.

Before entering the recursive main loop, `DialogExt::run` calls
`WidgetExt::show` on the dialog for you. Note that you still
need to show any children of the dialog yourself.

During `DialogExt::run`, the default behavior of `Widget::delete-event`
is disabled; if the dialog receives ::delete_event, it will not be
destroyed as windows usually are, and `DialogExt::run` will return
`ResponseType::DeleteEvent`. Also, during `DialogExt::run` the dialog
will be modal. You can force `DialogExt::run` to return at any time by
calling `DialogExt::response` to emit the ::response signal. Destroying
the dialog during `DialogExt::run` is a very bad idea, because your
post-run code won’t know whether the dialog was destroyed or not.

After `DialogExt::run` returns, you are responsible for hiding or
destroying the dialog if you wish to do so.

Typical usage of this function might be:

```C
  gint result = gtk_dialog_run (GTK_DIALOG (dialog));
  switch (result)
    {
      case GTK_RESPONSE_ACCEPT:
         do_application_specific_something ();
         break;
      default:
         do_nothing_since_dialog_was_cancelled ();
         break;
    }
  gtk_widget_destroy (dialog);
```

Note that even though the recursive main loop gives the effect of a
modal dialog (it prevents the user from interacting with other
windows in the same window group while the dialog is run), callbacks
such as timeouts, IO channel watches, DND drops, etc, will
be triggered during a `DialogExt::run` call.

# Returns

response ID
<!-- trait DialogExt::fn set_alternative_button_order -->
Sets an alternative button order. If the
`Settings:gtk-alternative-button-order` setting is set to `true`,
the dialog buttons are reordered according to the order of the
response ids passed to this function.

By default, GTK+ dialogs use the button order advocated by the
[GNOME Human Interface Guidelines](http://library.gnome.org/devel/hig-book/stable/)
with the affirmative button at the far
right, and the cancel button left of it. But the builtin GTK+ dialogs
and ``GtkMessageDialogs`` do provide an alternative button order,
which is more suitable on some platforms, e.g. Windows.

Use this function after adding all the buttons to your dialog, as the
following example shows:


```C
cancel_button = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                       _("_Cancel"),
                                       GTK_RESPONSE_CANCEL);

ok_button = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                   _("_OK"),
                                   GTK_RESPONSE_OK);

gtk_widget_grab_default (ok_button);

help_button = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                     _("_Help"),
                                     GTK_RESPONSE_HELP);

gtk_dialog_set_alternative_button_order (GTK_DIALOG (dialog),
                                         GTK_RESPONSE_OK,
                                         GTK_RESPONSE_CANCEL,
                                         GTK_RESPONSE_HELP,
                                         -1);
```

# Deprecated since 3.10

Deprecated
## `first_response_id`
a response id used by one `self`’s buttons
<!-- trait DialogExt::fn set_alternative_button_order_from_array -->
Sets an alternative button order. If the
`Settings:gtk-alternative-button-order` setting is set to `true`,
the dialog buttons are reordered according to the order of the
response ids in `new_order`.

See `DialogExt::set_alternative_button_order` for more information.

This function is for use by language bindings.

# Deprecated since 3.10

Deprecated
## `n_params`
the number of response ids in `new_order`
## `new_order`
an array of response ids of
 `self`’s buttons
<!-- trait DialogExt::fn set_default_response -->
Sets the last widget in the dialog’s action area with the given `response_id`
as the default widget for the dialog. Pressing “Enter” normally activates
the default widget.
## `response_id`
a response ID
<!-- trait DialogExt::fn set_response_sensitive -->
Calls `gtk_widget_set_sensitive (widget, @setting)`
for each widget in the dialog’s action area with the given `response_id`.
A convenient way to sensitize/desensitize dialog buttons.
## `response_id`
a response ID
## `setting`
`true` for sensitive
<!-- trait DialogExt::fn connect_close -->
The ::close signal is a
[keybinding signal][`BindingSignal`]
which gets emitted when the user uses a keybinding to close
the dialog.

The default binding for this signal is the Escape key.
<!-- trait DialogExt::fn connect_response -->
Emitted when an action widget is clicked, the dialog receives a
delete event, or the application programmer calls `DialogExt::response`.
On a delete event, the response ID is `ResponseType::DeleteEvent`.
Otherwise, it depends on which action widget was clicked.
## `response_id`
the response ID
<!-- trait DialogExt::fn get_property_use-header-bar -->
`true` if the dialog uses a `HeaderBar` for action buttons
instead of the action-area.

For technical reasons, this property is declared as an integer
property, but you should only set it to `true` or `false`.

Feature: `v3_12`

<!-- trait DialogExt::fn set_property_use-header-bar -->
`true` if the dialog uses a `HeaderBar` for action buttons
instead of the action-area.

For technical reasons, this property is declared as an integer
property, but you should only set it to `true` or `false`.

Feature: `v3_12`

<!-- enum DirectionType -->
Focus movement types.
<!-- enum DirectionType::variant TabForward -->
Move forward.
<!-- enum DirectionType::variant TabBackward -->
Move backward.
<!-- enum DirectionType::variant Up -->
Move up.
<!-- enum DirectionType::variant Down -->
Move down.
<!-- enum DirectionType::variant Left -->
Move left.
<!-- enum DirectionType::variant Right -->
Move right.
<!-- enum DragResult -->
Gives an indication why a drag operation failed.
The value can by obtained by connecting to the
`Widget::drag-failed` signal.
<!-- enum DragResult::variant Success -->
The drag operation was successful.
<!-- enum DragResult::variant NoTarget -->
No suitable drag target.
<!-- enum DragResult::variant UserCancelled -->
The user cancelled the drag operation.
<!-- enum DragResult::variant TimeoutExpired -->
The drag operation timed out.
<!-- enum DragResult::variant GrabBroken -->
The pointer or keyboard grab used
 for the drag operation was broken.
<!-- enum DragResult::variant Error -->
The drag operation failed due to some
 unspecified error.
<!-- struct DrawingArea -->
The `DrawingArea` widget is used for creating custom user interface
elements. It’s essentially a blank widget; you can draw on it. After
creating a drawing area, the application may want to connect to:

- Mouse and button press signals to respond to input from
 the user. (Use `WidgetExt::add_events` to enable events
 you wish to receive.)

- The `Widget::realize` signal to take any necessary actions
 when the widget is instantiated on a particular display.
 (Create GDK resources in response to this signal.)

- The `Widget::size-allocate` signal to take any necessary
 actions when the widget changes size.

- The `Widget::draw` signal to handle redrawing the
 contents of the widget.

The following code portion demonstrates using a drawing
area to display a circle in the normal widget foreground
color.

Note that GDK automatically clears the exposed area before sending
the expose event, and that drawing is implicitly clipped to the exposed
area. If you want to have a theme-provided background, you need
to call `gtk_render_background` in your ::draw method.

## Simple `DrawingArea` usage


```C
gboolean
draw_callback (GtkWidget *widget, cairo_t *cr, gpointer data)
{
  guint width, height;
  GdkRGBA color;
  GtkStyleContext *context;

  context = gtk_widget_get_style_context (widget);

  width = gtk_widget_get_allocated_width (widget);
  height = gtk_widget_get_allocated_height (widget);

  gtk_render_background (context, cr, 0, 0, width, height);

  cairo_arc (cr,
             width / 2.0, height / 2.0,
             MIN (width, height) / 2.0,
             0, 2 * G_PI);

  gtk_style_context_get_color (context,
                               gtk_style_context_get_state (context),
                               &color);
  gdk_cairo_set_source_rgba (cr, &color);

  cairo_fill (cr);

 return FALSE;
}
[...]
  GtkWidget *drawing_area = gtk_drawing_area_new ();
  gtk_widget_set_size_request (drawing_area, 100, 100);
  g_signal_connect (G_OBJECT (drawing_area), "draw",
                    G_CALLBACK (draw_callback), NULL);
```

Draw signals are normally delivered when a drawing area first comes
onscreen, or when it’s covered by another window and then uncovered.
You can also force an expose event by adding to the “damage region”
of the drawing area’s window; `WidgetExt::queue_draw_area` and
`gdk::WindowExt::invalidate_rect` are equally good ways to do this.
You’ll then get a draw signal for the invalid region.

The available routines for drawing are documented on the
[GDK Drawing Primitives][gdk3-Cairo-Interaction] page
and the cairo documentation.

To receive mouse events on a drawing area, you will need to enable
them with `WidgetExt::add_events`. To receive keyboard events, you
will need to set the “can-focus” property on the drawing area, and you
should probably draw some user-visible indication that the drawing
area is focused. Use `WidgetExt::has_focus` in your expose event
handler to decide whether to draw the focus indicator. See
`gtk_render_focus` for one way to draw focus.

# Implements

[`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- impl DrawingArea::fn new -->
Creates a new drawing area.

# Returns

a new `DrawingArea`
<!-- struct Editable -->
The `Editable` interface is an interface which should be implemented by
text editing widgets, such as `Entry` and `SpinButton`. It contains functions
for generically manipulating an editable widget, a large number of action
signals used for key bindings, and several signals that an application can
connect to to modify the behavior of a widget.

As an example of the latter usage, by connecting
the following handler to `Editable::insert-text`, an application
can convert all entry into a widget into uppercase.

## Forcing entry to uppercase.


```C
#include <ctype.h>;

void
insert_text_handler (GtkEditable *editable,
                     const gchar *text,
                     gint         length,
                     gint        *position,
                     gpointer     data)
{
  gchar *result = g_utf8_strup (text, length);

  g_signal_handlers_block_by_func (editable,
                               (gpointer) insert_text_handler, data);
  gtk_editable_insert_text (editable, result, length, position);
  g_signal_handlers_unblock_by_func (editable,
                                     (gpointer) insert_text_handler, data);

  g_signal_stop_emission_by_name (editable, "insert_text");

  g_free (result);
}
```

# Implements

[`EditableExt`](trait.EditableExt.html)
<!-- trait EditableExt -->
Trait containing all `Editable` methods.

# Implementors

[`Editable`](struct.Editable.html), [`Entry`](struct.Entry.html), [`SearchEntry`](struct.SearchEntry.html), [`SpinButton`](struct.SpinButton.html)
<!-- trait EditableExt::fn copy_clipboard -->
Copies the contents of the currently selected content in the editable and
puts it on the clipboard.
<!-- trait EditableExt::fn cut_clipboard -->
Removes the contents of the currently selected content in the editable and
puts it on the clipboard.
<!-- trait EditableExt::fn delete_selection -->
Deletes the currently selected text of the editable.
This call doesn’t do anything if there is no selected text.
<!-- trait EditableExt::fn delete_text -->
Deletes a sequence of characters. The characters that are deleted are
those characters at positions from `start_pos` up to, but not including
`end_pos`. If `end_pos` is negative, then the characters deleted
are those from `start_pos` to the end of the text.

Note that the positions are specified in characters, not bytes.
## `start_pos`
start position
## `end_pos`
end position
<!-- trait EditableExt::fn get_chars -->
Retrieves a sequence of characters. The characters that are retrieved
are those characters at positions from `start_pos` up to, but not
including `end_pos`. If `end_pos` is negative, then the characters
retrieved are those characters from `start_pos` to the end of the text.

Note that positions are specified in characters, not bytes.
## `start_pos`
start of text
## `end_pos`
end of text

# Returns

a pointer to the contents of the widget as a
 string. This string is allocated by the `Editable`
 implementation and should be freed by the caller.
<!-- trait EditableExt::fn get_editable -->
Retrieves whether `self` is editable. See
`Editable::set_editable`.

# Returns

`true` if `self` is editable.
<!-- trait EditableExt::fn get_position -->
Retrieves the current position of the cursor relative to the start
of the content of the editable.

Note that this position is in characters, not in bytes.

# Returns

the cursor position
<!-- trait EditableExt::fn get_selection_bounds -->
Retrieves the selection bound of the editable. start_pos will be filled
with the start of the selection and `end_pos` with end. If no text was
selected both will be identical and `false` will be returned.

Note that positions are specified in characters, not bytes.
## `start_pos`
location to store the starting position, or `None`
## `end_pos`
location to store the end position, or `None`

# Returns

`true` if an area is selected, `false` otherwise
<!-- trait EditableExt::fn insert_text -->
Inserts `new_text_length` bytes of `new_text` into the contents of the
widget, at position `position`.

Note that the position is in characters, not in bytes.
The function updates `position` to point after the newly inserted text.
## `new_text`
the text to append
## `new_text_length`
the length of the text in bytes, or -1
## `position`
location of the position text will be inserted at
<!-- trait EditableExt::fn paste_clipboard -->
Pastes the content of the clipboard to the current position of the
cursor in the editable.
<!-- trait EditableExt::fn select_region -->
Selects a region of text. The characters that are selected are
those characters at positions from `start_pos` up to, but not
including `end_pos`. If `end_pos` is negative, then the
characters selected are those characters from `start_pos` to
the end of the text.

Note that positions are specified in characters, not bytes.
## `start_pos`
start of region
## `end_pos`
end of region
<!-- trait EditableExt::fn set_editable -->
Determines if the user can edit the text in the editable
widget or not.
## `is_editable`
`true` if the user is allowed to edit the text
 in the widget
<!-- trait EditableExt::fn set_position -->
Sets the cursor position in the editable to the given value.

The cursor is displayed before the character with the given (base 0)
index in the contents of the editable. The value must be less than or
equal to the number of characters in the editable. A value of -1
indicates that the position should be set after the last character
of the editable. Note that `position` is in characters, not in bytes.
## `position`
the position of the cursor
<!-- trait EditableExt::fn connect_changed -->
The ::changed signal is emitted at the end of a single
user-visible operation on the contents of the `Editable`.

E.g., a paste operation that replaces the contents of the
selection will cause only one signal emission (even though it
is implemented by first deleting the selection, then inserting
the new content, and may cause multiple ::notify::text signals
to be emitted).
<!-- trait EditableExt::fn connect_delete_text -->
This signal is emitted when text is deleted from
the widget by the user. The default handler for
this signal will normally be responsible for deleting
the text, so by connecting to this signal and then
stopping the signal with `g_signal_stop_emission`, it
is possible to modify the range of deleted text, or
prevent it from being deleted entirely. The `start_pos`
and `end_pos` parameters are interpreted as for
`Editable::delete_text`.
## `start_pos`
the starting position
## `end_pos`
the end position
<!-- trait EditableExt::fn connect_insert_text -->
This signal is emitted when text is inserted into
the widget by the user. The default handler for
this signal will normally be responsible for inserting
the text, so by connecting to this signal and then
stopping the signal with `g_signal_stop_emission`, it
is possible to modify the inserted text, or prevent
it from being inserted entirely.
## `new_text`
the new text to insert
## `new_text_length`
the length of the new text, in bytes,
 or -1 if new_text is nul-terminated
## `position`
the position, in characters,
 at which to insert the new text. this is an in-out
 parameter. After the signal emission is finished, it
 should point after the newly inserted text.
<!-- struct Entry -->
The `Entry` widget is a single line text entry
widget. A fairly large set of key bindings are supported
by default. If the entered text is longer than the allocation
of the widget, the widget will scroll so that the cursor
position is visible.

When using an entry for passwords and other sensitive information,
it can be put into “password mode” using `EntryExt::set_visibility`.
In this mode, entered text is displayed using a “invisible” character.
By default, GTK+ picks the best invisible character that is available
in the current font, but it can be changed with
`EntryExt::set_invisible_char`. Since 2.16, GTK+ displays a warning
when Caps Lock or input methods might interfere with entering text in
a password entry. The warning can be turned off with the
`Entry:caps-lock-warning` property.

Since 2.16, `Entry` has the ability to display progress or activity
information behind the text. To make an entry display such information,
use `EntryExt::set_progress_fraction` or `EntryExt::set_progress_pulse_step`.

Additionally, `Entry` can show icons at either side of the entry. These
icons can be activatable by clicking, can be set up as drag source and
can have tooltips. To add an icon, use `EntryExt::set_icon_from_gicon` or
one of the various other functions that set an icon from a stock id, an
icon name or a pixbuf. To trigger an action when the user clicks an icon,
connect to the `Entry::icon-press` signal. To allow DND operations
from an icon, use `EntryExt::set_icon_drag_source`. To set a tooltip on
an icon, use `EntryExt::set_icon_tooltip_text` or the corresponding function
for markup.

Note that functionality or information that is only available by clicking
on an icon in an entry may not be accessible at all to users which are not
able to use a mouse or other pointing device. It is therefore recommended
that any such functionality should also be available by other means, e.g.
via the context menu of the entry.

# CSS nodes


```plain
entry
├── image.left
├── image.right
├── undershoot.left
├── undershoot.right
├── [selection]
├── [progress[.pulse]]
╰── [window.popup]
```

`Entry` has a main node with the name entry. Depending on the properties
of the entry, the style classes .read-only and .flat may appear. The style
classes .warning and .error may also be used with entries.

When the entry shows icons, it adds subnodes with the name image and the
style class .left or .right, depending on where the icon appears.

When the entry has a selection, it adds a subnode with the name selection.

When the entry shows progress, it adds a subnode with the name progress.
The node has the style class .pulse when the shown progress is pulsing.

The CSS node for a context menu is added as a subnode below entry as well.

The undershoot nodes are used to draw the underflow indication when content
is scrolled out of view. These nodes get the .left and .right style classes
added depending on where the indication is drawn.

When touch is used and touch selection handles are shown, they are using
CSS nodes with name cursor-handle. They get the .top or .bottom style class
depending on where they are shown in relation to the selection. If there is
just a single handle for the text cursor, it gets the style class
.insertion-cursor.

# Implements

[`EntryExt`](trait.EntryExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`CellEditableExt`](trait.CellEditableExt.html), [`EditableExt`](trait.EditableExt.html)
<!-- trait EntryExt -->
Trait containing all `Entry` methods.

# Implementors

[`Entry`](struct.Entry.html), [`SearchEntry`](struct.SearchEntry.html), [`SpinButton`](struct.SpinButton.html)
<!-- impl Entry::fn new -->
Creates a new entry.

# Returns

a new `Entry`.
<!-- impl Entry::fn new_with_buffer -->
Creates a new entry with the specified text buffer.
## `buffer`
The buffer to use for the new `Entry`.

# Returns

a new `Entry`
<!-- trait EntryExt::fn get_activates_default -->
Retrieves the value set by `EntryExt::set_activates_default`.

# Returns

`true` if the entry will activate the default widget
<!-- trait EntryExt::fn get_alignment -->
Gets the value set by `EntryExt::set_alignment`.

# Returns

the alignment
<!-- trait EntryExt::fn get_attributes -->
Gets the attribute list that was set on the entry using
`EntryExt::set_attributes`, if any.

Feature: `v3_6`


# Returns

the attribute list, or `None`
 if none was set.
<!-- trait EntryExt::fn get_buffer -->
Get the `EntryBuffer` object which holds the text for
this widget.

# Returns

A `EntryBuffer` object.
<!-- trait EntryExt::fn get_completion -->
Returns the auxiliary completion object currently in use by `self`.

# Returns

The auxiliary completion object currently
 in use by `self`.
<!-- trait EntryExt::fn get_current_icon_drag_source -->
Returns the index of the icon which is the source of the current
DND operation, or -1.

This function is meant to be used in a `Widget::drag-data-get`
callback.

# Returns

index of the icon which is the source of the current
 DND operation, or -1.
<!-- trait EntryExt::fn get_cursor_hadjustment -->
Retrieves the horizontal cursor adjustment for the entry.
See `EntryExt::set_cursor_hadjustment`.

# Returns

the horizontal cursor adjustment, or `None`
 if none has been set.
<!-- trait EntryExt::fn get_has_frame -->
Gets the value set by `EntryExt::set_has_frame`.

# Returns

whether the entry has a beveled frame
<!-- trait EntryExt::fn get_icon_activatable -->
Returns whether the icon is activatable.
## `icon_pos`
Icon position

# Returns

`true` if the icon is activatable.
<!-- trait EntryExt::fn get_icon_area -->
Gets the area where entry’s icon at `icon_pos` is drawn.
This function is useful when drawing something to the
entry in a draw callback.

If the entry is not realized or has no icon at the given position,
`icon_area` is filled with zeros. Otherwise, `icon_area` will be filled
with the icon’s allocation, relative to `self`’s allocation.

See also `EntryExt::get_text_area`
## `icon_pos`
Icon position
## `icon_area`
Return location for the icon’s area
<!-- trait EntryExt::fn get_icon_at_pos -->
Finds the icon at the given position and return its index. The
position’s coordinates are relative to the `self`’s top left corner.
If `x`, `y` doesn’t lie inside an icon, -1 is returned.
This function is intended for use in a `Widget::query-tooltip`
signal handler.
## `x`
the x coordinate of the position to find
## `y`
the y coordinate of the position to find

# Returns

the index of the icon at the given position, or -1
<!-- trait EntryExt::fn get_icon_gicon -->
Retrieves the `gio::Icon` used for the icon, or `None` if there is
no icon or if the icon was set by some other method (e.g., by
stock, pixbuf, or icon name).
## `icon_pos`
Icon position

# Returns

A `gio::Icon`, or `None` if no icon is set
 or if the icon is not a `gio::Icon`
<!-- trait EntryExt::fn get_icon_name -->
Retrieves the icon name used for the icon, or `None` if there is
no icon or if the icon was set by some other method (e.g., by
pixbuf, stock or gicon).
## `icon_pos`
Icon position

# Returns

An icon name, or `None` if no icon is set or if the icon
 wasn’t set from an icon name
<!-- trait EntryExt::fn get_icon_pixbuf -->
Retrieves the image used for the icon.

Unlike the other methods of setting and getting icon data, this
method will work regardless of whether the icon was set using a
`gdk_pixbuf::Pixbuf`, a `gio::Icon`, a stock item, or an icon name.
## `icon_pos`
Icon position

# Returns

A `gdk_pixbuf::Pixbuf`, or `None` if no icon is
 set for this position.
<!-- trait EntryExt::fn get_icon_sensitive -->
Returns whether the icon appears sensitive or insensitive.
## `icon_pos`
Icon position

# Returns

`true` if the icon is sensitive.
<!-- trait EntryExt::fn get_icon_stock -->
Retrieves the stock id used for the icon, or `None` if there is
no icon or if the icon was set by some other method (e.g., by
pixbuf, icon name or gicon).

# Deprecated since 3.10

Use `EntryExt::get_icon_name` instead.
## `icon_pos`
Icon position

# Returns

A stock id, or `None` if no icon is set or if the icon
 wasn’t set from a stock id
<!-- trait EntryExt::fn get_icon_storage_type -->
Gets the type of representation being used by the icon
to store image data. If the icon has no image data,
the return value will be `ImageType::Empty`.
## `icon_pos`
Icon position

# Returns

image representation being used
<!-- trait EntryExt::fn get_icon_tooltip_markup -->
Gets the contents of the tooltip on the icon at the specified
position in `self`.
## `icon_pos`
the icon position

# Returns

the tooltip text, or `None`. Free the returned
 string with `g_free` when done.
<!-- trait EntryExt::fn get_icon_tooltip_text -->
Gets the contents of the tooltip on the icon at the specified
position in `self`.
## `icon_pos`
the icon position

# Returns

the tooltip text, or `None`. Free the returned
 string with `g_free` when done.
<!-- trait EntryExt::fn get_inner_border -->
This function returns the entry’s `Entry:inner-border` property. See
`Entry::set_inner_border` for more information.

# Deprecated since 3.4

Use the standard border and padding CSS properties (through
 objects like `StyleContext` and `CssProvider`); the value returned by
 this function is ignored by `Entry`.

# Returns

the entry’s `Border`, or
 `None` if none was set.
<!-- trait EntryExt::fn get_input_hints -->
Gets the value of the `Entry:input-hints` property.

Feature: `v3_6`

<!-- trait EntryExt::fn get_input_purpose -->
Gets the value of the `Entry:input-purpose` property.

Feature: `v3_6`

<!-- trait EntryExt::fn get_invisible_char -->
Retrieves the character displayed in place of the real characters
for entries with visibility set to false. See `EntryExt::set_invisible_char`.

# Returns

the current invisible char, or 0, if the entry does not
 show invisible text at all.
<!-- trait EntryExt::fn get_layout -->
Gets the `pango::Layout` used to display the entry.
The layout is useful to e.g. convert text positions to
pixel positions, in combination with `EntryExt::get_layout_offsets`.
The returned layout is owned by the entry and must not be
modified or freed by the caller.

Keep in mind that the layout text may contain a preedit string, so
`EntryExt::layout_index_to_text_index` and
`EntryExt::text_index_to_layout_index` are needed to convert byte
indices in the layout to byte indices in the entry contents.

# Returns

the `pango::Layout` for this entry
<!-- trait EntryExt::fn get_layout_offsets -->
Obtains the position of the `pango::Layout` used to render text
in the entry, in widget coordinates. Useful if you want to line
up the text in an entry with some other text, e.g. when using the
entry to implement editable cells in a sheet widget.

Also useful to convert mouse events into coordinates inside the
`pango::Layout`, e.g. to take some action if some part of the entry text
is clicked.

Note that as the user scrolls around in the entry the offsets will
change; you’ll need to connect to the “notify::scroll-offset”
signal to track this. Remember when using the `pango::Layout`
functions you need to convert to and from pixels using
PANGO_PIXELS() or `PANGO_SCALE`.

Keep in mind that the layout text may contain a preedit string, so
`EntryExt::layout_index_to_text_index` and
`EntryExt::text_index_to_layout_index` are needed to convert byte
indices in the layout to byte indices in the entry contents.
## `x`
location to store X offset of layout, or `None`
## `y`
location to store Y offset of layout, or `None`
<!-- trait EntryExt::fn get_max_length -->
Retrieves the maximum allowed length of the text in
`self`. See `EntryExt::set_max_length`.

This is equivalent to:


```C
GtkEntryBuffer *buffer;
buffer = gtk_entry_get_buffer (entry);
gtk_entry_buffer_get_max_length (buffer);
```

# Returns

the maximum allowed number of characters
 in `Entry`, or 0 if there is no maximum.
<!-- trait EntryExt::fn get_max_width_chars -->
Retrieves the desired maximum width of `self`, in characters.
See `EntryExt::set_max_width_chars`.

Feature: `v3_12`


# Returns

the maximum width of the entry, in characters
<!-- trait EntryExt::fn get_overwrite_mode -->
Gets the value set by `EntryExt::set_overwrite_mode`.

# Returns

whether the text is overwritten when typing.
<!-- trait EntryExt::fn get_placeholder_text -->
Retrieves the text that will be displayed when `self` is empty and unfocused

# Returns

a pointer to the placeholder text as a string. This string points to internally allocated
storage in the widget and must not be freed, modified or stored.
<!-- trait EntryExt::fn get_progress_fraction -->
Returns the current fraction of the task that’s been completed.
See `EntryExt::set_progress_fraction`.

# Returns

a fraction from 0.0 to 1.0
<!-- trait EntryExt::fn get_progress_pulse_step -->
Retrieves the pulse step set with `EntryExt::set_progress_pulse_step`.

# Returns

a fraction from 0.0 to 1.0
<!-- trait EntryExt::fn get_tabs -->
Gets the tabstops that were set on the entry using `EntryExt::set_tabs`, if
any.

Feature: `v3_10`


# Returns

the tabstops, or `None` if none was set.
<!-- trait EntryExt::fn get_text -->
Retrieves the contents of the entry widget.
See also `Editable::get_chars`.

This is equivalent to:


```C
GtkEntryBuffer *buffer;
buffer = gtk_entry_get_buffer (entry);
gtk_entry_buffer_get_text (buffer);
```

# Returns

a pointer to the contents of the widget as a
 string. This string points to internally allocated
 storage in the widget and must not be freed, modified or
 stored.
<!-- trait EntryExt::fn get_text_area -->
Gets the area where the entry’s text is drawn. This function is
useful when drawing something to the entry in a draw callback.

If the entry is not realized, `text_area` is filled with zeros.

See also `EntryExt::get_icon_area`.
## `text_area`
Return location for the text area.
<!-- trait EntryExt::fn get_text_length -->
Retrieves the current length of the text in
`self`.

This is equivalent to:


```C
GtkEntryBuffer *buffer;
buffer = gtk_entry_get_buffer (entry);
gtk_entry_buffer_get_length (buffer);
```

# Returns

the current number of characters
 in `Entry`, or 0 if there are none.
<!-- trait EntryExt::fn get_visibility -->
Retrieves whether the text in `self` is visible. See
`EntryExt::set_visibility`.

# Returns

`true` if the text is currently visible
<!-- trait EntryExt::fn get_width_chars -->
Gets the value set by `EntryExt::set_width_chars`.

# Returns

number of chars to request space for, or negative if unset
<!-- trait EntryExt::fn grab_focus_without_selecting -->
Causes `self` to have keyboard focus.

It behaves like `WidgetExt::grab_focus`,
except that it doesn't select the contents of the entry.
You only want to call this on some special entries
which the user usually doesn't want to replace all text in,
such as search-as-you-type entries.

Feature: `v3_16`

<!-- trait EntryExt::fn im_context_filter_keypress -->
Allow the `Entry` input method to internally handle key press
and release events. If this function returns `true`, then no further
processing should be done for this key event. See
`IMContextExt::filter_keypress`.

Note that you are expected to call this function from your handler
when overriding key event handling. This is needed in the case when
you need to insert your own key handling between the input method
and the default key event handling of the `Entry`.
See `TextViewExt::reset_im_context` for an example of use.
## `event`
the key event

# Returns

`true` if the input method handled the key event.
<!-- trait EntryExt::fn layout_index_to_text_index -->
Converts from a position in the entry’s `pango::Layout` (returned by
`EntryExt::get_layout`) to a position in the entry contents
(returned by `EntryExt::get_text`).
## `layout_index`
byte index into the entry layout text

# Returns

byte index into the entry contents
<!-- trait EntryExt::fn progress_pulse -->
Indicates that some progress is made, but you don’t know how much.
Causes the entry’s progress indicator to enter “activity mode,”
where a block bounces back and forth. Each call to
`EntryExt::progress_pulse` causes the block to move by a little bit
(the amount of movement per pulse is determined by
`EntryExt::set_progress_pulse_step`).
<!-- trait EntryExt::fn reset_im_context -->
Reset the input method context of the entry if needed.

This can be necessary in the case where modifying the buffer
would confuse on-going input method behavior.
<!-- trait EntryExt::fn set_activates_default -->
If `setting` is `true`, pressing Enter in the `self` will activate the default
widget for the window containing the entry. This usually means that
the dialog box containing the entry will be closed, since the default
widget is usually one of the dialog buttons.

(For experts: if `setting` is `true`, the entry calls
`GtkWindowExt::activate_default` on the window containing the entry, in
the default handler for the `Entry::activate` signal.)
## `setting`
`true` to activate window’s default widget on Enter keypress
<!-- trait EntryExt::fn set_alignment -->
Sets the alignment for the contents of the entry. This controls
the horizontal positioning of the contents when the displayed
text is shorter than the width of the entry.
## `xalign`
The horizontal alignment, from 0 (left) to 1 (right).
 Reversed for RTL layouts
<!-- trait EntryExt::fn set_attributes -->
Sets a `pango::AttrList`; the attributes in the list are applied to the
entry text.

Feature: `v3_6`

## `attrs`
a `pango::AttrList`
<!-- trait EntryExt::fn set_buffer -->
Set the `EntryBuffer` object which holds the text for
this widget.
## `buffer`
a `EntryBuffer`
<!-- trait EntryExt::fn set_completion -->
Sets `completion` to be the auxiliary completion object to use with `self`.
All further configuration of the completion mechanism is done on
`completion` using the `EntryCompletion` API. Completion is disabled if
`completion` is set to `None`.
## `completion`
The `EntryCompletion` or `None`
<!-- trait EntryExt::fn set_cursor_hadjustment -->
Hooks up an adjustment to the cursor position in an entry, so that when
the cursor is moved, the adjustment is scrolled to show that position.
See `ScrolledWindowExt::get_hadjustment` for a typical way of obtaining
the adjustment.

The adjustment has to be in pixel units and in the same coordinate system
as the entry.
## `adjustment`
an adjustment which should be adjusted when the cursor
 is moved, or `None`
<!-- trait EntryExt::fn set_has_frame -->
Sets whether the entry has a beveled frame around it.
## `setting`
new value
<!-- trait EntryExt::fn set_icon_activatable -->
Sets whether the icon is activatable.
## `icon_pos`
Icon position
## `activatable`
`true` if the icon should be activatable
<!-- trait EntryExt::fn set_icon_drag_source -->
Sets up the icon at the given position so that GTK+ will start a drag
operation when the user clicks and drags the icon.

To handle the drag operation, you need to connect to the usual
`Widget::drag-data-get` (or possibly `Widget::drag-data-delete`)
signal, and use `EntryExt::get_current_icon_drag_source` in
your signal handler to find out if the drag was started from
an icon.

By default, GTK+ uses the icon as the drag icon. You can use the
`Widget::drag-begin` signal to set a different icon. Note that you
have to use `g_signal_connect_after` to ensure that your signal handler
gets executed after the default handler.
## `icon_pos`
icon position
## `target_list`
the targets (data formats) in which the data can be provided
## `actions`
a bitmask of the allowed drag actions
<!-- trait EntryExt::fn set_icon_from_gicon -->
Sets the icon shown in the entry at the specified position
from the current icon theme.
If the icon isn’t known, a “broken image” icon will be displayed
instead.

If `icon` is `None`, no icon will be shown in the specified position.
## `icon_pos`
The position at which to set the icon
## `icon`
The icon to set, or `None`
<!-- trait EntryExt::fn set_icon_from_icon_name -->
Sets the icon shown in the entry at the specified position
from the current icon theme.

If the icon name isn’t known, a “broken image” icon will be displayed
instead.

If `icon_name` is `None`, no icon will be shown in the specified position.
## `icon_pos`
The position at which to set the icon
## `icon_name`
An icon name, or `None`
<!-- trait EntryExt::fn set_icon_from_pixbuf -->
Sets the icon shown in the specified position using a pixbuf.

If `pixbuf` is `None`, no icon will be shown in the specified position.
## `icon_pos`
Icon position
## `pixbuf`
A `gdk_pixbuf::Pixbuf`, or `None`
<!-- trait EntryExt::fn set_icon_from_stock -->
Sets the icon shown in the entry at the specified position from
a stock image.

If `stock_id` is `None`, no icon will be shown in the specified position.

# Deprecated since 3.10

Use `EntryExt::set_icon_from_icon_name` instead.
## `icon_pos`
Icon position
## `stock_id`
The name of the stock item, or `None`
<!-- trait EntryExt::fn set_icon_sensitive -->
Sets the sensitivity for the specified icon.
## `icon_pos`
Icon position
## `sensitive`
Specifies whether the icon should appear
 sensitive or insensitive
<!-- trait EntryExt::fn set_icon_tooltip_markup -->
Sets `tooltip` as the contents of the tooltip for the icon at
the specified position. `tooltip` is assumed to be marked up with
the [Pango text markup language][PangoMarkupFormat].

Use `None` for `tooltip` to remove an existing tooltip.

See also `WidgetExt::set_tooltip_markup` and
`EntryExt::set_icon_tooltip_text`.
## `icon_pos`
the icon position
## `tooltip`
the contents of the tooltip for the icon, or `None`
<!-- trait EntryExt::fn set_icon_tooltip_text -->
Sets `tooltip` as the contents of the tooltip for the icon
at the specified position.

Use `None` for `tooltip` to remove an existing tooltip.

See also `WidgetExt::set_tooltip_text` and
`EntryExt::set_icon_tooltip_markup`.

If you unset the widget tooltip via `WidgetExt::set_tooltip_text` or
`WidgetExt::set_tooltip_markup`, this sets `Widget`:has-tooltip to `false`,
which suppresses icon tooltips too. You can resolve this by then calling
`WidgetExt::set_has_tooltip` to set `Widget`:has-tooltip back to `true`, or
setting at least one non-empty tooltip on any icon achieves the same result.
## `icon_pos`
the icon position
## `tooltip`
the contents of the tooltip for the icon, or `None`
<!-- trait EntryExt::fn set_inner_border -->
Sets `entry`’s inner-border property to `border`, or clears it if `None`
is passed. The inner-border is the area around the entry’s text, but
inside its frame.

If set, this property overrides the inner-border style property.
Overriding the style-provided border is useful when you want to do
in-place editing of some text in a canvas or list widget, where
pixel-exact positioning of the entry is important.

# Deprecated since 3.4

Use the standard border and padding CSS properties (through
 objects like `StyleContext` and `CssProvider`); the value set with
 this function is ignored by `Entry`.
## `border`
a `Border`, or `None`
<!-- trait EntryExt::fn set_input_hints -->
Sets the `Entry:input-hints` property, which
allows input methods to fine-tune their behaviour.

Feature: `v3_6`

## `hints`
the hints
<!-- trait EntryExt::fn set_input_purpose -->
Sets the `Entry:input-purpose` property which
can be used by on-screen keyboards and other input
methods to adjust their behaviour.

Feature: `v3_6`

## `purpose`
the purpose
<!-- trait EntryExt::fn set_invisible_char -->
Sets the character to use in place of the actual text when
`EntryExt::set_visibility` has been called to set text visibility
to `false`. i.e. this is the character used in “password mode” to
show the user how many characters have been typed. By default, GTK+
picks the best invisible char available in the current font. If you
set the invisible char to 0, then the user will get no feedback
at all; there will be no text on the screen as they type.
## `ch`
a Unicode character
<!-- trait EntryExt::fn set_max_length -->
Sets the maximum allowed length of the contents of the widget. If
the current contents are longer than the given length, then they
will be truncated to fit.

This is equivalent to:


```C
GtkEntryBuffer *buffer;
buffer = gtk_entry_get_buffer (entry);
gtk_entry_buffer_set_max_length (buffer, max);
```
## `max`
the maximum length of the entry, or 0 for no maximum.
 (other than the maximum length of entries.) The value passed in will
 be clamped to the range 0-65536.
<!-- trait EntryExt::fn set_max_width_chars -->
Sets the desired maximum width in characters of `self`.

Feature: `v3_12`

## `n_chars`
the new desired maximum width, in characters
<!-- trait EntryExt::fn set_overwrite_mode -->
Sets whether the text is overwritten when typing in the `Entry`.
## `overwrite`
new value
<!-- trait EntryExt::fn set_placeholder_text -->
Sets text to be displayed in `self` when it is empty and unfocused.
This can be used to give a visual hint of the expected contents of
the `Entry`.

Note that since the placeholder text gets removed when the entry
received focus, using this feature is a bit problematic if the entry
is given the initial focus in a window. Sometimes this can be
worked around by delaying the initial focus setting until the
first key event arrives.
## `text`
a string to be displayed when `self` is empty and unfocused, or `None`
<!-- trait EntryExt::fn set_progress_fraction -->
Causes the entry’s progress indicator to “fill in” the given
fraction of the bar. The fraction should be between 0.0 and 1.0,
inclusive.
## `fraction`
fraction of the task that’s been completed
<!-- trait EntryExt::fn set_progress_pulse_step -->
Sets the fraction of total entry width to move the progress
bouncing block for each call to `EntryExt::progress_pulse`.
## `fraction`
fraction between 0.0 and 1.0
<!-- trait EntryExt::fn set_tabs -->
Sets a `pango::TabArray`; the tabstops in the array are applied to the entry
text.

Feature: `v3_10`

## `tabs`
a `pango::TabArray`
<!-- trait EntryExt::fn set_text -->
Sets the text in the widget to the given
value, replacing the current contents.

See `EntryBufferExt::set_text`.
## `text`
the new text
<!-- trait EntryExt::fn set_visibility -->
Sets whether the contents of the entry are visible or not.
When visibility is set to `false`, characters are displayed
as the invisible char, and will also appear that way when
the text in the entry widget is copied elsewhere.

By default, GTK+ picks the best invisible character available
in the current font, but it can be changed with
`EntryExt::set_invisible_char`.

Note that you probably want to set `Entry:input-purpose`
to `InputPurpose::Password` or `InputPurpose::Pin` to
inform input methods about the purpose of this entry,
in addition to setting visibility to `false`.
## `visible`
`true` if the contents of the entry are displayed
 as plaintext
<!-- trait EntryExt::fn set_width_chars -->
Changes the size request of the entry to be about the right size
for `n_chars` characters. Note that it changes the size
request, the size can still be affected by
how you pack the widget into containers. If `n_chars` is -1, the
size reverts to the default entry size.
## `n_chars`
width in chars
<!-- trait EntryExt::fn text_index_to_layout_index -->
Converts from a position in the entry contents (returned
by `EntryExt::get_text`) to a position in the
entry’s `pango::Layout` (returned by `EntryExt::get_layout`,
with text retrieved via `pango::LayoutExt::get_text`).
## `text_index`
byte index into the entry contents

# Returns

byte index into the entry layout text
<!-- trait EntryExt::fn unset_invisible_char -->
Unsets the invisible char previously set with
`EntryExt::set_invisible_char`. So that the
default invisible char is used again.
<!-- trait EntryExt::fn connect_activate -->
The ::activate signal is emitted when the user hits
the Enter key.

While this signal is used as a
[keybinding signal][`BindingSignal`],
it is also commonly used by applications to intercept
activation of entries.

The default bindings for this signal are all forms of the Enter key.
<!-- trait EntryExt::fn connect_backspace -->
The ::backspace signal is a
[keybinding signal][`BindingSignal`]
which gets emitted when the user asks for it.

The default bindings for this signal are
Backspace and Shift-Backspace.
<!-- trait EntryExt::fn connect_copy_clipboard -->
The ::copy-clipboard signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to copy the selection to the clipboard.

The default bindings for this signal are
Ctrl-c and Ctrl-Insert.
<!-- trait EntryExt::fn connect_cut_clipboard -->
The ::cut-clipboard signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to cut the selection to the clipboard.

The default bindings for this signal are
Ctrl-x and Shift-Delete.
<!-- trait EntryExt::fn connect_delete_from_cursor -->
The ::delete-from-cursor signal is a
[keybinding signal][`BindingSignal`]
which gets emitted when the user initiates a text deletion.

If the `type_` is `DeleteType::Chars`, GTK+ deletes the selection
if there is one, otherwise it deletes the requested number
of characters.

The default bindings for this signal are
Delete for deleting a character and Ctrl-Delete for
deleting a word.
## `type_`
the granularity of the deletion, as a `DeleteType`
## `count`
the number of `type_` units to delete
<!-- trait EntryExt::fn connect_icon_press -->
The ::icon-press signal is emitted when an activatable icon
is clicked.
## `icon_pos`
The position of the clicked icon
## `event`
the button press event
<!-- trait EntryExt::fn connect_icon_release -->
The ::icon-release signal is emitted on the button release from a
mouse click over an activatable icon.
## `icon_pos`
The position of the clicked icon
## `event`
the button release event
<!-- trait EntryExt::fn connect_insert_at_cursor -->
The ::insert-at-cursor signal is a
[keybinding signal][`BindingSignal`]
which gets emitted when the user initiates the insertion of a
fixed string at the cursor.

This signal has no default bindings.
## `string`
the string to insert
<!-- trait EntryExt::fn connect_move_cursor -->
The ::move-cursor signal is a
[keybinding signal][`BindingSignal`]
which gets emitted when the user initiates a cursor movement.
If the cursor is not visible in `entry`, this signal causes
the viewport to be moved instead.

Applications should not connect to it, but may emit it with
`g_signal_emit_by_name` if they need to control the cursor
programmatically.

The default bindings for this signal come in two variants,
the variant with the Shift modifier extends the selection,
the variant without the Shift modifer does not.
There are too many key combinations to list them all here.
- Arrow keys move by individual characters/lines
- Ctrl-arrow key combinations move by words/paragraphs
- Home/End keys move to the ends of the buffer
## `step`
the granularity of the move, as a `MovementStep`
## `count`
the number of `step` units to move
## `extend_selection`
`true` if the move should extend the selection
<!-- trait EntryExt::fn connect_paste_clipboard -->
The ::paste-clipboard signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to paste the contents of the clipboard
into the text view.

The default bindings for this signal are
Ctrl-v and Shift-Insert.
<!-- trait EntryExt::fn connect_populate_popup -->
The ::populate-popup signal gets emitted before showing the
context menu of the entry.

If you need to add items to the context menu, connect
to this signal and append your items to the `widget`, which
will be a `Menu` in this case.

If `Entry:populate-all` is `true`, this signal will
also be emitted to populate touch popups. In this case,
`widget` will be a different container, e.g. a `Toolbar`.
The signal handler should not make assumptions about the
type of `widget`.
## `widget`
the container that is being populated
<!-- trait EntryExt::fn connect_preedit_changed -->
If an input method is used, the typed text will not immediately
be committed to the buffer. So if you are interested in the text,
connect to this signal.
## `preedit`
the current preedit string
<!-- trait EntryExt::fn connect_toggle_overwrite -->
The ::toggle-overwrite signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to toggle the overwrite mode of the entry.

The default bindings for this signal is Insert.
<!-- trait EntryExt::fn get_property_attributes -->
A list of Pango attributes to apply to the text of the entry.

This is mainly useful to change the size or weight of the text.

The `pango::Attribute`'s `start_index` and `end_index` must refer to the
`EntryBuffer` text, i.e. without the preedit string.

Feature: `v3_6`

<!-- trait EntryExt::fn set_property_attributes -->
A list of Pango attributes to apply to the text of the entry.

This is mainly useful to change the size or weight of the text.

The `pango::Attribute`'s `start_index` and `end_index` must refer to the
`EntryBuffer` text, i.e. without the preedit string.

Feature: `v3_6`

<!-- trait EntryExt::fn get_property_caps-lock-warning -->
Whether password entries will show a warning when Caps Lock is on.

Note that the warning is shown using a secondary icon, and thus
does not work if you are using the secondary icon position for some
other purpose.
<!-- trait EntryExt::fn set_property_caps-lock-warning -->
Whether password entries will show a warning when Caps Lock is on.

Note that the warning is shown using a secondary icon, and thus
does not work if you are using the secondary icon position for some
other purpose.
<!-- trait EntryExt::fn get_property_completion -->
The auxiliary completion object to use with the entry.
<!-- trait EntryExt::fn set_property_completion -->
The auxiliary completion object to use with the entry.
<!-- trait EntryExt::fn get_property_im-module -->
Which IM (input method) module should be used for this entry.
See `IMContext`.

Setting this to a non-`None` value overrides the
system-wide IM module setting. See the `Settings`
`Settings:gtk-im-module` property.
<!-- trait EntryExt::fn set_property_im-module -->
Which IM (input method) module should be used for this entry.
See `IMContext`.

Setting this to a non-`None` value overrides the
system-wide IM module setting. See the `Settings`
`Settings:gtk-im-module` property.
<!-- trait EntryExt::fn get_property_inner-border -->
Sets the text area's border between the text and the frame.

# Deprecated since 3.4

Use the standard border and padding CSS properties
 (through objects like `StyleContext` and `CssProvider`); the value
 of this style property is ignored.
<!-- trait EntryExt::fn set_property_inner-border -->
Sets the text area's border between the text and the frame.

# Deprecated since 3.4

Use the standard border and padding CSS properties
 (through objects like `StyleContext` and `CssProvider`); the value
 of this style property is ignored.
<!-- trait EntryExt::fn get_property_input-hints -->
Additional hints (beyond `Entry:input-purpose`) that
allow input methods to fine-tune their behaviour.

Feature: `v3_6`

<!-- trait EntryExt::fn set_property_input-hints -->
Additional hints (beyond `Entry:input-purpose`) that
allow input methods to fine-tune their behaviour.

Feature: `v3_6`

<!-- trait EntryExt::fn get_property_input-purpose -->
The purpose of this text field.

This property can be used by on-screen keyboards and other input
methods to adjust their behaviour.

Note that setting the purpose to `InputPurpose::Password` or
`InputPurpose::Pin` is independent from setting
`Entry:visibility`.

Feature: `v3_6`

<!-- trait EntryExt::fn set_property_input-purpose -->
The purpose of this text field.

This property can be used by on-screen keyboards and other input
methods to adjust their behaviour.

Note that setting the purpose to `InputPurpose::Password` or
`InputPurpose::Pin` is independent from setting
`Entry:visibility`.

Feature: `v3_6`

<!-- trait EntryExt::fn get_property_invisible-char -->
The invisible character is used when masking entry contents (in
\"password mode\")"). When it is not explicitly set with the
`Entry:invisible-char` property, GTK+ determines the character
to use from a list of possible candidates, depending on availability
in the current font.

This style property allows the theme to prepend a character
to the list of candidates.
<!-- trait EntryExt::fn set_property_invisible-char -->
The invisible character is used when masking entry contents (in
\"password mode\")"). When it is not explicitly set with the
`Entry:invisible-char` property, GTK+ determines the character
to use from a list of possible candidates, depending on availability
in the current font.

This style property allows the theme to prepend a character
to the list of candidates.
<!-- trait EntryExt::fn get_property_invisible-char-set -->
Whether the invisible char has been set for the `Entry`.
<!-- trait EntryExt::fn set_property_invisible-char-set -->
Whether the invisible char has been set for the `Entry`.
<!-- trait EntryExt::fn get_property_max-width-chars -->
The desired maximum width of the entry, in characters.
If this property is set to -1, the width will be calculated
automatically.

Feature: `v3_12`

<!-- trait EntryExt::fn set_property_max-width-chars -->
The desired maximum width of the entry, in characters.
If this property is set to -1, the width will be calculated
automatically.

Feature: `v3_12`

<!-- trait EntryExt::fn get_property_overwrite-mode -->
If text is overwritten when typing in the `Entry`.
<!-- trait EntryExt::fn set_property_overwrite-mode -->
If text is overwritten when typing in the `Entry`.
<!-- trait EntryExt::fn get_property_placeholder-text -->
The text that will be displayed in the `Entry` when it is empty
and unfocused.
<!-- trait EntryExt::fn set_property_placeholder-text -->
The text that will be displayed in the `Entry` when it is empty
and unfocused.
<!-- trait EntryExt::fn get_property_populate-all -->
If :populate-all is `true`, the `Entry::populate-popup`
signal is also emitted for touch popups.

Feature: `v3_8`

<!-- trait EntryExt::fn set_property_populate-all -->
If :populate-all is `true`, the `Entry::populate-popup`
signal is also emitted for touch popups.

Feature: `v3_8`

<!-- trait EntryExt::fn get_property_primary-icon-activatable -->
Whether the primary icon is activatable.

GTK+ emits the `Entry::icon-press` and `Entry::icon-release`
signals only on sensitive, activatable icons.

Sensitive, but non-activatable icons can be used for purely
informational purposes.
<!-- trait EntryExt::fn set_property_primary-icon-activatable -->
Whether the primary icon is activatable.

GTK+ emits the `Entry::icon-press` and `Entry::icon-release`
signals only on sensitive, activatable icons.

Sensitive, but non-activatable icons can be used for purely
informational purposes.
<!-- trait EntryExt::fn get_property_primary-icon-gicon -->
The `gio::Icon` to use for the primary icon for the entry.
<!-- trait EntryExt::fn set_property_primary-icon-gicon -->
The `gio::Icon` to use for the primary icon for the entry.
<!-- trait EntryExt::fn get_property_primary-icon-name -->
The icon name to use for the primary icon for the entry.
<!-- trait EntryExt::fn set_property_primary-icon-name -->
The icon name to use for the primary icon for the entry.
<!-- trait EntryExt::fn get_property_primary-icon-pixbuf -->
A pixbuf to use as the primary icon for the entry.
<!-- trait EntryExt::fn set_property_primary-icon-pixbuf -->
A pixbuf to use as the primary icon for the entry.
<!-- trait EntryExt::fn get_property_primary-icon-sensitive -->
Whether the primary icon is sensitive.

An insensitive icon appears grayed out. GTK+ does not emit the
`Entry::icon-press` and `Entry::icon-release` signals and
does not allow DND from insensitive icons.

An icon should be set insensitive if the action that would trigger
when clicked is currently not available.
<!-- trait EntryExt::fn set_property_primary-icon-sensitive -->
Whether the primary icon is sensitive.

An insensitive icon appears grayed out. GTK+ does not emit the
`Entry::icon-press` and `Entry::icon-release` signals and
does not allow DND from insensitive icons.

An icon should be set insensitive if the action that would trigger
when clicked is currently not available.
<!-- trait EntryExt::fn get_property_primary-icon-stock -->
The stock id to use for the primary icon for the entry.

# Deprecated since 3.10

Use `Entry:primary-icon-name` instead.
<!-- trait EntryExt::fn set_property_primary-icon-stock -->
The stock id to use for the primary icon for the entry.

# Deprecated since 3.10

Use `Entry:primary-icon-name` instead.
<!-- trait EntryExt::fn get_property_primary-icon-storage-type -->
The representation which is used for the primary icon of the entry.
<!-- trait EntryExt::fn get_property_primary-icon-tooltip-markup -->
The contents of the tooltip on the primary icon, which is marked up
with the [Pango text markup language][PangoMarkupFormat].

Also see `EntryExt::set_icon_tooltip_markup`.
<!-- trait EntryExt::fn set_property_primary-icon-tooltip-markup -->
The contents of the tooltip on the primary icon, which is marked up
with the [Pango text markup language][PangoMarkupFormat].

Also see `EntryExt::set_icon_tooltip_markup`.
<!-- trait EntryExt::fn get_property_primary-icon-tooltip-text -->
The contents of the tooltip on the primary icon.

Also see `EntryExt::set_icon_tooltip_text`.
<!-- trait EntryExt::fn set_property_primary-icon-tooltip-text -->
The contents of the tooltip on the primary icon.

Also see `EntryExt::set_icon_tooltip_text`.
<!-- trait EntryExt::fn get_property_progress-fraction -->
The current fraction of the task that's been completed.
<!-- trait EntryExt::fn set_property_progress-fraction -->
The current fraction of the task that's been completed.
<!-- trait EntryExt::fn get_property_progress-pulse-step -->
The fraction of total entry width to move the progress
bouncing block for each call to `EntryExt::progress_pulse`.
<!-- trait EntryExt::fn set_property_progress-pulse-step -->
The fraction of total entry width to move the progress
bouncing block for each call to `EntryExt::progress_pulse`.
<!-- trait EntryExt::fn get_property_secondary-icon-activatable -->
Whether the secondary icon is activatable.

GTK+ emits the `Entry::icon-press` and `Entry::icon-release`
signals only on sensitive, activatable icons.

Sensitive, but non-activatable icons can be used for purely
informational purposes.
<!-- trait EntryExt::fn set_property_secondary-icon-activatable -->
Whether the secondary icon is activatable.

GTK+ emits the `Entry::icon-press` and `Entry::icon-release`
signals only on sensitive, activatable icons.

Sensitive, but non-activatable icons can be used for purely
informational purposes.
<!-- trait EntryExt::fn get_property_secondary-icon-gicon -->
The `gio::Icon` to use for the secondary icon for the entry.
<!-- trait EntryExt::fn set_property_secondary-icon-gicon -->
The `gio::Icon` to use for the secondary icon for the entry.
<!-- trait EntryExt::fn get_property_secondary-icon-name -->
The icon name to use for the secondary icon for the entry.
<!-- trait EntryExt::fn set_property_secondary-icon-name -->
The icon name to use for the secondary icon for the entry.
<!-- trait EntryExt::fn get_property_secondary-icon-pixbuf -->
An pixbuf to use as the secondary icon for the entry.
<!-- trait EntryExt::fn set_property_secondary-icon-pixbuf -->
An pixbuf to use as the secondary icon for the entry.
<!-- trait EntryExt::fn get_property_secondary-icon-sensitive -->
Whether the secondary icon is sensitive.

An insensitive icon appears grayed out. GTK+ does not emit the
`Entry::icon-press` and `Entry::icon-release` signals and
does not allow DND from insensitive icons.

An icon should be set insensitive if the action that would trigger
when clicked is currently not available.
<!-- trait EntryExt::fn set_property_secondary-icon-sensitive -->
Whether the secondary icon is sensitive.

An insensitive icon appears grayed out. GTK+ does not emit the
`Entry::icon-press` and `Entry::icon-release` signals and
does not allow DND from insensitive icons.

An icon should be set insensitive if the action that would trigger
when clicked is currently not available.
<!-- trait EntryExt::fn get_property_secondary-icon-stock -->
The stock id to use for the secondary icon for the entry.

# Deprecated since 3.10

Use `Entry:secondary-icon-name` instead.
<!-- trait EntryExt::fn set_property_secondary-icon-stock -->
The stock id to use for the secondary icon for the entry.

# Deprecated since 3.10

Use `Entry:secondary-icon-name` instead.
<!-- trait EntryExt::fn get_property_secondary-icon-storage-type -->
The representation which is used for the secondary icon of the entry.
<!-- trait EntryExt::fn get_property_secondary-icon-tooltip-markup -->
The contents of the tooltip on the secondary icon, which is marked up
with the [Pango text markup language][PangoMarkupFormat].

Also see `EntryExt::set_icon_tooltip_markup`.
<!-- trait EntryExt::fn set_property_secondary-icon-tooltip-markup -->
The contents of the tooltip on the secondary icon, which is marked up
with the [Pango text markup language][PangoMarkupFormat].

Also see `EntryExt::set_icon_tooltip_markup`.
<!-- trait EntryExt::fn get_property_secondary-icon-tooltip-text -->
The contents of the tooltip on the secondary icon.

Also see `EntryExt::set_icon_tooltip_text`.
<!-- trait EntryExt::fn set_property_secondary-icon-tooltip-text -->
The contents of the tooltip on the secondary icon.

Also see `EntryExt::set_icon_tooltip_text`.
<!-- trait EntryExt::fn get_property_shadow-type -->
Which kind of shadow to draw around the entry when
`Entry:has-frame` is set to `true`.

# Deprecated since 3.20

Use CSS to determine the style of the border;
 the value of this style property is ignored.
<!-- trait EntryExt::fn set_property_shadow-type -->
Which kind of shadow to draw around the entry when
`Entry:has-frame` is set to `true`.

# Deprecated since 3.20

Use CSS to determine the style of the border;
 the value of this style property is ignored.
<!-- trait EntryExt::fn get_property_text-length -->
The length of the text in the `Entry`.
<!-- trait EntryExt::fn get_property_truncate-multiline -->
When `true`, pasted multi-line text is truncated to the first line.
<!-- trait EntryExt::fn set_property_truncate-multiline -->
When `true`, pasted multi-line text is truncated to the first line.
<!-- trait EntryExt::fn get_property_xalign -->
The horizontal alignment, from 0 (left) to 1 (right).
Reversed for RTL layouts.
<!-- trait EntryExt::fn set_property_xalign -->
The horizontal alignment, from 0 (left) to 1 (right).
Reversed for RTL layouts.
<!-- struct EntryBuffer -->
The `EntryBuffer` class contains the actual text displayed in a
`Entry` widget.

A single `EntryBuffer` object can be shared by multiple `Entry`
widgets which will then share the same text content, but not the cursor
position, visibility attributes, icon etc.

`EntryBuffer` may be derived from. Such a derived class might allow
text to be stored in an alternate location, such as non-pageable memory,
useful in the case of important passwords. Or a derived class could
integrate with an application’s concept of undo/redo.

# Implements

[`EntryBufferExt`](trait.EntryBufferExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait EntryBufferExt -->
Trait containing all `EntryBuffer` methods.

# Implementors

[`EntryBuffer`](struct.EntryBuffer.html)
<!-- impl EntryBuffer::fn new -->
Create a new `EntryBuffer` object.

Optionally, specify initial text to set in the buffer.
## `initial_chars`
initial buffer text, or `None`
## `n_initial_chars`
number of characters in `initial_chars`, or -1

# Returns

A new `EntryBuffer` object.
<!-- trait EntryBufferExt::fn delete_text -->
Deletes a sequence of characters from the buffer. `n_chars` characters are
deleted starting at `position`. If `n_chars` is negative, then all characters
until the end of the text are deleted.

If `position` or `n_chars` are out of bounds, then they are coerced to sane
values.

Note that the positions are specified in characters, not bytes.
## `position`
position at which to delete text
## `n_chars`
number of characters to delete

# Returns

The number of characters deleted.
<!-- trait EntryBufferExt::fn emit_deleted_text -->
Used when subclassing `EntryBuffer`
## `position`
position at which text was deleted
## `n_chars`
number of characters deleted
<!-- trait EntryBufferExt::fn emit_inserted_text -->
Used when subclassing `EntryBuffer`
## `position`
position at which text was inserted
## `chars`
text that was inserted
## `n_chars`
number of characters inserted
<!-- trait EntryBufferExt::fn get_bytes -->
Retrieves the length in bytes of the buffer.
See `EntryBufferExt::get_length`.

# Returns

The byte length of the buffer.
<!-- trait EntryBufferExt::fn get_length -->
Retrieves the length in characters of the buffer.

# Returns

The number of characters in the buffer.
<!-- trait EntryBufferExt::fn get_max_length -->
Retrieves the maximum allowed length of the text in
`self`. See `EntryBufferExt::set_max_length`.

# Returns

the maximum allowed number of characters
 in `EntryBuffer`, or 0 if there is no maximum.
<!-- trait EntryBufferExt::fn get_text -->
Retrieves the contents of the buffer.

The memory pointer returned by this call will not change
unless this object emits a signal, or is finalized.

# Returns

a pointer to the contents of the widget as a
 string. This string points to internally allocated
 storage in the buffer and must not be freed, modified or
 stored.
<!-- trait EntryBufferExt::fn insert_text -->
Inserts `n_chars` characters of `chars` into the contents of the
buffer, at position `position`.

If `n_chars` is negative, then characters from chars will be inserted
until a null-terminator is found. If `position` or `n_chars` are out of
bounds, or the maximum buffer text length is exceeded, then they are
coerced to sane values.

Note that the position and length are in characters, not in bytes.
## `position`
the position at which to insert text.
## `chars`
the text to insert into the buffer.
## `n_chars`
the length of the text in characters, or -1

# Returns

The number of characters actually inserted.
<!-- trait EntryBufferExt::fn set_max_length -->
Sets the maximum allowed length of the contents of the buffer. If
the current contents are longer than the given length, then they
will be truncated to fit.
## `max_length`
the maximum length of the entry buffer, or 0 for no maximum.
 (other than the maximum length of entries.) The value passed in will
 be clamped to the range 0-65536.
<!-- trait EntryBufferExt::fn set_text -->
Sets the text in the buffer.

This is roughly equivalent to calling `EntryBufferExt::delete_text`
and `EntryBufferExt::insert_text`.

Note that `n_chars` is in characters, not in bytes.
## `chars`
the new text
## `n_chars`
the number of characters in `text`, or -1
<!-- trait EntryBufferExt::fn connect_deleted_text -->
This signal is emitted after text is deleted from the buffer.
## `position`
the position the text was deleted at.
## `n_chars`
The number of characters that were deleted.
<!-- trait EntryBufferExt::fn connect_inserted_text -->
This signal is emitted after text is inserted into the buffer.
## `position`
the position the text was inserted at.
## `chars`
The text that was inserted.
## `n_chars`
The number of characters that were inserted.
<!-- trait EntryBufferExt::fn get_property_length -->
The length (in characters) of the text in buffer.
<!-- trait EntryBufferExt::fn get_property_max-length -->
The maximum length (in characters) of the text in the buffer.
<!-- trait EntryBufferExt::fn set_property_max-length -->
The maximum length (in characters) of the text in the buffer.
<!-- trait EntryBufferExt::fn get_property_text -->
The contents of the buffer.
<!-- trait EntryBufferExt::fn set_property_text -->
The contents of the buffer.
<!-- struct EntryCompletion -->
`EntryCompletion` is an auxiliary object to be used in conjunction with
`Entry` to provide the completion functionality. It implements the
`CellLayout` interface, to allow the user to add extra cells to the
`TreeView` with completion matches.

“Completion functionality” means that when the user modifies the text
in the entry, `EntryCompletion` checks which rows in the model match
the current content of the entry, and displays a list of matches.
By default, the matching is done by comparing the entry text
case-insensitively against the text column of the model (see
`EntryCompletionExt::set_text_column`), but this can be overridden
with a custom match function (see `EntryCompletionExt::set_match_func`).

When the user selects a completion, the content of the entry is
updated. By default, the content of the entry is replaced by the
text column of the model, but this can be overridden by connecting
to the `EntryCompletion::match-selected` signal and updating the
entry in the signal handler. Note that you should return `true` from
the signal handler to suppress the default behaviour.

To add completion functionality to an entry, use `EntryExt::set_completion`.

In addition to regular completion matches, which will be inserted into the
entry when they are selected, `EntryCompletion` also allows to display
“actions” in the popup window. Their appearance is similar to menuitems,
to differentiate them clearly from completion strings. When an action is
selected, the `EntryCompletion::action-activated` signal is emitted.

`EntryCompletion` uses a `TreeModelFilter` model to represent the
subset of the entire model that is currently matching. While the
`EntryCompletion` signals `EntryCompletion::match-selected` and
`EntryCompletion::cursor-on-match` take the original model and an
iter pointing to that model as arguments, other callbacks and signals
(such as ``GtkCellLayoutDataFuncs`` or `CellArea::apply-attributes`)
will generally take the filter model as argument. As long as you are
only calling `TreeModel::get`, this will make no difference to
you. If for some reason, you need the original model, use
`TreeModelFilterExt::get_model`. Don’t forget to use
`TreeModelFilterExt::convert_iter_to_child_iter` to obtain a
matching iter.

# Implements

[`EntryCompletionExt`](trait.EntryCompletionExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`CellLayoutExt`](trait.CellLayoutExt.html)
<!-- trait EntryCompletionExt -->
Trait containing all `EntryCompletion` methods.

# Implementors

[`EntryCompletion`](struct.EntryCompletion.html)
<!-- impl EntryCompletion::fn new -->
Creates a new `EntryCompletion` object.

# Returns

A newly created `EntryCompletion` object
<!-- impl EntryCompletion::fn new_with_area -->
Creates a new `EntryCompletion` object using the
specified `area` to layout cells in the underlying
`TreeViewColumn` for the drop-down menu.
## `area`
the `CellArea` used to layout cells

# Returns

A newly created `EntryCompletion` object
<!-- trait EntryCompletionExt::fn complete -->
Requests a completion operation, or in other words a refiltering of the
current list with completions, using the current key. The completion list
view will be updated accordingly.
<!-- trait EntryCompletionExt::fn compute_prefix -->
Computes the common prefix that is shared by all rows in `self`
that start with `key`. If no row matches `key`, `None` will be returned.
Note that a text column must have been set for this function to work,
see `EntryCompletionExt::set_text_column` for details.
## `key`
The text to complete for

# Returns

The common prefix all rows starting with
 `key` or `None` if no row matches `key`.
<!-- trait EntryCompletionExt::fn delete_action -->
Deletes the action at `index_` from `self`’s action list.

Note that `index_` is a relative position and the position of an
action may have changed since it was inserted.
## `index_`
the index of the item to delete
<!-- trait EntryCompletionExt::fn get_completion_prefix -->
Get the original text entered by the user that triggered
the completion or `None` if there’s no completion ongoing.

# Returns

the prefix for the current completion
<!-- trait EntryCompletionExt::fn get_entry -->
Gets the entry `self` has been attached to.

# Returns

The entry `self` has been attached to
<!-- trait EntryCompletionExt::fn get_inline_completion -->
Returns whether the common prefix of the possible completions should
be automatically inserted in the entry.

# Returns

`true` if inline completion is turned on
<!-- trait EntryCompletionExt::fn get_inline_selection -->
Returns `true` if inline-selection mode is turned on.

# Returns

`true` if inline-selection mode is on
<!-- trait EntryCompletionExt::fn get_minimum_key_length -->
Returns the minimum key length as set for `self`.

# Returns

The currently used minimum key length
<!-- trait EntryCompletionExt::fn get_model -->
Returns the model the `EntryCompletion` is using as data source.
Returns `None` if the model is unset.

# Returns

A `TreeModel`, or `None` if none
 is currently being used
<!-- trait EntryCompletionExt::fn get_popup_completion -->
Returns whether the completions should be presented in a popup window.

# Returns

`true` if popup completion is turned on
<!-- trait EntryCompletionExt::fn get_popup_set_width -->
Returns whether the completion popup window will be resized to the
width of the entry.

# Returns

`true` if the popup window will be resized to the width of
 the entry
<!-- trait EntryCompletionExt::fn get_popup_single_match -->
Returns whether the completion popup window will appear even if there is
only a single match.

# Returns

`true` if the popup window will appear regardless of the
 number of matches
<!-- trait EntryCompletionExt::fn get_text_column -->
Returns the column in the model of `self` to get strings from.

# Returns

the column containing the strings
<!-- trait EntryCompletionExt::fn insert_action_markup -->
Inserts an action in `self`’s action item list at position `index_`
with markup `markup`.
## `index_`
the index of the item to insert
## `markup`
markup of the item to insert
<!-- trait EntryCompletionExt::fn insert_action_text -->
Inserts an action in `self`’s action item list at position `index_`
with text `text`. If you want the action item to have markup, use
`EntryCompletionExt::insert_action_markup`.

Note that `index_` is a relative position in the list of actions and
the position of an action can change when deleting a different action.
## `index_`
the index of the item to insert
## `text`
text of the item to insert
<!-- trait EntryCompletionExt::fn insert_prefix -->
Requests a prefix insertion.
<!-- trait EntryCompletionExt::fn set_inline_completion -->
Sets whether the common prefix of the possible completions should
be automatically inserted in the entry.
## `inline_completion`
`true` to do inline completion
<!-- trait EntryCompletionExt::fn set_inline_selection -->
Sets whether it is possible to cycle through the possible completions
inside the entry.
## `inline_selection`
`true` to do inline selection
<!-- trait EntryCompletionExt::fn set_match_func -->
Sets the match function for `self` to be `func`. The match function
is used to determine if a row should or should not be in the completion
list.
## `func`
the ``GtkEntryCompletionMatchFunc`` to use
## `func_data`
user data for `func`
## `func_notify`
destroy notify for `func_data`.
<!-- trait EntryCompletionExt::fn set_minimum_key_length -->
Requires the length of the search key for `self` to be at least
`length`. This is useful for long lists, where completing using a small
key takes a lot of time and will come up with meaningless results anyway
(ie, a too large dataset).
## `length`
the minimum length of the key in order to start completing
<!-- trait EntryCompletionExt::fn set_model -->
Sets the model for a `EntryCompletion`. If `self` already has
a model set, it will remove it before setting the new model.
If model is `None`, then it will unset the model.
## `model`
the `TreeModel`
<!-- trait EntryCompletionExt::fn set_popup_completion -->
Sets whether the completions should be presented in a popup window.
## `popup_completion`
`true` to do popup completion
<!-- trait EntryCompletionExt::fn set_popup_set_width -->
Sets whether the completion popup window will be resized to be the same
width as the entry.
## `popup_set_width`
`true` to make the width of the popup the same as the entry
<!-- trait EntryCompletionExt::fn set_popup_single_match -->
Sets whether the completion popup window will appear even if there is
only a single match. You may want to set this to `false` if you
are using [inline completion][`EntryCompletion`--inline-completion].
## `popup_single_match`
`true` if the popup should appear even for a single
 match
<!-- trait EntryCompletionExt::fn set_text_column -->
Convenience function for setting up the most used case of this code: a
completion list with just strings. This function will set up `self`
to have a list displaying all (and just) strings in the completion list,
and to get those strings from `column` in the model of `self`.

This functions creates and adds a `CellRendererText` for the selected
column. If you need to set the text column, but don't want the cell
renderer, use `gobject::ObjectExt::set` to set the `EntryCompletion:text-column`
property directly.
## `column`
the column in the model of `self` to get strings from
<!-- trait EntryCompletionExt::fn connect_action_activated -->
Gets emitted when an action is activated.
## `index`
the index of the activated action
<!-- trait EntryCompletionExt::fn connect_cursor_on_match -->
Gets emitted when a match from the cursor is on a match
of the list. The default behaviour is to replace the contents
of the entry with the contents of the text column in the row
pointed to by `iter`.

Note that `model` is the model that was passed to
`EntryCompletionExt::set_model`.
## `model`
the `TreeModel` containing the matches
## `iter`
a `TreeIter` positioned at the selected match

# Returns

`true` if the signal has been handled
<!-- trait EntryCompletionExt::fn connect_insert_prefix -->
Gets emitted when the inline autocompletion is triggered.
The default behaviour is to make the entry display the
whole prefix and select the newly inserted part.

Applications may connect to this signal in order to insert only a
smaller part of the `prefix` into the entry - e.g. the entry used in
the `FileChooser` inserts only the part of the prefix up to the
next '/'.
## `prefix`
the common prefix of all possible completions

# Returns

`true` if the signal has been handled
<!-- trait EntryCompletionExt::fn connect_match_selected -->
Gets emitted when a match from the list is selected.
The default behaviour is to replace the contents of the
entry with the contents of the text column in the row
pointed to by `iter`.

Note that `model` is the model that was passed to
`EntryCompletionExt::set_model`.
## `model`
the `TreeModel` containing the matches
## `iter`
a `TreeIter` positioned at the selected match

# Returns

`true` if the signal has been handled
<!-- trait EntryCompletionExt::fn connect_no_matches -->
Gets emitted when the filter model has zero
number of rows in completion_complete method.
(In other words when `EntryCompletion` is out of
 suggestions)

Feature: `v3_14`

<!-- trait EntryCompletionExt::fn get_property_cell-area -->
The `CellArea` used to layout cell renderers in the treeview column.

If no area is specified when creating the entry completion with
`EntryCompletion::new_with_area` a horizontally oriented
`CellAreaBox` will be used.
<!-- trait EntryCompletionExt::fn set_property_cell-area -->
The `CellArea` used to layout cell renderers in the treeview column.

If no area is specified when creating the entry completion with
`EntryCompletion::new_with_area` a horizontally oriented
`CellAreaBox` will be used.
<!-- trait EntryCompletionExt::fn get_property_inline-completion -->
Determines whether the common prefix of the possible completions
should be inserted automatically in the entry. Note that this
requires text-column to be set, even if you are using a custom
match function.
<!-- trait EntryCompletionExt::fn set_property_inline-completion -->
Determines whether the common prefix of the possible completions
should be inserted automatically in the entry. Note that this
requires text-column to be set, even if you are using a custom
match function.
<!-- trait EntryCompletionExt::fn get_property_inline-selection -->
Determines whether the possible completions on the popup
will appear in the entry as you navigate through them.
<!-- trait EntryCompletionExt::fn set_property_inline-selection -->
Determines whether the possible completions on the popup
will appear in the entry as you navigate through them.
<!-- trait EntryCompletionExt::fn get_property_popup-completion -->
Determines whether the possible completions should be
shown in a popup window.
<!-- trait EntryCompletionExt::fn set_property_popup-completion -->
Determines whether the possible completions should be
shown in a popup window.
<!-- trait EntryCompletionExt::fn get_property_popup-set-width -->
Determines whether the completions popup window will be
resized to the width of the entry.
<!-- trait EntryCompletionExt::fn set_property_popup-set-width -->
Determines whether the completions popup window will be
resized to the width of the entry.
<!-- trait EntryCompletionExt::fn get_property_popup-single-match -->
Determines whether the completions popup window will shown
for a single possible completion. You probably want to set
this to `false` if you are using
[inline completion][`EntryCompletion`--inline-completion].
<!-- trait EntryCompletionExt::fn set_property_popup-single-match -->
Determines whether the completions popup window will shown
for a single possible completion. You probably want to set
this to `false` if you are using
[inline completion][`EntryCompletion`--inline-completion].
<!-- trait EntryCompletionExt::fn get_property_text-column -->
The column of the model containing the strings.
Note that the strings must be UTF-8.
<!-- trait EntryCompletionExt::fn set_property_text-column -->
The column of the model containing the strings.
Note that the strings must be UTF-8.
<!-- enum EntryIconPosition -->
Specifies the side of the entry at which an icon is placed.
<!-- enum EntryIconPosition::variant Primary -->
At the beginning of the entry (depending on the text direction).
<!-- enum EntryIconPosition::variant Secondary -->
At the end of the entry (depending on the text direction).
<!-- struct EventBox -->
The `EventBox` widget is a subclass of `Bin` which also has its
own window. It is useful since it allows you to catch events for widgets
which do not have their own window.

# Implements

[`EventBoxExt`](trait.EventBoxExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait EventBoxExt -->
Trait containing all `EventBox` methods.

# Implementors

[`EventBox`](struct.EventBox.html)
<!-- impl EventBox::fn new -->
Creates a new `EventBox`.

# Returns

a new `EventBox`
<!-- trait EventBoxExt::fn get_above_child -->
Returns whether the event box window is above or below the
windows of its child. See `EventBoxExt::set_above_child`
for details.

# Returns

`true` if the event box window is above the
 window of its child
<!-- trait EventBoxExt::fn get_visible_window -->
Returns whether the event box has a visible window.
See `EventBoxExt::set_visible_window` for details.

# Returns

`true` if the event box window is visible
<!-- trait EventBoxExt::fn set_above_child -->
Set whether the event box window is positioned above the windows
of its child, as opposed to below it. If the window is above, all
events inside the event box will go to the event box. If the window
is below, events in windows of child widgets will first got to that
widget, and then to its parents.

The default is to keep the window below the child.
## `above_child`
`true` if the event box window is above its child
<!-- trait EventBoxExt::fn set_visible_window -->
Set whether the event box uses a visible or invisible child
window. The default is to use visible windows.

In an invisible window event box, the window that the
event box creates is a `gdk::WindowWindowClass::InputOnly` window, which
means that it is invisible and only serves to receive
events.

A visible window event box creates a visible (`gdk::WindowWindowClass::InputOutput`)
window that acts as the parent window for all the widgets
contained in the event box.

You should generally make your event box invisible if
you just want to trap events. Creating a visible window
may cause artifacts that are visible to the user, especially
if the user is using a theme with gradients or pixmaps.

The main reason to create a non input-only event box is if
you want to set the background to a different color or
draw on it.

There is one unexpected issue for an invisible event box that has its
window below the child. (See `EventBoxExt::set_above_child`.)
Since the input-only window is not an ancestor window of any windows
that descendent widgets of the event box create, events on these
windows aren’t propagated up by the windowing system, but only by GTK+.
The practical effect of this is if an event isn’t in the event
mask for the descendant window (see `WidgetExt::add_events`),
it won’t be received by the event box.

This problem doesn’t occur for visible event boxes, because in
that case, the event box window is actually the ancestor of the
descendant windows, not just at the same place on the screen.
## `visible_window`
`true` to make the event box have a visible window
<!-- struct EventController -->
`EventController` is a base, low-level implementation for event
controllers. Those react to a series of ``GdkEvents``, and possibly trigger
actions as a consequence of those.

Feature: `v3_14`

# Implements

[`EventControllerExt`](trait.EventControllerExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait EventControllerExt -->
Trait containing all `EventController` methods.

Feature: `v3_14`

# Implementors

[`EventController`](struct.EventController.html), [`Gesture`](struct.Gesture.html)
<!-- trait EventControllerExt::fn get_propagation_phase -->
Gets the propagation phase at which `self` handles events.

Feature: `v3_14`


# Returns

the propagation phase
<!-- trait EventControllerExt::fn get_widget -->
Returns the `Widget` this controller relates to.

Feature: `v3_14`


# Returns

a `Widget`
<!-- trait EventControllerExt::fn handle_event -->
Feeds an events into `self`, so it can be interpreted
and the controller actions triggered.

Feature: `v3_14`

## `event`
a ``GdkEvent``

# Returns

`true` if the event was potentially useful to trigger the
 controller action
<!-- trait EventControllerExt::fn reset -->
Resets the `self` to a clean state. Every interaction
the controller did through `EventController::handle-event`
will be dropped at this point.

Feature: `v3_14`

<!-- trait EventControllerExt::fn set_propagation_phase -->
Sets the propagation phase at which a controller handles events.

If `phase` is `PropagationPhase::None`, no automatic event handling will be
performed, but other additional gesture maintenance will. In that phase,
the events can be managed by calling `EventControllerExt::handle_event`.

Feature: `v3_14`

## `phase`
a propagation phase
<!-- trait EventControllerExt::fn get_property_propagation-phase -->
The propagation phase at which this controller will handle events.

Feature: `v3_14`

<!-- trait EventControllerExt::fn set_property_propagation-phase -->
The propagation phase at which this controller will handle events.

Feature: `v3_14`

<!-- trait EventControllerExt::fn get_property_widget -->
The widget receiving the ``GdkEvents`` that the controller will handle.

Feature: `v3_14`

<!-- trait EventControllerExt::fn set_property_widget -->
The widget receiving the ``GdkEvents`` that the controller will handle.

Feature: `v3_14`

<!-- enum EventSequenceState -->
Describes the state of a `gdk::EventSequence` in a `Gesture`.
<!-- enum EventSequenceState::variant None -->
The sequence is handled, but not grabbed.
<!-- enum EventSequenceState::variant Claimed -->
The sequence is handled and grabbed.
<!-- enum EventSequenceState::variant Denied -->
The sequence is denied.

Feature: `v3_14`

<!-- struct Expander -->
A `Expander` allows the user to hide or show its child by clicking
on an expander triangle similar to the triangles used in a `TreeView`.

Normally you use an expander as you would use any other descendant
of `Bin`; you create the child widget and use `ContainerExt::add`
to add it to the expander. When the expander is toggled, it will take
care of showing and hiding the child automatically.

# Special Usage

There are situations in which you may prefer to show and hide the
expanded widget yourself, such as when you want to actually create
the widget at expansion time. In this case, create a `Expander`
but do not add a child to it. The expander widget has an
`Expander:expanded` property which can be used to monitor
its expansion state. You should watch this property with a signal
connection as follows:


```C
expander = gtk_expander_new_with_mnemonic ("_More Options");
g_signal_connect (expander, "notify::expanded",
                  G_CALLBACK (expander_callback), NULL);

...

static void
expander_callback (GObject    *object,
                   GParamSpec *param_spec,
                   gpointer    user_data)
{
  GtkExpander *expander;

  expander = GTK_EXPANDER (object);

  if (gtk_expander_get_expanded (expander))
    {
      // Show or create widgets
    }
  else
    {
      // Hide or destroy widgets
    }
}
```

# `Expander` as `Buildable`

The `Expander` implementation of the `Buildable` interface supports
placing a child in the label position by specifying “label” as the
“type” attribute of a `<child>` element. A normal content child can be
specified without specifying a `<child>` type attribute.

An example of a UI definition fragment with `Expander`:

```plain
expander
├── title
│   ├── arrow
│   ╰── <label widget>
╰── <child>
```

`Expander` has three CSS nodes, the main node with the name expander,
a subnode with name title and node below it with name arrow. Neither of
them is using any style classes.

# Implements

[`ExpanderExt`](trait.ExpanderExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait ExpanderExt -->
Trait containing all `Expander` methods.

# Implementors

[`Expander`](struct.Expander.html)
<!-- impl Expander::fn new -->
Creates a new expander using `label` as the text of the label.
## `label`
the text of the label

# Returns

a new `Expander` widget.
<!-- impl Expander::fn new_with_mnemonic -->
Creates a new expander using `label` as the text of the label.
If characters in `label` are preceded by an underscore, they are underlined.
If you need a literal underscore character in a label, use “__” (two
underscores). The first underlined character represents a keyboard
accelerator called a mnemonic.
Pressing Alt and that key activates the button.
## `label`
the text of the label with an underscore
 in front of the mnemonic character

# Returns

a new `Expander` widget.
<!-- trait ExpanderExt::fn get_expanded -->
Queries a `Expander` and returns its current state. Returns `true`
if the child widget is revealed.

See `ExpanderExt::set_expanded`.

# Returns

the current state of the expander
<!-- trait ExpanderExt::fn get_label -->
Fetches the text from a label widget including any embedded
underlines indicating mnemonics and Pango markup, as set by
`ExpanderExt::set_label`. If the label text has not been set the
return value will be `None`. This will be the case if you create an
empty button with `Button::new` to use as a container.

Note that this function behaved differently in versions prior to
2.14 and used to return the label text stripped of embedded
underlines indicating mnemonics and Pango markup. This problem can
be avoided by fetching the label text directly from the label
widget.

# Returns

The text of the label widget. This string is owned
 by the widget and must not be modified or freed.
<!-- trait ExpanderExt::fn get_label_fill -->
Returns whether the label widget will fill all available
horizontal space allocated to `self`.

# Returns

`true` if the label widget will fill all
 available horizontal space
<!-- trait ExpanderExt::fn get_label_widget -->
Retrieves the label widget for the frame. See
`ExpanderExt::set_label_widget`.

# Returns

the label widget,
 or `None` if there is none
<!-- trait ExpanderExt::fn get_resize_toplevel -->
Returns whether the expander will resize the toplevel widget
containing the expander upon resizing and collpasing.

# Returns

the “resize toplevel” setting.
<!-- trait ExpanderExt::fn get_spacing -->
Gets the value set by `ExpanderExt::set_spacing`.

# Deprecated since 3.20

Use margins on the child instead.

# Returns

spacing between the expander and child
<!-- trait ExpanderExt::fn get_use_markup -->
Returns whether the label’s text is interpreted as marked up with
the [Pango text markup language][PangoMarkupFormat].
See `ExpanderExt::set_use_markup`.

# Returns

`true` if the label’s text will be parsed for markup
<!-- trait ExpanderExt::fn get_use_underline -->
Returns whether an embedded underline in the expander label
indicates a mnemonic. See `ExpanderExt::set_use_underline`.

# Returns

`true` if an embedded underline in the expander
 label indicates the mnemonic accelerator keys
<!-- trait ExpanderExt::fn set_expanded -->
Sets the state of the expander. Set to `true`, if you want
the child widget to be revealed, and `false` if you want the
child widget to be hidden.
## `expanded`
whether the child widget is revealed
<!-- trait ExpanderExt::fn set_label -->
Sets the text of the label of the expander to `label`.

This will also clear any previously set labels.
## `label`
a string
<!-- trait ExpanderExt::fn set_label_fill -->
Sets whether the label widget should fill all available
horizontal space allocated to `self`.
## `label_fill`
`true` if the label should should fill
 all available horizontal space
<!-- trait ExpanderExt::fn set_label_widget -->
Set the label widget for the expander. This is the widget
that will appear embedded alongside the expander arrow.
## `label_widget`
the new label widget
<!-- trait ExpanderExt::fn set_resize_toplevel -->
Sets whether the expander will resize the toplevel widget
containing the expander upon resizing and collpasing.
## `resize_toplevel`
whether to resize the toplevel
<!-- trait ExpanderExt::fn set_spacing -->
Sets the spacing field of `self`, which is the number of
pixels to place between expander and the child.

# Deprecated since 3.20

Use margins on the child instead.
## `spacing`
distance between the expander and child in pixels
<!-- trait ExpanderExt::fn set_use_markup -->
Sets whether the text of the label contains markup in
[Pango’s text markup language][PangoMarkupFormat].
See `LabelExt::set_markup`.
## `use_markup`
`true` if the label’s text should be parsed for markup
<!-- trait ExpanderExt::fn set_use_underline -->
If true, an underline in the text of the expander label indicates
the next character should be used for the mnemonic accelerator key.
## `use_underline`
`true` if underlines in the text indicate mnemonics
<!-- trait ExpanderExt::fn get_property_resize-toplevel -->
When this property is `true`, the expander will resize the toplevel
widget containing the expander upon expanding and collapsing.
<!-- trait ExpanderExt::fn set_property_resize-toplevel -->
When this property is `true`, the expander will resize the toplevel
widget containing the expander upon expanding and collapsing.
<!-- trait ExpanderExt::fn get_property_spacing -->
Space to put between the label and the child when the
expander is expanded.

# Deprecated since 3.20

This property is deprecated and ignored.
 Use margins on the child instead.
<!-- trait ExpanderExt::fn set_property_spacing -->
Space to put between the label and the child when the
expander is expanded.

# Deprecated since 3.20

This property is deprecated and ignored.
 Use margins on the child instead.
<!-- struct FileChooser -->
`FileChooser` is an interface that can be implemented by file
selection widgets. In GTK+, the main objects that implement this
interface are `FileChooserWidget`, `FileChooserDialog`, and
`FileChooserButton`. You do not need to write an object that
implements the `FileChooser` interface unless you are trying to
adapt an existing file selector to expose a standard programming
interface.

`FileChooser` allows for shortcuts to various places in the filesystem.
In the default implementation these are displayed in the left pane. It
may be a bit confusing at first that these shortcuts come from various
sources and in various flavours, so lets explain the terminology here:

- Bookmarks: are created by the user, by dragging folders from the
 right pane to the left pane, or by using the “Add”. Bookmarks
 can be renamed and deleted by the user.

- Shortcuts: can be provided by the application. For example, a Paint
 program may want to add a shortcut for a Clipart folder. Shortcuts
 cannot be modified by the user.

- Volumes: are provided by the underlying filesystem abstraction. They are
 the “roots” of the filesystem.

# File Names and Encodings

When the user is finished selecting files in a
`FileChooser`, your program can get the selected names
either as filenames or as URIs. For URIs, the normal escaping
rules are applied if the URI contains non-ASCII characters.
However, filenames are always returned in
the character set specified by the
`G_FILENAME_ENCODING` environment variable.
Please see the GLib documentation for more details about this
variable.

This means that while you can pass the result of
`FileChooser::get_filename` to `open` or `fopen`,
you may not be able to directly set it as the text of a
`Label` widget unless you convert it first to UTF-8,
which all GTK+ widgets expect. You should use `g_filename_to_utf8`
to convert filenames into strings that can be passed to GTK+
widgets.

# Adding a Preview Widget

You can add a custom preview widget to a file chooser and then
get notification about when the preview needs to be updated.
To install a preview widget, use
`FileChooser::set_preview_widget`. Then, connect to the
`FileChooser::update-preview` signal to get notified when
you need to update the contents of the preview.

Your callback should use
`FileChooser::get_preview_filename` to see what needs
previewing. Once you have generated the preview for the
corresponding file, you must call
`FileChooser::set_preview_widget_active` with a boolean
flag that indicates whether your callback could successfully
generate a preview.

## Example: Using a Preview Widget ## {`gtkfilechooser`-preview}

```C
{
  GtkImage *preview;

  ...

  preview = gtk_image_new ();

  gtk_file_chooser_set_preview_widget (my_file_chooser, preview);
  g_signal_connect (my_file_chooser, "update-preview",
            G_CALLBACK (update_preview_cb), preview);
}

static void
update_preview_cb (GtkFileChooser *file_chooser, gpointer data)
{
  GtkWidget *preview;
  char *filename;
  GdkPixbuf *pixbuf;
  gboolean have_preview;

  preview = GTK_WIDGET (data);
  filename = gtk_file_chooser_get_preview_filename (file_chooser);

  pixbuf = gdk_pixbuf_new_from_file_at_size (filename, 128, 128, NULL);
  have_preview = (pixbuf != NULL);
  g_free (filename);

  gtk_image_set_from_pixbuf (GTK_IMAGE (preview), pixbuf);
  if (pixbuf)
    g_object_unref (pixbuf);

  gtk_file_chooser_set_preview_widget_active (file_chooser, have_preview);
}
```

# Adding Extra Widgets

You can add extra widgets to a file chooser to provide options
that are not present in the default design. For example, you
can add a toggle button to give the user the option to open a
file in read-only mode. You can use
`FileChooser::set_extra_widget` to insert additional
widgets in a file chooser.

An example for adding extra widgets:

```C

  GtkWidget *toggle;

  ...

  toggle = gtk_check_button_new_with_label ("Open file read-only");
  gtk_widget_show (toggle);
  gtk_file_chooser_set_extra_widget (my_file_chooser, toggle);
}
```

If you want to set more than one extra widget in the file
chooser, you can a container such as a `Box` or a `Grid`
and include your widgets in it. Then, set the container as
the whole extra widget.

# Implements

[`FileChooserExt`](trait.FileChooserExt.html)
<!-- trait FileChooserExt -->
Trait containing all `FileChooser` methods.

# Implementors

[`FileChooserButton`](struct.FileChooserButton.html), [`FileChooserDialog`](struct.FileChooserDialog.html), [`FileChooserWidget`](struct.FileChooserWidget.html), [`FileChooser`](struct.FileChooser.html)
<!-- trait FileChooserExt::fn add_choice -->
Adds a 'choice' to the file chooser. This is typically implemented
as a combobox or, for boolean choices, as a checkbutton. You can select
a value using `FileChooser::set_choice` before the dialog is shown,
and you can obtain the user-selected value in the ::response signal handler
using `FileChooser::get_choice`.

Compare `FileChooser::set_extra_widget`.

Feature: `v3_22`

## `id`
id for the added choice
## `label`
user-visible label for the added choice
## `options`
ids for the options of the choice, or `None` for a boolean choice
## `option_labels`
user-visible labels for the options, must be the same length as `options`
<!-- trait FileChooserExt::fn add_filter -->
Adds `filter` to the list of filters that the user can select between.
When a filter is selected, only files that are passed by that
filter are displayed.

Note that the `self` takes ownership of the filter, so you have to
ref and sink it if you want to keep a reference.
## `filter`
a `FileFilter`
<!-- trait FileChooserExt::fn add_shortcut_folder -->
Adds a folder to be displayed with the shortcut folders in a file chooser.
Note that shortcut folders do not get saved, as they are provided by the
application. For example, you can use this to add a
“/usr/share/mydrawprogram/Clipart” folder to the volume list.
## `folder`
filename of the folder to add

# Returns

`true` if the folder could be added successfully, `false`
otherwise. In the latter case, the `error` will be set as appropriate.
<!-- trait FileChooserExt::fn add_shortcut_folder_uri -->
Adds a folder URI to be displayed with the shortcut folders in a file
chooser. Note that shortcut folders do not get saved, as they are provided
by the application. For example, you can use this to add a
“file:///usr/share/mydrawprogram/Clipart” folder to the volume list.
## `uri`
URI of the folder to add

# Returns

`true` if the folder could be added successfully, `false`
otherwise. In the latter case, the `error` will be set as appropriate.
<!-- trait FileChooserExt::fn get_action -->
Gets the type of operation that the file chooser is performing; see
`FileChooser::set_action`.

# Returns

the action that the file selector is performing
<!-- trait FileChooserExt::fn get_choice -->
Gets the currently selected option in the 'choice' with the given ID.

Feature: `v3_22`

## `id`
the ID of the choice to get

# Returns

the ID of the currenly selected option
<!-- trait FileChooserExt::fn get_create_folders -->
Gets whether file choser will offer to create new folders.
See `FileChooser::set_create_folders`.

# Returns

`true` if the Create Folder button should be displayed.
<!-- trait FileChooserExt::fn get_current_folder -->
Gets the current folder of `self` as a local filename.
See `FileChooser::set_current_folder`.

Note that this is the folder that the file chooser is currently displaying
(e.g. "/home/username/Documents"), which is not the same
as the currently-selected folder if the chooser is in
`FileChooserAction::SelectFolder` mode
(e.g. "/home/username/Documents/selected-folder/". To get the
currently-selected folder in that mode, use `FileChooser::get_uri` as the
usual way to get the selection.

# Returns

the full path of the current
folder, or `None` if the current path cannot be represented as a local
filename. Free with `g_free`. This function will also return
`None` if the file chooser was unable to load the last folder that
was requested from it; for example, as would be for calling
`FileChooser::set_current_folder` on a nonexistent folder.
<!-- trait FileChooserExt::fn get_current_folder_file -->
Gets the current folder of `self` as `gio::File`.
See `FileChooser::get_current_folder_uri`.

# Returns

the `gio::File` for the current folder.
<!-- trait FileChooserExt::fn get_current_folder_uri -->
Gets the current folder of `self` as an URI.
See `FileChooser::set_current_folder_uri`.

Note that this is the folder that the file chooser is currently displaying
(e.g. "file:///home/username/Documents"), which is not the same
as the currently-selected folder if the chooser is in
`FileChooserAction::SelectFolder` mode
(e.g. "file:///home/username/Documents/selected-folder/". To get the
currently-selected folder in that mode, use `FileChooser::get_uri` as the
usual way to get the selection.

# Returns

the URI for the current folder.
Free with `g_free`. This function will also return `None` if the file chooser
was unable to load the last folder that was requested from it; for example,
as would be for calling `FileChooser::set_current_folder_uri` on a
nonexistent folder.
<!-- trait FileChooserExt::fn get_current_name -->
Gets the current name in the file selector, as entered by the user in the
text entry for “Name”.

This is meant to be used in save dialogs, to get the currently typed filename
when the file itself does not exist yet. For example, an application that
adds a custom extra widget to the file chooser for “file format” may want to
change the extension of the typed filename based on the chosen format, say,
from “.jpg” to “.png”.

Feature: `v3_10`


# Returns

The raw text from the file chooser’s “Name” entry. Free this with
`g_free`. Note that this string is not a full pathname or URI; it is
whatever the contents of the entry are. Note also that this string is in
UTF-8 encoding, which is not necessarily the system’s encoding for filenames.
<!-- trait FileChooserExt::fn get_do_overwrite_confirmation -->
Queries whether a file chooser is set to confirm for overwriting when the user
types a file name that already exists.

# Returns

`true` if the file chooser will present a confirmation dialog;
`false` otherwise.
<!-- trait FileChooserExt::fn get_extra_widget -->
Gets the current extra widget; see
`FileChooser::set_extra_widget`.

# Returns

the current extra widget, or `None`
<!-- trait FileChooserExt::fn get_file -->
Gets the `gio::File` for the currently selected file in
the file selector. If multiple files are selected,
one of the files will be returned at random.

If the file chooser is in folder mode, this function returns the selected
folder.

# Returns

a selected `gio::File`. You own the returned file;
 use `gobject::ObjectExt::unref` to release it.
<!-- trait FileChooserExt::fn get_filename -->
Gets the filename for the currently selected file in
the file selector. The filename is returned as an absolute path. If
multiple files are selected, one of the filenames will be returned at
random.

If the file chooser is in folder mode, this function returns the selected
folder.

# Returns

The currently selected filename,
 or `None` if no file is selected, or the selected file can't
 be represented with a local filename. Free with `g_free`.
<!-- trait FileChooserExt::fn get_filenames -->
Lists all the selected files and subfolders in the current folder of
`self`. The returned names are full absolute paths. If files in the current
folder cannot be represented as local filenames they will be ignored. (See
`FileChooser::get_uris`)

# Returns

a `glib::SList`
 containing the filenames of all selected files and subfolders in
 the current folder. Free the returned list with `glib::SList::free`,
 and the filenames with `g_free`.
<!-- trait FileChooserExt::fn get_files -->
Lists all the selected files and subfolders in the current folder of `self`
as `gio::File`. An internal function, see `FileChooser::get_uris`.

# Returns

a `glib::SList`
 containing a `gio::File` for each selected file and subfolder in the
 current folder. Free the returned list with `glib::SList::free`, and
 the files with `gobject::ObjectExt::unref`.
<!-- trait FileChooserExt::fn get_filter -->
Gets the current filter; see `FileChooser::set_filter`.

# Returns

the current filter, or `None`
<!-- trait FileChooserExt::fn get_local_only -->
Gets whether only local files can be selected in the
file selector. See `FileChooser::set_local_only`

# Returns

`true` if only local files can be selected.
<!-- trait FileChooserExt::fn get_preview_file -->
Gets the `gio::File` that should be previewed in a custom preview
Internal function, see `FileChooser::get_preview_uri`.

# Returns

the `gio::File` for the file to preview,
 or `None` if no file is selected. Free with `gobject::ObjectExt::unref`.
<!-- trait FileChooserExt::fn get_preview_filename -->
Gets the filename that should be previewed in a custom preview
widget. See `FileChooser::set_preview_widget`.

# Returns

the filename to preview, or `None` if
 no file is selected, or if the selected file cannot be represented
 as a local filename. Free with `g_free`
<!-- trait FileChooserExt::fn get_preview_uri -->
Gets the URI that should be previewed in a custom preview
widget. See `FileChooser::set_preview_widget`.

# Returns

the URI for the file to preview,
 or `None` if no file is selected. Free with `g_free`.
<!-- trait FileChooserExt::fn get_preview_widget -->
Gets the current preview widget; see
`FileChooser::set_preview_widget`.

# Returns

the current preview widget, or `None`
<!-- trait FileChooserExt::fn get_preview_widget_active -->
Gets whether the preview widget set by `FileChooser::set_preview_widget`
should be shown for the current filename. See
`FileChooser::set_preview_widget_active`.

# Returns

`true` if the preview widget is active for the current filename.
<!-- trait FileChooserExt::fn get_select_multiple -->
Gets whether multiple files can be selected in the file
selector. See `FileChooser::set_select_multiple`.

# Returns

`true` if multiple files can be selected.
<!-- trait FileChooserExt::fn get_show_hidden -->
Gets whether hidden files and folders are displayed in the file selector.
See `FileChooser::set_show_hidden`.

# Returns

`true` if hidden files and folders are displayed.
<!-- trait FileChooserExt::fn get_uri -->
Gets the URI for the currently selected file in
the file selector. If multiple files are selected,
one of the filenames will be returned at random.

If the file chooser is in folder mode, this function returns the selected
folder.

# Returns

The currently selected URI, or `None`
 if no file is selected. If `FileChooser::set_local_only` is set to
 `true` (the default) a local URI will be returned for any FUSE locations.
 Free with `g_free`
<!-- trait FileChooserExt::fn get_uris -->
Lists all the selected files and subfolders in the current folder of
`self`. The returned names are full absolute URIs.

# Returns

a `glib::SList` containing the URIs of all selected
 files and subfolders in the current folder. Free the returned list
 with `glib::SList::free`, and the filenames with `g_free`.
<!-- trait FileChooserExt::fn get_use_preview_label -->
Gets whether a stock label should be drawn with the name of the previewed
file. See `FileChooser::set_use_preview_label`.

# Returns

`true` if the file chooser is set to display a label with the
name of the previewed file, `false` otherwise.
<!-- trait FileChooserExt::fn list_filters -->
Lists the current set of user-selectable filters; see
`FileChooser::add_filter`, `FileChooser::remove_filter`.

# Returns

a
 `glib::SList` containing the current set of user selectable filters. The
 contents of the list are owned by GTK+, but you must free the list
 itself with `glib::SList::free` when you are done with it.
<!-- trait FileChooserExt::fn list_shortcut_folder_uris -->
Queries the list of shortcut folders in the file chooser, as set by
`FileChooser::add_shortcut_folder_uri`.

# Returns

A list of
folder URIs, or `None` if there are no shortcut folders. Free the
returned list with `glib::SList::free`, and the URIs with `g_free`.
<!-- trait FileChooserExt::fn list_shortcut_folders -->
Queries the list of shortcut folders in the file chooser, as set by
`FileChooser::add_shortcut_folder`.

# Returns

A list
of folder filenames, or `None` if there are no shortcut folders.
Free the returned list with `glib::SList::free`, and the filenames with
`g_free`.
<!-- trait FileChooserExt::fn remove_choice -->
Removes a 'choice' that has been added with `FileChooser::add_choice`.

Feature: `v3_22`

## `id`
the ID of the choice to remove
<!-- trait FileChooserExt::fn remove_filter -->
Removes `filter` from the list of filters that the user can select between.
## `filter`
a `FileFilter`
<!-- trait FileChooserExt::fn remove_shortcut_folder -->
Removes a folder from a file chooser’s list of shortcut folders.
## `folder`
filename of the folder to remove

# Returns

`true` if the operation succeeds, `false` otherwise.
In the latter case, the `error` will be set as appropriate.

See also: `FileChooser::add_shortcut_folder`
<!-- trait FileChooserExt::fn remove_shortcut_folder_uri -->
Removes a folder URI from a file chooser’s list of shortcut folders.
## `uri`
URI of the folder to remove

# Returns

`true` if the operation succeeds, `false` otherwise.
In the latter case, the `error` will be set as appropriate.

See also: `FileChooser::add_shortcut_folder_uri`
<!-- trait FileChooserExt::fn select_all -->
Selects all the files in the current folder of a file chooser.
<!-- trait FileChooserExt::fn select_file -->
Selects the file referred to by `file`. An internal function. See
`_gtk_file_chooser_select_uri`.
## `file`
the file to select

# Returns

Not useful.
<!-- trait FileChooserExt::fn select_filename -->
Selects a filename. If the file name isn’t in the current
folder of `self`, then the current folder of `self` will
be changed to the folder containing `filename`.
## `filename`
the filename to select

# Returns

Not useful.

See also: `FileChooser::set_filename`
<!-- trait FileChooserExt::fn select_uri -->
Selects the file to by `uri`. If the URI doesn’t refer to a
file in the current folder of `self`, then the current folder of
`self` will be changed to the folder containing `filename`.
## `uri`
the URI to select

# Returns

Not useful.
<!-- trait FileChooserExt::fn set_action -->
Sets the type of operation that the chooser is performing; the
user interface is adapted to suit the selected action. For example,
an option to create a new folder might be shown if the action is
`FileChooserAction::Save` but not if the action is
`FileChooserAction::Open`.
## `action`
the action that the file selector is performing
<!-- trait FileChooserExt::fn set_choice -->
Selects an option in a 'choice' that has been added with
`FileChooser::add_choice`. For a boolean choice, the
possible options are "true" and "false".

Feature: `v3_22`

## `id`
the ID of the choice to set
## `option`
the ID of the option to select
<!-- trait FileChooserExt::fn set_create_folders -->
Sets whether file choser will offer to create new folders.
This is only relevant if the action is not set to be
`FileChooserAction::Open`.
## `create_folders`
`true` if the Create Folder button should be displayed
<!-- trait FileChooserExt::fn set_current_folder -->
Sets the current folder for `self` from a local filename.
The user will be shown the full contents of the current folder,
plus user interface elements for navigating to other folders.

In general, you should not use this function. See the
[section on setting up a file chooser dialog][gtkfilechooserdialog-setting-up]
for the rationale behind this.
## `filename`
the full path of the new current folder

# Returns

Not useful.
<!-- trait FileChooserExt::fn set_current_folder_file -->
Sets the current folder for `self` from a `gio::File`.
Internal function, see `FileChooser::set_current_folder_uri`.
## `file`
the `gio::File` for the new folder

# Returns

`true` if the folder could be changed successfully, `false`
otherwise.
<!-- trait FileChooserExt::fn set_current_folder_uri -->
Sets the current folder for `self` from an URI.
The user will be shown the full contents of the current folder,
plus user interface elements for navigating to other folders.

In general, you should not use this function. See the
[section on setting up a file chooser dialog][gtkfilechooserdialog-setting-up]
for the rationale behind this.
## `uri`
the URI for the new current folder

# Returns

`true` if the folder could be changed successfully, `false`
otherwise.
<!-- trait FileChooserExt::fn set_current_name -->
Sets the current name in the file selector, as if entered
by the user. Note that the name passed in here is a UTF-8
string rather than a filename. This function is meant for
such uses as a suggested name in a “Save As...” dialog. You can
pass “Untitled.doc” or a similarly suitable suggestion for the `name`.

If you want to preselect a particular existing file, you should use
`FileChooser::set_filename` or `FileChooser::set_uri` instead.
Please see the documentation for those functions for an example of using
`FileChooser::set_current_name` as well.
## `name`
the filename to use, as a UTF-8 string
<!-- trait FileChooserExt::fn set_do_overwrite_confirmation -->
Sets whether a file chooser in `FileChooserAction::Save` mode will present
a confirmation dialog if the user types a file name that already exists. This
is `false` by default.

If set to `true`, the `self` will emit the
`FileChooser::confirm-overwrite` signal when appropriate.

If all you need is the stock confirmation dialog, set this property to `true`.
You can override the way confirmation is done by actually handling the
`FileChooser::confirm-overwrite` signal; please refer to its documentation
for the details.
## `do_overwrite_confirmation`
whether to confirm overwriting in save mode
<!-- trait FileChooserExt::fn set_extra_widget -->
Sets an application-supplied widget to provide extra options to the user.
## `extra_widget`
widget for extra options
<!-- trait FileChooserExt::fn set_file -->
Sets `file` as the current filename for the file chooser, by changing
to the file’s parent folder and actually selecting the file in list. If
the `self` is in `FileChooserAction::Save` mode, the file’s base name
will also appear in the dialog’s file name entry.

If the file name isn’t in the current folder of `self`, then the current
folder of `self` will be changed to the folder containing `filename`. This
is equivalent to a sequence of `FileChooser::unselect_all` followed by
`FileChooser::select_filename`.

Note that the file must exist, or nothing will be done except
for the directory change.

If you are implementing a save dialog,
you should use this function if you already have a file name to which the
user may save; for example, when the user opens an existing file and then
does Save As... If you don’t have
a file name already — for example, if the user just created a new
file and is saving it for the first time, do not call this function.
Instead, use something similar to this:

```C
if (document_is_new)
  {
    // the user just created a new document
    gtk_file_chooser_set_current_folder_file (chooser, default_file_for_saving);
    gtk_file_chooser_set_current_name (chooser, "Untitled document");
  }
else
  {
    // the user edited an existing document
    gtk_file_chooser_set_file (chooser, existing_file);
  }
```
## `file`
the `gio::File` to set as current

# Returns

Not useful.
<!-- trait FileChooserExt::fn set_filename -->
Sets `filename` as the current filename for the file chooser, by changing to
the file’s parent folder and actually selecting the file in list; all other
files will be unselected. If the `self` is in
`FileChooserAction::Save` mode, the file’s base name will also appear in
the dialog’s file name entry.

Note that the file must exist, or nothing will be done except
for the directory change.

You should use this function only when implementing a save
dialog for which you already have a file name to which
the user may save. For example, when the user opens an existing file and
then does Save As... to save a copy or
a modified version. If you don’t have a file name already — for
example, if the user just created a new file and is saving it for the first
time, do not call this function. Instead, use something similar to this:

```C
if (document_is_new)
  {
    // the user just created a new document
    gtk_file_chooser_set_current_name (chooser, "Untitled document");
  }
else
  {
    // the user edited an existing document
    gtk_file_chooser_set_filename (chooser, existing_filename);
  }
```

In the first case, the file chooser will present the user with useful suggestions
as to where to save his new file. In the second case, the file’s existing location
is already known, so the file chooser will use it.
## `filename`
the filename to set as current

# Returns

Not useful.
<!-- trait FileChooserExt::fn set_filter -->
Sets the current filter; only the files that pass the
filter will be displayed. If the user-selectable list of filters
is non-empty, then the filter should be one of the filters
in that list. Setting the current filter when the list of
filters is empty is useful if you want to restrict the displayed
set of files without letting the user change it.
## `filter`
a `FileFilter`
<!-- trait FileChooserExt::fn set_local_only -->
Sets whether only local files can be selected in the
file selector. If `local_only` is `true` (the default),
then the selected file or files are guaranteed to be
accessible through the operating systems native file
system and therefore the application only
needs to worry about the filename functions in
`FileChooser`, like `FileChooser::get_filename`,
rather than the URI functions like
`FileChooser::get_uri`,

On some systems non-native files may still be
available using the native filesystem via a userspace
filesystem (FUSE).
## `local_only`
`true` if only local files can be selected
<!-- trait FileChooserExt::fn set_preview_widget -->
Sets an application-supplied widget to use to display a custom preview
of the currently selected file. To implement a preview, after setting the
preview widget, you connect to the `FileChooser::update-preview`
signal, and call `FileChooser::get_preview_filename` or
`FileChooser::get_preview_uri` on each change. If you can
display a preview of the new file, update your widget and
set the preview active using `FileChooser::set_preview_widget_active`.
Otherwise, set the preview inactive.

When there is no application-supplied preview widget, or the
application-supplied preview widget is not active, the file chooser
will display no preview at all.
## `preview_widget`
widget for displaying preview.
<!-- trait FileChooserExt::fn set_preview_widget_active -->
Sets whether the preview widget set by
`FileChooser::set_preview_widget` should be shown for the
current filename. When `active` is set to false, the file chooser
may display an internally generated preview of the current file
or it may display no preview at all. See
`FileChooser::set_preview_widget` for more details.
## `active`
whether to display the user-specified preview widget
<!-- trait FileChooserExt::fn set_select_multiple -->
Sets whether multiple files can be selected in the file selector. This is
only relevant if the action is set to be `FileChooserAction::Open` or
`FileChooserAction::SelectFolder`.
## `select_multiple`
`true` if multiple files can be selected.
<!-- trait FileChooserExt::fn set_show_hidden -->
Sets whether hidden files and folders are displayed in the file selector.
## `show_hidden`
`true` if hidden files and folders should be displayed.
<!-- trait FileChooserExt::fn set_uri -->
Sets the file referred to by `uri` as the current file for the file chooser,
by changing to the URI’s parent folder and actually selecting the URI in the
list. If the `self` is `FileChooserAction::Save` mode, the URI’s base
name will also appear in the dialog’s file name entry.

Note that the URI must exist, or nothing will be done except for the
directory change.

You should use this function only when implementing a save
dialog for which you already have a file name to which
the user may save. For example, when the user opens an existing file and then
does Save As... to save a copy or a
modified version. If you don’t have a file name already — for example,
if the user just created a new file and is saving it for the first time, do
not call this function. Instead, use something similar to this:

```C
if (document_is_new)
  {
    // the user just created a new document
    gtk_file_chooser_set_current_name (chooser, "Untitled document");
  }
else
  {
    // the user edited an existing document
    gtk_file_chooser_set_uri (chooser, existing_uri);
  }
```


In the first case, the file chooser will present the user with useful suggestions
as to where to save his new file. In the second case, the file’s existing location
is already known, so the file chooser will use it.
## `uri`
the URI to set as current

# Returns

Not useful.
<!-- trait FileChooserExt::fn set_use_preview_label -->
Sets whether the file chooser should display a stock label with the name of
the file that is being previewed; the default is `true`. Applications that
want to draw the whole preview area themselves should set this to `false` and
display the name themselves in their preview widget.

See also: `FileChooser::set_preview_widget`
## `use_label`
whether to display a stock label with the name of the previewed file
<!-- trait FileChooserExt::fn unselect_all -->
Unselects all the files in the current folder of a file chooser.
<!-- trait FileChooserExt::fn unselect_file -->
Unselects the file referred to by `file`. If the file is not in the current
directory, does not exist, or is otherwise not currently selected, does nothing.
## `file`
a `gio::File`
<!-- trait FileChooserExt::fn unselect_filename -->
Unselects a currently selected filename. If the filename
is not in the current directory, does not exist, or
is otherwise not currently selected, does nothing.
## `filename`
the filename to unselect
<!-- trait FileChooserExt::fn unselect_uri -->
Unselects the file referred to by `uri`. If the file
is not in the current directory, does not exist, or
is otherwise not currently selected, does nothing.
## `uri`
the URI to unselect
<!-- trait FileChooserExt::fn connect_confirm_overwrite -->
This signal gets emitted whenever it is appropriate to present a
confirmation dialog when the user has selected a file name that
already exists. The signal only gets emitted when the file
chooser is in `FileChooserAction::Save` mode.

Most applications just need to turn on the
`FileChooser:do-overwrite-confirmation` property (or call the
`FileChooser::set_do_overwrite_confirmation` function), and
they will automatically get a stock confirmation dialog.
Applications which need to customize this behavior should do
that, and also connect to the `FileChooser::confirm-overwrite`
signal.

A signal handler for this signal must return a
`FileChooserConfirmation` value, which indicates the action to
take. If the handler determines that the user wants to select a
different filename, it should return
`FileChooserConfirmation::SelectAgain`. If it determines
that the user is satisfied with his choice of file name, it
should return `FileChooserConfirmation::AcceptFilename`.
On the other hand, if it determines that the stock confirmation
dialog should be used, it should return
`FileChooserConfirmation::Confirm`. The following example
illustrates this.

## Custom confirmation ## {`gtkfilechooser`-confirmation}


```C
static GtkFileChooserConfirmation
confirm_overwrite_callback (GtkFileChooser *chooser, gpointer data)
{
  char *uri;

  uri = gtk_file_chooser_get_uri (chooser);

  if (is_uri_read_only (uri))
    {
      if (user_wants_to_replace_read_only_file (uri))
        return GTK_FILE_CHOOSER_CONFIRMATION_ACCEPT_FILENAME;
      else
        return GTK_FILE_CHOOSER_CONFIRMATION_SELECT_AGAIN;
    } else
      return GTK_FILE_CHOOSER_CONFIRMATION_CONFIRM; // fall back to the default dialog
}

...

chooser = gtk_file_chooser_dialog_new (...);

gtk_file_chooser_set_do_overwrite_confirmation (GTK_FILE_CHOOSER (dialog), TRUE);
g_signal_connect (chooser, "confirm-overwrite",
                  G_CALLBACK (confirm_overwrite_callback), NULL);

if (gtk_dialog_run (chooser) == GTK_RESPONSE_ACCEPT)
        save_to_file (gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (chooser));

gtk_widget_destroy (chooser);
```

# Returns

a `FileChooserConfirmation` value that indicates which
 action to take after emitting the signal.
<!-- trait FileChooserExt::fn connect_current_folder_changed -->
This signal is emitted when the current folder in a `FileChooser`
changes. This can happen due to the user performing some action that
changes folders, such as selecting a bookmark or visiting a folder on the
file list. It can also happen as a result of calling a function to
explicitly change the current folder in a file chooser.

Normally you do not need to connect to this signal, unless you need to keep
track of which folder a file chooser is showing.

See also: `FileChooser::set_current_folder`,
`FileChooser::get_current_folder`,
`FileChooser::set_current_folder_uri`,
`FileChooser::get_current_folder_uri`.
<!-- trait FileChooserExt::fn connect_file_activated -->
This signal is emitted when the user "activates" a file in the file
chooser. This can happen by double-clicking on a file in the file list, or
by pressing `Enter`.

Normally you do not need to connect to this signal. It is used internally
by `FileChooserDialog` to know when to activate the default button in the
dialog.

See also: `FileChooser::get_filename`,
`FileChooser::get_filenames`, `FileChooser::get_uri`,
`FileChooser::get_uris`.
<!-- trait FileChooserExt::fn connect_selection_changed -->
This signal is emitted when there is a change in the set of selected files
in a `FileChooser`. This can happen when the user modifies the selection
with the mouse or the keyboard, or when explicitly calling functions to
change the selection.

Normally you do not need to connect to this signal, as it is easier to wait
for the file chooser to finish running, and then to get the list of
selected files using the functions mentioned below.

See also: `FileChooser::select_filename`,
`FileChooser::unselect_filename`, `FileChooser::get_filename`,
`FileChooser::get_filenames`, `FileChooser::select_uri`,
`FileChooser::unselect_uri`, `FileChooser::get_uri`,
`FileChooser::get_uris`.
<!-- trait FileChooserExt::fn connect_update_preview -->
This signal is emitted when the preview in a file chooser should be
regenerated. For example, this can happen when the currently selected file
changes. You should use this signal if you want your file chooser to have
a preview widget.

Once you have installed a preview widget with
`FileChooser::set_preview_widget`, you should update it when this
signal is emitted. You can use the functions
`FileChooser::get_preview_filename` or
`FileChooser::get_preview_uri` to get the name of the file to preview.
Your widget may not be able to preview all kinds of files; your callback
must call `FileChooser::set_preview_widget_active` to inform the file
chooser about whether the preview was generated successfully or not.

Please see the example code in
[Using a Preview Widget][gtkfilechooser-preview].

See also: `FileChooser::set_preview_widget`,
`FileChooser::set_preview_widget_active`,
`FileChooser::set_use_preview_label`,
`FileChooser::get_preview_filename`,
`FileChooser::get_preview_uri`.
<!-- trait FileChooserExt::fn get_property_create-folders -->
Whether a file chooser not in `FileChooserAction::Open` mode
will offer the user to create new folders.
<!-- trait FileChooserExt::fn set_property_create-folders -->
Whether a file chooser not in `FileChooserAction::Open` mode
will offer the user to create new folders.
<!-- trait FileChooserExt::fn get_property_do-overwrite-confirmation -->
Whether a file chooser in `FileChooserAction::Save` mode
will present an overwrite confirmation dialog if the user
selects a file name that already exists.
<!-- trait FileChooserExt::fn set_property_do-overwrite-confirmation -->
Whether a file chooser in `FileChooserAction::Save` mode
will present an overwrite confirmation dialog if the user
selects a file name that already exists.
<!-- enum FileChooserAction -->
Describes whether a `FileChooser` is being used to open existing files
or to save to a possibly new file.
<!-- enum FileChooserAction::variant Open -->
Indicates open mode. The file chooser
 will only let the user pick an existing file.
<!-- enum FileChooserAction::variant Save -->
Indicates save mode. The file chooser
 will let the user pick an existing file, or type in a new
 filename.
<!-- enum FileChooserAction::variant SelectFolder -->
Indicates an Open mode for
 selecting folders. The file chooser will let the user pick an
 existing folder.
<!-- enum FileChooserAction::variant CreateFolder -->
Indicates a mode for creating a
 new folder. The file chooser will let the user name an existing or
 new folder.
<!-- struct FileChooserButton -->
The `FileChooserButton` is a widget that lets the user select a
file. It implements the `FileChooser` interface. Visually, it is a
file name with a button to bring up a `FileChooserDialog`.
The user can then use that dialog to change the file associated with
that button. This widget does not support setting the
`FileChooser:select-multiple` property to `true`.

## Create a button to let the user select a file in /etc


```C
{
  GtkWidget *button;

  button = gtk_file_chooser_button_new (_("Select a file"),
                                        GTK_FILE_CHOOSER_ACTION_OPEN);
  gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (button),
                                       "/etc");
}
```

The `FileChooserButton` supports the ``GtkFileChooserActions``
`FileChooserAction::Open` and `FileChooserAction::SelectFolder`.

> The `FileChooserButton` will ellipsize the label, and will thus
> request little horizontal space. To give the button more space,
> you should call `WidgetExt::get_preferred_size`,
> `FileChooserButtonExt::set_width_chars`, or pack the button in
> such a way that other interface elements give space to the
> widget.

# Implements

[`FileChooserButtonExt`](trait.FileChooserButtonExt.html), [`BoxExt`](trait.BoxExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`OrientableExt`](trait.OrientableExt.html), [`FileChooserExt`](trait.FileChooserExt.html)
<!-- trait FileChooserButtonExt -->
Trait containing all `FileChooserButton` methods.

# Implementors

[`FileChooserButton`](struct.FileChooserButton.html)
<!-- impl FileChooserButton::fn new -->
Creates a new file-selecting button widget.
## `title`
the title of the browse dialog.
## `action`
the open mode for the widget.

# Returns

a new button widget.
<!-- impl FileChooserButton::fn new_with_dialog -->
Creates a `FileChooserButton` widget which uses `dialog` as its
file-picking window.

Note that `dialog` must be a `Dialog` (or subclass) which
implements the `FileChooser` interface and must not have
`DialogFlags::DestroyWithParent` set.

Also note that the dialog needs to have its confirmative button
added with response `ResponseType::Accept` or `ResponseType::Ok` in
order for the button to take over the file selected in the dialog.
## `dialog`
the widget to use as dialog

# Returns

a new button widget.
<!-- trait FileChooserButtonExt::fn get_focus_on_click -->
Returns whether the button grabs focus when it is clicked with the mouse.
See `FileChooserButtonExt::set_focus_on_click`.

# Deprecated since 3.20

Use `WidgetExt::get_focus_on_click` instead

# Returns

`true` if the button grabs focus when it is clicked with
 the mouse.
<!-- trait FileChooserButtonExt::fn get_title -->
Retrieves the title of the browse dialog used by `self`. The returned value
should not be modified or freed.

# Returns

a pointer to the browse dialog’s title.
<!-- trait FileChooserButtonExt::fn get_width_chars -->
Retrieves the width in characters of the `self` widget’s entry and/or label.

# Returns

an integer width (in characters) that the button will use to size itself.
<!-- trait FileChooserButtonExt::fn set_focus_on_click -->
Sets whether the button will grab focus when it is clicked with the mouse.
Making mouse clicks not grab focus is useful in places like toolbars where
you don’t want the keyboard focus removed from the main area of the
application.

# Deprecated since 3.20

Use `WidgetExt::set_focus_on_click` instead
## `focus_on_click`
whether the button grabs focus when clicked with the mouse
<!-- trait FileChooserButtonExt::fn set_title -->
Modifies the `title` of the browse dialog used by `self`.
## `title`
the new browse dialog title.
<!-- trait FileChooserButtonExt::fn set_width_chars -->
Sets the width (in characters) that `self` will use to `n_chars`.
## `n_chars`
the new width, in characters.
<!-- trait FileChooserButtonExt::fn connect_file_set -->
The ::file-set signal is emitted when the user selects a file.

Note that this signal is only emitted when the user
changes the file.
<!-- trait FileChooserButtonExt::fn set_property_dialog -->
Instance of the `FileChooserDialog` associated with the button.
<!-- trait FileChooserButtonExt::fn get_property_title -->
Title to put on the `FileChooserDialog` associated with the button.
<!-- trait FileChooserButtonExt::fn set_property_title -->
Title to put on the `FileChooserDialog` associated with the button.
<!-- trait FileChooserButtonExt::fn get_property_width-chars -->
The width of the entry and label inside the button, in characters.
<!-- trait FileChooserButtonExt::fn set_property_width-chars -->
The width of the entry and label inside the button, in characters.
<!-- enum FileChooserConfirmation -->
Used as a return value of handlers for the
`FileChooser::confirm-overwrite` signal of a `FileChooser`. This
value determines whether the file chooser will present the stock
confirmation dialog, accept the user’s choice of a filename, or
let the user choose another filename.
<!-- enum FileChooserConfirmation::variant Confirm -->
The file chooser will present
 its stock dialog to confirm about overwriting an existing file.
<!-- enum FileChooserConfirmation::variant AcceptFilename -->
The file chooser will
 terminate and accept the user’s choice of a file name.
<!-- enum FileChooserConfirmation::variant SelectAgain -->
The file chooser will
 continue running, so as to let the user select another file name.
<!-- struct FileChooserDialog -->
`FileChooserDialog` is a dialog box suitable for use with
“File/Open” or “File/Save as” commands. This widget works by
putting a `FileChooserWidget` inside a `Dialog`. It exposes
the `FileChooser` interface, so you can use all of the
`FileChooser` functions on the file chooser dialog as well as
those for `Dialog`.

Note that `FileChooserDialog` does not have any methods of its
own. Instead, you should use the functions that work on a
`FileChooser`.

If you want to integrate well with the platform you should use the
`FileChooserNative` API, which will use a platform-specific
dialog if available and fall back to `FileChooserDialog`
otherwise.

## Typical usage ## {`gtkfilechooser`-typical-usage}

In the simplest of cases, you can the following code to use
`FileChooserDialog` to select a file for opening:


```text
GtkWidget *dialog;
GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_OPEN;
gint res;

dialog = gtk_file_chooser_dialog_new ("Open File",
                                      parent_window,
                                      action,
                                      _("_Cancel"),
                                      GTK_RESPONSE_CANCEL,
                                      _("_Open"),
                                      GTK_RESPONSE_ACCEPT,
                                      NULL);

res = gtk_dialog_run (GTK_DIALOG (dialog));
if (res == GTK_RESPONSE_ACCEPT)
  {
    char *filename;
    GtkFileChooser *chooser = GTK_FILE_CHOOSER (dialog);
    filename = gtk_file_chooser_get_filename (chooser);
    open_file (filename);
    g_free (filename);
  }

gtk_widget_destroy (dialog);
```

To use a dialog for saving, you can use this:


```text
GtkWidget *dialog;
GtkFileChooser *chooser;
GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_SAVE;
gint res;

dialog = gtk_file_chooser_dialog_new ("Save File",
                                      parent_window,
                                      action,
                                      _("_Cancel"),
                                      GTK_RESPONSE_CANCEL,
                                      _("_Save"),
                                      GTK_RESPONSE_ACCEPT,
                                      NULL);
chooser = GTK_FILE_CHOOSER (dialog);

gtk_file_chooser_set_do_overwrite_confirmation (chooser, TRUE);

if (user_edited_a_new_document)
  gtk_file_chooser_set_current_name (chooser,
                                     _("Untitled document"));
else
  gtk_file_chooser_set_filename (chooser,
                                 existing_filename);

res = gtk_dialog_run (GTK_DIALOG (dialog));
if (res == GTK_RESPONSE_ACCEPT)
  {
    char *filename;

    filename = gtk_file_chooser_get_filename (chooser);
    save_to_file (filename);
    g_free (filename);
  }

gtk_widget_destroy (dialog);
```

## Setting up a file chooser dialog ## {`gtkfilechooserdialog`-setting-up}

There are various cases in which you may need to use a `FileChooserDialog`:

- To select a file for opening. Use `FileChooserAction::Open`.

- To save a file for the first time. Use `FileChooserAction::Save`,
 and suggest a name such as “Untitled” with `FileChooser::set_current_name`.

- To save a file under a different name. Use `FileChooserAction::Save`,
 and set the existing filename with `FileChooser::set_filename`.

- To choose a folder instead of a file. Use `FileChooserAction::SelectFolder`.

Note that old versions of the file chooser’s documentation suggested
using `FileChooser::set_current_folder` in various
situations, with the intention of letting the application
suggest a reasonable default folder. This is no longer
considered to be a good policy, as now the file chooser is
able to make good suggestions on its own. In general, you
should only cause the file chooser to show a specific folder
when it is appropriate to use `FileChooser::set_filename`,
i.e. when you are doing a Save As command and you already
have a file saved somewhere.

## Response Codes ## {`gtkfilechooserdialog`-responses}

`FileChooserDialog` inherits from `Dialog`, so buttons that
go in its action area have response codes such as
`ResponseType::Accept` and `ResponseType::Cancel`. For example, you
could call `FileChooserDialog::new` as follows:


```text
GtkWidget *dialog;
GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_OPEN;

dialog = gtk_file_chooser_dialog_new ("Open File",
                                      parent_window,
                                      action,
                                      _("_Cancel"),
                                      GTK_RESPONSE_CANCEL,
                                      _("_Open"),
                                      GTK_RESPONSE_ACCEPT,
                                      NULL);
```

This will create buttons for “Cancel” and “Open” that use stock
response identifiers from `ResponseType`. For most dialog
boxes you can use your own custom response codes rather than the
ones in `ResponseType`, but `FileChooserDialog` assumes that
its “accept”-type action, e.g. an “Open” or “Save” button,
will have one of the following response codes:

- `ResponseType::Accept`
- `ResponseType::Ok`
- `ResponseType::Yes`
- `ResponseType::Apply`

This is because `FileChooserDialog` must intercept responses
and switch to folders if appropriate, rather than letting the
dialog terminate — the implementation uses these known
response codes to know which responses can be blocked if
appropriate.

To summarize, make sure you use a
[stock response code][gtkfilechooserdialog-responses]
when you use `FileChooserDialog` to ensure proper operation.

# Implements

[`DialogExt`](trait.DialogExt.html), [`GtkWindowExt`](trait.GtkWindowExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`FileChooserExt`](trait.FileChooserExt.html)
<!-- impl FileChooserDialog::fn new -->
Creates a new `FileChooserDialog`. This function is analogous to
`Dialog::new_with_buttons`.
## `title`
Title of the dialog, or `None`
## `parent`
Transient parent of the dialog, or `None`
## `action`
Open or save mode for the dialog
## `first_button_text`
stock ID or text to go in the first button, or `None`

# Returns

a new `FileChooserDialog`
<!-- enum FileChooserError -->
These identify the various errors that can occur while calling
`FileChooser` functions.
<!-- enum FileChooserError::variant Nonexistent -->
Indicates that a file does not exist.
<!-- enum FileChooserError::variant BadFilename -->
Indicates a malformed filename.
<!-- enum FileChooserError::variant AlreadyExists -->
Indicates a duplicate path (e.g. when
 adding a bookmark).
<!-- enum FileChooserError::variant IncompleteHostname -->
Indicates an incomplete hostname (e.g. "http://foo" without a slash after that).
<!-- struct FileChooserWidget -->
`FileChooserWidget` is a widget for choosing files.
It exposes the `FileChooser` interface, and you should
use the methods of this interface to interact with the
widget.

# CSS nodes

`FileChooserWidget` has a single CSS node with name filechooser.

# Implements

[`FileChooserWidgetExt`](trait.FileChooserWidgetExt.html), [`BoxExt`](trait.BoxExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`OrientableExt`](trait.OrientableExt.html), [`FileChooserExt`](trait.FileChooserExt.html)
<!-- trait FileChooserWidgetExt -->
Trait containing all `FileChooserWidget` methods.

# Implementors

[`FileChooserWidget`](struct.FileChooserWidget.html)
<!-- impl FileChooserWidget::fn new -->
Creates a new `FileChooserWidget`. This is a file chooser widget that can
be embedded in custom windows, and it is the same widget that is used by
`FileChooserDialog`.
## `action`
Open or save mode for the widget

# Returns

a new `FileChooserWidget`
<!-- trait FileChooserWidgetExt::fn connect_desktop_folder -->
The ::desktop-folder signal is a [keybinding signal][`BindingSignal`]
which gets emitted when the user asks for it.

This is used to make the file chooser show the user's Desktop
folder in the file list.

The default binding for this signal is `Alt + D`.
<!-- trait FileChooserWidgetExt::fn connect_down_folder -->
The ::down-folder signal is a [keybinding signal][`BindingSignal`]
which gets emitted when the user asks for it.

This is used to make the file chooser go to a child of the current folder
in the file hierarchy. The subfolder that will be used is displayed in the
path bar widget of the file chooser. For example, if the path bar is showing
"/foo/bar/baz", with bar currently displayed, then this will cause the file
chooser to switch to the "baz" subfolder.

The default binding for this signal is `Alt + Down`.
<!-- trait FileChooserWidgetExt::fn connect_home_folder -->
The ::home-folder signal is a [keybinding signal][`BindingSignal`]
which gets emitted when the user asks for it.

This is used to make the file chooser show the user's home
folder in the file list.

The default binding for this signal is `Alt + Home`.
<!-- trait FileChooserWidgetExt::fn connect_location_popup -->
The ::location-popup signal is a [keybinding signal][`BindingSignal`]
which gets emitted when the user asks for it.

This is used to make the file chooser show a "Location" prompt which
the user can use to manually type the name of the file he wishes to select.

The default bindings for this signal are `Control + L` with a `path` string
of "" (the empty string). It is also bound to `/` with a `path` string of
"`/`" (a slash): this lets you type `/` and immediately type a path name.
On Unix systems, this is bound to `~` (tilde) with a `path` string of "~"
itself for access to home directories.
## `path`
a string that gets put in the text entry for the file name
<!-- trait FileChooserWidgetExt::fn connect_location_popup_on_paste -->
The ::location-popup-on-paste signal is a [keybinding signal][`BindingSignal`]
which gets emitted when the user asks for it.

This is used to make the file chooser show a "Location" prompt when the user
pastes into a `FileChooserWidget`.

The default binding for this signal is `Control + V`.
<!-- trait FileChooserWidgetExt::fn connect_location_toggle_popup -->
The ::location-toggle-popup signal is a [keybinding signal][`BindingSignal`]
which gets emitted when the user asks for it.

This is used to toggle the visibility of a "Location" prompt which the user
can use to manually type the name of the file he wishes to select.

The default binding for this signal is `Control + L`.
<!-- trait FileChooserWidgetExt::fn connect_places_shortcut -->
The ::places-shortcut signal is a [keybinding signal][`BindingSignal`]
which gets emitted when the user asks for it.

This is used to move the focus to the places sidebar.

The default binding for this signal is `Alt + P`.
<!-- trait FileChooserWidgetExt::fn connect_quick_bookmark -->
The ::quick-bookmark signal is a [keybinding signal][`BindingSignal`]
which gets emitted when the user asks for it.

This is used to make the file chooser switch to the bookmark specified
in the `bookmark_index` parameter. For example, if you have three bookmarks,
you can pass 0, 1, 2 to this signal to switch to each of them, respectively.

The default binding for this signal is `Alt + 1`, `Alt + 2`,
etc. until `Alt + 0`. Note that in the default binding, that
`Alt + 1` is actually defined to switch to the bookmark at index
0, and so on successively; `Alt + 0` is defined to switch to the
bookmark at index 10.
## `bookmark_index`
the number of the bookmark to switch to
<!-- trait FileChooserWidgetExt::fn connect_recent_shortcut -->
The ::recent-shortcut signal is a [keybinding signal][`BindingSignal`]
which gets emitted when the user asks for it.

This is used to make the file chooser show the Recent location.

The default binding for this signal is `Alt + R`.
<!-- trait FileChooserWidgetExt::fn connect_search_shortcut -->
The ::search-shortcut signal is a [keybinding signal][`BindingSignal`]
which gets emitted when the user asks for it.

This is used to make the file chooser show the search entry.

The default binding for this signal is `Alt + S`.
<!-- trait FileChooserWidgetExt::fn connect_show_hidden -->
The ::show-hidden signal is a [keybinding signal][`BindingSignal`]
which gets emitted when the user asks for it.

This is used to make the file chooser display hidden files.

The default binding for this signal is `Control + H`.
<!-- trait FileChooserWidgetExt::fn connect_up_folder -->
The ::up-folder signal is a [keybinding signal][`BindingSignal`]
which gets emitted when the user asks for it.

This is used to make the file chooser go to the parent of the current folder
in the file hierarchy.

The default binding for this signal is `Alt + Up`.
<!-- struct FileFilter -->
A `FileFilter` can be used to restrict the files being shown in a
`FileChooser`. Files can be filtered based on their name (with
`FileFilterExt::add_pattern`), on their mime type (with
`FileFilterExt::add_mime_type`), or by a custom filter function
(with `FileFilterExt::add_custom`).

Filtering by mime types handles aliasing and subclassing of mime
types; e.g. a filter for text/plain also matches a file with mime
type application/rtf, since application/rtf is a subclass of
text/plain. Note that `FileFilter` allows wildcards for the
subtype of a mime type, so you can e.g. filter for image/\*.

Normally, filters are used by adding them to a `FileChooser`,
see `FileChooser::add_filter`, but it is also possible
to manually use a filter on a file with `FileFilterExt::filter`.

# `FileFilter` as `Buildable`

The `FileFilter` implementation of the `Buildable` interface
supports adding rules using the `<mime-types>`, `<patterns>` and
`<applications>` elements and listing the rules within. Specifying
a `<mime-type>` or `<pattern>` has the same effect as as calling
`FileFilterExt::add_mime_type` or `FileFilterExt::add_pattern`.

An example of a UI definition fragment specifying `FileFilter`
rules:

```text
<object class="GtkFileFilter">
  <mime-types>
    <mime-type>text/plain</mime-type>
    <mime-type>image/ *</mime-type>
  </mime-types>
  <patterns>
    <pattern>*.txt</pattern>
    <pattern>*.png</pattern>
  </patterns>
</object>
```

# Implements

[`FileFilterExt`](trait.FileFilterExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait FileFilterExt -->
Trait containing all `FileFilter` methods.

# Implementors

[`FileFilter`](struct.FileFilter.html)
<!-- impl FileFilter::fn new -->
Creates a new `FileFilter` with no rules added to it.
Such a filter doesn’t accept any files, so is not
particularly useful until you add rules with
`FileFilterExt::add_mime_type`, `FileFilterExt::add_pattern`,
or `FileFilterExt::add_custom`. To create a filter
that accepts any file, use:

```C
GtkFileFilter *filter = gtk_file_filter_new ();
gtk_file_filter_add_pattern (filter, "*");
```

# Returns

a new `FileFilter`
<!-- impl FileFilter::fn new_from_gvariant -->
Deserialize a file filter from an a{sv} variant in
the format produced by `FileFilterExt::to_gvariant`.

Feature: `v3_22`

## `variant`
an a{sv} `glib::Variant`

# Returns

a new `FileFilter` object
<!-- trait FileFilterExt::fn add_custom -->
Adds rule to a filter that allows files based on a custom callback
function. The bitfield `needed` which is passed in provides information
about what sorts of information that the filter function needs;
this allows GTK+ to avoid retrieving expensive information when
it isn’t needed by the filter.
## `needed`
bitfield of flags indicating the information that the custom
 filter function needs.
## `func`
callback function; if the function returns `true`, then
 the file will be displayed.
## `data`
data to pass to `func`
## `notify`
function to call to free `data` when it is no longer needed.
<!-- trait FileFilterExt::fn add_mime_type -->
Adds a rule allowing a given mime type to `self`.
## `mime_type`
name of a MIME type
<!-- trait FileFilterExt::fn add_pattern -->
Adds a rule allowing a shell style glob to a filter.
## `pattern`
a shell style glob
<!-- trait FileFilterExt::fn add_pixbuf_formats -->
Adds a rule allowing image files in the formats supported
by `gdk_pixbuf::Pixbuf`.
<!-- trait FileFilterExt::fn filter -->
Tests whether a file should be displayed according to `self`.
The `FileFilterInfo` `filter_info` should include
the fields returned from `FileFilterExt::get_needed`.

This function will not typically be used by applications; it
is intended principally for use in the implementation of
`FileChooser`.
## `filter_info`
a `FileFilterInfo` containing information
 about a file.

# Returns

`true` if the file should be displayed
<!-- trait FileFilterExt::fn get_name -->
Gets the human-readable name for the filter. See `FileFilterExt::set_name`.

# Returns

The human-readable name of the filter,
 or `None`. This value is owned by GTK+ and must not
 be modified or freed.
<!-- trait FileFilterExt::fn get_needed -->
Gets the fields that need to be filled in for the `FileFilterInfo`
passed to `FileFilterExt::filter`

This function will not typically be used by applications; it
is intended principally for use in the implementation of
`FileChooser`.

# Returns

bitfield of flags indicating needed fields when
 calling `FileFilterExt::filter`
<!-- trait FileFilterExt::fn set_name -->
Sets the human-readable name of the filter; this is the string
that will be displayed in the file selector user interface if
there is a selectable list of filters.
## `name`
the human-readable-name for the filter, or `None`
 to remove any existing name.
<!-- trait FileFilterExt::fn to_gvariant -->
Serialize a file filter to an a{sv} variant.

Feature: `v3_22`


# Returns

a new, floating, `glib::Variant`
<!-- struct Fixed -->
The `Fixed` widget is a container which can place child widgets
at fixed positions and with fixed sizes, given in pixels. `Fixed`
performs no automatic layout management.

For most applications, you should not use this container! It keeps
you from having to learn about the other GTK+ containers, but it
results in broken applications. With `Fixed`, the following
things will result in truncated text, overlapping widgets, and
other display bugs:

- Themes, which may change widget sizes.

- Fonts other than the one you used to write the app will of course
 change the size of widgets containing text; keep in mind that
 users may use a larger font because of difficulty reading the
 default, or they may be using a different OS that provides different fonts.

- Translation of text into other languages changes its size. Also,
 display of non-English text will use a different font in many
 cases.

In addition, `Fixed` does not pay attention to text direction and thus may
produce unwanted results if your app is run under right-to-left languages
such as Hebrew or Arabic. That is: normally GTK+ will order containers
appropriately for the text direction, e.g. to put labels to the right of the
thing they label when using an RTL language, but it can’t do that with
`Fixed`. So if you need to reorder widgets depending on the text direction,
you would need to manually detect it and adjust child positions accordingly.

Finally, fixed positioning makes it kind of annoying to add/remove
GUI elements, since you have to reposition all the other
elements. This is a long-term maintenance problem for your
application.

If you know none of these things are an issue for your application,
and prefer the simplicity of `Fixed`, by all means use the
widget. But you should be aware of the tradeoffs.

See also `Layout`, which shares the ability to perform fixed positioning
of child widgets and additionally adds custom drawing and scrollability.

# Implements

[`FixedExt`](trait.FixedExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait FixedExt -->
Trait containing all `Fixed` methods.

# Implementors

[`Fixed`](struct.Fixed.html)
<!-- impl Fixed::fn new -->
Creates a new `Fixed`.

# Returns

a new `Fixed`.
<!-- trait FixedExt::fn move -->
Moves a child of a `Fixed` container to the given position.
## `widget`
the child widget.
## `x`
the horizontal position to move the widget to.
## `y`
the vertical position to move the widget to.
<!-- trait FixedExt::fn put -->
Adds a widget to a `Fixed` container at the given position.
## `widget`
the widget to add.
## `x`
the horizontal position to place the widget at.
## `y`
the vertical position to place the widget at.
<!-- struct FlowBox -->
A `FlowBox` positions child widgets in sequence according to its
orientation.

For instance, with the horizontal orientation, the widgets will be
arranged from left to right, starting a new row under the previous
row when necessary. Reducing the width in this case will require more
rows, so a larger height will be requested.

Likewise, with the vertical orientation, the widgets will be arranged
from top to bottom, starting a new column to the right when necessary.
Reducing the height will require more columns, so a larger width will
be requested.

The children of a `FlowBox` can be dynamically sorted and filtered.

Although a `FlowBox` must have only `FlowBoxChild` children,
you can add any kind of widget to it via `ContainerExt::add`, and
a `FlowBoxChild` widget will automatically be inserted between
the box and the widget.

Also see `ListBox`.

`FlowBox` was added in GTK+ 3.12.

# CSS nodes


```plain
flowbox
├── flowboxchild
│   ╰── <child>
├── flowboxchild
│   ╰── <child>
┊
╰── [rubberband]
```

`FlowBox` uses a single CSS node with name flowbox. `FlowBoxChild`
uses a single CSS node with name flowboxchild.
For rubberband selection, a subnode with name rubberband is used.

Feature: `v3_12`

# Implements

[`FlowBoxExt`](trait.FlowBoxExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`OrientableExt`](trait.OrientableExt.html)
<!-- trait FlowBoxExt -->
Trait containing all `FlowBox` methods.

Feature: `v3_12`

# Implementors

[`FlowBox`](struct.FlowBox.html)
<!-- impl FlowBox::fn new -->
Creates a `FlowBox`.

Feature: `v3_12`


# Returns

a new `FlowBox` container
<!-- trait FlowBoxExt::fn bind_model -->
Binds `model` to `self`.

If `self` was already bound to a model, that previous binding is
destroyed.

The contents of `self` are cleared and then filled with widgets that
represent items from `model`. `self` is updated whenever `model` changes.
If `model` is `None`, `self` is left empty.

It is undefined to add or remove widgets directly (for example, with
`FlowBoxExt::insert` or `ContainerExt::add`) while `self` is bound to a
model.

Note that using a model is incompatible with the filtering and sorting
functionality in `FlowBox`. When using a model, filtering and sorting
should be implemented by the model.

Feature: `v3_18`

## `model`
the `gio::ListModel` to be bound to `self`
## `create_widget_func`
a function that creates widgets for items
## `user_data`
user data passed to `create_widget_func`
## `user_data_free_func`
function for freeing `user_data`
<!-- trait FlowBoxExt::fn get_activate_on_single_click -->
Returns whether children activate on single clicks.

Feature: `v3_12`


# Returns

`true` if children are activated on single click,
 `false` otherwise
<!-- trait FlowBoxExt::fn get_child_at_index -->
Gets the nth child in the `self`.

Feature: `v3_12`

## `idx`
the position of the child

# Returns

the child widget, which will
 always be a `FlowBoxChild` or `None` in case no child widget
 with the given index exists.
<!-- trait FlowBoxExt::fn get_child_at_pos -->
Gets the child in the (`x`, `y`) position.

Feature: `v3_22_6`

## `x`
the x coordinate of the child
## `y`
the y coordinate of the child

# Returns

the child widget, which will
 always be a `FlowBoxChild` or `None` in case no child widget
 exists for the given x and y coordinates.
<!-- trait FlowBoxExt::fn get_column_spacing -->
Gets the horizontal spacing.

Feature: `v3_12`


# Returns

the horizontal spacing
<!-- trait FlowBoxExt::fn get_homogeneous -->
Returns whether the box is homogeneous (all children are the
same size). See `BoxExt::set_homogeneous`.

Feature: `v3_12`


# Returns

`true` if the box is homogeneous.
<!-- trait FlowBoxExt::fn get_max_children_per_line -->
Gets the maximum number of children per line.

Feature: `v3_12`


# Returns

the maximum number of children per line
<!-- trait FlowBoxExt::fn get_min_children_per_line -->
Gets the minimum number of children per line.

Feature: `v3_12`


# Returns

the minimum number of children per line
<!-- trait FlowBoxExt::fn get_row_spacing -->
Gets the vertical spacing.

Feature: `v3_12`


# Returns

the vertical spacing
<!-- trait FlowBoxExt::fn get_selected_children -->
Creates a list of all selected children.

Feature: `v3_12`


# Returns


 A `glib::List` containing the `Widget` for each selected child.
 Free with `glib::List::free` when done.
<!-- trait FlowBoxExt::fn get_selection_mode -->
Gets the selection mode of `self`.

Feature: `v3_12`


# Returns

the `SelectionMode`
<!-- trait FlowBoxExt::fn insert -->
Inserts the `widget` into `self` at `position`.

If a sort function is set, the widget will actually be inserted
at the calculated position and this function has the same effect
as `ContainerExt::add`.

If `position` is -1, or larger than the total number of children
in the `self`, then the `widget` will be appended to the end.

Feature: `v3_12`

## `widget`
the `Widget` to add
## `position`
the position to insert `child` in
<!-- trait FlowBoxExt::fn invalidate_filter -->
Updates the filtering for all children.

Call this function when the result of the filter
function on the `self` is changed due ot an external
factor. For instance, this would be used if the
filter function just looked for a specific search
term, and the entry with the string has changed.

Feature: `v3_12`

<!-- trait FlowBoxExt::fn invalidate_sort -->
Updates the sorting for all children.

Call this when the result of the sort function on
`self` is changed due to an external factor.

Feature: `v3_12`

<!-- trait FlowBoxExt::fn select_all -->
Select all children of `self`, if the selection
mode allows it.

Feature: `v3_12`

<!-- trait FlowBoxExt::fn select_child -->
Selects a single child of `self`, if the selection
mode allows it.

Feature: `v3_12`

## `child`
a child of `self`
<!-- trait FlowBoxExt::fn selected_foreach -->
Calls a function for each selected child.

Note that the selection cannot be modified from within
this function.

Feature: `v3_12`

## `func`
the function to call for each selected child
## `data`
user data to pass to the function
<!-- trait FlowBoxExt::fn set_activate_on_single_click -->
If `single` is `true`, children will be activated when you click
on them, otherwise you need to double-click.

Feature: `v3_12`

## `single`
`true` to emit child-activated on a single click
<!-- trait FlowBoxExt::fn set_column_spacing -->
Sets the horizontal space to add between children.
See the `FlowBox:column-spacing` property.

Feature: `v3_12`

## `spacing`
the spacing to use
<!-- trait FlowBoxExt::fn set_filter_func -->
By setting a filter function on the `self` one can decide dynamically
which of the children to show. For instance, to implement a search
function that only shows the children matching the search terms.

The `filter_func` will be called for each child after the call, and
it will continue to be called each time a child changes (via
`FlowBoxChildExt::changed`) or when `FlowBoxExt::invalidate_filter`
is called.

Note that using a filter function is incompatible with using a model
(see `FlowBoxExt::bind_model`).

Feature: `v3_12`

## `filter_func`
callback that
 lets you filter which children to show
## `user_data`
user data passed to `filter_func`
## `destroy`
destroy notifier for `user_data`
<!-- trait FlowBoxExt::fn set_hadjustment -->
Hooks up an adjustment to focus handling in `self`.
The adjustment is also used for autoscrolling during
rubberband selection. See `ScrolledWindowExt::get_hadjustment`
for a typical way of obtaining the adjustment, and
`FlowBoxExt::set_vadjustment`for setting the vertical
adjustment.

The adjustments have to be in pixel units and in the same
coordinate system as the allocation for immediate children
of the box.

Feature: `v3_12`

## `adjustment`
an adjustment which should be adjusted
 when the focus is moved among the descendents of `container`
<!-- trait FlowBoxExt::fn set_homogeneous -->
Sets the `FlowBox:homogeneous` property of `self`, controlling
whether or not all children of `self` are given equal space
in the box.

Feature: `v3_12`

## `homogeneous`
`true` to create equal allotments,
 `false` for variable allotments
<!-- trait FlowBoxExt::fn set_max_children_per_line -->
Sets the maximum number of children to request and
allocate space for in `self`’s orientation.

Setting the maximum number of children per line
limits the overall natural size request to be no more
than `n_children` children long in the given orientation.

Feature: `v3_12`

## `n_children`
the maximum number of children per line
<!-- trait FlowBoxExt::fn set_min_children_per_line -->
Sets the minimum number of children to line up
in `self`’s orientation before flowing.

Feature: `v3_12`

## `n_children`
the minimum number of children per line
<!-- trait FlowBoxExt::fn set_row_spacing -->
Sets the vertical space to add between children.
See the `FlowBox:row-spacing` property.

Feature: `v3_12`

## `spacing`
the spacing to use
<!-- trait FlowBoxExt::fn set_selection_mode -->
Sets how selection works in `self`.
See `SelectionMode` for details.

Feature: `v3_12`

## `mode`
the new selection mode
<!-- trait FlowBoxExt::fn set_sort_func -->
By setting a sort function on the `self`, one can dynamically
reorder the children of the box, based on the contents of
the children.

The `sort_func` will be called for each child after the call,
and will continue to be called each time a child changes (via
`FlowBoxChildExt::changed`) and when `FlowBoxExt::invalidate_sort`
is called.

Note that using a sort function is incompatible with using a model
(see `FlowBoxExt::bind_model`).

Feature: `v3_12`

## `sort_func`
the sort function
## `user_data`
user data passed to `sort_func`
## `destroy`
destroy notifier for `user_data`
<!-- trait FlowBoxExt::fn set_vadjustment -->
Hooks up an adjustment to focus handling in `self`.
The adjustment is also used for autoscrolling during
rubberband selection. See `ScrolledWindowExt::get_vadjustment`
for a typical way of obtaining the adjustment, and
`FlowBoxExt::set_hadjustment`for setting the horizontal
adjustment.

The adjustments have to be in pixel units and in the same
coordinate system as the allocation for immediate children
of the box.

Feature: `v3_12`

## `adjustment`
an adjustment which should be adjusted
 when the focus is moved among the descendents of `container`
<!-- trait FlowBoxExt::fn unselect_all -->
Unselect all children of `self`, if the selection
mode allows it.

Feature: `v3_12`

<!-- trait FlowBoxExt::fn unselect_child -->
Unselects a single child of `self`, if the selection
mode allows it.

Feature: `v3_12`

## `child`
a child of `self`
<!-- trait FlowBoxExt::fn connect_activate_cursor_child -->
The ::activate-cursor-child signal is a
[keybinding signal][`BindingSignal`]
which gets emitted when the user activates the `box_`.
<!-- trait FlowBoxExt::fn connect_child_activated -->
The ::child-activated signal is emitted when a child has been
activated by the user.
## `child`
the child that is activated
<!-- trait FlowBoxExt::fn connect_move_cursor -->
The ::move-cursor signal is a
[keybinding signal][`BindingSignal`]
which gets emitted when the user initiates a cursor movement.

Applications should not connect to it, but may emit it with
`g_signal_emit_by_name` if they need to control the cursor
programmatically.

The default bindings for this signal come in two variants,
the variant with the Shift modifier extends the selection,
the variant without the Shift modifer does not.
There are too many key combinations to list them all here.
- Arrow keys move by individual children
- Home/End keys move to the ends of the box
- PageUp/PageDown keys move vertically by pages
## `step`
the granularity fo the move, as a `MovementStep`
## `count`
the number of `step` units to move

# Returns

`true` to stop other handlers from being invoked for the event.
`false` to propagate the event further.
<!-- trait FlowBoxExt::fn connect_select_all -->
The ::select-all signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to select all children of the box, if
the selection mode permits it.

The default bindings for this signal is Ctrl-a.
<!-- trait FlowBoxExt::fn connect_selected_children_changed -->
The ::selected-children-changed signal is emitted when the
set of selected children changes.

Use `FlowBoxExt::selected_foreach` or
`FlowBoxExt::get_selected_children` to obtain the
selected children.
<!-- trait FlowBoxExt::fn connect_toggle_cursor_child -->
The ::toggle-cursor-child signal is a
[keybinding signal][`BindingSignal`]
which toggles the selection of the child that has the focus.

The default binding for this signal is Ctrl-Space.
<!-- trait FlowBoxExt::fn connect_unselect_all -->
The ::unselect-all signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to unselect all children of the box, if
the selection mode permits it.

The default bindings for this signal is Ctrl-Shift-a.
<!-- trait FlowBoxExt::fn get_property_activate-on-single-click -->
Determines whether children can be activated with a single
click, or require a double-click.
<!-- trait FlowBoxExt::fn set_property_activate-on-single-click -->
Determines whether children can be activated with a single
click, or require a double-click.
<!-- trait FlowBoxExt::fn get_property_column-spacing -->
The amount of horizontal space between two children.
<!-- trait FlowBoxExt::fn set_property_column-spacing -->
The amount of horizontal space between two children.
<!-- trait FlowBoxExt::fn get_property_homogeneous -->
Determines whether all children should be allocated the
same size.
<!-- trait FlowBoxExt::fn set_property_homogeneous -->
Determines whether all children should be allocated the
same size.
<!-- trait FlowBoxExt::fn get_property_max-children-per-line -->
The maximum amount of children to request space for consecutively
in the given orientation.
<!-- trait FlowBoxExt::fn set_property_max-children-per-line -->
The maximum amount of children to request space for consecutively
in the given orientation.
<!-- trait FlowBoxExt::fn get_property_min-children-per-line -->
The minimum number of children to allocate consecutively
in the given orientation.

Setting the minimum children per line ensures
that a reasonably small height will be requested
for the overall minimum width of the box.
<!-- trait FlowBoxExt::fn set_property_min-children-per-line -->
The minimum number of children to allocate consecutively
in the given orientation.

Setting the minimum children per line ensures
that a reasonably small height will be requested
for the overall minimum width of the box.
<!-- trait FlowBoxExt::fn get_property_row-spacing -->
The amount of vertical space between two children.
<!-- trait FlowBoxExt::fn set_property_row-spacing -->
The amount of vertical space between two children.
<!-- trait FlowBoxExt::fn get_property_selection-mode -->
The selection mode used by the flow box.
<!-- trait FlowBoxExt::fn set_property_selection-mode -->
The selection mode used by the flow box.
<!-- struct FlowBoxChild -->


Feature: `v3_12`

# Implements

[`FlowBoxChildExt`](trait.FlowBoxChildExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait FlowBoxChildExt -->
Trait containing all `FlowBoxChild` methods.

Feature: `v3_12`

# Implementors

[`FlowBoxChild`](struct.FlowBoxChild.html)
<!-- impl FlowBoxChild::fn new -->
Creates a new `FlowBoxChild`, to be used as a child
of a `FlowBox`.

Feature: `v3_12`


# Returns

a new `FlowBoxChild`
<!-- trait FlowBoxChildExt::fn changed -->
Marks `self` as changed, causing any state that depends on this
to be updated. This affects sorting and filtering.

Note that calls to this method must be in sync with the data
used for the sorting and filtering functions. For instance, if
the list is mirroring some external data set, and *two* children
changed in the external data set when you call
`FlowBoxChildExt::changed` on the first child, the sort function
must only read the new data for the first of the two changed
children, otherwise the resorting of the children will be wrong.

This generally means that if you don’t fully control the data
model, you have to duplicate the data that affects the sorting
and filtering functions into the widgets themselves. Another
alternative is to call `FlowBoxExt::invalidate_sort` on any
model change, but that is more expensive.

Feature: `v3_12`

<!-- trait FlowBoxChildExt::fn get_index -->
Gets the current index of the `self` in its `FlowBox` container.

Feature: `v3_12`


# Returns

the index of the `self`, or -1 if the `self` is not
 in a flow box.
<!-- trait FlowBoxChildExt::fn is_selected -->
Returns whether the `self` is currently selected in its
`FlowBox` container.

Feature: `v3_12`


# Returns

`true` if `self` is selected
<!-- trait FlowBoxChildExt::fn connect_activate -->
The ::activate signal is emitted when the user activates
a child widget in a `FlowBox`, either by clicking or
double-clicking, or by using the Space or Enter key.

While this signal is used as a
[keybinding signal][`BindingSignal`],
it can be used by applications for their own purposes.
<!-- struct FontButton -->
The `FontButton` is a button which displays the currently selected
font an allows to open a font chooser dialog to change the font.
It is suitable widget for selecting a font in a preference dialog.

# CSS nodes

`FontButton` has a single CSS node with name button and style class .font.

# Implements

[`FontButtonExt`](trait.FontButtonExt.html), [`ButtonExt`](trait.ButtonExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`ActionableExt`](trait.ActionableExt.html), [`FontChooserExt`](trait.FontChooserExt.html)
<!-- trait FontButtonExt -->
Trait containing all `FontButton` methods.

# Implementors

[`FontButton`](struct.FontButton.html)
<!-- impl FontButton::fn new -->
Creates a new font picker widget.

# Returns

a new font picker widget.
<!-- impl FontButton::fn new_with_font -->
Creates a new font picker widget.
## `fontname`
Name of font to display in font chooser dialog

# Returns

a new font picker widget.
<!-- trait FontButtonExt::fn get_font_name -->
Retrieves the name of the currently selected font. This name includes
style and size information as well. If you want to render something
with the font, use this string with `pango::FontDescription::from_string` .
If you’re interested in peeking certain values (family name,
style, size, weight) just query these properties from the
`pango::FontDescription` object.

# Returns

an internal copy of the font name which must not be freed.
<!-- trait FontButtonExt::fn get_show_size -->
Returns whether the font size will be shown in the label.

# Returns

whether the font size will be shown in the label.
<!-- trait FontButtonExt::fn get_show_style -->
Returns whether the name of the font style will be shown in the label.

# Returns

whether the font style will be shown in the label.
<!-- trait FontButtonExt::fn get_title -->
Retrieves the title of the font chooser dialog.

# Returns

an internal copy of the title string which must not be freed.
<!-- trait FontButtonExt::fn get_use_font -->
Returns whether the selected font is used in the label.

# Returns

whether the selected font is used in the label.
<!-- trait FontButtonExt::fn get_use_size -->
Returns whether the selected size is used in the label.

# Returns

whether the selected size is used in the label.
<!-- trait FontButtonExt::fn set_font_name -->
Sets or updates the currently-displayed font in font picker dialog.
## `fontname`
Name of font to display in font chooser dialog

# Returns

`true`
<!-- trait FontButtonExt::fn set_show_size -->
If `show_size` is `true`, the font size will be displayed along with the name of the selected font.
## `show_size`
`true` if font size should be displayed in dialog.
<!-- trait FontButtonExt::fn set_show_style -->
If `show_style` is `true`, the font style will be displayed along with name of the selected font.
## `show_style`
`true` if font style should be displayed in label.
<!-- trait FontButtonExt::fn set_title -->
Sets the title for the font chooser dialog.
## `title`
a string containing the font chooser dialog title
<!-- trait FontButtonExt::fn set_use_font -->
If `use_font` is `true`, the font name will be written using the selected font.
## `use_font`
If `true`, font name will be written using font chosen.
<!-- trait FontButtonExt::fn set_use_size -->
If `use_size` is `true`, the font name will be written using the selected size.
## `use_size`
If `true`, font name will be written using the selected size.
<!-- trait FontButtonExt::fn connect_font_set -->
The ::font-set signal is emitted when the user selects a font.
When handling this signal, use `FontButtonExt::get_font_name`
to find out which font was just selected.

Note that this signal is only emitted when the user
changes the font. If you need to react to programmatic font changes
as well, use the notify::font-name signal.
<!-- trait FontButtonExt::fn get_property_font-name -->
The name of the currently selected font.
<!-- trait FontButtonExt::fn set_property_font-name -->
The name of the currently selected font.
<!-- trait FontButtonExt::fn get_property_show-size -->
If this property is set to `true`, the selected font size will be shown
in the label. For a more WYSIWYG way to show the selected size, see the
::use-size property.
<!-- trait FontButtonExt::fn set_property_show-size -->
If this property is set to `true`, the selected font size will be shown
in the label. For a more WYSIWYG way to show the selected size, see the
::use-size property.
<!-- trait FontButtonExt::fn get_property_show-style -->
If this property is set to `true`, the name of the selected font style
will be shown in the label. For a more WYSIWYG way to show the selected
style, see the ::use-font property.
<!-- trait FontButtonExt::fn set_property_show-style -->
If this property is set to `true`, the name of the selected font style
will be shown in the label. For a more WYSIWYG way to show the selected
style, see the ::use-font property.
<!-- trait FontButtonExt::fn get_property_title -->
The title of the font chooser dialog.
<!-- trait FontButtonExt::fn set_property_title -->
The title of the font chooser dialog.
<!-- trait FontButtonExt::fn get_property_use-font -->
If this property is set to `true`, the label will be drawn
in the selected font.
<!-- trait FontButtonExt::fn set_property_use-font -->
If this property is set to `true`, the label will be drawn
in the selected font.
<!-- trait FontButtonExt::fn get_property_use-size -->
If this property is set to `true`, the label will be drawn
with the selected font size.
<!-- trait FontButtonExt::fn set_property_use-size -->
If this property is set to `true`, the label will be drawn
with the selected font size.
<!-- struct FontChooser -->
`FontChooser` is an interface that can be implemented by widgets
displaying the list of fonts. In GTK+, the main objects
that implement this interface are `FontChooserWidget`,
`FontChooserDialog` and `FontButton`. The `FontChooser` interface
has been introducted in GTK+ 3.2.

# Implements

[`FontChooserExt`](trait.FontChooserExt.html)
<!-- trait FontChooserExt -->
Trait containing all `FontChooser` methods.

# Implementors

[`FontButton`](struct.FontButton.html), [`FontChooserDialog`](struct.FontChooserDialog.html), [`FontChooserWidget`](struct.FontChooserWidget.html), [`FontChooser`](struct.FontChooser.html)
<!-- trait FontChooserExt::fn get_font -->
Gets the currently-selected font name.

Note that this can be a different string than what you set with
`FontChooser::set_font`, as the font chooser widget may
normalize font names and thus return a string with a different
structure. For example, “Helvetica Italic Bold 12” could be
normalized to “Helvetica Bold Italic 12”.

Use `pango::FontDescription::equal` if you want to compare two
font descriptions.

# Returns

A string with the name
 of the current font, or `None` if no font is selected. You must
 free this string with `g_free`.
<!-- trait FontChooserExt::fn get_font_desc -->
Gets the currently-selected font.

Note that this can be a different string than what you set with
`FontChooser::set_font`, as the font chooser widget may
normalize font names and thus return a string with a different
structure. For example, “Helvetica Italic Bold 12” could be
normalized to “Helvetica Bold Italic 12”.

Use `pango::FontDescription::equal` if you want to compare two
font descriptions.

# Returns

A `pango::FontDescription` for the
 current font, or `None` if no font is selected.
<!-- trait FontChooserExt::fn get_font_face -->
Gets the `pango::FontFace` representing the selected font group
details (i.e. family, slant, weight, width, etc).

If the selected font is not installed, returns `None`.

# Returns

A `pango::FontFace` representing the
 selected font group details, or `None`. The returned object is owned by
 `self` and must not be modified or freed.
<!-- trait FontChooserExt::fn get_font_family -->
Gets the `pango::FontFamily` representing the selected font family.
Font families are a collection of font faces.

If the selected font is not installed, returns `None`.

# Returns

A `pango::FontFamily` representing the
 selected font family, or `None`. The returned object is owned by `self`
 and must not be modified or freed.
<!-- trait FontChooserExt::fn get_font_map -->
Gets the custom font map of this font chooser widget,
or `None` if it does not have one.

Feature: `v3_18`


# Returns

a `pango::FontMap`, or `None`
<!-- trait FontChooserExt::fn get_font_size -->
The selected font size.

# Returns

A n integer representing the selected font size,
 or -1 if no font size is selected.
<!-- trait FontChooserExt::fn get_preview_text -->
Gets the text displayed in the preview area.

# Returns

the text displayed in the
 preview area
<!-- trait FontChooserExt::fn get_show_preview_entry -->
Returns whether the preview entry is shown or not.

# Returns

`true` if the preview entry is shown
 or `false` if it is hidden.
<!-- trait FontChooserExt::fn set_filter_func -->
Adds a filter function that decides which fonts to display
in the font chooser.
## `filter`
a ``GtkFontFilterFunc``, or `None`
## `user_data`
data to pass to `filter`
## `destroy`
function to call to free `data` when it is no longer needed
<!-- trait FontChooserExt::fn set_font -->
Sets the currently-selected font.
## `fontname`
a font name like “Helvetica 12” or “Times Bold 18”
<!-- trait FontChooserExt::fn set_font_desc -->
Sets the currently-selected font from `font_desc`.
## `font_desc`
a `pango::FontDescription`
<!-- trait FontChooserExt::fn set_font_map -->
Sets a custom font map to use for this font chooser widget.
A custom font map can be used to present application-specific
fonts instead of or in addition to the normal system fonts.


```C
FcConfig *config;
PangoFontMap *fontmap;

config = FcInitLoadConfigAndFonts ();
FcConfigAppFontAddFile (config, my_app_font_file);

fontmap = pango_cairo_font_map_new_for_font_type (CAIRO_FONT_TYPE_FT);
pango_fc_font_map_set_config (PANGO_FC_FONT_MAP (fontmap), config);

gtk_font_chooser_set_font_map (font_chooser, fontmap);
```

Note that other GTK+ widgets will only be able to use the application-specific
font if it is present in the font map they use:


```text
context = gtk_widget_get_pango_context (label);
pango_context_set_font_map (context, fontmap);
```

Feature: `v3_18`

## `fontmap`
a `pango::FontMap`
<!-- trait FontChooserExt::fn set_preview_text -->
Sets the text displayed in the preview area.
The `text` is used to show how the selected font looks.
## `text`
the text to display in the preview area
<!-- trait FontChooserExt::fn set_show_preview_entry -->
Shows or hides the editable preview entry.
## `show_preview_entry`
whether to show the editable preview entry or not
<!-- trait FontChooserExt::fn connect_font_activated -->
Emitted when a font is activated.
This usually happens when the user double clicks an item,
or an item is selected and the user presses one of the keys
Space, Shift+Space, Return or Enter.
## `fontname`
the font name
<!-- trait FontChooserExt::fn get_property_font -->
The font description as a string, e.g. "Sans Italic 12".
<!-- trait FontChooserExt::fn set_property_font -->
The font description as a string, e.g. "Sans Italic 12".
<!-- trait FontChooserExt::fn get_property_font-desc -->
The font description as a `pango::FontDescription`.
<!-- trait FontChooserExt::fn set_property_font-desc -->
The font description as a `pango::FontDescription`.
<!-- trait FontChooserExt::fn get_property_preview-text -->
The string with which to preview the font.
<!-- trait FontChooserExt::fn set_property_preview-text -->
The string with which to preview the font.
<!-- trait FontChooserExt::fn get_property_show-preview-entry -->
Whether to show an entry to change the preview text.
<!-- trait FontChooserExt::fn set_property_show-preview-entry -->
Whether to show an entry to change the preview text.
<!-- struct FontChooserDialog -->
The `FontChooserDialog` widget is a dialog for selecting a font.
It implements the `FontChooser` interface.

# `FontChooserDialog` as `Buildable`

The `FontChooserDialog` implementation of the `Buildable`
interface exposes the buttons with the names “select_button”
and “cancel_button”.

# Implements

[`DialogExt`](trait.DialogExt.html), [`GtkWindowExt`](trait.GtkWindowExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`FontChooserExt`](trait.FontChooserExt.html)
<!-- impl FontChooserDialog::fn new -->
Creates a new `FontChooserDialog`.
## `title`
Title of the dialog, or `None`
## `parent`
Transient parent of the dialog, or `None`

# Returns

a new `FontChooserDialog`
<!-- struct FontChooserWidget -->
The `FontChooserWidget` widget lists the available fonts,
styles and sizes, allowing the user to select a font. It is
used in the `FontChooserDialog` widget to provide a
dialog box for selecting fonts.

To set the font which is initially selected, use
`FontChooser::set_font` or `FontChooser::set_font_desc`.

To get the selected font use `FontChooser::get_font` or
`FontChooser::get_font_desc`.

To change the text which is shown in the preview area, use
`FontChooser::set_preview_text`.

# CSS nodes

`FontChooserWidget` has a single CSS node with name fontchooser.

# Implements

[`BoxExt`](trait.BoxExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`OrientableExt`](trait.OrientableExt.html), [`FontChooserExt`](trait.FontChooserExt.html)
<!-- impl FontChooserWidget::fn new -->
Creates a new `FontChooserWidget`.

# Returns

a new `FontChooserWidget`
<!-- struct Frame -->
The frame widget is a bin that surrounds its child with a decorative
frame and an optional label. If present, the label is drawn in a gap
in the top side of the frame. The position of the label can be
controlled with `FrameExt::set_label_align`.

# `Frame` as `Buildable`

The `Frame` implementation of the `Buildable` interface supports
placing a child in the label position by specifying “label” as the
“type” attribute of a `<child>` element. A normal content child can
be specified without specifying a `<child>` type attribute.

An example of a UI definition fragment with `Frame`:

```plain
frame
├── border
├── <label widget>
╰── <child>
```

`Frame` has a main CSS node with name frame and a subnode with
name border. The border node is used to render the visible border.

The border node can be given the style class .flat, which is used by themes
to disable drawing of the border. To do this from code, call
`FrameExt::set_shadow_type` with GTK_SHADOW_NONE to add the .flat class or
any other shadow type to remove it.

# Implements

[`FrameExt`](trait.FrameExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait FrameExt -->
Trait containing all `Frame` methods.

# Implementors

[`AspectFrame`](struct.AspectFrame.html), [`Frame`](struct.Frame.html)
<!-- impl Frame::fn new -->
Creates a new `Frame`, with optional label `label`.
If `label` is `None`, the label is omitted.
## `label`
the text to use as the label of the frame

# Returns

a new `Frame` widget
<!-- trait FrameExt::fn get_label -->
If the frame’s label widget is a `Label`, returns the
text in the label widget. (The frame will have a `Label`
for the label widget if a non-`None` argument was passed
to `Frame::new`.)

# Returns

the text in the label, or `None` if there
 was no label widget or the lable widget was not
 a `Label`. This string is owned by GTK+ and
 must not be modified or freed.
<!-- trait FrameExt::fn get_label_align -->
Retrieves the X and Y alignment of the frame’s label. See
`FrameExt::set_label_align`.
## `xalign`
location to store X alignment of
 frame’s label, or `None`
## `yalign`
location to store X alignment of
 frame’s label, or `None`
<!-- trait FrameExt::fn get_label_widget -->
Retrieves the label widget for the frame. See
`FrameExt::set_label_widget`.

# Returns

the label widget, or `None` if
there is none.
<!-- trait FrameExt::fn get_shadow_type -->
Retrieves the shadow type of the frame. See
`FrameExt::set_shadow_type`.

# Returns

the current shadow type of the frame.
<!-- trait FrameExt::fn set_label -->
Removes the current `Frame:label-widget`. If `label` is not `None`, creates a
new `Label` with that text and adds it as the `Frame:label-widget`.
## `label`
the text to use as the label of the frame
<!-- trait FrameExt::fn set_label_align -->
Sets the alignment of the frame widget’s label. The
default values for a newly created frame are 0.0 and 0.5.
## `xalign`
The position of the label along the top edge
 of the widget. A value of 0.0 represents left alignment;
 1.0 represents right alignment.
## `yalign`
The y alignment of the label. A value of 0.0 aligns under
 the frame; 1.0 aligns above the frame. If the values are exactly
 0.0 or 1.0 the gap in the frame won’t be painted because the label
 will be completely above or below the frame.
<!-- trait FrameExt::fn set_label_widget -->
Sets the `Frame:label-widget` for the frame. This is the widget that
will appear embedded in the top edge of the frame as a title.
## `label_widget`
the new label widget
<!-- trait FrameExt::fn set_shadow_type -->
Sets the `Frame:shadow-type` for `self`, i.e. whether it is drawn without
(GTK_SHADOW_NONE) or with (other values) a visible border. Values other than
GTK_SHADOW_NONE are treated identically by `Frame`. The chosen type is
applied by removing or adding the .flat class to the CSS node named border.
## `type_`
the new `ShadowType`
<!-- struct GLArea -->
`GLArea` is a widget that allows drawing with OpenGL.

`GLArea` sets up its own `gdk::GLContext` for the window it creates, and
creates a custom GL framebuffer that the widget will do GL rendering onto.
It also ensures that this framebuffer is the default GL rendering target
when rendering.

In order to draw, you have to connect to the `GLArea::render` signal,
or subclass `GLArea` and override the `GLAreaClass.render`() virtual
function.

The `GLArea` widget ensures that the `gdk::GLContext` is associated with
the widget's drawing area, and it is kept updated when the size and
position of the drawing area changes.

## Drawing with `GLArea` ##

The simplest way to draw using OpenGL commands in a `GLArea` is to
create a widget instance and connect to the `GLArea::render` signal:


```C
  // create a GtkGLArea instance
  GtkWidget *gl_area = gtk_gl_area_new ();

  // connect to the "render" signal
  g_signal_connect (gl_area, "render", G_CALLBACK (render), NULL);
```

The `render()` function will be called when the `GLArea` is ready
for you to draw its content:


```C
  static gboolean
  render (GtkGLArea *area, GdkGLContext *context)
  {
    // inside this function it's safe to use GL; the given
    // #GdkGLContext has been made current to the drawable
    // surface used by the #GtkGLArea and the viewport has
    // already been set to be the size of the allocation

    // we can start by clearing the buffer
    glClearColor (0, 0, 0, 0);
    glClear (GL_COLOR_BUFFER_BIT);

    // draw your object
    draw_an_object ();

    // we completed our drawing; the draw commands will be
    // flushed at the end of the signal emission chain, and
    // the buffers will be drawn on the window
    return TRUE;
  }
```

If you need to initialize OpenGL state, e.g. buffer objects or
shaders, you should use the `Widget::realize` signal; you
can use the `Widget::unrealize` signal to clean up. Since the
`gdk::GLContext` creation and initialization may fail, you will
need to check for errors, using `GLAreaExt::get_error`. An example
of how to safely initialize the GL state is:


```C
  static void
  on_realize (GtkGLarea *area)
  {
    // We need to make the context current if we want to
    // call GL API
    gtk_gl_area_make_current (area);

    // If there were errors during the initialization or
    // when trying to make the context current, this
    // function will return a #GError for you to catch
    if (gtk_gl_area_get_error (area) != NULL)
      return;

    // You can also use gtk_gl_area_set_error() in order
    // to show eventual initialization errors on the
    // GtkGLArea widget itself
    GError *internal_error = NULL;
    init_buffer_objects (&error);
    if (error != NULL)
      {
        gtk_gl_area_set_error (area, error);
        g_error_free (error);
        return;
      }

    init_shaders (&error);
    if (error != NULL)
      {
        gtk_gl_area_set_error (area, error);
        g_error_free (error);
        return;
      }
  }
```

If you need to change the options for creating the `gdk::GLContext`
you should use the `GLArea::create-context` signal.

Feature: `v3_16`

# Implements

[`GLAreaExt`](trait.GLAreaExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait GLAreaExt -->
Trait containing all `GLArea` methods.

Feature: `v3_16`

# Implementors

[`GLArea`](struct.GLArea.html)
<!-- impl GLArea::fn new -->
Creates a new `GLArea` widget.

Feature: `v3_16`


# Returns

the newly created `GLArea`
<!-- trait GLAreaExt::fn attach_buffers -->
Ensures that the `self` framebuffer object is made the current draw
and read target, and that all the required buffers for the `self`
are created and bound to the frambuffer.

This function is automatically called before emitting the
`GLArea::render` signal, and doesn't normally need to be called
by application code.

Feature: `v3_16`

<!-- trait GLAreaExt::fn get_auto_render -->
Returns whether the area is in auto render mode or not.

Feature: `v3_16`


# Returns

`true` if the `self` is auto rendering, `false` otherwise
<!-- trait GLAreaExt::fn get_context -->
Retrieves the `gdk::GLContext` used by `self`.

Feature: `v3_16`


# Returns

the `gdk::GLContext`
<!-- trait GLAreaExt::fn get_error -->
Gets the current error set on the `self`.

Feature: `v3_16`


# Returns

the `glib::Error` or `None`
<!-- trait GLAreaExt::fn get_has_alpha -->
Returns whether the area has an alpha component.

Feature: `v3_16`


# Returns

`true` if the `self` has an alpha component, `false` otherwise
<!-- trait GLAreaExt::fn get_has_depth_buffer -->
Returns whether the area has a depth buffer.

Feature: `v3_16`


# Returns

`true` if the `self` has a depth buffer, `false` otherwise
<!-- trait GLAreaExt::fn get_has_stencil_buffer -->
Returns whether the area has a stencil buffer.

Feature: `v3_16`


# Returns

`true` if the `self` has a stencil buffer, `false` otherwise
<!-- trait GLAreaExt::fn get_required_version -->
Retrieves the required version of OpenGL set
using `GLAreaExt::set_required_version`.

Feature: `v3_16`

## `major`
return location for the required major version
## `minor`
return location for the required minor version
<!-- trait GLAreaExt::fn get_use_es -->
Retrieves the value set by `GLAreaExt::set_use_es`.

Feature: `v3_22`


# Returns

`true` if the `GLArea` should create an OpenGL ES context
 and `false` otherwise
<!-- trait GLAreaExt::fn make_current -->
Ensures that the `gdk::GLContext` used by `self` is associated with
the `GLArea`.

This function is automatically called before emitting the
`GLArea::render` signal, and doesn't normally need to be called
by application code.

Feature: `v3_16`

<!-- trait GLAreaExt::fn queue_render -->
Marks the currently rendered data (if any) as invalid, and queues
a redraw of the widget, ensuring that the `GLArea::render` signal
is emitted during the draw.

This is only needed when the `GLAreaExt::set_auto_render` has
been called with a `false` value. The default behaviour is to
emit `GLArea::render` on each draw.

Feature: `v3_16`

<!-- trait GLAreaExt::fn set_auto_render -->
If `auto_render` is `true` the `GLArea::render` signal will be
emitted every time the widget draws. This is the default and is
useful if drawing the widget is faster.

If `auto_render` is `false` the data from previous rendering is kept
around and will be used for drawing the widget the next time,
unless the window is resized. In order to force a rendering
`GLAreaExt::queue_render` must be called. This mode is useful when
the scene changes seldomly, but takes a long time to redraw.

Feature: `v3_16`

## `auto_render`
a boolean
<!-- trait GLAreaExt::fn set_error -->
Sets an error on the area which will be shown instead of the
GL rendering. This is useful in the `GLArea::create-context`
signal if GL context creation fails.

Feature: `v3_16`

## `error`
a new `glib::Error`, or `None` to unset the error
<!-- trait GLAreaExt::fn set_has_alpha -->
If `has_alpha` is `true` the buffer allocated by the widget will have
an alpha channel component, and when rendering to the window the
result will be composited over whatever is below the widget.

If `has_alpha` is `false` there will be no alpha channel, and the
buffer will fully replace anything below the widget.

Feature: `v3_16`

## `has_alpha`
`true` to add an alpha component
<!-- trait GLAreaExt::fn set_has_depth_buffer -->
If `has_depth_buffer` is `true` the widget will allocate and
enable a depth buffer for the target framebuffer. Otherwise
there will be none.

Feature: `v3_16`

## `has_depth_buffer`
`true` to add a depth buffer
<!-- trait GLAreaExt::fn set_has_stencil_buffer -->
If `has_stencil_buffer` is `true` the widget will allocate and
enable a stencil buffer for the target framebuffer. Otherwise
there will be none.

Feature: `v3_16`

## `has_stencil_buffer`
`true` to add a stencil buffer
<!-- trait GLAreaExt::fn set_required_version -->
Sets the required version of OpenGL to be used when creating the context
for the widget.

This function must be called before the area has been realized.

Feature: `v3_16`

## `major`
the major version
## `minor`
the minor version
<!-- trait GLAreaExt::fn set_use_es -->
Sets whether the `self` should create an OpenGL or an OpenGL ES context.

You should check the capabilities of the `gdk::GLContext` before drawing
with either API.

Feature: `v3_22`

## `use_es`
whether to use OpenGL or OpenGL ES
<!-- trait GLAreaExt::fn connect_create_context -->
The ::create-context signal is emitted when the widget is being
realized, and allows you to override how the GL context is
created. This is useful when you want to reuse an existing GL
context, or if you want to try creating different kinds of GL
options.

If context creation fails then the signal handler can use
`GLAreaExt::set_error` to register a more detailed error
of how the construction failed.

Feature: `v3_16`


# Returns

a newly created `gdk::GLContext`;
 the `GLArea` widget will take ownership of the returned value.
<!-- trait GLAreaExt::fn connect_render -->
The ::render signal is emitted every time the contents
of the `GLArea` should be redrawn.

The `context` is bound to the `area` prior to emitting this function,
and the buffers are painted to the window once the emission terminates.

Feature: `v3_16`

## `context`
the `gdk::GLContext` used by `area`

# Returns

`true` to stop other handlers from being invoked for the event.
 `false` to propagate the event further.
<!-- trait GLAreaExt::fn connect_resize -->
The ::resize signal is emitted once when the widget is realized, and
then each time the widget is changed while realized. This is useful
in order to keep GL state up to date with the widget size, like for
instance camera properties which may depend on the width/height ratio.

The GL context for the area is guaranteed to be current when this signal
is emitted.

The default handler sets up the GL viewport.

Feature: `v3_16`

## `width`
the width of the viewport
## `height`
the height of the viewport
<!-- trait GLAreaExt::fn get_property_auto-render -->
If set to `true` the `GLArea::render` signal will be emitted every time
the widget draws. This is the default and is useful if drawing the widget
is faster.

If set to `false` the data from previous rendering is kept around and will
be used for drawing the widget the next time, unless the window is resized.
In order to force a rendering `GLAreaExt::queue_render` must be called.
This mode is useful when the scene changes seldomly, but takes a long time
to redraw.

Feature: `v3_16`

<!-- trait GLAreaExt::fn set_property_auto-render -->
If set to `true` the `GLArea::render` signal will be emitted every time
the widget draws. This is the default and is useful if drawing the widget
is faster.

If set to `false` the data from previous rendering is kept around and will
be used for drawing the widget the next time, unless the window is resized.
In order to force a rendering `GLAreaExt::queue_render` must be called.
This mode is useful when the scene changes seldomly, but takes a long time
to redraw.

Feature: `v3_16`

<!-- trait GLAreaExt::fn get_property_context -->
The `gdk::GLContext` used by the `GLArea` widget.

The `GLArea` widget is responsible for creating the `gdk::GLContext`
instance. If you need to render with other kinds of buffers (stencil,
depth, etc), use render buffers.

Feature: `v3_16`

<!-- trait GLAreaExt::fn get_property_has-alpha -->
If set to `true` the buffer allocated by the widget will have an alpha channel
component, and when rendering to the window the result will be composited over
whatever is below the widget.

If set to `false` there will be no alpha channel, and the buffer will fully
replace anything below the widget.

Feature: `v3_16`

<!-- trait GLAreaExt::fn set_property_has-alpha -->
If set to `true` the buffer allocated by the widget will have an alpha channel
component, and when rendering to the window the result will be composited over
whatever is below the widget.

If set to `false` there will be no alpha channel, and the buffer will fully
replace anything below the widget.

Feature: `v3_16`

<!-- trait GLAreaExt::fn get_property_has-depth-buffer -->
If set to `true` the widget will allocate and enable a depth buffer for the
target framebuffer.

Feature: `v3_16`

<!-- trait GLAreaExt::fn set_property_has-depth-buffer -->
If set to `true` the widget will allocate and enable a depth buffer for the
target framebuffer.

Feature: `v3_16`

<!-- trait GLAreaExt::fn get_property_has-stencil-buffer -->
If set to `true` the widget will allocate and enable a stencil buffer for the
target framebuffer.

Feature: `v3_16`

<!-- trait GLAreaExt::fn set_property_has-stencil-buffer -->
If set to `true` the widget will allocate and enable a stencil buffer for the
target framebuffer.

Feature: `v3_16`

<!-- trait GLAreaExt::fn get_property_use-es -->
If set to `true` the widget will try to create a `gdk::GLContext` using
OpenGL ES instead of OpenGL.

See also: `gdk::GLContextExt::set_use_es`

Feature: `v3_22`

<!-- trait GLAreaExt::fn set_property_use-es -->
If set to `true` the widget will try to create a `gdk::GLContext` using
OpenGL ES instead of OpenGL.

See also: `gdk::GLContextExt::set_use_es`

Feature: `v3_22`

<!-- struct Gesture -->
`Gesture` is the base object for gesture recognition, although this
object is quite generalized to serve as a base for multi-touch gestures,
it is suitable to implement single-touch and pointer-based gestures (using
the special `None` `gdk::EventSequence` value for these).

The number of touches that a `Gesture` need to be recognized is controlled
by the `Gesture:n-points` property, if a gesture is keeping track of less
or more than that number of sequences, it won't check wether the gesture
is recognized.

As soon as the gesture has the expected number of touches, the gesture will
run the `Gesture::check` signal regularly on input events until the gesture
is recognized, the criteria to consider a gesture as "recognized" is left to
`Gesture` subclasses.

A recognized gesture will then emit the following signals:
- `Gesture::begin` when the gesture is recognized.
- A number of `Gesture::update`, whenever an input event is processed.
- `Gesture::end` when the gesture is no longer recognized.

## Event propagation

In order to receive events, a gesture needs to either set a propagation phase
through `EventControllerExt::set_propagation_phase`, or feed those manually
through `EventControllerExt::handle_event`.

In the capture phase, events are propagated from the toplevel down to the
target widget, and gestures that are attached to containers above the widget
get a chance to interact with the event before it reaches the target.

After the capture phase, GTK+ emits the traditional `Widget::button-press-event`,
`Widget::button-release-event`, `Widget::touch-event`, etc signals. Gestures
with the `PropagationPhase::Target` phase are fed events from the default `Widget::event`
handlers.

In the bubble phase, events are propagated up from the target widget to the
toplevel, and gestures that are attached to containers above the widget get
a chance to interact with events that have not been handled yet.

## States of a sequence # {`touch`-sequence-states}

Whenever input interaction happens, a single event may trigger a cascade of
``GtkGestures``, both across the parents of the widget receiving the event and
in parallel within an individual widget. It is a responsibility of the
widgets using those gestures to set the state of touch sequences accordingly
in order to enable cooperation of gestures around the ``GdkEventSequences``
triggering those.

Within a widget, gestures can be grouped through `GestureExt::group`,
grouped gestures synchronize the state of sequences, so calling
`GestureExt::set_sequence_state` on one will effectively propagate
the state throughout the group.

By default, all sequences start out in the `EventSequenceState::None` state,
sequences in this state trigger the gesture event handler, but event
propagation will continue unstopped by gestures.

If a sequence enters into the `EventSequenceState::Denied` state, the gesture
group will effectively ignore the sequence, letting events go unstopped
through the gesture, but the "slot" will still remain occupied while
the touch is active.

If a sequence enters in the `EventSequenceState::Claimed` state, the gesture
group will grab all interaction on the sequence, by:
- Setting the same sequence to `EventSequenceState::Denied` on every other gesture
 group within the widget, and every gesture on parent widgets in the propagation
 chain.
- calling `Gesture::cancel` on every gesture in widgets underneath in the
 propagation chain.
- Stopping event propagation after the gesture group handles the event.

Note: if a sequence is set early to `EventSequenceState::Claimed` on
`gdk::EventType::TouchBegin`/`gdk::EventType::ButtonPress` (so those events are captured before
reaching the event widget, this implies `PropagationPhase::Capture`), one similar
event will emulated if the sequence changes to `EventSequenceState::Denied`.
This way event coherence is preserved before event propagation is unstopped
again.

Sequence states can't be changed freely, see `GestureExt::set_sequence_state`
to know about the possible lifetimes of a `gdk::EventSequence`.

## Touchpad gestures

On the platforms that support it, `Gesture` will handle transparently
touchpad gesture events. The only precautions users of `Gesture` should do
to enable this support are:
- Enabling `gdk::EventMask::TouchpadGestureMask` on their ``GdkWindows``
- If the gesture has `PropagationPhase::None`, ensuring events of type
 `gdk::EventType::TouchpadSwipe` and `gdk::EventType::TouchpadPinch` are handled by the `Gesture`

Feature: `v3_14`

# Implements

[`GestureExt`](trait.GestureExt.html), [`EventControllerExt`](trait.EventControllerExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait GestureExt -->
Trait containing all `Gesture` methods.

Feature: `v3_14`

# Implementors

[`GestureRotate`](struct.GestureRotate.html), [`GestureSingle`](struct.GestureSingle.html), [`GestureZoom`](struct.GestureZoom.html), [`Gesture`](struct.Gesture.html)
<!-- trait GestureExt::fn get_bounding_box -->
If there are touch sequences being currently handled by `self`,
this function returns `true` and fills in `rect` with the bounding
box containing all active touches. Otherwise, `false` will be
returned.

Note: This function will yield unexpected results on touchpad
gestures. Since there is no correlation between physical and
pixel distances, these will look as if constrained in an
infinitely small area, `rect` width and height will thus be 0
regardless of the number of touchpoints.

Feature: `v3_14`

## `rect`
bounding box containing all active touches.

# Returns

`true` if there are active touches, `false` otherwise
<!-- trait GestureExt::fn get_bounding_box_center -->
If there are touch sequences being currently handled by `self`,
this function returns `true` and fills in `x` and `y` with the center
of the bounding box containing all active touches. Otherwise, `false`
will be returned.

Feature: `v3_14`

## `x`
X coordinate for the bounding box center
## `y`
Y coordinate for the bounding box center

# Returns

`false` if no active touches are present, `true` otherwise
<!-- trait GestureExt::fn get_device -->
Returns the master `gdk::Device` that is currently operating
on `self`, or `None` if the gesture is not being interacted.

Feature: `v3_14`


# Returns

a `gdk::Device`, or `None`
<!-- trait GestureExt::fn get_group -->
Returns all gestures in the group of `self`

Feature: `v3_14`


# Returns

The list
 of ``GtkGestures``, free with `glib::List::free`
<!-- trait GestureExt::fn get_last_event -->
Returns the last event that was processed for `sequence`.

Note that the returned pointer is only valid as long as the `sequence`
is still interpreted by the `self`. If in doubt, you should make
a copy of the event.
## `sequence`
a `gdk::EventSequence`

# Returns

The last event from `sequence`
<!-- trait GestureExt::fn get_last_updated_sequence -->
Returns the `gdk::EventSequence` that was last updated on `self`.

Feature: `v3_14`


# Returns

The last updated sequence
<!-- trait GestureExt::fn get_point -->
If `sequence` is currently being interpreted by `self`, this
function returns `true` and fills in `x` and `y` with the last coordinates
stored for that event sequence. The coordinates are always relative to the
widget allocation.

Feature: `v3_14`

## `sequence`
a `gdk::EventSequence`, or `None` for pointer events
## `x`
return location for X axis of the sequence coordinates
## `y`
return location for Y axis of the sequence coordinates

# Returns

`true` if `sequence` is currently interpreted
<!-- trait GestureExt::fn get_sequence_state -->
Returns the `sequence` state, as seen by `self`.

Feature: `v3_14`

## `sequence`
a `gdk::EventSequence`

# Returns

The sequence state in `self`
<!-- trait GestureExt::fn get_sequences -->
Returns the list of ``GdkEventSequences`` currently being interpreted
by `self`.

Feature: `v3_14`


# Returns

A list
 of ``GdkEventSequences``, the list elements are owned by GTK+
 and must not be freed or modified, the list itself must be deleted
 through `glib::List::free`
<!-- trait GestureExt::fn get_window -->
Returns the user-defined window that receives the events
handled by `self`. See `GestureExt::set_window` for more
information.

Feature: `v3_14`


# Returns

the user defined window, or `None` if none
<!-- trait GestureExt::fn group -->
Adds `gesture` to the same group than `self`. Gestures
are by default isolated in their own groups.

When gestures are grouped, the state of ``GdkEventSequences``
is kept in sync for all of those, so calling `GestureExt::set_sequence_state`,
on one will transfer the same value to the others.

Groups also perform an "implicit grabbing" of sequences, if a
`gdk::EventSequence` state is set to `EventSequenceState::Claimed` on one group,
every other gesture group attached to the same `Widget` will switch the
state for that sequence to `EventSequenceState::Denied`.

Feature: `v3_14`

## `gesture`
a `Gesture`
<!-- trait GestureExt::fn handles_sequence -->
Returns `true` if `self` is currently handling events corresponding to
`sequence`.

Feature: `v3_14`

## `sequence`
a `gdk::EventSequence` or `None`

# Returns

`true` if `self` is handling `sequence`, `false` otherwise
<!-- trait GestureExt::fn is_active -->
Returns `true` if the gesture is currently active.
A gesture is active meanwhile there are touch sequences
interacting with it.

Feature: `v3_14`


# Returns

`true` if gesture is active
<!-- trait GestureExt::fn is_grouped_with -->
Returns `true` if both gestures pertain to the same group.

Feature: `v3_14`

## `other`
another `Gesture`

# Returns

whether the gestures are grouped
<!-- trait GestureExt::fn is_recognized -->
Returns `true` if the gesture is currently recognized.
A gesture is recognized if there are as many interacting
touch sequences as required by `self`, and `Gesture::check`
returned `true` for the sequences being currently interpreted.

Feature: `v3_14`


# Returns

`true` if gesture is recognized
<!-- trait GestureExt::fn set_sequence_state -->
Sets the state of `sequence` in `self`. Sequences start
in state `EventSequenceState::None`, and whenever they change
state, they can never go back to that state. Likewise,
sequences in state `EventSequenceState::Denied` cannot turn
back to a not denied state. With these rules, the lifetime
of an event sequence is constrained to the next four:

* None
* None → Denied
* None → Claimed
* None → Claimed → Denied

Note: Due to event handling ordering, it may be unsafe to
set the state on another gesture within a `Gesture::begin`
signal handler, as the callback might be executed before
the other gesture knows about the sequence. A safe way to
perform this could be:


```text
static void
first_gesture_begin_cb (GtkGesture       *first_gesture,
                        GdkEventSequence *sequence,
                        gpointer          user_data)
{
  gtk_gesture_set_sequence_state (first_gesture, sequence, GTK_EVENT_SEQUENCE_ACCEPTED);
  gtk_gesture_set_sequence_state (second_gesture, sequence, GTK_EVENT_SEQUENCE_DENIED);
}

static void
second_gesture_begin_cb (GtkGesture       *second_gesture,
                         GdkEventSequence *sequence,
                         gpointer          user_data)
{
  if (gtk_gesture_get_sequence_state (first_gesture, sequence) == GTK_EVENT_SEQUENCE_ACCEPTED)
    gtk_gesture_set_sequence_state (second_gesture, sequence, GTK_EVENT_SEQUENCE_DENIED);
}
```

If both gestures are in the same group, just set the state on
the gesture emitting the event, the sequence will be already
be initialized to the group's global state when the second
gesture processes the event.

Feature: `v3_14`

## `sequence`
a `gdk::EventSequence`
## `state`
the sequence state

# Returns

`true` if `sequence` is handled by `self`,
 and the state is changed successfully
<!-- trait GestureExt::fn set_state -->
Sets the state of all sequences that `self` is currently
interacting with. See `GestureExt::set_sequence_state`
for more details on sequence states.

Feature: `v3_14`

## `state`
the sequence state

# Returns

`true` if the state of at least one sequence
 was changed successfully
<!-- trait GestureExt::fn set_window -->
Sets a specific window to receive events about, so `self`
will effectively handle only events targeting `window`, or
a child of it. `window` must pertain to `EventControllerExt::get_widget`.

Feature: `v3_14`

## `window`
a `gdk::Window`, or `None`
<!-- trait GestureExt::fn ungroup -->
Separates `self` into an isolated group.

Feature: `v3_14`

<!-- trait GestureExt::fn connect_begin -->
This signal is emitted when the gesture is recognized. This means the
number of touch sequences matches `Gesture:n-points`, and the `Gesture::check`
handler(s) returned `true`.

Note: These conditions may also happen when an extra touch (eg. a third touch
on a 2-touches gesture) is lifted, in that situation `sequence` won't pertain
to the current set of active touches, so don't rely on this being true.

Feature: `v3_14`

## `sequence`
the `gdk::EventSequence` that made the gesture to be recognized
<!-- trait GestureExt::fn connect_cancel -->
This signal is emitted whenever a sequence is cancelled. This usually
happens on active touches when `EventControllerExt::reset` is called
on `gesture` (manually, due to grabs...), or the individual `sequence`
was claimed by parent widgets' controllers (see `GestureExt::set_sequence_state`).

`gesture` must forget everything about `sequence` as a reaction to this signal.

Feature: `v3_14`

## `sequence`
the `gdk::EventSequence` that was cancelled
<!-- trait GestureExt::fn connect_end -->
This signal is emitted when `gesture` either stopped recognizing the event
sequences as something to be handled (the `Gesture::check` handler returned
`false`), or the number of touch sequences became higher or lower than
`Gesture:n-points`.

Note: `sequence` might not pertain to the group of sequences that were
previously triggering recognition on `gesture` (ie. a just pressed touch
sequence that exceeds `Gesture:n-points`). This situation may be detected
by checking through `GestureExt::handles_sequence`.

Feature: `v3_14`

## `sequence`
the `gdk::EventSequence` that made gesture recognition to finish
<!-- trait GestureExt::fn connect_sequence_state_changed -->
This signal is emitted whenever a sequence state changes. See
`GestureExt::set_sequence_state` to know more about the expectable
sequence lifetimes.

Feature: `v3_14`

## `sequence`
the `gdk::EventSequence` that was cancelled
## `state`
the new sequence state
<!-- trait GestureExt::fn connect_update -->
This signal is emitted whenever an event is handled while the gesture is
recognized. `sequence` is guaranteed to pertain to the set of active touches.

Feature: `v3_14`

## `sequence`
the `gdk::EventSequence` that was updated
<!-- trait GestureExt::fn get_property_n-points -->
The number of touch points that trigger recognition on this gesture,

Feature: `v3_14`

<!-- trait GestureExt::fn set_property_n-points -->
The number of touch points that trigger recognition on this gesture,

Feature: `v3_14`

<!-- trait GestureExt::fn get_property_window -->
If non-`None`, the gesture will only listen for events that happen on
this `gdk::Window`, or a child of it.

Feature: `v3_14`

<!-- trait GestureExt::fn set_property_window -->
If non-`None`, the gesture will only listen for events that happen on
this `gdk::Window`, or a child of it.

Feature: `v3_14`

<!-- struct GestureDrag -->
`GestureDrag` is a `Gesture` implementation that recognizes drag
operations. The drag operation itself can be tracked throught the
`GestureDrag::drag-begin`, `GestureDrag::drag-update` and
`GestureDrag::drag-end` signals, or the relevant coordinates be
extracted through `GestureDragExt::get_offset` and
`GestureDragExt::get_start_point`.

Feature: `v3_14`

# Implements

[`GestureDragExt`](trait.GestureDragExt.html), [`GestureSingleExt`](trait.GestureSingleExt.html), [`GestureExt`](trait.GestureExt.html), [`EventControllerExt`](trait.EventControllerExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait GestureDragExt -->
Trait containing all `GestureDrag` methods.

Feature: `v3_14`

# Implementors

[`GestureDrag`](struct.GestureDrag.html), [`GesturePan`](struct.GesturePan.html)
<!-- impl GestureDrag::fn new -->
Returns a newly created `Gesture` that recognizes drags.

Feature: `v3_14`

## `widget`
a `Widget`

# Returns

a newly created `GestureDrag`
<!-- trait GestureDragExt::fn get_offset -->
If the `self` is active, this function returns `true` and
fills in `x` and `y` with the coordinates of the current point,
as an offset to the starting drag point.

Feature: `v3_14`

## `x`
X offset for the current point
## `y`
Y offset for the current point

# Returns

`true` if the gesture is active
<!-- trait GestureDragExt::fn get_start_point -->
If the `self` is active, this function returns `true`
and fills in `x` and `y` with the drag start coordinates,
in window-relative coordinates.

Feature: `v3_14`

## `x`
X coordinate for the drag start point
## `y`
Y coordinate for the drag start point

# Returns

`true` if the gesture is active
<!-- trait GestureDragExt::fn connect_drag_begin -->
This signal is emitted whenever dragging starts.

Feature: `v3_14`

## `start_x`
X coordinate, relative to the widget allocation
## `start_y`
Y coordinate, relative to the widget allocation
<!-- trait GestureDragExt::fn connect_drag_end -->
This signal is emitted whenever the dragging is finished.

Feature: `v3_14`

## `offset_x`
X offset, relative to the start point
## `offset_y`
Y offset, relative to the start point
<!-- trait GestureDragExt::fn connect_drag_update -->
This signal is emitted whenever the dragging point moves.

Feature: `v3_14`

## `offset_x`
X offset, relative to the start point
## `offset_y`
Y offset, relative to the start point
<!-- struct GestureLongPress -->
`GestureLongPress` is a `Gesture` implementation able to recognize
long presses, triggering the `GestureLongPress::pressed` after the
timeout is exceeded.

If the touchpoint is lifted before the timeout passes, or if it drifts
too far of the initial press point, the `GestureLongPress::cancelled`
signal will be emitted.

Feature: `v3_14`

# Implements

[`GestureLongPressExt`](trait.GestureLongPressExt.html), [`GestureSingleExt`](trait.GestureSingleExt.html), [`GestureExt`](trait.GestureExt.html), [`EventControllerExt`](trait.EventControllerExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait GestureLongPressExt -->
Trait containing all `GestureLongPress` methods.

Feature: `v3_14`

# Implementors

[`GestureLongPress`](struct.GestureLongPress.html)
<!-- impl GestureLongPress::fn new -->
Returns a newly created `Gesture` that recognizes long presses.

Feature: `v3_14`

## `widget`
a `Widget`

# Returns

a newly created `GestureLongPress`
<!-- trait GestureLongPressExt::fn connect_cancelled -->
This signal is emitted whenever a press moved too far, or was released
before `GestureLongPress::pressed` happened.

Feature: `v3_14`

<!-- trait GestureLongPressExt::fn connect_pressed -->
This signal is emitted whenever a press goes unmoved/unreleased longer than
what the GTK+ defaults tell.

Feature: `v3_14`

## `x`
the X coordinate where the press happened, relative to the widget allocation
## `y`
the Y coordinate where the press happened, relative to the widget allocation
<!-- struct GestureMultiPress -->
`GestureMultiPress` is a `Gesture` implementation able to recognize
multiple clicks on a nearby zone, which can be listened for through the
`GestureMultiPress::pressed` signal. Whenever time or distance between
clicks exceed the GTK+ defaults, `GestureMultiPress::stopped` is emitted,
and the click counter is reset.

Callers may also restrict the area that is considered valid for a >1
touch/button press through `GestureMultiPressExt::set_area`, so any
click happening outside that area is considered to be a first click of
its own.

Feature: `v3_14`

# Implements

[`GestureMultiPressExt`](trait.GestureMultiPressExt.html), [`GestureSingleExt`](trait.GestureSingleExt.html), [`GestureExt`](trait.GestureExt.html), [`EventControllerExt`](trait.EventControllerExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait GestureMultiPressExt -->
Trait containing all `GestureMultiPress` methods.

Feature: `v3_14`

# Implementors

[`GestureMultiPress`](struct.GestureMultiPress.html)
<!-- impl GestureMultiPress::fn new -->
Returns a newly created `Gesture` that recognizes single and multiple
presses.

Feature: `v3_14`

## `widget`
a `Widget`

# Returns

a newly created `GestureMultiPress`
<!-- trait GestureMultiPressExt::fn get_area -->
If an area was set through `GestureMultiPressExt::set_area`,
this function will return `true` and fill in `rect` with the
press area. See `GestureMultiPressExt::set_area` for more
details on what the press area represents.

Feature: `v3_14`

## `rect`
return location for the press area

# Returns

`true` if `rect` was filled with the press area
<!-- trait GestureMultiPressExt::fn set_area -->
If `rect` is non-`None`, the press area will be checked to be
confined within the rectangle, otherwise the button count
will be reset so the press is seen as being the first one.
If `rect` is `None`, the area will be reset to an unrestricted
state.

Note: The rectangle is only used to determine whether any
non-first click falls within the expected area. This is not
akin to an input shape.

Feature: `v3_14`

## `rect`
rectangle to receive coordinates on
<!-- trait GestureMultiPressExt::fn connect_pressed -->
This signal is emitted whenever a button or touch press happens.

Feature: `v3_14`

## `n_press`
how many touch/button presses happened with this one
## `x`
The X coordinate, in widget allocation coordinates
## `y`
The Y coordinate, in widget allocation coordinates
<!-- trait GestureMultiPressExt::fn connect_released -->
This signal is emitted when a button or touch is released. `n_press`
will report the number of press that is paired to this event, note
that `GestureMultiPress::stopped` may have been emitted between the
press and its release, `n_press` will only start over at the next press.

Feature: `v3_14`

## `n_press`
number of press that is paired with this release
## `x`
The X coordinate, in widget allocation coordinates
## `y`
The Y coordinate, in widget allocation coordinates
<!-- trait GestureMultiPressExt::fn connect_stopped -->
This signal is emitted whenever any time/distance threshold has
been exceeded.

Feature: `v3_14`

<!-- struct GesturePan -->
`GesturePan` is a `Gesture` implementation able to recognize
pan gestures, those are drags that are locked to happen along one
axis. The axis that a `GesturePan` handles is defined at
construct time, and can be changed through
`GesturePanExt::set_orientation`.

When the gesture starts to be recognized, `GesturePan` will
attempt to determine as early as possible whether the sequence
is moving in the expected direction, and denying the sequence if
this does not happen.

Once a panning gesture along the expected axis is recognized,
the `GesturePan::pan` signal will be emitted as input events
are received, containing the offset in the given axis.

Feature: `v3_14`

# Implements

[`GesturePanExt`](trait.GesturePanExt.html), [`GestureDragExt`](trait.GestureDragExt.html), [`GestureSingleExt`](trait.GestureSingleExt.html), [`GestureExt`](trait.GestureExt.html), [`EventControllerExt`](trait.EventControllerExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait GesturePanExt -->
Trait containing all `GesturePan` methods.

Feature: `v3_14`

# Implementors

[`GesturePan`](struct.GesturePan.html)
<!-- impl GesturePan::fn new -->
Returns a newly created `Gesture` that recognizes pan gestures.

Feature: `v3_14`

## `widget`
a `Widget`
## `orientation`
expected orientation

# Returns

a newly created `GesturePan`
<!-- trait GesturePanExt::fn get_orientation -->
Returns the orientation of the pan gestures that this `self` expects.

Feature: `v3_14`


# Returns

the expected orientation for pan gestures
<!-- trait GesturePanExt::fn set_orientation -->
Sets the orientation to be expected on pan gestures.

Feature: `v3_14`

## `orientation`
expected orientation
<!-- trait GesturePanExt::fn connect_pan -->
This signal is emitted once a panning gesture along the
expected axis is detected.

Feature: `v3_14`

## `direction`
current direction of the pan gesture
## `offset`
Offset along the gesture orientation
<!-- trait GesturePanExt::fn get_property_orientation -->
The expected orientation of pan gestures.

Feature: `v3_14`

<!-- trait GesturePanExt::fn set_property_orientation -->
The expected orientation of pan gestures.

Feature: `v3_14`

<!-- struct GestureRotate -->
`GestureRotate` is a `Gesture` implementation able to recognize
2-finger rotations, whenever the angle between both handled sequences
changes, the `GestureRotate::angle-changed` signal is emitted.

Feature: `v3_14`

# Implements

[`GestureRotateExt`](trait.GestureRotateExt.html), [`GestureExt`](trait.GestureExt.html), [`EventControllerExt`](trait.EventControllerExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait GestureRotateExt -->
Trait containing all `GestureRotate` methods.

Feature: `v3_14`

# Implementors

[`GestureRotate`](struct.GestureRotate.html)
<!-- impl GestureRotate::fn new -->
Returns a newly created `Gesture` that recognizes 2-touch
rotation gestures.

Feature: `v3_14`

## `widget`
a `Widget`

# Returns

a newly created `GestureRotate`
<!-- trait GestureRotateExt::fn get_angle_delta -->
If `self` is active, this function returns the angle difference
in radians since the gesture was first recognized. If `self` is
not active, 0 is returned.

Feature: `v3_14`


# Returns

the angle delta in radians
<!-- trait GestureRotateExt::fn connect_angle_changed -->
This signal is emitted when the angle between both tracked points
changes.

Feature: `v3_14`

## `angle`
Current angle in radians
## `angle_delta`
Difference with the starting angle, in radians
<!-- struct GestureSingle -->
`GestureSingle` is a subclass of `Gesture`, optimized (although
not restricted) for dealing with mouse and single-touch gestures. Under
interaction, these gestures stick to the first interacting sequence, which
is accessible through `GestureSingleExt::get_current_sequence` while the
gesture is being interacted with.

By default gestures react to both `GDK_BUTTON_PRIMARY` and touch
events, `GestureSingleExt::set_touch_only` can be used to change the
touch behavior. Callers may also specify a different mouse button number
to interact with through `GestureSingleExt::set_button`, or react to any
mouse button by setting 0. While the gesture is active, the button being
currently pressed can be known through `GestureSingleExt::get_current_button`.

Feature: `v3_14`

# Implements

[`GestureSingleExt`](trait.GestureSingleExt.html), [`GestureExt`](trait.GestureExt.html), [`EventControllerExt`](trait.EventControllerExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait GestureSingleExt -->
Trait containing all `GestureSingle` methods.

Feature: `v3_14`

# Implementors

[`GestureDrag`](struct.GestureDrag.html), [`GestureLongPress`](struct.GestureLongPress.html), [`GestureMultiPress`](struct.GestureMultiPress.html), [`GestureSingle`](struct.GestureSingle.html), [`GestureSwipe`](struct.GestureSwipe.html)
<!-- trait GestureSingleExt::fn get_button -->
Returns the button number `self` listens for, or 0 if `self`
reacts to any button press.

Feature: `v3_14`


# Returns

The button number, or 0 for any button
<!-- trait GestureSingleExt::fn get_current_button -->
Returns the button number currently interacting with `self`, or 0 if there
is none.

Feature: `v3_14`


# Returns

The current button number
<!-- trait GestureSingleExt::fn get_current_sequence -->
Returns the event sequence currently interacting with `self`.
This is only meaningful if `GestureExt::is_active` returns `true`.

Feature: `v3_14`


# Returns

the current sequence
<!-- trait GestureSingleExt::fn get_exclusive -->
Gets whether a gesture is exclusive. For more information, see
`GestureSingleExt::set_exclusive`.

Feature: `v3_14`


# Returns

Whether the gesture is exclusive
<!-- trait GestureSingleExt::fn get_touch_only -->
Returns `true` if the gesture is only triggered by touch events.

Feature: `v3_14`


# Returns

`true` if the gesture only handles touch events
<!-- trait GestureSingleExt::fn set_button -->
Sets the button number `self` listens to. If non-0, every
button press from a different button number will be ignored.
Touch events implicitly match with button 1.

Feature: `v3_14`

## `button`
button number to listen to, or 0 for any button
<!-- trait GestureSingleExt::fn set_exclusive -->
Sets whether `self` is exclusive. An exclusive gesture will
only handle pointer and "pointer emulated" touch events, so at
any given time, there is only one sequence able to interact with
those.

Feature: `v3_14`

## `exclusive`
`true` to make `self` exclusive
<!-- trait GestureSingleExt::fn set_touch_only -->
If `touch_only` is `true`, `self` will only handle events of type
`gdk::EventType::TouchBegin`, `gdk::EventType::TouchUpdate` or `gdk::EventType::TouchEnd`. If `false`,
mouse events will be handled too.

Feature: `v3_14`

## `touch_only`
whether `self` handles only touch events
<!-- trait GestureSingleExt::fn get_property_button -->
Mouse button number to listen to, or 0 to listen for any button.

Feature: `v3_14`

<!-- trait GestureSingleExt::fn set_property_button -->
Mouse button number to listen to, or 0 to listen for any button.

Feature: `v3_14`

<!-- trait GestureSingleExt::fn get_property_exclusive -->
Whether the gesture is exclusive. Exclusive gestures only listen to pointer
and pointer emulated events.

Feature: `v3_14`

<!-- trait GestureSingleExt::fn set_property_exclusive -->
Whether the gesture is exclusive. Exclusive gestures only listen to pointer
and pointer emulated events.

Feature: `v3_14`

<!-- trait GestureSingleExt::fn get_property_touch-only -->
Whether the gesture handles only touch events.

Feature: `v3_14`

<!-- trait GestureSingleExt::fn set_property_touch-only -->
Whether the gesture handles only touch events.

Feature: `v3_14`

<!-- struct GestureSwipe -->
`GestureSwipe` is a `Gesture` implementation able to recognize
swipes, after a press/move/.../move/release sequence happens, the
`GestureSwipe::swipe` signal will be emitted, providing the velocity
and directionality of the sequence at the time it was lifted.

If the velocity is desired in intermediate points,
`GestureSwipeExt::get_velocity` can be called on eg. a
`Gesture::update` handler.

All velocities are reported in pixels/sec units.

Feature: `v3_14`

# Implements

[`GestureSwipeExt`](trait.GestureSwipeExt.html), [`GestureSingleExt`](trait.GestureSingleExt.html), [`GestureExt`](trait.GestureExt.html), [`EventControllerExt`](trait.EventControllerExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait GestureSwipeExt -->
Trait containing all `GestureSwipe` methods.

Feature: `v3_14`

# Implementors

[`GestureSwipe`](struct.GestureSwipe.html)
<!-- impl GestureSwipe::fn new -->
Returns a newly created `Gesture` that recognizes swipes.

Feature: `v3_14`

## `widget`
a `Widget`

# Returns

a newly created `GestureSwipe`
<!-- trait GestureSwipeExt::fn get_velocity -->
If the gesture is recognized, this function returns `true` and fill in
`velocity_x` and `velocity_y` with the recorded velocity, as per the
last event(s) processed.

Feature: `v3_14`

## `velocity_x`
return value for the velocity in the X axis, in pixels/sec
## `velocity_y`
return value for the velocity in the Y axis, in pixels/sec

# Returns

whether velocity could be calculated
<!-- trait GestureSwipeExt::fn connect_swipe -->
This signal is emitted when the recognized gesture is finished, velocity
and direction are a product of previously recorded events.

Feature: `v3_14`

## `velocity_x`
velocity in the X axis, in pixels/sec
## `velocity_y`
velocity in the Y axis, in pixels/sec
<!-- struct GestureZoom -->
`GestureZoom` is a `Gesture` implementation able to recognize
pinch/zoom gestures, whenever the distance between both tracked
sequences changes, the `GestureZoom::scale-changed` signal is
emitted to report the scale factor.

Feature: `v3_14`

# Implements

[`GestureZoomExt`](trait.GestureZoomExt.html), [`GestureExt`](trait.GestureExt.html), [`EventControllerExt`](trait.EventControllerExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait GestureZoomExt -->
Trait containing all `GestureZoom` methods.

Feature: `v3_14`

# Implementors

[`GestureZoom`](struct.GestureZoom.html)
<!-- impl GestureZoom::fn new -->
Returns a newly created `Gesture` that recognizes zoom
in/out gestures (usually known as pinch/zoom).

Feature: `v3_14`

## `widget`
a `Widget`

# Returns

a newly created `GestureZoom`
<!-- trait GestureZoomExt::fn get_scale_delta -->
If `self` is active, this function returns the zooming difference
since the gesture was recognized (hence the starting point is
considered 1:1). If `self` is not active, 1 is returned.

Feature: `v3_14`


# Returns

the scale delta
<!-- trait GestureZoomExt::fn connect_scale_changed -->
This signal is emitted whenever the distance between both tracked
sequences changes.

Feature: `v3_14`

## `scale`
Scale delta, taking the initial state as 1:1
<!-- struct Grid -->
`Grid` is a container which arranges its child widgets in
rows and columns. It is a very similar to `Table` and `Box`,
but it consistently uses `Widget`’s `Widget:margin` and `Widget:expand`
properties instead of custom child properties, and it fully supports
[height-for-width geometry management][geometry-management].

Children are added using `GridExt::attach`. They can span multiple
rows or columns. It is also possible to add a child next to an
existing child, using `GridExt::attach_next_to`. The behaviour of
`Grid` when several children occupy the same grid cell is undefined.

`Grid` can be used like a `Box` by just using `ContainerExt::add`,
which will place children next to each other in the direction determined
by the `Orientable:orientation` property.

# CSS nodes

`Grid` uses a single CSS node with name grid.

# Implements

[`GridExt`](trait.GridExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`OrientableExt`](trait.OrientableExt.html)
<!-- trait GridExt -->
Trait containing all `Grid` methods.

# Implementors

[`Grid`](struct.Grid.html)
<!-- impl Grid::fn new -->
Creates a new grid widget.

# Returns

the new `Grid`
<!-- trait GridExt::fn attach -->
Adds a widget to the grid.

The position of `child` is determined by `left` and `top`. The
number of “cells” that `child` will occupy is determined by
`width` and `height`.
## `child`
the widget to add
## `left`
the column number to attach the left side of `child` to
## `top`
the row number to attach the top side of `child` to
## `width`
the number of columns that `child` will span
## `height`
the number of rows that `child` will span
<!-- trait GridExt::fn attach_next_to -->
Adds a widget to the grid.

The widget is placed next to `sibling`, on the side determined by
`side`. When `sibling` is `None`, the widget is placed in row (for
left or right placement) or column 0 (for top or bottom placement),
at the end indicated by `side`.

Attaching widgets labeled [1], [2], [3] with `sibling` == `None` and
`side` == `PositionType::Left` yields a layout of [3][2][1].
## `child`
the widget to add
## `sibling`
the child of `self` that `child` will be placed
 next to, or `None` to place `child` at the beginning or end
## `side`
the side of `sibling` that `child` is positioned next to
## `width`
the number of columns that `child` will span
## `height`
the number of rows that `child` will span
<!-- trait GridExt::fn get_baseline_row -->
Returns which row defines the global baseline of `self`.

Feature: `v3_10`


# Returns

the row index defining the global baseline
<!-- trait GridExt::fn get_child_at -->
Gets the child of `self` whose area covers the grid
cell whose upper left corner is at `left`, `top`.
## `left`
the left edge of the cell
## `top`
the top edge of the cell

# Returns

the child at the given position, or `None`
<!-- trait GridExt::fn get_column_homogeneous -->
Returns whether all columns of `self` have the same width.

# Returns

whether all columns of `self` have the same width.
<!-- trait GridExt::fn get_column_spacing -->
Returns the amount of space between the columns of `self`.

# Returns

the column spacing of `self`
<!-- trait GridExt::fn get_row_baseline_position -->
Returns the baseline position of `row` as set
by `GridExt::set_row_baseline_position` or the default value
`BaselinePosition::Center`.

Feature: `v3_10`

## `row`
a row index

# Returns

the baseline position of `row`
<!-- trait GridExt::fn get_row_homogeneous -->
Returns whether all rows of `self` have the same height.

# Returns

whether all rows of `self` have the same height.
<!-- trait GridExt::fn get_row_spacing -->
Returns the amount of space between the rows of `self`.

# Returns

the row spacing of `self`
<!-- trait GridExt::fn insert_column -->
Inserts a column at the specified position.

Children which are attached at or to the right of this position
are moved one column to the right. Children which span across this
position are grown to span the new column.
## `position`
the position to insert the column at
<!-- trait GridExt::fn insert_next_to -->
Inserts a row or column at the specified position.

The new row or column is placed next to `sibling`, on the side
determined by `side`. If `side` is `PositionType::Top` or `PositionType::Bottom`,
a row is inserted. If `side` is `PositionType::Left` of `PositionType::Right`,
a column is inserted.
## `sibling`
the child of `self` that the new row or column will be
 placed next to
## `side`
the side of `sibling` that `child` is positioned next to
<!-- trait GridExt::fn insert_row -->
Inserts a row at the specified position.

Children which are attached at or below this position
are moved one row down. Children which span across this
position are grown to span the new row.
## `position`
the position to insert the row at
<!-- trait GridExt::fn remove_column -->
Removes a column from the grid.

Children that are placed in this column are removed,
spanning children that overlap this column have their
width reduced by one, and children after the column
are moved to the left.

Feature: `v3_10`

## `position`
the position of the column to remove
<!-- trait GridExt::fn remove_row -->
Removes a row from the grid.

Children that are placed in this row are removed,
spanning children that overlap this row have their
height reduced by one, and children below the row
are moved up.

Feature: `v3_10`

## `position`
the position of the row to remove
<!-- trait GridExt::fn set_baseline_row -->
Sets which row defines the global baseline for the entire grid.
Each row in the grid can have its own local baseline, but only
one of those is global, meaning it will be the baseline in the
parent of the `self`.

Feature: `v3_10`

## `row`
the row index
<!-- trait GridExt::fn set_column_homogeneous -->
Sets whether all columns of `self` will have the same width.
## `homogeneous`
`true` to make columns homogeneous
<!-- trait GridExt::fn set_column_spacing -->
Sets the amount of space between columns of `self`.
## `spacing`
the amount of space to insert between columns
<!-- trait GridExt::fn set_row_baseline_position -->
Sets how the baseline should be positioned on `row` of the
grid, in case that row is assigned more space than is requested.

Feature: `v3_10`

## `row`
a row index
## `pos`
a `BaselinePosition`
<!-- trait GridExt::fn set_row_homogeneous -->
Sets whether all rows of `self` will have the same height.
## `homogeneous`
`true` to make rows homogeneous
<!-- trait GridExt::fn set_row_spacing -->
Sets the amount of space between rows of `self`.
## `spacing`
the amount of space to insert between rows
<!-- struct HeaderBar -->
`HeaderBar` is similar to a horizontal `Box`. It allows children to
be placed at the start or the end. In addition, it allows a title and
subtitle to be displayed. The title will be centered with respect to
the width of the box, even if the children at either side take up
different amounts of space. The height of the titlebar will be
set to provide sufficient space for the subtitle, even if none is
currently set. If a subtitle is not needed, the space reservation
can be turned off with `HeaderBarExt::set_has_subtitle`.

`HeaderBar` can add typical window frame controls, such as minimize,
maximize and close buttons, or the window icon.

Feature: `v3_10`

# Implements

[`HeaderBarExt`](trait.HeaderBarExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait HeaderBarExt -->
Trait containing all `HeaderBar` methods.

Feature: `v3_10`

# Implementors

[`HeaderBar`](struct.HeaderBar.html)
<!-- impl HeaderBar::fn new -->
Creates a new `HeaderBar` widget.

Feature: `v3_10`


# Returns

a new `HeaderBar`
<!-- trait HeaderBarExt::fn get_custom_title -->
Retrieves the custom title widget of the header. See
`HeaderBarExt::set_custom_title`.

Feature: `v3_10`


# Returns

the custom title widget
 of the header, or `None` if none has been set explicitly.
<!-- trait HeaderBarExt::fn get_decoration_layout -->
Gets the decoration layout set with
`HeaderBarExt::set_decoration_layout`.

Feature: `v3_12`


# Returns

the decoration layout
<!-- trait HeaderBarExt::fn get_has_subtitle -->
Retrieves whether the header bar reserves space for
a subtitle, regardless if one is currently set or not.

Feature: `v3_12`


# Returns

`true` if the header bar reserves space
 for a subtitle
<!-- trait HeaderBarExt::fn get_show_close_button -->
Returns whether this header bar shows the standard window
decorations.

Feature: `v3_10`


# Returns

`true` if the decorations are shown
<!-- trait HeaderBarExt::fn get_subtitle -->
Retrieves the subtitle of the header. See `HeaderBarExt::set_subtitle`.

Feature: `v3_10`


# Returns

the subtitle of the header, or `None` if none has
 been set explicitly. The returned string is owned by the widget
 and must not be modified or freed.
<!-- trait HeaderBarExt::fn get_title -->
Retrieves the title of the header. See `HeaderBarExt::set_title`.

Feature: `v3_10`


# Returns

the title of the header, or `None` if none has
 been set explicitly. The returned string is owned by the widget
 and must not be modified or freed.
<!-- trait HeaderBarExt::fn pack_end -->
Adds `child` to `self`, packed with reference to the
end of the `self`.

Feature: `v3_10`

## `child`
the `Widget` to be added to `self`
<!-- trait HeaderBarExt::fn pack_start -->
Adds `child` to `self`, packed with reference to the
start of the `self`.

Feature: `v3_10`

## `child`
the `Widget` to be added to `self`
<!-- trait HeaderBarExt::fn set_custom_title -->
Sets a custom title for the `HeaderBar`.

The title should help a user identify the current view. This
supersedes any title set by `HeaderBarExt::set_title` or
`HeaderBarExt::set_subtitle`. To achieve the same style as
the builtin title and subtitle, use the “title” and “subtitle”
style classes.

You should set the custom title to `None`, for the header title
label to be visible again.

Feature: `v3_10`

## `title_widget`
a custom widget to use for a title
<!-- trait HeaderBarExt::fn set_decoration_layout -->
Sets the decoration layout for this header bar, overriding
the `Settings:gtk-decoration-layout` setting.

There can be valid reasons for overriding the setting, such
as a header bar design that does not allow for buttons to take
room on the right, or only offers room for a single close button.
Split header bars are another example for overriding the
setting.

The format of the string is button names, separated by commas.
A colon separates the buttons that should appear on the left
from those on the right. Recognized button names are minimize,
maximize, close, icon (the window icon) and menu (a menu button
for the fallback app menu).

For example, “menu:minimize,maximize,close” specifies a menu
on the left, and minimize, maximize and close buttons on the right.

Feature: `v3_12`

## `layout`
a decoration layout, or `None` to
 unset the layout
<!-- trait HeaderBarExt::fn set_has_subtitle -->
Sets whether the header bar should reserve space
for a subtitle, even if none is currently set.

Feature: `v3_12`

## `setting`
`true` to reserve space for a subtitle
<!-- trait HeaderBarExt::fn set_show_close_button -->
Sets whether this header bar shows the standard window decorations,
including close, maximize, and minimize.

Feature: `v3_10`

## `setting`
`true` to show standard window decorations
<!-- trait HeaderBarExt::fn set_subtitle -->
Sets the subtitle of the `HeaderBar`. The title should give a user
an additional detail to help him identify the current view.

Note that `HeaderBar` by default reserves room for the subtitle,
even if none is currently set. If this is not desired, set the
`HeaderBar:has-subtitle` property to `false`.

Feature: `v3_10`

## `subtitle`
a subtitle, or `None`
<!-- trait HeaderBarExt::fn set_title -->
Sets the title of the `HeaderBar`. The title should help a user
identify the current view. A good title should not include the
application name.

Feature: `v3_10`

## `title`
a title, or `None`
<!-- trait HeaderBarExt::fn get_property_decoration-layout -->
The decoration layout for buttons. If this property is
not set, the `Settings:gtk-decoration-layout` setting
is used.

See `HeaderBarExt::set_decoration_layout` for information
about the format of this string.

Feature: `v3_12`

<!-- trait HeaderBarExt::fn set_property_decoration-layout -->
The decoration layout for buttons. If this property is
not set, the `Settings:gtk-decoration-layout` setting
is used.

See `HeaderBarExt::set_decoration_layout` for information
about the format of this string.

Feature: `v3_12`

<!-- trait HeaderBarExt::fn get_property_decoration-layout-set -->
Set to `true` if `HeaderBar:decoration-layout` is set.

Feature: `v3_12`

<!-- trait HeaderBarExt::fn set_property_decoration-layout-set -->
Set to `true` if `HeaderBar:decoration-layout` is set.

Feature: `v3_12`

<!-- trait HeaderBarExt::fn get_property_has-subtitle -->
If `true`, reserve space for a subtitle, even if none
is currently set.

Feature: `v3_12`

<!-- trait HeaderBarExt::fn set_property_has-subtitle -->
If `true`, reserve space for a subtitle, even if none
is currently set.

Feature: `v3_12`

<!-- trait HeaderBarExt::fn get_property_show-close-button -->
Whether to show window decorations.

Which buttons are actually shown and where is determined
by the `HeaderBar:decoration-layout` property, and by
the state of the window (e.g. a close button will not be
shown if the window can't be closed).
<!-- trait HeaderBarExt::fn set_property_show-close-button -->
Whether to show window decorations.

Which buttons are actually shown and where is determined
by the `HeaderBar:decoration-layout` property, and by
the state of the window (e.g. a close button will not be
shown if the window can't be closed).
<!-- struct IMContext -->
`IMContext` defines the interface for GTK+ input methods. An input method
is used by GTK+ text input widgets like `Entry` to map from key events to
Unicode character strings.

The default input method can be set programmatically via the
`Settings:gtk-im-module` `Settings` property. Alternatively, you may set
the GTK_IM_MODULE environment variable as documented in
[Running GTK+ Applications][gtk-running].

The `Entry` `Entry:im-module` and `TextView` `TextView:im-module`
properties may also be used to set input methods for specific widget
instances. For instance, a certain entry widget might be expected to contain
certain characters which would be easier to input with a certain input
method.

An input method may consume multiple key events in sequence and finally
output the composed result. This is called preediting, and an input method
may provide feedback about this process by displaying the intermediate
composition states as preedit text. For instance, the default GTK+ input
method implements the input of arbitrary Unicode code points by holding down
the Control and Shift keys and then typing “U” followed by the hexadecimal
digits of the code point. When releasing the Control and Shift keys,
preediting ends and the character is inserted as text. Ctrl+Shift+u20AC for
example results in the € sign.

Additional input methods can be made available for use by GTK+ widgets as
loadable modules. An input method module is a small shared library which
implements a subclass of `IMContext` or `IMContextSimple` and exports
these four functions:


```C
void im_module_init(GTypeModule *module);
```
This function should register the `glib::Type` of the `IMContext` subclass which
implements the input method by means of `gobject::TypeModule::register_type`. Note
that `g_type_register_static` cannot be used as the type needs to be
registered dynamically.


```C
void im_module_exit(void);
```
Here goes any cleanup code your input method might require on module unload.


```C
void im_module_list(const GtkIMContextInfo ***contexts, int *n_contexts)
{
  *contexts = info_list;
  *n_contexts = G_N_ELEMENTS (info_list);
}
```
This function returns the list of input methods provided by the module. The
example implementation above shows a common solution and simply returns a
pointer to statically defined array of `IMContextInfo` items for each
provided input method.


```C
GtkIMContext * im_module_create(const gchar *context_id);
```
This function should return a pointer to a newly created instance of the
`IMContext` subclass identified by `context_id`. The context ID is the same
as specified in the `IMContextInfo` array returned by `im_module_list`.

After a new loadable input method module has been installed on the system,
the configuration file `gtk.immodules` needs to be
regenerated by [gtk-query-immodules-3.0][gtk-query-immodules-3.0],
in order for the new input method to become available to GTK+ applications.

# Implements

[`IMContextExt`](trait.IMContextExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait IMContextExt -->
Trait containing all `IMContext` methods.

# Implementors

[`IMContext`](struct.IMContext.html), [`IMMulticontext`](struct.IMMulticontext.html)
<!-- trait IMContextExt::fn delete_surrounding -->
Asks the widget that the input context is attached to to delete
characters around the cursor position by emitting the
`IMContext`::delete_surrounding signal. Note that `offset` and `n_chars`
are in characters not in bytes which differs from the usage other
places in `IMContext`.

In order to use this function, you should first call
`IMContextExt::get_surrounding` to get the current context, and
call this function immediately afterwards to make sure that you
know what you are deleting. You should also account for the fact
that even if the signal was handled, the input context might not
have deleted all the characters that were requested to be deleted.

This function is used by an input method that wants to make
subsitutions in the existing text in response to new input. It is
not useful for applications.
## `offset`
offset from cursor position in chars;
 a negative value means start before the cursor.
## `n_chars`
number of characters to delete.

# Returns

`true` if the signal was handled.
<!-- trait IMContextExt::fn filter_keypress -->
Allow an input method to internally handle key press and release
events. If this function returns `true`, then no further processing
should be done for this key event.
## `event`
the key event

# Returns

`true` if the input method handled the key event.
<!-- trait IMContextExt::fn focus_in -->
Notify the input method that the widget to which this
input context corresponds has gained focus. The input method
may, for example, change the displayed feedback to reflect
this change.
<!-- trait IMContextExt::fn focus_out -->
Notify the input method that the widget to which this
input context corresponds has lost focus. The input method
may, for example, change the displayed feedback or reset the contexts
state to reflect this change.
<!-- trait IMContextExt::fn get_preedit_string -->
Retrieve the current preedit string for the input context,
and a list of attributes to apply to the string.
This string should be displayed inserted at the insertion
point.
## `str`
location to store the retrieved
 string. The string retrieved must be freed with `g_free`.
## `attrs`
location to store the retrieved
 attribute list. When you are done with this list, you
 must unreference it with `pango::AttrList::unref`.
## `cursor_pos`
location to store position of cursor (in characters)
 within the preedit string.
<!-- trait IMContextExt::fn get_surrounding -->
Retrieves context around the insertion point. Input methods
typically want context in order to constrain input text based on
existing text; this is important for languages such as Thai where
only some sequences of characters are allowed.

This function is implemented by emitting the
`IMContext`::retrieve_surrounding signal on the input method; in
response to this signal, a widget should provide as much context as
is available, up to an entire paragraph, by calling
`IMContextExt::set_surrounding`. Note that there is no obligation
for a widget to respond to the ::retrieve_surrounding signal, so input
methods must be prepared to function without context.
## `text`
location to store a UTF-8 encoded
 string of text holding context around the insertion point.
 If the function returns `true`, then you must free the result
 stored in this location with `g_free`.
## `cursor_index`
location to store byte index of the insertion
 cursor within `text`.

# Returns

`true` if surrounding text was provided; in this case
 you must free the result stored in *text.
<!-- trait IMContextExt::fn reset -->
Notify the input method that a change such as a change in cursor
position has been made. This will typically cause the input
method to clear the preedit state.
<!-- trait IMContextExt::fn set_client_window -->
Set the client window for the input context; this is the
`gdk::Window` in which the input appears. This window is
used in order to correctly position status windows, and may
also be used for purposes internal to the input method.
## `window`
the client window. This may be `None` to indicate
 that the previous client window no longer exists.
<!-- trait IMContextExt::fn set_cursor_location -->
Notify the input method that a change in cursor
position has been made. The location is relative to the client
window.
## `area`
new location
<!-- trait IMContextExt::fn set_surrounding -->
Sets surrounding context around the insertion point and preedit
string. This function is expected to be called in response to the
`IMContext`::retrieve_surrounding signal, and will likely have no
effect if called at other times.
## `text`
text surrounding the insertion point, as UTF-8.
 the preedit string should not be included within
 `text`.
## `len`
the length of `text`, or -1 if `text` is nul-terminated
## `cursor_index`
the byte index of the insertion cursor within `text`.
<!-- trait IMContextExt::fn set_use_preedit -->
Sets whether the IM context should use the preedit string
to display feedback. If `use_preedit` is FALSE (default
is TRUE), then the IM context may use some other method to display
feedback, such as displaying it in a child of the root window.
## `use_preedit`
whether the IM context should use the preedit string.
<!-- trait IMContextExt::fn connect_commit -->
The ::commit signal is emitted when a complete input sequence
has been entered by the user. This can be a single character
immediately after a key press or the final result of preediting.
## `str`
the completed character(s) entered by the user
<!-- trait IMContextExt::fn connect_delete_surrounding -->
The ::delete-surrounding signal is emitted when the input method
needs to delete all or part of the context surrounding the cursor.
## `offset`
the character offset from the cursor position of the text
 to be deleted. A negative value indicates a position before
 the cursor.
## `n_chars`
the number of characters to be deleted

# Returns

`true` if the signal was handled.
<!-- trait IMContextExt::fn connect_preedit_changed -->
The ::preedit-changed signal is emitted whenever the preedit sequence
currently being entered has changed. It is also emitted at the end of
a preedit sequence, in which case
`IMContextExt::get_preedit_string` returns the empty string.
<!-- trait IMContextExt::fn connect_preedit_end -->
The ::preedit-end signal is emitted when a preediting sequence
has been completed or canceled.
<!-- trait IMContextExt::fn connect_preedit_start -->
The ::preedit-start signal is emitted when a new preediting sequence
starts.
<!-- trait IMContextExt::fn connect_retrieve_surrounding -->
The ::retrieve-surrounding signal is emitted when the input method
requires the context surrounding the cursor. The callback should set
the input method surrounding context by calling the
`IMContextExt::set_surrounding` method.

# Returns

`true` if the signal was handled.
<!-- struct IMMulticontext -->


# Implements

[`IMMulticontextExt`](trait.IMMulticontextExt.html), [`IMContextExt`](trait.IMContextExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait IMMulticontextExt -->
Trait containing all `IMMulticontext` methods.

# Implementors

[`IMMulticontext`](struct.IMMulticontext.html)
<!-- impl IMMulticontext::fn new -->
Creates a new `IMMulticontext`.

# Returns

a new `IMMulticontext`.
<!-- trait IMMulticontextExt::fn append_menuitems -->
Add menuitems for various available input methods to a menu;
the menuitems, when selected, will switch the input method
for the context and the global default input method.

# Deprecated since 3.10

It is better to use the system-wide input
 method framework for changing input methods. Modern
 desktop shells offer on-screen displays for this that
 can triggered with a keyboard shortcut, e.g. Super-Space.
## `menushell`
a `MenuShell`
<!-- trait IMMulticontextExt::fn get_context_id -->
Gets the id of the currently active slave of the `self`.

# Returns

the id of the currently active slave
<!-- trait IMMulticontextExt::fn set_context_id -->
Sets the context id for `self`.

This causes the currently active slave of `self` to be
replaced by the slave corresponding to the new context id.
## `context_id`
the id to use
<!-- enum IMPreeditStyle -->
Style for input method preedit. See also
`Settings:gtk-im-preedit-style`

# Deprecated since 3.10

<!-- enum IMPreeditStyle::variant Nothing -->
Deprecated
<!-- enum IMPreeditStyle::variant Callback -->
Deprecated
<!-- enum IMPreeditStyle::variant None -->
Deprecated
<!-- enum IMStatusStyle -->
Style for input method status. See also
`Settings:gtk-im-status-style`

# Deprecated since 3.10

<!-- enum IMStatusStyle::variant Nothing -->
Deprecated
<!-- enum IMStatusStyle::variant Callback -->
Deprecated
<!-- enum IMStatusStyle::variant None -->
Deprecated
<!-- struct IconFactory -->
`[Deprecated since 3.10]` An icon factory manages a collection of `IconSet`; a `IconSet` manages a
set of variants of a particular icon (i.e. a `IconSet` contains variants for
different sizes and widget states). Icons in an icon factory are named by a
stock ID, which is a simple string identifying the icon. Each `Style` has a
list of `IconFactory` derived from the current theme; those icon factories
are consulted first when searching for an icon. If the theme doesn’t set a
particular icon, GTK+ looks for the icon in a list of default icon factories,
maintained by `IconFactoryExt::add_default` and
`IconFactoryExt::remove_default`. Applications with icons should add a default
icon factory with their icons, which will allow themes to override the icons
for the application.

To display an icon, always use `Style::lookup_icon_set` on the widget that
will display the icon, or the convenience function
`Widget::render_icon`. These functions take the theme into account when
looking up the icon to use for a given stock ID.

# `IconFactory` as `Buildable` # {`IconFactory`-BUILDER-UI}

`IconFactory` supports a custom `<sources>` element, which can contain
multiple `<source>` elements. The following attributes are allowed:

- stock-id

 The stock id of the source, a string. This attribute is
 mandatory

- filename

 The filename of the source, a string. This attribute is
 optional

- icon-name

 The icon name for the source, a string. This attribute is
 optional.

- size

 Size of the icon, a `IconSize` enum value. This attribute is
 optional.

- direction

 Direction of the source, a `TextDirection` enum value. This
 attribute is optional.

- state

 State of the source, a `StateType` enum value. This
 attribute is optional.


## A `IconFactory` UI definition fragment. ##


```text
<object class="GtkIconFactory" id="iconfactory1">
  <sources>
    <source stock-id="apple-red" filename="apple-red.png"/>
  </sources>
</object>
<object class="GtkWindow" id="window1">
  <child>
    <object class="GtkButton" id="apple_button">
      <property name="label">apple-red</property>
      <property name="use-stock">True</property>
    </object>
  </child>
</object>
```

# Implements

[`IconFactoryExt`](trait.IconFactoryExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait IconFactoryExt -->
`[Deprecated since 3.10]` Trait containing all `IconFactory` methods.

# Implementors

[`IconFactory`](struct.IconFactory.html)
<!-- impl IconFactory::fn new -->
Creates a new `IconFactory`. An icon factory manages a collection
of ``GtkIconSets``; a `IconSet` manages a set of variants of a
particular icon (i.e. a `IconSet` contains variants for different
sizes and widget states). Icons in an icon factory are named by a
stock ID, which is a simple string identifying the icon. Each
`Style` has a list of ``GtkIconFactorys`` derived from the current
theme; those icon factories are consulted first when searching for
an icon. If the theme doesn’t set a particular icon, GTK+ looks for
the icon in a list of default icon factories, maintained by
`IconFactoryExt::add_default` and
`IconFactoryExt::remove_default`. Applications with icons should
add a default icon factory with their icons, which will allow
themes to override the icons for the application.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

a new `IconFactory`
<!-- impl IconFactory::fn lookup_default -->
Looks for an icon in the list of default icon factories. For
display to the user, you should use `Style::lookup_icon_set` on
the `Style` for the widget that will display the icon, instead of
using this function directly, so that themes are taken into
account.

# Deprecated since 3.10

Use `IconTheme` instead.
## `stock_id`
an icon name

# Returns

a `IconSet`, or `None`
<!-- trait IconFactoryExt::fn add -->
Adds the given `icon_set` to the icon factory, under the name
`stock_id`. `stock_id` should be namespaced for your application,
e.g. “myapp-whatever-icon”. Normally applications create a
`IconFactory`, then add it to the list of default factories with
`IconFactoryExt::add_default`. Then they pass the `stock_id` to
widgets such as `Image` to display the icon. Themes can provide
an icon with the same name (such as "myapp-whatever-icon") to
override your application’s default icons. If an icon already
existed in `self` for `stock_id`, it is unreferenced and replaced
with the new `icon_set`.

# Deprecated since 3.10

Use `IconTheme` instead.
## `stock_id`
icon name
## `icon_set`
icon set
<!-- trait IconFactoryExt::fn add_default -->
Adds an icon factory to the list of icon factories searched by
`Style::lookup_icon_set`. This means that, for example,
`Image::new_from_stock` will be able to find icons in `self`.
There will normally be an icon factory added for each library or
application that comes with icons. The default icon factories
can be overridden by themes.

# Deprecated since 3.10

Use `IconTheme` instead.
<!-- trait IconFactoryExt::fn lookup -->
Looks up `stock_id` in the icon factory, returning an icon set
if found, otherwise `None`. For display to the user, you should
use `Style::lookup_icon_set` on the `Style` for the
widget that will display the icon, instead of using this
function directly, so that themes are taken into account.

# Deprecated since 3.10

Use `IconTheme` instead.
## `stock_id`
an icon name

# Returns

icon set of `stock_id`.
<!-- trait IconFactoryExt::fn remove_default -->
Removes an icon factory from the list of default icon
factories. Not normally used; you might use it for a library that
can be unloaded or shut down.

# Deprecated since 3.10

Use `IconTheme` instead.
<!-- struct IconInfo -->
Contains information found when looking up an icon in
an icon theme.

# Implements

[`IconInfoExt`](trait.IconInfoExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait IconInfoExt -->
Trait containing all `IconInfo` methods.

# Implementors

[`IconInfo`](struct.IconInfo.html)
<!-- impl IconInfo::fn new_for_pixbuf -->
Creates a `IconInfo` for a `gdk_pixbuf::Pixbuf`.
## `icon_theme`
a `IconTheme`
## `pixbuf`
the pixbuf to wrap in a `IconInfo`

# Returns

a `IconInfo`
<!-- trait IconInfoExt::fn copy -->
Make a copy of a `IconInfo`.

# Deprecated since 3.8

Use `gobject::ObjectExt::ref`

# Returns

the new `IconInfo`
<!-- trait IconInfoExt::fn free -->
Free a `IconInfo` and associated information

# Deprecated since 3.8

Use `gobject::ObjectExt::unref`
<!-- trait IconInfoExt::fn get_attach_points -->
This function is deprecated and always returns `false`.

# Deprecated since 3.14

Attachment points are deprecated
## `points`
location to store pointer
 to an array of points, or `None` free the array of points with `g_free`.
## `n_points`
location to store the number of points in `points`,
 or `None`

# Returns

`false`
<!-- trait IconInfoExt::fn get_base_scale -->
Gets the base scale for the icon. The base scale is a scale
for the icon that was specified by the icon theme creator.
For instance an icon drawn for a high-dpi screen with window
scale 2 for a base size of 32 will be 64 pixels tall and have
a base scale of 2.

Feature: `v3_10`


# Returns

the base scale
<!-- trait IconInfoExt::fn get_base_size -->
Gets the base size for the icon. The base size
is a size for the icon that was specified by
the icon theme creator. This may be different
than the actual size of image; an example of
this is small emblem icons that can be attached
to a larger icon. These icons will be given
the same base size as the larger icons to which
they are attached.

Note that for scaled icons the base size does
not include the base scale.

# Returns

the base size, or 0, if no base
 size is known for the icon.
<!-- trait IconInfoExt::fn get_builtin_pixbuf -->
Gets the built-in image for this icon, if any. To allow GTK+ to use
built in icon images, you must pass the `IconLookupFlags::UseBuiltin`
to `IconThemeExt::lookup_icon`.

# Deprecated since 3.14

This function is deprecated, use
 `IconThemeExt::add_resource_path` instead of builtin icons.

# Returns

the built-in image pixbuf, or `None`.
 No extra reference is added to the returned pixbuf, so if
 you want to keep it around, you must use `gobject::ObjectExt::ref`.
 The returned image must not be modified.
<!-- trait IconInfoExt::fn get_display_name -->
This function is deprecated and always returns `None`.

# Deprecated since 3.14

Display names are deprecated

# Returns

`None`
<!-- trait IconInfoExt::fn get_embedded_rect -->
This function is deprecated and always returns `false`.

# Deprecated since 3.14

Embedded rectangles are deprecated
## `rectangle`
`gdk::Rectangle` in which to store embedded
 rectangle coordinates; coordinates are only stored
 when this function returns `true`.

# Returns

`false`
<!-- trait IconInfoExt::fn get_filename -->
Gets the filename for the icon. If the `IconLookupFlags::UseBuiltin`
flag was passed to `IconThemeExt::lookup_icon`, there may be no
filename if a builtin icon is returned; in this case, you should
use `IconInfoExt::get_builtin_pixbuf`.

# Returns

the filename for the icon, or `None`
 if `IconInfoExt::get_builtin_pixbuf` should be used instead.
 The return value is owned by GTK+ and should not be modified
 or freed.
<!-- trait IconInfoExt::fn is_symbolic -->
Checks if the icon is symbolic or not. This currently uses only
the file name and not the file contents for determining this.
This behaviour may change in the future.

Feature: `v3_12`


# Returns

`true` if the icon is symbolic, `false` otherwise
<!-- trait IconInfoExt::fn load_icon -->
Renders an icon previously looked up in an icon theme using
`IconThemeExt::lookup_icon`; the size will be based on the size
passed to `IconThemeExt::lookup_icon`. Note that the resulting
pixbuf may not be exactly this size; an icon theme may have icons
that differ slightly from their nominal sizes, and in addition GTK+
will avoid scaling icons that it considers sufficiently close to the
requested size or for which the source image would have to be scaled
up too far. (This maintains sharpness.). This behaviour can be changed
by passing the `IconLookupFlags::ForceSize` flag when obtaining
the `IconInfo`. If this flag has been specified, the pixbuf
returned by this function will be scaled to the exact size.

# Returns

the rendered icon; this may be a newly
 created icon or a new reference to an internal icon, so you must
 not modify the icon. Use `gobject::ObjectExt::unref` to release your reference
 to the icon.
<!-- trait IconInfoExt::fn load_icon_async -->
Asynchronously load, render and scale an icon previously looked up
from the icon theme using `IconThemeExt::lookup_icon`.

For more details, see `IconInfoExt::load_icon` which is the synchronous
version of this call.

Feature: `v3_8`

## `cancellable`
optional `gio::Cancellable` object, `None` to ignore
## `callback`
a `GAsyncReadyCallback` to call when the
 request is satisfied
## `user_data`
the data to pass to callback function
<!-- trait IconInfoExt::fn load_icon_finish -->
Finishes an async icon load, see `IconInfoExt::load_icon_async`.

Feature: `v3_8`

## `res`
a `gio::AsyncResult`

# Returns

the rendered icon; this may be a newly
 created icon or a new reference to an internal icon, so you must
 not modify the icon. Use `gobject::ObjectExt::unref` to release your reference
 to the icon.
<!-- trait IconInfoExt::fn load_surface -->
Renders an icon previously looked up in an icon theme using
`IconThemeExt::lookup_icon`; the size will be based on the size
passed to `IconThemeExt::lookup_icon`. Note that the resulting
surface may not be exactly this size; an icon theme may have icons
that differ slightly from their nominal sizes, and in addition GTK+
will avoid scaling icons that it considers sufficiently close to the
requested size or for which the source image would have to be scaled
up too far. (This maintains sharpness.). This behaviour can be changed
by passing the `IconLookupFlags::ForceSize` flag when obtaining
the `IconInfo`. If this flag has been specified, the pixbuf
returned by this function will be scaled to the exact size.

Feature: `v3_10`

## `for_window`
`gdk::Window` to optimize drawing for, or `None`

# Returns

the rendered icon; this may be a newly
 created icon or a new reference to an internal icon, so you must
 not modify the icon. Use `cairo_surface_destroy` to release your
 reference to the icon.
<!-- trait IconInfoExt::fn load_symbolic -->
Loads an icon, modifying it to match the system colours for the foreground,
success, warning and error colors provided. If the icon is not a symbolic
one, the function will return the result from `IconInfoExt::load_icon`.

This allows loading symbolic icons that will match the system theme.

Unless you are implementing a widget, you will want to use
`gio::ThemedIcon::new_with_default_fallbacks` to load the icon.

As implementation details, the icon loaded needs to be of SVG type,
contain the “symbolic” term as the last component of the icon name,
and use the “fg”, “success”, “warning” and “error” CSS styles in the
SVG file itself.

See the [Symbolic Icons Specification](http://www.freedesktop.org/wiki/SymbolicIcons)
for more information about symbolic icons.
## `fg`
a `gdk::RGBA` representing the foreground color of the icon
## `success_color`
a `gdk::RGBA` representing the warning color
 of the icon or `None` to use the default color
## `warning_color`
a `gdk::RGBA` representing the warning color
 of the icon or `None` to use the default color
## `error_color`
a `gdk::RGBA` representing the error color
 of the icon or `None` to use the default color (allow-none)
## `was_symbolic`
a `gboolean`, returns whether the
 loaded icon was a symbolic one and whether the `fg` color was
 applied to it.

# Returns

a `gdk_pixbuf::Pixbuf` representing the loaded icon
<!-- trait IconInfoExt::fn load_symbolic_async -->
Asynchronously load, render and scale a symbolic icon previously looked up
from the icon theme using `IconThemeExt::lookup_icon`.

For more details, see `IconInfoExt::load_symbolic` which is the synchronous
version of this call.

Feature: `v3_8`

## `fg`
a `gdk::RGBA` representing the foreground color of the icon
## `success_color`
a `gdk::RGBA` representing the warning color
 of the icon or `None` to use the default color
## `warning_color`
a `gdk::RGBA` representing the warning color
 of the icon or `None` to use the default color
## `error_color`
a `gdk::RGBA` representing the error color
 of the icon or `None` to use the default color (allow-none)
## `cancellable`
optional `gio::Cancellable` object,
 `None` to ignore
## `callback`
a `GAsyncReadyCallback` to call when the
 request is satisfied
## `user_data`
the data to pass to callback function
<!-- trait IconInfoExt::fn load_symbolic_finish -->
Finishes an async icon load, see `IconInfoExt::load_symbolic_async`.

Feature: `v3_8`

## `res`
a `gio::AsyncResult`
## `was_symbolic`
a `gboolean`, returns whether the
 loaded icon was a symbolic one and whether the `fg` color was
 applied to it.

# Returns

the rendered icon; this may be a newly
 created icon or a new reference to an internal icon, so you must
 not modify the icon. Use `gobject::ObjectExt::unref` to release your reference
 to the icon.
<!-- trait IconInfoExt::fn load_symbolic_for_context -->
Loads an icon, modifying it to match the system colors for the foreground,
success, warning and error colors provided. If the icon is not a symbolic
one, the function will return the result from `IconInfoExt::load_icon`.
This function uses the regular foreground color and the symbolic colors
with the names “success_color”, “warning_color” and “error_color” from
the context.

This allows loading symbolic icons that will match the system theme.

See `IconInfoExt::load_symbolic` for more details.
## `context`
a `StyleContext`
## `was_symbolic`
a `gboolean`, returns whether the
 loaded icon was a symbolic one and whether the `fg` color was
 applied to it.

# Returns

a `gdk_pixbuf::Pixbuf` representing the loaded icon
<!-- trait IconInfoExt::fn load_symbolic_for_context_async -->
Asynchronously load, render and scale a symbolic icon previously
looked up from the icon theme using `IconThemeExt::lookup_icon`.

For more details, see `IconInfoExt::load_symbolic_for_context`
which is the synchronous version of this call.

Feature: `v3_8`

## `context`
a `StyleContext`
## `cancellable`
optional `gio::Cancellable` object,
 `None` to ignore
## `callback`
a `GAsyncReadyCallback` to call when the
 request is satisfied
## `user_data`
the data to pass to callback function
<!-- trait IconInfoExt::fn load_symbolic_for_context_finish -->
Finishes an async icon load, see `IconInfoExt::load_symbolic_for_context_async`.

Feature: `v3_8`

## `res`
a `gio::AsyncResult`
## `was_symbolic`
a `gboolean`, returns whether the
 loaded icon was a symbolic one and whether the `fg` color was
 applied to it.

# Returns

the rendered icon; this may be a newly
 created icon or a new reference to an internal icon, so you must
 not modify the icon. Use `gobject::ObjectExt::unref` to release your reference
 to the icon.
<!-- trait IconInfoExt::fn load_symbolic_for_style -->
Loads an icon, modifying it to match the system colours for the foreground,
success, warning and error colors provided. If the icon is not a symbolic
one, the function will return the result from `IconInfoExt::load_icon`.

This allows loading symbolic icons that will match the system theme.

See `IconInfoExt::load_symbolic` for more details.

# Deprecated since 3.0

Use `IconInfoExt::load_symbolic_for_context` instead
## `style`
a `Style` to take the colors from
## `state`
the widget state to use for colors
## `was_symbolic`
a `gboolean`, returns whether the
 loaded icon was a symbolic one and whether the `fg` color was
 applied to it.

# Returns

a `gdk_pixbuf::Pixbuf` representing the loaded icon
<!-- trait IconInfoExt::fn set_raw_coordinates -->
Sets whether the coordinates returned by `IconInfoExt::get_embedded_rect`
and `IconInfoExt::get_attach_points` should be returned in their
original form as specified in the icon theme, instead of scaled
appropriately for the pixbuf returned by `IconInfoExt::load_icon`.

Raw coordinates are somewhat strange; they are specified to be with
respect to the unscaled pixmap for PNG and XPM icons, but for SVG
icons, they are in a 1000x1000 coordinate space that is scaled
to the final size of the icon. You can determine if the icon is an SVG
icon by using `IconInfoExt::get_filename`, and seeing if it is non-`None`
and ends in “.svg”.

This function is provided primarily to allow compatibility wrappers
for older API's, and is not expected to be useful for applications.

# Deprecated since 3.14

Embedded rectangles and attachment points are deprecated
## `raw_coordinates`
whether the coordinates of embedded rectangles
 and attached points should be returned in their original
 (unscaled) form.
<!-- struct IconSet -->

# Deprecated since 3.10

<!-- impl IconSet::fn new -->
Creates a new `IconSet`. A `IconSet` represents a single icon
in various sizes and widget states. It can provide a `gdk_pixbuf::Pixbuf`
for a given size and state on request, and automatically caches
some of the rendered `gdk_pixbuf::Pixbuf` objects.

Normally you would use `WidgetExt::render_icon_pixbuf` instead of
using `IconSet` directly. The one case where you’d use
`IconSet` is to create application-specific icon sets to place in
a `IconFactory`.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

a new `IconSet`
<!-- impl IconSet::fn new_from_pixbuf -->
Creates a new `IconSet` with `pixbuf` as the default/fallback
source image. If you don’t add any additional `IconSource` to the
icon set, all variants of the icon will be created from `pixbuf`,
using scaling, pixelation, etc. as required to adjust the icon size
or make the icon look insensitive/prelighted.

# Deprecated since 3.10

Use `IconTheme` instead.
## `pixbuf`
a `gdk_pixbuf::Pixbuf`

# Returns

a new `IconSet`
<!-- impl IconSet::fn add_source -->
Icon sets have a list of `IconSource`, which they use as base
icons for rendering icons in different states and sizes. Icons are
scaled, made to look insensitive, etc. in
`IconSet::render_icon`, but `IconSet` needs base images to
work with. The base images and when to use them are described by
a `IconSource`.

This function copies `source`, so you can reuse the same source immediately
without affecting the icon set.

An example of when you’d use this function: a web browser’s "Back
to Previous Page" icon might point in a different direction in
Hebrew and in English; it might look different when insensitive;
and it might change size depending on toolbar mode (small/large
icons). So a single icon set would contain all those variants of
the icon, and you might add a separate source for each one.

You should nearly always add a “default” icon source with all
fields wildcarded, which will be used as a fallback if no more
specific source matches. `IconSet` always prefers more specific
icon sources to more generic icon sources. The order in which you
add the sources to the icon set does not matter.

`IconSet::new_from_pixbuf` creates a new icon set with a
default icon source based on the given pixbuf.

# Deprecated since 3.10

Use `IconTheme` instead.
## `source`
a `IconSource`
<!-- impl IconSet::fn copy -->
Copies `self` by value.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

a new `IconSet` identical to the first.
<!-- impl IconSet::fn get_sizes -->
Obtains a list of icon sizes this icon set can render. The returned
array must be freed with `g_free`.

# Deprecated since 3.10

Use `IconTheme` instead.
## `sizes`
return location
 for array of sizes (`IconSize`)
## `n_sizes`
location to store number of elements in returned array
<!-- impl IconSet::fn ref -->
Increments the reference count on `self`.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

`self`.
<!-- impl IconSet::fn render_icon -->
Renders an icon using `Style::render_icon`. In most cases,
`Widget::render_icon` is better, since it automatically provides
most of the arguments from the current widget settings. This
function never returns `None`; if the icon can’t be rendered
(perhaps because an image file fails to load), a default "missing
image" icon will be returned instead.

# Deprecated since 3.0

Use `IconSet::render_icon_pixbuf` instead
## `style`
a `Style` associated with `widget`, or `None`
## `direction`
text direction
## `state`
widget state
## `size`
icon size (`IconSize`). A size of `(GtkIconSize)-1`
 means render at the size of the source and don’t scale.
## `widget`
widget that will display the icon, or `None`.
 The only use that is typically made of this
 is to determine the appropriate `gdk::Screen`.
## `detail`
detail to pass to the theme engine, or `None`.
 Note that passing a detail of anything but `None`
 will disable caching.

# Returns

a `gdk_pixbuf::Pixbuf` to be displayed
<!-- impl IconSet::fn render_icon_pixbuf -->
Renders an icon using `gtk_render_icon_pixbuf`. In most cases,
`WidgetExt::render_icon_pixbuf` is better, since it automatically provides
most of the arguments from the current widget settings. This
function never returns `None`; if the icon can’t be rendered
(perhaps because an image file fails to load), a default "missing
image" icon will be returned instead.

# Deprecated since 3.10

Use `IconTheme` instead.
## `context`
a `StyleContext`
## `size`
icon size (`IconSize`). A size of `(GtkIconSize)-1`
 means render at the size of the source and don’t scale.

# Returns

a `gdk_pixbuf::Pixbuf` to be displayed
<!-- impl IconSet::fn render_icon_surface -->
Renders an icon using `gtk_render_icon_pixbuf` and converts it to a
cairo surface.

This function never returns `None`; if the icon can’t be rendered
(perhaps because an image file fails to load), a default "missing
image" icon will be returned instead.

Feature: `v3_10`


# Deprecated since 3.10

Use `IconTheme` instead.
## `context`
a `StyleContext`
## `size`
icon size (`IconSize`). A size of `(GtkIconSize)-1`
 means render at the size of the source and don’t scale.
## `scale`
the window scale to render for
## `for_window`
`gdk::Window` to optimize drawing for, or `None`

# Returns

a `cairo::Surface` to be displayed
<!-- impl IconSet::fn unref -->
Decrements the reference count on `self`, and frees memory
if the reference count reaches 0.

# Deprecated since 3.10

Use `IconTheme` instead.
<!-- enum IconSize -->
Built-in stock icon sizes.
<!-- enum IconSize::variant Invalid -->
Invalid size.
<!-- enum IconSize::variant Menu -->
Size appropriate for menus (16px).
<!-- enum IconSize::variant SmallToolbar -->
Size appropriate for small toolbars (16px).
<!-- enum IconSize::variant LargeToolbar -->
Size appropriate for large toolbars (24px)
<!-- enum IconSize::variant Button -->
Size appropriate for buttons (16px)
<!-- enum IconSize::variant Dnd -->
Size appropriate for drag and drop (32px)
<!-- enum IconSize::variant Dialog -->
Size appropriate for dialogs (48px)
<!-- struct IconSource -->

# Deprecated since 3.10

<!-- impl IconSource::fn new -->
Creates a new `IconSource`. A `IconSource` contains a `gdk_pixbuf::Pixbuf` (or
image filename) that serves as the base image for one or more of the
icons in a `IconSet`, along with a specification for which icons in the
icon set will be based on that pixbuf or image file. An icon set contains
a set of icons that represent “the same” logical concept in different states,
different global text directions, and different sizes.

So for example a web browser’s “Back to Previous Page” icon might
point in a different direction in Hebrew and in English; it might
look different when insensitive; and it might change size depending
on toolbar mode (small/large icons). So a single icon set would
contain all those variants of the icon. `IconSet` contains a list
of `IconSource` from which it can derive specific icon variants in
the set.

In the simplest case, `IconSet` contains one source pixbuf from
which it derives all variants. The convenience function
`IconSet::new_from_pixbuf` handles this case; if you only have
one source pixbuf, just use that function.

If you want to use a different base pixbuf for different icon
variants, you create multiple icon sources, mark which variants
they’ll be used to create, and add them to the icon set with
`IconSet::add_source`.

By default, the icon source has all parameters wildcarded. That is,
the icon source will be used as the base icon for any desired text
direction, widget state, or icon size.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

a new `IconSource`
<!-- impl IconSource::fn copy -->
Creates a copy of `self`; mostly useful for language bindings.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

a new `IconSource`
<!-- impl IconSource::fn free -->
Frees a dynamically-allocated icon source, along with its
filename, size, and pixbuf fields if those are not `None`.

# Deprecated since 3.10

Use `IconTheme` instead.
<!-- impl IconSource::fn get_direction -->
Obtains the text direction this icon source applies to. The return
value is only useful/meaningful if the text direction is not
wildcarded.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

text direction this source matches
<!-- impl IconSource::fn get_direction_wildcarded -->
Gets the value set by `IconSource::set_direction_wildcarded`.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

`true` if this icon source is a base for any text direction variant
<!-- impl IconSource::fn get_filename -->
Retrieves the source filename, or `None` if none is set. The
filename is not a copy, and should not be modified or expected to
persist beyond the lifetime of the icon source.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

image filename. This string must not
be modified or freed.
<!-- impl IconSource::fn get_icon_name -->
Retrieves the source icon name, or `None` if none is set. The
icon_name is not a copy, and should not be modified or expected to
persist beyond the lifetime of the icon source.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

icon name. This string must not be modified or freed.
<!-- impl IconSource::fn get_pixbuf -->
Retrieves the source pixbuf, or `None` if none is set.
In addition, if a filename source is in use, this
function in some cases will return the pixbuf from
loaded from the filename. This is, for example, true
for the `IconSource` passed to the `Style` `render_icon`
virtual function. The reference count on the pixbuf is
not incremented.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

source pixbuf
<!-- impl IconSource::fn get_size -->
Obtains the icon size this source applies to. The return value
is only useful/meaningful if the icon size is not wildcarded.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

icon size (`IconSize`) this source matches.
<!-- impl IconSource::fn get_size_wildcarded -->
Gets the value set by `IconSource::set_size_wildcarded`.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

`true` if this icon source is a base for any icon size variant
<!-- impl IconSource::fn get_state -->
Obtains the widget state this icon source applies to. The return
value is only useful/meaningful if the widget state is not
wildcarded.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

widget state this source matches
<!-- impl IconSource::fn get_state_wildcarded -->
Gets the value set by `IconSource::set_state_wildcarded`.

# Deprecated since 3.10

Use `IconTheme` instead.

# Returns

`true` if this icon source is a base for any widget state variant
<!-- impl IconSource::fn set_direction -->
Sets the text direction this icon source is intended to be used
with.

Setting the text direction on an icon source makes no difference
if the text direction is wildcarded. Therefore, you should usually
call `IconSource::set_direction_wildcarded` to un-wildcard it
in addition to calling this function.

# Deprecated since 3.10

Use `IconTheme` instead.
## `direction`
text direction this source applies to
<!-- impl IconSource::fn set_direction_wildcarded -->
If the text direction is wildcarded, this source can be used
as the base image for an icon in any `TextDirection`.
If the text direction is not wildcarded, then the
text direction the icon source applies to should be set
with `IconSource::set_direction`, and the icon source
will only be used with that text direction.

`IconSet` prefers non-wildcarded sources (exact matches) over
wildcarded sources, and will use an exact match when possible.

# Deprecated since 3.10

Use `IconTheme` instead.
## `setting`
`true` to wildcard the text direction
<!-- impl IconSource::fn set_filename -->
Sets the name of an image file to use as a base image when creating
icon variants for `IconSet`. The filename must be absolute.

# Deprecated since 3.10

Use `IconTheme` instead.
## `filename`
image file to use
<!-- impl IconSource::fn set_icon_name -->
Sets the name of an icon to look up in the current icon theme
to use as a base image when creating icon variants for `IconSet`.

# Deprecated since 3.10

Use `IconTheme` instead.
## `icon_name`
name of icon to use
<!-- impl IconSource::fn set_pixbuf -->
Sets a pixbuf to use as a base image when creating icon variants
for `IconSet`.

# Deprecated since 3.10

Use `IconTheme` instead.
## `pixbuf`
pixbuf to use as a source
<!-- impl IconSource::fn set_size -->
Sets the icon size this icon source is intended to be used
with.

Setting the icon size on an icon source makes no difference
if the size is wildcarded. Therefore, you should usually
call `IconSource::set_size_wildcarded` to un-wildcard it
in addition to calling this function.

# Deprecated since 3.10

Use `IconTheme` instead.
## `size`
icon size (`IconSize`) this source applies to
<!-- impl IconSource::fn set_size_wildcarded -->
If the icon size is wildcarded, this source can be used as the base
image for an icon of any size. If the size is not wildcarded, then
the size the source applies to should be set with
`IconSource::set_size` and the icon source will only be used
with that specific size.

`IconSet` prefers non-wildcarded sources (exact matches) over
wildcarded sources, and will use an exact match when possible.

`IconSet` will normally scale wildcarded source images to produce
an appropriate icon at a given size, but will not change the size
of source images that match exactly.

# Deprecated since 3.10

Use `IconTheme` instead.
## `setting`
`true` to wildcard the widget state
<!-- impl IconSource::fn set_state -->
Sets the widget state this icon source is intended to be used
with.

Setting the widget state on an icon source makes no difference
if the state is wildcarded. Therefore, you should usually
call `IconSource::set_state_wildcarded` to un-wildcard it
in addition to calling this function.

# Deprecated since 3.10

Use `IconTheme` instead.
## `state`
widget state this source applies to
<!-- impl IconSource::fn set_state_wildcarded -->
If the widget state is wildcarded, this source can be used as the
base image for an icon in any `StateType`. If the widget state
is not wildcarded, then the state the source applies to should be
set with `IconSource::set_state` and the icon source will
only be used with that specific state.

`IconSet` prefers non-wildcarded sources (exact matches) over
wildcarded sources, and will use an exact match when possible.

`IconSet` will normally transform wildcarded source images to
produce an appropriate icon for a given state, for example
lightening an image on prelight, but will not modify source images
that match exactly.

# Deprecated since 3.10

Use `IconTheme` instead.
## `setting`
`true` to wildcard the widget state
<!-- struct IconTheme -->
`IconTheme` provides a facility for looking up icons by name
and size. The main reason for using a name rather than simply
providing a filename is to allow different icons to be used
depending on what “icon theme” is selected
by the user. The operation of icon themes on Linux and Unix
follows the [Icon Theme Specification](http://www.freedesktop.org/Standards/icon-theme-spec)
There is a fallback icon theme, named `hicolor`, where applications
should install their icons, but additional icon themes can be installed
as operating system vendors and users choose.

Named icons are similar to the deprecated [Stock Items][gtkstock],
and the distinction between the two may be a bit confusing.
A few things to keep in mind:

- Stock images usually are used in conjunction with
 [Stock Items][gtkstock], such as `GTK_STOCK_OK` or
 `GTK_STOCK_OPEN`. Named icons are easier to set up and therefore
 are more useful for new icons that an application wants to
 add, such as application icons or window icons.

- Stock images can only be loaded at the symbolic sizes defined
 by the `IconSize` enumeration, or by custom sizes defined
 by `IconSize::register`, while named icons are more flexible
 and any pixel size can be specified.

- Because stock images are closely tied to stock items, and thus
 to actions in the user interface, stock images may come in
 multiple variants for different widget states or writing
 directions.

A good rule of thumb is that if there is a stock image for what
you want to use, use it, otherwise use a named icon. It turns
out that internally stock images are generally defined in
terms of one or more named icons. (An example of the
more than one case is icons that depend on writing direction;
`GTK_STOCK_GO_FORWARD` uses the two themed icons
“gtk-stock-go-forward-ltr” and “gtk-stock-go-forward-rtl”.)

In many cases, named themes are used indirectly, via `Image`
or stock items, rather than directly, but looking up icons
directly is also simple. The `IconTheme` object acts
as a database of all the icons in the current theme. You
can create new `IconTheme` objects, but it’s much more
efficient to use the standard icon theme for the `gdk::Screen`
so that the icon information is shared with other people
looking up icons.

```C
GError *error = NULL;
GtkIconTheme *icon_theme;
GdkPixbuf *pixbuf;

icon_theme = gtk_icon_theme_get_default ();
pixbuf = gtk_icon_theme_load_icon (icon_theme,
                                   "my-icon-name", // icon name
                                   48, // icon size
                                   0,  // flags
                                   &error);
if (!pixbuf)
  {
    g_warning ("Couldn’t load icon: %s", error->message);
    g_error_free (error);
  }
else
  {
    // Use the pixbuf
    g_object_unref (pixbuf);
  }
```

# Implements

[`IconThemeExt`](trait.IconThemeExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait IconThemeExt -->
Trait containing all `IconTheme` methods.

# Implementors

[`IconTheme`](struct.IconTheme.html)
<!-- impl IconTheme::fn new -->
Creates a new icon theme object. Icon theme objects are used
to lookup up an icon by name in a particular icon theme.
Usually, you’ll want to use `IconTheme::get_default`
or `IconTheme::get_for_screen` rather than creating
a new icon theme object for scratch.

# Returns

the newly created `IconTheme` object.
<!-- impl IconTheme::fn add_builtin_icon -->
Registers a built-in icon for icon theme lookups. The idea
of built-in icons is to allow an application or library
that uses themed icons to function requiring files to
be present in the file system. For instance, the default
images for all of GTK+’s stock icons are registered
as built-icons.

In general, if you use `IconTheme::add_builtin_icon`
you should also install the icon in the icon theme, so
that the icon is generally available.

This function will generally be used with pixbufs loaded
via `gdk_pixbuf::Pixbuf::new_from_inline`.

# Deprecated since 3.14

Use `IconThemeExt::add_resource_path`
 to add application-specific icons to the icon theme.
## `icon_name`
the name of the icon to register
## `size`
the size in pixels at which to register the icon (different
 images can be registered for the same icon name at different sizes.)
## `pixbuf`
`gdk_pixbuf::Pixbuf` that contains the image to use for `icon_name`
<!-- impl IconTheme::fn get_default -->
Gets the icon theme for the default screen. See
`IconTheme::get_for_screen`.

# Returns

A unique `IconTheme` associated with
 the default screen. This icon theme is associated with
 the screen and can be used as long as the screen
 is open. Do not ref or unref it.
<!-- impl IconTheme::fn get_for_screen -->
Gets the icon theme object associated with `screen`; if this
function has not previously been called for the given
screen, a new icon theme object will be created and
associated with the screen. Icon theme objects are
fairly expensive to create, so using this function
is usually a better choice than calling than `IconTheme::new`
and setting the screen yourself; by using this function
a single icon theme object will be shared between users.
## `screen`
a `gdk::Screen`

# Returns

A unique `IconTheme` associated with
 the given screen. This icon theme is associated with
 the screen and can be used as long as the screen
 is open. Do not ref or unref it.
<!-- trait IconThemeExt::fn add_resource_path -->
Adds a resource path that will be looked at when looking
for icons, similar to search paths.

This function should be used to make application-specific icons
available as part of the icon theme.

The resources are considered as part of the hicolor icon theme
and must be located in subdirectories that are defined in the
hicolor icon theme, such as `@path/16x16/actions/run.png`.
Icons that are directly placed in the resource path instead
of a subdirectory are also considered as ultimate fallback.

Feature: `v3_14`

## `path`
a resource path
<!-- trait IconThemeExt::fn append_search_path -->
Appends a directory to the search path.
See `IconTheme::set_search_path`.
## `path`
directory name to append to the icon path
<!-- trait IconThemeExt::fn choose_icon -->
Looks up a named icon and returns a `IconInfo` containing
information such as the filename of the icon. The icon
can then be rendered into a pixbuf using
`IconInfoExt::load_icon`. (`IconThemeExt::load_icon`
combines these two steps if all you need is the pixbuf.)

If `icon_names` contains more than one name, this function
tries them all in the given order before falling back to
inherited icon themes.
## `icon_names`
`None`-terminated array of
 icon names to lookup
## `size`
desired icon size
## `flags`
flags modifying the behavior of the icon lookup

# Returns

a `IconInfo` object
containing information about the icon, or `None` if the icon wasn’t
found.
<!-- trait IconThemeExt::fn choose_icon_for_scale -->
Looks up a named icon for a particular window scale and returns
a `IconInfo` containing information such as the filename of the
icon. The icon can then be rendered into a pixbuf using
`IconInfoExt::load_icon`. (`IconThemeExt::load_icon`
combines these two steps if all you need is the pixbuf.)

If `icon_names` contains more than one name, this function
tries them all in the given order before falling back to
inherited icon themes.

Feature: `v3_10`

## `icon_names`
`None`-terminated
 array of icon names to lookup
## `size`
desired icon size
## `scale`
desired scale
## `flags`
flags modifying the behavior of the icon lookup

# Returns

a `IconInfo` object
 containing information about the icon, or `None` if the
 icon wasn’t found.
<!-- trait IconThemeExt::fn get_example_icon_name -->
Gets the name of an icon that is representative of the
current theme (for instance, to use when presenting
a list of themes to the user.)

# Returns

the name of an example icon or `None`.
 Free with `g_free`.
<!-- trait IconThemeExt::fn get_icon_sizes -->
Returns an array of integers describing the sizes at which
the icon is available without scaling. A size of -1 means
that the icon is available in a scalable format. The array
is zero-terminated.
## `icon_name`
the name of an icon

# Returns

An newly
allocated array describing the sizes at which the icon is
available. The array should be freed with `g_free` when it is no
longer needed.
<!-- trait IconThemeExt::fn get_search_path -->
Gets the current search path. See `IconTheme::set_search_path`.
## `path`

 location to store a list of icon theme path directories or `None`.
 The stored value should be freed with `g_strfreev`.
## `n_elements`
location to store number of elements in `path`, or `None`
<!-- trait IconThemeExt::fn has_icon -->
Checks whether an icon theme includes an icon
for a particular name.
## `icon_name`
the name of an icon

# Returns

`true` if `self` includes an
 icon for `icon_name`.
<!-- trait IconThemeExt::fn list_contexts -->
Gets the list of contexts available within the current
hierarchy of icon themes.
See `IconThemeExt::list_icons` for details about contexts.

# Returns

a `glib::List` list
 holding the names of all the contexts in the theme. You must first
 free each element in the list with `g_free`, then free the list
 itself with `glib::List::free`.
<!-- trait IconThemeExt::fn list_icons -->
Lists the icons in the current icon theme. Only a subset
of the icons can be listed by providing a context string.
The set of values for the context string is system dependent,
but will typically include such values as “Applications” and
“MimeTypes”. Contexts are explained in the
[Icon Theme Specification](http://www.freedesktop.org/wiki/Specifications/icon-theme-spec).
The standard contexts are listed in the
[Icon Naming Specification](http://www.freedesktop.org/wiki/Specifications/icon-naming-spec).
Also see `IconThemeExt::list_contexts`.
## `context`
a string identifying a particular type of
 icon, or `None` to list all icons.

# Returns

a `glib::List` list
 holding the names of all the icons in the theme. You must
 first free each element in the list with `g_free`, then
 free the list itself with `glib::List::free`.
<!-- trait IconThemeExt::fn load_icon -->
Looks up an icon in an icon theme, scales it to the given size
and renders it into a pixbuf. This is a convenience function;
if more details about the icon are needed, use
`IconThemeExt::lookup_icon` followed by `IconInfoExt::load_icon`.

Note that you probably want to listen for icon theme changes and
update the icon. This is usually done by connecting to the
`Widget`::style-set signal. If for some reason you do not want to
update the icon when the icon theme changes, you should consider
using `gdk_pixbuf::PixbufExt::copy` to make a private copy of the pixbuf
returned by this function. Otherwise GTK+ may need to keep the old
icon theme loaded, which would be a waste of memory.
## `icon_name`
the name of the icon to lookup
## `size`
the desired icon size. The resulting icon may not be
 exactly this size; see `IconInfoExt::load_icon`.
## `flags`
flags modifying the behavior of the icon lookup

# Returns

the rendered icon; this may be
 a newly created icon or a new reference to an internal icon, so
 you must not modify the icon. Use `gobject::ObjectExt::unref` to release
 your reference to the icon. `None` if the icon isn’t found.
<!-- trait IconThemeExt::fn load_icon_for_scale -->
Looks up an icon in an icon theme for a particular window scale,
scales it to the given size and renders it into a pixbuf. This is a
convenience function; if more details about the icon are needed,
use `IconThemeExt::lookup_icon` followed by
`IconInfoExt::load_icon`.

Note that you probably want to listen for icon theme changes and
update the icon. This is usually done by connecting to the
`Widget`::style-set signal. If for some reason you do not want to
update the icon when the icon theme changes, you should consider
using `gdk_pixbuf::PixbufExt::copy` to make a private copy of the pixbuf
returned by this function. Otherwise GTK+ may need to keep the old
icon theme loaded, which would be a waste of memory.

Feature: `v3_10`

## `icon_name`
the name of the icon to lookup
## `size`
the desired icon size. The resulting icon may not be
 exactly this size; see `IconInfoExt::load_icon`.
## `scale`
desired scale
## `flags`
flags modifying the behavior of the icon lookup

# Returns

the rendered icon; this may be
 a newly created icon or a new reference to an internal icon, so
 you must not modify the icon. Use `gobject::ObjectExt::unref` to release
 your reference to the icon. `None` if the icon isn’t found.
<!-- trait IconThemeExt::fn load_surface -->
Looks up an icon in an icon theme for a particular window scale,
scales it to the given size and renders it into a cairo surface. This is a
convenience function; if more details about the icon are needed,
use `IconThemeExt::lookup_icon` followed by
`IconInfoExt::load_surface`.

Note that you probably want to listen for icon theme changes and
update the icon. This is usually done by connecting to the
`Widget`::style-set signal.

Feature: `v3_10`

## `icon_name`
the name of the icon to lookup
## `size`
the desired icon size. The resulting icon may not be
 exactly this size; see `IconInfoExt::load_icon`.
## `scale`
desired scale
## `for_window`
`gdk::Window` to optimize drawing for, or `None`
## `flags`
flags modifying the behavior of the icon lookup

# Returns

the rendered icon; this may be
 a newly created icon or a new reference to an internal icon, so
 you must not modify the icon. Use `cairo_surface_destroy` to
 release your reference to the icon. `None` if the icon isn’t
 found.
<!-- trait IconThemeExt::fn lookup_by_gicon -->
Looks up an icon and returns a `IconInfo` containing information
such as the filename of the icon. The icon can then be rendered
into a pixbuf using `IconInfoExt::load_icon`.

When rendering on displays with high pixel densities you should not
use a `size` multiplied by the scaling factor returned by functions
like `gdk::WindowExt::get_scale_factor`. Instead, you should use
`IconThemeExt::lookup_by_gicon_for_scale`, as the assets loaded
for a given scaling factor may be different.
## `icon`
the `gio::Icon` to look up
## `size`
desired icon size
## `flags`
flags modifying the behavior of the icon lookup

# Returns

a `IconInfo` containing
 information about the icon, or `None` if the icon wasn’t
 found. Unref with `gobject::ObjectExt::unref`
<!-- trait IconThemeExt::fn lookup_by_gicon_for_scale -->
Looks up an icon and returns a `IconInfo` containing information
such as the filename of the icon. The icon can then be rendered into
a pixbuf using `IconInfoExt::load_icon`.

Feature: `v3_10`

## `icon`
the `gio::Icon` to look up
## `size`
desired icon size
## `scale`
the desired scale
## `flags`
flags modifying the behavior of the icon lookup

# Returns

a `IconInfo` containing
 information about the icon, or `None` if the icon wasn’t
 found. Unref with `gobject::ObjectExt::unref`
<!-- trait IconThemeExt::fn lookup_icon -->
Looks up a named icon and returns a `IconInfo` containing
information such as the filename of the icon. The icon
can then be rendered into a pixbuf using
`IconInfoExt::load_icon`. (`IconThemeExt::load_icon`
combines these two steps if all you need is the pixbuf.)

When rendering on displays with high pixel densities you should not
use a `size` multiplied by the scaling factor returned by functions
like `gdk::WindowExt::get_scale_factor`. Instead, you should use
`IconThemeExt::lookup_icon_for_scale`, as the assets loaded
for a given scaling factor may be different.
## `icon_name`
the name of the icon to lookup
## `size`
desired icon size
## `flags`
flags modifying the behavior of the icon lookup

# Returns

a `IconInfo` object
 containing information about the icon, or `None` if the
 icon wasn’t found.
<!-- trait IconThemeExt::fn lookup_icon_for_scale -->
Looks up a named icon for a particular window scale and returns a
`IconInfo` containing information such as the filename of the
icon. The icon can then be rendered into a pixbuf using
`IconInfoExt::load_icon`. (`IconThemeExt::load_icon` combines
these two steps if all you need is the pixbuf.)

Feature: `v3_10`

## `icon_name`
the name of the icon to lookup
## `size`
desired icon size
## `scale`
the desired scale
## `flags`
flags modifying the behavior of the icon lookup

# Returns

a `IconInfo` object
 containing information about the icon, or `None` if the
 icon wasn’t found.
<!-- trait IconThemeExt::fn prepend_search_path -->
Prepends a directory to the search path.
See `IconTheme::set_search_path`.
## `path`
directory name to prepend to the icon path
<!-- trait IconThemeExt::fn rescan_if_needed -->
Checks to see if the icon theme has changed; if it has, any
currently cached information is discarded and will be reloaded
next time `self` is accessed.

# Returns

`true` if the icon theme has changed and needed
 to be reloaded.
<!-- trait IconThemeExt::fn set_custom_theme -->
Sets the name of the icon theme that the `IconTheme` object uses
overriding system configuration. This function cannot be called
on the icon theme objects returned from `IconTheme::get_default`
and `IconTheme::get_for_screen`.
## `theme_name`
name of icon theme to use instead of
 configured theme, or `None` to unset a previously set custom theme
<!-- trait IconThemeExt::fn set_screen -->
Sets the screen for an icon theme; the screen is used
to track the user’s currently configured icon theme,
which might be different for different screens.
## `screen`
a `gdk::Screen`
<!-- trait IconThemeExt::fn set_search_path -->
Sets the search path for the icon theme object. When looking
for an icon theme, GTK+ will search for a subdirectory of
one or more of the directories in `path` with the same name
as the icon theme containing an index.theme file. (Themes from
multiple of the path elements are combined to allow themes to be
extended by adding icons in the user’s home directory.)

In addition if an icon found isn’t found either in the current
icon theme or the default icon theme, and an image file with
the right name is found directly in one of the elements of
`path`, then that image will be used for the icon name.
(This is legacy feature, and new icons should be put
into the fallback icon theme, which is called hicolor,
rather than directly on the icon path.)
## `path`
array of
 directories that are searched for icon themes
## `n_elements`
number of elements in `path`.
<!-- trait IconThemeExt::fn connect_changed -->
Emitted when the current icon theme is switched or GTK+ detects
that a change has occurred in the contents of the current
icon theme.
<!-- enum IconThemeError -->
Error codes for `IconTheme` operations.
<!-- enum IconThemeError::variant NotFound -->
The icon specified does not exist in the theme
<!-- enum IconThemeError::variant Failed -->
An unspecified error occurred.
<!-- struct IconView -->
`IconView` provides an alternative view on a `TreeModel`.
It displays the model as a grid of icons with labels. Like
`TreeView`, it allows to select one or multiple items
(depending on the selection mode, see `IconViewExt::set_selection_mode`).
In addition to selection with the arrow keys, `IconView` supports
rubberband selection, which is controlled by dragging the pointer.

Note that if the tree model is backed by an actual tree store (as
opposed to a flat list where the mapping to icons is obvious),
`IconView` will only display the first level of the tree and
ignore the tree’s branches.

# CSS nodes


```plain
iconview.view
╰── [rubberband]
```

`IconView` has a single CSS node with name iconview and style class .view.
For rubberband selection, a subnode with name rubberband is used.

# Implements

[`IconViewExt`](trait.IconViewExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`CellLayoutExt`](trait.CellLayoutExt.html), [`ScrollableExt`](trait.ScrollableExt.html)
<!-- trait IconViewExt -->
Trait containing all `IconView` methods.

# Implementors

[`IconView`](struct.IconView.html)
<!-- impl IconView::fn new -->
Creates a new `IconView` widget

# Returns

A newly created `IconView` widget
<!-- impl IconView::fn new_with_area -->
Creates a new `IconView` widget using the
specified `area` to layout cells inside the icons.
## `area`
the `CellArea` to use to layout cells

# Returns

A newly created `IconView` widget
<!-- impl IconView::fn new_with_model -->
Creates a new `IconView` widget with the model `model`.
## `model`
The model.

# Returns

A newly created `IconView` widget.
<!-- trait IconViewExt::fn convert_widget_to_bin_window_coords -->
Converts widget coordinates to coordinates for the bin_window,
as expected by e.g. `IconViewExt::get_path_at_pos`.
## `wx`
X coordinate relative to the widget
## `wy`
Y coordinate relative to the widget
## `bx`
return location for bin_window X coordinate
## `by`
return location for bin_window Y coordinate
<!-- trait IconViewExt::fn create_drag_icon -->
Creates a `cairo::Surface` representation of the item at `path`.
This image is used for a drag icon.
## `path`
a `TreePath` in `self`

# Returns

a newly-allocated surface of the drag icon.
<!-- trait IconViewExt::fn enable_model_drag_dest -->
Turns `self` into a drop destination for automatic DND. Calling this
method sets `IconView:reorderable` to `false`.
## `targets`
the table of targets that the drag will
 support
## `n_targets`
the number of items in `targets`
## `actions`
the bitmask of possible actions for a drag to this
 widget
<!-- trait IconViewExt::fn enable_model_drag_source -->
Turns `self` into a drag source for automatic DND. Calling this
method sets `IconView:reorderable` to `false`.
## `start_button_mask`
Mask of allowed buttons to start drag
## `targets`
the table of targets that the drag will
 support
## `n_targets`
the number of items in `targets`
## `actions`
the bitmask of possible actions for a drag from this
 widget
<!-- trait IconViewExt::fn get_activate_on_single_click -->
Gets the setting set by `IconViewExt::set_activate_on_single_click`.

Feature: `v3_8`


# Returns

`true` if item-activated will be emitted on a single click
<!-- trait IconViewExt::fn get_cell_rect -->
Fills the bounding rectangle in widget coordinates for the cell specified by
`path` and `cell`. If `cell` is `None` the main cell area is used.

This function is only valid if `self` is realized.

Feature: `v3_6`

## `path`
a `TreePath`
## `cell`
a `CellRenderer` or `None`
## `rect`
rectangle to fill with cell rect

# Returns

`false` if there is no such item, `true` otherwise
<!-- trait IconViewExt::fn get_column_spacing -->
Returns the value of the ::column-spacing property.

# Returns

the space between columns
<!-- trait IconViewExt::fn get_columns -->
Returns the value of the ::columns property.

# Returns

the number of columns, or -1
<!-- trait IconViewExt::fn get_cursor -->
Fills in `path` and `cell` with the current cursor path and cell.
If the cursor isn’t currently set, then *`path` will be `None`.
If no cell currently has focus, then *`cell` will be `None`.

The returned `TreePath` must be freed with `TreePath::free`.
## `path`
Return location for the current
 cursor path, or `None`
## `cell`
Return location the current
 focus cell, or `None`

# Returns

`true` if the cursor is set.
<!-- trait IconViewExt::fn get_dest_item_at_pos -->
Determines the destination item for a given position.
## `drag_x`
the position to determine the destination item for
## `drag_y`
the position to determine the destination item for
## `path`
Return location for the path of the item,
 or `None`.
## `pos`
Return location for the drop position, or `None`

# Returns

whether there is an item at the given position.
<!-- trait IconViewExt::fn get_drag_dest_item -->
Gets information about the item that is highlighted for feedback.
## `path`
Return location for the path of
 the highlighted item, or `None`.
## `pos`
Return location for the drop position, or `None`
<!-- trait IconViewExt::fn get_item_at_pos -->
Finds the path at the point (`x`, `y`), relative to bin_window coordinates.
In contrast to `IconViewExt::get_path_at_pos`, this function also
obtains the cell at the specified position. The returned path should
be freed with `TreePath::free`.
See `IconViewExt::convert_widget_to_bin_window_coords` for converting
widget coordinates to bin_window coordinates.
## `x`
The x position to be identified
## `y`
The y position to be identified
## `path`
Return location for the path, or `None`
## `cell`
Return location for the renderer
 responsible for the cell at (`x`, `y`), or `None`

# Returns

`true` if an item exists at the specified position
<!-- trait IconViewExt::fn get_item_column -->
Gets the column in which the item `path` is currently
displayed. Column numbers start at 0.
## `path`
the `TreePath` of the item

# Returns

The column in which the item is displayed
<!-- trait IconViewExt::fn get_item_orientation -->
Returns the value of the ::item-orientation property which determines
whether the labels are drawn beside the icons instead of below.

# Returns

the relative position of texts and icons
<!-- trait IconViewExt::fn get_item_padding -->
Returns the value of the ::item-padding property.

# Returns

the padding around items
<!-- trait IconViewExt::fn get_item_row -->
Gets the row in which the item `path` is currently
displayed. Row numbers start at 0.
## `path`
the `TreePath` of the item

# Returns

The row in which the item is displayed
<!-- trait IconViewExt::fn get_item_width -->
Returns the value of the ::item-width property.

# Returns

the width of a single item, or -1
<!-- trait IconViewExt::fn get_margin -->
Returns the value of the ::margin property.

# Returns

the space at the borders
<!-- trait IconViewExt::fn get_markup_column -->
Returns the column with markup text for `self`.

# Returns

the markup column, or -1 if it’s unset.
<!-- trait IconViewExt::fn get_model -->
Returns the model the `IconView` is based on. Returns `None` if the
model is unset.

# Returns

A `TreeModel`, or `None` if none is
 currently being used.
<!-- trait IconViewExt::fn get_path_at_pos -->
Finds the path at the point (`x`, `y`), relative to bin_window coordinates.
See `IconViewExt::get_item_at_pos`, if you are also interested in
the cell at the specified position.
See `IconViewExt::convert_widget_to_bin_window_coords` for converting
widget coordinates to bin_window coordinates.
## `x`
The x position to be identified
## `y`
The y position to be identified

# Returns

The `TreePath` corresponding
to the icon or `None` if no icon exists at that position.
<!-- trait IconViewExt::fn get_pixbuf_column -->
Returns the column with pixbufs for `self`.

# Returns

the pixbuf column, or -1 if it’s unset.
<!-- trait IconViewExt::fn get_reorderable -->
Retrieves whether the user can reorder the list via drag-and-drop.
See `IconViewExt::set_reorderable`.

# Returns

`true` if the list can be reordered.
<!-- trait IconViewExt::fn get_row_spacing -->
Returns the value of the ::row-spacing property.

# Returns

the space between rows
<!-- trait IconViewExt::fn get_selected_items -->
Creates a list of paths of all selected items. Additionally, if you are
planning on modifying the model after calling this function, you may
want to convert the returned list into a list of ``GtkTreeRowReferences``.
To do this, you can use `TreeRowReference::new`.

To free the return value, use:

```C
g_list_free_full (list, (GDestroyNotify) gtk_tree_path_free);
```

# Returns

A `glib::List` containing a `TreePath` for each selected row.
<!-- trait IconViewExt::fn get_selection_mode -->
Gets the selection mode of the `self`.

# Returns

the current selection mode
<!-- trait IconViewExt::fn get_spacing -->
Returns the value of the ::spacing property.

# Returns

the space between cells
<!-- trait IconViewExt::fn get_text_column -->
Returns the column with text for `self`.

# Returns

the text column, or -1 if it’s unset.
<!-- trait IconViewExt::fn get_tooltip_column -->
Returns the column of `self`’s model which is being used for
displaying tooltips on `self`’s rows.

# Returns

the index of the tooltip column that is currently being
used, or -1 if this is disabled.
<!-- trait IconViewExt::fn get_tooltip_context -->
This function is supposed to be used in a `Widget::query-tooltip`
signal handler for `IconView`. The `x`, `y` and `keyboard_tip` values
which are received in the signal handler, should be passed to this
function without modification.

The return value indicates whether there is an icon view item at the given
coordinates (`true`) or not (`false`) for mouse tooltips. For keyboard
tooltips the item returned will be the cursor item. When `true`, then any of
`model`, `path` and `iter` which have been provided will be set to point to
that row and the corresponding model. `x` and `y` will always be converted
to be relative to `self`’s bin_window if `keyboard_tooltip` is `false`.
## `x`
the x coordinate (relative to widget coordinates)
## `y`
the y coordinate (relative to widget coordinates)
## `keyboard_tip`
whether this is a keyboard tooltip or not
## `model`
a pointer to receive a
 `TreeModel` or `None`
## `path`
a pointer to receive a `TreePath` or `None`
## `iter`
a pointer to receive a `TreeIter` or `None`

# Returns

whether or not the given tooltip context points to a item
<!-- trait IconViewExt::fn get_visible_range -->
Sets `start_path` and `end_path` to be the first and last visible path.
Note that there may be invisible paths in between.

Both paths should be freed with `TreePath::free` after use.
## `start_path`
Return location for start of region,
 or `None`
## `end_path`
Return location for end of region, or `None`

# Returns

`true`, if valid paths were placed in `start_path` and `end_path`
<!-- trait IconViewExt::fn item_activated -->
Activates the item determined by `path`.
## `path`
The `TreePath` to be activated
<!-- trait IconViewExt::fn path_is_selected -->
Returns `true` if the icon pointed to by `path` is currently
selected. If `path` does not point to a valid location, `false` is returned.
## `path`
A `TreePath` to check selection on.

# Returns

`true` if `path` is selected.
<!-- trait IconViewExt::fn scroll_to_path -->
Moves the alignments of `self` to the position specified by `path`.
`row_align` determines where the row is placed, and `col_align` determines
where `column` is placed. Both are expected to be between 0.0 and 1.0.
0.0 means left/top alignment, 1.0 means right/bottom alignment, 0.5 means
center.

If `use_align` is `false`, then the alignment arguments are ignored, and the
tree does the minimum amount of work to scroll the item onto the screen.
This means that the item will be scrolled to the edge closest to its current
position. If the item is currently visible on the screen, nothing is done.

This function only works if the model is set, and `path` is a valid row on
the model. If the model changes before the `self` is realized, the
centered path will be modified to reflect this change.
## `path`
The path of the item to move to.
## `use_align`
whether to use alignment arguments, or `false`.
## `row_align`
The vertical alignment of the item specified by `path`.
## `col_align`
The horizontal alignment of the item specified by `path`.
<!-- trait IconViewExt::fn select_all -->
Selects all the icons. `self` must has its selection mode set
to `SelectionMode::Multiple`.
<!-- trait IconViewExt::fn select_path -->
Selects the row at `path`.
## `path`
The `TreePath` to be selected.
<!-- trait IconViewExt::fn selected_foreach -->
Calls a function for each selected icon. Note that the model or
selection cannot be modified from within this function.
## `func`
The function to call for each selected icon.
## `data`
User data to pass to the function.
<!-- trait IconViewExt::fn set_activate_on_single_click -->
Causes the `IconView::item-activated` signal to be emitted on
a single click instead of a double click.

Feature: `v3_8`

## `single`
`true` to emit item-activated on a single click
<!-- trait IconViewExt::fn set_column_spacing -->
Sets the ::column-spacing property which specifies the space
which is inserted between the columns of the icon view.
## `column_spacing`
the column spacing
<!-- trait IconViewExt::fn set_columns -->
Sets the ::columns property which determines in how
many columns the icons are arranged. If `columns` is
-1, the number of columns will be chosen automatically
to fill the available area.
## `columns`
the number of columns
<!-- trait IconViewExt::fn set_cursor -->
Sets the current keyboard focus to be at `path`, and selects it. This is
useful when you want to focus the user’s attention on a particular item.
If `cell` is not `None`, then focus is given to the cell specified by
it. Additionally, if `start_editing` is `true`, then editing should be
started in the specified cell.

This function is often followed by `gtk_widget_grab_focus
(icon_view)` in order to give keyboard focus to the widget.
Please note that editing can only happen when the widget is realized.
## `path`
A `TreePath`
## `cell`
One of the cell renderers of `self`, or `None`
## `start_editing`
`true` if the specified cell should start being edited.
<!-- trait IconViewExt::fn set_drag_dest_item -->
Sets the item that is highlighted for feedback.
## `path`
The path of the item to highlight, or `None`.
## `pos`
Specifies where to drop, relative to the item
<!-- trait IconViewExt::fn set_item_orientation -->
Sets the ::item-orientation property which determines whether the labels
are drawn beside the icons instead of below.
## `orientation`
the relative position of texts and icons
<!-- trait IconViewExt::fn set_item_padding -->
Sets the `IconView:item-padding` property which specifies the padding
around each of the icon view’s items.
## `item_padding`
the item padding
<!-- trait IconViewExt::fn set_item_width -->
Sets the ::item-width property which specifies the width
to use for each item. If it is set to -1, the icon view will
automatically determine a suitable item size.
## `item_width`
the width for each item
<!-- trait IconViewExt::fn set_margin -->
Sets the ::margin property which specifies the space
which is inserted at the top, bottom, left and right
of the icon view.
## `margin`
the margin
<!-- trait IconViewExt::fn set_markup_column -->
Sets the column with markup information for `self` to be
`column`. The markup column must be of type `G_TYPE_STRING`.
If the markup column is set to something, it overrides
the text column set by `IconViewExt::set_text_column`.
## `column`
A column in the currently used model, or -1 to display no text
<!-- trait IconViewExt::fn set_model -->
Sets the model for a `IconView`.
If the `self` already has a model set, it will remove
it before setting the new model. If `model` is `None`, then
it will unset the old model.
## `model`
The model.
<!-- trait IconViewExt::fn set_pixbuf_column -->
Sets the column with pixbufs for `self` to be `column`. The pixbuf
column must be of type `GDK_TYPE_PIXBUF`
## `column`
A column in the currently used model, or -1 to disable
<!-- trait IconViewExt::fn set_reorderable -->
This function is a convenience function to allow you to reorder models that
support the `TreeDragSourceIface` and the `TreeDragDestIface`. Both
`TreeStore` and `ListStore` support these. If `reorderable` is `true`, then
the user can reorder the model by dragging and dropping rows. The
developer can listen to these changes by connecting to the model's
row_inserted and row_deleted signals. The reordering is implemented by setting up
the icon view as a drag source and destination. Therefore, drag and
drop can not be used in a reorderable view for any other purpose.

This function does not give you any degree of control over the order -- any
reordering is allowed. If more control is needed, you should probably
handle drag and drop manually.
## `reorderable`
`true`, if the list of items can be reordered.
<!-- trait IconViewExt::fn set_row_spacing -->
Sets the ::row-spacing property which specifies the space
which is inserted between the rows of the icon view.
## `row_spacing`
the row spacing
<!-- trait IconViewExt::fn set_selection_mode -->
Sets the selection mode of the `self`.
## `mode`
The selection mode
<!-- trait IconViewExt::fn set_spacing -->
Sets the ::spacing property which specifies the space
which is inserted between the cells (i.e. the icon and
the text) of an item.
## `spacing`
the spacing
<!-- trait IconViewExt::fn set_text_column -->
Sets the column with text for `self` to be `column`. The text
column must be of type `G_TYPE_STRING`.
## `column`
A column in the currently used model, or -1 to display no text
<!-- trait IconViewExt::fn set_tooltip_cell -->
Sets the tip area of `tooltip` to the area which `cell` occupies in
the item pointed to by `path`. See also `TooltipExt::set_tip_area`.

See also `IconViewExt::set_tooltip_column` for a simpler alternative.
## `tooltip`
a `Tooltip`
## `path`
a `TreePath`
## `cell`
a `CellRenderer` or `None`
<!-- trait IconViewExt::fn set_tooltip_column -->
If you only plan to have simple (text-only) tooltips on full items, you
can use this function to have `IconView` handle these automatically
for you. `column` should be set to the column in `self`’s model
containing the tooltip texts, or -1 to disable this feature.

When enabled, `Widget:has-tooltip` will be set to `true` and
`self` will connect a `Widget::query-tooltip` signal handler.

Note that the signal handler sets the text with `TooltipExt::set_markup`,
so &, <, etc have to be escaped in the text.
## `column`
an integer, which is a valid column number for `self`’s model
<!-- trait IconViewExt::fn set_tooltip_item -->
Sets the tip area of `tooltip` to be the area covered by the item at `path`.
See also `IconViewExt::set_tooltip_column` for a simpler alternative.
See also `TooltipExt::set_tip_area`.
## `tooltip`
a `Tooltip`
## `path`
a `TreePath`
<!-- trait IconViewExt::fn unselect_all -->
Unselects all the icons.
<!-- trait IconViewExt::fn unselect_path -->
Unselects the row at `path`.
## `path`
The `TreePath` to be unselected.
<!-- trait IconViewExt::fn unset_model_drag_dest -->
Undoes the effect of `IconView::enable_model_drag_dest`. Calling this
method sets `IconView:reorderable` to `false`.
<!-- trait IconViewExt::fn unset_model_drag_source -->
Undoes the effect of `IconView::enable_model_drag_source`. Calling this
method sets `IconView:reorderable` to `false`.
<!-- trait IconViewExt::fn connect_activate_cursor_item -->
A [keybinding signal][`BindingSignal`]
which gets emitted when the user activates the currently
focused item.

Applications should not connect to it, but may emit it with
`g_signal_emit_by_name` if they need to control activation
programmatically.

The default bindings for this signal are Space, Return and Enter.
<!-- trait IconViewExt::fn connect_item_activated -->
The ::item-activated signal is emitted when the method
`IconViewExt::item_activated` is called, when the user double
clicks an item with the "activate-on-single-click" property set
to `false`, or when the user single clicks an item when the
"activate-on-single-click" property set to `true`. It is also
emitted when a non-editable item is selected and one of the keys:
Space, Return or Enter is pressed.
## `path`
the `TreePath` for the activated item
<!-- trait IconViewExt::fn connect_move_cursor -->
The ::move-cursor signal is a
[keybinding signal][`BindingSignal`]
which gets emitted when the user initiates a cursor movement.

Applications should not connect to it, but may emit it with
`g_signal_emit_by_name` if they need to control the cursor
programmatically.

The default bindings for this signal include
- Arrow keys which move by individual steps
- Home/End keys which move to the first/last item
- PageUp/PageDown which move by "pages"
All of these will extend the selection when combined with
the Shift modifier.
## `step`
the granularity of the move, as a `MovementStep`
## `count`
the number of `step` units to move
<!-- trait IconViewExt::fn connect_select_all -->
A [keybinding signal][`BindingSignal`]
which gets emitted when the user selects all items.

Applications should not connect to it, but may emit it with
`g_signal_emit_by_name` if they need to control selection
programmatically.

The default binding for this signal is Ctrl-a.
<!-- trait IconViewExt::fn connect_select_cursor_item -->
A [keybinding signal][`BindingSignal`]
which gets emitted when the user selects the item that is currently
focused.

Applications should not connect to it, but may emit it with
`g_signal_emit_by_name` if they need to control selection
programmatically.

There is no default binding for this signal.
<!-- trait IconViewExt::fn connect_selection_changed -->
The ::selection-changed signal is emitted when the selection
(i.e. the set of selected items) changes.
<!-- trait IconViewExt::fn connect_toggle_cursor_item -->
A [keybinding signal][`BindingSignal`]
which gets emitted when the user toggles whether the currently
focused item is selected or not. The exact effect of this
depend on the selection mode.

Applications should not connect to it, but may emit it with
`g_signal_emit_by_name` if they need to control selection
programmatically.

There is no default binding for this signal is Ctrl-Space.
<!-- trait IconViewExt::fn connect_unselect_all -->
A [keybinding signal][`BindingSignal`]
which gets emitted when the user unselects all items.

Applications should not connect to it, but may emit it with
`g_signal_emit_by_name` if they need to control selection
programmatically.

The default binding for this signal is Ctrl-Shift-a.
<!-- trait IconViewExt::fn get_property_activate-on-single-click -->
The activate-on-single-click property specifies whether the "item-activated" signal
will be emitted after a single click.

Feature: `v3_8`

<!-- trait IconViewExt::fn set_property_activate-on-single-click -->
The activate-on-single-click property specifies whether the "item-activated" signal
will be emitted after a single click.

Feature: `v3_8`

<!-- trait IconViewExt::fn get_property_cell-area -->
The `CellArea` used to layout cell renderers for this view.

If no area is specified when creating the icon view with `IconView::new_with_area`
a `CellAreaBox` will be used.
<!-- trait IconViewExt::fn set_property_cell-area -->
The `CellArea` used to layout cell renderers for this view.

If no area is specified when creating the icon view with `IconView::new_with_area`
a `CellAreaBox` will be used.
<!-- trait IconViewExt::fn get_property_column-spacing -->
The column-spacing property specifies the space which is inserted between
the columns of the icon view.
<!-- trait IconViewExt::fn set_property_column-spacing -->
The column-spacing property specifies the space which is inserted between
the columns of the icon view.
<!-- trait IconViewExt::fn get_property_columns -->
The columns property contains the number of the columns in which the
items should be displayed. If it is -1, the number of columns will
be chosen automatically to fill the available area.
<!-- trait IconViewExt::fn set_property_columns -->
The columns property contains the number of the columns in which the
items should be displayed. If it is -1, the number of columns will
be chosen automatically to fill the available area.
<!-- trait IconViewExt::fn get_property_item-orientation -->
The item-orientation property specifies how the cells (i.e. the icon and
the text) of the item are positioned relative to each other.
<!-- trait IconViewExt::fn set_property_item-orientation -->
The item-orientation property specifies how the cells (i.e. the icon and
the text) of the item are positioned relative to each other.
<!-- trait IconViewExt::fn get_property_item-padding -->
The item-padding property specifies the padding around each
of the icon view's item.
<!-- trait IconViewExt::fn set_property_item-padding -->
The item-padding property specifies the padding around each
of the icon view's item.
<!-- trait IconViewExt::fn get_property_item-width -->
The item-width property specifies the width to use for each item.
If it is set to -1, the icon view will automatically determine a
suitable item size.
<!-- trait IconViewExt::fn set_property_item-width -->
The item-width property specifies the width to use for each item.
If it is set to -1, the icon view will automatically determine a
suitable item size.
<!-- trait IconViewExt::fn get_property_margin -->
The margin property specifies the space which is inserted
at the edges of the icon view.
<!-- trait IconViewExt::fn set_property_margin -->
The margin property specifies the space which is inserted
at the edges of the icon view.
<!-- trait IconViewExt::fn get_property_markup-column -->
The ::markup-column property contains the number of the model column
containing markup information to be displayed. The markup column must be
of type `G_TYPE_STRING`. If this property and the :text-column property
are both set to column numbers, it overrides the text column.
If both are set to -1, no texts are displayed.
<!-- trait IconViewExt::fn set_property_markup-column -->
The ::markup-column property contains the number of the model column
containing markup information to be displayed. The markup column must be
of type `G_TYPE_STRING`. If this property and the :text-column property
are both set to column numbers, it overrides the text column.
If both are set to -1, no texts are displayed.
<!-- trait IconViewExt::fn get_property_pixbuf-column -->
The ::pixbuf-column property contains the number of the model column
containing the pixbufs which are displayed. The pixbuf column must be
of type `GDK_TYPE_PIXBUF`. Setting this property to -1 turns off the
display of pixbufs.
<!-- trait IconViewExt::fn set_property_pixbuf-column -->
The ::pixbuf-column property contains the number of the model column
containing the pixbufs which are displayed. The pixbuf column must be
of type `GDK_TYPE_PIXBUF`. Setting this property to -1 turns off the
display of pixbufs.
<!-- trait IconViewExt::fn get_property_reorderable -->
The reorderable property specifies if the items can be reordered
by DND.
<!-- trait IconViewExt::fn set_property_reorderable -->
The reorderable property specifies if the items can be reordered
by DND.
<!-- trait IconViewExt::fn get_property_row-spacing -->
The row-spacing property specifies the space which is inserted between
the rows of the icon view.
<!-- trait IconViewExt::fn set_property_row-spacing -->
The row-spacing property specifies the space which is inserted between
the rows of the icon view.
<!-- trait IconViewExt::fn get_property_selection-mode -->
The ::selection-mode property specifies the selection mode of
icon view. If the mode is `SelectionMode::Multiple`, rubberband selection
is enabled, for the other modes, only keyboard selection is possible.
<!-- trait IconViewExt::fn set_property_selection-mode -->
The ::selection-mode property specifies the selection mode of
icon view. If the mode is `SelectionMode::Multiple`, rubberband selection
is enabled, for the other modes, only keyboard selection is possible.
<!-- trait IconViewExt::fn get_property_spacing -->
The spacing property specifies the space which is inserted between
the cells (i.e. the icon and the text) of an item.
<!-- trait IconViewExt::fn set_property_spacing -->
The spacing property specifies the space which is inserted between
the cells (i.e. the icon and the text) of an item.
<!-- trait IconViewExt::fn get_property_text-column -->
The ::text-column property contains the number of the model column
containing the texts which are displayed. The text column must be
of type `G_TYPE_STRING`. If this property and the :markup-column
property are both set to -1, no texts are displayed.
<!-- trait IconViewExt::fn set_property_text-column -->
The ::text-column property contains the number of the model column
containing the texts which are displayed. The text column must be
of type `G_TYPE_STRING`. If this property and the :markup-column
property are both set to -1, no texts are displayed.
<!-- enum IconViewDropPosition -->
An enum for determining where a dropped item goes.
<!-- enum IconViewDropPosition::variant NoDrop -->
no drop possible
<!-- enum IconViewDropPosition::variant DropInto -->
dropped item replaces the item
<!-- enum IconViewDropPosition::variant DropLeft -->
droppped item is inserted to the left
<!-- enum IconViewDropPosition::variant DropRight -->
dropped item is inserted to the right
<!-- enum IconViewDropPosition::variant DropAbove -->
dropped item is inserted above
<!-- enum IconViewDropPosition::variant DropBelow -->
dropped item is inserted below
<!-- struct Image -->
The `Image` widget displays an image. Various kinds of object
can be displayed as an image; most typically, you would load a
`gdk_pixbuf::Pixbuf` ("pixel buffer") from a file, and then display that.
There’s a convenience function to do this, `Image::new_from_file`,
used as follows:

```C
  GtkWidget *image;
  image = gtk_image_new_from_file ("myfile.png");
```
If the file isn’t loaded successfully, the image will contain a
“broken image” icon similar to that used in many web browsers.
If you want to handle errors in loading the file yourself,
for example by displaying an error message, then load the image with
`gdk_pixbuf::Pixbuf::new_from_file`, then create the `Image` with
`Image::new_from_pixbuf`.

The image file may contain an animation, if so the `Image` will
display an animation (`gdk_pixbuf::PixbufAnimation`) instead of a static image.

`Image` is a subclass of `Misc`, which implies that you can
align it (center, left, right) and add padding to it, using
`Misc` methods.

`Image` is a “no window” widget (has no `gdk::Window` of its own),
so by default does not receive events. If you want to receive events
on the image, such as button clicks, place the image inside a
`EventBox`, then connect to the event signals on the event box.

## Handling button press events on a `Image`.


```C
  static gboolean
  button_press_callback (GtkWidget      *event_box,
                         GdkEventButton *event,
                         gpointer        data)
  {
    g_print ("Event box clicked at coordinates %f,%f\n",
             event->x, event->y);

    // Returning TRUE means we handled the event, so the signal
    // emission should be stopped (don’t call any further callbacks
    // that may be connected). Return FALSE to continue invoking callbacks.
    return TRUE;
  }

  static GtkWidget*
  create_image (void)
  {
    GtkWidget *image;
    GtkWidget *event_box;

    image = gtk_image_new_from_file ("myfile.png");

    event_box = gtk_event_box_new ();

    gtk_container_add (GTK_CONTAINER (event_box), image);

    g_signal_connect (G_OBJECT (event_box),
                      "button_press_event",
                      G_CALLBACK (button_press_callback),
                      image);

    return image;
  }
```

When handling events on the event box, keep in mind that coordinates
in the image may be different from event box coordinates due to
the alignment and padding settings on the image (see `Misc`).
The simplest way to solve this is to set the alignment to 0.0
(left/top), and set the padding to zero. Then the origin of
the image will be the same as the origin of the event box.

Sometimes an application will want to avoid depending on external data
files, such as image files. GTK+ comes with a program to avoid this,
called “gdk-pixbuf-csource”. This library
allows you to convert an image into a C variable declaration, which
can then be loaded into a `gdk_pixbuf::Pixbuf` using
`gdk_pixbuf::Pixbuf::new_from_inline`.

# CSS nodes

`Image` has a single CSS node with the name image.

# Implements

[`ImageExt`](trait.ImageExt.html), [`MiscExt`](trait.MiscExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait ImageExt -->
Trait containing all `Image` methods.

# Implementors

[`Image`](struct.Image.html)
<!-- impl Image::fn new -->
Creates a new empty `Image` widget.

# Returns

a newly created `Image` widget.
<!-- impl Image::fn new_from_animation -->
Creates a `Image` displaying the given animation.
The `Image` does not assume a reference to the
animation; you still need to unref it if you own references.
`Image` will add its own reference rather than adopting yours.

Note that the animation frames are shown using a timeout with
`G_PRIORITY_DEFAULT`. When using animations to indicate busyness,
keep in mind that the animation will only be shown if the main loop
is not busy with something that has a higher priority.
## `animation`
an animation

# Returns

a new `Image` widget
<!-- impl Image::fn new_from_file -->
Creates a new `Image` displaying the file `filename`. If the file
isn’t found or can’t be loaded, the resulting `Image` will
display a “broken image” icon. This function never returns `None`,
it always returns a valid `Image` widget.

If the file contains an animation, the image will contain an
animation.

If you need to detect failures to load the file, use
`gdk_pixbuf::Pixbuf::new_from_file` to load the file yourself, then create
the `Image` from the pixbuf. (Or for animations, use
`gdk_pixbuf::PixbufAnimation::new_from_file`).

The storage type (`ImageExt::get_storage_type`) of the returned
image is not defined, it will be whatever is appropriate for
displaying the file.
## `filename`
a filename

# Returns

a new `Image`
<!-- impl Image::fn new_from_gicon -->
Creates a `Image` displaying an icon from the current icon theme.
If the icon name isn’t known, a “broken image” icon will be
displayed instead. If the current icon theme is changed, the icon
will be updated appropriately.
## `icon`
an icon
## `size`
a stock icon size (`IconSize`)

# Returns

a new `Image` displaying the themed icon
<!-- impl Image::fn new_from_icon_name -->
Creates a `Image` displaying an icon from the current icon theme.
If the icon name isn’t known, a “broken image” icon will be
displayed instead. If the current icon theme is changed, the icon
will be updated appropriately.
## `icon_name`
an icon name or `None`
## `size`
a stock icon size (`IconSize`)

# Returns

a new `Image` displaying the themed icon
<!-- impl Image::fn new_from_icon_set -->
Creates a `Image` displaying an icon set. Sample stock sizes are
`IconSize::Menu`, `IconSize::SmallToolbar`. Instead of using
this function, usually it’s better to create a `IconFactory`, put
your icon sets in the icon factory, add the icon factory to the
list of default factories with `IconFactoryExt::add_default`, and
then use `Image::new_from_stock`. This will allow themes to
override the icon you ship with your application.

The `Image` does not assume a reference to the
icon set; you still need to unref it if you own references.
`Image` will add its own reference rather than adopting yours.

# Deprecated since 3.10

Use `Image::new_from_icon_name` instead.
## `icon_set`
a `IconSet`
## `size`
a stock icon size (`IconSize`)

# Returns

a new `Image`
<!-- impl Image::fn new_from_pixbuf -->
Creates a new `Image` displaying `pixbuf`.
The `Image` does not assume a reference to the
pixbuf; you still need to unref it if you own references.
`Image` will add its own reference rather than adopting yours.

Note that this function just creates an `Image` from the pixbuf. The
`Image` created will not react to state changes. Should you want that,
you should use `Image::new_from_icon_name`.
## `pixbuf`
a `gdk_pixbuf::Pixbuf`, or `None`

# Returns

a new `Image`
<!-- impl Image::fn new_from_resource -->
Creates a new `Image` displaying the resource file `resource_path`. If the file
isn’t found or can’t be loaded, the resulting `Image` will
display a “broken image” icon. This function never returns `None`,
it always returns a valid `Image` widget.

If the file contains an animation, the image will contain an
animation.

If you need to detect failures to load the file, use
`gdk_pixbuf::Pixbuf::new_from_file` to load the file yourself, then create
the `Image` from the pixbuf. (Or for animations, use
`gdk_pixbuf::PixbufAnimation::new_from_file`).

The storage type (`ImageExt::get_storage_type`) of the returned
image is not defined, it will be whatever is appropriate for
displaying the file.
## `resource_path`
a resource path

# Returns

a new `Image`
<!-- impl Image::fn new_from_stock -->
Creates a `Image` displaying a stock icon. Sample stock icon
names are `GTK_STOCK_OPEN`, `GTK_STOCK_QUIT`. Sample stock sizes
are `IconSize::Menu`, `IconSize::SmallToolbar`. If the stock
icon name isn’t known, the image will be empty.
You can register your own stock icon names, see
`IconFactoryExt::add_default` and `IconFactoryExt::add`.

# Deprecated since 3.10

Use `Image::new_from_icon_name` instead.
## `stock_id`
a stock icon name
## `size`
a stock icon size (`IconSize`)

# Returns

a new `Image` displaying the stock icon
<!-- impl Image::fn new_from_surface -->
Creates a new `Image` displaying `surface`.
The `Image` does not assume a reference to the
surface; you still need to unref it if you own references.
`Image` will add its own reference rather than adopting yours.

Feature: `v3_10`

## `surface`
a `cairo::Surface`, or `None`

# Returns

a new `Image`
<!-- trait ImageExt::fn clear -->
Resets the image to be empty.
<!-- trait ImageExt::fn get_animation -->
Gets the `gdk_pixbuf::PixbufAnimation` being displayed by the `Image`.
The storage type of the image must be `ImageType::Empty` or
`ImageType::Animation` (see `ImageExt::get_storage_type`).
The caller of this function does not own a reference to the
returned animation.

# Returns

the displayed animation, or `None` if
the image is empty
<!-- trait ImageExt::fn get_gicon -->
Gets the `gio::Icon` and size being displayed by the `Image`.
The storage type of the image must be `ImageType::Empty` or
`ImageType::Gicon` (see `ImageExt::get_storage_type`).
The caller of this function does not own a reference to the
returned `gio::Icon`.
## `gicon`
place to store a
 `gio::Icon`, or `None`
## `size`
place to store an icon size
 (`IconSize`), or `None`
<!-- trait ImageExt::fn get_icon_name -->
Gets the icon name and size being displayed by the `Image`.
The storage type of the image must be `ImageType::Empty` or
`ImageType::IconName` (see `ImageExt::get_storage_type`).
The returned string is owned by the `Image` and should not
be freed.
## `icon_name`
place to store an
 icon name, or `None`
## `size`
place to store an icon size
 (`IconSize`), or `None`
<!-- trait ImageExt::fn get_icon_set -->
Gets the icon set and size being displayed by the `Image`.
The storage type of the image must be `ImageType::Empty` or
`ImageType::IconSet` (see `ImageExt::get_storage_type`).

# Deprecated since 3.10

Use `Image::get_icon_name` instead.
## `icon_set`
location to store a
 `IconSet`, or `None`
## `size`
location to store a stock
 icon size (`IconSize`), or `None`
<!-- trait ImageExt::fn get_pixbuf -->
Gets the `gdk_pixbuf::Pixbuf` being displayed by the `Image`.
The storage type of the image must be `ImageType::Empty` or
`ImageType::Pixbuf` (see `ImageExt::get_storage_type`).
The caller of this function does not own a reference to the
returned pixbuf.

# Returns

the displayed pixbuf, or `None` if
the image is empty
<!-- trait ImageExt::fn get_pixel_size -->
Gets the pixel size used for named icons.

# Returns

the pixel size used for named icons.
<!-- trait ImageExt::fn get_stock -->
Gets the stock icon name and size being displayed by the `Image`.
The storage type of the image must be `ImageType::Empty` or
`ImageType::Stock` (see `ImageExt::get_storage_type`).
The returned string is owned by the `Image` and should not
be freed.

# Deprecated since 3.10

Use `Image::get_icon_name` instead.
## `stock_id`
place to store a
 stock icon name, or `None`
## `size`
place to store a stock icon
 size (`IconSize`), or `None`
<!-- trait ImageExt::fn get_storage_type -->
Gets the type of representation being used by the `Image`
to store image data. If the `Image` has no image data,
the return value will be `ImageType::Empty`.

# Returns

image representation being used
<!-- trait ImageExt::fn set_from_animation -->
Causes the `Image` to display the given animation (or display
nothing, if you set the animation to `None`).
## `animation`
the `gdk_pixbuf::PixbufAnimation`
<!-- trait ImageExt::fn set_from_file -->
See `Image::new_from_file` for details.
## `filename`
a filename or `None`
<!-- trait ImageExt::fn set_from_gicon -->
See `Image::new_from_gicon` for details.
## `icon`
an icon
## `size`
an icon size (`IconSize`)
<!-- trait ImageExt::fn set_from_icon_name -->
See `Image::new_from_icon_name` for details.
## `icon_name`
an icon name or `None`
## `size`
an icon size (`IconSize`)
<!-- trait ImageExt::fn set_from_icon_set -->
See `Image::new_from_icon_set` for details.

# Deprecated since 3.10

Use `ImageExt::set_from_icon_name` instead.
## `icon_set`
a `IconSet`
## `size`
a stock icon size (`IconSize`)
<!-- trait ImageExt::fn set_from_pixbuf -->
See `Image::new_from_pixbuf` for details.
## `pixbuf`
a `gdk_pixbuf::Pixbuf` or `None`
<!-- trait ImageExt::fn set_from_resource -->
See `Image::new_from_resource` for details.
## `resource_path`
a resource path or `None`
<!-- trait ImageExt::fn set_from_stock -->
See `Image::new_from_stock` for details.

# Deprecated since 3.10

Use `ImageExt::set_from_icon_name` instead.
## `stock_id`
a stock icon name
## `size`
a stock icon size (`IconSize`)
<!-- trait ImageExt::fn set_from_surface -->
See `Image::new_from_surface` for details.

Feature: `v3_10`

## `surface`
a cairo_surface_t or `None`
<!-- trait ImageExt::fn set_pixel_size -->
Sets the pixel size to use for named icons. If the pixel size is set
to a value != -1, it is used instead of the icon size set by
`ImageExt::set_from_icon_name`.
## `pixel_size`
the new pixel size
<!-- trait ImageExt::fn get_property_gicon -->
The GIcon displayed in the `Image`. For themed icons,
If the icon theme is changed, the image will be updated
automatically.
<!-- trait ImageExt::fn set_property_gicon -->
The GIcon displayed in the `Image`. For themed icons,
If the icon theme is changed, the image will be updated
automatically.
<!-- trait ImageExt::fn get_property_icon-name -->
The name of the icon in the icon theme. If the icon theme is
changed, the image will be updated automatically.
<!-- trait ImageExt::fn set_property_icon-name -->
The name of the icon in the icon theme. If the icon theme is
changed, the image will be updated automatically.
<!-- trait ImageExt::fn get_property_icon-set -->

# Deprecated since 3.10

Use `Image:icon-name` instead.
<!-- trait ImageExt::fn set_property_icon-set -->

# Deprecated since 3.10

Use `Image:icon-name` instead.
<!-- trait ImageExt::fn get_property_pixel-size -->
The "pixel-size" property can be used to specify a fixed size
overriding the `Image:icon-size` property for images of type
`ImageType::IconName`.
<!-- trait ImageExt::fn set_property_pixel-size -->
The "pixel-size" property can be used to specify a fixed size
overriding the `Image:icon-size` property for images of type
`ImageType::IconName`.
<!-- trait ImageExt::fn get_property_resource -->
A path to a resource file to display.

Feature: `v3_8`

<!-- trait ImageExt::fn set_property_resource -->
A path to a resource file to display.

Feature: `v3_8`

<!-- trait ImageExt::fn get_property_stock -->

# Deprecated since 3.10

Use `Image:icon-name` instead.
<!-- trait ImageExt::fn set_property_stock -->

# Deprecated since 3.10

Use `Image:icon-name` instead.
<!-- trait ImageExt::fn get_property_use-fallback -->
Whether the icon displayed in the `Image` will use
standard icon names fallback. The value of this property
is only relevant for images of type `ImageType::IconName`
and `ImageType::Gicon`.
<!-- trait ImageExt::fn set_property_use-fallback -->
Whether the icon displayed in the `Image` will use
standard icon names fallback. The value of this property
is only relevant for images of type `ImageType::IconName`
and `ImageType::Gicon`.
<!-- struct ImageMenuItem -->
`[Deprecated since 3.10]` A `ImageMenuItem` is a menu item which has an icon next to the text label.

This is functionally equivalent to:


```C
  GtkWidget *box = gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
  GtkWidget *icon = gtk_image_new_from_icon_name ("folder-music-symbolic", GTK_ICON_SIZE_MENU);
  GtkWidget *label = gtk_label_new ("Music");
  GtkWidget *menu_item = gtk_menu_item_new ();

  gtk_container_add (GTK_CONTAINER (box), icon);
  gtk_container_add (GTK_CONTAINER (box), label);

  gtk_container_add (GTK_CONTAINER (menu_item), box);

  gtk_widget_show_all (menu_item);
```

Note that the user may disable display of menu icons using
the `Settings:gtk-menu-images` setting, so make sure to still
fill in the text label. If you want to ensure that your menu items
show an icon you are strongly encouraged to use a `MenuItem`
with a `Image` instead.

`ImageMenuItem` has been deprecated since GTK+ 3.10. If you want to
display an icon in a menu item, you should use `MenuItem` and pack a
`Box` with a `Image` and a `Label` instead. You should also consider
using `Builder` and the XML `gio::Menu` description for creating menus, by
following the [GMenu guide][https://developer.gnome.org/GMenu/]. You should
consider using icons in menu items only sparingly, and for "objects" (or
"nouns") elements only, like bookmarks, files, and links; "actions" (or
"verbs") should not have icons.

Furthermore, if you would like to display keyboard accelerator, you must
pack the accel label into the box using `BoxExt::pack_end` and align the
label, otherwise the accelerator will not display correctly. The following
code snippet adds a keyboard accelerator to the menu item, with a key
binding of Ctrl+M:


```C
  GtkWidget *box = gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
  GtkWidget *icon = gtk_image_new_from_icon_name ("folder-music-symbolic", GTK_ICON_SIZE_MENU);
  GtkWidget *label = gtk_accel_label_new ("Music");
  GtkWidget *menu_item = gtk_menu_item_new ();
  GtkAccelGroup *accel_group = gtk_accel_group_new ();

  gtk_container_add (GTK_CONTAINER (box), icon);

  gtk_label_set_use_underline (GTK_LABEL (label), TRUE);
  gtk_label_set_xalign (GTK_LABEL (label), 0.0);

  gtk_widget_add_accelerator (menu_item, "activate", accel_group,
                              GDK_KEY_m, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
  gtk_accel_label_set_accel_widget (GTK_ACCEL_LABEL (label), menu_item);

  gtk_box_pack_end (GTK_BOX (box), label, TRUE, TRUE, 0);

  gtk_container_add (GTK_CONTAINER (menu_item), box);

  gtk_widget_show_all (menu_item);
```

# Implements

[`ImageMenuItemExt`](trait.ImageMenuItemExt.html), [`MenuItemExt`](trait.MenuItemExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`ActionableExt`](trait.ActionableExt.html)
<!-- trait ImageMenuItemExt -->
`[Deprecated since 3.10]` Trait containing all `ImageMenuItem` methods.

# Implementors

[`ImageMenuItem`](struct.ImageMenuItem.html)
<!-- impl ImageMenuItem::fn new -->
Creates a new `ImageMenuItem` with an empty label.

# Deprecated since 3.10

Use `MenuItem::new` instead.

# Returns

a new `ImageMenuItem`
<!-- impl ImageMenuItem::fn new_from_stock -->
Creates a new `ImageMenuItem` containing the image and text from a
stock item. Some stock ids have preprocessor macros like `GTK_STOCK_OK`
and `GTK_STOCK_APPLY`.

If you want this menu item to have changeable accelerators, then pass in
`None` for accel_group. Next call `MenuItemExt::set_accel_path` with an
appropriate path for the menu item, use `gtk_stock_lookup` to look up the
standard accelerator for the stock item, and if one is found, call
`AccelMap::add_entry` to register it.

# Deprecated since 3.10

Use `MenuItem::new_with_mnemonic` instead.
## `stock_id`
the name of the stock item.
## `accel_group`
the `AccelGroup` to add the menu items
 accelerator to, or `None`.

# Returns

a new `ImageMenuItem`.
<!-- impl ImageMenuItem::fn new_with_label -->
Creates a new `ImageMenuItem` containing a label.

# Deprecated since 3.10

Use `MenuItem::new_with_label` instead.
## `label`
the text of the menu item.

# Returns

a new `ImageMenuItem`.
<!-- impl ImageMenuItem::fn new_with_mnemonic -->
Creates a new `ImageMenuItem` containing a label. The label
will be created using `Label::new_with_mnemonic`, so underscores
in `label` indicate the mnemonic for the menu item.

# Deprecated since 3.10

Use `MenuItem::new_with_mnemonic` instead.
## `label`
the text of the menu item, with an underscore in front of the
 mnemonic character

# Returns

a new `ImageMenuItem`
<!-- trait ImageMenuItemExt::fn get_always_show_image -->
Returns whether the menu item will ignore the `Settings:gtk-menu-images`
setting and always show the image, if available.

# Deprecated since 3.10


# Returns

`true` if the menu item will always show the image
<!-- trait ImageMenuItemExt::fn get_image -->
Gets the widget that is currently set as the image of `self`.
See `ImageMenuItemExt::set_image`.

# Deprecated since 3.10


# Returns

the widget set as image of `self`
<!-- trait ImageMenuItemExt::fn get_use_stock -->
Checks whether the label set in the menuitem is used as a
stock id to select the stock item for the item.

# Deprecated since 3.10


# Returns

`true` if the label set in the menuitem is used as a
 stock id to select the stock item for the item
<!-- trait ImageMenuItemExt::fn set_accel_group -->
Specifies an `accel_group` to add the menu items accelerator to
(this only applies to stock items so a stock item must already
be set, make sure to call `ImageMenuItemExt::set_use_stock`
and `MenuItemExt::set_label` with a valid stock item first).

If you want this menu item to have changeable accelerators then
you shouldnt need this (see `ImageMenuItem::new_from_stock`).

# Deprecated since 3.10

## `accel_group`
the `AccelGroup`
<!-- trait ImageMenuItemExt::fn set_always_show_image -->
If `true`, the menu item will ignore the `Settings:gtk-menu-images`
setting and always show the image, if available.

Use this property if the menuitem would be useless or hard to use
without the image.

# Deprecated since 3.10

## `always_show`
`true` if the menuitem should always show the image
<!-- trait ImageMenuItemExt::fn set_image -->
Sets the image of `self` to the given widget.
Note that it depends on the show-menu-images setting whether
the image will be displayed or not.

# Deprecated since 3.10

## `image`
a widget to set as the image for the menu item.
<!-- trait ImageMenuItemExt::fn set_use_stock -->
If `true`, the label set in the menuitem is used as a
stock id to select the stock item for the item.

# Deprecated since 3.10

## `use_stock`
`true` if the menuitem should use a stock item
<!-- trait ImageMenuItemExt::fn set_property_accel-group -->
The Accel Group to use for stock accelerator keys

# Deprecated since 3.10

Use `WidgetExt::add_accelerator` instead
<!-- trait ImageMenuItemExt::fn get_property_always-show-image -->
If `true`, the menu item will always show the image, if available.

Use this property only if the menuitem would be useless or hard to use
without the image.

# Deprecated since 3.10

Use a `MenuItem` containing a `Box` with
 a `AccelLabel` and a `Image` instead
<!-- trait ImageMenuItemExt::fn set_property_always-show-image -->
If `true`, the menu item will always show the image, if available.

Use this property only if the menuitem would be useless or hard to use
without the image.

# Deprecated since 3.10

Use a `MenuItem` containing a `Box` with
 a `AccelLabel` and a `Image` instead
<!-- trait ImageMenuItemExt::fn get_property_image -->
Child widget to appear next to the menu text.

# Deprecated since 3.10

Use a `MenuItem` containing a `Box` with
 a `AccelLabel` and a `Image` instead
<!-- trait ImageMenuItemExt::fn set_property_image -->
Child widget to appear next to the menu text.

# Deprecated since 3.10

Use a `MenuItem` containing a `Box` with
 a `AccelLabel` and a `Image` instead
<!-- trait ImageMenuItemExt::fn get_property_use-stock -->
If `true`, the label set in the menuitem is used as a
stock id to select the stock item for the item.

# Deprecated since 3.10

Use a named icon from the `IconTheme` instead
<!-- trait ImageMenuItemExt::fn set_property_use-stock -->
If `true`, the label set in the menuitem is used as a
stock id to select the stock item for the item.

# Deprecated since 3.10

Use a named icon from the `IconTheme` instead
<!-- enum ImageType -->
Describes the image data representation used by a `Image`. If you
want to get the image from the widget, you can only get the
currently-stored representation. e.g. if the
`ImageExt::get_storage_type` returns `ImageType::Pixbuf`, then you can
call `ImageExt::get_pixbuf` but not `Image::get_stock`. For empty
images, you can request any storage type (call any of the "get"
functions), but they will all return `None` values.
<!-- enum ImageType::variant Empty -->
there is no image displayed by the widget
<!-- enum ImageType::variant Pixbuf -->
the widget contains a `gdk_pixbuf::Pixbuf`
<!-- enum ImageType::variant Stock -->
the widget contains a [stock item name][gtkstock]
<!-- enum ImageType::variant IconSet -->
the widget contains a `IconSet`
<!-- enum ImageType::variant Animation -->
the widget contains a `gdk_pixbuf::PixbufAnimation`
<!-- enum ImageType::variant IconName -->
the widget contains a named icon.
 This image type was added in GTK+ 2.6
<!-- enum ImageType::variant Gicon -->
the widget contains a `gio::Icon`.
 This image type was added in GTK+ 2.14
<!-- enum ImageType::variant Surface -->
the widget contains a `cairo::Surface`.
 This image type was added in GTK+ 3.10
<!-- struct InfoBar -->
`InfoBar` is a widget that can be used to show messages to
the user without showing a dialog. It is often temporarily shown
at the top or bottom of a document. In contrast to `Dialog`, which
has a action area at the bottom, `InfoBar` has an action area
at the side.

The API of `InfoBar` is very similar to `Dialog`, allowing you
to add buttons to the action area with `InfoBarExt::add_button` or
`InfoBar::new_with_buttons`. The sensitivity of action widgets
can be controlled with `InfoBarExt::set_response_sensitive`.
To add widgets to the main content area of a `InfoBar`, use
`InfoBarExt::get_content_area` and add your widgets to the container.

Similar to `MessageDialog`, the contents of a `InfoBar` can by
classified as error message, warning, informational message, etc,
by using `InfoBarExt::set_message_type`. GTK+ may use the message type
to determine how the message is displayed.

A simple example for using a `InfoBar`:

```C
// set up info bar
GtkWidget *widget;
GtkInfoBar *bar;

widget = gtk_info_bar_new ();
bar = GTK_INFO_BAR (widget);

gtk_widget_set_no_show_all (widget, TRUE);
message_label = gtk_label_new ("");
gtk_widget_show (message_label);
content_area = gtk_info_bar_get_content_area (bar);
gtk_container_add (GTK_CONTAINER (content_area),
                   message_label);
gtk_info_bar_add_button (bar,
                         _("_OK"),
                         GTK_RESPONSE_OK);
g_signal_connect (bar,
                  "response",
                  G_CALLBACK (gtk_widget_hide),
                  NULL);
gtk_grid_attach (GTK_GRID (grid),
                 widget,
                 0, 2, 1, 1);

...

// show an error message
gtk_label_set_text (GTK_LABEL (message_label), message);
gtk_info_bar_set_message_type (bar,
                               GTK_MESSAGE_ERROR);
gtk_widget_show (bar);
```

# `InfoBar` as `Buildable`

The `InfoBar` implementation of the `Buildable` interface exposes
the content area and action area as internal children with the names
“content_area” and “action_area”.

`InfoBar` supports a custom `<action-widgets>` element, which can contain
multiple `<action-widget>` elements. The “response” attribute specifies a
numeric response, and the content of the element is the id of widget
(which should be a child of the dialogs `action_area`).

# CSS nodes

`InfoBar` has a single CSS node with name infobar. The node may get
one of the style classes .info, .warning, .error or .question, depending
on the message type.

# Implements

[`InfoBarExt`](trait.InfoBarExt.html), [`BoxExt`](trait.BoxExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`OrientableExt`](trait.OrientableExt.html)
<!-- trait InfoBarExt -->
Trait containing all `InfoBar` methods.

# Implementors

[`InfoBar`](struct.InfoBar.html)
<!-- impl InfoBar::fn new -->
Creates a new `InfoBar` object.

# Returns

a new `InfoBar` object
<!-- impl InfoBar::fn new_with_buttons -->
Creates a new `InfoBar` with buttons. Button text/response ID
pairs should be listed, with a `None` pointer ending the list.
Button text can be either a stock ID such as `GTK_STOCK_OK`, or
some arbitrary text. A response ID can be any positive number,
or one of the values in the `ResponseType` enumeration. If the
user clicks one of these dialog buttons, `InfoBar` will emit
the “response” signal with the corresponding response ID.
## `first_button_text`
stock ID or text to go in first button, or `None`

# Returns

a new `InfoBar`
<!-- trait InfoBarExt::fn add_action_widget -->
Add an activatable widget to the action area of a `InfoBar`,
connecting a signal handler that will emit the `InfoBar::response`
signal on the message area when the widget is activated. The widget
is appended to the end of the message areas action area.
## `child`
an activatable widget
## `response_id`
response ID for `child`
<!-- trait InfoBarExt::fn add_button -->
Adds a button with the given text and sets things up so that
clicking the button will emit the “response” signal with the given
response_id. The button is appended to the end of the info bars's
action area. The button widget is returned, but usually you don't
need it.
## `button_text`
text of button
## `response_id`
response ID for the button

# Returns

the `Button` widget
that was added
<!-- trait InfoBarExt::fn add_buttons -->
Adds more buttons, same as calling `InfoBarExt::add_button`
repeatedly. The variable argument list should be `None`-terminated
as with `InfoBar::new_with_buttons`. Each button must have both
text and response ID.
## `first_button_text`
button text or stock ID
<!-- trait InfoBarExt::fn get_action_area -->
Returns the action area of `self`.

# Returns

the action area
<!-- trait InfoBarExt::fn get_content_area -->
Returns the content area of `self`.

# Returns

the content area
<!-- trait InfoBarExt::fn get_message_type -->
Returns the message type of the message area.

# Returns

the message type of the message area.
<!-- trait InfoBarExt::fn get_show_close_button -->
Returns whether the widget will display a standard close button.

Feature: `v3_10`


# Returns

`true` if the widget displays standard close button
<!-- trait InfoBarExt::fn response -->
Emits the “response” signal with the given `response_id`.
## `response_id`
a response ID
<!-- trait InfoBarExt::fn set_default_response -->
Sets the last widget in the info bar’s action area with
the given response_id as the default widget for the dialog.
Pressing “Enter” normally activates the default widget.

Note that this function currently requires `self` to
be added to a widget hierarchy.
## `response_id`
a response ID
<!-- trait InfoBarExt::fn set_message_type -->
Sets the message type of the message area.

GTK+ uses this type to determine how the message is displayed.
## `message_type`
a `MessageType`
<!-- trait InfoBarExt::fn set_response_sensitive -->
Calls gtk_widget_set_sensitive (widget, setting) for each
widget in the info bars’s action area with the given response_id.
A convenient way to sensitize/desensitize dialog buttons.
## `response_id`
a response ID
## `setting`
TRUE for sensitive
<!-- trait InfoBarExt::fn set_show_close_button -->
If true, a standard close button is shown. When clicked it emits
the response `ResponseType::Close`.

Feature: `v3_10`

## `setting`
`true` to include a close button
<!-- trait InfoBarExt::fn connect_close -->
The ::close signal is a
[keybinding signal][`BindingSignal`]
which gets emitted when the user uses a keybinding to dismiss
the info bar.

The default binding for this signal is the Escape key.
<!-- trait InfoBarExt::fn connect_response -->
Emitted when an action widget is clicked or the application programmer
calls `DialogExt::response`. The `response_id` depends on which action
widget was clicked.
## `response_id`
the response ID
<!-- trait InfoBarExt::fn get_property_message-type -->
The type of the message.

The type may be used to determine the appearance of the info bar.
<!-- trait InfoBarExt::fn set_property_message-type -->
The type of the message.

The type may be used to determine the appearance of the info bar.
<!-- trait InfoBarExt::fn get_property_show-close-button -->
Whether to include a standard close button.

Feature: `v3_10`

<!-- trait InfoBarExt::fn set_property_show-close-button -->
Whether to include a standard close button.

Feature: `v3_10`

<!-- enum InputPurpose -->
Describes primary purpose of the input widget. This information is
useful for on-screen keyboards and similar input methods to decide
which keys should be presented to the user.

Note that the purpose is not meant to impose a totally strict rule
about allowed characters, and does not replace input validation.
It is fine for an on-screen keyboard to let the user override the
character set restriction that is expressed by the purpose. The
application is expected to validate the entry contents, even if
it specified a purpose.

The difference between `InputPurpose::Digits` and
`InputPurpose::Number` is that the former accepts only digits
while the latter also some punctuation (like commas or points, plus,
minus) and “e” or “E” as in 3.14E+000.

This enumeration may be extended in the future; input methods should
interpret unknown values as “free form”.
<!-- enum InputPurpose::variant FreeForm -->
Allow any character
<!-- enum InputPurpose::variant Alpha -->
Allow only alphabetic characters
<!-- enum InputPurpose::variant Digits -->
Allow only digits
<!-- enum InputPurpose::variant Number -->
Edited field expects numbers
<!-- enum InputPurpose::variant Phone -->
Edited field expects phone number
<!-- enum InputPurpose::variant Url -->
Edited field expects URL
<!-- enum InputPurpose::variant Email -->
Edited field expects email address
<!-- enum InputPurpose::variant Name -->
Edited field expects the name of a person
<!-- enum InputPurpose::variant Password -->
Like `InputPurpose::FreeForm`, but characters are hidden
<!-- enum InputPurpose::variant Pin -->
Like `InputPurpose::Digits`, but characters are hidden

Feature: `v3_6`

<!-- enum Justification -->
Used for justifying the text inside a `Label` widget. (See also
`Alignment`).
<!-- enum Justification::variant Left -->
The text is placed at the left edge of the label.
<!-- enum Justification::variant Right -->
The text is placed at the right edge of the label.
<!-- enum Justification::variant Center -->
The text is placed in the center of the label.
<!-- enum Justification::variant Fill -->
The text is placed is distributed across the label.
<!-- struct Label -->
The `Label` widget displays a small amount of text. As the name
implies, most labels are used to label another widget such as a
`Button`, a `MenuItem`, or a `ComboBox`.

# CSS nodes


```plain
label
├── [selection]
├── [link]
┊
╰── [link]
```

`Label` has a single CSS node with the name label. A wide variety
of style classes may be applied to labels, such as .title, .subtitle,
.dim-label, etc. In the `ShortcutsWindow`, labels are used wth the
.keycap style class.

If the label has a selection, it gets a subnode with name selection.

If the label has links, there is one subnode per link. These subnodes
carry the link or visited state depending on whether they have been
visited.

# `Label` as `Buildable`

The `Label` implementation of the `Buildable` interface supports a
custom `<attributes>` element, which supports any number of `<attribute>`
elements. The `<attribute>` element has attributes named “name“, “value“,
“start“ and “end“ and allows you to specify `pango::Attribute` values for
this label.

An example of a UI definition fragment specifying Pango attributes:

```C
  // Pressing Alt+H will activate this button
  button = gtk_button_new ();
  label = gtk_label_new_with_mnemonic ("_Hello");
  gtk_container_add (GTK_CONTAINER (button), label);
```

There’s a convenience function to create buttons with a mnemonic label
already inside:


```C
  // Pressing Alt+H will activate this button
  button = gtk_button_new_with_mnemonic ("_Hello");
```

To create a mnemonic for a widget alongside the label, such as a
`Entry`, you have to point the label at the entry with
`LabelExt::set_mnemonic_widget`:


```C
  // Pressing Alt+H will focus the entry
  entry = gtk_entry_new ();
  label = gtk_label_new_with_mnemonic ("_Hello");
  gtk_label_set_mnemonic_widget (GTK_LABEL (label), entry);
```

# Markup (styled text)

To make it easy to format text in a label (changing colors,
fonts, etc.), label text can be provided in a simple
[markup format][PangoMarkupFormat].

Here’s how to create a label with a small font:

```C
  label = gtk_label_new (NULL);
  gtk_label_set_markup (GTK_LABEL (label), "<small>Small text</small>");
```

(See [complete documentation][PangoMarkupFormat] of available
tags in the Pango manual.)

The markup passed to `LabelExt::set_markup` must be valid; for example,
literal <, > and & characters must be escaped as &lt;, &gt;, and &amp;.
If you pass text obtained from the user, file, or a network to
`LabelExt::set_markup`, you’ll want to escape it with
`g_markup_escape_text` or `g_markup_printf_escaped`.

Markup strings are just a convenient way to set the `pango::AttrList` on
a label; `LabelExt::set_attributes` may be a simpler way to set
attributes in some cases. Be careful though; `pango::AttrList` tends to
cause internationalization problems, unless you’re applying attributes
to the entire string (i.e. unless you set the range of each attribute
to [0, `G_MAXINT`)). The reason is that specifying the start_index and
end_index for a `pango::Attribute` requires knowledge of the exact string
being displayed, so translations will cause problems.

# Selectable labels

Labels can be made selectable with `LabelExt::set_selectable`.
Selectable labels allow the user to copy the label contents to
the clipboard. Only labels that contain useful-to-copy information
— such as error messages — should be made selectable.

# Text layout # {`label`-text-layout}

A label can contain any number of paragraphs, but will have
performance problems if it contains more than a small number.
Paragraphs are separated by newlines or other paragraph separators
understood by Pango.

Labels can automatically wrap text if you call
`LabelExt::set_line_wrap`.

`LabelExt::set_justify` sets how the lines in a label align
with one another. If you want to set how the label as a whole
aligns in its available space, see the `Widget:halign` and
`Widget:valign` properties.

The `Label:width-chars` and `Label:max-width-chars` properties
can be used to control the size allocation of ellipsized or wrapped
labels. For ellipsizing labels, if either is specified (and less
than the actual text size), it is used as the minimum width, and the actual
text size is used as the natural width of the label. For wrapping labels,
width-chars is used as the minimum width, if specified, and max-width-chars
is used as the natural width. Even if max-width-chars specified, wrapping
labels will be rewrapped to use all of the available width.

Note that the interpretation of `Label:width-chars` and
`Label:max-width-chars` has changed a bit with the introduction of
[width-for-height geometry management.][geometry-management]

# Links

Since 2.18, GTK+ supports markup for clickable hyperlinks in addition
to regular Pango markup. The markup for links is borrowed from HTML,
using the `<a>` with “href“ and “title“ attributes. GTK+ renders links
similar to the way they appear in web browsers, with colored, underlined
text. The “title“ attribute is displayed as a tooltip on the link.

An example looks like this:


```C
const gchar *text =
"Go to the"
"<a href=\"http://www.gtk.org title="&lt;i&gt;Our&lt;/i&gt; website\">"
"GTK+ website</a> for more...";
gtk_label_set_markup (label, text);
```

It is possible to implement custom handling for links and their tooltips with
the `Label::activate-link` signal and the `LabelExt::get_current_uri` function.

# Implements

[`LabelExt`](trait.LabelExt.html), [`MiscExt`](trait.MiscExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait LabelExt -->
Trait containing all `Label` methods.

# Implementors

[`Label`](struct.Label.html)
<!-- impl Label::fn new -->
Creates a new label with the given text inside it. You can
pass `None` to get an empty label widget.
## `str`
The text of the label

# Returns

the new `Label`
<!-- impl Label::fn new_with_mnemonic -->
Creates a new `Label`, containing the text in `str`.

If characters in `str` are preceded by an underscore, they are
underlined. If you need a literal underscore character in a label, use
'__' (two underscores). The first underlined character represents a
keyboard accelerator called a mnemonic. The mnemonic key can be used
to activate another widget, chosen automatically, or explicitly using
`LabelExt::set_mnemonic_widget`.

If `LabelExt::set_mnemonic_widget` is not called, then the first
activatable ancestor of the `Label` will be chosen as the mnemonic
widget. For instance, if the label is inside a button or menu item,
the button or menu item will automatically become the mnemonic widget
and be activated by the mnemonic.
## `str`
The text of the label, with an underscore in front of the
 mnemonic character

# Returns

the new `Label`
<!-- trait LabelExt::fn get_angle -->
Gets the angle of rotation for the label. See
`LabelExt::set_angle`.

# Returns

the angle of rotation for the label
<!-- trait LabelExt::fn get_attributes -->
Gets the attribute list that was set on the label using
`LabelExt::set_attributes`, if any. This function does
not reflect attributes that come from the labels markup
(see `LabelExt::set_markup`). If you want to get the
effective attributes for the label, use
pango_layout_get_attribute (gtk_label_get_layout (label)).

# Returns

the attribute list, or `None`
 if none was set.
<!-- trait LabelExt::fn get_current_uri -->
Returns the URI for the currently active link in the label.
The active link is the one under the mouse pointer or, in a
selectable label, the link in which the text cursor is currently
positioned.

This function is intended for use in a `Label::activate-link` handler
or for use in a `Widget::query-tooltip` handler.

# Returns

the currently active URI. The string is owned by GTK+ and must
 not be freed or modified.
<!-- trait LabelExt::fn get_ellipsize -->
Returns the ellipsizing position of the label. See `LabelExt::set_ellipsize`.

# Returns

`pango::EllipsizeMode`
<!-- trait LabelExt::fn get_justify -->
Returns the justification of the label. See `LabelExt::set_justify`.

# Returns

`Justification`
<!-- trait LabelExt::fn get_label -->
Fetches the text from a label widget including any embedded
underlines indicating mnemonics and Pango markup. (See
`LabelExt::get_text`).

# Returns

the text of the label widget. This string is
 owned by the widget and must not be modified or freed.
<!-- trait LabelExt::fn get_layout -->
Gets the `pango::Layout` used to display the label.
The layout is useful to e.g. convert text positions to
pixel positions, in combination with `LabelExt::get_layout_offsets`.
The returned layout is owned by the `self` so need not be
freed by the caller. The `self` is free to recreate its layout at
any time, so it should be considered read-only.

# Returns

the `pango::Layout` for this label
<!-- trait LabelExt::fn get_layout_offsets -->
Obtains the coordinates where the label will draw the `pango::Layout`
representing the text in the label; useful to convert mouse events
into coordinates inside the `pango::Layout`, e.g. to take some action
if some part of the label is clicked. Of course you will need to
create a `EventBox` to receive the events, and pack the label
inside it, since labels are windowless (they return `false` from
`WidgetExt::get_has_window`). Remember
when using the `pango::Layout` functions you need to convert to
and from pixels using PANGO_PIXELS() or `PANGO_SCALE`.
## `x`
location to store X offset of layout, or `None`
## `y`
location to store Y offset of layout, or `None`
<!-- trait LabelExt::fn get_line_wrap -->
Returns whether lines in the label are automatically wrapped.
See `LabelExt::set_line_wrap`.

# Returns

`true` if the lines of the label are automatically wrapped.
<!-- trait LabelExt::fn get_line_wrap_mode -->
Returns line wrap mode used by the label. See `LabelExt::set_line_wrap_mode`.

# Returns

`true` if the lines of the label are automatically wrapped.
<!-- trait LabelExt::fn get_lines -->
Gets the number of lines to which an ellipsized, wrapping
label should be limited. See `LabelExt::set_lines`.

Feature: `v3_10`


# Returns

The number of lines
<!-- trait LabelExt::fn get_max_width_chars -->
Retrieves the desired maximum width of `self`, in characters. See
`LabelExt::set_width_chars`.

# Returns

the maximum width of the label in characters.
<!-- trait LabelExt::fn get_mnemonic_keyval -->
If the label has been set so that it has an mnemonic key this function
returns the keyval used for the mnemonic accelerator. If there is no
mnemonic set up it returns `GDK_KEY_VoidSymbol`.

# Returns

GDK keyval usable for accelerators, or `GDK_KEY_VoidSymbol`
<!-- trait LabelExt::fn get_mnemonic_widget -->
Retrieves the target of the mnemonic (keyboard shortcut) of this
label. See `LabelExt::set_mnemonic_widget`.

# Returns

the target of the label’s mnemonic,
 or `None` if none has been set and the default algorithm will be used.
<!-- trait LabelExt::fn get_selectable -->
Gets the value set by `LabelExt::set_selectable`.

# Returns

`true` if the user can copy text from the label
<!-- trait LabelExt::fn get_selection_bounds -->
Gets the selected range of characters in the label, returning `true`
if there’s a selection.
## `start`
return location for start of selection, as a character offset
## `end`
return location for end of selection, as a character offset

# Returns

`true` if selection is non-empty
<!-- trait LabelExt::fn get_single_line_mode -->
Returns whether the label is in single line mode.

# Returns

`true` when the label is in single line mode.
<!-- trait LabelExt::fn get_text -->
Fetches the text from a label widget, as displayed on the
screen. This does not include any embedded underlines
indicating mnemonics or Pango markup. (See `LabelExt::get_label`)

# Returns

the text in the label widget. This is the internal
 string used by the label, and must not be modified.
<!-- trait LabelExt::fn get_track_visited_links -->
Returns whether the label is currently keeping track
of clicked links.

# Returns

`true` if clicked links are remembered
<!-- trait LabelExt::fn get_use_markup -->
Returns whether the label’s text is interpreted as marked up with
the [Pango text markup language][PangoMarkupFormat].
See gtk_label_set_use_markup ().

# Returns

`true` if the label’s text will be parsed for markup.
<!-- trait LabelExt::fn get_use_underline -->
Returns whether an embedded underline in the label indicates a
mnemonic. See `LabelExt::set_use_underline`.

# Returns

`true` whether an embedded underline in the label indicates
 the mnemonic accelerator keys.
<!-- trait LabelExt::fn get_width_chars -->
Retrieves the desired width of `self`, in characters. See
`LabelExt::set_width_chars`.

# Returns

the width of the label in characters.
<!-- trait LabelExt::fn get_xalign -->
Gets the `Label:xalign` property for `self`.

Feature: `v3_16`


# Returns

the xalign property
<!-- trait LabelExt::fn get_yalign -->
Gets the `Label:yalign` property for `self`.

Feature: `v3_16`


# Returns

the yalign property
<!-- trait LabelExt::fn select_region -->
Selects a range of characters in the label, if the label is selectable.
See `LabelExt::set_selectable`. If the label is not selectable,
this function has no effect. If `start_offset` or
`end_offset` are -1, then the end of the label will be substituted.
## `start_offset`
start offset (in characters not bytes)
## `end_offset`
end offset (in characters not bytes)
<!-- trait LabelExt::fn set_angle -->
Sets the angle of rotation for the label. An angle of 90 reads from
from bottom to top, an angle of 270, from top to bottom. The angle
setting for the label is ignored if the label is selectable,
wrapped, or ellipsized.
## `angle`
the angle that the baseline of the label makes with
 the horizontal, in degrees, measured counterclockwise
<!-- trait LabelExt::fn set_attributes -->
Sets a `pango::AttrList`; the attributes in the list are applied to the
label text.

The attributes set with this function will be applied
and merged with any other attributes previously effected by way
of the `Label:use-underline` or `Label:use-markup` properties.
While it is not recommended to mix markup strings with manually set
attributes, if you must; know that the attributes will be applied
to the label after the markup string is parsed.
## `attrs`
a `pango::AttrList`, or `None`
<!-- trait LabelExt::fn set_ellipsize -->
Sets the mode used to ellipsize (add an ellipsis: "...") to the text
if there is not enough space to render the entire string.
## `mode`
a `pango::EllipsizeMode`
<!-- trait LabelExt::fn set_justify -->
Sets the alignment of the lines in the text of the label relative to
each other. `Justification::Left` is the default value when the widget is
first created with `Label::new`. If you instead want to set the
alignment of the label as a whole, use `WidgetExt::set_halign` instead.
`LabelExt::set_justify` has no effect on labels containing only a
single line.
## `jtype`
a `Justification`
<!-- trait LabelExt::fn set_label -->
Sets the text of the label. The label is interpreted as
including embedded underlines and/or Pango markup depending
on the values of the `Label:use-underline` and
`Label:use-markup` properties.
## `str`
the new text to set for the label
<!-- trait LabelExt::fn set_line_wrap -->
Toggles line wrapping within the `Label` widget. `true` makes it break
lines if text exceeds the widget’s size. `false` lets the text get cut off
by the edge of the widget if it exceeds the widget size.

Note that setting line wrapping to `true` does not make the label
wrap at its parent container’s width, because GTK+ widgets
conceptually can’t make their requisition depend on the parent
container’s size. For a label that wraps at a specific position,
set the label’s width using `WidgetExt::set_size_request`.
## `wrap`
the setting
<!-- trait LabelExt::fn set_line_wrap_mode -->
If line wrapping is on (see `LabelExt::set_line_wrap`) this controls how
the line wrapping is done. The default is `pango::WrapMode::Word` which means
wrap on word boundaries.
## `wrap_mode`
the line wrapping mode
<!-- trait LabelExt::fn set_lines -->
Sets the number of lines to which an ellipsized, wrapping label
should be limited. This has no effect if the label is not wrapping
or ellipsized. Set this to -1 if you don’t want to limit the
number of lines.

Feature: `v3_10`

## `lines`
the desired number of lines, or -1
<!-- trait LabelExt::fn set_markup -->
Parses `str` which is marked up with the
[Pango text markup language][PangoMarkupFormat], setting the
label’s text and attribute list based on the parse results.

If the `str` is external data, you may need to escape it with
`g_markup_escape_text` or `g_markup_printf_escaped`:


```C
const char *format = "<span style=\"italic\">\%s</span>";
char *markup;

markup = g_markup_printf_escaped (format, str);
gtk_label_set_markup (GTK_LABEL (label), markup);
g_free (markup);
```

This function will set the `Label:use-markup` property to `true` as
a side effect.

If you set the label contents using the `Label:label` property you
should also ensure that you set the `Label:use-markup` property
accordingly.

See also: `LabelExt::set_text`
## `str`
a markup string (see [Pango markup format][PangoMarkupFormat])
<!-- trait LabelExt::fn set_markup_with_mnemonic -->
Parses `str` which is marked up with the
[Pango text markup language][PangoMarkupFormat],
setting the label’s text and attribute list based on the parse results.
If characters in `str` are preceded by an underscore, they are underlined
indicating that they represent a keyboard accelerator called a mnemonic.

The mnemonic key can be used to activate another widget, chosen
automatically, or explicitly using `LabelExt::set_mnemonic_widget`.
## `str`
a markup string (see
 [Pango markup format][PangoMarkupFormat])
<!-- trait LabelExt::fn set_max_width_chars -->
Sets the desired maximum width in characters of `self` to `n_chars`.
## `n_chars`
the new desired maximum width, in characters.
<!-- trait LabelExt::fn set_mnemonic_widget -->
If the label has been set so that it has an mnemonic key (using
i.e. `LabelExt::set_markup_with_mnemonic`,
`LabelExt::set_text_with_mnemonic`, `Label::new_with_mnemonic`
or the “use_underline” property) the label can be associated with a
widget that is the target of the mnemonic. When the label is inside
a widget (like a `Button` or a `Notebook` tab) it is
automatically associated with the correct widget, but sometimes
(i.e. when the target is a `Entry` next to the label) you need to
set it explicitly using this function.

The target widget will be accelerated by emitting the
`Widget`::mnemonic-activate signal on it. The default handler for
this signal will activate the widget if there are no mnemonic collisions
and toggle focus between the colliding widgets otherwise.
## `widget`
the target `Widget`
<!-- trait LabelExt::fn set_pattern -->
The pattern of underlines you want under the existing text within the
`Label` widget. For example if the current text of the label says
“FooBarBaz” passing a pattern of “___ ___” will underline
“Foo” and “Baz” but not “Bar”.
## `pattern`
The pattern as described above.
<!-- trait LabelExt::fn set_selectable -->
Selectable labels allow the user to select text from the label, for
copy-and-paste.
## `setting`
`true` to allow selecting text in the label
<!-- trait LabelExt::fn set_single_line_mode -->
Sets whether the label is in single line mode.
## `single_line_mode`
`true` if the label should be in single line mode
<!-- trait LabelExt::fn set_text -->
Sets the text within the `Label` widget. It overwrites any text that
was there before.

This function will clear any previously set mnemonic accelerators, and
set the `Label:use-underline` property to `false` as a side effect.

This function will set the `Label:use-markup` property to `false`
as a side effect.

See also: `LabelExt::set_markup`
## `str`
The text you want to set
<!-- trait LabelExt::fn set_text_with_mnemonic -->
Sets the label’s text from the string `str`.
If characters in `str` are preceded by an underscore, they are underlined
indicating that they represent a keyboard accelerator called a mnemonic.
The mnemonic key can be used to activate another widget, chosen
automatically, or explicitly using `LabelExt::set_mnemonic_widget`.
## `str`
a string
<!-- trait LabelExt::fn set_track_visited_links -->
Sets whether the label should keep track of clicked
links (and use a different color for them).
## `track_links`
`true` to track visited links
<!-- trait LabelExt::fn set_use_markup -->
Sets whether the text of the label contains markup in
[Pango’s text markup language][PangoMarkupFormat].
See `LabelExt::set_markup`.
## `setting`
`true` if the label’s text should be parsed for markup.
<!-- trait LabelExt::fn set_use_underline -->
If true, an underline in the text indicates the next character should be
used for the mnemonic accelerator key.
## `setting`
`true` if underlines in the text indicate mnemonics
<!-- trait LabelExt::fn set_width_chars -->
Sets the desired width in characters of `self` to `n_chars`.
## `n_chars`
the new desired width, in characters.
<!-- trait LabelExt::fn set_xalign -->
Sets the `Label:xalign` property for `self`.

Feature: `v3_16`

## `xalign`
the new xalign value, between 0 and 1
<!-- trait LabelExt::fn set_yalign -->
Sets the `Label:yalign` property for `self`.

Feature: `v3_16`

## `yalign`
the new yalign value, between 0 and 1
<!-- trait LabelExt::fn connect_activate_current_link -->
A [keybinding signal][`BindingSignal`]
which gets emitted when the user activates a link in the label.

Applications may also emit the signal with `g_signal_emit_by_name`
if they need to control activation of URIs programmatically.

The default bindings for this signal are all forms of the Enter key.
<!-- trait LabelExt::fn connect_activate_link -->
The signal which gets emitted to activate a URI.
Applications may connect to it to override the default behaviour,
which is to call `gtk_show_uri_on_window`.
## `uri`
the URI that is activated

# Returns

`true` if the link has been activated
<!-- trait LabelExt::fn connect_copy_clipboard -->
The ::copy-clipboard signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to copy the selection to the clipboard.

The default binding for this signal is Ctrl-c.
<!-- trait LabelExt::fn connect_move_cursor -->
The ::move-cursor signal is a
[keybinding signal][`BindingSignal`]
which gets emitted when the user initiates a cursor movement.
If the cursor is not visible in `entry`, this signal causes
the viewport to be moved instead.

Applications should not connect to it, but may emit it with
`g_signal_emit_by_name` if they need to control the cursor
programmatically.

The default bindings for this signal come in two variants,
the variant with the Shift modifier extends the selection,
the variant without the Shift modifer does not.
There are too many key combinations to list them all here.
- Arrow keys move by individual characters/lines
- Ctrl-arrow key combinations move by words/paragraphs
- Home/End keys move to the ends of the buffer
## `step`
the granularity of the move, as a `MovementStep`
## `count`
the number of `step` units to move
## `extend_selection`
`true` if the move should extend the selection
<!-- trait LabelExt::fn connect_populate_popup -->
The ::populate-popup signal gets emitted before showing the
context menu of the label. Note that only selectable labels
have context menus.

If you need to add items to the context menu, connect
to this signal and append your menuitems to the `menu`.
## `menu`
the menu that is being populated
<!-- trait LabelExt::fn get_property_angle -->
The angle that the baseline of the label makes with the horizontal,
in degrees, measured counterclockwise. An angle of 90 reads from
from bottom to top, an angle of 270, from top to bottom. Ignored
if the label is selectable.
<!-- trait LabelExt::fn set_property_angle -->
The angle that the baseline of the label makes with the horizontal,
in degrees, measured counterclockwise. An angle of 90 reads from
from bottom to top, an angle of 270, from top to bottom. Ignored
if the label is selectable.
<!-- trait LabelExt::fn get_property_ellipsize -->
The preferred place to ellipsize the string, if the label does
not have enough room to display the entire string, specified as a
`pango::EllipsizeMode`.

Note that setting this property to a value other than
`pango::EllipsizeMode::None` has the side-effect that the label requests
only enough space to display the ellipsis "...". In particular, this
means that ellipsizing labels do not work well in notebook tabs, unless
the `Notebook` tab-expand child property is set to `true`. Other ways
to set a label's width are `WidgetExt::set_size_request` and
`LabelExt::set_width_chars`.
<!-- trait LabelExt::fn set_property_ellipsize -->
The preferred place to ellipsize the string, if the label does
not have enough room to display the entire string, specified as a
`pango::EllipsizeMode`.

Note that setting this property to a value other than
`pango::EllipsizeMode::None` has the side-effect that the label requests
only enough space to display the ellipsis "...". In particular, this
means that ellipsizing labels do not work well in notebook tabs, unless
the `Notebook` tab-expand child property is set to `true`. Other ways
to set a label's width are `WidgetExt::set_size_request` and
`LabelExt::set_width_chars`.
<!-- trait LabelExt::fn get_property_label -->
The contents of the label.

If the string contains [Pango XML markup][PangoMarkupFormat], you will
have to set the `Label:use-markup` property to `true` in order for the
label to display the markup attributes. See also `LabelExt::set_markup`
for a convenience function that sets both this property and the
`Label:use-markup` property at the same time.

If the string contains underlines acting as mnemonics, you will have to
set the `Label:use-underline` property to `true` in order for the label
to display them.
<!-- trait LabelExt::fn set_property_label -->
The contents of the label.

If the string contains [Pango XML markup][PangoMarkupFormat], you will
have to set the `Label:use-markup` property to `true` in order for the
label to display the markup attributes. See also `LabelExt::set_markup`
for a convenience function that sets both this property and the
`Label:use-markup` property at the same time.

If the string contains underlines acting as mnemonics, you will have to
set the `Label:use-underline` property to `true` in order for the label
to display them.
<!-- trait LabelExt::fn get_property_lines -->
The number of lines to which an ellipsized, wrapping label
should be limited. This property has no effect if the
label is not wrapping or ellipsized. Set this property to
-1 if you don't want to limit the number of lines.

Feature: `v3_10`

<!-- trait LabelExt::fn set_property_lines -->
The number of lines to which an ellipsized, wrapping label
should be limited. This property has no effect if the
label is not wrapping or ellipsized. Set this property to
-1 if you don't want to limit the number of lines.

Feature: `v3_10`

<!-- trait LabelExt::fn get_property_max-width-chars -->
The desired maximum width of the label, in characters. If this property
is set to -1, the width will be calculated automatically.

See the section on [text layout][label-text-layout]
for details of how `Label:width-chars` and `Label:max-width-chars`
determine the width of ellipsized and wrapped labels.
<!-- trait LabelExt::fn set_property_max-width-chars -->
The desired maximum width of the label, in characters. If this property
is set to -1, the width will be calculated automatically.

See the section on [text layout][label-text-layout]
for details of how `Label:width-chars` and `Label:max-width-chars`
determine the width of ellipsized and wrapped labels.
<!-- trait LabelExt::fn get_property_single-line-mode -->
Whether the label is in single line mode. In single line mode,
the height of the label does not depend on the actual text, it
is always set to ascent + descent of the font. This can be an
advantage in situations where resizing the label because of text
changes would be distracting, e.g. in a statusbar.
<!-- trait LabelExt::fn set_property_single-line-mode -->
Whether the label is in single line mode. In single line mode,
the height of the label does not depend on the actual text, it
is always set to ascent + descent of the font. This can be an
advantage in situations where resizing the label because of text
changes would be distracting, e.g. in a statusbar.
<!-- trait LabelExt::fn get_property_track-visited-links -->
Set this property to `true` to make the label track which links
have been visited. It will then apply the `StateFlags::Visited`
when rendering this link, in addition to `StateFlags::Link`.
<!-- trait LabelExt::fn set_property_track-visited-links -->
Set this property to `true` to make the label track which links
have been visited. It will then apply the `StateFlags::Visited`
when rendering this link, in addition to `StateFlags::Link`.
<!-- trait LabelExt::fn get_property_width-chars -->
The desired width of the label, in characters. If this property is set to
-1, the width will be calculated automatically.

See the section on [text layout][label-text-layout]
for details of how `Label:width-chars` and `Label:max-width-chars`
determine the width of ellipsized and wrapped labels.
<!-- trait LabelExt::fn set_property_width-chars -->
The desired width of the label, in characters. If this property is set to
-1, the width will be calculated automatically.

See the section on [text layout][label-text-layout]
for details of how `Label:width-chars` and `Label:max-width-chars`
determine the width of ellipsized and wrapped labels.
<!-- trait LabelExt::fn get_property_wrap-mode -->
If line wrapping is on (see the `Label:wrap` property) this controls
how the line wrapping is done. The default is `pango::WrapMode::Word`, which
means wrap on word boundaries.
<!-- trait LabelExt::fn set_property_wrap-mode -->
If line wrapping is on (see the `Label:wrap` property) this controls
how the line wrapping is done. The default is `pango::WrapMode::Word`, which
means wrap on word boundaries.
<!-- trait LabelExt::fn get_property_xalign -->
The xalign property determines the horizontal aligment of the label text
inside the labels size allocation. Compare this to `Widget:halign`,
which determines how the labels size allocation is positioned in the
space available for the label.

Feature: `v3_16`

<!-- trait LabelExt::fn set_property_xalign -->
The xalign property determines the horizontal aligment of the label text
inside the labels size allocation. Compare this to `Widget:halign`,
which determines how the labels size allocation is positioned in the
space available for the label.

Feature: `v3_16`

<!-- trait LabelExt::fn get_property_yalign -->
The yalign property determines the vertical aligment of the label text
inside the labels size allocation. Compare this to `Widget:valign`,
which determines how the labels size allocation is positioned in the
space available for the label.

Feature: `v3_16`

<!-- trait LabelExt::fn set_property_yalign -->
The yalign property determines the vertical aligment of the label text
inside the labels size allocation. Compare this to `Widget:valign`,
which determines how the labels size allocation is positioned in the
space available for the label.

Feature: `v3_16`

<!-- struct Layout -->
`Layout` is similar to `DrawingArea` in that it’s a “blank slate” and
doesn’t do anything except paint a blank background by default. It’s
different in that it supports scrolling natively due to implementing
`Scrollable`, and can contain child widgets since it’s a `Container`.

If you just want to draw, a `DrawingArea` is a better choice since it has
lower overhead. If you just need to position child widgets at specific
points, then `Fixed` provides that functionality on its own.

When handling expose events on a `Layout`, you must draw to the `gdk::Window`
returned by `LayoutExt::get_bin_window`, rather than to the one returned by
`WidgetExt::get_window` as you would for a `DrawingArea`.

# Implements

[`LayoutExt`](trait.LayoutExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`ScrollableExt`](trait.ScrollableExt.html)
<!-- trait LayoutExt -->
Trait containing all `Layout` methods.

# Implementors

[`Layout`](struct.Layout.html)
<!-- impl Layout::fn new -->
Creates a new `Layout`. Unless you have a specific adjustment
you’d like the layout to use for scrolling, pass `None` for
`hadjustment` and `vadjustment`.
## `hadjustment`
horizontal scroll adjustment, or `None`
## `vadjustment`
vertical scroll adjustment, or `None`

# Returns

a new `Layout`
<!-- trait LayoutExt::fn get_bin_window -->
Retrieve the bin window of the layout used for drawing operations.

# Returns

a `gdk::Window`
<!-- trait LayoutExt::fn get_hadjustment -->
This function should only be called after the layout has been
placed in a `ScrolledWindow` or otherwise configured for
scrolling. It returns the `Adjustment` used for communication
between the horizontal scrollbar and `self`.

See `ScrolledWindow`, `Scrollbar`, `Adjustment` for details.

# Deprecated since 3.0

Use `Scrollable::get_hadjustment`

# Returns

horizontal scroll adjustment
<!-- trait LayoutExt::fn get_size -->
Gets the size that has been set on the layout, and that determines
the total extents of the layout’s scrollbar area. See
gtk_layout_set_size ().
## `width`
location to store the width set on
 `self`, or `None`
## `height`
location to store the height set on
 `self`, or `None`
<!-- trait LayoutExt::fn get_vadjustment -->
This function should only be called after the layout has been
placed in a `ScrolledWindow` or otherwise configured for
scrolling. It returns the `Adjustment` used for communication
between the vertical scrollbar and `self`.

See `ScrolledWindow`, `Scrollbar`, `Adjustment` for details.

# Deprecated since 3.0

Use `Scrollable::get_vadjustment`

# Returns

vertical scroll adjustment
<!-- trait LayoutExt::fn move -->
Moves a current child of `self` to a new position.
## `child_widget`
a current child of `self`
## `x`
X position to move to
## `y`
Y position to move to
<!-- trait LayoutExt::fn put -->
Adds `child_widget` to `self`, at position (`x`,`y`).
`self` becomes the new parent container of `child_widget`.
## `child_widget`
child widget
## `x`
X position of child widget
## `y`
Y position of child widget
<!-- trait LayoutExt::fn set_hadjustment -->
Sets the horizontal scroll adjustment for the layout.

See `ScrolledWindow`, `Scrollbar`, `Adjustment` for details.

# Deprecated since 3.0

Use `Scrollable::set_hadjustment`
## `adjustment`
new scroll adjustment
<!-- trait LayoutExt::fn set_size -->
Sets the size of the scrollable area of the layout.
## `width`
width of entire scrollable area
## `height`
height of entire scrollable area
<!-- trait LayoutExt::fn set_vadjustment -->
Sets the vertical scroll adjustment for the layout.

See `ScrolledWindow`, `Scrollbar`, `Adjustment` for details.

# Deprecated since 3.0

Use `Scrollable::set_vadjustment`
## `adjustment`
new scroll adjustment
<!-- struct LevelBar -->
The `LevelBar` is a bar widget that can be used
as a level indicator. Typical use cases are displaying the strength
of a password, or showing the charge level of a battery.

Use `LevelBarExt::set_value` to set the current value, and
`LevelBarExt::add_offset_value` to set the value offsets at which
the bar will be considered in a different state. GTK will add a few
offsets by default on the level bar: `GTK_LEVEL_BAR_OFFSET_LOW`,
`GTK_LEVEL_BAR_OFFSET_HIGH` and `GTK_LEVEL_BAR_OFFSET_FULL`, with
values 0.25, 0.75 and 1.0 respectively.

Note that it is your responsibility to update preexisting offsets
when changing the minimum or maximum value. GTK+ will simply clamp
them to the new range.

## Adding a custom offset on the bar


```C

static GtkWidget *
create_level_bar (void)
{
  GtkWidget *widget;
  GtkLevelBar *bar;

  widget = gtk_level_bar_new ();
  bar = GTK_LEVEL_BAR (widget);

  // This changes the value of the default low offset

  gtk_level_bar_add_offset_value (bar,
                                  GTK_LEVEL_BAR_OFFSET_LOW,
                                  0.10);

  // This adds a new offset to the bar; the application will
  // be able to change its color CSS like this:
  //
  // levelbar block.my-offset {
  //   background-color: magenta;
  //   border-style: solid;
  //   border-color: black;
  //   border-style: 1px;
  // }

  gtk_level_bar_add_offset_value (bar, "my-offset", 0.60);

  return widget;
}
```

The default interval of values is between zero and one, but it’s possible to
modify the interval using `LevelBarExt::set_min_value` and
`LevelBarExt::set_max_value`. The value will be always drawn in proportion to
the admissible interval, i.e. a value of 15 with a specified interval between
10 and 20 is equivalent to a value of 0.5 with an interval between 0 and 1.
When `LevelBarMode::Discrete` is used, the bar level is rendered
as a finite number of separated blocks instead of a single one. The number
of blocks that will be rendered is equal to the number of units specified by
the admissible interval.

For instance, to build a bar rendered with five blocks, it’s sufficient to
set the minimum value to 0 and the maximum value to 5 after changing the indicator
mode to discrete.

`LevelBar` was introduced in GTK+ 3.6.

# `LevelBar` as `Buildable`

The `LevelBar` implementation of the `Buildable` interface supports a
custom `<offsets>` element, which can contain any number of `<offset>` elements,
each of which must have name and value attributes.

# CSS nodes


```plain
levelbar[.discrete]
╰── trough
    ├── block.filled.level-name
    ┊
    ├── block.empty
    ┊
```

`LevelBar` has a main CSS node with name levelbar and one of the style
classes .discrete or .continuous and a subnode with name trough. Below the
trough node are a number of nodes with name block and style class .filled
or .empty. In continuous mode, there is exactly one node of each, in discrete
mode, the number of filled and unfilled nodes corresponds to blocks that are
drawn. The block.filled nodes also get a style class .level-name corresponding
to the level for the current value.

In horizontal orientation, the nodes are always arranged from left to right,
regardless of text direction.

Feature: `v3_6`

# Implements

[`LevelBarExt`](trait.LevelBarExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`OrientableExt`](trait.OrientableExt.html)
<!-- trait LevelBarExt -->
Trait containing all `LevelBar` methods.

Feature: `v3_6`

# Implementors

[`LevelBar`](struct.LevelBar.html)
<!-- impl LevelBar::fn new -->
Creates a new `LevelBar`.

Feature: `v3_6`


# Returns

a `LevelBar`.
<!-- impl LevelBar::fn new_for_interval -->
Utility constructor that creates a new `LevelBar` for the specified
interval.

Feature: `v3_6`

## `min_value`
a positive value
## `max_value`
a positive value

# Returns

a `LevelBar`
<!-- trait LevelBarExt::fn add_offset_value -->
Adds a new offset marker on `self` at the position specified by `value`.
When the bar value is in the interval topped by `value` (or between `value`
and `LevelBar:max-value` in case the offset is the last one on the bar)
a style class named `level-``name` will be applied
when rendering the level bar fill.
If another offset marker named `name` exists, its value will be
replaced by `value`.

Feature: `v3_6`

## `name`
the name of the new offset
## `value`
the value for the new offset
<!-- trait LevelBarExt::fn get_inverted -->
Return the value of the `LevelBar:inverted` property.

Feature: `v3_8`


# Returns

`true` if the level bar is inverted
<!-- trait LevelBarExt::fn get_max_value -->
Returns the value of the `LevelBar:max-value` property.

Feature: `v3_6`


# Returns

a positive value
<!-- trait LevelBarExt::fn get_min_value -->
Returns the value of the `LevelBar:min-value` property.

Feature: `v3_6`


# Returns

a positive value
<!-- trait LevelBarExt::fn get_mode -->
Returns the value of the `LevelBar:mode` property.

Feature: `v3_6`


# Returns

a `LevelBarMode`
<!-- trait LevelBarExt::fn get_offset_value -->
Fetches the value specified for the offset marker `name` in `self`,
returning `true` in case an offset named `name` was found.

Feature: `v3_6`

## `name`
the name of an offset in the bar
## `value`
location where to store the value

# Returns

`true` if the specified offset is found
<!-- trait LevelBarExt::fn get_value -->
Returns the value of the `LevelBar:value` property.

Feature: `v3_6`


# Returns

a value in the interval between
 `LevelBar:min-value` and `LevelBar:max-value`
<!-- trait LevelBarExt::fn remove_offset_value -->
Removes an offset marker previously added with
`LevelBarExt::add_offset_value`.

Feature: `v3_6`

## `name`
the name of an offset in the bar
<!-- trait LevelBarExt::fn set_inverted -->
Sets the value of the `LevelBar:inverted` property.

Feature: `v3_8`

## `inverted`
`true` to invert the level bar
<!-- trait LevelBarExt::fn set_max_value -->
Sets the value of the `LevelBar:max-value` property.

You probably want to update preexisting level offsets after calling
this function.

Feature: `v3_6`

## `value`
a positive value
<!-- trait LevelBarExt::fn set_min_value -->
Sets the value of the `LevelBar:min-value` property.

You probably want to update preexisting level offsets after calling
this function.

Feature: `v3_6`

## `value`
a positive value
<!-- trait LevelBarExt::fn set_mode -->
Sets the value of the `LevelBar:mode` property.

Feature: `v3_6`

## `mode`
a `LevelBarMode`
<!-- trait LevelBarExt::fn set_value -->
Sets the value of the `LevelBar:value` property.

Feature: `v3_6`

## `value`
a value in the interval between
 `LevelBar:min-value` and `LevelBar:max-value`
<!-- trait LevelBarExt::fn connect_offset_changed -->
Emitted when an offset specified on the bar changes value as an
effect to `LevelBarExt::add_offset_value` being called.

The signal supports detailed connections; you can connect to the
detailed signal "changed::x" in order to only receive callbacks when
the value of offset "x" changes.

Feature: `v3_6`

## `name`
the name of the offset that changed value
<!-- trait LevelBarExt::fn get_property_inverted -->
Level bars normally grow from top to bottom or left to right.
Inverted level bars grow in the opposite direction.

Feature: `v3_8`

<!-- trait LevelBarExt::fn set_property_inverted -->
Level bars normally grow from top to bottom or left to right.
Inverted level bars grow in the opposite direction.

Feature: `v3_8`

<!-- trait LevelBarExt::fn get_property_max-value -->
The `LevelBar:max-value` property determaxes the maximum value of
the interval that can be displayed by the bar.

Feature: `v3_6`

<!-- trait LevelBarExt::fn set_property_max-value -->
The `LevelBar:max-value` property determaxes the maximum value of
the interval that can be displayed by the bar.

Feature: `v3_6`

<!-- trait LevelBarExt::fn get_property_min-value -->
The `LevelBar:min-value` property determines the minimum value of
the interval that can be displayed by the bar.

Feature: `v3_6`

<!-- trait LevelBarExt::fn set_property_min-value -->
The `LevelBar:min-value` property determines the minimum value of
the interval that can be displayed by the bar.

Feature: `v3_6`

<!-- trait LevelBarExt::fn get_property_mode -->
The `LevelBar:mode` property determines the way `LevelBar`
interprets the value properties to draw the level fill area.
Specifically, when the value is `LevelBarMode::Continuous`,
`LevelBar` will draw a single block representing the current value in
that area; when the value is `LevelBarMode::Discrete`,
the widget will draw a succession of separate blocks filling the
draw area, with the number of blocks being equal to the units separating
the integral roundings of `LevelBar:min-value` and `LevelBar:max-value`.

Feature: `v3_6`

<!-- trait LevelBarExt::fn set_property_mode -->
The `LevelBar:mode` property determines the way `LevelBar`
interprets the value properties to draw the level fill area.
Specifically, when the value is `LevelBarMode::Continuous`,
`LevelBar` will draw a single block representing the current value in
that area; when the value is `LevelBarMode::Discrete`,
the widget will draw a succession of separate blocks filling the
draw area, with the number of blocks being equal to the units separating
the integral roundings of `LevelBar:min-value` and `LevelBar:max-value`.

Feature: `v3_6`

<!-- trait LevelBarExt::fn get_property_value -->
The `LevelBar:value` property determines the currently
filled value of the level bar.

Feature: `v3_6`

<!-- trait LevelBarExt::fn set_property_value -->
The `LevelBar:value` property determines the currently
filled value of the level bar.

Feature: `v3_6`

<!-- enum LevelBarMode -->
Describes how `LevelBar` contents should be rendered.
Note that this enumeration could be extended with additional modes
in the future.
<!-- enum LevelBarMode::variant Continuous -->
the bar has a continuous mode
<!-- enum LevelBarMode::variant Discrete -->
the bar has a discrete mode

Feature: `v3_6`

<!-- enum License -->
The type of license for an application.

This enumeration can be expanded at later date.
<!-- enum License::variant Unknown -->
No license specified
<!-- enum License::variant Custom -->
A license text is going to be specified by the
 developer
<!-- enum License::variant Gpl20 -->
The GNU General Public License, version 2.0 or later
<!-- enum License::variant Gpl30 -->
The GNU General Public License, version 3.0 or later
<!-- enum License::variant Lgpl21 -->
The GNU Lesser General Public License, version 2.1 or later
<!-- enum License::variant Lgpl30 -->
The GNU Lesser General Public License, version 3.0 or later
<!-- enum License::variant Bsd -->
The BSD standard license
<!-- enum License::variant MitX11 -->
The MIT/X11 standard license
<!-- enum License::variant Artistic -->
The Artistic License, version 2.0
<!-- enum License::variant Gpl20Only -->
The GNU General Public License, version 2.0 only. Since 3.12.
<!-- enum License::variant Gpl30Only -->
The GNU General Public License, version 3.0 only. Since 3.12.
<!-- enum License::variant Lgpl21Only -->
The GNU Lesser General Public License, version 2.1 only. Since 3.12.
<!-- enum License::variant Lgpl30Only -->
The GNU Lesser General Public License, version 3.0 only. Since 3.12.
<!-- enum License::variant Agpl30 -->
The GNU Affero General Public License, version 3.0 or later. Since: 3.22.
<!-- struct LinkButton -->
A `LinkButton` is a `Button` with a hyperlink, similar to the one
used by web browsers, which triggers an action when clicked. It is useful
to show quick links to resources.

A link button is created by calling either `LinkButton::new` or
`LinkButton::new_with_label`. If using the former, the URI you pass
to the constructor is used as a label for the widget.

The URI bound to a `LinkButton` can be set specifically using
`LinkButtonExt::set_uri`, and retrieved using `LinkButtonExt::get_uri`.

By default, `LinkButton` calls `gtk_show_uri_on_window` when the button is
clicked. This behaviour can be overridden by connecting to the
`LinkButton::activate-link` signal and returning `true` from the
signal handler.

# CSS nodes

`LinkButton` has a single CSS node with name button. To differentiate
it from a plain `Button`, it gets the .link style class.

# Implements

[`LinkButtonExt`](trait.LinkButtonExt.html), [`ButtonExt`](trait.ButtonExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`ActionableExt`](trait.ActionableExt.html)
<!-- trait LinkButtonExt -->
Trait containing all `LinkButton` methods.

# Implementors

[`LinkButton`](struct.LinkButton.html)
<!-- impl LinkButton::fn new -->
Creates a new `LinkButton` with the URI as its text.
## `uri`
a valid URI

# Returns

a new link button widget.
<!-- impl LinkButton::fn new_with_label -->
Creates a new `LinkButton` containing a label.
## `uri`
a valid URI
## `label`
the text of the button

# Returns

a new link button widget.
<!-- trait LinkButtonExt::fn get_uri -->
Retrieves the URI set using `LinkButtonExt::set_uri`.

# Returns

a valid URI. The returned string is owned by the link button
 and should not be modified or freed.
<!-- trait LinkButtonExt::fn get_visited -->
Retrieves the “visited” state of the URI where the `LinkButton`
points. The button becomes visited when it is clicked. If the URI
is changed on the button, the “visited” state is unset again.

The state may also be changed using `LinkButtonExt::set_visited`.

# Returns

`true` if the link has been visited, `false` otherwise
<!-- trait LinkButtonExt::fn set_uri -->
Sets `uri` as the URI where the `LinkButton` points. As a side-effect
this unsets the “visited” state of the button.
## `uri`
a valid URI
<!-- trait LinkButtonExt::fn set_visited -->
Sets the “visited” state of the URI where the `LinkButton`
points. See `LinkButtonExt::get_visited` for more details.
## `visited`
the new “visited” state
<!-- trait LinkButtonExt::fn connect_activate_link -->
The ::activate-link signal is emitted each time the `LinkButton`
has been clicked.

The default handler will call `gtk_show_uri_on_window` with the URI stored inside
the `LinkButton:uri` property.

To override the default behavior, you can connect to the ::activate-link
signal and stop the propagation of the signal by returning `true` from
your handler.
<!-- trait LinkButtonExt::fn get_property_uri -->
The URI bound to this button.
<!-- trait LinkButtonExt::fn set_property_uri -->
The URI bound to this button.
<!-- trait LinkButtonExt::fn get_property_visited -->
The 'visited' state of this button. A visited link is drawn in a
different color.
<!-- trait LinkButtonExt::fn set_property_visited -->
The 'visited' state of this button. A visited link is drawn in a
different color.
<!-- struct ListBox -->
A `ListBox` is a vertical container that contains `ListBoxRow`
children. These rows can by dynamically sorted and filtered, and
headers can be added dynamically depending on the row content.
It also allows keyboard and mouse navigation and selection like
a typical list.

Using `ListBox` is often an alternative to `TreeView`, especially
when the list contents has a more complicated layout than what is allowed
by a `CellRenderer`, or when the contents is interactive (i.e. has a
button in it).

Although a `ListBox` must have only `ListBoxRow` children you can
add any kind of widget to it via `ContainerExt::add`, and a `ListBoxRow`
widget will automatically be inserted between the list and the widget.

``GtkListBoxRows`` can be marked as activatable or selectable. If a row
is activatable, `ListBox::row-activated` will be emitted for it when
the user tries to activate it. If it is selectable, the row will be marked
as selected when the user tries to select it.

The `ListBox` widget was added in GTK+ 3.10.

# CSS nodes


```plain
list
╰── row[.activatable]
```

`ListBox` uses a single CSS node named list. Each `ListBoxRow` uses
a single CSS node named row. The row nodes get the .activatable
style class added when appropriate.

Feature: `v3_10`

# Implements

[`ListBoxExt`](trait.ListBoxExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait ListBoxExt -->
Trait containing all `ListBox` methods.

Feature: `v3_10`

# Implementors

[`ListBox`](struct.ListBox.html)
<!-- impl ListBox::fn new -->
Creates a new `ListBox` container.

Feature: `v3_10`


# Returns

a new `ListBox`
<!-- trait ListBoxExt::fn bind_model -->
Binds `model` to `self`.

If `self` was already bound to a model, that previous binding is
destroyed.

The contents of `self` are cleared and then filled with widgets that
represent items from `model`. `self` is updated whenever `model` changes.
If `model` is `None`, `self` is left empty.

It is undefined to add or remove widgets directly (for example, with
`ListBoxExt::insert` or `ContainerExt::add`) while `self` is bound to a
model.

Note that using a model is incompatible with the filtering and sorting
functionality in `ListBox`. When using a model, filtering and sorting
should be implemented by the model.

Feature: `v3_16`

## `model`
the `gio::ListModel` to be bound to `self`
## `create_widget_func`
a function that creates widgets for items
 or `None` in case you also passed `None` as `model`
## `user_data`
user data passed to `create_widget_func`
## `user_data_free_func`
function for freeing `user_data`
<!-- trait ListBoxExt::fn drag_highlight_row -->
This is a helper function for implementing DnD onto a `ListBox`.
The passed in `row` will be highlighted via `WidgetExt::drag_highlight`,
and any previously highlighted row will be unhighlighted.

The row will also be unhighlighted when the widget gets
a drag leave event.

Feature: `v3_10`

## `row`
a `ListBoxRow`
<!-- trait ListBoxExt::fn drag_unhighlight_row -->
If a row has previously been highlighted via `ListBoxExt::drag_highlight_row`
it will have the highlight removed.

Feature: `v3_10`

<!-- trait ListBoxExt::fn get_activate_on_single_click -->
Returns whether rows activate on single clicks.

Feature: `v3_10`


# Returns

`true` if rows are activated on single click, `false` otherwise
<!-- trait ListBoxExt::fn get_adjustment -->
Gets the adjustment (if any) that the widget uses to
for vertical scrolling.

Feature: `v3_10`


# Returns

the adjustment
<!-- trait ListBoxExt::fn get_row_at_index -->
Gets the n-th child in the list (not counting headers).
If `_index` is negative or larger than the number of items in the
list, `None` is returned.

Feature: `v3_10`

## `index_`
the index of the row

# Returns

the child `Widget` or `None`
<!-- trait ListBoxExt::fn get_row_at_y -->
Gets the row at the `y` position.

Feature: `v3_10`

## `y`
position

# Returns

the row or `None`
 in case no row exists for the given y coordinate.
<!-- trait ListBoxExt::fn get_selected_row -->
Gets the selected row.

Note that the box may allow multiple selection, in which
case you should use `ListBoxExt::selected_foreach` to
find all selected rows.

Feature: `v3_10`


# Returns

the selected row
<!-- trait ListBoxExt::fn get_selected_rows -->
Creates a list of all selected children.

Feature: `v3_14`


# Returns


 A `glib::List` containing the `Widget` for each selected child.
 Free with `glib::List::free` when done.
<!-- trait ListBoxExt::fn get_selection_mode -->
Gets the selection mode of the listbox.

Feature: `v3_10`


# Returns

a `SelectionMode`
<!-- trait ListBoxExt::fn insert -->
Insert the `child` into the `self` at `position`. If a sort function is
set, the widget will actually be inserted at the calculated position and
this function has the same effect of `ContainerExt::add`.

If `position` is -1, or larger than the total number of items in the
`self`, then the `child` will be appended to the end.

Feature: `v3_10`

## `child`
the `Widget` to add
## `position`
the position to insert `child` in
<!-- trait ListBoxExt::fn invalidate_filter -->
Update the filtering for all rows. Call this when result
of the filter function on the `self` is changed due
to an external factor. For instance, this would be used
if the filter function just looked for a specific search
string and the entry with the search string has changed.

Feature: `v3_10`

<!-- trait ListBoxExt::fn invalidate_headers -->
Update the separators for all rows. Call this when result
of the header function on the `self` is changed due
to an external factor.

Feature: `v3_10`

<!-- trait ListBoxExt::fn invalidate_sort -->
Update the sorting for all rows. Call this when result
of the sort function on the `self` is changed due
to an external factor.

Feature: `v3_10`

<!-- trait ListBoxExt::fn prepend -->
Prepend a widget to the list. If a sort function is set, the widget will
actually be inserted at the calculated position and this function has the
same effect of `ContainerExt::add`.

Feature: `v3_10`

## `child`
the `Widget` to add
<!-- trait ListBoxExt::fn select_all -->
Select all children of `self`, if the selection mode allows it.

Feature: `v3_14`

<!-- trait ListBoxExt::fn select_row -->
Make `row` the currently selected row.

Feature: `v3_10`

## `row`
The row to select or `None`
<!-- trait ListBoxExt::fn selected_foreach -->
Calls a function for each selected child.

Note that the selection cannot be modified from within this function.

Feature: `v3_14`

## `func`
the function to call for each selected child
## `data`
user data to pass to the function
<!-- trait ListBoxExt::fn set_activate_on_single_click -->
If `single` is `true`, rows will be activated when you click on them,
otherwise you need to double-click.

Feature: `v3_10`

## `single`
a boolean
<!-- trait ListBoxExt::fn set_adjustment -->
Sets the adjustment (if any) that the widget uses to
for vertical scrolling. For instance, this is used
to get the page size for PageUp/Down key handling.

In the normal case when the `self` is packed inside
a `ScrolledWindow` the adjustment from that will
be picked up automatically, so there is no need
to manually do that.

Feature: `v3_10`

## `adjustment`
the adjustment, or `None`
<!-- trait ListBoxExt::fn set_filter_func -->
By setting a filter function on the `self` one can decide dynamically which
of the rows to show. For instance, to implement a search function on a list that
filters the original list to only show the matching rows.

The `filter_func` will be called for each row after the call, and it will
continue to be called each time a row changes (via `ListBoxRowExt::changed`) or
when `ListBoxExt::invalidate_filter` is called.

Note that using a filter function is incompatible with using a model
(see `ListBoxExt::bind_model`).

Feature: `v3_10`

## `filter_func`
callback that lets you filter which rows to show
## `user_data`
user data passed to `filter_func`
## `destroy`
destroy notifier for `user_data`
<!-- trait ListBoxExt::fn set_header_func -->
By setting a header function on the `self` one can dynamically add headers
in front of rows, depending on the contents of the row and its position in the list.
For instance, one could use it to add headers in front of the first item of a
new kind, in a list sorted by the kind.

The `update_header` can look at the current header widget using `ListBoxRowExt::get_header`
and either update the state of the widget as needed, or set a new one using
`ListBoxRowExt::set_header`. If no header is needed, set the header to `None`.

Note that you may get many calls `update_header` to this for a particular row when e.g.
changing things that don’t affect the header. In this case it is important for performance
to not blindly replace an existing header with an identical one.

The `update_header` function will be called for each row after the call, and it will
continue to be called each time a row changes (via `ListBoxRowExt::changed`) and when
the row before changes (either by `ListBoxRowExt::changed` on the previous row, or when
the previous row becomes a different row). It is also called for all rows when
`ListBoxExt::invalidate_headers` is called.

Feature: `v3_10`

## `update_header`
callback that lets you add row headers
## `user_data`
user data passed to `update_header`
## `destroy`
destroy notifier for `user_data`
<!-- trait ListBoxExt::fn set_placeholder -->
Sets the placeholder widget that is shown in the list when
it doesn't display any visible children.

Feature: `v3_10`

## `placeholder`
a `Widget` or `None`
<!-- trait ListBoxExt::fn set_selection_mode -->
Sets how selection works in the listbox.
See `SelectionMode` for details.

Feature: `v3_10`

## `mode`
The `SelectionMode`
<!-- trait ListBoxExt::fn set_sort_func -->
By setting a sort function on the `self` one can dynamically reorder the rows
of the list, based on the contents of the rows.

The `sort_func` will be called for each row after the call, and will continue to
be called each time a row changes (via `ListBoxRowExt::changed`) and when
`ListBoxExt::invalidate_sort` is called.

Note that using a sort function is incompatible with using a model
(see `ListBoxExt::bind_model`).

Feature: `v3_10`

## `sort_func`
the sort function
## `user_data`
user data passed to `sort_func`
## `destroy`
destroy notifier for `user_data`
<!-- trait ListBoxExt::fn unselect_all -->
Unselect all children of `self`, if the selection mode allows it.

Feature: `v3_14`

<!-- trait ListBoxExt::fn unselect_row -->
Unselects a single row of `self`, if the selection mode allows it.

Feature: `v3_14`

## `row`
the row to unselected
<!-- trait ListBoxExt::fn connect_row_activated -->
The ::row-activated signal is emitted when a row has been activated by the user.

Feature: `v3_10`

## `row`
the activated row
<!-- trait ListBoxExt::fn connect_row_selected -->
The ::row-selected signal is emitted when a new row is selected, or
(with a `None` `row`) when the selection is cleared.

When the `box_` is using `SelectionMode::Multiple`, this signal will not
give you the full picture of selection changes, and you should use
the `ListBox::selected-rows-changed` signal instead.

Feature: `v3_10`

## `row`
the selected row
<!-- trait ListBoxExt::fn connect_select_all -->
The ::select-all signal is a [keybinding signal][`BindingSignal`]
which gets emitted to select all children of the box, if the selection
mode permits it.

The default bindings for this signal is Ctrl-a.

Feature: `v3_14`

<!-- trait ListBoxExt::fn connect_selected_rows_changed -->
The ::selected-rows-changed signal is emitted when the
set of selected rows changes.

Feature: `v3_14`

<!-- trait ListBoxExt::fn connect_unselect_all -->
The ::unselect-all signal is a [keybinding signal][`BindingSignal`]
which gets emitted to unselect all children of the box, if the selection
mode permits it.

The default bindings for this signal is Ctrl-Shift-a.

Feature: `v3_14`

<!-- struct ListBoxRow -->


Feature: `v3_10`

# Implements

[`ListBoxRowExt`](trait.ListBoxRowExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait ListBoxRowExt -->
Trait containing all `ListBoxRow` methods.

Feature: `v3_10`

# Implementors

[`ListBoxRow`](struct.ListBoxRow.html)
<!-- impl ListBoxRow::fn new -->
Creates a new `ListBoxRow`, to be used as a child of a `ListBox`.

Feature: `v3_10`


# Returns

a new `ListBoxRow`
<!-- trait ListBoxRowExt::fn changed -->
Marks `self` as changed, causing any state that depends on this
to be updated. This affects sorting, filtering and headers.

Note that calls to this method must be in sync with the data
used for the row functions. For instance, if the list is
mirroring some external data set, and *two* rows changed in the
external data set then when you call `ListBoxRowExt::changed`
on the first row the sort function must only read the new data
for the first of the two changed rows, otherwise the resorting
of the rows will be wrong.

This generally means that if you don’t fully control the data
model you have to duplicate the data that affects the listbox
row functions into the row widgets themselves. Another alternative
is to call `ListBoxExt::invalidate_sort` on any model change,
but that is more expensive.

Feature: `v3_10`

<!-- trait ListBoxRowExt::fn get_activatable -->
Gets the value of the `ListBoxRow:activatable` property
for this row.

Feature: `v3_14`


# Returns

`true` if the row is activatable
<!-- trait ListBoxRowExt::fn get_header -->
Returns the current header of the `self`. This can be used
in a ``GtkListBoxUpdateHeaderFunc`` to see if there is a header
set already, and if so to update the state of it.

Feature: `v3_10`


# Returns

the current header, or `None` if none
<!-- trait ListBoxRowExt::fn get_index -->
Gets the current index of the `self` in its `ListBox` container.

Feature: `v3_10`


# Returns

the index of the `self`, or -1 if the `self` is not in a listbox
<!-- trait ListBoxRowExt::fn get_selectable -->
Gets the value of the `ListBoxRow:selectable` property
for this row.

Feature: `v3_14`


# Returns

`true` if the row is selectable
<!-- trait ListBoxRowExt::fn is_selected -->
Returns whether the child is currently selected in its
`ListBox` container.

Feature: `v3_14`


# Returns

`true` if `self` is selected
<!-- trait ListBoxRowExt::fn set_activatable -->
Set the `ListBoxRow:activatable` property for this row.

Feature: `v3_14`

## `activatable`
`true` to mark the row as activatable
<!-- trait ListBoxRowExt::fn set_header -->
Sets the current header of the `self`. This is only allowed to be called
from a ``GtkListBoxUpdateHeaderFunc``. It will replace any existing
header in the row, and be shown in front of the row in the listbox.

Feature: `v3_10`

## `header`
the header, or `None`
<!-- trait ListBoxRowExt::fn set_selectable -->
Set the `ListBoxRow:selectable` property for this row.

Feature: `v3_14`

## `selectable`
`true` to mark the row as selectable
<!-- trait ListBoxRowExt::fn get_property_activatable -->
The property determines whether the `ListBox::row-activated`
signal will be emitted for this row.

Feature: `v3_14`

<!-- trait ListBoxRowExt::fn set_property_activatable -->
The property determines whether the `ListBox::row-activated`
signal will be emitted for this row.

Feature: `v3_14`

<!-- trait ListBoxRowExt::fn get_property_selectable -->
The property determines whether this row can be selected.

Feature: `v3_14`

<!-- trait ListBoxRowExt::fn set_property_selectable -->
The property determines whether this row can be selected.

Feature: `v3_14`

<!-- struct ListStore -->
The `ListStore` object is a list model for use with a `TreeView`
widget. It implements the `TreeModel` interface, and consequentialy,
can use all of the methods available there. It also implements the
`TreeSortable` interface so it can be sorted by the view.
Finally, it also implements the tree
[drag and drop][gtk3-`TreeView`-drag-and-drop]
interfaces.

The `ListStore` can accept most GObject types as a column type, though
it can’t accept all custom types. Internally, it will keep a copy of
data passed in (such as a string or a boxed pointer). Columns that
accept `GObjects` are handled a little differently. The
`ListStore` will keep a reference to the object instead of copying the
value. As a result, if the object is modified, it is up to the
application writer to call `TreeModel::row_changed` to emit the
`TreeModel::row_changed` signal. This most commonly affects lists with
``GdkPixbufs`` stored.

An example for creating a simple list store:

```C
enum {
  COLUMN_STRING,
  COLUMN_INT,
  COLUMN_BOOLEAN,
  N_COLUMNS
};

{
  GtkListStore *list_store;
  GtkTreePath *path;
  GtkTreeIter iter;
  gint i;

  list_store = gtk_list_store_new (N_COLUMNS,
                                   G_TYPE_STRING,
                                   G_TYPE_INT,
                                   G_TYPE_BOOLEAN);

  for (i = 0; i < 10; i++)
    {
      gchar *some_data;

      some_data = get_some_data (i);

      // Add a new row to the model
      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
                          COLUMN_STRING, some_data,
                          COLUMN_INT, i,
                          COLUMN_BOOLEAN,  FALSE,
                          -1);

      // As the store will keep a copy of the string internally,
      // we free some_data.
      g_free (some_data);
    }

  // Modify a particular row
  path = gtk_tree_path_new_from_string ("4");
  gtk_tree_model_get_iter (GTK_TREE_MODEL (list_store),
                           &iter,
                           path);
  gtk_tree_path_free (path);
  gtk_list_store_set (list_store, &iter,
                      COLUMN_BOOLEAN, TRUE,
                      -1);
}
```

# Performance Considerations

Internally, the `ListStore` was implemented with a linked list with
a tail pointer prior to GTK+ 2.6. As a result, it was fast at data
insertion and deletion, and not fast at random data access. The
`ListStore` sets the `TreeModelFlags::ItersPersist` flag, which means
that ``GtkTreeIters`` can be cached while the row exists. Thus, if
access to a particular row is needed often and your code is expected to
run on older versions of GTK+, it is worth keeping the iter around.

# Atomic Operations

It is important to note that only the methods
`ListStoreExt::insert_with_values` and `ListStoreExt::insert_with_valuesv`
are atomic, in the sense that the row is being appended to the store and the
values filled in in a single operation with regard to `TreeModel` signaling.
In contrast, using e.g. `ListStoreExt::append` and then `ListStoreExt::set`
will first create a row, which triggers the `TreeModel::row-inserted` signal
on `ListStore`. The row, however, is still empty, and any signal handler
connecting to `TreeModel::row-inserted` on this particular store should be prepared
for the situation that the row might be empty. This is especially important
if you are wrapping the `ListStore` inside a `TreeModelFilter` and are
using a ``GtkTreeModelFilterVisibleFunc``. Using any of the non-atomic operations
to append rows to the `ListStore` will cause the
``GtkTreeModelFilterVisibleFunc`` to be visited with an empty row first; the
function must be prepared for that.

# `ListStore` as `Buildable`

The `ListStore` implementation of the `Buildable` interface allows
to specify the model columns with a `<columns>` element that may contain
multiple `<column>` elements, each specifying one model column. The “type”
attribute specifies the data type for the column.

Additionally, it is possible to specify content for the list store
in the UI definition, with the `<data>` element. It can contain multiple
`<row>` elements, each specifying to content for one row of the list model.
Inside a `<row>`, the `<col>` elements specify the content for individual cells.

Note that it is probably more common to define your models in the code,
and one might consider it a layering violation to specify the content of
a list store in a UI definition, data, not presentation, and common wisdom
is to separate the two, as far as possible.

An example of a UI Definition fragment for a list store:

```C
<object class="GtkListStore">
  <columns>
    <column type="gchararray"/>
    <column type="gchararray"/>
    <column type="gint"/>
  </columns>
  <data>
    <row>
      <col id="0">John</col>
      <col id="1">Doe</col>
      <col id="2">25</col>
    </row>
    <row>
      <col id="0">Johan</col>
      <col id="1">Dahlin</col>
      <col id="2">50</col>
    </row>
  </data>
</object>
```

# Implements

[`ListStoreExt`](trait.ListStoreExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`TreeModelExt`](trait.TreeModelExt.html), [`TreeSortableExt`](trait.TreeSortableExt.html)
<!-- trait ListStoreExt -->
Trait containing all `ListStore` methods.

# Implementors

[`ListStore`](struct.ListStore.html)
<!-- impl ListStore::fn new -->
Creates a new list store as with `n_columns` columns each of the types passed
in. Note that only types derived from standard GObject fundamental types
are supported.

As an example, `gtk_list_store_new (3, G_TYPE_INT, G_TYPE_STRING,
GDK_TYPE_PIXBUF);` will create a new `ListStore` with three columns, of type
int, string and `gdk_pixbuf::Pixbuf` respectively.
## `n_columns`
number of columns in the list store

# Returns

a new `ListStore`
<!-- impl ListStore::fn newv -->
Non-vararg creation function. Used primarily by language bindings.
## `n_columns`
number of columns in the list store
## `types`
an array of `glib::Type` types for the columns, from first to last

# Returns

a new `ListStore`
<!-- trait ListStoreExt::fn append -->
Appends a new row to `self`. `iter` will be changed to point to this new
row. The row will be empty after this function is called. To fill in
values, you need to call `ListStoreExt::set` or `ListStore::set_value`.
## `iter`
An unset `TreeIter` to set to the appended row
<!-- trait ListStoreExt::fn clear -->
Removes all rows from the list store.
<!-- trait ListStoreExt::fn insert -->
Creates a new row at `position`. `iter` will be changed to point to this new
row. If `position` is -1 or is larger than the number of rows on the list,
then the new row will be appended to the list. The row will be empty after
this function is called. To fill in values, you need to call
`ListStoreExt::set` or `ListStore::set_value`.
## `iter`
An unset `TreeIter` to set to the new row
## `position`
position to insert the new row, or -1 for last
<!-- trait ListStoreExt::fn insert_after -->
Inserts a new row after `sibling`. If `sibling` is `None`, then the row will be
prepended to the beginning of the list. `iter` will be changed to point to
this new row. The row will be empty after this function is called. To fill
in values, you need to call `ListStoreExt::set` or `ListStore::set_value`.
## `iter`
An unset `TreeIter` to set to the new row
## `sibling`
A valid `TreeIter`, or `None`
<!-- trait ListStoreExt::fn insert_before -->
Inserts a new row before `sibling`. If `sibling` is `None`, then the row will
be appended to the end of the list. `iter` will be changed to point to this
new row. The row will be empty after this function is called. To fill in
values, you need to call `ListStoreExt::set` or `ListStore::set_value`.
## `iter`
An unset `TreeIter` to set to the new row
## `sibling`
A valid `TreeIter`, or `None`
<!-- trait ListStoreExt::fn insert_with_values -->
Creates a new row at `position`. `iter` will be changed to point to this new
row. If `position` is -1, or larger than the number of rows in the list, then
the new row will be appended to the list. The row will be filled with the
values given to this function.

Calling
`gtk_list_store_insert_with_values (list_store, iter, position...)`
has the same effect as calling

```C
gtk_list_store_insert (list_store, iter, position);
gtk_list_store_set (list_store, iter, ...);
```
with the difference that the former will only emit a row_inserted signal,
while the latter will emit row_inserted, row_changed and, if the list store
is sorted, rows_reordered. Since emitting the rows_reordered signal
repeatedly can affect the performance of the program,
`ListStoreExt::insert_with_values` should generally be preferred when
inserting rows in a sorted list store.
## `iter`
An unset `TreeIter` to set to the new row, or `None`
## `position`
position to insert the new row, or -1 to append after existing
 rows
<!-- trait ListStoreExt::fn insert_with_valuesv -->
A variant of `ListStoreExt::insert_with_values` which
takes the columns and values as two arrays, instead of
varargs. This function is mainly intended for
language-bindings.
## `iter`
An unset `TreeIter` to set to the new row, or `None`.
## `position`
position to insert the new row, or -1 for last
## `columns`
an array of column numbers
## `values`
an array of GValues
## `n_values`
the length of the `columns` and `values` arrays
<!-- trait ListStoreExt::fn iter_is_valid -->
> This function is slow. Only use it for debugging and/or testing
> purposes.

Checks if the given iter is a valid iter for this `ListStore`.
## `iter`
A `TreeIter`.

# Returns

`true` if the iter is valid, `false` if the iter is invalid.
<!-- trait ListStoreExt::fn move_after -->
Moves `iter` in `self` to the position after `position`. Note that this
function only works with unsorted stores. If `position` is `None`, `iter`
will be moved to the start of the list.
## `iter`
A `TreeIter`.
## `position`
A `TreeIter` or `None`.
<!-- trait ListStoreExt::fn move_before -->
Moves `iter` in `self` to the position before `position`. Note that this
function only works with unsorted stores. If `position` is `None`, `iter`
will be moved to the end of the list.
## `iter`
A `TreeIter`.
## `position`
A `TreeIter`, or `None`.
<!-- trait ListStoreExt::fn prepend -->
Prepends a new row to `self`. `iter` will be changed to point to this new
row. The row will be empty after this function is called. To fill in
values, you need to call `ListStoreExt::set` or `ListStore::set_value`.
## `iter`
An unset `TreeIter` to set to the prepend row
<!-- trait ListStoreExt::fn remove -->
Removes the given row from the list store. After being removed,
`iter` is set to be the next valid row, or invalidated if it pointed
to the last row in `self`.
## `iter`
A valid `TreeIter`

# Returns

`true` if `iter` is valid, `false` if not.
<!-- trait ListStoreExt::fn reorder -->
Reorders `self` to follow the order indicated by `new_order`. Note that
this function only works with unsorted stores.
## `new_order`
an array of integers mapping the new
 position of each child to its old position before the re-ordering,
 i.e. `new_order``[newpos] = oldpos`. It must have
 exactly as many items as the list store’s length.
<!-- trait ListStoreExt::fn set -->
Sets the value of one or more cells in the row referenced by `iter`.
The variable argument list should contain integer column numbers,
each column number followed by the value to be set.
The list is terminated by a -1. For example, to set column 0 with type
`G_TYPE_STRING` to “Foo”, you would write `gtk_list_store_set (store, iter,
0, "Foo", -1)`.

The value will be referenced by the store if it is a `G_TYPE_OBJECT`, and it
will be copied if it is a `G_TYPE_STRING` or `G_TYPE_BOXED`.
## `iter`
row iterator
<!-- trait ListStoreExt::fn set_column_types -->
This function is meant primarily for `GObjects` that inherit from `ListStore`,
and should only be used when constructing a new `ListStore`. It will not
function after a row has been added, or a method on the `TreeModel`
interface is called.
## `n_columns`
Number of columns for the list store
## `types`
An array length n of `GTypes`
<!-- trait ListStoreExt::fn set_valist -->
See `ListStoreExt::set`; this version takes a va_list for use by language
bindings.
## `iter`
A valid `TreeIter` for the row being modified
## `var_args`
va_list of column/value pairs
<!-- trait ListStoreExt::fn set_value -->
Sets the data in the cell specified by `iter` and `column`.
The type of `value` must be convertible to the type of the
column.
## `iter`
A valid `TreeIter` for the row being modified
## `column`
column number to modify
## `value`
new value for the cell
<!-- trait ListStoreExt::fn set_valuesv -->
A variant of `ListStoreExt::set_valist` which
takes the columns and values as two arrays, instead of
varargs. This function is mainly intended for
language-bindings and in case the number of columns to
change is not known until run-time.
## `iter`
A valid `TreeIter` for the row being modified
## `columns`
an array of column numbers
## `values`
an array of GValues
## `n_values`
the length of the `columns` and `values` arrays
<!-- trait ListStoreExt::fn swap -->
Swaps `a` and `b` in `self`. Note that this function only works with
unsorted stores.
## `a`
A `TreeIter`.
## `b`
Another `TreeIter`.
<!-- struct Menu -->
A `Menu` is a `MenuShell` that implements a drop down menu
consisting of a list of `MenuItem` objects which can be navigated
and activated by the user to perform application functions.

A `Menu` is most commonly dropped down by activating a
`MenuItem` in a `MenuBar` or popped up by activating a
`MenuItem` in another `Menu`.

A `Menu` can also be popped up by activating a `ComboBox`.
Other composite widgets such as the `Notebook` can pop up a
`Menu` as well.

Applications can display a `Menu` as a popup menu by calling the
`MenuExt::popup` function. The example below shows how an application
can pop up a menu when the 3rd mouse button is pressed.

## Connecting the popup signal handler.


```C
  // connect our handler which will popup the menu
  g_signal_connect_swapped (window, "button_press_event",
G_CALLBACK (my_popup_handler), menu);
```

## Signal handler which displays a popup menu.


```C
static gint
my_popup_handler (GtkWidget *widget, GdkEvent *event)
{
  GtkMenu *menu;
  GdkEventButton *event_button;

  g_return_val_if_fail (widget != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_MENU (widget), FALSE);
  g_return_val_if_fail (event != NULL, FALSE);

  // The "widget" is the menu that was supplied when
  // g_signal_connect_swapped() was called.
  menu = GTK_MENU (widget);

  if (event->type == GDK_BUTTON_PRESS)
    {
      event_button = (GdkEventButton *) event;
      if (event_button->button == GDK_BUTTON_SECONDARY)
        {
          gtk_menu_popup (menu, NULL, NULL, NULL, NULL,
                          event_button->button, event_button->time);
          return TRUE;
        }
    }

  return FALSE;
}
```

# CSS nodes


```plain
menu
├── arrow.top
├── <child>
┊
├── <child>
╰── arrow.bottom
```

The main CSS node of `Menu` has name menu, and there are two subnodes
with name arrow, for scrolling menu arrows. These subnodes get the
.top and .bottom style classes.

# Implements

[`MenuExt`](trait.MenuExt.html), [`MenuShellExt`](trait.MenuShellExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait MenuExt -->
Trait containing all `Menu` methods.

# Implementors

[`Menu`](struct.Menu.html)
<!-- impl Menu::fn new -->
Creates a new `Menu`

# Returns

a new `Menu`
<!-- impl Menu::fn new_from_model -->
Creates a `Menu` and populates it with menu items and
submenus according to `model`.

The created menu items are connected to actions found in the
`ApplicationWindow` to which the menu belongs - typically
by means of being attached to a widget (see `MenuExt::attach_to_widget`)
that is contained within the ``GtkApplicationWindows`` widget hierarchy.

Actions can also be added using `WidgetExt::insert_action_group` on the menu's
attach widget or on any of its parent widgets.
## `model`
a `gio::MenuModel`

# Returns

a new `Menu`
<!-- impl Menu::fn get_for_attach_widget -->
Returns a list of the menus which are attached to this widget.
This list is owned by GTK+ and must not be modified.
## `widget`
a `Widget`

# Returns

the list
 of menus attached to his widget.
<!-- trait MenuExt::fn attach -->
Adds a new `MenuItem` to a (table) menu. The number of “cells” that
an item will occupy is specified by `left_attach`, `right_attach`,
`top_attach` and `bottom_attach`. These each represent the leftmost,
rightmost, uppermost and lower column and row numbers of the table.
(Columns and rows are indexed from zero).

Note that this function is not related to `MenuExt::detach`.
## `child`
a `MenuItem`
## `left_attach`
The column number to attach the left side of the item to
## `right_attach`
The column number to attach the right side of the item to
## `top_attach`
The row number to attach the top of the item to
## `bottom_attach`
The row number to attach the bottom of the item to
<!-- trait MenuExt::fn attach_to_widget -->
Attaches the menu to the widget and provides a callback function
that will be invoked when the menu calls `MenuExt::detach` during
its destruction.

If the menu is attached to the widget then it will be destroyed
when the widget is destroyed, as if it was a child widget.
An attached menu will also move between screens correctly if the
widgets moves between screens.
## `attach_widget`
the `Widget` that the menu will be attached to
## `detacher`
the user supplied callback function
 that will be called when the menu calls `MenuExt::detach`
<!-- trait MenuExt::fn detach -->
Detaches the menu from the widget to which it had been attached.
This function will call the callback function, `detacher`, provided
when the `MenuExt::attach_to_widget` function was called.
<!-- trait MenuExt::fn get_accel_group -->
Gets the `AccelGroup` which holds global accelerators for the
menu. See `MenuExt::set_accel_group`.

# Returns

the `AccelGroup` associated with the menu
<!-- trait MenuExt::fn get_accel_path -->
Retrieves the accelerator path set on the menu.

# Returns

the accelerator path set on the menu.
<!-- trait MenuExt::fn get_active -->
Returns the selected menu item from the menu. This is used by the
`ComboBox`.

# Returns

the `MenuItem` that was last selected
 in the menu. If a selection has not yet been made, the
 first menu item is selected.
<!-- trait MenuExt::fn get_attach_widget -->
Returns the `Widget` that the menu is attached to.

# Returns

the `Widget` that the menu is attached to
<!-- trait MenuExt::fn get_monitor -->
Retrieves the number of the monitor on which to show the menu.

# Returns

the number of the monitor on which the menu should
 be popped up or -1, if no monitor has been set
<!-- trait MenuExt::fn get_reserve_toggle_size -->
Returns whether the menu reserves space for toggles and
icons, regardless of their actual presence.

# Returns

Whether the menu reserves toggle space
<!-- trait MenuExt::fn get_tearoff_state -->
Returns whether the menu is torn off.
See `MenuExt::set_tearoff_state`.

# Deprecated since 3.10


# Returns

`true` if the menu is currently torn off.
<!-- trait MenuExt::fn get_title -->
Returns the title of the menu. See `MenuExt::set_title`.

# Deprecated since 3.10


# Returns

the title of the menu, or `None` if the menu
 has no title set on it. This string is owned by GTK+
 and should not be modified or freed.
<!-- trait MenuExt::fn place_on_monitor -->
Places `self` on the given monitor.

Feature: `v3_22`

## `monitor`
the monitor to place the menu on
<!-- trait MenuExt::fn popdown -->
Removes the menu from the screen.
<!-- trait MenuExt::fn popup -->
Displays a menu and makes it available for selection.

Applications can use this function to display context-sensitive
menus, and will typically supply `None` for the `parent_menu_shell`,
`parent_menu_item`, `func` and `data` parameters. The default menu
positioning function will position the menu at the current mouse
cursor position.

The `button` parameter should be the mouse button pressed to initiate
the menu popup. If the menu popup was initiated by something other
than a mouse button press, such as a mouse button release or a keypress,
`button` should be 0.

The `activate_time` parameter is used to conflict-resolve initiation
of concurrent requests for mouse/keyboard grab requests. To function
properly, this needs to be the timestamp of the user event (such as
a mouse click or key press) that caused the initiation of the popup.
Only if no such event is available, `gtk_get_current_event_time` can
be used instead.

Note that this function does not work very well on GDK backends that
do not have global coordinates, such as Wayland or Mir. You should
probably use one of the gtk_menu_popup_at_ variants, which do not
have this problem.

# Deprecated since 3.22

Please use `MenuExt::popup_at_widget`,
 `MenuExt::popup_at_pointer`. or `MenuExt::popup_at_rect` instead
## `parent_menu_shell`
the menu shell containing the
 triggering menu item, or `None`
## `parent_menu_item`
the menu item whose activation
 triggered the popup, or `None`
## `func`
a user supplied function used to position
 the menu, or `None`
## `data`
user supplied data to be passed to `func`.
## `button`
the mouse button which was pressed to initiate the event.
## `activate_time`
the time at which the activation event occurred.
<!-- trait MenuExt::fn popup_at_pointer -->
Displays `self` and makes it available for selection.

See gtk_menu_popup_at_widget () to pop up a menu at a widget.
gtk_menu_popup_at_rect () also allows you to position a menu at an arbitrary
rectangle.

`self` will be positioned at the pointer associated with `trigger_event`.

Properties that influence the behaviour of this function are
`Menu:anchor-hints`, `Menu:rect-anchor-dx`, `Menu:rect-anchor-dy`, and
`Menu:menu-type-hint`. Connect to the `Menu::popped-up` signal to find
out how it was actually positioned.

Feature: `v3_22`

## `trigger_event`
the ``GdkEvent`` that initiated this request or
 `None` if it's the current event
<!-- trait MenuExt::fn popup_at_rect -->
Displays `self` and makes it available for selection.

See gtk_menu_popup_at_widget () and gtk_menu_popup_at_pointer (), which
handle more common cases for popping up menus.

`self` will be positioned at `rect`, aligning their anchor points. `rect` is
relative to the top-left corner of `rect_window`. `rect_anchor` and
`menu_anchor` determine anchor points on `rect` and `self` to pin together.
`self` can optionally be offset by `Menu:rect-anchor-dx` and
`Menu:rect-anchor-dy`.

Anchors should be specified under the assumption that the text direction is
left-to-right; they will be flipped horizontally automatically if the text
direction is right-to-left.

Other properties that influence the behaviour of this function are
`Menu:anchor-hints` and `Menu:menu-type-hint`. Connect to the
`Menu::popped-up` signal to find out how it was actually positioned.

Feature: `v3_22`

## `rect_window`
the `gdk::Window` `rect` is relative to
## `rect`
the `gdk::Rectangle` to align `self` with
## `rect_anchor`
the point on `rect` to align with `self`'s anchor point
## `menu_anchor`
the point on `self` to align with `rect`'s anchor point
## `trigger_event`
the ``GdkEvent`` that initiated this request or
 `None` if it's the current event
<!-- trait MenuExt::fn popup_at_widget -->
Displays `self` and makes it available for selection.

See gtk_menu_popup_at_pointer () to pop up a menu at the master pointer.
gtk_menu_popup_at_rect () also allows you to position a menu at an arbitrary
rectangle.

![](popup-anchors.png)

`self` will be positioned at `widget`, aligning their anchor points.
`widget_anchor` and `menu_anchor` determine anchor points on `widget` and `self`
to pin together. `self` can optionally be offset by `Menu:rect-anchor-dx`
and `Menu:rect-anchor-dy`.

Anchors should be specified under the assumption that the text direction is
left-to-right; they will be flipped horizontally automatically if the text
direction is right-to-left.

Other properties that influence the behaviour of this function are
`Menu:anchor-hints` and `Menu:menu-type-hint`. Connect to the
`Menu::popped-up` signal to find out how it was actually positioned.

Feature: `v3_22`

## `widget`
the `Widget` to align `self` with
## `widget_anchor`
the point on `widget` to align with `self`'s anchor point
## `menu_anchor`
the point on `self` to align with `widget`'s anchor point
## `trigger_event`
the ``GdkEvent`` that initiated this request or
 `None` if it's the current event
<!-- trait MenuExt::fn popup_for_device -->
Displays a menu and makes it available for selection.

Applications can use this function to display context-sensitive menus,
and will typically supply `None` for the `parent_menu_shell`,
`parent_menu_item`, `func`, `data` and `destroy` parameters. The default
menu positioning function will position the menu at the current position
of `device` (or its corresponding pointer).

The `button` parameter should be the mouse button pressed to initiate
the menu popup. If the menu popup was initiated by something other than
a mouse button press, such as a mouse button release or a keypress,
`button` should be 0.

The `activate_time` parameter is used to conflict-resolve initiation of
concurrent requests for mouse/keyboard grab requests. To function
properly, this needs to be the time stamp of the user event (such as
a mouse click or key press) that caused the initiation of the popup.
Only if no such event is available, `gtk_get_current_event_time` can
be used instead.

Note that this function does not work very well on GDK backends that
do not have global coordinates, such as Wayland or Mir. You should
probably use one of the gtk_menu_popup_at_ variants, which do not
have this problem.

# Deprecated since 3.22

Please use `MenuExt::popup_at_widget`,
 `MenuExt::popup_at_pointer`. or `MenuExt::popup_at_rect` instead
## `device`
a `gdk::Device`
## `parent_menu_shell`
the menu shell containing the triggering
 menu item, or `None`
## `parent_menu_item`
the menu item whose activation triggered
 the popup, or `None`
## `func`
a user supplied function used to position the menu,
 or `None`
## `data`
user supplied data to be passed to `func`
## `destroy`
destroy notify for `data`
## `button`
the mouse button which was pressed to initiate the event
## `activate_time`
the time at which the activation event occurred
<!-- trait MenuExt::fn reorder_child -->
Moves `child` to a new `position` in the list of `self`
children.
## `child`
the `MenuItem` to move
## `position`
the new position to place `child`.
 Positions are numbered from 0 to n - 1
<!-- trait MenuExt::fn reposition -->
Repositions the menu according to its position function.
<!-- trait MenuExt::fn set_accel_group -->
Set the `AccelGroup` which holds global accelerators for the
menu. This accelerator group needs to also be added to all windows
that this menu is being used in with `GtkWindowExt::add_accel_group`,
in order for those windows to support all the accelerators
contained in this group.
## `accel_group`
the `AccelGroup` to be associated
 with the menu.
<!-- trait MenuExt::fn set_accel_path -->
Sets an accelerator path for this menu from which accelerator paths
for its immediate children, its menu items, can be constructed.
The main purpose of this function is to spare the programmer the
inconvenience of having to call `MenuItemExt::set_accel_path` on
each menu item that should support runtime user changable accelerators.
Instead, by just calling `MenuExt::set_accel_path` on their parent,
each menu item of this menu, that contains a label describing its
purpose, automatically gets an accel path assigned.

For example, a menu containing menu items “New” and “Exit”, will, after
`gtk_menu_set_accel_path (menu, "<Gnumeric-Sheet>/File");` has been
called, assign its items the accel paths: `"<Gnumeric-Sheet>/File/New"`
and `"<Gnumeric-Sheet>/File/Exit"`.

Assigning accel paths to menu items then enables the user to change
their accelerators at runtime. More details about accelerator paths
and their default setups can be found at `AccelMap::add_entry`.

Note that `accel_path` string will be stored in a `glib::Quark`. Therefore,
if you pass a static string, you can save some memory by interning
it first with `g_intern_static_string`.
## `accel_path`
a valid accelerator path
<!-- trait MenuExt::fn set_active -->
Selects the specified menu item within the menu. This is used by
the `ComboBox` and should not be used by anyone else.
## `index`
the index of the menu item to select. Index values are
 from 0 to n-1
<!-- trait MenuExt::fn set_monitor -->
Informs GTK+ on which monitor a menu should be popped up.
See `gdk::MonitorExt::get_geometry`.

This function should be called from a ``GtkMenuPositionFunc``
if the menu should not appear on the same monitor as the pointer.
This information can’t be reliably inferred from the coordinates
returned by a ``GtkMenuPositionFunc``, since, for very long menus,
these coordinates may extend beyond the monitor boundaries or even
the screen boundaries.
## `monitor_num`
the number of the monitor on which the menu should
 be popped up
<!-- trait MenuExt::fn set_reserve_toggle_size -->
Sets whether the menu should reserve space for drawing toggles
or icons, regardless of their actual presence.
## `reserve_toggle_size`
whether to reserve size for toggles
<!-- trait MenuExt::fn set_screen -->
Sets the `gdk::Screen` on which the menu will be displayed.
## `screen`
a `gdk::Screen`, or `None` if the screen should be
 determined by the widget the menu is attached to
<!-- trait MenuExt::fn set_tearoff_state -->
Changes the tearoff state of the menu. A menu is normally
displayed as drop down menu which persists as long as the menu is
active. It can also be displayed as a tearoff menu which persists
until it is closed or reattached.

# Deprecated since 3.10

## `torn_off`
If `true`, menu is displayed as a tearoff menu.
<!-- trait MenuExt::fn set_title -->
Sets the title string for the menu.

The title is displayed when the menu is shown as a tearoff
menu. If `title` is `None`, the menu will see if it is attached
to a parent menu item, and if so it will try to use the same
text as that menu item’s label.

# Deprecated since 3.10

## `title`
a string containing the title for the menu
<!-- trait MenuExt::fn connect_move_scroll -->
## `scroll_type`
a `ScrollType`
<!-- trait MenuExt::fn connect_popped_up -->
Emitted when the position of `menu` is finalized after being popped up
using gtk_menu_popup_at_rect (), gtk_menu_popup_at_widget (), or
gtk_menu_popup_at_pointer ().

`menu` might be flipped over the anchor rectangle in order to keep it
on-screen, in which case `flipped_x` and `flipped_y` will be set to `true`
accordingly.

`flipped_rect` is the ideal position of `menu` after any possible flipping,
but before any possible sliding. `final_rect` is `flipped_rect`, but possibly
translated in the case that flipping is still ineffective in keeping `menu`
on-screen.

![](popup-slide.png)

The blue menu is `menu`'s ideal position, the green menu is `flipped_rect`,
and the red menu is `final_rect`.

See gtk_menu_popup_at_rect (), gtk_menu_popup_at_widget (),
gtk_menu_popup_at_pointer (), `Menu:anchor-hints`,
`Menu:rect-anchor-dx`, `Menu:rect-anchor-dy`, and
`Menu:menu-type-hint`.

Feature: `v3_22`

## `flipped_rect`
the position of `menu` after any possible
 flipping or `None` if the backend can't obtain it
## `final_rect`
the final position of `menu` or `None` if the
 backend can't obtain it
## `flipped_x`
`true` if the anchors were flipped horizontally
## `flipped_y`
`true` if the anchors were flipped vertically
<!-- trait MenuExt::fn get_property_accel-group -->
The accel group holding accelerators for the menu.
<!-- trait MenuExt::fn set_property_accel-group -->
The accel group holding accelerators for the menu.
<!-- trait MenuExt::fn get_property_accel-path -->
An accel path used to conveniently construct accel paths of child items.
<!-- trait MenuExt::fn set_property_accel-path -->
An accel path used to conveniently construct accel paths of child items.
<!-- trait MenuExt::fn get_property_active -->
The index of the currently selected menu item, or -1 if no
menu item is selected.
<!-- trait MenuExt::fn set_property_active -->
The index of the currently selected menu item, or -1 if no
menu item is selected.
<!-- trait MenuExt::fn get_property_anchor-hints -->
Positioning hints for aligning the menu relative to a rectangle.

These hints determine how the menu should be positioned in the case that
the menu would fall off-screen if placed in its ideal position.

![](popup-flip.png)

For example, `gdk::AnchorHints::FlipY` will replace `gdk::Gravity::NorthWest` with
`gdk::Gravity::SouthWest` and vice versa if the menu extends beyond the
bottom edge of the monitor.

See gtk_menu_popup_at_rect (), gtk_menu_popup_at_widget (),
gtk_menu_popup_at_pointer (), `Menu:rect-anchor-dx`,
`Menu:rect-anchor-dy`, `Menu:menu-type-hint`, and `Menu::popped-up`.

Feature: `v3_22`

<!-- trait MenuExt::fn set_property_anchor-hints -->
Positioning hints for aligning the menu relative to a rectangle.

These hints determine how the menu should be positioned in the case that
the menu would fall off-screen if placed in its ideal position.

![](popup-flip.png)

For example, `gdk::AnchorHints::FlipY` will replace `gdk::Gravity::NorthWest` with
`gdk::Gravity::SouthWest` and vice versa if the menu extends beyond the
bottom edge of the monitor.

See gtk_menu_popup_at_rect (), gtk_menu_popup_at_widget (),
gtk_menu_popup_at_pointer (), `Menu:rect-anchor-dx`,
`Menu:rect-anchor-dy`, `Menu:menu-type-hint`, and `Menu::popped-up`.

Feature: `v3_22`

<!-- trait MenuExt::fn get_property_attach-widget -->
The widget the menu is attached to. Setting this property attaches
the menu without a ``GtkMenuDetachFunc``. If you need to use a detacher,
use `MenuExt::attach_to_widget` directly.
<!-- trait MenuExt::fn set_property_attach-widget -->
The widget the menu is attached to. Setting this property attaches
the menu without a ``GtkMenuDetachFunc``. If you need to use a detacher,
use `MenuExt::attach_to_widget` directly.
<!-- trait MenuExt::fn get_property_menu-type-hint -->
The `gdk::WindowTypeHint` to use for the menu's `gdk::Window`.

See gtk_menu_popup_at_rect (), gtk_menu_popup_at_widget (),
gtk_menu_popup_at_pointer (), `Menu:anchor-hints`,
`Menu:rect-anchor-dx`, `Menu:rect-anchor-dy`, and `Menu::popped-up`.

Feature: `v3_22`

<!-- trait MenuExt::fn set_property_menu-type-hint -->
The `gdk::WindowTypeHint` to use for the menu's `gdk::Window`.

See gtk_menu_popup_at_rect (), gtk_menu_popup_at_widget (),
gtk_menu_popup_at_pointer (), `Menu:anchor-hints`,
`Menu:rect-anchor-dx`, `Menu:rect-anchor-dy`, and `Menu::popped-up`.

Feature: `v3_22`

<!-- trait MenuExt::fn get_property_monitor -->
The monitor the menu will be popped up on.
<!-- trait MenuExt::fn set_property_monitor -->
The monitor the menu will be popped up on.
<!-- trait MenuExt::fn get_property_rect-anchor-dx -->
Horizontal offset to apply to the menu, i.e. the rectangle or widget
anchor.

See gtk_menu_popup_at_rect (), gtk_menu_popup_at_widget (),
gtk_menu_popup_at_pointer (), `Menu:anchor-hints`,
`Menu:rect-anchor-dy`, `Menu:menu-type-hint`, and `Menu::popped-up`.

Feature: `v3_22`

<!-- trait MenuExt::fn set_property_rect-anchor-dx -->
Horizontal offset to apply to the menu, i.e. the rectangle or widget
anchor.

See gtk_menu_popup_at_rect (), gtk_menu_popup_at_widget (),
gtk_menu_popup_at_pointer (), `Menu:anchor-hints`,
`Menu:rect-anchor-dy`, `Menu:menu-type-hint`, and `Menu::popped-up`.

Feature: `v3_22`

<!-- trait MenuExt::fn get_property_rect-anchor-dy -->
Vertical offset to apply to the menu, i.e. the rectangle or widget anchor.

See gtk_menu_popup_at_rect (), gtk_menu_popup_at_widget (),
gtk_menu_popup_at_pointer (), `Menu:anchor-hints`,
`Menu:rect-anchor-dx`, `Menu:menu-type-hint`, and `Menu::popped-up`.

Feature: `v3_22`

<!-- trait MenuExt::fn set_property_rect-anchor-dy -->
Vertical offset to apply to the menu, i.e. the rectangle or widget anchor.

See gtk_menu_popup_at_rect (), gtk_menu_popup_at_widget (),
gtk_menu_popup_at_pointer (), `Menu:anchor-hints`,
`Menu:rect-anchor-dx`, `Menu:menu-type-hint`, and `Menu::popped-up`.

Feature: `v3_22`

<!-- trait MenuExt::fn get_property_reserve-toggle-size -->
A boolean that indicates whether the menu reserves space for
toggles and icons, regardless of their actual presence.

This property should only be changed from its default value
for special-purposes such as tabular menus. Regular menus that
are connected to a menu bar or context menus should reserve
toggle space for consistency.
<!-- trait MenuExt::fn set_property_reserve-toggle-size -->
A boolean that indicates whether the menu reserves space for
toggles and icons, regardless of their actual presence.

This property should only be changed from its default value
for special-purposes such as tabular menus. Regular menus that
are connected to a menu bar or context menus should reserve
toggle space for consistency.
<!-- trait MenuExt::fn get_property_tearoff-state -->
A boolean that indicates whether the menu is torn-off.

# Deprecated since 3.10

<!-- trait MenuExt::fn set_property_tearoff-state -->
A boolean that indicates whether the menu is torn-off.

# Deprecated since 3.10

<!-- trait MenuExt::fn get_property_tearoff-title -->
A title that may be displayed by the window manager when this
menu is torn-off.

# Deprecated since 3.10

<!-- trait MenuExt::fn set_property_tearoff-title -->
A title that may be displayed by the window manager when this
menu is torn-off.

# Deprecated since 3.10

<!-- struct MenuBar -->
The `MenuBar` is a subclass of `MenuShell` which contains one or
more ``GtkMenuItems``. The result is a standard menu bar which can hold
many menu items.

# CSS nodes

`MenuBar` has a single CSS node with name menubar.

# Implements

[`MenuBarExt`](trait.MenuBarExt.html), [`MenuShellExt`](trait.MenuShellExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait MenuBarExt -->
Trait containing all `MenuBar` methods.

# Implementors

[`MenuBar`](struct.MenuBar.html)
<!-- impl MenuBar::fn new -->
Creates a new `MenuBar`

# Returns

the new menu bar, as a `Widget`
<!-- impl MenuBar::fn new_from_model -->
Creates a new `MenuBar` and populates it with menu items
and submenus according to `model`.

The created menu items are connected to actions found in the
`ApplicationWindow` to which the menu bar belongs - typically
by means of being contained within the ``GtkApplicationWindows``
widget hierarchy.
## `model`
a `gio::MenuModel`

# Returns

a new `MenuBar`
<!-- trait MenuBarExt::fn get_child_pack_direction -->
Retrieves the current child pack direction of the menubar.
See `MenuBarExt::set_child_pack_direction`.

# Returns

the child pack direction
<!-- trait MenuBarExt::fn get_pack_direction -->
Retrieves the current pack direction of the menubar.
See `MenuBarExt::set_pack_direction`.

# Returns

the pack direction
<!-- trait MenuBarExt::fn set_child_pack_direction -->
Sets how widgets should be packed inside the children of a menubar.
## `child_pack_dir`
a new `PackDirection`
<!-- trait MenuBarExt::fn set_pack_direction -->
Sets how items should be packed inside a menubar.
## `pack_dir`
a new `PackDirection`
<!-- trait MenuBarExt::fn get_property_child-pack-direction -->
The child pack direction of the menubar. It determines how
the widgets contained in child menuitems are arranged.
<!-- trait MenuBarExt::fn set_property_child-pack-direction -->
The child pack direction of the menubar. It determines how
the widgets contained in child menuitems are arranged.
<!-- trait MenuBarExt::fn get_property_pack-direction -->
The pack direction of the menubar. It determines how
menuitems are arranged in the menubar.
<!-- trait MenuBarExt::fn set_property_pack-direction -->
The pack direction of the menubar. It determines how
menuitems are arranged in the menubar.
<!-- struct MenuButton -->
The `MenuButton` widget is used to display a popup when clicked on.
This popup can be provided either as a `Menu`, a `Popover` or an
abstract `gio::MenuModel`.

The `MenuButton` widget can hold any valid child widget. That is, it
can hold almost any other standard `Widget`. The most commonly used
child is `Image`. If no widget is explicitely added to the `MenuButton`,
a `Image` is automatically created, using an arrow image oriented
according to `MenuButton:direction` or the generic "view-context-menu"
icon if the direction is not set.

The positioning of the popup is determined by the `MenuButton:direction`
property of the menu button.

For menus, the `Widget:halign` and `Widget:valign` properties of the
menu are also taken into account. For example, when the direction is
`ArrowType::Down` and the horizontal alignment is `Align::Start`, the
menu will be positioned below the button, with the starting edge
(depending on the text direction) of the menu aligned with the starting
edge of the button. If there is not enough space below the button, the
menu is popped up above the button instead. If the alignment would move
part of the menu offscreen, it is “pushed in”.

## Direction = Down

- halign = start

 ![](down-start.png)

- halign = center

 ![](down-center.png)

- halign = end

 ![](down-end.png)

## Direction = Up

- halign = start

 ![](up-start.png)

- halign = center

 ![](up-center.png)

- halign = end

 ![](up-end.png)

## Direction = Left

- valign = start

 ![](left-start.png)

- valign = center

 ![](left-center.png)

- valign = end

 ![](left-end.png)

## Direction = Right

- valign = start

 ![](right-start.png)

- valign = center

 ![](right-center.png)

- valign = end

 ![](right-end.png)

# CSS nodes

`MenuButton` has a single CSS node with name button. To differentiate
it from a plain `Button`, it gets the .popup style class.

Feature: `v3_6`

# Implements

[`MenuButtonExt`](trait.MenuButtonExt.html), [`ToggleButtonExt`](trait.ToggleButtonExt.html), [`ButtonExt`](trait.ButtonExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`ActionableExt`](trait.ActionableExt.html)
<!-- trait MenuButtonExt -->
Trait containing all `MenuButton` methods.

Feature: `v3_6`

# Implementors

[`MenuButton`](struct.MenuButton.html)
<!-- impl MenuButton::fn new -->
Creates a new `MenuButton` widget with downwards-pointing
arrow as the only child. You can replace the child widget
with another `Widget` should you wish to.

Feature: `v3_6`


# Returns

The newly created `MenuButton` widget
<!-- trait MenuButtonExt::fn get_align_widget -->
Returns the parent `Widget` to use to line up with menu.

Feature: `v3_6`


# Returns

a `Widget` value or `None`
<!-- trait MenuButtonExt::fn get_direction -->
Returns the direction the popup will be pointing at when popped up.

Feature: `v3_6`


# Returns

a `ArrowType` value
<!-- trait MenuButtonExt::fn get_menu_model -->
Returns the `gio::MenuModel` used to generate the popup.

Feature: `v3_6`


# Returns

a `gio::MenuModel` or `None`
<!-- trait MenuButtonExt::fn get_popover -->
Returns the `Popover` that pops out of the button.
If the button is not using a `Popover`, this function
returns `None`.

Feature: `v3_12`


# Returns

a `Popover` or `None`
<!-- trait MenuButtonExt::fn get_popup -->
Returns the `Menu` that pops out of the button.
If the button does not use a `Menu`, this function
returns `None`.

Feature: `v3_6`


# Returns

a `Menu` or `None`
<!-- trait MenuButtonExt::fn get_use_popover -->
Returns whether a `Popover` or a `Menu` will be constructed
from the menu model.

Feature: `v3_12`


# Returns

`true` if using a `Popover`
<!-- trait MenuButtonExt::fn set_align_widget -->
Sets the `Widget` to use to line the menu with when popped up.
Note that the `align_widget` must contain the `MenuButton` itself.

Setting it to `None` means that the menu will be aligned with the
button itself.

Note that this property is only used with menus currently,
and not for popovers.

Feature: `v3_6`

## `align_widget`
a `Widget`
<!-- trait MenuButtonExt::fn set_direction -->
Sets the direction in which the popup will be popped up, as
well as changing the arrow’s direction. The child will not
be changed to an arrow if it was customized.

If the does not fit in the available space in the given direction,
GTK+ will its best to keep it inside the screen and fully visible.

If you pass `ArrowType::None` for a `direction`, the popup will behave
as if you passed `ArrowType::Down` (although you won’t see any arrows).

Feature: `v3_6`

## `direction`
a `ArrowType`
<!-- trait MenuButtonExt::fn set_menu_model -->
Sets the `gio::MenuModel` from which the popup will be constructed,
or `None` to disable the button.

Depending on the value of `MenuButton:use-popover`, either a
`Menu` will be created with `Menu::new_from_model`, or a
`Popover` with `Popover::new_from_model`. In either case,
actions will be connected as documented for these functions.

If `MenuButton:popup` or `MenuButton:popover` are already set,
their content will be lost and replaced by the newly created popup.

Feature: `v3_6`

## `menu_model`
a `gio::MenuModel`
<!-- trait MenuButtonExt::fn set_popover -->
Sets the `Popover` that will be popped up when the button is
clicked, or `None` to disable the button. If `MenuButton:menu-model`
or `MenuButton:popup` are set, they will be set to `None`.

Feature: `v3_12`

## `popover`
a `Popover`
<!-- trait MenuButtonExt::fn set_popup -->
Sets the `Menu` that will be popped up when the button is clicked,
or `None` to disable the button. If `MenuButton:menu-model` or
`MenuButton:popover` are set, they will be set to `None`.

Feature: `v3_6`

## `menu`
a `Menu`
<!-- trait MenuButtonExt::fn set_use_popover -->
Sets whether to construct a `Popover` instead of `Menu`
when `MenuButtonExt::set_menu_model` is called. Note that
this property is only consulted when a new menu model is set.

Feature: `v3_12`

## `use_popover`
`true` to construct a popover from the menu model
<!-- trait MenuButtonExt::fn get_property_align-widget -->
The `Widget` to use to align the menu with.

Feature: `v3_6`

<!-- trait MenuButtonExt::fn set_property_align-widget -->
The `Widget` to use to align the menu with.

Feature: `v3_6`

<!-- trait MenuButtonExt::fn get_property_direction -->
The `ArrowType` representing the direction in which the
menu or popover will be popped out.

Feature: `v3_6`

<!-- trait MenuButtonExt::fn set_property_direction -->
The `ArrowType` representing the direction in which the
menu or popover will be popped out.

Feature: `v3_6`

<!-- trait MenuButtonExt::fn get_property_menu-model -->
The `gio::MenuModel` from which the popup will be created.
Depending on the `MenuButton:use-popover` property, that may
be a menu or a popover.

See `MenuButtonExt::set_menu_model` for the interaction with the
`MenuButton:popup` property.

Feature: `v3_6`

<!-- trait MenuButtonExt::fn set_property_menu-model -->
The `gio::MenuModel` from which the popup will be created.
Depending on the `MenuButton:use-popover` property, that may
be a menu or a popover.

See `MenuButtonExt::set_menu_model` for the interaction with the
`MenuButton:popup` property.

Feature: `v3_6`

<!-- trait MenuButtonExt::fn get_property_popover -->
The `Popover` that will be popped up when the button is clicked.

Feature: `v3_12`

<!-- trait MenuButtonExt::fn set_property_popover -->
The `Popover` that will be popped up when the button is clicked.

Feature: `v3_12`

<!-- trait MenuButtonExt::fn get_property_popup -->
The `Menu` that will be popped up when the button is clicked.

Feature: `v3_6`

<!-- trait MenuButtonExt::fn set_property_popup -->
The `Menu` that will be popped up when the button is clicked.

Feature: `v3_6`

<!-- trait MenuButtonExt::fn get_property_use-popover -->
Whether to construct a `Popover` from the menu model,
or a `Menu`.

Feature: `v3_12`

<!-- trait MenuButtonExt::fn set_property_use-popover -->
Whether to construct a `Popover` from the menu model,
or a `Menu`.

Feature: `v3_12`

<!-- enum MenuDirectionType -->
An enumeration representing directional movements within a menu.
<!-- enum MenuDirectionType::variant Parent -->
To the parent menu shell
<!-- enum MenuDirectionType::variant Child -->
To the submenu, if any, associated with the item
<!-- enum MenuDirectionType::variant Next -->
To the next menu item
<!-- enum MenuDirectionType::variant Prev -->
To the previous menu item
<!-- struct MenuItem -->
The `MenuItem` widget and the derived widgets are the only valid
children for menus. Their function is to correctly handle highlighting,
alignment, events and submenus.

As a `MenuItem` derives from `Bin` it can hold any valid child widget,
although only a few are really useful.

By default, a `MenuItem` sets a `AccelLabel` as its child.
`MenuItem` has direct functions to set the label and its mnemonic.
For more advanced label settings, you can fetch the child widget from the `Bin`.

An example for setting markup and accelerator on a MenuItem:

```C
GtkWidget *child = gtk_bin_get_child (GTK_BIN (menu_item));
gtk_label_set_markup (GTK_LABEL (child), "<i>new label</i> with <b>markup</b>");
gtk_accel_label_set_accel (GTK_ACCEL_LABEL (child), GDK_KEY_1, 0);
```

# `MenuItem` as `Buildable`

The `MenuItem` implementation of the `Buildable` interface supports
adding a submenu by specifying “submenu” as the “type” attribute of
a `<child>` element.

An example of UI definition fragment with submenus:

```plain
menuitem
├── <child>
╰── [arrow.right]
```

`MenuItem` has a single CSS node with name menuitem. If the menuitem
has a submenu, it gets another CSS node with name arrow, which has
the .left or .right style class.

# Implements

[`MenuItemExt`](trait.MenuItemExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`ActionableExt`](trait.ActionableExt.html)
<!-- trait MenuItemExt -->
Trait containing all `MenuItem` methods.

# Implementors

[`CheckMenuItem`](struct.CheckMenuItem.html), [`ImageMenuItem`](struct.ImageMenuItem.html), [`MenuItem`](struct.MenuItem.html), [`SeparatorMenuItem`](struct.SeparatorMenuItem.html)
<!-- impl MenuItem::fn new -->
Creates a new `MenuItem`.

# Returns

the newly created `MenuItem`
<!-- impl MenuItem::fn new_with_label -->
Creates a new `MenuItem` whose child is a `Label`.
## `label`
the text for the label

# Returns

the newly created `MenuItem`
<!-- impl MenuItem::fn new_with_mnemonic -->
Creates a new `MenuItem` containing a label.

The label will be created using `Label::new_with_mnemonic`,
so underscores in `label` indicate the mnemonic for the menu item.
## `label`
The text of the button, with an underscore in front of the
 mnemonic character

# Returns

a new `MenuItem`
<!-- trait MenuItemExt::fn activate -->
Emits the `MenuItem::activate` signal on the given item
<!-- trait MenuItemExt::fn deselect -->
Emits the `MenuItem::deselect` signal on the given item.
<!-- trait MenuItemExt::fn get_accel_path -->
Retrieve the accelerator path that was previously set on `self`.

See `MenuItemExt::set_accel_path` for details.

# Returns

the accelerator path corresponding to
 this menu item’s functionality, or `None` if not set
<!-- trait MenuItemExt::fn get_label -->
Sets `text` on the `self` label

# Returns

The text in the `self` label. This is the internal
 string used by the label, and must not be modified.
<!-- trait MenuItemExt::fn get_reserve_indicator -->
Returns whether the `self` reserves space for
the submenu indicator, regardless if it has a submenu
or not.

# Returns

`true` if `self` always reserves space for the
 submenu indicator
<!-- trait MenuItemExt::fn get_right_justified -->
Gets whether the menu item appears justified at the right
side of the menu bar.

# Deprecated since 3.2

See `MenuItem::set_right_justified`

# Returns

`true` if the menu item will appear at the
 far right if added to a menu bar.
<!-- trait MenuItemExt::fn get_submenu -->
Gets the submenu underneath this menu item, if any.
See `MenuItemExt::set_submenu`.

# Returns

submenu for this menu item, or `None` if none
<!-- trait MenuItemExt::fn get_use_underline -->
Checks if an underline in the text indicates the next character
should be used for the mnemonic accelerator key.

# Returns

`true` if an embedded underline in the label
 indicates the mnemonic accelerator key.
<!-- trait MenuItemExt::fn select -->
Emits the `MenuItem::select` signal on the given item.
<!-- trait MenuItemExt::fn set_accel_path -->
Set the accelerator path on `self`, through which runtime
changes of the menu item’s accelerator caused by the user can be
identified and saved to persistent storage (see `AccelMap::save`
on this). To set up a default accelerator for this menu item, call
`AccelMap::add_entry` with the same `accel_path`. See also
`AccelMap::add_entry` on the specifics of accelerator paths,
and `MenuExt::set_accel_path` for a more convenient variant of
this function.

This function is basically a convenience wrapper that handles
calling `WidgetExt::set_accel_path` with the appropriate accelerator
group for the menu item.

Note that you do need to set an accelerator on the parent menu with
`MenuExt::set_accel_group` for this to work.

Note that `accel_path` string will be stored in a `glib::Quark`.
Therefore, if you pass a static string, you can save some memory
by interning it first with `g_intern_static_string`.
## `accel_path`
accelerator path, corresponding to this menu
 item’s functionality, or `None` to unset the current path.
<!-- trait MenuItemExt::fn set_label -->
Sets `text` on the `self` label
## `label`
the text you want to set
<!-- trait MenuItemExt::fn set_reserve_indicator -->
Sets whether the `self` should reserve space for
the submenu indicator, regardless if it actually has
a submenu or not.

There should be little need for applications to call
this functions.
## `reserve`
the new value
<!-- trait MenuItemExt::fn set_right_justified -->
Sets whether the menu item appears justified at the right
side of a menu bar. This was traditionally done for “Help”
menu items, but is now considered a bad idea. (If the widget
layout is reversed for a right-to-left language like Hebrew
or Arabic, right-justified-menu-items appear at the left.)

# Deprecated since 3.2

If you insist on using it, use
 `WidgetExt::set_hexpand` and `WidgetExt::set_halign`.
## `right_justified`
if `true` the menu item will appear at the
 far right if added to a menu bar
<!-- trait MenuItemExt::fn set_submenu -->
Sets or replaces the menu item’s submenu, or removes it when a `None`
submenu is passed.
## `submenu`
the submenu, or `None`
<!-- trait MenuItemExt::fn set_use_underline -->
If true, an underline in the text indicates the next character
should be used for the mnemonic accelerator key.
## `setting`
`true` if underlines in the text indicate mnemonics
<!-- trait MenuItemExt::fn toggle_size_allocate -->
Emits the `MenuItem::toggle-size-allocate` signal on the given item.
## `allocation`
the allocation to use as signal data.
<!-- trait MenuItemExt::fn toggle_size_request -->
Emits the `MenuItem::toggle-size-request` signal on the given item.
## `requisition`
the requisition to use as signal data.
<!-- trait MenuItemExt::fn connect_activate -->
Emitted when the item is activated.
<!-- trait MenuItemExt::fn connect_activate_item -->
Emitted when the item is activated, but also if the menu item has a
submenu. For normal applications, the relevant signal is
`MenuItem::activate`.
<!-- trait MenuItemExt::fn get_property_accel-path -->
Sets the accelerator path of the menu item, through which runtime
changes of the menu item's accelerator caused by the user can be
identified and saved to persistant storage.
<!-- trait MenuItemExt::fn set_property_accel-path -->
Sets the accelerator path of the menu item, through which runtime
changes of the menu item's accelerator caused by the user can be
identified and saved to persistant storage.
<!-- trait MenuItemExt::fn get_property_label -->
The text for the child label.
<!-- trait MenuItemExt::fn set_property_label -->
The text for the child label.
<!-- trait MenuItemExt::fn get_property_right-justified -->
Sets whether the menu item appears justified
at the right side of a menu bar.
<!-- trait MenuItemExt::fn set_property_right-justified -->
Sets whether the menu item appears justified
at the right side of a menu bar.
<!-- trait MenuItemExt::fn get_property_submenu -->
The submenu attached to the menu item, or `None` if it has none.
<!-- trait MenuItemExt::fn set_property_submenu -->
The submenu attached to the menu item, or `None` if it has none.
<!-- trait MenuItemExt::fn get_property_use-underline -->
`true` if underlines in the text indicate mnemonics.
<!-- trait MenuItemExt::fn set_property_use-underline -->
`true` if underlines in the text indicate mnemonics.
<!-- struct MenuShell -->
A `MenuShell` is the abstract base class used to derive the
`Menu` and `MenuBar` subclasses.

A `MenuShell` is a container of `MenuItem` objects arranged
in a list which can be navigated, selected, and activated by the
user to perform application functions. A `MenuItem` can have a
submenu associated with it, allowing for nested hierarchical menus.

# Terminology

A menu item can be “selected”, this means that it is displayed
in the prelight state, and if it has a submenu, that submenu
will be popped up.

A menu is “active” when it is visible onscreen and the user
is selecting from it. A menubar is not active until the user
clicks on one of its menuitems. When a menu is active,
passing the mouse over a submenu will pop it up.

There is also is a concept of the current menu and a current
menu item. The current menu item is the selected menu item
that is furthest down in the hierarchy. (Every active menu shell
does not necessarily contain a selected menu item, but if
it does, then the parent menu shell must also contain
a selected menu item.) The current menu is the menu that
contains the current menu item. It will always have a GTK
grab and receive all key presses.

# Implements

[`MenuShellExt`](trait.MenuShellExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait MenuShellExt -->
Trait containing all `MenuShell` methods.

# Implementors

[`MenuBar`](struct.MenuBar.html), [`MenuShell`](struct.MenuShell.html), [`Menu`](struct.Menu.html)
<!-- trait MenuShellExt::fn activate_item -->
Activates the menu item within the menu shell.
## `menu_item`
the `MenuItem` to activate
## `force_deactivate`
if `true`, force the deactivation of the
 menu shell after the menu item is activated
<!-- trait MenuShellExt::fn append -->
Adds a new `MenuItem` to the end of the menu shell's
item list.
## `child`
The `MenuItem` to add
<!-- trait MenuShellExt::fn bind_model -->
Establishes a binding between a `MenuShell` and a `gio::MenuModel`.

The contents of `shell` are removed and then refilled with menu items
according to `model`. When `model` changes, `shell` is updated.
Calling this function twice on `shell` with different `model` will
cause the first binding to be replaced with a binding to the new
model. If `model` is `None` then any previous binding is undone and
all children are removed.

`with_separators` determines if toplevel items (eg: sections) have
separators inserted between them. This is typically desired for
menus but doesn’t make sense for menubars.

If `action_namespace` is non-`None` then the effect is as if all
actions mentioned in the `model` have their names prefixed with the
namespace, plus a dot. For example, if the action “quit” is
mentioned and `action_namespace` is “app” then the effective action
name is “app.quit”.

This function uses `Actionable` to define the action name and
target values on the created menu items. If you want to use an
action group other than “app” and “win”, or if you want to use a
`MenuShell` outside of a `ApplicationWindow`, then you will need
to attach your own action group to the widget hierarchy using
`WidgetExt::insert_action_group`. As an example, if you created a
group with a “quit” action and inserted it with the name “mygroup”
then you would use the action name “mygroup.quit” in your
`gio::MenuModel`.

For most cases you are probably better off using
`Menu::new_from_model` or `MenuBar::new_from_model` or just
directly passing the `gio::MenuModel` to `GtkApplicationExt::set_app_menu` or
`GtkApplicationExt::set_menubar`.

Feature: `v3_6`

## `model`
the `gio::MenuModel` to bind to or `None` to remove
 binding
## `action_namespace`
the namespace for actions in `model`
## `with_separators`
`true` if toplevel items in `shell` should have
 separators between them
<!-- trait MenuShellExt::fn cancel -->
Cancels the selection within the menu shell.
<!-- trait MenuShellExt::fn deactivate -->
Deactivates the menu shell.

Typically this results in the menu shell being erased
from the screen.
<!-- trait MenuShellExt::fn deselect -->
Deselects the currently selected item from the menu shell,
if any.
<!-- trait MenuShellExt::fn get_parent_shell -->
Gets the parent menu shell.

The parent menu shell of a submenu is the `Menu` or `MenuBar`
from which it was opened up.

# Returns

the parent `MenuShell`
<!-- trait MenuShellExt::fn get_selected_item -->
Gets the currently selected item.

# Returns

the currently selected item
<!-- trait MenuShellExt::fn get_take_focus -->
Returns `true` if the menu shell will take the keyboard focus on popup.

# Returns

`true` if the menu shell will take the keyboard focus on popup.
<!-- trait MenuShellExt::fn insert -->
Adds a new `MenuItem` to the menu shell’s item list
at the position indicated by `position`.
## `child`
The `MenuItem` to add
## `position`
The position in the item list where `child`
 is added. Positions are numbered from 0 to n-1
<!-- trait MenuShellExt::fn prepend -->
Adds a new `MenuItem` to the beginning of the menu shell's
item list.
## `child`
The `MenuItem` to add
<!-- trait MenuShellExt::fn select_first -->
Select the first visible or selectable child of the menu shell;
don’t select tearoff items unless the only item is a tearoff
item.
## `search_sensitive`
if `true`, search for the first selectable
 menu item, otherwise select nothing if
 the first item isn’t sensitive. This
 should be `false` if the menu is being
 popped up initially.
<!-- trait MenuShellExt::fn select_item -->
Selects the menu item from the menu shell.
## `menu_item`
The `MenuItem` to select
<!-- trait MenuShellExt::fn set_take_focus -->
If `take_focus` is `true` (the default) the menu shell will take
the keyboard focus so that it will receive all keyboard events
which is needed to enable keyboard navigation in menus.

Setting `take_focus` to `false` is useful only for special applications
like virtual keyboard implementations which should not take keyboard
focus.

The `take_focus` state of a menu or menu bar is automatically
propagated to submenus whenever a submenu is popped up, so you
don’t have to worry about recursively setting it for your entire
menu hierarchy. Only when programmatically picking a submenu and
popping it up manually, the `take_focus` property of the submenu
needs to be set explicitly.

Note that setting it to `false` has side-effects:

If the focus is in some other app, it keeps the focus and keynav in
the menu doesn’t work. Consequently, keynav on the menu will only
work if the focus is on some toplevel owned by the onscreen keyboard.

To avoid confusing the user, menus with `take_focus` set to `false`
should not display mnemonics or accelerators, since it cannot be
guaranteed that they will work.

See also `gdk_keyboard_grab`
## `take_focus`
`true` if the menu shell should take the keyboard
 focus on popup
<!-- trait MenuShellExt::fn connect_activate_current -->
An action signal that activates the current menu item within
the menu shell.
## `force_hide`
if `true`, hide the menu after activating the menu item
<!-- trait MenuShellExt::fn connect_cancel -->
An action signal which cancels the selection within the menu shell.
Causes the `MenuShell::selection-done` signal to be emitted.
<!-- trait MenuShellExt::fn connect_cycle_focus -->
A keybinding signal which moves the focus in the
given `direction`.
## `direction`
the direction to cycle in
<!-- trait MenuShellExt::fn connect_deactivate -->
This signal is emitted when a menu shell is deactivated.
<!-- trait MenuShellExt::fn connect_insert -->
The ::insert signal is emitted when a new `MenuItem` is added to
a `MenuShell`. A separate signal is used instead of
`Container`::add because of the need for an additional position
parameter.

The inverse of this signal is the `Container`::removed signal.
## `child`
the `MenuItem` that is being inserted
## `position`
the position at which the insert occurs
<!-- trait MenuShellExt::fn connect_move_current -->
An keybinding signal which moves the current menu item
in the direction specified by `direction`.
## `direction`
the direction to move
<!-- trait MenuShellExt::fn connect_move_selected -->
The ::move-selected signal is emitted to move the selection to
another item.
## `distance`
+1 to move to the next item, -1 to move to the previous

# Returns

`true` to stop the signal emission, `false` to continue
<!-- trait MenuShellExt::fn connect_selection_done -->
This signal is emitted when a selection has been
completed within a menu shell.
<!-- trait MenuShellExt::fn get_property_take-focus -->
A boolean that determines whether the menu and its submenus grab the
keyboard focus. See `MenuShellExt::set_take_focus` and
`MenuShellExt::get_take_focus`.
<!-- trait MenuShellExt::fn set_property_take-focus -->
A boolean that determines whether the menu and its submenus grab the
keyboard focus. See `MenuShellExt::set_take_focus` and
`MenuShellExt::get_take_focus`.
<!-- struct MenuToolButton -->
A `MenuToolButton` is a `ToolItem` that contains a button and
a small additional button with an arrow. When clicked, the arrow
button pops up a dropdown menu.

Use `MenuToolButton::new` to create a new
`MenuToolButton`.

# `MenuToolButton` as `Buildable`

The `MenuToolButton` implementation of the `Buildable` interface
supports adding a menu by specifying “menu” as the “type” attribute
of a `<child>` element.

An example for a UI definition fragment with menus:

```text
<object class="GtkMenuToolButton">
  <child type="menu">
    <object class="GtkMenu"/>
  </child>
</object>
```

# Implements

[`MenuToolButtonExt`](trait.MenuToolButtonExt.html), [`ToolButtonExt`](trait.ToolButtonExt.html), [`ToolItemExt`](trait.ToolItemExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`ActionableExt`](trait.ActionableExt.html)
<!-- trait MenuToolButtonExt -->
Trait containing all `MenuToolButton` methods.

# Implementors

[`MenuToolButton`](struct.MenuToolButton.html)
<!-- impl MenuToolButton::fn new -->
Creates a new `MenuToolButton` using `icon_widget` as icon and
`label` as label.
## `icon_widget`
a widget that will be used as icon widget, or `None`
## `label`
a string that will be used as label, or `None`

# Returns

the new `MenuToolButton`
<!-- impl MenuToolButton::fn new_from_stock -->
Creates a new `MenuToolButton`.
The new `MenuToolButton` will contain an icon and label from
the stock item indicated by `stock_id`.

# Deprecated since 3.10

Use `MenuToolButton::new` instead.
## `stock_id`
the name of a stock item

# Returns

the new `MenuToolButton`
<!-- trait MenuToolButtonExt::fn get_menu -->
Gets the `Menu` associated with `MenuToolButton`.

# Returns

the `Menu` associated
 with `MenuToolButton`
<!-- trait MenuToolButtonExt::fn set_arrow_tooltip_markup -->
Sets the tooltip markup text to be used as tooltip for the arrow button
which pops up the menu. See `ToolItem::set_tooltip_text` for setting
a tooltip on the whole `MenuToolButton`.
## `markup`
markup text to be used as tooltip text for button’s arrow button
<!-- trait MenuToolButtonExt::fn set_arrow_tooltip_text -->
Sets the tooltip text to be used as tooltip for the arrow button which
pops up the menu. See `ToolItem::set_tooltip_text` for setting a tooltip
on the whole `MenuToolButton`.
## `text`
text to be used as tooltip text for button’s arrow button
<!-- trait MenuToolButtonExt::fn set_menu -->
Sets the `Menu` that is popped up when the user clicks on the arrow.
If `menu` is NULL, the arrow button becomes insensitive.
## `menu`
the `Menu` associated with `MenuToolButton`
<!-- trait MenuToolButtonExt::fn connect_show_menu -->
The ::show-menu signal is emitted before the menu is shown.

It can be used to populate the menu on demand, using
`MenuToolButtonExt::set_menu`.

Note that even if you populate the menu dynamically in this way,
you must set an empty menu on the `MenuToolButton` beforehand,
since the arrow is made insensitive if the menu is not set.
<!-- struct MessageDialog -->
`MessageDialog` presents a dialog with some message text. It’s simply a
convenience widget; you could construct the equivalent of `MessageDialog`
from `Dialog` without too much effort, but `MessageDialog` saves typing.

One difference from `Dialog` is that `MessageDialog` sets the
`Window:skip-taskbar-hint` property to `true`, so that the dialog is hidden
from the taskbar by default.

The easiest way to do a modal message dialog is to use `DialogExt::run`, though
you can also pass in the `DialogFlags::Modal` flag, `DialogExt::run` automatically
makes the dialog modal and waits for the user to respond to it. `DialogExt::run`
returns when any dialog button is clicked.

An example for using a modal dialog:

```C
 GtkDialogFlags flags = GTK_DIALOG_DESTROY_WITH_PARENT;
 dialog = gtk_message_dialog_new (parent_window,
                                  flags,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Error reading “%s”: %s",
                                  filename,
                                  g_strerror (errno));
 gtk_dialog_run (GTK_DIALOG (dialog));
 gtk_widget_destroy (dialog);
```

You might do a non-modal `MessageDialog` as follows:

An example for a non-modal dialog:

```C
 GtkDialogFlags flags = GTK_DIALOG_DESTROY_WITH_PARENT;
 dialog = gtk_message_dialog_new (parent_window,
                                  flags,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Error reading “%s”: %s",
                                  filename,
                                  g_strerror (errno));

 // Destroy the dialog when the user responds to it
 // (e.g. clicks a button)

 g_signal_connect_swapped (dialog, "response",
                           G_CALLBACK (gtk_widget_destroy),
                           dialog);
```

# `MessageDialog` as `Buildable`

The `MessageDialog` implementation of the `Buildable` interface exposes
the message area as an internal child with the name “message_area”.

# Implements

[`MessageDialogExt`](trait.MessageDialogExt.html), [`DialogExt`](trait.DialogExt.html), [`GtkWindowExt`](trait.GtkWindowExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait MessageDialogExt -->
Trait containing all `MessageDialog` methods.

# Implementors

[`MessageDialog`](struct.MessageDialog.html)
<!-- impl MessageDialog::fn new -->
Creates a new message dialog, which is a simple dialog with some text
the user may want to see. When the user clicks a button a “response”
signal is emitted with response IDs from `ResponseType`. See
`Dialog` for more details.
## `parent`
transient parent, or `None` for none
## `flags`
flags
## `type_`
type of message
## `buttons`
set of buttons to use
## `message_format`
`printf`-style format string, or `None`

# Returns

a new `MessageDialog`
<!-- impl MessageDialog::fn new_with_markup -->
Creates a new message dialog, which is a simple dialog with some text that
is marked up with the [Pango text markup language][PangoMarkupFormat].
When the user clicks a button a “response” signal is emitted with
response IDs from `ResponseType`. See `Dialog` for more details.

Special XML characters in the `printf` arguments passed to this
function will automatically be escaped as necessary.
(See `g_markup_printf_escaped` for how this is implemented.)
Usually this is what you want, but if you have an existing
Pango markup string that you want to use literally as the
label, then you need to use `MessageDialogExt::set_markup`
instead, since you can’t pass the markup string either
as the format (it might contain “%” characters) or as a string
argument.

```C
 GtkWidget *dialog;
 GtkDialogFlags flags = GTK_DIALOG_DESTROY_WITH_PARENT;
 dialog = gtk_message_dialog_new (parent_window,
                                  flags,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  NULL);
 gtk_message_dialog_set_markup (GTK_MESSAGE_DIALOG (dialog),
                                markup);
```
## `parent`
transient parent, or `None` for none
## `flags`
flags
## `type_`
type of message
## `buttons`
set of buttons to use
## `message_format`
`printf`-style format string, or `None`

# Returns

a new `MessageDialog`
<!-- trait MessageDialogExt::fn format_secondary_markup -->
Sets the secondary text of the message dialog to be `message_format` (with
`printf`-style), which is marked up with the
[Pango text markup language][PangoMarkupFormat].

Due to an oversight, this function does not escape special XML characters
like `MessageDialog::new_with_markup` does. Thus, if the arguments
may contain special XML characters, you should use `g_markup_printf_escaped`
to escape it.


```C
gchar *msg;

msg = g_markup_printf_escaped (message_format, ...);
gtk_message_dialog_format_secondary_markup (message_dialog,
                                            "%s", msg);
g_free (msg);
```
## `message_format`
`printf`-style markup string (see
 [Pango markup format][PangoMarkupFormat]), or `None`
<!-- trait MessageDialogExt::fn format_secondary_text -->
Sets the secondary text of the message dialog to be `message_format`
(with `printf`-style).
## `message_format`
`printf`-style format string, or `None`
<!-- trait MessageDialogExt::fn get_image -->
Gets the dialog’s image.

# Deprecated since 3.12

Use `Dialog` for dialogs with images

# Returns

the dialog’s image
<!-- trait MessageDialogExt::fn get_message_area -->
Returns the message area of the dialog. This is the box where the
dialog’s primary and secondary labels are packed. You can add your
own extra content to that box and it will appear below those labels.
See `DialogExt::get_content_area` for the corresponding
function in the parent `Dialog`.

# Returns

A `Box` corresponding to the
 “message area” in the `self`.
<!-- trait MessageDialogExt::fn set_image -->
Sets the dialog’s image to `image`.

# Deprecated since 3.12

Use `Dialog` to create dialogs with images
## `image`
the image
<!-- trait MessageDialogExt::fn set_markup -->
Sets the text of the message dialog to be `str`, which is marked
up with the [Pango text markup language][PangoMarkupFormat].
## `str`
markup string (see [Pango markup format][PangoMarkupFormat])
<!-- trait MessageDialogExt::fn get_property_image -->
The image for this dialog.

# Deprecated since 3.12

Use `Dialog` to create dialogs with images
<!-- trait MessageDialogExt::fn set_property_image -->
The image for this dialog.

# Deprecated since 3.12

Use `Dialog` to create dialogs with images
<!-- trait MessageDialogExt::fn get_property_message-area -->
The `Box` that corresponds to the message area of this dialog. See
`MessageDialogExt::get_message_area` for a detailed description of this
area.
<!-- trait MessageDialogExt::fn get_property_message-type -->
The type of the message.
<!-- trait MessageDialogExt::fn set_property_message-type -->
The type of the message.
<!-- trait MessageDialogExt::fn get_property_secondary-text -->
The secondary text of the message dialog.
<!-- trait MessageDialogExt::fn set_property_secondary-text -->
The secondary text of the message dialog.
<!-- trait MessageDialogExt::fn get_property_secondary-use-markup -->
`true` if the secondary text of the dialog includes Pango markup.
See `pango_parse_markup`.
<!-- trait MessageDialogExt::fn set_property_secondary-use-markup -->
`true` if the secondary text of the dialog includes Pango markup.
See `pango_parse_markup`.
<!-- trait MessageDialogExt::fn get_property_text -->
The primary text of the message dialog. If the dialog has
a secondary text, this will appear as the title.
<!-- trait MessageDialogExt::fn set_property_text -->
The primary text of the message dialog. If the dialog has
a secondary text, this will appear as the title.
<!-- trait MessageDialogExt::fn get_property_use-markup -->
`true` if the primary text of the dialog includes Pango markup.
See `pango_parse_markup`.
<!-- trait MessageDialogExt::fn set_property_use-markup -->
`true` if the primary text of the dialog includes Pango markup.
See `pango_parse_markup`.
<!-- enum MessageType -->
The type of message being displayed in the dialog.
<!-- enum MessageType::variant Info -->
Informational message
<!-- enum MessageType::variant Warning -->
Non-fatal warning message
<!-- enum MessageType::variant Question -->
Question requiring a choice
<!-- enum MessageType::variant Error -->
Fatal error message
<!-- enum MessageType::variant Other -->
None of the above
<!-- struct Misc -->
`[Deprecated since 3.14]` The `Misc` widget is an abstract widget which is not useful itself, but
is used to derive subclasses which have alignment and padding attributes.

The horizontal and vertical padding attributes allows extra space to be
added around the widget.

The horizontal and vertical alignment attributes enable the widget to be
positioned within its allocated area. Note that if the widget is added to
a container in such a way that it expands automatically to fill its
allocated area, the alignment settings will not alter the widget's position.

Note that the desired effect can in most cases be achieved by using the
`Widget:halign`, `Widget:valign` and `Widget:margin` properties
on the child widget, so `Misc` should not be used in new code. To reflect
this fact, all `Misc` API has been deprecated.

# Implements

[`MiscExt`](trait.MiscExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait MiscExt -->
`[Deprecated since 3.14]` Trait containing all `Misc` methods.

# Implementors

[`Arrow`](struct.Arrow.html), [`Image`](struct.Image.html), [`Label`](struct.Label.html), [`Misc`](struct.Misc.html)
<!-- trait MiscExt::fn get_alignment -->
Gets the X and Y alignment of the widget within its allocation.
See `MiscExt::set_alignment`.

# Deprecated since 3.14

Use `Widget` alignment and margin properties.
## `xalign`
location to store X alignment of `self`, or `None`
## `yalign`
location to store Y alignment of `self`, or `None`
<!-- trait MiscExt::fn get_padding -->
Gets the padding in the X and Y directions of the widget.
See `MiscExt::set_padding`.

# Deprecated since 3.14

Use `Widget` alignment and margin properties.
## `xpad`
location to store padding in the X
 direction, or `None`
## `ypad`
location to store padding in the Y
 direction, or `None`
<!-- trait MiscExt::fn set_alignment -->
Sets the alignment of the widget.

# Deprecated since 3.14

Use `Widget`'s alignment (`Widget:halign` and `Widget:valign`) and margin properties or `Label`'s `Label:xalign` and `Label:yalign` properties.
## `xalign`
the horizontal alignment, from 0 (left) to 1 (right).
## `yalign`
the vertical alignment, from 0 (top) to 1 (bottom).
<!-- trait MiscExt::fn set_padding -->
Sets the amount of space to add around the widget.

# Deprecated since 3.14

Use `Widget` alignment and margin properties.
## `xpad`
the amount of space to add on the left and right of the widget,
 in pixels.
## `ypad`
the amount of space to add on the top and bottom of the widget,
 in pixels.
<!-- trait MiscExt::fn get_property_xalign -->
The horizontal alignment. A value of 0.0 means left alignment (or right
on RTL locales); a value of 1.0 means right alignment (or left on RTL
locales).

# Deprecated since 3.14

Use `WidgetExt::set_halign` instead. If you are using
 `Label`, use `Label:xalign` instead.
<!-- trait MiscExt::fn set_property_xalign -->
The horizontal alignment. A value of 0.0 means left alignment (or right
on RTL locales); a value of 1.0 means right alignment (or left on RTL
locales).

# Deprecated since 3.14

Use `WidgetExt::set_halign` instead. If you are using
 `Label`, use `Label:xalign` instead.
<!-- trait MiscExt::fn get_property_xpad -->
The amount of space to add on the left and right of the widget, in
pixels.

# Deprecated since 3.14

Use `WidgetExt::set_margin_start` and
 `WidgetExt::set_margin_end` instead
<!-- trait MiscExt::fn set_property_xpad -->
The amount of space to add on the left and right of the widget, in
pixels.

# Deprecated since 3.14

Use `WidgetExt::set_margin_start` and
 `WidgetExt::set_margin_end` instead
<!-- trait MiscExt::fn get_property_yalign -->
The vertical alignment. A value of 0.0 means top alignment;
a value of 1.0 means bottom alignment.

# Deprecated since 3.14

Use `WidgetExt::set_valign` instead. If you are using
 `Label`, use `Label:yalign` instead.
<!-- trait MiscExt::fn set_property_yalign -->
The vertical alignment. A value of 0.0 means top alignment;
a value of 1.0 means bottom alignment.

# Deprecated since 3.14

Use `WidgetExt::set_valign` instead. If you are using
 `Label`, use `Label:yalign` instead.
<!-- trait MiscExt::fn get_property_ypad -->
The amount of space to add on the top and bottom of the widget, in
pixels.

# Deprecated since 3.14

Use `WidgetExt::set_margin_top` and
 `WidgetExt::set_margin_bottom` instead
<!-- trait MiscExt::fn set_property_ypad -->
The amount of space to add on the top and bottom of the widget, in
pixels.

# Deprecated since 3.14

Use `WidgetExt::set_margin_top` and
 `WidgetExt::set_margin_bottom` instead
<!-- struct ModelButton -->
`ModelButton` is a button class that can use a `gio::Action` as its model.
In contrast to `ToggleButton` or `RadioButton`, which can also
be backed by a `gio::Action` via the `Actionable:action-name` property,
`ModelButton` will adapt its appearance according to the kind of
action it is backed by, and appear either as a plain, check or
radio button.

Model buttons are used when popovers from a menu model with
`Popover::new_from_model`; they can also be used manually in
a `PopoverMenu`.

When the action is specified via the `Actionable:action-name`
and `Actionable:action-target` properties, the role of the button
(i.e. whether it is a plain, check or radio button) is determined by
the type of the action and doesn't have to be explicitly specified
with the `ModelButton:role` property.

The content of the button is specified by the `ModelButton:text`
and `ModelButton:icon` properties.

The appearance of model buttons can be influenced with the
`ModelButton:centered` and `ModelButton:iconic` properties.

Model buttons have built-in support for submenus in `PopoverMenu`.
To make a `ModelButton` that opens a submenu when activated, set
the `ModelButton:menu-name` property. To make a button that goes
back to the parent menu, you should set the `ModelButton:inverted`
property to place the submenu indicator at the opposite side.

# Example


```plain
modelbutton
├── <child>
╰── check
```


```plain
modelbutton
├── <child>
╰── radio
```


```plain
modelbutton
├── <child>
╰── arrow
```

`ModelButton` has a main CSS node with name modelbutton, and a subnode,
which will have the name check, radio or arrow, depending on the role
of the button and whether it has a menu name set.

The subnode is positioned before or after the content nodes and gets the
.left or .right style class, depending on where it is located.


```plain
button.model
├── <child>
╰── check
```

Iconic model buttons (see `ModelButton:iconic`) change the name of
their main node to button and add a .model style class to it. The indicator
subnode is invisible in this case.

Feature: `v3_16`

# Implements

[`ModelButtonExt`](trait.ModelButtonExt.html), [`ButtonExt`](trait.ButtonExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`ActionableExt`](trait.ActionableExt.html)
<!-- trait ModelButtonExt -->
Trait containing all `ModelButton` methods.

Feature: `v3_16`

# Implementors

[`ModelButton`](struct.ModelButton.html)
<!-- impl ModelButton::fn new -->
Creates a new `ModelButton`.

Feature: `v3_16`


# Returns

the newly created `ModelButton` widget
<!-- trait ModelButtonExt::fn get_property_active -->
The state of the button. This is reflecting the state of the associated
`gio::Action`.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn set_property_active -->
The state of the button. This is reflecting the state of the associated
`gio::Action`.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn get_property_centered -->
Wether to render the button contents centered instead of left-aligned.
This property should be set for title-like items.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn set_property_centered -->
Wether to render the button contents centered instead of left-aligned.
This property should be set for title-like items.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn get_property_icon -->
A `gio::Icon` that will be used if iconic appearance for the button is
desired.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn set_property_icon -->
A `gio::Icon` that will be used if iconic appearance for the button is
desired.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn get_property_iconic -->
If this property is set, the button will show an icon if one is set.
If no icon is set, the text will be used. This is typically used for
horizontal sections of linked buttons.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn set_property_iconic -->
If this property is set, the button will show an icon if one is set.
If no icon is set, the text will be used. This is typically used for
horizontal sections of linked buttons.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn get_property_inverted -->
Whether to show the submenu indicator at the opposite side than normal.
This property should be set for model buttons that 'go back' to a parent
menu.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn set_property_inverted -->
Whether to show the submenu indicator at the opposite side than normal.
This property should be set for model buttons that 'go back' to a parent
menu.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn get_property_menu-name -->
The name of a submenu to open when the button is activated.
If this is set, the button should not have an action associated with it.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn set_property_menu-name -->
The name of a submenu to open when the button is activated.
If this is set, the button should not have an action associated with it.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn get_property_role -->
Specifies whether the button is a plain, check or radio button.
When `Actionable:action-name` is set, the role will be determined
from the action and does not have to be set explicitly.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn set_property_role -->
Specifies whether the button is a plain, check or radio button.
When `Actionable:action-name` is set, the role will be determined
from the action and does not have to be set explicitly.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn get_property_text -->
The label for the button.

Feature: `v3_16`

<!-- trait ModelButtonExt::fn set_property_text -->
The label for the button.

Feature: `v3_16`

<!-- enum MovementStep -->
<!-- enum MovementStep::variant LogicalPositions -->
Move forward or back by graphemes
<!-- enum MovementStep::variant VisualPositions -->
Move left or right by graphemes
<!-- enum MovementStep::variant Words -->
Move forward or back by words
<!-- enum MovementStep::variant DisplayLines -->
Move up or down lines (wrapped lines)
<!-- enum MovementStep::variant DisplayLineEnds -->
Move to either end of a line
<!-- enum MovementStep::variant Paragraphs -->
Move up or down paragraphs (newline-ended lines)
<!-- enum MovementStep::variant ParagraphEnds -->
Move to either end of a paragraph
<!-- enum MovementStep::variant Pages -->
Move by pages
<!-- enum MovementStep::variant BufferEnds -->
Move to ends of the buffer
<!-- enum MovementStep::variant HorizontalPages -->
Move horizontally by pages
<!-- struct Notebook -->
The `Notebook` widget is a `Container` whose children are pages that
can be switched between using tab labels along one edge.

There are many configuration options for `Notebook`. Among other
things, you can choose on which edge the tabs appear
(see `NotebookExt::set_tab_pos`), whether, if there are too many
tabs to fit the notebook should be made bigger or scrolling
arrows added (see `NotebookExt::set_scrollable`), and whether there
will be a popup menu allowing the users to switch pages.
(see `NotebookExt::popup_enable`, `NotebookExt::popup_disable`)

# `Notebook` as `Buildable`

The `Notebook` implementation of the `Buildable` interface
supports placing children into tabs by specifying “tab” as the
“type” attribute of a `<child>` element. Note that the content
of the tab must be created before the tab can be filled.
A tab child can be specified without specifying a `<child>`
type attribute.

To add a child widget in the notebooks action area, specify
"action-start" or “action-end” as the “type” attribute of the
`<child>` element.

An example of a UI definition fragment with `Notebook`:

```plain
notebook
├── header.top
│   ├── [<action widget>]
│   ├── tabs
│   │   ├── [arrow]
│   │   ├── tab
│   │   │   ╰── <tab label>
┊   ┊   ┊
│   │   ├── tab[.reorderable-page]
│   │   │   ╰── <tab label>
│   │   ╰── [arrow]
│   ╰── [<action widget>]
│
╰── stack
    ├── <child>
    ┊
    ╰── <child>
```

`Notebook` has a main CSS node with name notebook, a subnode
with name header and below that a subnode with name tabs which
contains one subnode per tab with name tab.

If action widgets are present, their CSS nodes are placed next
to the tabs node. If the notebook is scrollable, CSS nodes with
name arrow are placed as first and last child of the tabs node.

The main node gets the .frame style class when the notebook
has a border (see `NotebookExt::set_show_border`).

The header node gets one of the style class .top, .bottom,
.left or .right, depending on where the tabs are placed. For
reorderable pages, the tab node gets the .reorderable-page class.

A tab node gets the .dnd style class while it is moved with drag-and-drop.

The nodes are always arranged from left-to-right, regarldess of text direction.

# Implements

[`NotebookExt`](trait.NotebookExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait NotebookExt -->
Trait containing all `Notebook` methods.

# Implementors

[`Notebook`](struct.Notebook.html)
<!-- impl Notebook::fn new -->
Creates a new `Notebook` widget with no pages.

# Returns

the newly created `Notebook`
<!-- trait NotebookExt::fn append_page -->
Appends a page to `self`.
## `child`
the `Widget` to use as the contents of the page
## `tab_label`
the `Widget` to be used as the label
 for the page, or `None` to use the default label, “page N”

# Returns

the index (starting from 0) of the appended
 page in the notebook, or -1 if function fails
<!-- trait NotebookExt::fn append_page_menu -->
Appends a page to `self`, specifying the widget to use as the
label in the popup menu.
## `child`
the `Widget` to use as the contents of the page
## `tab_label`
the `Widget` to be used as the label
 for the page, or `None` to use the default label, “page N”
## `menu_label`
the widget to use as a label for the
 page-switch menu, if that is enabled. If `None`, and `tab_label`
 is a `Label` or `None`, then the menu label will be a newly
 created label with the same text as `tab_label`; if `tab_label`
 is not a `Label`, `menu_label` must be specified if the
 page-switch menu is to be used.

# Returns

the index (starting from 0) of the appended
 page in the notebook, or -1 if function fails
<!-- trait NotebookExt::fn detach_tab -->
Removes the child from the notebook.

This function is very similar to `ContainerExt::remove`,
but additionally informs the notebook that the removal
is happening as part of a tab DND operation, which should
not be cancelled.

Feature: `v3_16`

## `child`
a child
<!-- trait NotebookExt::fn get_action_widget -->
Gets one of the action widgets. See `NotebookExt::set_action_widget`.
## `pack_type`
pack type of the action widget to receive

# Returns

The action widget with the given
`pack_type` or `None` when this action widget has not been set
<!-- trait NotebookExt::fn get_current_page -->
Returns the page number of the current page.

# Returns

the index (starting from 0) of the current
 page in the notebook. If the notebook has no pages,
 then -1 will be returned.
<!-- trait NotebookExt::fn get_group_name -->
Gets the current group name for `self`.

# Returns

the group name, or `None` if none is set
<!-- trait NotebookExt::fn get_menu_label -->
Retrieves the menu label widget of the page containing `child`.
## `child`
a widget contained in a page of `self`

# Returns

the menu label, or `None` if the
notebook page does not have a menu label other than the default (the tab
label).
<!-- trait NotebookExt::fn get_menu_label_text -->
Retrieves the text of the menu label for the page containing
`child`.
## `child`
the child widget of a page of the notebook.

# Returns

the text of the tab label, or `None` if the widget does
not have a menu label other than the default menu label, or the menu label
widget is not a `Label`. The string is owned by the widget and must not be
freed.
<!-- trait NotebookExt::fn get_n_pages -->
Gets the number of pages in a notebook.

# Returns

the number of pages in the notebook
<!-- trait NotebookExt::fn get_nth_page -->
Returns the child widget contained in page number `page_num`.
## `page_num`
the index of a page in the notebook, or -1
 to get the last page

# Returns

the child widget, or `None` if `page_num`
is out of bounds
<!-- trait NotebookExt::fn get_scrollable -->
Returns whether the tab label area has arrows for scrolling.
See `NotebookExt::set_scrollable`.

# Returns

`true` if arrows for scrolling are present
<!-- trait NotebookExt::fn get_show_border -->
Returns whether a bevel will be drawn around the notebook pages.
See `NotebookExt::set_show_border`.

# Returns

`true` if the bevel is drawn
<!-- trait NotebookExt::fn get_show_tabs -->
Returns whether the tabs of the notebook are shown.
See `NotebookExt::set_show_tabs`.

# Returns

`true` if the tabs are shown
<!-- trait NotebookExt::fn get_tab_detachable -->
Returns whether the tab contents can be detached from `self`.
## `child`
a child `Widget`

# Returns

`true` if the tab is detachable.
<!-- trait NotebookExt::fn get_tab_hborder -->
Returns the horizontal width of a tab border.

# Deprecated since 3.4

this function returns zero

# Returns

horizontal width of a tab border
<!-- trait NotebookExt::fn get_tab_label -->
Returns the tab label widget for the page `child`.
`None` is returned if `child` is not in `self` or
if no tab label has specifically been set for `child`.
## `child`
the page

# Returns

the tab label
<!-- trait NotebookExt::fn get_tab_label_text -->
Retrieves the text of the tab label for the page containing
`child`.
## `child`
a widget contained in a page of `self`

# Returns

the text of the tab label, or `None` if the tab label
widget is not a `Label`. The string is owned by the widget and must not be
freed.
<!-- trait NotebookExt::fn get_tab_pos -->
Gets the edge at which the tabs for switching pages in the
notebook are drawn.

# Returns

the edge at which the tabs are drawn
<!-- trait NotebookExt::fn get_tab_reorderable -->
Gets whether the tab can be reordered via drag and drop or not.
## `child`
a child `Widget`

# Returns

`true` if the tab is reorderable.
<!-- trait NotebookExt::fn get_tab_vborder -->
Returns the vertical width of a tab border.

# Deprecated since 3.4

this function returns zero

# Returns

vertical width of a tab border
<!-- trait NotebookExt::fn insert_page -->
Insert a page into `self` at the given position.
## `child`
the `Widget` to use as the contents of the page
## `tab_label`
the `Widget` to be used as the label
 for the page, or `None` to use the default label, “page N”
## `position`
the index (starting at 0) at which to insert the page,
 or -1 to append the page after all other pages

# Returns

the index (starting from 0) of the inserted
 page in the notebook, or -1 if function fails
<!-- trait NotebookExt::fn insert_page_menu -->
Insert a page into `self` at the given position, specifying
the widget to use as the label in the popup menu.
## `child`
the `Widget` to use as the contents of the page
## `tab_label`
the `Widget` to be used as the label
 for the page, or `None` to use the default label, “page N”
## `menu_label`
the widget to use as a label for the
 page-switch menu, if that is enabled. If `None`, and `tab_label`
 is a `Label` or `None`, then the menu label will be a newly
 created label with the same text as `tab_label`; if `tab_label`
 is not a `Label`, `menu_label` must be specified if the
 page-switch menu is to be used.
## `position`
the index (starting at 0) at which to insert the page,
 or -1 to append the page after all other pages.

# Returns

the index (starting from 0) of the inserted
 page in the notebook
<!-- trait NotebookExt::fn next_page -->
Switches to the next page. Nothing happens if the current page is
the last page.
<!-- trait NotebookExt::fn page_num -->
Finds the index of the page which contains the given child
widget.
## `child`
a `Widget`

# Returns

the index of the page containing `child`, or
 -1 if `child` is not in the notebook
<!-- trait NotebookExt::fn popup_disable -->
Disables the popup menu.
<!-- trait NotebookExt::fn popup_enable -->
Enables the popup menu: if the user clicks with the right
mouse button on the tab labels, a menu with all the pages
will be popped up.
<!-- trait NotebookExt::fn prepend_page -->
Prepends a page to `self`.
## `child`
the `Widget` to use as the contents of the page
## `tab_label`
the `Widget` to be used as the label
 for the page, or `None` to use the default label, “page N”

# Returns

the index (starting from 0) of the prepended
 page in the notebook, or -1 if function fails
<!-- trait NotebookExt::fn prepend_page_menu -->
Prepends a page to `self`, specifying the widget to use as the
label in the popup menu.
## `child`
the `Widget` to use as the contents of the page
## `tab_label`
the `Widget` to be used as the label
 for the page, or `None` to use the default label, “page N”
## `menu_label`
the widget to use as a label for the
 page-switch menu, if that is enabled. If `None`, and `tab_label`
 is a `Label` or `None`, then the menu label will be a newly
 created label with the same text as `tab_label`; if `tab_label`
 is not a `Label`, `menu_label` must be specified if the
 page-switch menu is to be used.

# Returns

the index (starting from 0) of the prepended
 page in the notebook, or -1 if function fails
<!-- trait NotebookExt::fn prev_page -->
Switches to the previous page. Nothing happens if the current page
is the first page.
<!-- trait NotebookExt::fn remove_page -->
Removes a page from the notebook given its index
in the notebook.
## `page_num`
the index of a notebook page, starting
 from 0. If -1, the last page will be removed.
<!-- trait NotebookExt::fn reorder_child -->
Reorders the page containing `child`, so that it appears in position
`position`. If `position` is greater than or equal to the number of
children in the list or negative, `child` will be moved to the end
of the list.
## `child`
the child to move
## `position`
the new position, or -1 to move to the end
<!-- trait NotebookExt::fn set_action_widget -->
Sets `widget` as one of the action widgets. Depending on the pack type
the widget will be placed before or after the tabs. You can use
a `Box` if you need to pack more than one widget on the same side.

Note that action widgets are “internal” children of the notebook and thus
not included in the list returned from `ContainerExt::foreach`.
## `widget`
a `Widget`
## `pack_type`
pack type of the action widget
<!-- trait NotebookExt::fn set_current_page -->
Switches to the page number `page_num`.

Note that due to historical reasons, `Notebook` refuses
to switch to a page unless the child widget is visible.
Therefore, it is recommended to show child widgets before
adding them to a notebook.
## `page_num`
index of the page to switch to, starting from 0.
 If negative, the last page will be used. If greater
 than the number of pages in the notebook, nothing
 will be done.
<!-- trait NotebookExt::fn set_group_name -->
Sets a group name for `self`.

Notebooks with the same name will be able to exchange tabs
via drag and drop. A notebook with a `None` group name will
not be able to exchange tabs with any other notebook.
## `group_name`
the name of the notebook group,
 or `None` to unset it
<!-- trait NotebookExt::fn set_menu_label -->
Changes the menu label for the page containing `child`.
## `child`
the child widget
## `menu_label`
the menu label, or `None` for default
<!-- trait NotebookExt::fn set_menu_label_text -->
Creates a new label and sets it as the menu label of `child`.
## `child`
the child widget
## `menu_text`
the label text
<!-- trait NotebookExt::fn set_scrollable -->
Sets whether the tab label area will have arrows for
scrolling if there are too many tabs to fit in the area.
## `scrollable`
`true` if scroll arrows should be added
<!-- trait NotebookExt::fn set_show_border -->
Sets whether a bevel will be drawn around the notebook pages.
This only has a visual effect when the tabs are not shown.
See `NotebookExt::set_show_tabs`.
## `show_border`
`true` if a bevel should be drawn around the notebook
<!-- trait NotebookExt::fn set_show_tabs -->
Sets whether to show the tabs for the notebook or not.
## `show_tabs`
`true` if the tabs should be shown
<!-- trait NotebookExt::fn set_tab_detachable -->
Sets whether the tab can be detached from `self` to another
notebook or widget.

Note that 2 notebooks must share a common group identificator
(see `NotebookExt::set_group_name`) to allow automatic tabs
interchange between them.

If you want a widget to interact with a notebook through DnD
(i.e.: accept dragged tabs from it) it must be set as a drop
destination and accept the target “GTK_NOTEBOOK_TAB”. The notebook
will fill the selection with a `Widget`** pointing to the child
widget that corresponds to the dropped tab.

Note that you should use `NotebookExt::detach_tab` instead
of `ContainerExt::remove` if you want to remove the tab from
the source notebook as part of accepting a drop. Otherwise,
the source notebook will think that the dragged tab was
removed from underneath the ongoing drag operation, and
will initiate a drag cancel animation.


```C
 static void
 on_drag_data_received (GtkWidget        *widget,
                        GdkDragContext   *context,
                        gint              x,
                        gint              y,
                        GtkSelectionData *data,
                        guint             info,
                        guint             time,
                        gpointer          user_data)
 {
   GtkWidget *notebook;
   GtkWidget **child;

   notebook = gtk_drag_get_source_widget (context);
   child = (void*) gtk_selection_data_get_data (data);

   process_widget (*child);
   gtk_notebook_detach_tab (GTK_NOTEBOOK (notebook), *child);
 }
```

If you want a notebook to accept drags from other widgets,
you will have to set your own DnD code to do it.
## `child`
a child `Widget`
## `detachable`
whether the tab is detachable or not
<!-- trait NotebookExt::fn set_tab_label -->
Changes the tab label for `child`.
If `None` is specified for `tab_label`, then the page will
have the label “page N”.
## `child`
the page
## `tab_label`
the tab label widget to use, or `None`
 for default tab label
<!-- trait NotebookExt::fn set_tab_label_text -->
Creates a new label and sets it as the tab label for the page
containing `child`.
## `child`
the page
## `tab_text`
the label text
<!-- trait NotebookExt::fn set_tab_pos -->
Sets the edge at which the tabs for switching pages in the
notebook are drawn.
## `pos`
the edge to draw the tabs at
<!-- trait NotebookExt::fn set_tab_reorderable -->
Sets whether the notebook tab can be reordered
via drag and drop or not.
## `child`
a child `Widget`
## `reorderable`
whether the tab is reorderable or not
<!-- trait NotebookExt::fn connect_create_window -->
The ::create-window signal is emitted when a detachable
tab is dropped on the root window.

A handler for this signal can create a window containing
a notebook where the tab will be attached. It is also
responsible for moving/resizing the window and adding the
necessary properties to the notebook (e.g. the
`Notebook:group-name` ).
## `page`
the tab of `notebook` that is being detached
## `x`
the X coordinate where the drop happens
## `y`
the Y coordinate where the drop happens

# Returns

a `Notebook` that `page` should be
 added to, or `None`.
<!-- trait NotebookExt::fn connect_page_added -->
the ::page-added signal is emitted in the notebook
right after a page is added to the notebook.
## `child`
the child `Widget` affected
## `page_num`
the new page number for `child`
<!-- trait NotebookExt::fn connect_page_removed -->
the ::page-removed signal is emitted in the notebook
right after a page is removed from the notebook.
## `child`
the child `Widget` affected
## `page_num`
the `child` page number
<!-- trait NotebookExt::fn connect_page_reordered -->
the ::page-reordered signal is emitted in the notebook
right after a page has been reordered.
## `child`
the child `Widget` affected
## `page_num`
the new page number for `child`
<!-- trait NotebookExt::fn connect_switch_page -->
Emitted when the user or a function changes the current page.
## `page`
the new current page
## `page_num`
the index of the page
<!-- trait NotebookExt::fn get_property_group-name -->
Group name for tab drag and drop.
<!-- trait NotebookExt::fn set_property_group-name -->
Group name for tab drag and drop.
<!-- enum NotebookTab -->
<!-- enum NumberUpLayout -->
Used to determine the layout of pages on a sheet when printing
multiple pages per sheet.
<!-- enum NumberUpLayout::variant Lrtb -->
![](layout-lrtb.png)
<!-- enum NumberUpLayout::variant Lrbt -->
![](layout-lrbt.png)
<!-- enum NumberUpLayout::variant Rltb -->
![](layout-rltb.png)
<!-- enum NumberUpLayout::variant Rlbt -->
![](layout-rlbt.png)
<!-- enum NumberUpLayout::variant Tblr -->
![](layout-tblr.png)
<!-- enum NumberUpLayout::variant Tbrl -->
![](layout-tbrl.png)
<!-- enum NumberUpLayout::variant Btlr -->
![](layout-btlr.png)
<!-- enum NumberUpLayout::variant Btrl -->
![](layout-btrl.png)
<!-- struct Orientable -->
The `Orientable` interface is implemented by all widgets that can be
oriented horizontally or vertically. Historically, such widgets have been
realized as subclasses of a common base class (e.g `Box`/`HBox`/`VBox`
or `Scale`/`HScale`/`VScale`). `Orientable` is more flexible in that
it allows the orientation to be changed at runtime, allowing the widgets
to “flip”.

`Orientable` was introduced in GTK+ 2.16.

# Implements

[`OrientableExt`](trait.OrientableExt.html)
<!-- trait OrientableExt -->
Trait containing all `Orientable` methods.

# Implementors

[`AppChooserWidget`](struct.AppChooserWidget.html), [`Box`](struct.Box.html), [`ButtonBox`](struct.ButtonBox.html), [`CellAreaBox`](struct.CellAreaBox.html), [`CellRendererProgress`](struct.CellRendererProgress.html), [`ColorChooserWidget`](struct.ColorChooserWidget.html), [`FileChooserButton`](struct.FileChooserButton.html), [`FileChooserWidget`](struct.FileChooserWidget.html), [`FlowBox`](struct.FlowBox.html), [`FontChooserWidget`](struct.FontChooserWidget.html), [`Grid`](struct.Grid.html), [`InfoBar`](struct.InfoBar.html), [`LevelBar`](struct.LevelBar.html), [`Orientable`](struct.Orientable.html), [`Paned`](struct.Paned.html), [`ProgressBar`](struct.ProgressBar.html), [`Range`](struct.Range.html), [`RecentChooserWidget`](struct.RecentChooserWidget.html), [`ScaleButton`](struct.ScaleButton.html), [`Scale`](struct.Scale.html), [`Scrollbar`](struct.Scrollbar.html), [`Separator`](struct.Separator.html), [`SpinButton`](struct.SpinButton.html), [`StackSwitcher`](struct.StackSwitcher.html), [`Statusbar`](struct.Statusbar.html), [`ToolPalette`](struct.ToolPalette.html), [`Toolbar`](struct.Toolbar.html), [`VolumeButton`](struct.VolumeButton.html)
<!-- trait OrientableExt::fn get_orientation -->
Retrieves the orientation of the `self`.

# Returns

the orientation of the `self`.
<!-- trait OrientableExt::fn set_orientation -->
Sets the orientation of the `self`.
## `orientation`
the orientable’s new orientation.
<!-- trait OrientableExt::fn get_property_orientation -->
The orientation of the orientable.
<!-- trait OrientableExt::fn set_property_orientation -->
The orientation of the orientable.
<!-- enum Orientation -->
Represents the orientation of widgets and other objects which can be switched
between horizontal and vertical orientation on the fly, like `Toolbar` or
`GesturePan`.
<!-- enum Orientation::variant Horizontal -->
The element is in horizontal orientation.
<!-- enum Orientation::variant Vertical -->
The element is in vertical orientation.
<!-- struct Overlay -->
`Overlay` is a container which contains a single main child, on top
of which it can place “overlay” widgets. The position of each overlay
widget is determined by its `Widget:halign` and `Widget:valign`
properties. E.g. a widget with both alignments set to `Align::Start`
will be placed at the top left corner of the `Overlay` container,
whereas an overlay with halign set to `Align::Center` and valign set
to `Align::End` will be placed a the bottom edge of the `Overlay`,
horizontally centered. The position can be adjusted by setting the margin
properties of the child to non-zero values.

More complicated placement of overlays is possible by connecting
to the `Overlay::get-child-position` signal.

# `Overlay` as `Buildable`

The `Overlay` implementation of the `Buildable` interface
supports placing a child as an overlay by specifying “overlay” as
the “type” attribute of a `<child>` element.

# Implements

[`OverlayExt`](trait.OverlayExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait OverlayExt -->
Trait containing all `Overlay` methods.

# Implementors

[`Overlay`](struct.Overlay.html)
<!-- impl Overlay::fn new -->
Creates a new `Overlay`.

# Returns

a new `Overlay` object.
<!-- trait OverlayExt::fn add_overlay -->
Adds `widget` to `self`.

The widget will be stacked on top of the main widget
added with `ContainerExt::add`.

The position at which `widget` is placed is determined
from its `Widget:halign` and `Widget:valign` properties.
## `widget`
a `Widget` to be added to the container
<!-- trait OverlayExt::fn get_overlay_pass_through -->
Convenience function to get the value of the `Overlay:pass-through`
child property for `widget`.

Feature: `v3_18`

## `widget`
an overlay child of `Overlay`

# Returns

whether the widget is a pass through child.
<!-- trait OverlayExt::fn reorder_overlay -->
Moves `child` to a new `index` in the list of `self` children.
The list contains overlays in the order that these were
added to `self`.

A widget’s index in the `self` children list determines which order
the children are drawn if they overlap. The first child is drawn at
the bottom. It also affects the default focus chain order.

Feature: `v3_18`

## `child`
the overlaid `Widget` to move
## `position`
the new index for `child` in the list of overlay children
 of `self`, starting from 0. If negative, indicates the end of
 the list
<!-- trait OverlayExt::fn set_overlay_pass_through -->
Convenience function to set the value of the `Overlay:pass-through`
child property for `widget`.

Feature: `v3_18`

## `widget`
an overlay child of `Overlay`
## `pass_through`
whether the child should pass the input through
<!-- trait OverlayExt::fn connect_get_child_position -->
The ::get-child-position signal is emitted to determine
the position and size of any overlay child widgets. A
handler for this signal should fill `allocation` with
the desired position and size for `widget`, relative to
the 'main' child of `overlay`.

The default handler for this signal uses the `widget`'s
halign and valign properties to determine the position
and gives the widget its natural size (except that an
alignment of `Align::Fill` will cause the overlay to
be full-width/height). If the main child is a
`ScrolledWindow`, the overlays are placed relative
to its contents.
## `widget`
the child widget to position
## `allocation`
return
 location for the allocation

# Returns

`true` if the `allocation` has been filled
<!-- enum PackDirection -->
Determines how widgets should be packed inside menubars
and menuitems contained in menubars.
<!-- enum PackDirection::variant Ltr -->
Widgets are packed left-to-right
<!-- enum PackDirection::variant Rtl -->
Widgets are packed right-to-left
<!-- enum PackDirection::variant Ttb -->
Widgets are packed top-to-bottom
<!-- enum PackDirection::variant Btt -->
Widgets are packed bottom-to-top
<!-- enum PackType -->
Represents the packing location `Box` children. (See: `VBox`,
`HBox`, and `ButtonBox`).
<!-- enum PackType::variant Start -->
The child is packed into the start of the box
<!-- enum PackType::variant End -->
The child is packed into the end of the box
<!-- enum PageOrientation -->
See also `PrintSettingsExt::set_orientation`.
<!-- enum PageOrientation::variant Portrait -->
Portrait mode.
<!-- enum PageOrientation::variant Landscape -->
Landscape mode.
<!-- enum PageOrientation::variant ReversePortrait -->
Reverse portrait mode.
<!-- enum PageOrientation::variant ReverseLandscape -->
Reverse landscape mode.
<!-- enum PageSet -->
See also `gtk_print_job_set_page_set`.
<!-- enum PageSet::variant All -->
All pages.
<!-- enum PageSet::variant Even -->
Even pages.
<!-- enum PageSet::variant Odd -->
Odd pages.
<!-- struct PageSetup -->
A `PageSetup` object stores the page size, orientation and margins.
The idea is that you can get one of these from the page setup dialog
and then pass it to the `PrintOperation` when printing.
The benefit of splitting this out of the `PrintSettings` is that
these affect the actual layout of the page, and thus need to be set
long before user prints.

## Margins ## {`print`-margins}
The margins specified in this object are the “print margins”, i.e. the
parts of the page that the printer cannot print on. These are different
from the layout margins that a word processor uses; they are typically
used to determine the minimal size for the layout
margins.

To obtain a `PageSetup` use `PageSetup::new` to get the defaults,
or use `gtk_print_run_page_setup_dialog` to show the page setup dialog
and receive the resulting page setup.

## A page setup dialog


```C
static GtkPrintSettings *settings = NULL;
static GtkPageSetup *page_setup = NULL;

static void
do_page_setup (void)
{
  GtkPageSetup *new_page_setup;

  if (settings == NULL)
    settings = gtk_print_settings_new ();

  new_page_setup = gtk_print_run_page_setup_dialog (GTK_WINDOW (main_window),
                                                    page_setup, settings);

  if (page_setup)
    g_object_unref (page_setup);

  page_setup = new_page_setup;
}
```

Printing support was added in GTK+ 2.10.

# Implements

[`PageSetupExt`](trait.PageSetupExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html)
<!-- trait PageSetupExt -->
Trait containing all `PageSetup` methods.

# Implementors

[`PageSetup`](struct.PageSetup.html)
<!-- impl PageSetup::fn new -->
Creates a new `PageSetup`.

# Returns

a new `PageSetup`.
<!-- impl PageSetup::fn new_from_file -->
Reads the page setup from the file `file_name`. Returns a
new `PageSetup` object with the restored page setup,
or `None` if an error occurred. See `PageSetupExt::to_file`.
## `file_name`
the filename to read the page setup from

# Returns

the restored `PageSetup`
<!-- impl PageSetup::fn new_from_gvariant -->
Desrialize a page setup from an a{sv} variant in
the format produced by `PageSetupExt::to_gvariant`.

Feature: `v3_22`

## `variant`
an a{sv} `glib::Variant`

# Returns

a new `PageSetup` object
<!-- impl PageSetup::fn new_from_key_file -->
Reads the page setup from the group `group_name` in the key file
`key_file`. Returns a new `PageSetup` object with the restored
page setup, or `None` if an error occurred.
## `key_file`
the `glib::KeyFile` to retrieve the page_setup from
## `group_name`
the name of the group in the key_file to read, or `None`
 to use the default name “Page Setup”

# Returns

the restored `PageSetup`
<!-- trait PageSetupExt::fn copy -->
Copies a `PageSetup`.

# Returns

a copy of `self`
<!-- trait PageSetupExt::fn get_bottom_margin -->
Gets the bottom margin in units of `unit`.
## `unit`
the unit for the return value

# Returns

the bottom margin
<!-- trait PageSetupExt::fn get_left_margin -->
Gets the left margin in units of `unit`.
## `unit`
the unit for the return value

# Returns

the left margin
<!-- trait PageSetupExt::fn get_orientation -->
Gets the page orientation of the `PageSetup`.

# Returns

the page orientation
<!-- trait PageSetupExt::fn get_page_height -->
Returns the page height in units of `unit`.

Note that this function takes orientation and
margins into consideration.
See `PageSetupExt::get_paper_height`.
## `unit`
the unit for the return value

# Returns

the page height.
<!-- trait PageSetupExt::fn get_page_width -->
Returns the page width in units of `unit`.

Note that this function takes orientation and
margins into consideration.
See `PageSetupExt::get_paper_width`.
## `unit`
the unit for the return value

# Returns

the page width.
<!-- trait PageSetupExt::fn get_paper_height -->
Returns the paper height in units of `unit`.

Note that this function takes orientation, but
not margins into consideration.
See `PageSetupExt::get_page_height`.
## `unit`
the unit for the return value

# Returns

the paper height.
<!-- trait PageSetupExt::fn get_paper_size -->
Gets the paper size of the `PageSetup`.

# Returns

the paper size
<!-- trait PageSetupExt::fn get_paper_width -->
Returns the paper width in units of `unit`.

Note that this function takes orientation, but
not margins into consideration.
See `PageSetupExt::get_page_width`.
## `unit`
the unit for the return value

# Returns

the paper width.
<!-- trait PageSetupExt::fn get_right_margin -->
Gets the right margin in units of `unit`.
## `unit`
the unit for the return value

# Returns

the right margin
<!-- trait PageSetupExt::fn get_top_margin -->
Gets the top margin in units of `unit`.
## `unit`
the unit for the return value

# Returns

the top margin
<!-- trait PageSetupExt::fn load_file -->
Reads the page setup from the file `file_name`.
See `PageSetupExt::to_file`.
## `file_name`
the filename to read the page setup from

# Returns

`true` on success
<!-- trait PageSetupExt::fn load_key_file -->
Reads the page setup from the group `group_name` in the key file
`key_file`.
## `key_file`
the `glib::KeyFile` to retrieve the page_setup from
## `group_name`
the name of the group in the key_file to read, or `None`
 to use the default name “Page Setup”

# Returns

`true` on success
<!-- trait PageSetupExt::fn set_bottom_margin -->
Sets the bottom margin of the `PageSetup`.
## `margin`
the new bottom margin in units of `unit`
## `unit`
the units for `margin`
<!-- trait PageSetupExt::fn set_left_margin -->
Sets the left margin of the `PageSetup`.
## `margin`
the new left margin in units of `unit`
## `unit`
the units for `margin`
<!-- trait PageSetupExt::fn set_orientation -->
Sets the page orientation of the `PageSetup`.
## `orientation`
a `PageOrientation` value
<!-- trait PageSetupExt::fn set_paper_size -->
Sets the paper size of the `PageSetup` without
changing the margins. See
`PageSetupExt::set_paper_size_and_default_margins`.
## `size`
a `PaperSize`
<!-- trait PageSetupExt::fn set_paper_size_and_default_margins -->
Sets the paper size of the `PageSetup` and modifies
the margins according to the new paper size.
## `size`
a `PaperSize`
<!-- trait PageSetupExt::fn set_right_margin -->
Sets the right margin of the `PageSetup`.
## `margin`
the new right margin in units of `unit`
## `unit`
the units for `margin`
<!-- trait PageSetupExt::fn set_top_margin -->
Sets the top margin of the `PageSetup`.
## `margin`
the new top margin in units of `unit`
## `unit`
the units for `margin`
<!-- trait PageSetupExt::fn to_file -->
This function saves the information from `self` to `file_name`.
## `file_name`
the file to save to

# Returns

`true` on success
<!-- trait PageSetupExt::fn to_gvariant -->
Serialize page setup to an a{sv} variant.

Feature: `v3_22`


# Returns

a new, floating, `glib::Variant`
<!-- trait PageSetupExt::fn to_key_file -->
This function adds the page setup from `self` to `key_file`.
## `key_file`
the `glib::KeyFile` to save the page setup to
## `group_name`
the group to add the settings to in `key_file`,
 or `None` to use the default name “Page Setup”
<!-- enum PanDirection -->
Describes the panning direction of a `GesturePan`
<!-- enum PanDirection::variant Left -->
panned towards the left
<!-- enum PanDirection::variant Right -->
panned towards the right
<!-- enum PanDirection::variant Up -->
panned upwards
<!-- enum PanDirection::variant Down -->
panned downwards

Feature: `v3_14`

<!-- struct Paned -->
`Paned` has two panes, arranged either
horizontally or vertically. The division between
the two panes is adjustable by the user by dragging
a handle.

Child widgets are
added to the panes of the widget with `PanedExt::pack1` and
`PanedExt::pack2`. The division between the two children is set by default
from the size requests of the children, but it can be adjusted by the
user.

A paned widget draws a separator between the two child widgets and a
small handle that the user can drag to adjust the division. It does not
draw any relief around the children or around the separator. (The space
in which the separator is called the gutter.) Often, it is useful to put
each child inside a `Frame` with the shadow type set to `ShadowType::In`
so that the gutter appears as a ridge. No separator is drawn if one of
the children is missing.

Each child has two options that can be set, `resize` and `shrink`. If
`resize` is true, then when the `Paned` is resized, that child will
expand or shrink along with the paned widget. If `shrink` is true, then
that child can be made smaller than its requisition by the user.
Setting `shrink` to `false` allows the application to set a minimum size.
If `resize` is false for both children, then this is treated as if
`resize` is true for both children.

The application can set the position of the slider as if it were set
by the user, by calling `PanedExt::set_position`.

# CSS nodes


```plain
paned
├── <child>
├── separator[.wide]
╰── <child>
```

`Paned` has a main CSS node with name paned, and a subnode for
the separator with name separator. The subnode gets a .wide style
class when the paned is supposed to be wide.

In horizontal orientation, the nodes of the children are always arranged
from left to right. So :first-child will always select the leftmost child,
regardless of text direction.

## Creating a paned widget with minimum sizes.


```C
GtkWidget *hpaned = gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
GtkWidget *frame1 = gtk_frame_new (NULL);
GtkWidget *frame2 = gtk_frame_new (NULL);
gtk_frame_set_shadow_type (GTK_FRAME (frame1), GTK_SHADOW_IN);
gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_IN);

gtk_widget_set_size_request (hpaned, 200, -1);

gtk_paned_pack1 (GTK_PANED (hpaned), frame1, TRUE, FALSE);
gtk_widget_set_size_request (frame1, 50, -1);

gtk_paned_pack2 (GTK_PANED (hpaned), frame2, FALSE, FALSE);
gtk_widget_set_size_request (frame2, 50, -1);
```

# Implements

[`PanedExt`](trait.PanedExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html), [`OrientableExt`](trait.OrientableExt.html)
<!-- trait PanedExt -->
Trait containing all `Paned` methods.

# Implementors

[`Paned`](struct.Paned.html)
<!-- impl Paned::fn new -->
Creates a new `Paned` widget.
## `orientation`
the paned’s orientation.

# Returns

a new `Paned`.
<!-- trait PanedExt::fn add1 -->
Adds a child to the top or left pane with default parameters. This is
equivalent to
`gtk_paned_pack1 (paned, child, FALSE, TRUE)`.
## `child`
the child to add
<!-- trait PanedExt::fn add2 -->
Adds a child to the bottom or right pane with default parameters. This
is equivalent to
`gtk_paned_pack2 (paned, child, TRUE, TRUE)`.
## `child`
the child to add
<!-- trait PanedExt::fn get_child1 -->
Obtains the first child of the paned widget.

# Returns

first child, or `None` if it is not set.
<!-- trait PanedExt::fn get_child2 -->
Obtains the second child of the paned widget.

# Returns

second child, or `None` if it is not set.
<!-- trait PanedExt::fn get_handle_window -->
Returns the `gdk::Window` of the handle. This function is
useful when handling button or motion events because it
enables the callback to distinguish between the window
of the paned, a child and the handle.

# Returns

the paned’s handle window.
<!-- trait PanedExt::fn get_position -->
Obtains the position of the divider between the two panes.

# Returns

position of the divider
<!-- trait PanedExt::fn get_wide_handle -->
Gets the `Paned:wide-handle` property.

Feature: `v3_16`


# Returns

`true` if the paned should have a wide handle
<!-- trait PanedExt::fn pack1 -->
Adds a child to the top or left pane.
## `child`
the child to add
## `resize`
should this child expand when the paned widget is resized.
## `shrink`
can this child be made smaller than its requisition.
<!-- trait PanedExt::fn pack2 -->
Adds a child to the bottom or right pane.
## `child`
the child to add
## `resize`
should this child expand when the paned widget is resized.
## `shrink`
can this child be made smaller than its requisition.
<!-- trait PanedExt::fn set_position -->
Sets the position of the divider between the two panes.
## `position`
pixel position of divider, a negative value means that the position
 is unset.
<!-- trait PanedExt::fn set_wide_handle -->
Sets the `Paned:wide-handle` property.

Feature: `v3_16`

## `wide`
the new value for the `Paned:wide-handle` property
<!-- trait PanedExt::fn connect_accept_position -->
The ::accept-position signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to accept the current position of the handle when
moving it using key bindings.

The default binding for this signal is Return or Space.
<!-- trait PanedExt::fn connect_cancel_position -->
The ::cancel-position signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to cancel moving the position of the handle using key
bindings. The position of the handle will be reset to the value prior to
moving it.

The default binding for this signal is Escape.
<!-- trait PanedExt::fn connect_cycle_child_focus -->
The ::cycle-child-focus signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to cycle the focus between the children of the paned.

The default binding is f6.
## `reversed`
whether cycling backward or forward
<!-- trait PanedExt::fn connect_cycle_handle_focus -->
The ::cycle-handle-focus signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to cycle whether the paned should grab focus to allow
the user to change position of the handle by using key bindings.

The default binding for this signal is f8.
## `reversed`
whether cycling backward or forward
<!-- trait PanedExt::fn connect_move_handle -->
The ::move-handle signal is a
[keybinding signal][`BindingSignal`]
which gets emitted to move the handle when the user is using key bindings
to move it.
## `scroll_type`
a `ScrollType`
<!-- trait PanedExt::fn connect_toggle_handle_focus -->
The ::toggle-handle-focus is a
[keybinding signal][`BindingSignal`]
which gets emitted to accept the current position of the handle and then
move focus to the next widget in the focus chain.

The default binding is Tab.
<!-- trait PanedExt::fn get_property_max-position -->
The largest possible value for the position property.
This property is derived from the size and shrinkability
of the widget's children.
<!-- trait PanedExt::fn get_property_min-position -->
The smallest possible value for the position property.
This property is derived from the size and shrinkability
of the widget's children.
<!-- trait PanedExt::fn get_property_wide-handle -->
Setting this property to `true` indicates that the paned needs
to provide stronger visual separation (e.g. because it separates
between two notebooks, whose tab rows would otherwise merge visually).

Feature: `v3_16`

<!-- trait PanedExt::fn set_property_wide-handle -->
Setting this property to `true` indicates that the paned needs
to provide stronger visual separation (e.g. because it separates
between two notebooks, whose tab rows would otherwise merge visually).

Feature: `v3_16`

<!-- struct PaperSize -->
`PaperSize` handles paper sizes. It uses the standard called
[PWG 5101.1-2002 PWG: Standard for Media Standardized Names](http://www.pwg.org/standards.html)
to name the paper sizes (and to get the data for the page sizes).
In addition to standard paper sizes, `PaperSize` allows to
construct custom paper sizes with arbitrary dimensions.

The `PaperSize` object stores not only the dimensions (width
and height) of a paper size and its name, it also provides
default [print margins][print-margins].

Printing support has been added in GTK+ 2.10.
<!-- impl PaperSize::fn new -->
Creates a new `PaperSize` object by parsing a
[PWG 5101.1-2002](ftp://ftp.pwg.org/pub/pwg/candidates/cs-pwgmsn10-20020226-5101.1.pdf)
paper name.

If `name` is `None`, the default paper size is returned,
see `PaperSize::get_default`.
## `name`
a paper size name, or `None`

# Returns

a new `PaperSize`, use `PaperSize::free`
to free it
<!-- impl PaperSize::fn new_custom -->
Creates a new `PaperSize` object with the
given parameters.
## `name`
the paper name
## `display_name`
the human-readable name
## `width`
the paper width, in units of `unit`
## `height`
the paper height, in units of `unit`
## `unit`
the unit for `width` and `height`. not `Unit::None`.

# Returns

a new `PaperSize` object, use `PaperSize::free`
to free it
<!-- impl PaperSize::fn new_from_gvariant -->
Deserialize a paper size from an a{sv} variant in
the format produced by `PaperSize::to_gvariant`.

Feature: `v3_22`

## `variant`
an a{sv} `glib::Variant`

# Returns

a new `PaperSize` object
<!-- impl PaperSize::fn new_from_ipp -->
Creates a new `PaperSize` object by using
IPP information.

If `ipp_name` is not a recognized paper name,
`width` and `height` are used to
construct a custom `PaperSize` object.

Feature: `v3_16`

## `ipp_name`
an IPP paper name
## `width`
the paper width, in points
## `height`
the paper height in points

# Returns

a new `PaperSize`, use `PaperSize::free`
to free it
<!-- impl PaperSize::fn new_from_key_file -->
Reads a paper size from the group `group_name` in the key file
`key_file`.
## `key_file`
the `glib::KeyFile` to retrieve the papersize from
## `group_name`
the name ofthe group in the key file to read,
 or `None` to read the first group

# Returns

a new `PaperSize` object with the restored
 paper size, or `None` if an error occurred
<!-- impl PaperSize::fn new_from_ppd -->
Creates a new `PaperSize` object by using
PPD information.

If `ppd_name` is not a recognized PPD paper name,
`ppd_display_name`, `width` and `height` are used to
construct a custom `PaperSize` object.
## `ppd_name`
a PPD paper name
## `ppd_display_name`
the corresponding human-readable name
## `width`
the paper width, in points
## `height`
the paper height in points

# Returns

a new `PaperSize`, use `PaperSize::free`
to free it
<!-- impl PaperSize::fn copy -->
Copies an existing `PaperSize`.

# Returns

a copy of `self`
<!-- impl PaperSize::fn free -->
Free the given `PaperSize` object.
<!-- impl PaperSize::fn get_default_bottom_margin -->
Gets the default bottom margin for the `PaperSize`.
## `unit`
the unit for the return value, not `Unit::None`

# Returns

the default bottom margin
<!-- impl PaperSize::fn get_default_left_margin -->
Gets the default left margin for the `PaperSize`.
## `unit`
the unit for the return value, not `Unit::None`

# Returns

the default left margin
<!-- impl PaperSize::fn get_default_right_margin -->
Gets the default right margin for the `PaperSize`.
## `unit`
the unit for the return value, not `Unit::None`

# Returns

the default right margin
<!-- impl PaperSize::fn get_default_top_margin -->
Gets the default top margin for the `PaperSize`.
## `unit`
the unit for the return value, not `Unit::None`

# Returns

the default top margin
<!-- impl PaperSize::fn get_display_name -->
Gets the human-readable name of the `PaperSize`.

# Returns

the human-readable name of `self`
<!-- impl PaperSize::fn get_height -->
Gets the paper height of the `PaperSize`, in
units of `unit`.
## `unit`
the unit for the return value, not `Unit::None`

# Returns

the paper height
<!-- impl PaperSize::fn get_name -->
Gets the name of the `PaperSize`.

# Returns

the name of `self`
<!-- impl PaperSize::fn get_ppd_name -->
Gets the PPD name of the `PaperSize`, which
may be `None`.

# Returns

the PPD name of `self`
<!-- impl PaperSize::fn get_width -->
Gets the paper width of the `PaperSize`, in
units of `unit`.
## `unit`
the unit for the return value, not `Unit::None`

# Returns

the paper width
<!-- impl PaperSize::fn is_custom -->
Returns `true` if `self` is not a standard paper size.

# Returns

whether `self` is a custom paper size.
<!-- impl PaperSize::fn is_equal -->
Compares two `PaperSize` objects.
## `size2`
another `PaperSize` object

# Returns

`true`, if `self` and `size2`
represent the same paper size
<!-- impl PaperSize::fn is_ipp -->
Returns `true` if `self` is an IPP standard paper size.

# Returns

whether `self` is not an IPP custom paper size.
<!-- impl PaperSize::fn set_size -->
Changes the dimensions of a `self` to `width` x `height`.
## `width`
the new width in units of `unit`
## `height`
the new height in units of `unit`
## `unit`
the unit for `width` and `height`
<!-- impl PaperSize::fn to_gvariant -->
Serialize a paper size to an a{sv} variant.

Feature: `v3_22`


# Returns

a new, floating, `glib::Variant`
<!-- impl PaperSize::fn to_key_file -->
This function adds the paper size from `self` to `key_file`.
## `key_file`
the `glib::KeyFile` to save the paper size to
## `group_name`
the group to add the settings to in `key_file`
<!-- impl PaperSize::fn get_default -->
Returns the name of the default paper size, which
depends on the current locale.

# Returns

the name of the default paper size. The string
is owned by GTK+ and should not be modified.
<!-- impl PaperSize::fn get_paper_sizes -->
Creates a list of known paper sizes.
## `include_custom`
whether to include custom paper sizes
 as defined in the page setup dialog

# Returns

a newly allocated list of newly
 allocated `PaperSize` objects
<!-- struct PlacesSidebar -->
`PlacesSidebar` is a widget that displays a list of frequently-used places in the
file system: the user’s home directory, the user’s bookmarks, and volumes and drives.
This widget is used as a sidebar in `FileChooser` and may be used by file managers
and similar programs.

The places sidebar displays drives and volumes, and will automatically mount
or unmount them when the user selects them.

Applications can hook to various signals in the places sidebar to customize
its behavior. For example, they can add extra commands to the context menu
of the sidebar.

While bookmarks are completely in control of the user, the places sidebar also
allows individual applications to provide extra shortcut folders that are unique
to each application. For example, a Paint program may want to add a shortcut
for a Clipart folder. You can do this with `PlacesSidebarExt::add_shortcut`.

To make use of the places sidebar, an application at least needs to connect
to the `PlacesSidebar::open-location` signal. This is emitted when the
user selects in the sidebar a location to open. The application should also
call `PlacesSidebarExt::set_location` when it changes the currently-viewed
location.

# CSS nodes

`PlacesSidebar` uses a single CSS node with name placessidebar and style
class .sidebar.

Among the children of the places sidebar, the following style classes can
be used:
- .sidebar-new-bookmark-row for the 'Add new bookmark' row
- .sidebar-placeholder-row for a row that is a placeholder
- .has-open-popup when a popup is open for a row

# Implements

[`PlacesSidebarExt`](trait.PlacesSidebarExt.html), [`ScrolledWindowExt`](trait.ScrolledWindowExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait PlacesSidebarExt -->
Trait containing all `PlacesSidebar` methods.

# Implementors

[`PlacesSidebar`](struct.PlacesSidebar.html)
<!-- impl PlacesSidebar::fn new -->
Creates a new `PlacesSidebar` widget.

The application should connect to at least the
`PlacesSidebar::open-location` signal to be notified
when the user makes a selection in the sidebar.

Feature: `v3_10`


# Returns

a newly created `PlacesSidebar`
<!-- trait PlacesSidebarExt::fn add_shortcut -->
Applications may want to present some folders in the places sidebar if
they could be immediately useful to users. For example, a drawing
program could add a “/usr/share/clipart” location when the sidebar is
being used in an “Insert Clipart” dialog box.

This function adds the specified `location` to a special place for immutable
shortcuts. The shortcuts are application-specific; they are not shared
across applications, and they are not persistent. If this function
is called multiple times with different locations, then they are added
to the sidebar’s list in the same order as the function is called.

Feature: `v3_10`

## `location`
location to add as an application-specific shortcut
<!-- trait PlacesSidebarExt::fn get_local_only -->
Returns the value previously set with `PlacesSidebarExt::set_local_only`.

Feature: `v3_12`


# Returns

`true` if the sidebar will only show local files.
<!-- trait PlacesSidebarExt::fn get_location -->
Gets the currently-selected location in the `self`. This can be `None` when
nothing is selected, for example, when `PlacesSidebarExt::set_location` has
been called with a location that is not among the sidebar’s list of places to
show.

You can use this function to get the selection in the `self`. Also, if you
connect to the `PlacesSidebar::populate-popup` signal, you can use this
function to get the location that is being referred to during the callbacks
for your menu items.

Feature: `v3_10`


# Returns

a GFile with the selected location, or
`None` if nothing is visually selected.
<!-- trait PlacesSidebarExt::fn get_nth_bookmark -->
This function queries the bookmarks added by the user to the places sidebar,
and returns one of them. This function is used by `FileChooser` to implement
the “Alt-1”, “Alt-2”, etc. shortcuts, which activate the cooresponding bookmark.

Feature: `v3_10`

## `n`
index of the bookmark to query

# Returns

The bookmark specified by the index `n`, or
`None` if no such index exist. Note that the indices start at 0, even though
the file chooser starts them with the keyboard shortcut "Alt-1".
<!-- trait PlacesSidebarExt::fn get_open_flags -->
Gets the open flags.

Feature: `v3_10`


# Returns

the `PlacesOpenFlags` of `self`
<!-- trait PlacesSidebarExt::fn get_show_connect_to_server -->
Returns the value previously set with `PlacesSidebarExt::set_show_connect_to_server`

# Deprecated since 3.18

It is recommended to group this functionality with the drives
 and network location under the new 'Other Location' item

# Returns

`true` if the sidebar will display a “Connect to Server” item.
<!-- trait PlacesSidebarExt::fn get_show_desktop -->
Returns the value previously set with `PlacesSidebarExt::set_show_desktop`

Feature: `v3_10`


# Returns

`true` if the sidebar will display a builtin shortcut to the desktop folder.
<!-- trait PlacesSidebarExt::fn get_show_enter_location -->
Returns the value previously set with `PlacesSidebarExt::set_show_enter_location`

Feature: `v3_14`


# Returns

`true` if the sidebar will display an “Enter Location” item.
<!-- trait PlacesSidebarExt::fn get_show_other_locations -->
Returns the value previously set with `PlacesSidebarExt::set_show_other_locations`

Feature: `v3_18`


# Returns

`true` if the sidebar will display an “Other Locations” item.
<!-- trait PlacesSidebarExt::fn get_show_recent -->
Returns the value previously set with `PlacesSidebarExt::set_show_recent`

Feature: `v3_18`


# Returns

`true` if the sidebar will display a builtin shortcut for recent files
<!-- trait PlacesSidebarExt::fn get_show_trash -->
Returns the value previously set with `PlacesSidebarExt::set_show_trash`

Feature: `v3_18`


# Returns

`true` if the sidebar will display a “Trash” item.
<!-- trait PlacesSidebarExt::fn list_shortcuts -->
Gets the list of shortcuts.

Feature: `v3_10`


# Returns


 A `glib::SList` of `gio::File` of the locations that have been added as
 application-specific shortcuts with `PlacesSidebarExt::add_shortcut`.
 To free this list, you can use

```C
g_slist_free_full (list, (GDestroyNotify) g_object_unref);
```
<!-- trait PlacesSidebarExt::fn remove_shortcut -->
Removes an application-specific shortcut that has been previously been
inserted with `PlacesSidebarExt::add_shortcut`. If the `location` is not a
shortcut in the sidebar, then nothing is done.

Feature: `v3_10`

## `location`
location to remove
<!-- trait PlacesSidebarExt::fn set_drop_targets_visible -->
Make the `PlacesSidebar` show drop targets, so it can show the available
drop targets and a "new bookmark" row. This improves the Drag-and-Drop
experience of the user and allows applications to show all available
drop targets at once.

This needs to be called when the application is aware of an ongoing drag
that might target the sidebar. The drop-targets-visible state will be unset
automatically if the drag finishes in the `PlacesSidebar`. You only need
to unset the state when the drag ends on some other widget on your application.

Feature: `v3_18`

## `visible`
whether to show the valid targets or not.
## `context`
drag context used to ask the source about the action that wants to
 perform, so hints are more accurate.
<!-- trait PlacesSidebarExt::fn set_local_only -->
Sets whether the `self` should only show local files.

Feature: `v3_12`

## `local_only`
whether to show only local files
<!-- trait PlacesSidebarExt::fn set_location -->
Sets the location that is being shown in the widgets surrounding the
`self`, for example, in a folder view in a file manager. In turn, the
`self` will highlight that location if it is being shown in the list of
places, or it will unhighlight everything if the `location` is not among the
places in the list.

Feature: `v3_10`

## `location`
location to select, or `None` for no current path
<!-- trait PlacesSidebarExt::fn set_open_flags -->
Sets the way in which the calling application can open new locations from
the places sidebar. For example, some applications only open locations
“directly” into their main view, while others may support opening locations
in a new notebook tab or a new window.

This function is used to tell the places `self` about the ways in which the
application can open new locations, so that the sidebar can display (or not)
the “Open in new tab” and “Open in new window” menu items as appropriate.

When the `PlacesSidebar::open-location` signal is emitted, its flags
argument will be set to one of the `flags` that was passed in
`PlacesSidebarExt::set_open_flags`.

Passing 0 for `flags` will cause `PlacesOpenFlags::Normal` to always be sent
to callbacks for the “open-location” signal.

Feature: `v3_10`

## `flags`
Bitmask of modes in which the calling application can open locations
<!-- trait PlacesSidebarExt::fn set_show_connect_to_server -->
Sets whether the `self` should show an item for connecting to a network server;
this is off by default. An application may want to turn this on if it implements
a way for the user to connect to network servers directly.

If you enable this, you should connect to the
`PlacesSidebar::show-connect-to-server` signal.

Feature: `v3_10`


# Deprecated since 3.18

It is recommended to group this functionality with the drives
 and network location under the new 'Other Location' item
## `show_connect_to_server`
whether to show an item for the Connect to Server command
<!-- trait PlacesSidebarExt::fn set_show_desktop -->
Sets whether the `self` should show an item for the Desktop folder.
The default value for this option is determined by the desktop
environment and the user’s configuration, but this function can be
used to override it on a per-application basis.

Feature: `v3_10`

## `show_desktop`
whether to show an item for the Desktop folder
<!-- trait PlacesSidebarExt::fn set_show_enter_location -->
Sets whether the `self` should show an item for entering a location;
this is off by default. An application may want to turn this on if manually
entering URLs is an expected user action.

If you enable this, you should connect to the
`PlacesSidebar::show-enter-location` signal.

Feature: `v3_14`

## `show_enter_location`
whether to show an item to enter a location
<!-- trait PlacesSidebarExt::fn set_show_other_locations -->
Sets whether the `self` should show an item for the application to show
an Other Locations view; this is off by default. When set to `true`, persistent
devices such as hard drives are hidden, otherwise they are shown in the sidebar.
An application may want to turn this on if it implements a way for the user to
see and interact with drives and network servers directly.

If you enable this, you should connect to the
`PlacesSidebar::show-other-locations` signal.

Feature: `v3_18`

## `show_other_locations`
whether to show an item for the Other Locations view
<!-- trait PlacesSidebarExt::fn set_show_recent -->
Sets whether the `self` should show an item for recent files.
The default value for this option is determined by the desktop
environment, but this function can be used to override it on a
per-application basis.

Feature: `v3_18`

## `show_recent`
whether to show an item for recent files
<!-- trait PlacesSidebarExt::fn set_show_trash -->
Sets whether the `self` should show an item for the Trash location.

Feature: `v3_18`

## `show_trash`
whether to show an item for the Trash location
<!-- trait PlacesSidebarExt::fn connect_drag_action_ask -->
The places sidebar emits this signal when it needs to ask the application
to pop up a menu to ask the user for which drag action to perform.

Feature: `v3_10`

## `actions`
Possible drag actions that need to be asked for.

# Returns

the final drag action that the sidebar should pass to the drag side
of the drag-and-drop operation.
<!-- trait PlacesSidebarExt::fn connect_drag_action_requested -->
When the user starts a drag-and-drop operation and the sidebar needs
to ask the application for which drag action to perform, then the
sidebar will emit this signal.

The application can evaluate the `context` for customary actions, or
it can check the type of the files indicated by `source_file_list` against the
possible actions for the destination `dest_file`.

The drag action to use must be the return value of the signal handler.

Feature: `v3_10`

## `context`
`gdk::DragContext` with information about the drag operation
## `dest_file`
`gio::File` with the tentative location that is being hovered for a drop
## `source_file_list`

 List of `gio::File` that are being dragged

# Returns

The drag action to use, for example, `gdk::DragAction::Copy`
or `gdk::DragAction::Move`, or 0 if no action is allowed here (i.e. drops
are not allowed in the specified `dest_file`).
<!-- trait PlacesSidebarExt::fn connect_drag_perform_drop -->
The places sidebar emits this signal when the user completes a
drag-and-drop operation and one of the sidebar's items is the
destination. This item is in the `dest_file`, and the
`source_file_list` has the list of files that are dropped into it and
which should be copied/moved/etc. based on the specified `action`.

Feature: `v3_10`

## `dest_file`
Destination `gio::File`.
## `source_file_list`

 `glib::List` of `gio::File` that got dropped.
## `action`
Drop action to perform.
<!-- trait PlacesSidebarExt::fn connect_mount -->
The places sidebar emits this signal when it starts a new operation
because the user clicked on some location that needs mounting.
In this way the application using the `PlacesSidebar` can track the
progress of the operation and, for example, show a notification.

Feature: `v3_20`

## `mount_operation`
the `gio::MountOperation` that is going to start.
<!-- trait PlacesSidebarExt::fn connect_open_location -->
The places sidebar emits this signal when the user selects a location
in it. The calling application should display the contents of that
location; for example, a file manager should show a list of files in
the specified location.

Feature: `v3_10`

## `location`
`gio::File` to which the caller should switch.
## `open_flags`
a single value from `PlacesOpenFlags` specifying how the `location` should be opened.
<!-- trait PlacesSidebarExt::fn connect_populate_popup -->
The places sidebar emits this signal when the user invokes a contextual
popup on one of its items. In the signal handler, the application may
add extra items to the menu as appropriate. For example, a file manager
may want to add a "Properties" command to the menu.

It is not necessary to store the `selected_item` for each menu item;
during their callbacks, the application can use `PlacesSidebarExt::get_location`
to get the file to which the item refers.

The `selected_item` argument may be `None` in case the selection refers to
a volume. In this case, `selected_volume` will be non-`None`. In this case,
the calling application will have to `gobject::ObjectExt::ref` the `selected_volume` and
keep it around to use it in the callback.

The `container` and all its contents are destroyed after the user
dismisses the popup. The popup is re-created (and thus, this signal is
emitted) every time the user activates the contextual menu.

Before 3.18, the `container` always was a `Menu`, and you were expected
to add your items as ``GtkMenuItems``. Since 3.18, the popup may be implemented
as a `Popover`, in which case `container` will be something else, e.g. a
`Box`, to which you may add ``GtkModelButtons`` or other widgets, such as
``GtkEntries``, ``GtkSpinButtons``, etc. If your application can deal with this
situation, you can set `PlacesSidebar::populate-all` to `true` to request
that this signal is emitted for populating popovers as well.

Feature: `v3_10`

## `container`
a `Menu` or another `Container`
## `selected_item`
`gio::File` with the item to which the popup should refer, or `None` in the case of a `selected_volume`.
## `selected_volume`
`gio::Volume` if the selected item is a volume, or `None` if it is a file.
<!-- trait PlacesSidebarExt::fn connect_show_connect_to_server -->
The places sidebar emits this signal when it needs the calling
application to present an way to connect directly to a network server.
For example, the application may bring up a dialog box asking for
a URL like "sftp://ftp.example.com". It is up to the application to create
the corresponding mount by using, for example, `gio::File::mount_enclosing_volume`.

# Deprecated since 3.18

use the `PlacesSidebar::show-other-locations` signal
 to connect to network servers.
<!-- trait PlacesSidebarExt::fn connect_show_enter_location -->
The places sidebar emits this signal when it needs the calling
application to present an way to directly enter a location.
For example, the application may bring up a dialog box asking for
a URL like "http://http.example.com".

Feature: `v3_14`

<!-- trait PlacesSidebarExt::fn connect_show_error_message -->
The places sidebar emits this signal when it needs the calling
application to present an error message. Most of these messages
refer to mounting or unmounting media, for example, when a drive
cannot be started for some reason.

Feature: `v3_10`

## `primary`
primary message with a summary of the error to show.
## `secondary`
secondary message with details of the error to show.
<!-- trait PlacesSidebarExt::fn connect_show_other_locations -->
The places sidebar emits this signal when it needs the calling
application to present a way to show other locations e.g. drives
and network access points.
For example, the application may bring up a page showing persistent
volumes and discovered network addresses.

Feature: `v3_18`


# Deprecated since 3.20

use the `PlacesSidebar::show-other-locations-with-flags`
which includes the open flags in order to allow the user to specify to open
in a new tab or window, in a similar way than `PlacesSidebar::open-location`
<!-- trait PlacesSidebarExt::fn connect_show_other_locations_with_flags -->
The places sidebar emits this signal when it needs the calling
application to present a way to show other locations e.g. drives
and network access points.
For example, the application may bring up a page showing persistent
volumes and discovered network addresses.

Feature: `v3_20`

## `open_flags`
a single value from `PlacesOpenFlags` specifying how it should be opened.
<!-- trait PlacesSidebarExt::fn connect_unmount -->
The places sidebar emits this signal when it starts a new operation
because the user for example ejected some drive or unmounted a mount.
In this way the application using the `PlacesSidebar` can track the
progress of the operation and, for example, show a notification.

Feature: `v3_20`

## `mount_operation`
the `gio::MountOperation` that is going to start.
<!-- trait PlacesSidebarExt::fn get_property_populate-all -->
If :populate-all is `true`, the `PlacesSidebar::populate-popup` signal
is also emitted for popovers.

Feature: `v3_18`

<!-- trait PlacesSidebarExt::fn set_property_populate-all -->
If :populate-all is `true`, the `PlacesSidebar::populate-popup` signal
is also emitted for popovers.

Feature: `v3_18`

<!-- enum PolicyType -->
Determines how the size should be computed to achieve the one of the
visibility mode for the scrollbars.
<!-- enum PolicyType::variant Always -->
The scrollbar is always visible. The view size is
 independent of the content.
<!-- enum PolicyType::variant Automatic -->
The scrollbar will appear and disappear as necessary.
 For example, when all of a `TreeView` can not be seen.
<!-- enum PolicyType::variant Never -->
The scrollbar should never appear. In this mode the
 content determines the size.
<!-- enum PolicyType::variant External -->
Don't show a scrollbar, but don't force the
 size to follow the content. This can be used e.g. to make multiple
 scrolled windows share a scrollbar. Since: 3.16
<!-- struct Popover -->
`Popover` is a bubble-like context window, primarily meant to
provide context-dependent information or options. Popovers are
attached to a widget, passed at construction time on `Popover::new`,
or updated afterwards through `PopoverExt::set_relative_to`, by
default they will point to the whole widget area, although this
behavior can be changed through `PopoverExt::set_pointing_to`.

The position of a popover relative to the widget it is attached to
can also be changed through `PopoverExt::set_position`.

By default, `Popover` performs a GTK+ grab, in order to ensure
input events get redirected to it while it is shown, and also so
the popover is dismissed in the expected situations (clicks outside
the popover, or the Esc key being pressed). If no such modal behavior
is desired on a popover, `PopoverExt::set_modal` may be called on it
to tweak its behavior.

## `Popover` as menu replacement

`Popover` is often used to replace menus. To facilitate this, it
supports being populated from a `gio::MenuModel`, using
`Popover::new_from_model`. In addition to all the regular menu
model features, this function supports rendering sections in the
model in a more compact form, as a row of icon buttons instead of
menu items.

To use this rendering, set the ”display-hint” attribute of the
section to ”horizontal-buttons” and set the icons of your items
with the ”verb-icon” attribute.


```text
<section>
  <attribute name="display-hint">horizontal-buttons</attribute>
  <item>
    <attribute name="label">Cut</attribute>
    <attribute name="action">app.cut</attribute>
    <attribute name="verb-icon">edit-cut-symbolic</attribute>
  </item>
  <item>
    <attribute name="label">Copy</attribute>
    <attribute name="action">app.copy</attribute>
    <attribute name="verb-icon">edit-copy-symbolic</attribute>
  </item>
  <item>
    <attribute name="label">Paste</attribute>
    <attribute name="action">app.paste</attribute>
    <attribute name="verb-icon">edit-paste-symbolic</attribute>
  </item>
</section>
```

# CSS nodes

`Popover` has a single css node called popover. It always gets the
.background style class and it gets the .menu style class if it is
menu-like (e.g. `PopoverMenu` or created using `Popover::new_from_model`.

Particular uses of `Popover`, such as touch selection popups
or magnifiers in `Entry` or `TextView` get style classes
like .touch-selection or .magnifier to differentiate from
plain popovers.

Feature: `v3_12`

# Implements

[`PopoverExt`](trait.PopoverExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html), [`WidgetExt`](trait.WidgetExt.html), [`glib::object::ObjectExt`](../glib/object/trait.ObjectExt.html), [`BuildableExt`](trait.BuildableExt.html)
<!-- trait PopoverExt -->
Trait containing all `Popover` methods.

Feature: `v3_12`

# Implementors

[`PopoverMenu`](struct.PopoverMenu.html), [`Popover`](struct.Popover.html)
<!-- impl Popover::fn new -->
Creates a new popover to point to `relative_to`

Feature: `v3_12`

## `relative_to`
`Widget` the popover is related to

# Returns

a new `Popover`
<!-- impl Popover::fn new_from_model -->
Creates a `Popover` and populates it according to
`model`. The popover is pointed to the `relative_to` widget.

The created buttons are connected to actions found in the
`ApplicationWindow` to which the popover belongs - typically
by means of being attached to a widget that is contained within
the ``GtkApplicationWindows`` widget hierarchy.

Actions can also be added using `WidgetExt::insert_action_group`
on the menus attach widget or on any of its parent widgets.

Feature: `v3_12`

## `relative_to`
`Widget` the popover is related to
## `model`
a `gio::MenuModel`

# Returns

the new `Popover`
<!-- trait PopoverExt::fn bind_model -->
Establishes a binding between a `Popover` and a `gio::MenuModel`.

The contents of `self` are removed and then refilled with menu items
according to `model`. When `model` changes, `self` is updated.
Calling this function twice on `self` with different `model` will
cause the first binding to be replaced with a binding to the new
model. If `model` is `None` then any previous binding is undone and
all children are removed.

If `action_namespace` is non-`None` then the effect is as if all
actions mentioned in the `model` have their names prefixed with the
namespace, plus a dot. For example, if the action “quit” is
mentioned and `action_namespace` is “app” then the effective action
name is “app.quit”.

This function uses `Actionable` to define the action name and
target values on the created menu items. If you want to use an
action group other than “app” and “win”, or if you want to use a
`MenuShell` outside of a `ApplicationWindow`, then you will need
to attach your own action group to the widget hierarchy using
`WidgetExt::insert_action_group`. As an example, if you created a
group with a “quit” action and inserted it with the name “mygroup”
then you would use the action name “mygroup.quit” in your
`gio::MenuModel`.

Feature: `v3_12`

## `model`
the `gio::MenuModel` to bind to or `None` to remove
 binding
## `action_namespace`
the namespace for actions in `model`
<!-- trait PopoverExt::fn get_constrain_to -->
Returns the constraint for placing this popover.
See `PopoverExt::set_constrain_to`.

Feature: `v3_20`


# Returns

the constraint for placing this popover.
<!-- trait PopoverExt::fn get_default_widget -->
Gets the widget that should be set as the default while
the popover is shown.

Feature: `v3_18`


# Returns

the default widget,
or `None` if there is none
<!-- trait PopoverExt::fn get_modal -->
Returns whether the popover is modal, see gtk_popover_set_modal to
see the implications of this.

Feature: `v3_12`


# Returns

`true` if `self` is modal
<!-- trait PopoverExt::fn get_pointing_to -->
If a rectangle to point to has been set, this function will
return `true` and fill in `rect` with such rectangle, otherwise
it will return `false` and fill in `rect` with the attached
widget coordinates.
## `rect`
location to store the rectangle

# Returns

`true` if a rectangle to point to was set.
<!-- trait PopoverExt::fn get_position -->
Returns the preferred position of `self`.

# Returns

The preferred position.
<!-- trait PopoverExt::fn get_relative_to -->
Returns the widget `self` is currently attached to

Feature: `v3_12`


# Returns

a `Widget`
<!-- trait PopoverExt::fn get_transitions_enabled -->
Returns whether show/hide transitions are enabled on this popover.

Feature: `v3_16`


# Deprecated since 3.22

You can show or hide the popover without transitions
 using `WidgetExt::show` and `WidgetExt::hide` while `PopoverExt::popup`
 and `PopoverExt::popdown` will use transitions.

# Returns

`true` if the show and hide transitions of the given
 popover are enabled, `false` otherwise.
<!-- trait PopoverExt::fn popdown -->
Pops `self` down.This is different than a `WidgetExt::hide` call
in that it shows the popover with a transition. If you want to hide
the popover without a transition, use `WidgetExt::hide`.

Feature: `v3_22`

<!-- trait PopoverExt::fn popup -->
Pops `self` up. This is different than a `WidgetExt::show` call
in that it shows the popover with a transition. If you want to show
the popover without a transition, use `WidgetExt::show`.

Feature: `v3_22`

<!-- trait PopoverExt::fn set_constrain_to -->
Sets a constraint for positioning this popover.

Note that not all platforms support placing popovers freely,
and may already impose constraints.

Feature: `v3_20`

## `constraint`
the new constraint
<!-- trait PopoverExt::fn set_default_widget -->
Sets the widget that should be set as default widget while
the popover is shown (see `GtkWindowExt::set_default`). `Popover`
remembers the previous default widget and reestablishes it
when the popover is dismissed.

Feature: `v3_18`

## `widget`
the new default widget, or `None`
<!-- trait PopoverExt::fn set_modal -->
Sets whether `self` is modal, a modal popover will grab all input
within the toplevel and grab the keyboard focus on it when being
displayed. Clicking outside the popover area or pressing Esc will
dismiss the popover and ungrab input.

Feature: `v3_12`

## `modal`
`true` to make popover claim all input within the toplevel
<!-- trait PopoverExt::fn set_pointing_to -->
Sets the rectangle that `self` will point to, in the
coordinate space of the widget `self` is attached to,
see `PopoverExt::set_relative_to`.

Feature: `v3_12`

## `rect`
rectangle to point to
<!-- trait PopoverExt::fn set_position -->
Sets the preferred position for `self` to appear. If the `self`
is currently visible, it will be immediately updated.

This preference will be respected where possible, although
on lack of space (eg. if close to the window edges), the
`Popover` may choose to appear on the opposite side

Feature: `v3_12`

## `position`
preferred popover position
<!-- trait PopoverExt::fn set_relative_to -->
Sets a new widget to be attached to `self`. If `self` is
visible, the position will be updated.

Note: the ownership of popovers is always given to their `relative_to`
widget, so if `relative_to` is set to `None` on an attached `self`, it
will be detached from its previous widget, and consequently destroyed
unless extra references are kept.

Feature: `v3_12`

## `relative_to`
a `Widget`
<!-- trait PopoverExt::fn set_transitions_enabled -->
Sets whether show/hide transitions are enabled on this popover

Feature: `v3_16`


# Deprecated since 3.22

You can show or hide the popover without transitions
 using `WidgetExt::show` and `WidgetExt::hide` while `PopoverExt::popup`
 and `PopoverExt::popdown` will use transitions.
## `transitions_enabled`
Whether transitions are enabled
<!-- trait PopoverExt::fn get_property_constrain-to -->
Sets a constraint for the popover position.

Feature: `v3_20`

<!-- trait PopoverExt::fn set_property_constrain-to -->
Sets a constraint for the popover position.

Feature: `v3_20`

<!-- trait PopoverExt::fn get_property_modal -->
Sets whether the popover is modal (so other elements in the window do not
receive input while the popover is visible).

Feature: `v3_12`

<!-- trait PopoverExt::fn set_property_modal -->
Sets whether the popover is modal (so other elements in the window do not
receive input while the popover is visible).

Feature: `v3_12`

<!-- trait PopoverExt::fn get_property_pointing-to -->
Marks a specific rectangle to be pointed.

Feature: `v3_12`

<!-- trait PopoverExt::fn set_property_pointing-to -->
Marks a specific rectangle to be pointed.

Feature: `v3_12`

<!-- trait PopoverExt::fn get_property_position -->
Sets the preferred position of the popover.

Feature: `v3_12`

<!-- trait PopoverExt::fn set_property_position -->
Sets the preferred position of the popover.

Feature: `v3_12`

<!-- trait PopoverExt::fn get_property_relative-to -->
Sets the attached widget.

Feature: `v3_12`

<!-- trait PopoverExt::fn set_property_relative-to -->
Sets the attached widget.

Feature: `v3_12`

<!-- trait PopoverExt::fn get_property_transitions-enabled -->
Whether show/hide transitions are enabled for this popover.

Feature: `v3_16`

<!-- trait PopoverExt::fn set_property_transitions-enabled -->
Whether show/hide transitions are enabled for this popover.

Feature: `v3_16`

<!-- enum PopoverConstraint -->
Describes constraints to positioning of popovers. More values
may be added to this enumeration in the future.
<!-- enum PopoverConstraint::variant None -->
Don't constrain the popover position
 beyond what is imposed by the implementation
<!-- enum PopoverConstraint::variant Window -->
Constrain the popover to the boundaries
 of the window that it is attached to

Feature: `v3_20`

<!-- struct PopoverMenu -->
`PopoverMenu` is a subclass of `Popover` that treats its
children like menus and allows switching between them. It is
meant to be used primarily together with `ModelButton`, but
any widget can be used, such as `SpinButton` or `Scale`.
In this respect, `PopoverMenu` is more flexible than popovers
that are created from a `gio::MenuModel` with `Popover::new_from_model`.

To add a child as a submenu, set the `PopoverMenu:submenu`
child property to the name of the submenu. To let the user open
this submenu, add a `ModelButton` whose `ModelButton:menu-name`
property is set to the name you've given to the submenu.

By convention, the first child of a submenu should be a `ModelButton`
to switch back to the parent menu. Such a button should use the
`ModelButton:inverted` and `ModelButton:centered` properties
to achieve a title-like appearance and place the submenu indicator
at the opposite side. To switch back to the main menu, use "main"
as the menu name.

# Example


```text
<object class="GtkPopoverMenu">
  <child>
    <object class="GtkBox">
      <property name="visible">True</property>
      <property name="margin">10</property>
      <child>
        <object class="GtkModelButton">
          <property name="visible">True</property>
          <property name="action-name">win.frob</property>
          <property name="text" translatable="yes">Frob</property>
        </object>
      </child>
      <child>
        <object class="GtkModelButton">
          <property name="visible">True</property>
          <property name="menu-name">more</property>
          <property name="text" translatable="yes">More</property>
        </object>
      </child>
    </object>
  </child>
  <child>
    <object class="GtkBox">
      <property name="visible">True</property>
      <property name="margin">10</property>
      <child>
        <object class="GtkModelButton">
          <property name="visible">True</property>
          <property name="action-name">win.foo</property>
          <property name="text" translatable="yes">Foo</property>
        </object>
      </child>
      <child>
        <object class="GtkModelButton">
          <property name="visible">True</property>
          <property name="action-name">win.bar</property>
          <property name="text" translatable="yes">Bar</property>
        </object>
      </child>
    </object>
    <packing>
      <property name="submenu">more</property>
    </packing>
  </child>
</object>
```

Just like normal popovers created using gtk_popover_new_from_model,
`PopoverMenu` instances have a single css node called "popover"
and get the .menu style class.

Feature: `v3_16`

# Implements

[`PopoverMenuExt`](trait.PopoverMenuExt.html), [`PopoverExt`](trait.PopoverExt.html), [`BinExt`](trait.BinExt.html), [`ContainerExt`](trait.ContainerExt.html),