#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the following features of the sanitizer:

  - null boundary string vuln. protection (Exchange 5.5 DoS)
  - null charset vulnerability protection (Exchange 5.5 DoS)

tac
$ANOMY/bin/sanitizer.pl \
    'header_rev = 0' \
    'feat_testing = 1' \
    'feat_log_inline = 1' \
    'file_list_2_policy = accept' \
    'file_list_2 = (?i)\.txt$' \
    'feat_log_stderr = 0' <<EOF 2>test.log >test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
To: fake@example.com
Subject: Clean multipart/mixed test case
Content-Type: multipart/mixed; boundary="=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV"

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset=""
Content-Transfer-Encoding: 8bit

blah blah

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: multipart/mixed; boundary=""


--
Content-Type: text/plain; charset=iso-8859-1
Content-Disposition: attachment; 
Content-Transfer-Encoding: 8bit

bleh!
----

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV--

EOF
