#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests how the sanitizer handles CRLF instead of just LF
endings in the message body.

This also tests the detection of bare <CR> characters within headers
(a possible Outlook exploit).

tac

CRHACK=$(echo -e "\rX-Evil-Header: boo")

rm -f ./.tmp.* test.log test.out
for a in 0 1 2 3; do
  cat <<EOF | perl -npe 's/\n/\r\n/gs' | $ANOMY/bin/sanitizer.pl $SAN_CONF \
    "feat_newlines = $a" \
    'feat_force_name = 1' \
    'feat_fixmime = 1' \
    'file_list_rules = 0' \
    'file_default_policy = drop' \
    'header_rev = 0' \
    'feat_testing = 1' \
    'feat_log_inline = 1' \
    'feat_log_stderr = 0' 2>>test.log >>test.out
Return-Path: <bre@klaki.net>
Date: Wed, 15 Aug 2001 13:11:46 +0000
From: Bjarni <bre@klaki.net>
To: dood@dood.com
Subject: Monkeygame
Message-ID: <02001511533181391.A16415@klaki.net>
Mime-Version: 1.0
Content-Type: multipart/mixed; boundary=nFreZHaLTZJo0R7j
X-Junk: $CRHACK
X-Mailer: Mutt 0.95i


--nFreZHaLTZJo0R7j
Content-Type: text/plain; charset=us-ascii
X-Junk: $CRHACK

Testing

--nFreZHaLTZJo0R7j
Content-Type: application/x-msdos-program
Content-Disposition: attachment; filename="pong.exe"
Content-Transfer-Encoding: base64

TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAA2AAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFtIGNhbm5vdCBiZSBydW4gaW4g
RE9TIG1vZGUuDQ0KJAAAAAAAAAAXx9XqU6a7uVOmu7lTpru5u7mwuVKmu7nQurW5Q6a7udS6
ublcpru5U6a6uQemu7kxuai5VKa7ubu5sbkGpru5UmljaFOmu7kAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAATkIxMAAA
AADLocM4RwAAAE46XHRtcFxmb3JyaXQyXERlYnVnXGZvcnJpdDIucGRiAA==

--nFreZHaLTZJo0R7j--
EOF

echo "*** Exit code was $? ***" >>test.out
rm -f ./.tmp.*
done

exit 0
