#!/bin/sh

# Set default variables.
#
FAILED=0
[ "$TEST_RESULTS" = "" ] && TEST_RESULTS=results.def
ANOMY=..
PERL5LIB=
export ANOMY PERL5LIB

# Do we have/need the TNEF stuff?
TNEF=0
[ -e ../bin/Anomy/TNEFStream.pm ] && TNEF=1

# Check prerequisites.
#
echo -n "Checking prerequisites... "
REQ="-MDigest::MD5 -MMIME::Base64 -MMIME::QuotedPrint -MIO::File"
[ $TNEF = 1 ] && REQ="$REQ -MMIME::Body"
perl $REQ -e1 2>/dev/null
if [ $? != 0 ] ; then
    echo failed.
    echo
    echo "One or more of the following Perl modules were missing from your"
    echo "system.  You need to install them before you can use the Anomy"
    echo "Mail Sanitizer:"
    echo
    echo "    IO::File"
[ $TNEF = 1 ] && \
    echo "    MIME::Body"
    echo "    MIME::Base64"
    echo "    MIME::QuotedPrint"
    echo "    Digest::MD5"
    echo
    echo "Try 'perldoc CPAN' for information on how to obtain them.  But"
    echo "beware - the CPAN module likes to upgrade your perl installation,"
    echo "which may not be what you want. :-)"
    echo
    exit 1
else
    echo ok.
fi

# Load local configuration, if it exists.
#
if [ -f tests.conf ]; then
    . tests.conf
    echo "Using configuration from tests.conf - results go in $TEST_RESULTS."
fi
export TEST_RESULTS SAN_CONF

# Minor sanity checks...
#
if [ ! -d "$TEST_RESULTS" ]; then
    echo "No such directory: $TEST_RESULTS"
    exit 1
fi
if [ "$SAN_CONF" != "" -a ! -r "$SAN_CONF" ]; then
    echo "No such file: $SAN_CONF"
    exit 1
fi

# Run tests!
#
WHICH=$1
echo "Running tests ..."
echo
for a in *.t; do
  if [ "$WHICH" = "" -o "$a" = "$WHICH" ]; then
        test=`echo $a |sed -e 's/\.t$//'`
	/bin/echo -n "$test:	"
	sh $a
	if [ ! -f "$TEST_RESULTS/$test.ok" ]; then
	    cp test.out "$TEST_RESULTS/$test.ok"
	    echo installed
	else
	    if diff test.out "$TEST_RESULTS/$test.ok" >test.diff; then
	        T="$TEST_RESULTS/$test"
	        rm -f test.* $T.out $T.log $T.diff
	        echo ok
            else
		for t in test.*; do
		    mv -f $t "$TEST_RESULTS"/`echo $t |sed -e "s/^test/$test/"`
		done
	        echo "failed  (moved result files to $TEST_RESULTS)"
		let FAILED=$FAILED+1
	    fi
        fi
  fi
done

rm -f test.*
echo
[ $FAILED = 0 ] && exit 0

# Beg for feedback...
#
cat <<tac
One or more tests failed!  There are two possible reasons for this:

 1) Something was fixed, and your test-case results need to be updated.
 2) I (the author) broke something.

Please check the change-log to see which it is.  If it's number 1), then
just replace the .ok file with the .out file generated by the failed test,
in your result directory.

Otherwise - if you think something is broken (case 2), please send the
following info to anomy-bugs@mailtools.anomy.net:

 - Architecture (e.g. Sparc, Intel, Alpha. ...)
 - Operating system (e.g. RedHat 6.2, Solaris 8, HP-UX, ...)
 - Perl version (the output of "perl -V")
 - Any relevant Anomy configuration files (e.g. for the sanitizer).
 - Copies of all result files for the failed tests (they should have the
   extensions .ok, .out, .diff and .log).

Thanks!

tac
exit 1

