#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc Debug {which varname} {
    upvar $varname var
    global current

    if {$current(frame) != ""} {
	$current(frame) debug $which $var
    }
}

proc ProcessDebugTclCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global debug

    switch -- [lindex $var $i] {
	events {set debug(tcl,events) 1}
	update {set debug(tcl,update) 1}
	idletasks {set debug(tcl,idletasks) 1}
	layout {set debug(tcl,layout) 1}
	info {set debug(tcl,info) 1}
	watch {set debug(tcl,watch) 1}
	hv {set debug(tcl,hv) 1}
	grid {set debug(tcl,grid) 1}
	http {set debug(tcl,http) 1}
	ftp {set debug(tcl,ftp) 1}
    }
}

proc ProcessDebugCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global debug

    DebugMenu

    switch -- [lindex $var $i] {
	ast {
	    set debug(saotk,ast) 1
	    Debug ast debug(saotk,ast)
	}
	mosaic {
	    set debug(saotk,mosaic) 1
	    Debug mosaic debug(saotk,mosaic)
	}
	parser {
	    set debug(saotk,parser) 1
	    Debug parser debug(saotk,parser)
	}
	perf {
	    set debug(saotk,perf) 1
	    Debug perf debug(saotk,perf)
	}
	wcs {
	    set debug(saotk,wcs) 1
	    Debug wcs debug(saotk,wcs)
	}
	bin {
	    set debug(saotk,bin) 1
	    Debug bin debug(saotk,bin)
	}
	gz {
	    set debug(saotk,gz) 1
	    Debug gz debug(saotk,gz)
	}
	iis {
	    set debug(iis) 1
	    IISDebug
	}
	rgb {
	    set debug(saotk,rgb) 1
	    Debug rgb debug(saotk,rgb)
	}
    }
}
