#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc RGBEvalLock {varname cmd} {
    upvar $varname var

    global current
    global scale
    global rgb

    if {$var && [$current(frame) get type] == "rgb"} {
	set ch $current(rgb)
	foreach c {red green blue} {
	    $current(frame) rgb channel $c
	    eval "$cmd"
	}
	set current(rgb) $ch
	$current(frame) rgb channel $current(rgb)
    } else {
	eval "$cmd"
    }
}

proc RGBEvalLockColorbar {cmd} {
    global current
    global scale
    global rgb

    if {$rgb(lock,colorbar) && [$current(frame) get type] == "rgb"} {
	set ch $current(rgb)
	foreach c {red green blue} {
	    colorbarrgb rgb channel $c
	    eval "$cmd"
	}
	set current(rgb) $ch
	colorbarrgb rgb channel $current(rgb)
    } else {
	eval "$cmd"
    }
}

proc RGBChannel {} {
    global current

    if {$current(frame) != ""} {
	if {[$current(frame) get type] == "rgb"} {
	    colorbarrgb rgb channel $current(rgb)
	}
	$current(frame) rgb channel $current(rgb)
	UpdateDS9
    }
}

proc RGBView {} {
    global current
    global rgb

    if {$current(frame) != ""} {
	$current(frame) rgb view $rgb(red) $rgb(green) $rgb(blue)
    }
}

proc RGBSystem {} {
    global current
    global rgb

    if {$current(frame) != ""} {
	$current(frame) rgb system $rgb(system)
    }
}

proc RGBDialog {} {
    global rgb
    global current
    global menu
    global ds9

    # see if we already have a window visible
    if [winfo exist $rgb(top)] {
	raise $rgb(top)
	return
    }

    set w $rgb(top)
    set title "RGB"

    # create the rgb window

    toplevel $w -colormap $ds9(main)
    wm title $w $title
    wm iconname $w $title
    wm group $w $ds9(top)
    wm protocol $w WM_DELETE_WINDOW RGBDestroyDialog

    $w configure -menu $rgb(mb)

    menu $rgb(mb) -tearoff 0
    $rgb(mb) add cascade -label "File" -menu $rgb(mb).file
    $rgb(mb) add cascade -label "Align" -menu $rgb(mb).align
    $rgb(mb) add cascade -label "Lock" -menu $rgb(mb).lock

    menu $rgb(mb).file -tearoff 0 -selectcolor $menu(selectcolor)
    $rgb(mb).file add command -label "Close" -command RGBDestroyDialog

    menu $rgb(mb).align -tearoff 0 -selectcolor $menu(selectcolor)
    $rgb(mb).align add radiobutton -label "WCS" \
	-variable rgb(system) -value wcs -command RGBSystem
    $rgb(mb).align add cascade -label "Multiple WCS" \
	-menu $rgb(mb).align.wcs
    $rgb(mb).align add separator
    $rgb(mb).align add radiobutton -label "Image" \
	-variable rgb(system) -value image -command RGBSystem
    $rgb(mb).align add radiobutton -label "Physical" \
	-variable rgb(system) -value physical -command RGBSystem
    if {$ds9(amp,det)} {
	$rgb(mb).align add radiobutton -label "Amplifier" \
	    -variable rgb(system) -value amplifier -command RGBSystem
	$rgb(mb).align add radiobutton -label "Detector" \
	    -variable rgb(system) -value detector -command RGBSystem
    }

    menu $rgb(mb).align.wcs -tearoff 0 -selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$rgb(mb).align.wcs add radiobutton -label "WCS $l" \
	    -variable rgb(system) -value "wcs$l"  -command RGBSystem
    }

    menu $rgb(mb).lock -tearoff 0 -selectcolor $menu(selectcolor)
    $rgb(mb).lock add checkbutton -label "Scaling" \
	-variable rgb(lock,scale)
    $rgb(mb).lock add checkbutton -label "Binning" \
	-variable rgb(lock,bin)
    $rgb(mb).lock add checkbutton -label "Colorbar" \
	-variable rgb(lock,colorbar)

    frame $w.param -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.param $w.buttons -fill x -ipadx 4 -ipady 4

    label $w.param.currenttitle -text "Current"
    label $w.param.viewtitle -text "View"
    label $w.param.redtitle -text "Red"
    label $w.param.bluetitle -text "Blue"
    label $w.param.greentitle -text "Green"

    radiobutton $w.param.redcurrent -selectcolor $menu(selectcolor) \
	-variable current(rgb) -value red -command RGBChannel
    radiobutton $w.param.greencurrent -selectcolor $menu(selectcolor) \
	-variable current(rgb) -value green -command RGBChannel
    radiobutton $w.param.bluecurrent -selectcolor $menu(selectcolor) \
	-variable current(rgb) -value blue -command RGBChannel

    checkbutton $w.param.redview -selectcolor $menu(selectcolor) \
	-variable rgb(red) -command RGBView
    checkbutton $w.param.greenview -selectcolor $menu(selectcolor) \
	-variable rgb(green) -command RGBView
    checkbutton $w.param.blueview -selectcolor $menu(selectcolor) \
	-variable rgb(blue) -command RGBView

    grid rowconfigure $w.param 0 -pad 4
    grid rowconfigure $w.param 1 -pad 4
    grid rowconfigure $w.param 2 -pad 4
    grid rowconfigure $w.param 3 -pad 4

    grid x $w.param.currenttitle $w.param.viewtitle -padx 4 -sticky w
    grid $w.param.redtitle -row 1 -column 0 -padx 4 -sticky w
    grid $w.param.redcurrent -row 1 -column 1 -padx 4 -sticky ew
    grid $w.param.redview -row 1 -column 2 -padx 4 -sticky ew
    grid $w.param.greentitle -row 2 -column 0 -padx 4 -sticky w
    grid $w.param.greencurrent -row 2 -column 1 -padx 4 -sticky ew
    grid $w.param.greenview -row 2 -column 2 -padx 4 -sticky ew
    grid $w.param.bluetitle -row 3 -column 0 -padx 4 -sticky w
    grid $w.param.bluecurrent -row 3 -column 1 -padx 4 -sticky ew
    grid $w.param.blueview -row 3 -column 2 -padx 4 -sticky ew

    button $w.buttons.close -text "Close" -command RGBDestroyDialog
    pack $w.buttons.close -side left -padx 10 -expand true
}

proc RGBDestroyDialog {} {
    global rgb

    destroy $rgb(top)
    destroy $rgb(mb)
}

proc UpdateRGBDialog {} {
    global rgb
    global current

    global debug
    if {$debug(tcl,update)} {
	puts "UpdateRGBDialog"
    }

    if {[winfo exist $rgb(top)] && $current(frame) != ""} {
	set current(rgb) [$current(frame) get rgb channel]
	set r [$current(frame) get rgb view]
	set rgb(red) [lindex $r 0]
	set rgb(green) [lindex $r 1]
	set rgb(blue) [lindex $r 2]
	set rgb(system) [$current(frame) get rgb system]
    }
}

proc ProcessRGBCmd {varname iname} {
    global current
    global rgb

    upvar $varname var
    upvar $iname i

    switch -- [string tolower [lindex $var $i]] {
	red -
	green -
	blue {
	    set current(rgb) [string tolower [lindex $var $i]]
	    RGBChannel
	}
	channel {
	    incr i
	    set current(rgb) [string tolower [lindex $var $i]]
	    RGBChannel
	}
	lock {
	    incr i
	    switch -- [string tolower [lindex $var $i]] {
		bin {incr i; set rgb(lock,bin) [FromYesNo [lindex $var $i]]}
		scale {incr i;set rgb(lock,scale) [FromYesNo [lindex $var $i]]}
		colorbar {incr i;set rgb(lock,colorbar) [FromYesNo [lindex $var $i]]}
	    }
	}
	system {
	    incr i
	    set rgb(system) [string tolower [lindex $var $i]]
	    RGBSystem
	}
	view {
	    set w [lindex $var [expr $i+1]]
	    set yesno [lindex $var [expr $i+2]]
	    switch -- [string tolower $w] {
		red {set rgb(red) [FromYesNo $yesno]; RGBView}
		green {set rgb(green) [FromYesNo $yesno]; RGBView}
		blue {set rgb(blue) [FromYesNo $yesno]; RGBView}
	    }
	    incr i 2
	}
	default {CreateRGBFrame; incr i -1}
    }
}
