// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <stdlib.h>

#include "colormap.h"
#include "util.h"

static int squenceID = 1;

// ColorMapInfo

ColorMapInfo::ColorMapInfo()
{
  id = squenceID++;
  name = NULL;
  fileName = NULL;
  next = NULL;
}

ColorMapInfo::~ColorMapInfo()
{
  if (name)
    delete [] name;

  if (fileName)
    delete [] fileName;
}

void ColorMapInfo::setName(const char* n)
{
  if (name)
    delete [] name;

  name = dupstr(n);
}

void ColorMapInfo::setFileName(const char* n)
{
  if (fileName)
    delete [] fileName;

  fileName = dupstr(n);
}
