#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc CreateInfoPanel {} {
    global ds9
    global menu
    global view
    global info

    # Panel Frame

    set ds9(panel) [frame $ds9(main).panel]

    # Panner
    global panner
    set ds9(panner) [canvas $ds9(panel).pan -width $panner(size) \
			 -height $panner(size) \
			 -bd 2 -relief groove \
			 -highlightthickness 0 -insertofftime 0 -takefocus 0]
    $ds9(panner) create panner$ds9(visual) -width $panner(size) \
	-height $panner(size) -command panner -tag panner

    # Magnifier
    global magnifier
    set ds9(magnifier) [canvas $ds9(panel).mag -width $magnifier(size) \
		       -height $magnifier(size) \
		       -bd 2 -relief groove \
		       -highlightthickness 0 -insertofftime 0 -takefocus 0]
    $ds9(magnifier) create magnifier$ds9(visual) -width $magnifier(size) \
	-height $magnifier(size) -command magnifier -tag magnifier

    # Info
    set ds9(info) [frame $ds9(panel).info -relief groove -borderwidth 2]

    frame $ds9(info).dummy

    label $ds9(info).fileTitle -text "File"
    label $ds9(info).fileValue -relief groove -anchor w \
	-textvariable info(pFileName)

    label $ds9(info).objTitle -text "Object"
    label $ds9(info).objValue -relief groove -anchor w \
	-textvariable info(pObject)

    label $ds9(info).minTitle -text "Min"
    label $ds9(info).minValue -relief groove \
	-textvariable info(pMin)

    label $ds9(info).maxTitle -text "Max"
    label $ds9(info).maxValue -relief groove \
	-textvariable info(pMax)

    label $ds9(info).lowTitle -text "Low"
    label $ds9(info).lowValue -relief groove \
	-textvariable info(pLow)

    label $ds9(info).highTitle -text "High"
    label $ds9(info).highValue -relief groove \
	-textvariable info(pHigh)

    label $ds9(info).valueTitle -text "Value" -anchor w
    frame $ds9(info).valueValue
    label $ds9(info).valueValue.v -relief groove \
	-textvariable info(pValue)

    label $ds9(info).valueValue.red -relief groove \
	-textvariable info(pValue,red)
    label $ds9(info).valueValue.green -relief groove \
	-textvariable info(pValue,green)
    label $ds9(info).valueValue.blue -relief groove \
	-textvariable info(pValue,blue)

    foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	set info(pWCSCoord,$l) "WCS $l"
	label $ds9(info).wcsLabel$l -textvariable info(pWCSCoord,$l)

	set info(pWCSXName,$l) [label $ds9(info).wcsXLabel$l -text {} \
				    -font {symbol 12} -width 3]
	label $ds9(info).wcsXValue$l -relief groove \
	    -textvariable info(pWCSX,$l)
	set info(pWCSYName,$l) [label $ds9(info).wcsYLabel$l -text {} \
				    -font {symbol 12} -width 3]
	label $ds9(info).wcsYValue$l -relief groove \
	    -textvariable info(pWCSY,$l)
    }

    label $ds9(info).detectorTitle -text "Detector"
    label $ds9(info).detectorXLabel -text "X"
    label $ds9(info).detectorXValue -relief groove \
	-textvariable info(pDetectorX)
    label $ds9(info).detectorYLabel -text "Y"
    label $ds9(info).detectorYValue -relief groove \
	-textvariable info(pDetectorY)

    label $ds9(info).amplifierTitle -text "Amp"
    label $ds9(info).amplifierXLabel -text "X"
    label $ds9(info).amplifierXValue -relief groove \
	-textvariable info(pAmplifierX)
    label $ds9(info).amplifierYLabel -text "Y"
    label $ds9(info).amplifierYValue -relief groove \
	-textvariable info(pAmplifierY)

    label $ds9(info).physicalTitle -text "Physical"
    label $ds9(info).physicalXLabel -text "X"
    label $ds9(info).physicalXValue -relief groove \
	-textvariable info(pPhysicalX)
    label $ds9(info).physicalYLabel -text "Y"
    label $ds9(info).physicalYValue -relief groove \
	-textvariable info(pPhysicalY)

    label $ds9(info).imageTitle -text "Image"
    label $ds9(info).imageXLabel -text "X"
    label $ds9(info).imageXValue -relief groove \
	-textvariable info(pImageX)
    label $ds9(info).imageYLabel -text "Y"
    label $ds9(info).imageYValue -relief groove \
	-textvariable info(pImageY)

    label $ds9(info).frame -textvariable info(pFrame) 

    label $ds9(info).zoomtitle -text "Zoom"
    label $ds9(info).zoomValue -relief groove -textvariable info(pZoom)

    label $ds9(info).angleTitle -text "Ang"
    label $ds9(info).angleValue -relief groove -textvariable info(pAngle)
}

proc EnterInfoBox {which x y sys} {
    global info

    global debug
    if {$debug(tcl,events)} {
	puts "EnterInfoBox"
    }

    UpdateInfoPanelValue $which
    UpdateInfoBox $which $x $y $sys

    set info(pFrame) $which
    set info(pAngle) [$which get rotate fixed]

    set z [$which get zoom fixed]
    set z1 [lindex $z 0]
    set z2 [lindex $z 1]
    if {$z1 != $z2} {
	set info(pZoom) "$z1  $z2"
    } else {
	set info(pZoom) $z1
    }
}

proc LeaveInfoBox {} {
    global ds9
    global current

    global debug
    if {$debug(tcl,events)} {
	puts "LeaveInfoBox"
    }

    ClearInfoBoxCoords
}

proc MotionInfoBox {which x y sys} {
    UpdateInfoBox $which $x $y $sys
}

proc ClearInfoBox {} {
    global info

    global debug
    if {$debug(tcl,info)} {
	puts "ClearInfoBox"
    }

    set info(pFileName) {}
    set info(pObject) {}

    set info(pMin) {}
    set info(pMax) {}
    set info(pLow) {}
    set info(pHigh) {}

    ClearInfoBoxCoords

    set info(pFrame) Frame
    set info(pZoom) {}
    set info(pAngle) {}
}

proc RefreshInfoBox {which} {
    global ds9
    global info

    global debug
    if {$debug(tcl,info)} {
	puts "RefreshInfoBox"
    }

    switch -- [$which get type] {
	base {
	    grid forget $ds9(info).valueValue.red
	    grid forget $ds9(info).valueValue.green
	    grid forget $ds9(info).valueValue.blue
	    grid $ds9(info).valueValue.v
	}
	rgb {
	    grid forget $ds9(info).valueValue.v
	    grid $ds9(info).valueValue.red $ds9(info).valueValue.green \
		$ds9(info).valueValue.blue
	}
    }

    $which get info result
    SetInfoBoxFileName result

    # not needed if panner will generate an EnterWindow Event
    ClearInfoBoxCoords

    set info(pFrame) $which
    set info(pAngle) [$which get rotate fixed]

    set z [$which get zoom fixed]
    set z1 [lindex $z 0]
    set z2 [lindex $z 1]
    if {$z1 != $z2} {
	set info(pZoom) "$z1  $z2"
    } else {
	set info(pZoom) $z1
    }
}

proc UpdateInfoBox {which x y sys} {
# Note: we want to avoid changing the displayed data at all cost. 
# Updating a label widget is very costly. Therefor, try to test 
# for change of data before updating.

    global debug
    if {$debug(tcl,info)} {
	puts "UpdateInfoBox"
    }

    global wcs
    $which get info $sys $x $y $wcs(sky) $wcs(skyformat) result
    SetInfoBoxFileName result

    global info
    set info(pValue) $result(value)
    set info(pValue,red) $result(value,red)
    set info(pValue,green) $result(value,green)
    set info(pValue,blue) $result(value,blue)

    global view
    if {$view(info,image)} {
	set info(pImageX) $result(xImage)
	set info(pImageY) $result(yImage)
    }

    if {$view(info,physical)} {
	set info(pPhysicalX) $result(xPhysical)
	set info(pPhysicalY) $result(yPhysical)
    }

    if {$view(info,amplifier)} {
	set info(pAmplifierX) $result(xAmplifier)
	set info(pAmplifierY) $result(yAmplifier)
    }

    if {$view(info,detector)} {
	set info(pDetectorX) $result(xDetector)
	set info(pDetectorY) $result(yDetector)
    }

    foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	if {$view(info,wcs$l)} {
	    set info(pWCSX,$l) $result(xWCS,$l)
	    set info(pWCSY,$l) $result(yWCS,$l)

	    switch -- $result(sysWCS,$l) {
		fk4 {
		    if {$info(pWCSCoord,$l) != "FK4"} {
			set info(pWCSCoord,$l) "FK4"
			$info(pWCSXName,$l) configure -text "a" \
			    -font {symbol 12}
			$info(pWCSYName,$l) configure -text "d" \
			    -font {symbol 12}
		    }
		}
		fk5 {
		    if {$info(pWCSCoord,$l) != "FK5"} {
			set info(pWCSCoord,$l) "FK5"
			$info(pWCSXName,$l) configure -text "a" \
			    -font {symbol 12}
			$info(pWCSYName,$l) configure -text "d" \
			    -font {symbol 12}
		    }
		}
		icrs {
		    if {$info(pWCSCoord,$l) != "ICRS"} {
			set info(pWCSCoord,$l) "ICRS"
			$info(pWCSXName,$l) configure -text "a" \
			    -font {symbol 12}
			$info(pWCSYName,$l) configure -text "d" \
			    -font {symbol 12}
		    }
		}
		galactic {
		    if {$info(pWCSCoord,$l) != "Galactic"} {
			set info(pWCSCoord,$l) "Galactic"
			$info(pWCSXName,$l) configure -text "l" -font \
			    {-family times -slant italic}
			$info(pWCSYName,$l) configure -text "b" -font \
			    {-family times -slant italic}
		    }
		}
		ecliptic {
		    if {$info(pWCSCoord,$l) != "Ecliptic"} {
			set info(pWCSCoord,$l) "Ecliptic"
			$info(pWCSXName,$l) configure -text "l" \
			    -font {symbol 12}
			$info(pWCSYName,$l) configure -text "b" \
			    -font {symbol 12}
		    }
		}
		{} {
		    if {$info(pWCSCoord,$l) != "WCS $l"} {
			set info(pWCSCoord,$l) "WCS $l"
			$info(pWCSXName,$l) configure -text {}
			$info(pWCSYName,$l) configure -text {}
		    }
		}
		default {
		    if {$info(pWCSCoord,$l) != $result(sysWCS,$l)} {
			set info(pWCSCoord,$l) $result(sysWCS,$l)
 			set unit1 [string range $result(xUnitWCS,$l) 0 2]
 			set unit2 [string range $result(yUnitWCS,$l) 0 2]
			$info(pWCSXName,$l) configure -text "$unit1" \
			    -font {times 12}
			$info(pWCSYName,$l) configure -text "$unit2" \
			    -font {times 12}
		    }
		}
	    }
	}
    }
}

proc SetInfoBoxFileName {rvar} {
    upvar $rvar result
    global info

    if {$info(pFileName) != $result(filename)} {
	set info(pFileName) $result(filename)
    }
    if {$info(pObject) != $result(objectname)} {
	set info(pObject) $result(objectname)
    }

    if {$info(pMin) != $result(min)} {
	set info(pMin) $result(min)
    }
    if {$info(pMax) != $result(max)} {
	set info(pMax) $result(max)
    }
    if {$info(pLow) != $result(low)} {
	set info(pLow) $result(low)
    }
    if {$info(pHigh) != $result(high)} {
	set info(pHigh) $result(high)
    }
}

proc ClearInfoBoxCoords {} {
    global info

    set info(pValue) {}
    set info(pValue,red) {}
    set info(pValue,green) {}
    set info(pValue,blue) {}

    foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	set info(pWCSCoord,$l) "WCS $l"
	$info(pWCSXName,$l) configure -text {}
	set info(pWCSX,$l) {}
	$info(pWCSYName,$l) configure -text {}
	set info(pWCSY,$l) {}
    }

    set info(pDetectorX) {}
    set info(pDetectorY) {}
    set info(pAmplifierX) {}
    set info(pAmplifierY) {}
    set info(pPhysicalX) {}
    set info(pPhysicalY) {}
    set info(pImageX) {}
    set info(pImageY) {}
}

proc DisplayCoordDialog {which x y sys} {
    global coord

    set r {}

    foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	if {"$coord(wcs$l)" && [$which has wcs "wcs$l"]} {
	    set cd \
    "[$which get coordinates $sys $x $y wcs$l $coord(sky) $coord(skyformat)]"

	    if [$which has wcs equatorial "wcs$l"] {
		append r " [lindex $cd 0] [lindex $cd 1] $coord(sky)"
	    } else {
		set name [$which get wcs name "wcs$l"]
		if {$name != {}} {
		    append r " [lindex $cd 0] [lindex $cd 1] $name"
		} else {
		    append r " [lindex $cd 0] [lindex $cd 1] [lindex $cd 3]"
		}
	    }
	}
    }

    if {$coord(detector) && [$which has detector]} {
	append r " [$which get coordinates $sys $x $y detector] detector"
    }

    if {$coord(amplifier) && [$which has amplifier]} {
	append r " [$which get coordinates $sys $x $y amplifier] amplifier"
    }

    if {$coord(physical) && [$which has physical]} {
	append r " [$which get coordinates $sys $x $y physical] physical"
    }

    if {$coord(image)} {
	append r " [$which get coordinates $sys $x $y image]"
    }

    if {$coord(value)} {
	append r " [$which get value $sys $x $y]"
    }

    append r " \n"

    SimpleTextDialog coord Coordinates 80 20 append bottom "$r"
}
