#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc APUpdateState {tt} {
    global ap

    if {$ap($tt,data,total) > 0} {
	set nn $ap($tt,data,current)

	set ap($tt,$nn,discrete) $ap($tt,discrete)
	set ap($tt,$nn,discrete,symbol) $ap($tt,discrete,symbol)
	set ap($tt,$nn,discrete,color) $ap($tt,discrete,color)

	set ap($tt,$nn,linear) $ap($tt,linear)
	set ap($tt,$nn,linear,width) $ap($tt,linear,width)
	set ap($tt,$nn,linear,color) $ap($tt,linear,color)
	set ap($tt,$nn,linear,dash) $ap($tt,linear,dash)

	set ap($tt,$nn,step) $ap($tt,step)
	set ap($tt,$nn,step,width) $ap($tt,step,width)
	set ap($tt,$nn,step,color) $ap($tt,step,color)
	set ap($tt,$nn,step,dash) $ap($tt,step,dash)

	set ap($tt,$nn,quadratic) $ap($tt,quadratic)
	set ap($tt,$nn,quadratic,width) $ap($tt,quadratic,width)
	set ap($tt,$nn,quadratic,color) $ap($tt,quadratic,color)
	set ap($tt,$nn,quadratic,dash) $ap($tt,quadratic,dash)

	set ap($tt,$nn,error) $ap($tt,error)
	set ap($tt,$nn,error,width) $ap($tt,error,width)
	set ap($tt,$nn,error,color) $ap($tt,error,color)
	set ap($tt,$nn,error,style) $ap($tt,error,style)
    }
    APUpdateElement $tt
}

proc APNextColor {which} {
    switch -- $which {
	black {return white}
	white {return black}
	red {return green}
	green {return blue}
	blue {return red}
	cyan {return magenta}
	magenta {return yellow}
	yellow {return cyan}
    }
}

proc APPing {tt} {
    global ap

    if {[info exist ap($tt,top)]} {
	if {[winfo exist $ap($tt,top)]} {
	    return 1
	}
    }
    return 0
}

proc APRaise {tt} {
    global ap

    if {[APPing $tt]} {
	raise $ap($tt,top)
    }
}

proc APDataSet {tt dim data} {
    global ap

    switch -- $dim {
	4 {
	    # first data set
	    APOneDataSet $tt "4.1" $data

	    # set color
	    set dc $ap($tt,discrete,color)
	    set lc $ap($tt,linear,color)
	    set sc $ap($tt,step,color)
	    set qc $ap($tt,quadratic,color)

	    set ap($tt,discrete,color) [APNextColor $ap($tt,discrete,color)]
	    set ap($tt,linear,color) [APNextColor $ap($tt,linear,color)]
	    set ap($tt,step,color) [APNextColor $ap($tt,step,color)]
	    set ap($tt,quadratic,color) [APNextColor $ap($tt,quadratic,color)]

	    # second data set
	    APOneDataSet $tt "4.2" $data

	    # rest colors
	    set ap($tt,discrete,color) $dc
	    set ap($tt,linear,color) $lc
	    set ap($tt,step,color) $sc
	    set ap($tt,quadratic,color) $qc
	}
	5 {
	    # first data set
	    APOneDataSet $tt "5.1" $data

	    # set color
	    set dc $ap($tt,discrete,color)
	    set lc $ap($tt,linear,color)
	    set sc $ap($tt,step,color)
	    set qc $ap($tt,quadratic,color)

	    set ap($tt,discrete,color) [APNextColor $ap($tt,discrete,color)]
	    set ap($tt,linear,color) [APNextColor $ap($tt,linear,color)]
	    set ap($tt,step,color) [APNextColor $ap($tt,step,color)]
	    set ap($tt,quadratic,color) [APNextColor $ap($tt,quadratic,color)]

	    # second data set
	    APOneDataSet $tt "5.2" $data

	    # rest colors
	    set ap($tt,discrete,color) $dc
	    set ap($tt,linear,color) $lc
	    set ap($tt,step,color) $sc
	    set ap($tt,quadratic,color) $qc
	}
	default {APOneDataSet $tt $dim $data}
    }
}

proc APOneDataSet {tt dim data} {
    global ap

    # look for no data
    if {[string length $data] == 0} {
	return
    }

    # incr count
    incr ap($tt,data,total) 
    set nn $ap($tt,data,total)
    set ap($tt,data,current) $nn

    # new vectors
    set ap($tt,xdata) ap${tt}xx${nn}
    set ap($tt,ydata) ap${tt}yy${nn}
    set ap($tt,xedata) ap${tt}xe${nn}
    set ap($tt,yedata) ap${tt}ye${nn}

    global $ap($tt,xdata) $ap($tt,ydata) $ap($tt,xedata) $ap($tt,yedata)

    blt::vector create $ap($tt,xdata) $ap($tt,ydata) \
	$ap($tt,xedata) $ap($tt,yedata)

    # substitute all separtors
    regsub -all {[\n\r\t, ]+} $data { } data
    # remove all non-numeric data
    regsub -all {[^0-9.e\- ]+} $data {} data

    set l [llength $data]
    switch -- $dim {
	2 -
	xy {
	    set x {}
	    set y {}
	    for {set i 0} {$i<$l} {incr i 2} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+1]]
	    }
	    $ap($tt,xdata) set $x
	    $ap($tt,ydata) set $y
	}

	xyex {
	    set x {}
	    set y {}
	    set xe {}
	    for {set i 0} {$i<$l} {incr i 3} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+1]]
		lappend xe [lindex $data [expr $i+2]]
	    }
	    $ap($tt,xdata) set $x
	    $ap($tt,ydata) set $y
	    $ap($tt,xedata) set $xe
	}

	3 -
	xyey {
	    set x {}
	    set y {}
	    set ye {}
	    for {set i 0} {$i<$l} {incr i 3} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+1]]
		lappend ye [lindex $data [expr $i+2]]
	    }
	    $ap($tt,xdata) set $x
	    $ap($tt,ydata) set $y
	    $ap($tt,yedata) set $ye
	}

	xyexey {
	    set x {}
	    set y {}
	    set xe {}
	    set ye {}
	    for {set i 0} {$i<$l} {incr i 4} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+1]]
		lappend xe [lindex $data [expr $i+2]]
		lappend ye [lindex $data [expr $i+3]]
	    }
	    $ap($tt,xdata) set $x
	    $ap($tt,ydata) set $y
	    $ap($tt,xedata) set $xe
	    $ap($tt,yedata) set $ye
	}

	4.1 {
	    set x {}
	    set y {}
	    set ye {}
	    for {set i 0} {$i<$l} {incr i 4} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+1]]
		lappend ye [lindex $data [expr $i+2]]
	    }
	    $ap($tt,xdata) set $x
	    $ap($tt,ydata) set $y
	    $ap($tt,yedata) set $ye
	}

	4.2 {
	    set x {}
	    set y {}
	    for {set i 0} {$i<$l} {incr i 4} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+3]]
	    }
	    $ap($tt,xdata) set $x
	    $ap($tt,ydata) set $y
	}

	5.1 {
	    set x {}
	    set y {}
	    set ye {}
	    for {set i 0} {$i<$l} {incr i 5} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+1]]
		lappend ye [lindex $data [expr $i+2]]
	    }
	    $ap($tt,xdata) set $x
	    $ap($tt,ydata) set $y
	    $ap($tt,yedata) set $ye
	}

	5.2 {
	    set x {}
	    set y {}
	    set ye {}
	    for {set i 0} {$i<$l} {incr i 5} {
		lappend x [lindex $data $i]
		lappend y [lindex $data [expr $i+3]]
		lappend ye [lindex $data [expr $i+4]]
	    }
	    $ap($tt,xdata) set $x
	    $ap($tt,ydata) set $y
	    $ap($tt,yedata) set $ye
	}

    }

    # set menu options
    set ap($tt,$nn,manage) 1
    set ap($tt,$nn,xdata) $ap($tt,xdata) 
    set ap($tt,$nn,ydata) $ap($tt,ydata) 
    set ap($tt,$nn,xedata) $ap($tt,xedata) 
    set ap($tt,$nn,yedata) $ap($tt,yedata) 

    set ap($tt,$nn,discrete) $ap($tt,discrete) 
    set ap($tt,$nn,discrete,symbol) $ap($tt,discrete,symbol) 
    set ap($tt,$nn,discrete,color) $ap($tt,discrete,color) 

    set ap($tt,$nn,linear) $ap($tt,linear) 
    set ap($tt,$nn,linear,width) $ap($tt,linear,width) 
    set ap($tt,$nn,linear,color) $ap($tt,linear,color) 
    set ap($tt,$nn,linear,dash) $ap($tt,linear,dash) 

    set ap($tt,$nn,step) $ap($tt,step) 
    set ap($tt,$nn,step,width) $ap($tt,step,width) 
    set ap($tt,$nn,step,color) $ap($tt,step,color) 
    set ap($tt,$nn,step,dash) $ap($tt,step,dash) 

    set ap($tt,$nn,quadratic) $ap($tt,quadratic) 
    set ap($tt,$nn,quadratic,width) $ap($tt,quadratic,width) 
    set ap($tt,$nn,quadratic,color) $ap($tt,quadratic,color) 
    set ap($tt,$nn,quadratic,dash) $ap($tt,quadratic,dash) 

    set ap($tt,$nn,error) $ap($tt,error) 
    set ap($tt,$nn,error,width) $ap($tt,error,width) 
    set ap($tt,$nn,error,color) $ap($tt,error,color) 
    set ap($tt,$nn,error,style) $ap($tt,error,style) 

    # update data set menu
    $ap($tt,mb).dataset add radiobutton -label "Data Set $nn" \
	-variable ap($tt,data,current) -value $nn \
	-command "APCurrentData $tt"

    APUpdateGraph $tt
    APUpdateElement $tt
}

proc APExternal {tt} {
    global ap

    # incr count
    incr ap($tt,data,total) 
    set nn $ap($tt,data,total)
    set ap($tt,data,current) $nn

    # set menu options
    set ap($tt,$nn,manage) 0
    set ap($tt,$nn,xdata) $ap($tt,xdata) 
    set ap($tt,$nn,ydata) $ap($tt,ydata) 
    set ap($tt,$nn,xedata) $ap($tt,xedata) 
    set ap($tt,$nn,yedata) $ap($tt,yedata) 

    set ap($tt,$nn,discrete) $ap($tt,discrete) 
    set ap($tt,$nn,discrete,symbol) $ap($tt,discrete,symbol) 
    set ap($tt,$nn,discrete,color) $ap($tt,discrete,color) 

    set ap($tt,$nn,linear) $ap($tt,linear) 
    set ap($tt,$nn,linear,width) $ap($tt,linear,width) 
    set ap($tt,$nn,linear,color) $ap($tt,linear,color) 
    set ap($tt,$nn,linear,dash) $ap($tt,linear,dash) 

    set ap($tt,$nn,step) $ap($tt,step) 
    set ap($tt,$nn,step,width) $ap($tt,step,width) 
    set ap($tt,$nn,step,color) $ap($tt,step,color) 
    set ap($tt,$nn,step,dash) $ap($tt,step,dash) 

    set ap($tt,$nn,quadratic) $ap($tt,quadratic) 
    set ap($tt,$nn,quadratic,width) $ap($tt,quadratic,width) 
    set ap($tt,$nn,quadratic,color) $ap($tt,quadratic,color) 
    set ap($tt,$nn,quadratic,dash) $ap($tt,quadratic,dash) 

    set ap($tt,$nn,error) $ap($tt,error) 
    set ap($tt,$nn,error,width) $ap($tt,error,width) 
    set ap($tt,$nn,error,color) $ap($tt,error,color) 
    set ap($tt,$nn,error,style) $ap($tt,error,style) 

    # update data set menu
    $ap($tt,mb).dataset add radiobutton -label "Data Set $nn" \
	-variable ap($tt,data,current) -value $nn \
	-command "APCurrentData $tt"

    APUpdateGraph $tt
    APUpdateElement $tt
}

proc APUpdateGraph {tt} {
    global ap

    switch -- $ap($tt,grid,log) {
	linearlinear {set xlog false; set ylog false}
	linearlog {set xlog false; set ylog true}
	loglinear {set xlog true; set ylog false}
	loglog {set xlog true; set ylog true}
    }

    if {$ap($tt,graph,x,auto)} {
	set xmin {}
	set xmax {}
    } else {
	set xmin $ap($tt,graph,x,min)
	set xmax $ap($tt,graph,x,max)
    }

    if {$ap($tt,graph,y,auto)} {
	set ymin {}
	set ymax {}
    } else {
	set ymin $ap($tt,graph,y,min)
	set ymax $ap($tt,graph,y,max)
    }

    $ap($tt,graph) configure -plotpadx 0 -plotpady 0 \
	-title $ap($tt,graph,title) \
	-font "$ap($tt,titleFont) $ap($tt,titleSize) $ap($tt,titleStyle)"

    $ap($tt,graph) grid configure -hide [expr !$ap($tt,grid)]

    $ap($tt,graph) xaxis configure -logscale $xlog \
	-min $xmin -max $xmax \
	-title $ap($tt,graph,xaxis) -tickfont \
	"$ap($tt,numlabFont) $ap($tt,numlabSize) $ap($tt,numlabStyle)" \
	-titlefont \
	"$ap($tt,textlabFont) $ap($tt,textlabSize) $ap($tt,textlabStyle)"
    $ap($tt,graph) yaxis configure -logscale $ylog \
	-min $ymin -max $ymax \
	-title $ap($tt,graph,yaxis) -tickfont \
	"$ap($tt,numlabFont) $ap($tt,numlabSize) $ap($tt,numlabStyle)" \
	-titlefont \
	"$ap($tt,textlabFont) $ap($tt,textlabSize) $ap($tt,textlabStyle)"
}

proc APUpdateElement {tt} {
    global ap

    # warning: uses current vars

    if {$ap($tt,data,total) == 0} {
	return
    }

    global $ap($tt,xdata) $ap($tt,ydata) $ap($tt,xedata) $ap($tt,yedata)

    set nn $ap($tt,data,current)
    # create data elements
    foreach el [$ap($tt,graph) element names] {
	set f [split $el -]
	if {[lindex $f 1] == $nn} {
	    $ap($tt,graph) element delete $el
	}
    }

    if {$ap($tt,discrete)} {
	$ap($tt,graph) element create "d1-${nn}" \
	    -linewidth 0 -fill {} -pixels 5 \
	    -xdata $ap($tt,xdata) -ydata $ap($tt,ydata) \
	    -trace increasing \
	    -symbol $ap($tt,discrete,symbol) \
	    -outline $ap($tt,discrete,color) \
	    -color $ap($tt,discrete,color)
    }
    if {$ap($tt,linear)} {
	$ap($tt,graph) element create "d2-${nn}" \
	    -smooth linear -symbol {} \
	    -xdata $ap($tt,xdata) -ydata $ap($tt,ydata) \
	    -trace increasing \
	    -linewidth $ap($tt,linear,width) \
	    -color $ap($tt,linear,color) \
	    -dashes $ap($tt,linear,dash)
    }
    if {$ap($tt,step)} {
	$ap($tt,graph) element create "d3-${nn}" \
	    -smooth step -symbol {} \
	    -xdata $ap($tt,xdata) -ydata $ap($tt,ydata) \
	    -trace increasing \
	    -linewidth $ap($tt,step,width) \
	    -color $ap($tt,step,color) \
	    -dashes $ap($tt,step,dash)
    }
    if {$ap($tt,quadratic)} {
	$ap($tt,graph) element create "d4-${nn}" \
	    -smooth quadratic -symbol {} \
	    -xdata $ap($tt,xdata) -ydata $ap($tt,ydata) \
	    -trace increasing \
	    -linewidth $ap($tt,quadratic,width) \
	    -color $ap($tt,quadratic,color) \
	    -dashes $ap($tt,quadratic,dash)
    }

    # yerror
    if {$ap($tt,error) && 
	[$ap($tt,yedata) length] > 0} {

	set min [expr "$$ap($tt,xdata)\(min\)"]
	set max [expr "$$ap($tt,xdata)\(max\)"]
	set errdelt [expr ($max-$min)*.0125]

	set err1 {}
	set err2 {}
	set err3 {}

	set l [$ap($tt,yedata) length]
	for {set i 0} {$i<$l} {incr i} {
	    set x [expr "$$ap($tt,xdata)\($i\)"]
	    set y [expr "$$ap($tt,ydata)\($i\)"]
	    set e [expr "$$ap($tt,yedata)\($i\)"]

	    append err1  "$x [expr $y-$e] $x [expr $y+$e] "
	    append err2  \
	    "[expr $x+$errdelt] [expr $y+$e] [expr $x-$errdelt] [expr $y+$e] "
	    append err3  \
	    "[expr $x+$errdelt] [expr $y-$e] [expr $x-$errdelt] [expr $y-$e] "
	}

	$ap($tt,graph) element create "err1-${nn}" \
	    -smooth linear -symbol {} \
	    -data $err1 \
	    -trace decreasing \
	    -linewidth $ap($tt,error,width) \
	    -color $ap($tt,error,color)
	if {$ap($tt,error,style)} {
	    $ap($tt,graph) element create "err2-${nn}" \
		-smooth linear -symbol {} \
		-data $err2 \
		-trace decreasing \
		-linewidth $ap($tt,error,width) \
		-color $ap($tt,error,color)
	    $ap($tt,graph) element create "err3-${nn}" \
		-smooth linear -symbol {} \
		-data $err3 \
		-trace decreasing \
		-linewidth $ap($tt,error,width) \
		-color $ap($tt,error,color)
	}
    }

    # xerror
    if {$ap($tt,error) && 
	[$ap($tt,xedata) length] > 0} {

	set min [expr "$$ap($tt,ydata)\(min\)"]
	set max [expr "$$ap($tt,ydata)\(max\)"]
	set errdelt [expr ($max-$min)*.0125]

	set err4 {}
	set err5 {}
	set err6 {}

	set l [$ap($tt,xedata) length]
	for {set i 0} {$i<$l} {incr i} {
	    set x [expr "$$ap($tt,xdata)\($i\)"]
	    set y [expr "$$ap($tt,ydata)\($i\)"]
	    set e [expr "$$ap($tt,xedata)\($i\)"]

	    append err4 "[expr $x+$e] $y [expr $x-$e] $y "
	    append err5 \
	    "[expr $x-$e] [expr $y+$errdelt] [expr $x-$e] [expr $y-$errdelt] "
	    append err6 \
	    "[expr $x+$e] [expr $y+$errdelt] [expr $x+$e] [expr $y-$errdelt] "
	}

	$ap($tt,graph) element create "err4-${nn}" \
	    -smooth linear -symbol {} \
	    -trace decreasing \
	    -data $err4 \
	    -linewidth $ap($tt,error,width) \
	    -color $ap($tt,error,color)
	if {$ap($tt,error,style)} {
	    $ap($tt,graph) element create "err5-${nn}" \
		-smooth linear -symbol {} \
		-data $err5 \
		-trace decreasing \
		-linewidth $ap($tt,error,width) \
		-color $ap($tt,error,color)
	    $ap($tt,graph) element create "err6-${nn}" \
		-smooth linear -symbol {} \
		-data $err6 \
		-trace decreasing \
		-linewidth $ap($tt,error,width) \
		-color $ap($tt,error,color)
	}
    }
}

