.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.14
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "funtext n"
.TH funtext n "August 12, 2005" "version 1.3.0b9" "SAORD Documentation"
.SH "NAME"
\&\fBFuntext: support for column\-based text files\fR
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
This document contains a summary of the options for processing column-based
text files.
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
Funtools will automatically sense and process \*(L"standard\*(R"
column-based text files as if they were \s-1FITS\s0 binary tables without any
change in Funtools syntax. In particular, you can filter text files
using the same syntax as \s-1FITS\s0 binary tables:
.PP
.Vb 3
\&  fundisp foo'[cir 512 512 .1]'
\&  fundisp -T foo
\&  funtable foo'[pha=1:10,cir 512 512 10]' foo.fits
.Ve
.PP
The first example displays a filtered selection of a text file.  The
second example converts a text file to an \s-1RDB\s0 file.  The third example
converts a filtered selection of a text file to a \s-1FITS\s0 binary table.
.PP
Text files can also be used in Funtools image programs. In this case,
you must provide binning parameters (as with raw event files), using
the bincols keyword specifier:
.PP
.Vb 1
\&  bincols=([xname[:tlmin[:tlmax:[binsiz]]]],[yname[:tlmin[:tlmax[:binsiz]]]
.Ve
.PP
For example:
.PP
.Vb 1
\&  funcnts foo'[bincols=(x:1024,y:1024)]' "ann 512 512 0 10 n=10"
.Ve
.PP
\&\fBStandard Text Files\fR
.PP
Standard text files have the following characteristics:
.IP "\(bu" 4
Optional comment lines start with #
.IP "\(bu" 4
Optional blank lines are considered comments
.IP "\(bu" 4
An optional header consists of the following (in order):
.RS 4
.IP "\(bu" 4
a single line of alpha-numeric column names
.IP "\(bu" 4
an optional line of unit strings containing the same number of cols
.IP "\(bu" 4
an optional line of dashes containing the same number of cols
.RE
.RS 4
.RE
.IP "\(bu" 4
Data lines follow the optional header and (for the present) consist of
     the same number of columns as the header.
.IP "\(bu" 4
Standard delimiters such as space, tab, comma, semi\-colon, and bar.
.PP
Examples:
.PP
.Vb 5
\&  # rdb file
\&  foo1  foo2    foo3    foos
\&  ----  ----    ----    ----
\&  1     2.2     3       xxxx
\&  10    20.2    30      yyyy
.Ve
.PP
.Vb 5
\&  # multiple consecutive whitespace and dashes
\&  foo1   foo2    foo3 foos
\&  ---    ----    ---- ----
\&     1    2.2    3    xxxx
\&    10   20.2    30   yyyy
.Ve
.PP
.Vb 2
\&  # comma delims and blank lines
\&  foo1,foo2,foo3,foos
.Ve
.PP
.Vb 2
\&  1,2.2,3,xxxx
\&  10,20.2,30,yyyy
.Ve
.PP
.Vb 4
\&  # bar delims with null values
\&  foo1|foo2|foo3|foos
\&  1||3|xxxx
\&  10|20.2||yyyy
.Ve
.PP
.Vb 3
\&  # header-less data
\&  1     2.2   3 xxxx
\&  10    20.2 30 yyyy
.Ve
.PP
The default set of token delimiters consists of spaces, tabs, commas,
semi\-colons, and vertical bars. Several parsers are tried simultaneously
to analyze a line of text in different ways.  One way of analyzing a
line is to allow a combination of spaces, tabs, and commas to be
squashed into a single delimiter (no null values between consecutive
delimiters). Another way is to allow tab, semi\-colon, and vertical bar
delimiters to support null values, i.e. two consecutive delimiters
implies a null value (e.g. \s-1RDB\s0 file).  A successful parser is one
which returns a consistent number of columns for all rows, with each
column having a consistent data type.  More than one parser can be
successful. For now, it is assumed that they return the same tokens
for a given line (theoretically, there are pathological cases, to be
taken care of later on, maybe). Bad parsers are discarded on the fly.
.PP
If the header does not exist, then names \*(L"col1\*(R", \*(L"col2\*(R", etc.  are
assigned to the columns to allow filtering.  Furthermore, data types
for each column are determined by the data types found in the columns
of the first data line and can be one of the following: string, int,
and double. Thus, all of the above examples return the following
display:
.PP
.Vb 4
\&  fundisp foo'[foo1>5]'
\&        FOO1                  FOO2       FOO3         FOOS
\&  ---------- --------------------- ---------- ------------
\&          10           20.20000000         30         yyyy
.Ve
.PP
\&\fBComments Convert to Header Params\fR
.PP
Comments which precede data rows are converted into header parameters and
will be written out as such using funimage or funhead. Two styles of comments
are recognized:
.PP
1. FITS-style comments have an equal sign \*(L"=\*(R" between the keyword and
value and an optional slash \*(L"/\*(R" to signify a comment. The strict \s-1FITS\s0
rules on column positions are not enforced. In addition, strings only
need to be quoted if they contain whitespace. For example, the following
are valid FITS-style comments:
.PP
.Vb 5
\&  # fits0 = 100
\&  # fits1 = /usr/local/bin
\&  # fits2 = "/usr/local/bin /opt/local/bin"
\&  # fits3c = /usr/local/bin /opt/local/bin /usr/bin
\&  # fits4c = "/usr/local/bin /opt/local/bin" / path dir
.Ve
.PP
Note that the fits3c comment is not quoted and therefore its value is the
single token \*(L"/usr/local/bin\*(R" and the comment is \*(L"opt/local/bin /usr/bin\*(R".
This different from the quoted comment in fits4c.
.PP
2. Free-form comments can have an optional colon separator between the
keyword and value. In the absence of quote, all tokens after the
keyword are part of the value, i.e. no comment is allowed. If a string
is quoted, then slash \*(L"/\*(R" after the string will signify a comment.
For example:
.PP
.Vb 4
\&  # foo1 /usr/local/bin
\&  # foo2 "/usr/local/bin /opt/local/bin"
\&  # foo3 /usr/local/bin /opt/local/bin /usr/bin
\&  # foo4c "/usr/local/bin /opt/local/bin" / path dir
.Ve
.PP
.Vb 4
\&  # goo1: /usr/local/bin
\&  # goo2: "/usr/local/bin /opt/local/bin"
\&  # goo3: /usr/local/bin /opt/local/bin /usr/bin
\&  # goo4c: "/usr/local/bin /opt/local/bin" / path dir
.Ve
.PP
Note that foo3 and goo3 are not quoted, so the whole string is part of
the value, while foo4c and goo4c are quoted and have comments following
the values.
.PP
\&\fBMultiple Tables in a Single File\fR
.PP
Multiple tables are supported in a single file. If an RDB-style file
is sensed, then a ^L will signify end of table. Otherwise, an end of
table is sensed when a new header (i.e., all alphanumeric columns) is
found. Also, for standard parsers, end of table is sensed when a
comment is found, i.e. comments are not mixed with data rows (although
blank lines can be mixed).
.PP
You can access the nth table (starting from 0) in a multi-table file
by enclosing the table number in brackets, as with a \s-1FITS\s0 extension:
.PP
.Vb 1
\&  fundisp foo'[2]'
.Ve
.PP
The above example will display the third table in the file.
.PP
\&\fB\s-1\f(BITEXT\s0()\fB Specifier\fR
.PP
As with \s-1\fIARRAY\s0()\fR and \s-1\fIEVENTS\s0()\fR specifiers for raw image arrays and raw
event lists respectively, you can use the \s-1\fITEXT\s0()\fR on text files to pass
key=value options to the parsers. An empty set of keywords is
equivalent to not having \s-1\fITEXT\s0()\fR at all, that is:
.PP
.Vb 2
\&  fundisp foo
\&  fundisp foo'[TEXT()]'
.Ve
.PP
are equivalent. A multi-table index number is placed inside the \s-1\fITEXT\s0()\fR
specifier as the first token, when indexing into a multi\-table:
.PP
.Vb 1
\&  fundisp foo'[TEXT(2,...)]'
.Ve
.PP
The filter specification is placed after the \s-1\fITEXT\s0()\fR specifier, separated
by a comma, or in an entirely separate bracket:
.PP
.Vb 2
\&  fundisp foo'[TEXT(...),circle 512 512 .1]'
\&  fundisp foo'[TEXT(2,...)][circle 512 512 .1]'
.Ve
.PP
\&\fB\f(BIText()\fB Keyword Options\fR
.PP
The following is a list of keywords that can be used within the \s-1\fITEXT\s0()\fR
specifier (the first three are the most important ones):
.IP "\(bu" 4
delims=\*(L"[delims]\*(R"
.Sp
Specify token delimiters for this file. Only a single parser having these
delimiters will be used to process the file.
.Sp
.Vb 2
\&  fundisp foo.fits'[TEXT(delims="!")]'
\&  fundisp foo.fits'[TEXT(delims="\et%")]'
.Ve
.IP "\(bu" 4
comchars=\*(L"[comchars]\*(R"	
.Sp
Specify comment characters. You must include \*(L"\en\*(R" to allow blank lines.
These comment characters will be used for all standard parsers (unless delims
are also specified).
.Sp
.Vb 1
\&  fundisp foo.fits'[TEXT(comchars="!\en")]'
.Ve
.IP "\(bu" 4
cols=\*(L"[name1:type1 ...]\*(R"
.Sp
Specify names and data type of columns. This overrides header
names and/or data types in the first data row or specified names and
data types for header-less tables.
.Sp
.Vb 1
\&  fundisp foo.fits'[TEXT(cols="x:I,y:I,pha:I,pi:I,time:D,dx:E,dy:e")]'
.Ve
.Sp
If the column specifier is the only keyword, then the cols= is not
required (in analogy with \s-1\fIEVENTS\s0()\fR):
.Sp
.Vb 1
\&  fundisp foo.fits'[TEXT(x:I,y:I,pha:I,pi:I,time:D,dx:E,dy:e)]'
.Ve
.Sp
A index is allowed in this case:
.Sp
.Vb 1
\&  fundisp foo.fits'[TEXT(2,x:I,y:I,pha:I,pi:I,time:D,dx:E,dy:e)]'
.Ve
.IP "\(bu" 4
eot=\*(L"[eot delim]\*(R"
.Sp
Specify end of table string specifier for multi-table files. \s-1RDB\s0
files support ^L. The end of table specifier is a string and the whole
string must be found alone on a line to signify \s-1EOT\s0. For example:
.Sp
.Vb 1
\&  fundisp foo.fits'[TEXT(eot="END")]'
.Ve
.Sp
will end the table when a line contains \*(L"\s-1END\s0\*(R" is found. Multiple lines
are supported, so that:
.Sp
.Vb 1
\&  fundisp foo.fits'[TEXT(eot="END\enGAME")]'
.Ve
.Sp
will end the table when a line contains \*(L"\s-1END\s0\*(R" followed by a line
containing \*(L"\s-1GAME\s0\*(R".
.Sp
In the absence of an \s-1EOT\s0 delimiter, a new table will be sensed when a new
header (all alphanumeric columns) is found.
.IP "\(bu" 4
null1=\*(L"[datatype]\*(R"
.Sp
Specify data type of a single null value in row 1.
Since column data types are determined by the first row, a null value
in that row will result in an error and a request to specify names and
data types using cols=. If you only have a one null in row 1, you don't
need to specify all names and columns. Instead, use null1=\*(L"type\*(R" to
specify its data type.
.IP "\(bu" 4
alen=[n]
.Sp
Specify size in bytes to save for \s-1ASCII\s0 type columns.
\&\s-1FITS\s0 binary tables only support fixed length \s-1ASCII\s0 columns and so a
size value must be specified. The default is 16 bytes.
.IP "\(bu" 4
nullvalues=[\*(L"true\*(R"|\*(L"false\*(R"]
.Sp
Specify whether to expect null values.
Give the parsers a hint as to whether null values should be allowed. The
default is to try to determine this from the data.
.IP "\(bu" 4
whitespace=[\*(L"true\*(R"|\*(L"false\*(R"]
.Sp
Specify whether surrounding white space should be kept as part of
string tokens.  By default surrounding white space is removed from
tokens.
.IP "\(bu" 4
header=[\*(L"true\*(R"|\*(L"false\*(R"]
.Sp
Specify whether to require a header.  This is needed by tables
containing all string columns (and with no row containing dashes), in
order to be able to tell whether the first row is a header or part of
the data. The default is false, meaning that the first row will be
data. If a row dashes are present, the previous row is considered the
column name row.
.IP "\(bu" 4
units=[\*(L"true\*(R"|\*(L"false\*(R"]
.Sp
Specify whether to require a units line.
Give the parsers a hint as to whether a row specifying units should be
allowed. The default is to try to determine this from the data.
.IP "\(bu" 4
i2f=[\*(L"true\*(R"|\*(L"false\*(R"]
.Sp
Specify whether to allow int to float conversions.
If a column in row 1 contains an integer value, the data type for that
column will be set to int. If a subsequent row contains a float in
that column, an error will be signaled. This flag specifies that,
instead of an error, the float should be silently truncated to
int. Usually, you will want an error to be signaled, so that you can
specify the data type using cols= (or by editing the column in row 1).
.IP "\(bu" 4
comeot=[\*(L"true\*(R"|\*(L"false\*(R"|0|1|2]
.Sp
Specify whether comment signifies end of table.
If comeot is 0 or false, then comments do not signify end of table and
can be interspersed with data rows. If the value is true or 1 (the
default for standard parsers), then non-blank lines (e.g. lines
beginning with '#') signify end of table but blanks are allowed
between rows. If the value is 2, then all comments, including blank
lines, signify end of table.
.IP "\(bu" 4
debug=[\*(L"true\*(R"|\*(L"false\*(R"]
.Sp
Specify display debugging information during parsing.
.PP
\&\fBEnvironment Variables\fR
.PP
Environment variables are defined to allow many of these values to be
set without having to include them in \s-1\fITEXT\s0()\fR every time a file is processed:
.PP
.Vb 9
\&  keyword       environment variable
\&  -------       --------------------
\&  delims        TEXT_DELIMS
\&  comchars      TEXT_COMCHARS
\&  cols          TEXT_COLUMNS
\&  eot           TEXT_EOT
\&  null1         TEXT_NULL1
\&  alen          TEXT_ALEN
\&  bincols       TEXT_BINCOLS
.Ve
.PP
\&\fBRestrictions\fR
.PP
As with raw event files, the '+' (copy extensions) specifier is not
supported for programs such as funtable.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
See funtools(n) for a list of Funtools help pages
