// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __frametrue_h__
#define __frametrue_h__

#include "frame.h"

class FrameTrueColor : public Frame {
protected:
  int skipUpdate;

  XImage* colormapXM;      // rotate dest ximage
  Pixmap colormapPM;       // rotate pixmap
  GC colormapGCXOR;        // GC for interactive rotation
  long* colormapData;

  char bgTrueColor_[4];  // bg color encoded
  char nanTrueColor_[4];  // nan color encoded

 private:
  void fillXImage(XImage*, int, int, int, int, double* (FitsImage::*)());
  void fillXImageMosaic(XImage*, int, int, int, int,
			double* (FitsImage::*)());
  void fillXImageMosaicFast(XImage*, int, int, int, int, 
			    double* (FitsImage::*)());

  void colormapBeginSingle(int,int);
  void colormapBeginMosaic(int,int);
  void colormapBeginMosaicFast(int,int);

  void psLevel2Single(PSColorSpace, int, int, float);
  void psLevel2Mosaic(PSColorSpace, int, int, float);
  void psLevel2MosaicFast(PSColorSpace, int, int, float);

  void rotateMotion();

protected:
  virtual void updateColorScale() =0;
  virtual void encodeTrueColor(XColor*,char*) =0;

public:
  FrameTrueColor(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  ~FrameTrueColor();

  void colormapCmd(int, float, float, int, unsigned short*, 
		   unsigned char*, int);
  void colormapBeginCmd();
  void colormapBeginCmd(const Vector&);
  void colormapMotionCmd(int, float, float, int, unsigned short*, 
			 unsigned char*, int);
  void colormapEndCmd(int, float, float, int, unsigned short*, 
		      unsigned char*, int);
  void bgColorCmd(const char*);
  void nanColorCmd(const char*);
};

#endif
