// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __text_h__
#define __text_h__

#include "marker.h"

class Text : public Marker {
 private:
  void render(Drawable, const Matrix&, RenderMode);

 public:
  Text(const Text&);
  Text(FrameBase* p, const Vector& ctr,
       double a,
       const char* clr, int wth, const char* fnt, const char* txt, 
       unsigned short prop, const char* cmt,
       const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new Text(*this);}
  void updateBBox();

  void editBegin(int) {}
  void edit(const Vector& v, int h) {}
  void editEnd() {}

  void ps(int);
  void draw(Drawable);
  void drawXOR();
  void drawMagnifier(const Matrix&);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);
  void listPost(ostream&, CoordSystem, SkyFrame, int);
  void listSAOtng(ostream&, CoordSystem, SkyFrame, SkyFormat, int);
};

#endif
