#! /bin/sh

echo "WCS2 Tests"

echo "Starting DS9..."
if [ `xpaaccess ds9` = no ]; then
    ds9 &

    i=1
    while [ "$i" -le 30 ]
	do
	sleep 2
	if [ `xpaaccess ds9` = yes ]; then
	    break
	fi

	i=`expr $i + 1`
    done
fi

testit () {
    echo "Testing $1"
    xpaset -p ds9 file $1
    xpaset -p ds9 wcs sky fk5
    xpaset -p ds9 align yes
    read
    xpaset -p ds9 wcs sky galactic
    read
    xpaset -p ds9 frame clear
}

# load default image
xpaset -p ds9 grid yes
xpaset -p ds9 wcs skyformat deg

echo "GLON--RA"
testit CAR_model.fits
testit car_01.fits

echo "GLON-CAR"
testit GLM_00350+0115_mosaic_I4_cutout_14706.fits
testit GLM_03350+0000_mosaic_I1_cutout_10617.fits
testit GP_343.5_+0.0_A.fits
testit fermi_counts_gps_bin_1.00.fits
testit gc_energybin07_fadapt10_smajor030.fits
testit gc_energybin07_fadapt10_smajor100.fits
testit msxmapA-1a.fits
testit msxmapA-2.fits

echo "GLON-ZEA"
testit SFD_dust_4096_sgp.fits
testit South_galactic.fits
testit g000p00r2.fits

echo "TNX---RA"
testit 30s_01.fits
testit cal000277b.fits
testit mscred.fits
testit obj094.fits
testit obj269z.fits
testit westphal_Rs.wcs.fits

echo "ZPN---RA"
testit ABELL0586.0750.fits
testit D4.0705.fits
testit EGS1.1193.fits
testit LSSTtest.2124.fits
testit UKIDDS_K_3219_606_17_67_3.fits
testit rcs2_m3.2540.fits

echo "ZPX---RA"
testit E5.3090.fits
testit E5.3075.fits

echo "TAN---RA-SIP"
testit sst.fits

echo "IRAF"
testit obj011.fits
testit oct12_096.4.fits

xpaset -p ds9 quit


