#ifndef IIRSCRAM_ENTITY_DECLARATION_HH
#define IIRSCRAM_ENTITY_DECLARATION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_EntityDeclaration.hh,v 1.3 1999/03/25 02:57:28 tmcbraye Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_EntityDeclaration.hh"

class IIR_Name;

class IIRScram_EntityDeclaration : public IIRBase_EntityDeclaration {

public:
  set<IIR_Declaration> *_find_declarations( IIR_Name * );
  IIR_TypeDefinition *_get_subtype();
  void _make_interface_visible( symbol_table * );

  void _publish_vhdl(ostream &);
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl_binding_name(ostream &);
  void _publish_vhdl_with_library_name(ostream &);
  void _publish_cc();
  void _publish_cc_elaborate();
  void _publish_cc_object_pointers_init();
  void _publish_cc_createNetInfo();
  void _publish_cc_binding_name(ostream& outstream = _cc_out);
  void _publish_cc_class();
  void _publish_cc_headerfile();
  void _publish_cc_ccfile();
  void _publish_cc_component_decl();
  void _publish_cc_headerfiles_for_cc();
  void _publish_cc_constructor();
  void _publish_cc_constructor_with_no_arguments();
  void _publish_cc_constructor_with_arguments();
  void _publish_cc_signal_objects_init();

#ifdef PROCESS_COMBINATION
  void _static_elaborate(IIR_ArchitectureDeclaration*, 
			 IIR_DeclarationList*, char*);
#endif

  IIR_PortList *_get_port_list();
  IIR_GenericList *_get_generic_list();

  IIR_Boolean _is_iir_entity_declaration(){ return TRUE; }
  IIR_Boolean _is_primary_unit(){ return TRUE; }
  IIR_Boolean _is_entity_decl() { return TRUE; }

  void _type_check();
  
protected:
  IIRScram_EntityDeclaration();
  virtual ~IIRScram_EntityDeclaration() = 0;

  declaration_type _get_type();
  IIR_EntityDeclaration* _get_entity();
   
private:
};
#endif


