#ifndef IIRSCRAM_FLOATING_POINT_LITERAL32_HH
#define IIRSCRAM_FLOATING_POINT_LITERAL32_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_FloatingPointLiteral32.hh,v 1.2 1999/03/09 20:54:33 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_FloatingPointLiteral32.hh"

class IIRScram_FloatingPointLiteral32 : public IIRBase_FloatingPointLiteral32 {

// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  void _publish_vhdl(ostream &);
  void _publish_cc();

  IIR_Boolean _is_floating_literal() { return TRUE; }

  IIR *_clone() { return this; }

protected:
  IIRScram_FloatingPointLiteral32() {}
  virtual ~IIRScram_FloatingPointLiteral32() = 0;
    
private:
};
#endif
