// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_IntegerTypeDefinition.cc,v 1.3 1999/08/02 12:50:05 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_IntegerSubtypeDefinition.hh"
#include "IIRScram_IntegerLiteral.hh"
#include "resolution_func.hh"
#include "StandardPackage.hh"

IIRScram_IntegerTypeDefinition::~IIRScram_IntegerTypeDefinition() {}


void 
IIRScram_IntegerTypeDefinition::_publish_cc_data_members() {
}
  
void
IIRScram_IntegerTypeDefinition::_publish_cc_type_info() {
  if (_is_anonymous() == FALSE) {
    _cc_out << "rangeInfo ";
    _publish_cc();
    _cc_out << "_info(";
    get_left()->_publish_cc_value();
    _cc_out << ", ";
    if(get_direction()->_is_ascending_range() == TRUE) {
      _cc_out << "to, ";
    }
    else {
      _cc_out << "downto, ";
    } 
    get_right()->_publish_cc_value();
    _cc_out << ")";
  }
}

void
IIRScram_IntegerTypeDefinition::_publish_cc_extern_type_info() {
  _cc_out << "extern rangeInfo ";
  
  if (_is_anonymous() == FALSE) {
    _publish_cc();
  }
  else {
    ASSERT (_get_base_type() != NULL);
    _get_base_type()->_publish_cc();
  }
  
  _cc_out << "_info;" << endl;
}

void 
IIRScram_IntegerTypeDefinition::_publish_cc_type_string(){
  _cc_out << "IntegerType";
}


void
IIRScram_IntegerTypeDefinition::_publish_cc_decl_cc() {
  _publish_cc_define_type_attributes();
}


void 
IIRScram_IntegerTypeDefinition::_publish_cc_left() {
  get_left()->_publish_cc();
}


void 
IIRScram_IntegerTypeDefinition::_publish_cc_right() {
  get_right()->_publish_cc();
}

void 
IIRScram_IntegerTypeDefinition::_publish_cc_universal_type() {
  _cc_out << "UniversalInteger";
}

void 
IIRScram_IntegerTypeDefinition::_publish_cc_kernel_type() {
  _cc_out << "IntegerType";
}

void 
IIRScram_IntegerTypeDefinition::_publish_cc_attribute_image() {
  _cc_out << "const SavantstringType" << endl;
  _publish_cc_type_name();
  _cc_out << "::IMAGE(const ";
  _publish_cc_base_type_name();
  _cc_out << "& x"
	  << ") {" << endl
	  << "UniversalInteger value;" << endl
	  << " value = x.getObject()->readVal();" << endl
	  << "strstream string;" << endl
	  << "string << value << ends;" << endl
	  << "char* ptr = string.str();" << endl
	  << "SavantstringType image(ObjectBase::VARIABLE,0,to,strlen(ptr)-1, ptr);"
	  << endl
	  << "return image;" << endl
	  << "}" << endl;
}

void 
IIRScram_IntegerTypeDefinition::_publish_cc_attribute_value() {
  _cc_out << "const ";
  _publish_cc_base_type_name();
  _cc_out << endl;
  _publish_cc_type_name();
  _cc_out << "::VALUE(const SavantstringType& x) {" << endl
	  << "int length = x.get_number_of_elements();" << endl
	  << "strstream value;" << endl
	  << "char* ptr;" << endl
	  << "for(int i=0; i < length; i++) {" << endl
	  << "x.get_element(i).print(value);" << endl
	  << "}" << endl
	  << "value << ends;" << endl
	  << "ptr = value.str();" << endl
	  << "int val = atoi(ptr);" << endl;
  _publish_cc_base_type_name();
  _cc_out << " retval(ObjectBase::VARIABLE, val);" << endl
	  << "return retval;" << endl
	  << "}" << endl;
}

IIR_TypeDefinition *
IIRScram_IntegerTypeDefinition::_check_special_compatible( IIR_TypeDefinition *to_check ){
  // Note that it things like array indexes can be subtypes of universal
  // integer so we'll cut to the chase and simply check base types.
  if( to_check->_get_bottom_base_type() == 
      StandardPackage::savant_universal_integer->_get_bottom_base_type() ||
      ( _get_bottom_base_type() == 
	StandardPackage::savant_universal_integer->_get_bottom_base_type()
	&& to_check->_is_integer_type() == TRUE ) ){
    return StandardPackage::savant_universal_integer;
  }
  else{
    return NULL;
  }
}
  
IIR_TypeDefinition *
IIRScram_IntegerTypeDefinition::_get_new_subtype(){
  IIR_TypeDefinition *retval = new IIR_IntegerSubtypeDefinition();
  copy_location( this, retval );
  return retval;
}


void 
IIRScram_IntegerTypeDefinition::_build_implicit_operators( set<IIR_Declaration> *add_to ){
  char *multiplying_operators[] = {"\"*\"", "\"/\"", "\"mod\"", "\"rem\"", NULL };
  IIR_ScalarTypeDefinition::_build_implicit_operators( add_to );
  IIR_TypeDefinition::_build_implicit_operators( multiplying_operators,
						 add_to,
						 this,
						 this,
						 this );

  IIR_TypeDefinition *integer_type = StandardPackage::integer_type;
  IIR_TypeDefinition::_build_implicit_operator( "\"**\"", add_to, this, this, integer_type );  
}
