// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SignalInterfaceDeclaration.cc,v 1.4 1999/06/30 11:33:44 tmcbraye Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_SignalInterfaceDeclaration.hh"
#include "IIR_DesignatorExplicit.hh"
#include "IIR_ConcurrentStatement.hh"
#include "IIR_DesignatorList.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_Attribute.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "error_func.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_SignalInterfaceDeclaration::IIRScram_SignalInterfaceDeclaration() {
  register int i;
  implemented_attributes_in_constructor = new IIR_Boolean[numSignalAttributes];
  implemented_attributes_in_state = new IIR_Boolean[numSignalAttributes];
  implemented_attributes_in_initstate = new IIR_Boolean[numSignalAttributes];
  for(i = 0; i < numSignalAttributes; i++) {
    implemented_attributes_in_constructor[i] = FALSE;
    implemented_attributes_in_state[i] = FALSE;
    implemented_attributes_in_initstate[i] = FALSE;
  }
  _my_clone = NULL;
  _driver_addition_flag = FALSE;
}


IIRScram_SignalInterfaceDeclaration::~IIRScram_SignalInterfaceDeclaration() {
  delete [] implemented_attributes_in_constructor;
  delete [] implemented_attributes_in_state;
  delete [] implemented_attributes_in_initstate;
}

void 
IIRScram_SignalInterfaceDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << " signal ";
  IIRScram_ObjectDeclaration::_publish_vhdl_declarator_with_colon(_vhdl_out);
  _publish_vhdl_mode(_vhdl_out);
  _publish_vhdl_subtype_indication(_vhdl_out);
  _publish_vhdl_signal_kind(_vhdl_out);
  _publish_vhdl_expression(_vhdl_out);
}

IIR_SignalKind
IIRScram_SignalInterfaceDeclaration::_get_signal_kind()
{
  return get_signal_kind();
}

void
IIRScram_SignalInterfaceDeclaration::_publish_cc_elaborate() {
  //  _cc_out << "SigInfo ";
  _get_declarator()->_publish_cc_elaborate();
  _cc_out << "_info";
  //  _cc_out << "_info;\n";
}


void
IIRScram_SignalInterfaceDeclaration::_publish_cc_type_name() {
  get_subtype()->_publish_cc_type_name();
}


IIRScram_Declaration::declaration_type 
IIRScram_SignalInterfaceDeclaration::_get_type(){
  return INTERFACE_SIGNAL;
}


void
IIRScram_SignalInterfaceDeclaration::_publish_cc_sigdest() {
  ASSERT( cgen_sym_tab_ptr != NULL );
  ASSERT( get_declarator()->get_kind() == IIR_IDENTIFIER );

  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  // _cc_out << "state.current->" << *get_declarator();
  _cc_out << "sate.current->";
  _get_declarator()->_publish_cc();
}


void 
IIRScram_SignalInterfaceDeclaration::_publish_cc_decl() {
  if(_is_implicit_declaration()) {
    _get_attribute_name()->_publish_cc_necessary_decl_in_state();
  }
  else {
    if (get_subtype()->_is_scalar_type() == TRUE) {
      get_subtype()->_publish_cc_kernel_type();
    }
    else {
      get_subtype()->_publish_cc();
    }
    _cc_out << " " << *_get_declarator();
    _cc_out << ";" << endl;
  }
}


void
IIRScram_SignalInterfaceDeclaration::_publish_cc_init() {
  //#### yet to handle composite types.  Will be solved eventually
  char *procname;
  char* anothername = _current_another_name;
  IIR* temporaryNode = _current_publish_node;
  IIR_ConcurrentStatement* tempConcStmt;
  IIR_Declaration* tempDecl = NULL;
  // since c_p_n is changed here, it must be reset before returning
  procname = _current_publish_name;
  ostrstream labelstr;
  ostrstream signalNetinfostr;
  int index = 0;
  IIR_Boolean last_activeAttribRequired = false;
  IIR_Boolean last_eventAttribRequired = false;
  IIR_Boolean last_activeAttribPresent = false;
  IIR_Boolean last_eventAttribPresent = false;
  IIR_Declaration* implied_declarations = NULL;
  
  //Reset the index counter since, a new signal interface declaration
  //is initialized
  _index_level =0;

  if( _get_implicit_declarations() != NULL ){
    implied_declarations = _get_implicit_declarations()->get_element();
    while(implied_declarations != NULL) {
      if(cgen_sym_tab_ptr->in_scope(implied_declarations)) {
	switch(implied_declarations->get_kind()) {
	case IIR_SIGNAL_DECLARATION:
	case IIR_SIGNAL_INTERFACE_DECLARATION:
	  implied_declarations->_set_declarative_region(_get_declarative_region());
	  implied_declarations->_publish_cc_init_signal(); 
	  break;
	case IIR_FUNCTION_DECLARATION:
	  //	  implied_declarations->_publish_cc_init_function(); 
	  break;
	default:
	  cerr << "Unknown declaration initialization: "
	       << implied_declarations->get_kind_text() << endl;
	  break;
	}

	// Count the number of attributes of this signal
	index++;

	switch(implied_declarations->_get_attribute_name()->get_kind()) {
	case IIR_QUIET_ATTRIBUTE:
	case IIR_ACTIVE_ATTRIBUTE:
	  last_activeAttribRequired = true;
	  break;
	case IIR_STABLE_ATTRIBUTE:
	case IIR_EVENT_ATTRIBUTE:
	  last_eventAttribRequired = true;
	  break;
	case IIR_LAST_ACTIVE_ATTRIBUTE:
	    last_activeAttribPresent = true;
	    break;
	case IIR_LAST_EVENT_ATTRIBUTE:
	  last_eventAttribPresent = true;
	}
      }
      implied_declarations = _get_implicit_declarations()->get_next_element();
    }
  }

  // Implementation of the QIUET, STABLE, ACTIVE and EVENT attributes
  // require last_active or last_event attribute.  This will be declared
  // transparent to the user.  This is why index is incremented by one here.
  // CAUTION: However, this must not be done if last_active or last_event is
  // already declared in the process.
  if(last_activeAttribRequired == TRUE &&
     last_activeAttribPresent == FALSE) {
    index++;
  }
  if(last_eventAttribRequired == TRUE &&
     last_eventAttribPresent == FALSE) {
    index++;
  }

  _get_declarator()->_print(labelstr);
  labelstr << ends;
  _current_publish_name = labelstr.str();

 if ( _is_implicit_declaration() != TRUE ) {
    ASSERT ( _get_declarative_region() != NULL );
    
    if ((_current_publish_node != NULL) && ( _current_publish_node->_is_concurrent_statement() == TRUE )) {
      tempConcStmt = (IIR_ConcurrentStatement *) _current_publish_node;
      ASSERT ( tempConcStmt->_is_concurrent_statement() == TRUE );
      
      tempConcStmt->_publish_cc_scoping_prefix(_get_declarative_region(), _current_publish_node, signalNetinfostr);
    }
  }
  else {
    ASSERT ( _get_signal_decl()->_is_iir_declaration() == TRUE );
    tempDecl = (IIR_Declaration *) _get_signal_decl();
    ASSERT ( tempDecl->_is_iir_declaration() == TRUE );
    
    if ((_current_publish_node != NULL) && ( _current_publish_node->_is_concurrent_statement() == TRUE )) {
      tempConcStmt = (IIR_ConcurrentStatement *) _current_publish_node;
      ASSERT ( tempConcStmt->_is_concurrent_statement() == TRUE );
      
      tempConcStmt->_publish_cc_scoping_prefix(tempDecl->_get_declarative_region(), this, signalNetinfostr);
    }
  }


  _current_publish_node = this;
  _get_declarator()->_print(signalNetinfostr);
  signalNetinfostr << "_info" << ends;
  _current_another_name = signalNetinfostr.str();
  _cc_out << "{\n";//begin dummy block for scoping
  _cc_out << "  " << _current_publish_name << ".setElaborationInfo(";
  if((_get_declarative_region()->_is_iir_package_declaration() == FALSE) &&
     (_get_declarative_region()->get_kind() != IIR_PACKAGE_BODY_DECLARATION)) {
    _cc_out << "proc->" ;
  }
  _cc_out << _current_another_name << ");\n";

  // publish attributes for this signal
  if(index > 0) {
    ASSERT( _get_implicit_declarations() != NULL );
    
    _cc_out << "  " << _current_publish_name <<".setNumAttributes("
	    << index << ");\n";

    implied_declarations = _get_implicit_declarations()->get_element();

    while(implied_declarations != NULL) {
      if(cgen_sym_tab_ptr->in_scope(implied_declarations)) {
	_cc_out << "  " << _current_publish_name <<".setAttrib" << "(";
	implied_declarations->_get_attribute_name()->_publish_cc_name_in_caps();
	_cc_out << ", ";
	
	if (implied_declarations->_get_attribute_name() != NULL) {
	  implied_declarations->_get_attribute_name()->_publish_cc_declarator();
	}
	else {
	  implied_declarations->_get_declarator()->_publish_cc();
	}
	_cc_out << ");\n";
      }
      implied_declarations = _get_implicit_declarations()->get_next_element();
    }

    if(last_activeAttribRequired == TRUE && 
       last_activeAttribPresent == FALSE) {
      _cc_out << "  " << _current_publish_name <<".setAttrib" << "(";
      _cc_out << "LAST_ACTIVE, ";
      ASSERT(_current_publish_node->_is_signal() == true);
      _current_publish_node->_get_declarator()->_publish_cc();
      _cc_out << "_last_active);\n";
      
      last_activeAttribPresent = TRUE;
    }
    
    if(last_eventAttribRequired == TRUE && 
       last_eventAttribPresent == FALSE) {
      _cc_out << "  " << _current_publish_name <<".setAttrib" << "(";
      _cc_out << "LAST_EVENT, ";
      
      ASSERT(_current_publish_node->_is_signal() == true);
      
      // This function takes care of publishing last events
      // properly for the corresponding types

      _current_publish_node->_get_declarator()->_publish_cc();
      _cc_out << "_last_event);\n";

      last_eventAttribPresent = TRUE;
    }
  }

  if ( _is_implicit_declaration() == FALSE ){
    _cc_out << "  " << _current_publish_name <<
      ".resolveAndUpdate(processPointer);\n";
  }
  
  //  get_subtype()->_publish_cc_init_signal();
  _cc_out << "};\n";//end dummy block
  _current_publish_name = procname;
  _current_publish_node = temporaryNode;
  _current_another_name = anothername;
}


void
IIRScram_SignalInterfaceDeclaration::_publish_cc_data() {
  //  _cc_out << "state.current->" << *get_declarator();
  _cc_out << "state->current->";
  _get_declarator()->_publish_cc();
}


void 
IIRScram_SignalInterfaceDeclaration::_publish_cc() {
  ASSERT( cgen_sym_tab_ptr != NULL );
  ASSERT( get_declarator()->get_kind() == IIR_IDENTIFIER );

  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  IIRScram_Declaration::_set_scoping_prefix();
  IIRScram::_publish_cc_prefix_string();
  _get_declarator()->_publish_cc();
  IIRScram_Declaration::_reset_scoping_prefix();
}



void
IIRScram_SignalInterfaceDeclaration::_publish_cc_wait_data() {
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  //_cc_out << "s->" << *get_declarator();
  _cc_out << "s->";
  _get_declarator()->_publish_cc();
}



void
IIRScram_SignalInterfaceDeclaration::_publish_cc_state_object_init() {
  _get_declarator()->_publish_cc();
  _publish_cc_constructor_args();
  _cc_out << ", ";
}


void
IIRScram_SignalInterfaceDeclaration::_publish_cc_object_type() {
  _cc_out << "SIGNAL";
}

IIR*
IIRScram_SignalInterfaceDeclaration::_clone() {
  if (_my_clone == NULL) {
    _my_clone = new IIR_SignalInterfaceDeclaration();
    IIRScram_Declaration::_clone(_my_clone);
    _my_clone->_set_driver_addition_flag(_have_added_driver());
    _my_clone->set_subtype(get_subtype());
    _my_clone->set_value(get_value());
    _my_clone->set_signal_kind(get_signal_kind());
    _my_clone->attributes = attributes;
  }
  return _my_clone;
}

void 
IIRScram_SignalInterfaceDeclaration::_type_check( IIRScram_InterfaceDeclaration::_InterfaceListType list_type ){
  IIR_InterfaceDeclaration::_type_check();

  if( get_subtype()->_is_access_type() == TRUE || get_subtype()->_is_file_type() == TRUE ){
    ostrstream err;
    err << "Signal interface declaration |" << *get_declarator() << "| must have a subtype "
	<< "indication that defines a subtype that is neither an access type or a file type." 
	<< ends;
    report_error( this, err );
  }

  if(list_type == IIRScram_InterfaceDeclaration::PARAMETER_INTERFACE_LIST && get_value() != NULL){
    ostrstream err;
    err << "Formal signal parameter |" << *get_declarator() << "| may not have a default "
	<< "value specified." << ends;
    report_error( this, err );
  }
}
