#ifndef IIRSCRAM_STRING_HH
#define IIRSCRAM_STRING_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_String.hh,v 1.2 1999/03/09 20:56:46 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include <strstream.h>

class IIRScram_String {
public:
  IIRScram_String(){};
  ~IIRScram_String(){
    cout << "String being deleted!\n";
  };
  
  void 
  set_key( char *new_text, int new_length ){
    my_text = new char[new_length];
    memcpy( my_text, new_text, new_length );

    my_length = new_length;
  }

  int
  test_key( char *compare_text, int compare_length ){
    if( compare_length != my_length ){
      if( compare_length < my_length ){
	return -1;
      }
      else{
	return 1;
      }
    }
    
    // Their sizes are equal
    return memcmp( my_text, compare_text, compare_length );
  }

  IIR_Char *get_text(){
    return my_text;
  }

  int get_text_length(){
    return my_length;
  }

  IIR_Char &operator[]( int offset ){
    if( offset > get_text_length() ){
      cerr << "Out of bounds access in IIRScram_String!" << endl;
      abort();
    }
    return my_text[ offset ];
  }

  IIR_Char *_convert_to_c_string(){
    ostrstream outstream;
    int i;

    for( i = 0; i < my_length; i++ ){
      if( my_text[i] == '\0' ){
	outstream << "NULL";
      }
      else{
	if(my_text[i] == '"') {
	  outstream << "\\";
	}
	outstream << my_text[i];
      }
    }

    outstream << ends;

    return outstream.str();
  }

private:
  IIR_Char *my_text;
  int my_length;
};
#endif
