
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_TypeConversion.cc,v 1.3 1999/09/22 00:38:52 tmcbraye Exp $
// 
//---------------------------------------------------------------------------
#include "set.hh"
#include "IIRScram_TypeConversion.hh"
#include "IIR_AssociationElementByExpression.hh"
#include "IIR_ArrayTypeDefinition.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_AssociationList.hh"

IIRScram_TypeConversion::~IIRScram_TypeConversion(){}

void 
IIRScram_TypeConversion::_publish_vhdl(ostream &_vhdl_out) {
  get_type_mark()->_get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "(";
  get_expression()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ")";
}

void
IIRScram_TypeConversion::_publish_cc_headers() {
  _cc_out << "#include \"";
  get_type_mark()->_publish_cc_type_name();
  _cc_out << ".hh\"\n";
}

void
IIRScram_TypeConversion::_publish_cc(){
  if(get_type_mark()->_is_scalar_type() == TRUE) {
    get_type_mark()->_publish_cc_type_name();
    _cc_out << "(";
    _cc_out << "ObjectBase::VARIABLE, ";
    get_type_mark()->_publish_cc_universal_type();
    _cc_out << "::typeCast(((";
    get_expression()->_get_subtype()->_publish_cc_universal_type();
    _cc_out << " &)";
    get_expression()->_publish_cc();
    _cc_out << ".getVHDLData()))";
    get_type_mark()->_publish_cc_object_type_info();
    _cc_out << ")";
  }
  else if(get_type_mark()->_is_array_type() == TRUE) {
    IIR_ArrayTypeDefinition* type_def = (IIR_ArrayTypeDefinition*)get_type_mark();
    type_def->_publish_cc_type_name();
    _cc_out << "(ObjectBase::VARIABLE";
    _cc_out << ", ";
    _cc_out << "(";
    type_def->_publish_cc_type_name();    
    _cc_out << " &)";
    get_expression()->_publish_cc();
    _cc_out << ")";
  }
  else {
    get_expression()->_publish_cc();
  }
}


void
IIRScram_TypeConversion::_publish_cc_initialization_value(){
  _publish_cc();
}

void
IIRScram_TypeConversion::_get_list_of_input_signals(set<IIR_Declaration>* list){
  get_expression()->_get_list_of_input_signals(list);
}

void
IIRScram_TypeConversion::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  get_expression()->_build_sensitivity_list(sensitivity_list);
}

ostream & 
IIRScram_TypeConversion::_print( ostream &os ) {
  os << *get_type_mark();
  os << " ( ";
  os << *get_expression();
  os << " ) ";
  
  return os;
}
 
IIR_Boolean
IIRScram_TypeConversion::_is_resolved(){
  IIR_Boolean retval = TRUE;
  if( get_type_mark()->_is_resolved() == FALSE || get_expression()->_is_resolved() == FALSE ){
    retval = FALSE;
  }

  return retval;
}

IIR_TypeDefinition *
IIRScram_TypeConversion::_get_subtype(){
  return get_type_mark();
}


set<IIR_TypeDefinition> *
IIRScram_TypeConversion::_get_rval_set(IIR_Boolean (IIR::*constraint_function)() ){
  return new set<IIR_TypeDefinition>(_get_subtype());
}

IIR_Declaration *
IIRScram_TypeConversion::_find_formal_declaration(){
  ASSERT( _is_resolved() == TRUE );
  ASSERT( get_expression() != NULL );
  ASSERT( get_expression()->get_kind() != IIR_ASSOCIATION_LIST || 
	  ((IIR_AssociationList *)get_expression())->num_elements() == 1 );
  ASSERT( get_type_mark() != NULL );
  return get_type_mark()->_find_formal_declaration();
}

IIR_Boolean 
IIRScram_TypeConversion::_is_locally_static_primary(){
  ASSERT( get_expression() != NULL );
  ASSERT( get_expression()->_is_resolved() == TRUE );

  return get_expression()->_is_locally_static();
}

IIR_Boolean 
IIRScram_TypeConversion::_is_globally_static_primary(){
  ASSERT( get_expression() != NULL );
  ASSERT( get_expression()->_is_resolved() == TRUE );

  return get_expression()->_is_globally_static();
}
