#ifndef IIRSCRAM_WHILE_LOOP_STATEMENT_HH
#define IIRSCRAM_WHILE_LOOP_STATEMENT_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_WhileLoopStatement.hh,v 1.2 1999/03/09 20:57:16 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_WhileLoopStatement.hh"
class IIR_DesignatorList;
class IIR_List;
template <class type> class set;

class IIRScram_WhileLoopStatement : public IIRBase_WhileLoopStatement {
// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  void _publish_vhdl(ostream &);

  void _publish_cc();
  void _publish_cc_decl_for_loop_iterator();

  void _type_check();
  void _get_list_of_input_signals(set<IIR_Declaration>* list);
  void _get_signal_source_info(set<IIR_Declaration>* siginfo);
  void _build_wait_list(dl_list<IIRScram_WaitStatement>* );
  void _build_procedure_call_stmt_list(dl_list<IIR_ProcedureCallStatement> *);
  IIR_Boolean _type_check_return_statements( set<IIR_TypeDefinition> *,
					     IIR_SubprogramDeclaration *subprogram_decl );
  
  IIR_Boolean _has_statement_list() { return TRUE; }
  IIR *_clone();

protected:
  IIRScram_WhileLoopStatement() {}
  virtual ~IIRScram_WhileLoopStatement() = 0;
    
private:
};
#endif
