// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_InterfaceList.hh"
#include "IIR_InterfaceDeclaration.hh"

IIRBase_InterfaceList::IIRBase_InterfaceList() {}
IIRBase_InterfaceList::~IIRBase_InterfaceList() {}


IIR_InterfaceDeclaration* 
IIRBase_InterfaceList::first() {
  IIR_Declaration *element = IIR_DeclarationList::first();

  ASSERT( element == NULL || element->_is_interface() == TRUE );

  return (IIR_InterfaceDeclaration *)element;
}


IIR_InterfaceDeclaration*
IIRBase_InterfaceList::successor(IIR_InterfaceDeclaration* node) {
  IIR_Declaration *element = IIR_DeclarationList::successor( node );

  ASSERT( element == NULL || element->_is_interface() == TRUE );

  return (IIR_InterfaceDeclaration*)element;
}


IIR_InterfaceDeclaration *
IIRBase_InterfaceList::get_nth_element( IIR_Int32 position ){
  IIR_Declaration *element = IIR_DeclarationList::get_nth_element( position );

  ASSERT( element == NULL || element->_is_interface() == TRUE );

  return (IIR_InterfaceDeclaration*)element;  
}


void
IIRBase_InterfaceList::prepend( IIR_InterfaceDeclaration *element ) {
  
  ASSERT( element->_is_interface() == TRUE ); 

  IIR_DeclarationList::prepend( element );
}


void
IIRBase_InterfaceList::append( IIR_InterfaceDeclaration *element ) {

  ASSERT( element->_is_interface() == TRUE );
  
  IIR_DeclarationList::append( element );
}


void 
IIRBase_InterfaceList::insert_after( IIR_InterfaceDeclaration* existing_element,
				     IIR_InterfaceDeclaration* new_element) {

  ASSERT( existing_element->_is_interface() == TRUE );
  ASSERT( new_element->_is_interface() == TRUE );
  
  IIR_DeclarationList::insert_after( existing_element, new_element );
}

IIR_InterfaceDeclaration*
IIRBase_InterfaceList::predecessor( IIR_InterfaceDeclaration *element ){
  ASSERT( element->_is_interface() == TRUE );
  
  IIR_Declaration *retval = IIR_DeclarationList::predecessor( element );

  ASSERT( retval->_is_interface() == TRUE );
  
  return (IIR_InterfaceDeclaration*)retval;
}

IIR_InterfaceDeclaration*
IIRBase_InterfaceList::last() {
  IIR_Declaration *retval = IIR_DeclarationList::last( );

  ASSERT( retval->_is_interface() == TRUE );

  return (IIR_InterfaceDeclaration*)retval;
}


IIR_Int32
IIRBase_InterfaceList::get_position( IIR_InterfaceDeclaration *element ) {
  ASSERT( element->_is_interface() == TRUE );
  return IIR_DeclarationList::get_position( element );
}
