
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Author: Sivakumar Gowrisankar             gowriss@ececs.uc.edu

#include "IIRBase_TypeDefinition.hh"
#include "IIRScram.hh"
#include "IIRScram_ArrayNatureDefinition.hh"
#include "IIR_NatureDeclaration.hh"
#include "IIR_ArraySubnatureDefinition.hh"
#include "IIR_ArrayNatureDefinition.hh"
#include "IIR_ScalarNatureDefinition.hh"
#include "IIR_RangeTypeDefinition.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "published_file.hh"
#include "published_header_file.hh"
#include "published_cc_file.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "StandardPackage.hh"

extern symbol_table sym_tab;

IIRScram_ArrayNatureDefinition::IIRScram_ArrayNatureDefinition(){
  set_index_subtype(NULL);
  set_element_subtype(NULL);
}

IIRScram_ArrayNatureDefinition::~IIRScram_ArrayNatureDefinition() {}

void
IIRScram_ArrayNatureDefinition::_publish_vhdl_decl(ostream &_vhdl_out) {
  IIR_TypeDefinition *node = this;
  int max_index = _get_num_indexes();

  ASSERT(get_element_subtype() != NULL);
  ASSERT(_get_index_subtype() != NULL);

  _vhdl_out << "array (";

  node = this;
  while ((node->_is_array_type() == TRUE) && (max_index > 0)) {
    node->_get_index_subtype()->_publish_vhdl_index(_vhdl_out);
    max_index--;
    node =  node->_get_element_subtype();
    if (max_index > 0) {
      _vhdl_out << ", ";
      ASSERT ( node != NULL );
    }
  }

  ASSERT ( node != NULL );
  _vhdl_out << ") of ";
  node->_publish_vhdl(_vhdl_out);
}

void
IIRScram_ArrayNatureDefinition::_publish_vhdl(ostream &_vhdl_out){
  ASSERT( _get_declaration() != NULL );
  _get_declaration()->_publish_vhdl(_vhdl_out);
}

void IIRScram_ArrayNatureDefinition::_publish_cc_lvalue(){}

void IIRScram_ArrayNatureDefinition::_publish_cc_ams(){}

void
IIRScram_ArrayNatureDefinition::_publish_vhdl_subtype_decl(ostream &_vhdl_out){
  if( _is_anonymous() == FALSE ){
    if( _get_type_mark() != NULL ){
      _get_type_mark()->_get_declaration()->get_declarator()->_publish_vhdl(_vhdl_out);
    }
    else {
      _get_declaration()->get_declarator()->_publish_vhdl(_vhdl_out);
    }
  }
  else {
    _publish_vhdl_decl(_vhdl_out);
  }
}

IIR_Boolean 
IIRScram_ArrayNatureDefinition::_is_unconstrained_array_type(){
  IIR_ScalarTypeDefinition *index = get_index_subtype();
  ASSERT(index != NULL);
  if( index->get_left() == NULL ){
    ASSERT( index->get_right() == NULL );
    ASSERT( index->get_direction() == NULL );
    return TRUE;
  }
  else{
    return FALSE;
  }
}

IIR_ArrayNatureDefinition *
IIRScram_ArrayNatureDefinition::_construct_array_type( IIR_ScalarTypeDefinition *index_subtype,
                                                       IIR_NatureDefinition *element_subtype,
                                                       IIR_NatureDeclaration *declaration ){
  if( index_subtype->get_left() == NULL ){
    return _construct_unconstrained( index_subtype, element_subtype, declaration );
  }
  else{
    return _construct_constrained( index_subtype, element_subtype, declaration );
  }

}

IIR_ArraySubnatureDefinition *
IIRScram_ArrayNatureDefinition::_construct_unconstrained( IIR_ScalarTypeDefinition *index_subtype,
                                                          IIR_NatureDefinition *element_subtype,
                                                          IIR_NatureDeclaration *declaration ){

  IIR_ArrayNatureDefinition *base_type = new IIR_ArrayNatureDefinition();
  copy_location( index_subtype, base_type );
 
  ASSERT( index_subtype->get_left() == NULL );
  ASSERT( index_subtype->get_direction() == NULL );
  ASSERT( index_subtype->get_right() == NULL );
 
  base_type->set_index_subtype( index_subtype );
  base_type->set_element_subtype( element_subtype );
  base_type->_set_declaration( declaration );
  IIR_NatureDefinition *temp =  base_type->_construct_new_subtype( 0, 0 );
  ASSERT( temp->get_kind() == IIR_ARRAY_SUBNATURE_DEFINITION );
 
  IIR_ArraySubnatureDefinition *retval = (IIR_ArraySubnatureDefinition *)temp;
  retval->_set_declaration( declaration );
  return retval;
}

IIR_ArraySubnatureDefinition *
IIRScram_ArrayNatureDefinition::_construct_constrained( IIR_ScalarTypeDefinition *index_subtype,
                                                        IIR_NatureDefinition *element_subtype,
                                                        IIR_NatureDeclaration *declaration ){

  IIR_ArrayNatureDefinition *base_type = new IIR_ArrayNatureDefinition();
  copy_location( index_subtype, base_type );

  IIR_TypeDefinition *base_index_type;
  base_index_type = index_subtype->_get_new_subtype();
  base_index_type->set_base_type( index_subtype->get_base_type() );
  base_index_type->_set_resolution_function( index_subtype->_get_resolution_function() );
  base_index_type->_set_type_mark( index_subtype );
  base_index_type->_set_declaration( index_subtype->_get_declaration() );
  ASSERT( base_index_type->_is_iir_scalar_type_definition() == TRUE );
  base_type->_set_index_subtype( (IIR_ScalarTypeDefinition *)base_index_type );
  base_type->_get_index_subtype()->_set_type_mark( index_subtype );

  IIR_NatureDefinition *temp =  base_type->_construct_new_subtype( 0, index_subtype );
  ASSERT( temp->get_kind() == IIR_ARRAY_SUBNATURE_DEFINITION );

  IIR_ArraySubnatureDefinition *retval = (IIR_ArraySubnatureDefinition *)temp;
  base_type->_set_type_mark( retval );
  base_type->_set_declaration( declaration );
  retval->_set_declaration( declaration );

  return retval;
}

IIR_NatureDefinition *
IIRScram_ArrayNatureDefinition::_index_constrain_array( IIR_ScalarTypeDefinition *constraint ){
#ifdef DEVELOPER_ASSERTIONS
  IIR_TypeDefinition *original_index_subtype = _get_index_subtype();
#endif

  IIR_ArraySubnatureDefinition *retval = NULL;
  IIR_TypeDefinition *current_index_type = _get_index_subtype();
  current_index_type = current_index_type->_construct_new_subtype( NULL, constraint);
  if( constraint->_is_subtype() == FALSE && constraint->_is_anonymous() == FALSE ){
    current_index_type->_set_type_mark( constraint );
  }
  else{
    current_index_type->_set_type_mark( constraint->_get_type_mark() );
  }
  current_index_type->_set_declaration( constraint->_get_declaration() );
  retval = new IIR_ArraySubnatureDefinition();
  copy_location( constraint, retval );

  ASSERT( current_index_type->_is_scalar_type() == TRUE );
  retval->_set_index_subtype( (IIR_ScalarTypeDefinition *)current_index_type );

  if( _is_subtype() == TRUE ){
    retval->set_base_type( get_base_type() );
  }
  else{
    retval->set_base_type( this );
  }

  ASSERT( original_index_subtype == _get_index_subtype() );

  return retval;
}

IIR_NatureDefinition *
IIRScram_ArrayNatureDefinition::_construct_new_subtype( IIR_Name *,
                                                        IIR_ScalarTypeDefinition *index_constraint ){
  IIR_NatureDefinition *retval = NULL;

  if( index_constraint != NULL ){
    retval = _index_constrain_array( index_constraint );
    retval->_set_element_subtype( _get_element_subtype() );
  }

  if( retval == NULL ){
    retval = _get_new_subtype();
    ASSERT( retval->_is_iir_array_type_definition() == TRUE );
    _clone( (IIR_ArrayNatureDefinition *)retval );
    if( _is_subtype() ){
      retval->set_base_type( get_base_type() );
    }
    else{
      retval->set_base_type( this );
    }
  }
  return retval;
}

IIR_NatureDefinition *
IIRScram_ArrayNatureDefinition::_get_element_subtype(){
  return get_element_subtype();
}

IIR_ScalarTypeDefinition *
IIRScram_ArrayNatureDefinition::_get_index_subtype(){
  return get_index_subtype();
}
 
void
IIRScram_ArrayNatureDefinition::_set_element_subtype( IIR_NatureDefinition *new_element_type ){
  set_element_subtype( new_element_type );
}
 
void
IIRScram_ArrayNatureDefinition::_set_index_subtype( IIR_ScalarTypeDefinition *new_index_type ){
  set_index_subtype( new_index_type );
}

IIR_NatureDefinition *
IIRScram_ArrayNatureDefinition::_get_new_subtype(){
  IIR_NatureDefinition *retval = new IIR_ArraySubnatureDefinition();
  copy_location( this, retval );
  return retval;
}

IIR *
IIRScram_ArrayNatureDefinition::_clone(){
  IIR_ArrayNatureDefinition *type_def = new IIR_ArrayNatureDefinition();
  _clone( type_def );

  return type_def;
}

void
IIRScram_ArrayNatureDefinition::_clone( IIR *my_clone ){
  ASSERT( my_clone->_is_iir_array_type_definition() == TRUE );
  IIR_ArrayNatureDefinition *as_array_type = (IIR_ArrayNatureDefinition *)my_clone;

  as_array_type->set_index_subtype( get_index_subtype() );
  as_array_type->set_element_subtype( get_element_subtype() );

  IIR_TypeDefinition::_clone( my_clone );
}

IIR_Int32
IIRScram_ArrayNatureDefinition::_get_num_indexes() {
  IIR_Int32 num_indexes = 1;

  IIR_TypeDefinition *current_subtype = get_element_subtype();
  ASSERT(current_subtype != NULL);
  while( current_subtype->_is_array_type() == TRUE
         && current_subtype->_is_element() == FALSE ){
    num_indexes++;
    current_subtype = current_subtype->_get_element_subtype();
    ASSERT(current_subtype != NULL);
  }

  return num_indexes;
}

IIR_TypeDefinition*
IIRScram_ArrayNatureDefinition::_get_final_subtype() {

  IIR_TypeDefinition* node = get_element_subtype();
  while ( (node->get_kind() == IIR_ARRAY_NATURE_DEFINITION ||
           node->get_kind() == IIR_ARRAY_SUBNATURE_DEFINITION) &&
          node->_is_element() == false ){
    node =  node->_get_element_subtype();
  }
  return node;
}

void
IIRScram_ArrayNatureDefinition::_publish_cc_lvalue( published_file &_cc_out ) {
  _cc_out.get_stream() << "Savant"
		      << *_get_declarator()
		      << "Type";
}

void
IIRScram_ArrayNatureDefinition::_publish_cc_type_info( published_file &_cc_out ) {
  _publish_cc_type_info( _cc_out, NULL, NULL );

  if( _get_currently_publishing_unit() == PACKAGE_BODY ||
      _get_currently_publishing_unit() == PACKAGE_PUB ){
    _cc_out << ";\n";
  }
  else {
    _cc_out << ",\n";
  }

  _publish_cc_type_info( _cc_out, "_event", "SavantbooleanType_info" );

  if ((_get_currently_publishing_unit() == PACKAGE_BODY) ||
      (_get_currently_publishing_unit() == PACKAGE_PUB))  {
    _cc_out << ";\n";
  }
  else {
    _cc_out << ",\n";
  }

  _publish_cc_type_info( _cc_out, "_lastevent", "SavanttimeType_info" );
}

void
IIRScram_ArrayNatureDefinition::_publish_cc_type_info( published_file &_cc_out,
                                                       char *suffix,
                                                       char *elementTypeInfo) {
  IIR_Int32 dimensions = _get_num_indexes();
  IIR_TypeDefinition *node = this;
  IIR_Int32 i = dimensions;

  SCRAM_CC_REF( _cc_out, "IIRScram_ArrayNatureDefinition::_publish_cc_type_info" );

  if ((_get_currently_publishing_unit() == PACKAGE_BODY) ||
      (_get_currently_publishing_unit() == PACKAGE_PUB))  {
    _cc_out << "  ArrayTypeInfo ";
  }
  else {
    _cc_out << "  ";
  }

  _publish_cc_lvalue( _cc_out );
  if (suffix != NULL) {
    _cc_out << suffix;
  }
  _cc_out << "_info(" << dimensions << ", ";

  ASSERT ( _get_element_subtype() != NULL );

  if (elementTypeInfo == NULL) {
      if ((_get_final_subtype()->_is_array_type() == TRUE) &&
          (_get_final_subtype()->_is_anonymous() == TRUE)) {
        _cc_out << "new ";
      }
      else {
        _cc_out << "&";
      }
      _get_final_subtype()->_publish_cc_object_type_info( _cc_out, FALSE, suffix, TRUE );
  }
  else {
    _cc_out << "&" << elementTypeInfo;
  }

  _cc_out << ", ";

  _cc_out << ((_is_unconstrained_array_type() == TRUE) ? "true" : "false")
          << ", ";
  _cc_out << ((_is_resolved_type() == TRUE) ? "true" : "false")
          << ", ";

  _publish_cc_resolution_function_id( _cc_out );
  _cc_out << ", ";

  do {
    if(node->_get_index_subtype()->get_left() != NULL) {
      ASSERT(node->_get_index_subtype()->get_right() != NULL);
      ASSERT(node->_get_index_subtype()->get_direction() != NULL);
      if (node->_get_index_subtype()->_is_anonymous() == FALSE) {
        _cc_out << "&";
        node->_get_index_subtype()->_publish_cc_object_type_info( _cc_out, FALSE );
      }
      else {
        _cc_out << "new ";
        node->_get_index_subtype()->_publish_cc_temporary_type_info( _cc_out,
                                                                     suffix,
                                                                     elementTypeInfo );
      }
    }
    else {
      if (node->_get_index_subtype()->_get_base_type() != NULL) {
        _cc_out << "new ";
        node->_get_index_subtype()->_get_base_type()->_publish_cc_temporary_type_info( _cc_out,
                                                                                       suffix,
                                                                                       elementTypeInfo);
      }
      else {
        cerr << "Error: Unable to determine range for dimension " << i
             << " of array Type " << *_get_declarator() << ".\n";
        ASSERT ( TRUE );
      }
    }
   
    i--;
    if (i > 0) {
      _cc_out << ", ";
      node = node->_get_element_subtype();
    }
  } while (i > 0);

  _cc_out << ")";

  if ((_get_currently_publishing_unit() == PACKAGE_BODY) ||
      (_get_currently_publishing_unit() == PACKAGE_PUB)) {
    _cc_out << ";\n";
  }

}

