// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram.hh"
#include "IIRScram_AssociationElementOpen.hh"
#include "IIR_List.hh"
#include "error_func.hh"
#include "sstream-wrap.hh"


IIRScram_AssociationElementOpen::~IIRScram_AssociationElementOpen() {}

void 
IIRScram_AssociationElementOpen::_publish_vhdl(ostream &_vhdl_out) {
  _vhdl_out << "open";
}

void
IIRScram_AssociationElementOpen::_publish_vhdl_without_formals(ostream &_vhdl_out) {
  if (get_formal() != NULL) {
    if (get_formal()->get_kind() == IIR_FUNCTION_CALL) {
      get_formal()->_publish_vhdl(_vhdl_out);
      _vhdl_out << "=>";
    }
  }

  _vhdl_out << "open";
}

void
IIRScram_AssociationElementOpen::_publish_cc_lvalue( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_AssociationElementOpen::_publish_cc" );
  ostringstream err; 
  err << "ERROR: node " << get_kind_text() << " not handled yet...\n";
  report_error( this, err.str() );
  abort();
}

ostream&
IIRScram_AssociationElementOpen::_print(ostream& os) {
  if (get_formal() != NULL) {
    os << *get_formal();
    os << " => ";
  }
  
  os << "open";
  
  return os;
}




visitor_return_type *IIRScram_AssociationElementOpen::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_AssociationElementOpen(this, arg);
};
