// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRScram_BaseAttribute.hh"
#include "IIR_Identifier.hh"
#include "error_func.hh"
#include "resolution_func.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_TypeDeclaration.hh"
#include "set.hh"
#include "sstream-wrap.hh"

IIRScram_BaseAttribute::~IIRScram_BaseAttribute() {}

void 
IIRScram_BaseAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'BASE";
}


IIR_TextLiteral *
IIRScram_BaseAttribute::_build_attribute_name() {
  char *name = "base";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_TypeDefinition *
IIRScram_BaseAttribute::get_subtype(){
  IIR_TypeDefinition *retval = NULL;

  IIR_TypeDefinition *prefix_subtype = _get_prefix_subtype( &IIR::_is_type );
  if( prefix_subtype != NULL ){
    retval = prefix_subtype->get_base_type();
  }

  return retval;
}

IIR_Declaration *
IIRScram_BaseAttribute::_get_implicit_declaration( const string &implicit_decl_name,
						   IIR_TypeDefinition *implicit_decl_type ){
  return _build_type_declaration( implicit_decl_name, implicit_decl_type );
}

visitor_return_type *IIRScram_BaseAttribute::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_BaseAttribute(this, arg);
};
