
#ifndef IIRSCRAM_CASE_STATEMENT_ALTERNATIVE_BY_CHOICES_HH
#define IIRSCRAM_CASE_STATEMENT_ALTERNATIVE_BY_CHOICES_HH

// Copyright (c) 1996-2002 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey    philip.wilsey@ieee.org
//          Dale E. Martin      dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam

//---------------------------------------------------------------------------
#include "IIRBase_CaseStatementAlternativeByChoices.hh"

template <class type> class set;
class IIR_TypeDefinition;
class IIR_List;

class IIRScram_CaseStatementAlternativeByChoices : public IIRBase_CaseStatementAlternativeByChoices {
  
public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);
  
  void _type_check( set<IIR_TypeDefinition> * );
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)()=0); 
  IIR_Boolean _is_resolved();
  
  void _publish_vhdl(ostream &);
  void _publish_cc_lvalue( published_file &_cc_out );
  
  IIR *_clone();

protected:
  IIRScram_CaseStatementAlternativeByChoices() {}
  virtual ~IIRScram_CaseStatementAlternativeByChoices() = 0;

private:

};

#endif
