// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram_ChoiceList.hh"
#include "IIR_Choice.hh"
#include "published_file.hh"
#include "savant.hh"

IIRScram_ChoiceList::~IIRScram_ChoiceList() {}


void 
IIRScram_ChoiceList::_publish_vhdl(ostream &_vhdl_out) {
  register int numberOfChoices = 1;
  IIR_Choice *choice = first();
  choice->_publish_vhdl(_vhdl_out);
  choice = successor(choice);
  while(numberOfChoices < num_elements()){
    _vhdl_out << " | ";
    choice->_publish_vhdl(_vhdl_out);
    numberOfChoices++;
    choice = successor(choice);
  }
}

void
IIRScram_ChoiceList::_publish_cc_rvalue( published_file &_cc_out ){
  int numberOfChoices = 1;
  IIR_Choice *choice = first();

  SCRAM_CC_REF( _cc_out, "IIRScram_ChoiceList::_publish_cc" );

  _cc_out << OS("else if(")
	  << "SAVANT_BOOLEAN_TRUE == ";
  if(!choice->get_value()->_is_subtype()){
    _get_current_publish_node()->_publish_cc_rvalue( _cc_out );
    _cc_out << OS(".vhdlEqual(");
  }
  choice->_publish_cc_rvalue( _cc_out );
  if(!choice->get_value()->_is_subtype()){
    _cc_out << CS(")");
  }
  choice = successor(choice);
  while(numberOfChoices < num_elements()){
    _cc_out << "||" << OS("(") << NL()
	    << "SAVANT_BOOLEAN_TRUE == " << NL();
    if(!choice->get_value()->_is_subtype()){
      _get_current_publish_node()->_publish_cc_rvalue( _cc_out );
      _cc_out << OS(".vhdlEqual(");
    }
    choice->_publish_cc_rvalue( _cc_out );
    if(!choice->get_value()->_is_subtype()){
      _cc_out << CS(")");
    }
    _cc_out << CS(")");
    numberOfChoices++;
    choice = successor(choice);
  }
  _cc_out << CS(")");
}



void
IIRScram_ChoiceList::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  IIR_Choice* choice;
  choice = first();
  while(choice != NULL) {
    choice->_build_sensitivity_list(sensitivity_list);
    choice = successor(choice);
  }
}



visitor_return_type *
IIRScram_ChoiceList::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ChoiceList(this, arg);
};
