
#ifndef IIRSCRAM_CONCURRENT_BREAK_STATEMENT_HH
#define IIRSCRAM_CONCURRENT_BREAK_STATEMENT_HH

// Copyright (c) 2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Author: Harish Venkataramani venkath@ececs.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_ConcurrentBreakStatement.hh"
#include "published_file.hh"

/** The extension base for Concurrent Break Statement. This represents a
    process containing a break statement. */
class IIRScram_ConcurrentBreakStatement : public IIRBase_ConcurrentBreakStatement {
  
public:
  
  /** @name Method for publishing VHDL code. */
  void _publish_vhdl(ostream &);
  
  /** C++ publishing methods.  These methods relate to the publishing
      of C++. */
  void _publish_cc();
  void _publish_cc_ams();
  
  /** Creates a process with no sensitivity list and a statement part that
      includes a break statement followed by a wait statement. */
  IIR* _transmute();
  
  void _type_check();
  
  /** Generates net info for signals in the break statement. */
  void _publish_createNetInfo(char *, published_file &);

  IIR *_resolve_signal_name(IIR *);

  /** Appends the break statement info to the break handler. */
  void _build_break_info();
  
protected:
  IIRScram_ConcurrentBreakStatement(){};
  virtual ~IIRScram_ConcurrentBreakStatement() = 0;
  
private:
  
};
#endif
