
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRScram_ConditionalWaveformList.hh"
#include "IIR_ConditionalWaveform.hh"
#include "savant.hh"

IIRScram_ConditionalWaveformList::~IIRScram_ConditionalWaveformList(){}

void 
IIRScram_ConditionalWaveformList::_publish_vhdl(ostream &_vhdl_out) {
  IIR_ConditionalWaveform* waveform_condition;
  for(waveform_condition = first();
      waveform_condition != NULL; ) {
    waveform_condition->_publish_vhdl(_vhdl_out);
    waveform_condition = successor(waveform_condition);
    if( waveform_condition != NULL) {
      _vhdl_out << " else\n";
    }
  }
}

void
IIRScram_ConditionalWaveformList::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  IIR_ConditionalWaveform* waveform_condition;
  for(waveform_condition = first();
      waveform_condition != NULL;
    ) {
    waveform_condition->_build_sensitivity_list(sensitivity_list);
    waveform_condition = successor(waveform_condition);
  }
}

visitor_return_type *IIRScram_ConditionalWaveformList::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ConditionalWaveformList(this, arg);
};
