// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRScram_DesignatorByAll.hh"
#include "IIR_List.hh"
#include "IIR_Declaration.hh"
#include "IIR_AccessTypeDefinition.hh"
#include "set.hh"
#include "published_file.hh"

IIRScram_DesignatorByAll::~IIRScram_DesignatorByAll() {}


void 
IIRScram_DesignatorByAll::_publish_vhdl(ostream &_vhdl_out) {
  _vhdl_out << "all";
}

void 
IIRScram_DesignatorByAll::_publish_cc_lvalue( published_file &_cc_out ) {
  _cc_out << "all()";
}

void 
IIRScram_DesignatorByAll::_publish_cc_designator( published_file &_cc_out ) {
  _cc_out << "all";
}

void 
IIRScram_DesignatorByAll::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "all";
}


ostream &
IIRScram_DesignatorByAll::_print( ostream &os ){
  os << "all";
  return os;
}

set<IIR_Declaration> *
IIRScram_DesignatorByAll::_symbol_lookup( set<IIR_Declaration> *decl_set ){
  return new set<IIR_Declaration>( *decl_set );
}

IIR_Boolean 
IIRScram_DesignatorByAll::_is_resolved(){
  return TRUE;
}

set<IIR_TypeDefinition> *
IIRScram_DesignatorByAll::_get_rval_set( set<IIR_Declaration> *prefix_decls,
					 IIR_Boolean (IIR::*constraint_function)()){
  if( prefix_decls == NULL ){
    return NULL;
  }

  set<IIR_TypeDefinition> *retval = new set<IIR_TypeDefinition>;

  IIR_Declaration *current_decl = prefix_decls->get_element();
  while( current_decl != NULL ){
    if( current_decl->_is_access_type() == TRUE ){
      IIR_TypeDefinition *access_to = current_decl->get_subtype()->_get_designated_subtype();
      retval->add( access_to );
    }
    current_decl = prefix_decls->get_next_element();
  }

  if( retval->num_elements() == 0 ){
    delete retval;
    retval = NULL;
  }
  
  return retval;
}

set<IIR_TypeDefinition> *
IIRScram_DesignatorByAll::_get_rval_set( set<IIR_TypeDefinition> *prefix_types,
					 IIR_Boolean (IIR::*constraint_function)()){
  if( prefix_types == NULL ){
    return NULL;
  }

  set<IIR_TypeDefinition> *retval = new set<IIR_TypeDefinition>;

  IIR_TypeDefinition *current_type = prefix_types->get_element();
  while( current_type != NULL ){
    if( current_type->_is_access_type() == TRUE ){
      IIR_TypeDefinition *access_to = current_type->_get_designated_subtype();
      retval->add( access_to );
    }
    
    current_type = prefix_types->get_next_element();
  }

  if( retval->num_elements() == 0 ){
    delete retval;
    retval = NULL;
  }
  
  return retval;
}

IIR_TypeDefinition *
IIRScram_DesignatorByAll::_determine_rval_in_set( set<IIR_TypeDefinition> *prefix_types,
						  IIR_TypeDefinition *return_type ){
  IIR_TypeDefinition *retval = NULL;
  IIR_TypeDefinition *current_type = prefix_types->get_element();
  while( current_type != NULL ){
    if( current_type->_is_access_type() == TRUE ){
      IIR_TypeDefinition *access_to = current_type->get_subtype()->_get_designated_subtype();
      if( access_to->_is_compatible( return_type ) != NULL ){
	retval = current_type;
	break;
      }
    }

    current_type = prefix_types->get_next_element();
  }

  return retval;
}

IIR_Declaration *
IIRScram_DesignatorByAll::_determine_decl_in_set( set<IIR_Declaration> *prefix_decls,
						  IIR_TypeDefinition *return_type ){
  IIR_Declaration *retval = NULL;
  IIR_Declaration *current_decl = prefix_decls->get_element();
  while( current_decl != NULL ){
    if( current_decl->_is_access_type() == TRUE ){
      IIR_TypeDefinition *access_to = current_decl->get_subtype()->_get_designated_subtype();
      if( access_to->_is_compatible( return_type ) != NULL ){
	retval = current_decl;
	break;
      }
    }

    current_decl = prefix_decls->get_next_element();
  }

  return retval;
}

IIR *
IIRScram_DesignatorByAll::_rval_to_decl( IIR_TypeDefinition *prefix_type,
					 IIR_TypeDefinition *suffix_rval ){
  return this;
}

IIR *
IIRScram_DesignatorByAll::_rval_to_decl( IIR_Declaration *prefix_decl, IIR_TypeDefinition *suffix_rval ){
  return this;
}

visitor_return_type *IIRScram_DesignatorByAll::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_DesignatorByAll(this, arg);
};
