// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
#include "IIR_FileTypeDefinition.hh"
#include "IIR_ArraySubtypeDefinition.hh"
#include "IIR_EnumerationSubtypeDefinition.hh"
#include "IIR_IntegerSubtypeDefinition.hh"
#include "IIR_ConstantInterfaceDeclaration.hh"
#include "IIR_FunctionDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_ProcedureDeclaration.hh"
#include "resolution_func.hh"
#include "error_func.hh"
#include "symbol_table.hh"
#include "set.hh"
#include "StandardPackage.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"


IIRScram_FileTypeDefinition::~IIRScram_FileTypeDefinition() {}


void 
IIRScram_FileTypeDefinition::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "file of ";
  get_type_mark()->_get_declaration()->get_declarator()->_publish_vhdl(_vhdl_out);
}

void 
IIRScram_FileTypeDefinition::_come_into_scope( symbol_table *sym_tab, 
					       IIR_TypeDeclaration *type_declaration ){
  // Whenever a new file type is created, we need to build the
  // following declarations (shown in VHDL)  
  IIR_TypeDefinition *type_mark = get_type_mark();
  
  // procedure file_open( file f : new_file_type;
  //                      external_name : in string;
  //                      open_kind : in file_open_kind := read_mode );

  if( type_declaration->_get_implicit_declarations() == NULL ){
    type_declaration->_set_implicit_declarations( new set<IIR_Declaration> );
    
    
    char *name = "file_open";
    IIR_ProcedureDeclaration *new_procedure_declaration = new IIR_ProcedureDeclaration();
    copy_location( this, new_procedure_declaration );
    new_procedure_declaration->set_declarator( IIR_Identifier::get( name, strlen(name ) ) );
    new_procedure_declaration->_set_is_implicit( TRUE );

    type_declaration->_get_implicit_declarations()->add( new_procedure_declaration );
    
    IIR_ConstantInterfaceDeclaration *new_interface_declaration;
    new_interface_declaration  = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    new_interface_declaration->_set_is_visible( FALSE );
    copy_location( this, new_interface_declaration );

    name = "f";
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( this );

    new_procedure_declaration->interface_declarations.append( new_interface_declaration );
    
    name = "external_name";
    IIR_TypeDefinition *string_type = StandardPackage::get_string_type();
    
    new_interface_declaration  = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    new_interface_declaration->_set_is_visible( FALSE );
    copy_location( this, new_interface_declaration );
    
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( string_type );
    new_procedure_declaration->interface_declarations.append( new_interface_declaration );
    
    name = "my_open_kind";
    IIR_TypeDefinition *file_open_type = StandardPackage::get_file_open_kind_type();
    
    new_interface_declaration  = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    new_interface_declaration->_set_is_visible( FALSE );
    copy_location( this, new_interface_declaration );
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( file_open_type );
    new_procedure_declaration->interface_declarations.append( new_interface_declaration );
    
    sym_tab->add_subprogram_declaration( new_procedure_declaration );

    
    // procedure file_open( status: out FILE_OPEN_STATUS;
    //                      file f : ft;
    //                      external_name: in string;
    //                      open_kind: in FILE_OPEN_KIND := READ_MODE );
    
    name = "file_open";
    new_procedure_declaration = new IIR_ProcedureDeclaration();
    new_procedure_declaration->_set_is_implicit( TRUE );
    copy_location( this, new_procedure_declaration );
    new_procedure_declaration->set_declarator( IIR_Identifier::get( name, strlen(name ) ) );
    
    type_declaration->_get_implicit_declarations()->add( new_procedure_declaration );
    
    name = "status";
    IIR_TypeDefinition *file_open_status_type = StandardPackage::get_file_open_status_type();
    
    new_interface_declaration = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    new_interface_declaration->_set_is_visible( FALSE );
    copy_location( this, new_interface_declaration );
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( file_open_status_type );
    new_procedure_declaration->interface_declarations.append( new_interface_declaration );
    
    name = "f";
    new_interface_declaration = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    new_interface_declaration->_set_is_visible( FALSE );
    copy_location( this, new_interface_declaration );
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( this );
    new_procedure_declaration->interface_declarations.append( new_interface_declaration );
    
    name = "external_name";
    new_interface_declaration = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    new_interface_declaration->_set_is_visible( FALSE );
    copy_location( this, new_interface_declaration );
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( string_type );
    new_procedure_declaration->interface_declarations.append( new_interface_declaration );
    
    name = "my_open_kind";
    new_interface_declaration = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    new_interface_declaration->_set_is_visible( FALSE );
    copy_location( this, new_interface_declaration );
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( file_open_type );
    new_procedure_declaration->interface_declarations.append( new_interface_declaration );
    sym_tab->add_subprogram_declaration( new_procedure_declaration );
    
    // procedure file_close( file f : ft );
    name = "file_close";
    new_procedure_declaration = new IIR_ProcedureDeclaration();
    new_procedure_declaration->_set_is_implicit( TRUE );
    copy_location( this, new_procedure_declaration );
    new_procedure_declaration->set_declarator( IIR_Identifier::get( name, strlen(name ) ) );
    
    type_declaration->_get_implicit_declarations()->add( new_procedure_declaration );
    
    name = "f";
    new_interface_declaration = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    new_interface_declaration->_set_is_visible( FALSE );
    copy_location( this, new_interface_declaration );
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( this );
    new_procedure_declaration->interface_declarations.append( new_interface_declaration );
    sym_tab->add_subprogram_declaration( new_procedure_declaration );

    // procedure read ( file f : ft; value : out tm );
    name = "read";
    new_procedure_declaration = new IIR_ProcedureDeclaration();
    new_procedure_declaration->_set_is_implicit( TRUE );
    copy_location( this, new_procedure_declaration );
    new_procedure_declaration->set_declarator( IIR_Identifier::get( name, strlen(name ) ) );
    
    type_declaration->_get_implicit_declarations()->add( new_procedure_declaration );
    
    name = "f";
    new_interface_declaration = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    new_interface_declaration->_set_is_visible( FALSE );
    copy_location( this, new_interface_declaration );
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( this );
    new_procedure_declaration->interface_declarations.append( new_interface_declaration );
    
    name = "value";
    new_interface_declaration = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    new_interface_declaration->_set_is_visible( FALSE );
    copy_location( this, new_interface_declaration );
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( type_mark );
    new_interface_declaration->set_mode( IIR_OUT_MODE );
    new_procedure_declaration->interface_declarations.append( new_interface_declaration );
    
    if( type_mark->_is_unconstrained_array_type() == TRUE ){
      name = "length";
      new_interface_declaration = new IIR_ConstantInterfaceDeclaration();
      new_interface_declaration->_set_is_implicit( TRUE );
      new_interface_declaration->_set_is_visible( FALSE );
      copy_location( this, new_interface_declaration );
      new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
      new_interface_declaration->set_subtype( StandardPackage::get_natural_type() );
      new_interface_declaration->set_mode( IIR_OUT_MODE );
      new_procedure_declaration->interface_declarations.append( new_interface_declaration );    
    }
    sym_tab->add_subprogram_declaration( new_procedure_declaration );
    
    // procedure write ( file f : ft; value in tm );
    name = "write";
    new_procedure_declaration = new IIR_ProcedureDeclaration();
    new_procedure_declaration->_set_is_implicit( TRUE );
    copy_location( this, new_procedure_declaration );
    new_procedure_declaration->set_declarator( IIR_Identifier::get( name, strlen(name ) ) );
    type_declaration->_get_implicit_declarations()->add( new_procedure_declaration );

    name = "f";
    new_interface_declaration = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    new_interface_declaration->_set_is_visible( FALSE );
    copy_location( this, new_procedure_declaration );
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( this );
    new_procedure_declaration->interface_declarations.append( new_interface_declaration );

    name = "value";
    new_interface_declaration = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    new_interface_declaration->_set_is_visible( FALSE );
    copy_location( this, new_interface_declaration );
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( type_mark );
    new_interface_declaration->set_mode( IIR_IN_MODE );
    new_procedure_declaration->interface_declarations.append( new_interface_declaration );
    sym_tab->add_subprogram_declaration( new_procedure_declaration );
    // function endfile ( file f : ft ) return boolean;
    name = "endfile";
    IIR_FunctionDeclaration *new_function_declaration = new IIR_FunctionDeclaration();
    new_function_declaration->_set_is_implicit( TRUE );
    copy_location( this, new_function_declaration );
    new_function_declaration->set_declarator( IIR_Identifier::get( name, strlen(name ) ) );
    type_declaration->_get_implicit_declarations()->add( new_function_declaration );

    name = "f";
    new_interface_declaration = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    new_interface_declaration->_set_is_visible( FALSE );
    copy_location( this, new_interface_declaration );
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( this );
    new_function_declaration->interface_declarations.append( new_interface_declaration );
  
    IIR_TypeDefinition *boolean_type = StandardPackage::get_boolean_type();
    new_function_declaration->set_return_type( boolean_type );

    sym_tab->add_subprogram_declaration( new_function_declaration );
  }
  else{
    sym_tab->add_declaration( type_declaration->_get_implicit_declarations() );
  }
}

void
IIRScram_FileTypeDefinition::_publish_cc_headers( published_file &_cc_out ) {
  get_type_mark()->_publish_cc_include( _cc_out );
  _publish_cc_include( _cc_out, "tyvis/FileType.hh" );
  _publish_cc_include( _cc_out, "tyvis/SavantlineType.hh" );
  _publish_cc_include( _cc_out, "tyvis/AccessVariable.hh" );
  _publish_cc_include( _cc_out, "tyvis/VHDLProcess.hh" );
}

const string
IIRScram_FileTypeDefinition::_get_cc_kernel_type(){
  return "FileType";
}

void
IIRScram_FileTypeDefinition::_publish_cc_data_members( published_file & ) {
  // Do nothing
}

void
IIRScram_FileTypeDefinition::_publish_cc_decl_constructors( published_file &_cc_out ){
  _publish_cc_lvalue( _cc_out );
  _cc_out << "() {};\n";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "(bool alias) : FileType(alias)  { }\n";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "(VHDLKernel *proc, const char *, const _savant_file_open_kind &);\n";
  _cc_out << "~";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "() {};\n";
}

void
IIRScram_FileTypeDefinition::_publish_cc_decl_operator_equalto( published_file & ){
  // Do nothing
}

void
IIRScram_FileTypeDefinition::_publish_cc_decl_type_attributes( published_file & ){
  // Do nothing
}

void
IIRScram_FileTypeDefinition::_publish_cc_decl_predefined_procedures_prototypes( published_file &_cc_out ) {
  
  SCRAM_CC_REF( _cc_out,
		"IIRScram_FileTypeDefinition::_publish_cc_decl_predefined_procedures_prototypes" );

  _cc_out << "extern int savantwrite(VHDLKernel *base, ";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "&, const ";
  if (get_type_mark()->_is_scalar_type() == TRUE &&
      get_type_mark()->_is_kernel_type() == FALSE){
    get_type_mark()->_publish_cc_kernel_type( _cc_out );
  }
  else {
    _cc_out << get_type_mark()->_get_cc_type_name();
  }
  _cc_out << "&);\n";

  SCRAM_CC_REF( _cc_out,
		"IIRScram_FileTypeDefinition::_publish_cc_decl_predefined_procedures_prototypes" );

  _cc_out << "extern int savantread(VHDLKernel *base, ";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "&, ";
  if (get_type_mark()->_is_scalar_type() == TRUE &&
      get_type_mark()->_is_kernel_type() == FALSE){
    get_type_mark()->_publish_cc_kernel_type( _cc_out );
  }
  else {
    _cc_out << get_type_mark()->_get_cc_type_name();
  }
  _cc_out << "&);\n";

  SCRAM_CC_REF( _cc_out,
		"IIRScram_FileTypeDefinition::_publish_cc_decl_predefined_procedures_prototypes" );

  _cc_out << "extern const EnumerationType& savantendfile(VHDLKernel *base, ";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "&);" << NL();

  SCRAM_CC_REF( _cc_out,
		"IIRScram_FileTypeDefinition::_publish_cc_decl_predefined_procedures_prototypes" );

  
  _cc_out << "extern int savantfile_close(VHDLKernel *base, ";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "&);\n";

  SCRAM_CC_REF( _cc_out,
		"IIRScram_FileTypeDefinition::_publish_cc_decl_predefined_procedures_prototypes" );

  
  if (get_type_mark()->_is_array_type()) {
    _cc_out << "extern int savantread(VHDLKernel *base, ";
    _publish_cc_lvalue( _cc_out );
    _cc_out << "&, ";
    _cc_out << get_type_mark()->_get_cc_type_name();
    _cc_out << "&, IntegerType&);" << NL();
  }
}

void
IIRScram_FileTypeDefinition::_publish_cc_decl_cc( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out,
		"IIRScram_FileTypeDefinition::_publish_cc_decl_cc" );

  _publish_cc_lvalue( _cc_out );
  _cc_out << "::";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "(VHDLKernel *proc, const char *fileName, const _savant_file_open_kind &mode)  {\n";
  _cc_out << "  openFile(proc, fileName, mode);\n";
  _cc_out << "}\n\n";

  SCRAM_CC_REF( _cc_out,
		"IIRScram_FileTypeDefinition::_publish_cc_decl_cc" );
  
  _cc_out << "int\nsavantwrite(VHDLKernel *base, ";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "& file, const ";
  _cc_out << get_type_mark()->_get_cc_type_name();
  _cc_out << "& var)  {";
  _cc_out << "  SavantlineType line;\n\n";
  _cc_out << "  var.savantwrite(line);\n";
  _cc_out << "  return file.savantwriteline(base, line);\n";
  _cc_out << "}\n\n";

  SCRAM_CC_REF( _cc_out,
		"IIRScram_FileTypeDefinition::_publish_cc_decl_cc" );

  
  _cc_out << "int\nsavantread(VHDLKernel *base, ";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "& file, ";
  _cc_out << get_type_mark()->_get_cc_type_name();
  _cc_out << "& var)  {\n";
  _cc_out << "  SavantlineType line;\n\n";
  _cc_out << "  file.savantreadline(base, line);\n"; 
  _cc_out << "  return var.savantread(line);\n";
  _cc_out << "}\n\n";
  
  SCRAM_CC_REF( _cc_out,
		"IIRScram_FileTypeDefinition::_publish_cc_decl_cc" );

  _cc_out << "const EnumerationType&\nsavantendfile(VHDLKernel *base, ";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "& file)  {\n";
  _cc_out << "  if (file.savantendfile_boolean(base, file.get_fileHandle())"
	  << " == SAVANT_BOOLEAN_TRUE)  {\n";
  _cc_out << "    return SAVANT_BOOLEAN_TRUE;\n";
  _cc_out << "  }\n  else  {\n";
  _cc_out << "    return SAVANT_BOOLEAN_FALSE;\n  }\n"
	  << "}\n\n";

  SCRAM_CC_REF( _cc_out,
		"IIRScram_FileTypeDefinition::_publish_cc_decl_cc" );

  _cc_out << "int\nsavantfile_close(VHDLKernel *base, ";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "& file)  {\n";
  _cc_out << "  file.closeFile(base);\n\n";
  _cc_out << "  return NORMAL_RETURN;\n";
  _cc_out << "}\n\n";
  
  if (get_type_mark()->_is_array_type()) {
    SCRAM_CC_REF( _cc_out,
		  "IIRScram_FileTypeDefinition::_publish_cc_decl_cc" );

    _cc_out << "int\nsavantread(VHDLKernel *base, ";
    _publish_cc_lvalue( _cc_out );
    _cc_out << "& file, ";
    _cc_out << get_type_mark()->_get_cc_type_name();
    _cc_out << "& var, IntegerType &count)  {" << NL();
    _cc_out << "  SavantlineType line;\n  file.savantreadline(base, line,"
	    << " count);\n";
    
    if (get_type_mark()->_is_array_type() == TRUE) {
      _cc_out << "  count = IntegerType(ObjectBase::VARIABLE,"
	      << " UniversalInteger(var.length()), SavantnaturalType_info);\n";
    }
    else {
      _cc_out << "  count = IntegerType(ObjectBase::VARIABLE,"
	      << " UniversalInteger(1), SavantnaturalType_info);\n";
    }
    
    _cc_out << "  return var.savantread(line);\n}\n";
  }
}

const string
IIRScram_FileTypeDefinition::_get_cc_type_name( ){
  return "FileType";
}

void
IIRScram_FileTypeDefinition::_publish_cc_extern_type_info( published_file &) {}

void
IIRScram_FileTypeDefinition::_publish_cc_type_info( published_file &) {}

void
IIRScram_FileTypeDefinition::_publish_cc_decl_destructors( published_file & ){
  // Do nothing
}

void 
IIRScram_FileTypeDefinition::_set_resolution_function( IIR_FunctionDeclaration * ){
  ostringstream err;
  err << "Internal error - IIRScram_FileTypeDefinition::_set_resolution_function was "
      << "called.  Resolution functions can't be associated with a file type and this "
      << "should have been caught earlier.";
  report_error( this, err.str() );
}

visitor_return_type *
IIRScram_FileTypeDefinition::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_FileTypeDefinition(this, arg);
};
