
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Malolan Chetlur    

//---------------------------------------------------------------------------

#include "IIR_LessThanOperator.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_LessThanOperator::~IIRScram_LessThanOperator() {}

void 
IIRScram_LessThanOperator::_publish_vhdl_operator(ostream &_vhdl_out) {
  _vhdl_out << " < ";
}

const string &
IIRScram_LessThanOperator::_get_cc_operator_name() const {
  static const string operator_name = "vhdlLessThan";
  return operator_name;
}

void
IIRScram_LessThanOperator::_publish_cc_ams_operator_name( published_file &_cc_out ) {
  _cc_out << " < ";
}

IIR*
IIRScram_LessThanOperator::_clone() {
  IIR_LessThanOperator *clone = new IIR_LessThanOperator();
  IIRScram_DyadicOperator::_clone(clone);
  return clone;
}

IIRScram::OperatorPrecedenceLevel
IIRScram_LessThanOperator::_get_operator_precedence(){
  return IIRScram::RELATIONAL_OPERATOR;
}

IIR_Boolean                                      
IIRScram_LessThanOperator::_is_relational_operator(){
  return TRUE ;                                                              
}

visitor_return_type *IIRScram_LessThanOperator::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_LessThanOperator(this, arg);
};
