/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil.emit;

import ch.epfl.lamp.compiler.msil.Assembly;
import ch.epfl.lamp.compiler.msil.AssemblyName;
import ch.epfl.lamp.compiler.msil.Attribute;
import ch.epfl.lamp.compiler.msil.CallingConventions;
import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.FieldAttributes;
import ch.epfl.lamp.compiler.msil.FieldInfo;
import ch.epfl.lamp.compiler.msil.ICustomAttributeProvider;
import ch.epfl.lamp.compiler.msil.MethodAttributes;
import ch.epfl.lamp.compiler.msil.MethodBase;
import ch.epfl.lamp.compiler.msil.MethodImplAttributes;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.Module;
import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.ParameterAttributes;
import ch.epfl.lamp.compiler.msil.ParameterInfo;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.TypeAttributes;
import ch.epfl.lamp.compiler.msil.Version;
import ch.epfl.lamp.compiler.msil.emit.AssemblyBuilder;
import ch.epfl.lamp.compiler.msil.emit.ConstructorBuilder;
import ch.epfl.lamp.compiler.msil.emit.FieldBuilder;
import ch.epfl.lamp.compiler.msil.emit.ILGenerator;
import ch.epfl.lamp.compiler.msil.emit.Label;
import ch.epfl.lamp.compiler.msil.emit.LocalBuilder;
import ch.epfl.lamp.compiler.msil.emit.MethodBuilder;
import ch.epfl.lamp.compiler.msil.emit.ModuleBuilder;
import ch.epfl.lamp.compiler.msil.emit.OpCode;
import ch.epfl.lamp.compiler.msil.emit.ParameterBuilder;
import ch.epfl.lamp.compiler.msil.emit.TypeBuilder;
import ch.epfl.lamp.compiler.msil.emit.Visitable;
import ch.epfl.lamp.compiler.msil.emit.Visitor;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public final class ILPrinterVisitor
implements Visitor {
    private final Comparator assemblyNameComparator = new 0();
    static final Type VOID;
    private PrintWriter out;
    private int lmargin = 0;
    private boolean newline = true;
    private boolean nomembers;
    private static int TAB;
    private int padding = 0;
    private static final String SPACES = "                                ";
    private static final int SPACES_LEN;
    static final String EMPTY = "";
    private MethodInfo entryPoint;
    private Object argument;
    public static Assembly currAssembly;
    private Module currentModule;
    private Type currentType;
    static final HashMap primitive;
    private static final /* synthetic */ boolean $assertionsDisabled;

    private ILPrinterVisitor(String string) throws IOException {
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(string)));
    }

    private void align() {
        if (this.newline) {
            this.padding = this.lmargin;
        }
        this.printPadding();
        this.newline = false;
    }

    private void indent() {
        this.lmargin += TAB;
    }

    private void undent() {
        this.lmargin -= TAB;
        if (!$assertionsDisabled && this.lmargin < 0) {
            throw new AssertionError();
        }
    }

    private void pad(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf("negative padding: ".concat(String.valueOf(n)))));
        }
        this.padding += n;
    }

    private void printPadding() {
        if (this.padding == 0) {
            return;
        }
        while (this.padding > SPACES_LEN) {
            this.out.print(SPACES);
            this.padding -= SPACES_LEN;
        }
        this.out.print(SPACES.substring(0, this.padding));
        this.padding = 0;
    }

    private void print(String string) {
        this.align();
        this.out.print(string);
    }

    private void print(Object object) {
        this.align();
        this.out.print(object);
    }

    private void print(char c) {
        this.align();
        this.out.print(c);
    }

    private void print(int n) {
        this.align();
        this.out.print(n);
    }

    private void print(long l) {
        this.align();
        this.out.print(l);
    }

    private void println() {
        this.out.println();
        this.newline = true;
        this.padding = 0;
    }

    private void println(char c) {
        this.print(c);
        this.println();
    }

    private void println(int n) {
        this.print(n);
        this.println();
    }

    private void println(long l) {
        this.print(l);
        this.println();
    }

    private void println(String string) {
        this.print(string);
        this.println();
    }

    private void println(Object object) {
        this.print(object);
        this.println();
    }

    private void printName(String string) {
        char c = string.charAt(0);
        if (c != '.') {
            this.print('\'');
            this.print(string);
            this.print('\'');
        } else {
            this.print(string);
        }
    }

    private static boolean hasControlChars(String string) {
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': {
                    continue block3;
                }
                default: {
                    if (!Character.isISOControl(c)) continue block3;
                    return true;
                }
            }
        }
        return false;
    }

    public static String msilString(String string) {
        if (ILPrinterVisitor.hasControlChars(string)) {
            try {
                return String.valueOf(String.valueOf("bytearray (".concat(String.valueOf(String.valueOf(PEFile.bytes2hex(string.getBytes("UTF-16LE"))))))).concat(")");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            String string2 = EMPTY;
            char c = stringBuffer.charAt(i);
            switch (c) {
                case '\b': {
                    string2 = "\\b";
                    break;
                }
                case '\t': {
                    string2 = "\\t";
                    break;
                }
                case '\n': {
                    string2 = "\\n";
                    break;
                }
                case '\f': {
                    string2 = "\\f";
                    break;
                }
                case '\r': {
                    string2 = "\\r";
                    break;
                }
                case '\"': {
                    string2 = "\\\"";
                    break;
                }
                case '\'': {
                    string2 = "\\'";
                    break;
                }
                case '\\': {
                    string2 = "\\\\";
                    break;
                }
                default: {
                    if (!Character.isISOControl(c)) break;
                    string2 = "\\u".concat(String.valueOf(String.valueOf(PEFile.int2hex(Character.getNumericValue(c)))));
                }
            }
            if (string2 == EMPTY) continue;
            stringBuffer.replace(i, i + 1, string2);
            i += string2.length() - 1;
        }
        return stringBuffer.insert(0, '\"').append('\"').toString();
    }

    public static void printAssembly(AssemblyBuilder assemblyBuilder, String string) throws IOException {
        assemblyBuilder.apply(new ILPrinterVisitor(string));
    }

    protected void print(Visitable visitable) {
        if (visitable != null) {
            visitable.apply(this);
        }
    }

    public void caseAssemblyBuilder(AssemblyBuilder assemblyBuilder) {
        currAssembly = assemblyBuilder;
        this.entryPoint = assemblyBuilder.EntryPoint;
        Assembly[] assemblyArray = assemblyBuilder.getExternAssemblies();
        Arrays.sort(assemblyArray, this.assemblyNameComparator);
        for (int i = 0; i < assemblyArray.length; ++i) {
            this.printAssemblySignature(assemblyArray[i], true);
        }
        this.printAssemblySignature(assemblyBuilder, false);
        Module[] moduleArray = assemblyBuilder.GetModules();
        this.nomembers = true;
        for (int i = 0; i < moduleArray.length; ++i) {
            this.print((ModuleBuilder)moduleArray[i]);
        }
        this.nomembers = false;
        for (int i = 0; i < moduleArray.length; ++i) {
            this.print((ModuleBuilder)moduleArray[i]);
        }
        this.out.close();
        currAssembly = null;
    }

    public void caseModuleBuilder(ModuleBuilder moduleBuilder) {
        this.currentModule = moduleBuilder;
        if (this.nomembers) {
            this.print(".module '");
            this.print(moduleBuilder.Name);
            this.println("'");
            this.printAttributes(moduleBuilder);
        }
        if (!moduleBuilder.globalsCreated) {
            moduleBuilder.CreateGlobalFunctions();
        }
        MethodInfo[] methodInfoArray = moduleBuilder.GetMethods();
        for (int i = 0; i < methodInfoArray.length; ++i) {
            this.print((MethodBuilder)methodInfoArray[i]);
        }
        Type[] typeArray = moduleBuilder.GetTypes();
        for (int i = 0; i < typeArray.length; ++i) {
            this.print((TypeBuilder)typeArray[i]);
        }
        this.currentModule = null;
    }

    public void caseTypeBuilder(TypeBuilder typeBuilder) {
        Type[] typeArray;
        this.currentType = typeBuilder;
        this.println();
        if (!typeBuilder.Namespace.equals(EMPTY) && typeBuilder.DeclaringType == null) {
            this.print(".namespace '");
            this.print(typeBuilder.Namespace);
            this.println("'");
            this.println("{");
            this.indent();
        }
        this.print(".class ");
        this.print(TypeAttributes.toString(typeBuilder.Attributes));
        this.print(" '");
        this.print(typeBuilder.Name);
        this.print("'");
        if (typeBuilder.BaseType() != null) {
            this.println();
            this.print("       extends    ");
            this.printReference(typeBuilder.BaseType());
        }
        if ((typeArray = typeBuilder.getInterfaces()).length > 0) {
            this.println();
            this.print("       implements ");
            for (int i = 0; i < typeArray.length; ++i) {
                if (i > 0) {
                    this.println(",");
                    this.print("                  ");
                }
                this.printReference(typeArray[i]);
            }
        }
        this.println();
        this.println("{");
        this.indent();
        if (!this.nomembers && typeBuilder.sourceFilename != null) {
            this.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(".line  ".concat(String.valueOf(typeBuilder.sourceLine)))).concat("  '"))).concat(String.valueOf(String.valueOf(typeBuilder.sourceFilename))))).concat("'"));
        }
        if (!this.nomembers) {
            this.printAttributes(typeBuilder);
        }
        Iterator iterator = ((AbstractList)typeBuilder.nestedTypeBuilders).iterator();
        while (iterator.hasNext()) {
            this.print((TypeBuilder)iterator.next());
        }
        Iterator iterator2 = ((AbstractList)typeBuilder.fieldBuilders).iterator();
        while (iterator2.hasNext()) {
            this.print((FieldBuilder)iterator2.next());
        }
        Iterator iterator3 = ((AbstractList)typeBuilder.constructorBuilders).iterator();
        while (iterator3.hasNext()) {
            this.print((ConstructorBuilder)iterator3.next());
        }
        Iterator iterator4 = ((AbstractList)typeBuilder.methodBuilders).iterator();
        while (iterator4.hasNext()) {
            MethodBuilder methodBuilder = (MethodBuilder)iterator4.next();
            if (!$assertionsDisabled && methodBuilder.DeclaringType != typeBuilder) {
                throw new AssertionError();
            }
            this.print(methodBuilder);
        }
        this.undent();
        this.println("}");
        if (!typeBuilder.Namespace.equals(EMPTY) && typeBuilder.DeclaringType == null) {
            this.undent();
            this.println("}");
        }
        this.currentType = null;
    }

    public void caseFieldBuilder(FieldBuilder fieldBuilder) {
        if (this.nomembers) {
            return;
        }
        this.print(".field ");
        this.print(FieldAttributes.toString(fieldBuilder.Attributes));
        this.print(" ");
        this.printSignature(fieldBuilder.FieldType);
        this.print(" '");
        this.print(fieldBuilder.Name);
        this.print("'");
        if (fieldBuilder.IsLiteral()) {
            this.print(" = ");
            Object object = fieldBuilder.getValue();
            if (object == null) {
                this.print("nullref");
            } else if (object instanceof String) {
                this.print(ILPrinterVisitor.msilString((String)object));
            } else if (object instanceof Boolean) {
                this.print("bool (");
                this.print((Boolean)object != false ? "true" : "false");
                this.print(")");
            } else if (object instanceof Byte) {
                this.print("int8 (");
                this.print(((Byte)object).byteValue());
                this.print(")");
            } else if (object instanceof Short) {
                this.print("int16 (");
                this.print(((Short)object).shortValue());
                this.print(")");
            } else if (object instanceof Character) {
                this.print("char (");
                this.print(((Character)object).charValue());
                this.print(")");
            } else if (object instanceof Integer) {
                this.print("int32 (");
                this.print((Integer)object);
                this.print(")");
            } else if (object instanceof Long) {
                this.print("int64 (");
                this.print((Long)object);
                this.print(")");
            } else if (object instanceof Float) {
                long l = Float.floatToRawIntBits(((Float)object).floatValue());
                this.print("float32 (float32 (");
                this.print(l);
                this.print("))");
            } else if (object instanceof Double) {
                long l = Double.doubleToRawLongBits((Double)object);
                this.print("float64 (float64 (");
                this.print(l);
                this.print("))");
            } else {
                throw new Error("ILPrinterVisitor: Illegal default value: ".concat(String.valueOf(String.valueOf(object.getClass()))));
            }
        }
        this.println();
        this.printAttributes(fieldBuilder);
    }

    public void caseConstructorBuilder(ConstructorBuilder constructorBuilder) {
        if (this.nomembers) {
            return;
        }
        this.print(".method ");
        this.printHeader(constructorBuilder, VOID);
        this.println();
        this.println("{");
        this.indent();
        this.printAttributes(constructorBuilder);
        try {
            this.print(constructorBuilder.GetILGenerator());
        }
        catch (RuntimeException runtimeException) {
            System.err.println("In method ".concat(String.valueOf(String.valueOf(constructorBuilder))));
            runtimeException.printStackTrace();
        }
        this.undent();
        this.println("}");
    }

    public void caseMethodBuilder(MethodBuilder methodBuilder) {
        if (this.nomembers) {
            return;
        }
        this.print(".method ");
        this.printHeader(methodBuilder, methodBuilder.ReturnType);
        if (methodBuilder.IsAbstract() || methodBuilder.DeclaringType != null && methodBuilder.DeclaringType.IsInterface() && !methodBuilder.IsStatic()) {
            this.println(" {");
            this.indent();
            this.printAttributes(methodBuilder);
            this.undent();
            this.println("}");
        } else {
            this.println();
            this.println("{");
            this.indent();
            this.printAttributes(methodBuilder);
            if (methodBuilder == this.entryPoint) {
                this.println(".entrypoint");
            }
            try {
                this.print(methodBuilder.GetILGenerator());
            }
            catch (RuntimeException runtimeException) {
                System.err.println("In method ".concat(String.valueOf(String.valueOf(methodBuilder))));
                runtimeException.printStackTrace();
            }
            this.undent();
            this.println("}");
        }
    }

    public void caseParameterBuilder(ParameterBuilder parameterBuilder) {
        this.print(ParameterAttributes.toString(parameterBuilder.Attributes));
        this.printSignature(parameterBuilder.ParameterType);
        this.print(' ');
        this.printName(parameterBuilder.Name);
    }

    public void caseILGenerator(ILGenerator iLGenerator) {
        this.println(".maxstack   ".concat(String.valueOf(iLGenerator.getMaxStacksize())));
        LocalBuilder[] localBuilderArray = iLGenerator.getLocals();
        if (localBuilderArray.length > 0) {
            this.println(".locals init (");
            this.indent();
            for (int i = 0; i < localBuilderArray.length; ++i) {
                if (i > 0) {
                    this.println(",");
                }
                this.print(localBuilderArray[i]);
            }
            this.undent();
            this.println(")");
        }
        Iterator iterator = iLGenerator.getLabelIterator();
        Iterator iterator2 = iLGenerator.getOpcodeIterator();
        Iterator iterator3 = iLGenerator.getArgumentIterator();
        while (iterator2.hasNext()) {
            Label label = (Label)iterator.next();
            Object v = iLGenerator.lineNums.get(label);
            if (v != null) {
                this.println(".line       ".concat(String.valueOf(String.valueOf(v))));
            }
            this.print(label);
            this.print("   ");
            this.argument = iterator3.next();
            this.print((OpCode)iterator2.next());
            this.println();
        }
    }

    public void caseOpCode(OpCode opCode) {
        String string = opCode.toString();
        this.print(string);
        this.pad(12 - string.length());
        switch (opCode.$tag) {
            case 149: {
                this.print(ILPrinterVisitor.msilString(this.argument.toString()));
                break;
            }
            case 206: {
                this.print("(");
                Label[] labelArray = (Label[])this.argument;
                int n = labelArray.length;
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        this.print(", ");
                    }
                    this.print(labelArray[i]);
                }
                this.print(")");
                break;
            }
            case 33: {
                this.printSignature((MethodBase)this.argument);
                break;
            }
            case 35: {
                this.printSignature((MethodBase)this.argument);
                break;
            }
            case 86: {
                this.printSignature((MethodBase)this.argument);
                break;
            }
            case 124: {
                this.printSignature((MethodBase)this.argument);
                break;
            }
            case 151: {
                this.printSignature((MethodBase)this.argument);
                break;
            }
            case 161: {
                this.printSignature((ConstructorInfo)this.argument);
                break;
            }
            case 122: {
                this.printSignature((FieldInfo)this.argument);
                break;
            }
            case 123: {
                this.printSignature((FieldInfo)this.argument);
                break;
            }
            case 147: {
                this.printSignature((FieldInfo)this.argument);
                break;
            }
            case 148: {
                this.printSignature((FieldInfo)this.argument);
                break;
            }
            case 186: {
                this.printSignature((FieldInfo)this.argument);
                break;
            }
            case 202: {
                this.printSignature((FieldInfo)this.argument);
                break;
            }
            case 36: {
                this.printSignature((Type)this.argument);
                break;
            }
            case 85: {
                this.printSignature((Type)this.argument);
                break;
            }
            case 25: {
                this.printSignature((Type)this.argument);
                break;
            }
            case 210: {
                this.printSignature((Type)this.argument);
                break;
            }
            case 146: {
                this.printSignature((Type)this.argument);
                break;
            }
            case 160: {
                this.printSignature((Type)this.argument);
                break;
            }
            case 137: {
                LocalBuilder localBuilder = (LocalBuilder)this.argument;
                this.print(localBuilder.slot);
                this.print("\t// ");
                this.printSignature(localBuilder.LocalType);
                this.print(" '");
                this.print(localBuilder.name);
                this.print("'");
                break;
            }
            case 142: {
                LocalBuilder localBuilder = (LocalBuilder)this.argument;
                this.print(localBuilder.slot);
                this.print("\t// ");
                this.printSignature(localBuilder.LocalType);
                this.print(" '");
                this.print(localBuilder.name);
                this.print("'");
                break;
            }
            case 143: {
                LocalBuilder localBuilder = (LocalBuilder)this.argument;
                this.print(localBuilder.slot);
                this.print("\t// ");
                this.printSignature(localBuilder.LocalType);
                this.print(" '");
                this.print(localBuilder.name);
                this.print("'");
                break;
            }
            case 144: {
                LocalBuilder localBuilder = (LocalBuilder)this.argument;
                this.print(localBuilder.slot);
                this.print("\t// ");
                this.printSignature(localBuilder.LocalType);
                this.print(" '");
                this.print(localBuilder.name);
                this.print("'");
                break;
            }
            case 195: {
                LocalBuilder localBuilder = (LocalBuilder)this.argument;
                this.print(localBuilder.slot);
                this.print("\t// ");
                this.printSignature(localBuilder.LocalType);
                this.print(" '");
                this.print(localBuilder.name);
                this.print("'");
                break;
            }
            case 200: {
                LocalBuilder localBuilder = (LocalBuilder)this.argument;
                this.print(localBuilder.slot);
                this.print("\t// ");
                this.printSignature(localBuilder.LocalType);
                this.print(" '");
                this.print(localBuilder.name);
                this.print("'");
                break;
            }
            default: {
                if (this.argument == null) break;
                this.print(this.argument);
            }
        }
    }

    public void caseLabel(Label label) {
        Object object = label.getScopeInfo();
        switch (((Label.Scope)object).$tag) {
            case 2: {
                this.println("{");
                this.indent();
                break;
            }
            case 1: {
                this.undent();
                this.println("}");
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new Error();
            }
        }
        object = label.getTryInfo();
        switch (((Label.Try)object).$tag) {
            case 5: {
                break;
            }
            case 6: {
                this.println(".try");
                this.println("{");
                this.indent();
                break;
            }
            case 0: {
                Label.Try.Catch catch_ = (Label.Try.Catch)object;
                Type type = catch_.type;
                this.undent();
                this.println("}");
                this.print("catch ");
                this.printReference(type);
                this.println("{");
                this.indent();
                break;
            }
            case 2: {
                this.undent();
                this.println("}");
                this.println("filter {");
                this.indent();
                break;
            }
            case 3: {
                this.print("endfilter");
                this.undent();
                this.println("}");
                break;
            }
            case 4: {
                this.undent();
                this.println("}");
                this.println("finally {");
                this.indent();
                break;
            }
            case 1: {
                this.undent();
                this.println("}");
                break;
            }
            default: {
                throw new Error();
            }
        }
        this.print(String.valueOf(String.valueOf(label)).concat(": "));
    }

    public void caseLocalBuilder(LocalBuilder localBuilder) {
        this.printSignature(localBuilder.LocalType);
        this.print(" '");
        this.print(localBuilder.name);
        this.print("'");
    }

    void printAssemblySignature(Assembly assembly, boolean bl) {
        byte[] byArray;
        Version version;
        this.print(".assembly ");
        if (bl) {
            this.print("extern ");
        }
        AssemblyName assemblyName = assembly.GetName();
        this.printName(assemblyName.Name);
        this.println();
        this.println("{");
        if (!bl) {
            this.printAttributes(assembly);
        }
        if ((version = assemblyName.Version) != null) {
            this.print("    .ver ");
            this.print(version.Major);
            this.print(':');
            this.print(version.Minor);
            this.print(':');
            this.print(version.Build);
            this.print(':');
            this.print(version.Revision);
            this.println();
        }
        if ((byArray = assemblyName.GetPublicKeyToken()) != null) {
            this.print("    .publickeytoken = (");
            this.print(PEFile.bytes2hex(byArray));
            this.println(")");
        } else {
            byArray = assemblyName.GetPublicKey();
            if (byArray != null) {
                this.print("    .publickey = (");
                this.print(PEFile.bytes2hex(byArray));
                this.println(")");
            }
        }
        this.println("}");
    }

    void printSignature(FieldInfo fieldInfo) {
        this.printSignature(fieldInfo.FieldType);
        this.print(' ');
        this.printReference(fieldInfo.DeclaringType);
        this.print("::");
        this.printName(fieldInfo.Name);
    }

    void printHeader(MethodBase methodBase, Type type) {
        this.print(MethodAttributes.toString(methodBase.Attributes));
        this.print(' ');
        this.print(CallingConventions.toString(methodBase.CallingConvention));
        this.print(' ');
        this.printSignature(type);
        this.print(' ');
        this.printName(methodBase.Name);
        ParameterInfo[] parameterInfoArray = methodBase.GetParameters();
        this.print('(');
        for (int i = 0; i < parameterInfoArray.length; ++i) {
            if (i > 0) {
                this.print(", ");
            }
            this.print((ParameterBuilder)parameterInfoArray[i]);
        }
        this.print(") ");
        this.print(MethodImplAttributes.toString(methodBase.GetMethodImplementationFlags()));
    }

    void printSignature(MethodBase methodBase) {
        Type type = null;
        if (methodBase instanceof MethodInfo) {
            type = ((MethodInfo)methodBase).ReturnType;
        } else if (methodBase instanceof ConstructorInfo) {
            type = VOID;
        } else {
            throw new RuntimeException();
        }
        String string = CallingConventions.toString(methodBase.CallingConvention);
        this.print(string);
        if (string.length() > 0) {
            this.print(' ');
        }
        this.printSignature(type);
        this.print(' ');
        this.printReference(methodBase.DeclaringType);
        this.print("::");
        this.printName(methodBase.Name);
        ParameterInfo[] parameterInfoArray = methodBase.GetParameters();
        this.print("(");
        for (int i = 0; i < parameterInfoArray.length; ++i) {
            if (i > 0) {
                this.print(", ");
            }
            this.printSignature(parameterInfoArray[i].ParameterType);
        }
        this.print(")");
    }

    static void addPrimitive(String string, String string2) {
        Type type = Type.GetType(string);
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf("Cannot lookup primitive type ".concat(String.valueOf(String.valueOf(type))))));
        }
        primitive.put(type, string2);
    }

    void printSignature(Type type) {
        Object v = primitive.get(type);
        if (v != null) {
            this.print(v);
            return;
        }
        if (type.HasElementType()) {
            this.printSignature(type.GetElementType());
            if (type.IsArray()) {
                this.print("[]");
            } else if (type.IsPointer()) {
                this.print('*');
            } else if (type.IsByRef()) {
                this.print('&');
            }
        } else {
            this.print(type.IsValueType() ? "valuetype " : "class ");
            this.printReference(type);
        }
    }

    void printReference(Type type) {
        if (type.Assembly() != this.currentModule.Assembly) {
            this.print('[');
            this.print(type.Assembly().GetName().Name);
            this.print("]");
        } else if (type.Module != this.currentModule) {
            this.print("[.module ");
            this.print(type.Module.Name);
            this.print("]");
        }
        this.printTypeName(type);
    }

    void printTypeName(Type type) {
        if (type.DeclaringType != null) {
            this.printTypeName(type.DeclaringType);
            this.print('/');
            this.printName(type.Name);
        } else {
            this.printName(type.FullName);
        }
    }

    void printAttributes(ICustomAttributeProvider iCustomAttributeProvider) {
        Object[] objectArray = iCustomAttributeProvider.GetCustomAttributes(false);
        for (int i = 0; i < objectArray.length; ++i) {
            this.print(".custom ");
            this.printSignature(((Attribute)objectArray[i]).getConstructor());
            this.print(" = (");
            this.print(PEFile.bytes2hex(((Attribute)objectArray[i]).getValue()));
            this.println(")");
        }
    }

    static {
        $assertionsDisabled = !Class.forName("ch.epfl.lamp.compiler.msil.emit.ILPrinterVisitor").desiredAssertionStatus();
        VOID = Type.GetType("System.Void");
        TAB = 3;
        SPACES_LEN = SPACES.length();
        primitive = new HashMap();
        ILPrinterVisitor.addPrimitive("System.Object", "object");
        ILPrinterVisitor.addPrimitive("System.String", "string");
        ILPrinterVisitor.addPrimitive("System.Void", "void");
        ILPrinterVisitor.addPrimitive("System.Boolean", "bool");
        ILPrinterVisitor.addPrimitive("System.Char", "char");
        ILPrinterVisitor.addPrimitive("System.SByte", "int8");
        ILPrinterVisitor.addPrimitive("System.Byte", "unsigned int8");
        ILPrinterVisitor.addPrimitive("System.Int16", "int16");
        ILPrinterVisitor.addPrimitive("System.UInt16", "unsigned int16");
        ILPrinterVisitor.addPrimitive("System.Int32", "int32");
        ILPrinterVisitor.addPrimitive("System.UInt32", "unsigned int32");
        ILPrinterVisitor.addPrimitive("System.Int64", "int64");
        ILPrinterVisitor.addPrimitive("System.UInt64", "unsigned int64");
        ILPrinterVisitor.addPrimitive("System.IntPtr", "native int");
        ILPrinterVisitor.addPrimitive("System.UIntPtr", "unsigned native int");
        ILPrinterVisitor.addPrimitive("System.Single", "float32");
        ILPrinterVisitor.addPrimitive("System.Double", "float64");
        ILPrinterVisitor.addPrimitive("System.TypedReference", "typedref");
    }

    class 0
    implements Comparator {
        public int compare(Object object, Object object2) {
            Assembly assembly = (Assembly)object;
            Assembly assembly2 = (Assembly)object2;
            return assembly.GetName().Name.compareTo(assembly2.GetName().Name);
        }

        0() {
        }
    }
}

