/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ksecurity;

import com.sun.ksecurity.CryptoException;
import com.sun.ksecurity.Key;
import com.sun.ksecurity.KeyBuilder;

public final class SecretKey
implements Key {
    byte kind;
    short bitsize;
    boolean initOk;
    byte[] secret = null;

    SecretKey(byte type, short len) {
        this.kind = type;
        this.bitsize = len;
        this.initOk = false;
    }

    public void clearKey() {
        this.initOk = false;
        this.bitsize = 0;
    }

    public short getSize() {
        return this.bitsize;
    }

    public byte getType() {
        return this.kind;
    }

    public boolean isInitialized() {
        return this.initOk;
    }

    public byte getKey(byte[] buf, short off) {
        if (!this.initOk || off + this.secret.length > buf.length) {
            return 0;
        }
        System.arraycopy(this.secret, 0, buf, off, this.secret.length);
        return (byte)this.secret.length;
    }

    public void setKey(byte[] buf, short off) throws CryptoException {
        int cnt = this.bitsize + 7 >>> 3;
        if (off + cnt > buf.length) {
            throw new CryptoException(2);
        }
        this.secret = new byte[cnt];
        System.arraycopy(buf, off, this.secret, 0, cnt);
        this.initOk = true;
    }

    public String toString() {
        return "[" + this.getSize() + "-bit secret key: 0x" + KeyBuilder.hexEncode(this.secret) + "]";
    }
}

