/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.midlet;

import com.sun.midp.lcdui.DisplayAccess;
import com.sun.midp.lcdui.MIDLetMap;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public abstract class MIDletState {
    static final int PAUSED = 0;
    static final int ACTIVE = 1;
    static final int ACTIVE_FOREGROUND = 2;
    static final int PAUSED_RESUME = 3;
    static final int DESTROY_PENDING = 4;
    static final int DESTROYED = 5;
    private int state;
    private Object mutex;
    private Scheduler scheduler;
    protected MIDlet midlet;
    protected DisplayAccess displayAccess;

    protected MIDletState(MIDlet m) {
        this.midlet = m;
        this.state = 3;
        this.scheduler = Scheduler.getScheduler();
        this.mutex = this.scheduler.getMutex();
        Display.getDisplay(this.midlet);
        this.displayAccess = MIDLetMap.get(this.midlet);
        this.scheduler.register(this);
    }

    public MIDlet getMIDlet() {
        return this.midlet;
    }

    public DisplayAccess getDisplayAccess() {
        return this.displayAccess;
    }

    protected abstract void startApp() throws MIDletStateChangeException;

    protected abstract void pauseApp();

    protected abstract void destroyApp(boolean var1) throws MIDletStateChangeException;

    public final void notifyDestroyed() {
        Object object = this.mutex;
        synchronized (object) {
            this.state = 5;
            this.mutex.notify();
        }
    }

    public final void notifyPaused() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == 1 || this.state == 2) {
                this.state = 0;
                this.mutex.notify();
            }
        }
    }

    public final MIDletSuite getMIDletSuite() {
        return this.scheduler.getMIDletSuite();
    }

    public final void resumeRequest() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == 0) {
                this.state = 3;
                this.mutex.notify();
            }
        }
    }

    void setState(int newState) {
        Object object = this.mutex;
        synchronized (object) {
            this.state = newState;
            this.mutex.notify();
        }
    }

    int getState() {
        Object object = this.mutex;
        synchronized (object) {
            int n = this.state;
            return n;
        }
    }
}

