/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.perfmon;

import com.sun.midp.perfmon.PerformanceMonitor;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.TimeZone;

public class PerfMon
implements PerformanceMonitor {
    String m_classname;
    String m_testname;
    boolean m_first_time = true;
    long m_start_t;
    long m_end_t;
    long m_delta_t;
    int[] m_start_count;
    int[] m_end_count;
    int[] m_delta_count;

    public PerfMon() {
        this("");
    }

    public PerfMon(String classname) {
        this.m_classname = classname;
        this.m_start_count = new int[9];
        this.m_end_count = new int[9];
        this.m_delta_count = new int[9];
    }

    public synchronized void init() {
        this.m_start_t = 0L;
        this.m_end_t = -1L;
        this.m_testname = null;
        int i = 0;
        while (i < 9) {
            this.m_start_count[i] = 0;
            this.m_end_count[i] = 0;
            this.m_delta_count[i] = 0;
            ++i;
        }
    }

    public synchronized long start(String testname) {
        this.init();
        this.m_testname = testname;
        int i = 0;
        while (i < 9) {
            this.m_start_count[i] = this.getStat(i);
            ++i;
        }
        this.m_start_t = System.currentTimeMillis();
        return this.m_start_t;
    }

    public synchronized long end() {
        int i = 0;
        while (i < 9) {
            this.m_end_count[i] = this.getStat(i);
            ++i;
        }
        this.m_end_t = System.currentTimeMillis();
        return this.m_end_t;
    }

    public synchronized void report(PrintStream printstream) {
        Calendar cal = Calendar.getInstance();
        TimeZone tz = TimeZone.getTimeZone("GMT");
        cal.setTimeZone(tz);
        this.m_delta_t = this.m_end_t - this.m_start_t;
        int i = 0;
        while (i < 9) {
            this.m_delta_count[i] = this.m_end_count[i] - this.m_start_count[i];
            ++i;
        }
        if (this.m_first_time) {
            printstream.println("\n===============================================================================");
            printstream.println("\t\t\tPerformance Monitor Tracing Report");
            printstream.println("Application Name: [" + this.m_classname + "]");
            printstream.println("Report Date: [" + PerfMon.toString(cal) + "]");
            printstream.println("===============================================================================\n");
            this.m_first_time = false;
        }
        printstream.println("-------------------------------------------------------------------------------");
        printstream.println("Performance Monitor - Snapshot Analysis - ");
        printstream.println("TimeStamp: \t\t[" + PerfMon.toString(cal) + "]");
        printstream.println("Class Name: \t\t[" + this.m_classname + "]");
        printstream.println("Test Name: \t\t[" + this.m_testname + "]");
        printstream.println("Elapsed Time : \t\t[" + this.m_delta_t + "] (milli-seconds)");
        printstream.println("Classname: \t\t[" + this.m_classname + "]");
        printstream.println("Instruction Count: \t[" + this.m_delta_count[0] + "]");
        printstream.println("Thread Switch Count: \t[" + this.m_delta_count[1] + "]");
        printstream.println("Dynamic Object Count: \t[" + this.m_delta_count[2] + "]");
        printstream.println("Dynamic Alloc Count: \t[" + this.m_delta_count[3] + "]");
        printstream.println("Dynamic Dealloc Count: \t[" + this.m_delta_count[4] + "]");
        printstream.println("Garbage Collect Count: \t[" + this.m_delta_count[5] + "]");
        printstream.println("GC Deferrals: \t\t[" + this.m_delta_count[6] + "]");
        printstream.println("Maximum GC Deferrals: \t[" + this.m_delta_count[7] + "]");
        printstream.println("Garbage Collect Rescans:[" + this.m_delta_count[8] + "]");
        printstream.println("-------------------------------------------------------------------------------\n");
    }

    static String toString(Calendar cal) {
        int h = cal.get(10);
        String hour = h == 0 ? " (00" : (h < 10 ? " (0" + h : " (" + h);
        int m = cal.get(12);
        String min = m == 0 ? ":00" : (m < 10 ? ":0" + m : ":" + m);
        int am_pm = cal.get(9);
        return ((Object)cal).toString() + hour + min + " " + (am_pm == 1 ? "pm)" : "am)");
    }

    public int getDelta(int perfmon_id) throws IllegalStateException, IllegalArgumentException {
        if (this.m_start_count[0] == 0 || this.m_end_count[0] == 0) {
            throw new IllegalStateException("Invalid start/end sequence.");
        }
        if (perfmon_id < 0 || perfmon_id > 8) {
            throw new IllegalArgumentException("Invalid PerfMon measurement type");
        }
        this.m_delta_count[perfmon_id] = this.m_end_count[perfmon_id] - this.m_start_count[perfmon_id];
        return this.m_delta_count[perfmon_id];
    }

    public int getStat(int perfmon_id) throws IllegalArgumentException {
        if (perfmon_id < 0 || perfmon_id > 8) {
            throw new IllegalArgumentException("Invalid PerfMon measurement type");
        }
        return PerfMon.sysGetCounter(perfmon_id);
    }

    public long getStartTime() {
        return this.m_start_t;
    }

    public long getEndTime() {
        return this.m_end_t;
    }

    public long getElapsedTime() throws IllegalStateException {
        if (this.m_start_count[0] == 0 || this.m_end_count[0] == 0) {
            throw new IllegalStateException("Invalid start/end sequence.");
        }
        this.m_delta_t = this.m_end_t - this.m_start_t;
        return this.m_delta_t;
    }

    static native int sysGetCounter(int var0);
}

