/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

class ImmutableImage
extends Image {
    ImmutableImage(Image img) {
        this.width = img.width;
        this.height = img.height;
        this.createImmutableCopy(this.width, this.height, img);
    }

    ImmutableImage(byte[] imageData, int imageOffset, int imageLength) {
        if (imageOffset < 0 || imageOffset >= imageData.length || imageLength < 0 || imageOffset + imageLength > imageData.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.decodeImage(imageData, imageOffset, imageLength);
    }

    ImmutableImage(String str) throws IOException {
        InputStream is = null;
        int blocksize = 4096;
        is = this.getClass().getResourceAsStream(str);
        if (is == null) {
            throw new IOException();
        }
        int l = is.available();
        byte[] buffer = new byte[l + 1];
        int length = 0;
        while ((l = is.read(buffer, length, buffer.length - length)) != -1) {
            if ((length += l) != buffer.length) continue;
            byte[] b = new byte[buffer.length + blocksize];
            System.arraycopy(buffer, 0, b, 0, length);
            buffer = b;
        }
        this.decodeImage(buffer, 0, length);
        is.close();
    }

    private native void createImmutableCopy(int var1, int var2, Image var3);

    private native void decodeImage(byte[] var1, int var2, int var3);
}

