package scala.swing.test

import swing._
import swing.event._

object Dialogs extends SimpleGUIApplication {
  import TabbedPane._
  
  val label = new Label("No Result yet")
  val tabs = new TabbedPane {
    pages += new Page("File", new GridBagPanel { grid =>
      import GridBagPanel._
      val buttonText = new TextField("Click Me")
      
      val c = new Constraints
      c.fill = Fill.Horizontal
      c.grid = (1,1)
    
      val chooser = new FileChooser
      layout(new Button(Action("Open") {
        chooser.showOpenDialog(grid)                   
      })) = c
      
      c.grid = (1,2)
      layout(new Button(Action("Save") {
        chooser.showSaveDialog(grid)                 
      })) = c
      
      c.grid = (1,3)
      layout(new Button(Action("Custom") { 
        chooser.showDialog(grid, buttonText.text)
      })) = c
      
      c.grid = (2,3)
      layout(new Label("  with Text  ")) = c
      
      c.grid = (3,3)
      c.ipadx = 50
      layout(buttonText) = c
      
      border = Swing.EmptyBorder(5, 5, 5, 5)
    })
    pages += new Page("Simple Modal Dialogs", new BorderPanel {
      import BorderPanel._
      val mutex = new ButtonGroup
      val ok = new RadioButton("OK (in the L&F's words)")
      val ynlf = new RadioButton("Yes/No (in the L&F's words)")
      val ynp = new RadioButton("Yes/No (in the programmer's words)")
      val yncp = new RadioButton("Yes/No/Cancel (in the programmer's words)")
      val radios = List(ok, ynlf, ynp, yncp)
      mutex.buttons ++= radios 
      mutex.select(ok)      
      val buttons = new BoxPanel(Orientation.Vertical) {
        contents ++= radios
      }
      layout(buttons) = Position.North
      layout(new Button(Action("Show It!") {
        import Dialog._
        mutex.selected.get match {
          case `ok` => 
            showMessage(buttons, "Eggs aren't supposed to be green.")
          case `ynlf` => 
            showConfirmation(buttons, "Would you like green eggs and ham?",
                            "An Inane Question", Options.YesNo) match {
              case Result.Yes => label.text = "Ewww!"
              case Result.No => label.text = "Me neither!"
              case _ => label.text = "Come on -- tell me!"
          }
          case `ynp` => 
            val options = List("Yes, please",
                               "No, thanks",
                               "No eggs, no ham!")
            showOptions(buttons,
                        "Would you like some green eggs to go with that ham?",
                        "A Silly Question",
                        Options.YesNo, Message.Question,
                        Swing.EmptyIcon, options, 2) match {
              case Result.Yes => label.text = "You're kidding!"
              case Result.No => label.text = "I don't like them, either."
              case _ => label.text = "Come on -- 'fess up!"
            }
          case `yncp` => 
            val options = List("Yes, please",
                               "No, thanks",
                               "No eggs, no ham!")
            showOptions(buttons,
                        "Would you like some green eggs to go with that ham?",
                        "A Silly Question",
                        Options.YesNoCancel, Message.Question,
                        Swing.EmptyIcon, options, 2) match {
              case Result.Yes => label.text = "Here you go: green eggs and ham!"
              case Result.No => label.text = "OK, just the ham, then."
              case Result.Cancel => label.text = "Well, I'm certainly not going to eat them!"
              case _ => label.text = "Please tell me what you want!"
            }
        }            
      })) = Position.South
    })
    pages += new Page("More Dialogs", new BorderPanel {
      import BorderPanel._
      val mutex = new ButtonGroup
      val pick = new RadioButton("Pick one of several choices")
      val enter = new RadioButton("Enter some text")
      //val nonClosing = new RadioButton("Non-auto-closing dialog")
      //val validate = new RadioButton("Input-validating dialog (with custom message area)")
      //val nonModal = new RadioButton("Non-modal dialog")
      val radios = List(pick, enter)//, nonClosing, validate, nonModal)
      mutex.buttons ++= radios
      mutex.select(pick)      
      val buttons = new BoxPanel(Orientation.Vertical) {
        contents ++= radios
      }
      layout(buttons) = Position.North
      layout(new Button(Action("Show It!") {
        import Dialog._
        mutex.selected.get match {
          case `pick` => 
            val possibilities = List("ham", "spam", "yam")
            val s = showInput(buttons,
                      "Complete the sentence:\n"
                      + "\"Green eggs and...\"",
                      "Customized Dialog",
                      Message.Plain, Swing.EmptyIcon,
                      possibilities, "ham")

                    //If a string was returned, say so.
            if ((s != None) && (s.get.length > 0))
              label.text =  "Green eggs and... " + s.get + "!"
            else
              label.text = "Come on, finish the sentence!"
          case `enter` => 
            val s = showInput(buttons,
                      "Complete the sentence:\n"
                      + "\"Green eggs and...\"",
                      "Customized Dialog",
                      Message.Plain, Swing.EmptyIcon,
                      Nil, "ham")

                    //If a string was returned, say so.
            if ((s != None) && (s.get.length > 0))
              label.text =  "Green eggs and... " + s.get + "!"
            else
              label.text = "Come on, finish the sentence!"
        }            
      })) = Position.South
    })
  }
  
  val ui = new BorderPanel {
    layout(tabs) = BorderPanel.Position.Center
    layout(label) = BorderPanel.Position.South
  }
   
  
  def top = new MainFrame { 
    title = "Dialog Demo"
    contents = ui
  }
}

