/*
 * mjl_splaytree
 *
 * The (almost) completely reusable splay tree data structure and accompanying
 * algorithms.
 * this code was written for 0657.317 1999 at the University of Waikato
 * by Matthew Luckie
 *
 * Copyright (C) 1999-2007 Matthew Luckie. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY Matthew Luckie ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Matthew Luckie BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: mjl_splaytree.h,v 1.9 2007/03/05 01:26:17 mjl Exp $
 *
 */

#ifndef __MJL_SPLAYTREE_H
#define __MJL_SPLAYTREE_H

typedef struct splaytree splaytree_t;
typedef struct splaytree_node splaytree_node_t;

typedef int  (*splaytree_cmp_t)(const void *a, const void *b);
typedef int  (*splaytree_diff_t)(const void *a, const void *b);
typedef void (*splaytree_display_t)(const void *ptr, int pad);
typedef int  (*splaytree_inorder_t)(void *ptr, void *entry);
typedef void (*splaytree_free_t)(void *ptr);

/* functions for allocating and freeing a splaytree structure */
splaytree_t *splaytree_alloc(splaytree_cmp_t cmp);
void splaytree_free(splaytree_t *tree, splaytree_free_t free_ptr);

/* insert a node into the tree */
splaytree_node_t *splaytree_insert(splaytree_t *tree, const void *ptr);

/* remove a node from the tree */
int splaytree_remove_item(splaytree_t *tree, const void *ptr);
int splaytree_remove_node(splaytree_t *tree, splaytree_node_t *node);

/* find a node in the tree and return it */
void *splaytree_find(splaytree_t *tree, const void *ptr);

/* find a value in the tree closest to a particular value */
void *splaytree_findclosest(splaytree_t *tree, const void *ptr,
			    splaytree_diff_t diff);

/* return the right most node on the left branch of the tree */
void *splaytree_getrmlb(splaytree_t *tree);

/* return the left most node on the right branch of the tree */
void *splaytree_getlmrb(splaytree_t *tree);

/* calculate the longest search path of the subtree passed in */
int splaytree_depth(splaytree_t *tree);

void splaytree_display(splaytree_t *tree, splaytree_display_t disp);

int splaytree_count(splaytree_t *tree);

void splaytree_inorder(splaytree_t *tree, splaytree_inorder_t func, void *in);

#endif /* __MJL_SPLAYTREE_H */
