module Schleuder
  class ManageSelfPlugin < Plugin
    def initialize
      @plugin_type = :request
    end

    def unsubscribe(mail, foo)
      Schleuder.log.debug 'UNSUBSCRIBE requested'
      msg = ''

      key = Plugin.signing_key(mail)
      member = Schleuder.list.find_member_by_key(key) || Schleuder.list.find_admin_by_key(key)

      members = Schleuder.list.members.dup
      members.delete_if {|mem| mem.email.eql?(member.email)}

      if Schleuder.list.members = members
        msg << "Your address #{member.email} hast been unsubscribed.\n"
      else
        msg = "Something failed. Please ask the maintainer of this list to figure out what\nhappened (e.g. by mailing to #{Schleuder.list.owner_addr}).\n"
      end
      msg
    end

  end
end
