/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_function_dialog.h"
#include "sg.h"
#include "sg_dialogs.h"
#include "sg_dataset.h"

#define DATASET_NAME_LENGTH 100

static GtkWidget *functions_dialog = NULL;

static GtkWidget *functions_list;
static GtkWidget *label;
static GtkWidget *exp_entry;
static SGdataset *new_dataset;
static gboolean return_value;

SGdataset *the_function;


static SGdataset * open_function_dialog		(SGdataset *function);

static gboolean
mw_destroy(GtkWidget *widget)
{
  /* This is needed to get out of gtk_main */
  sg_dialog_kill(widget);

/*
  gtk_main_quit ();
*/

  functions_dialog = NULL;

  return FALSE;
}

static gboolean
mw_destroy2(GtkWidget *widget)
{
  /* This is needed to get out of gtk_main */
  sg_dialog_kill(widget);

  gtk_main_quit ();

  return FALSE;
}

static void
update_label(gint row)
{
  SGdataset *aux_data;
  GList *list;
  gchar *ctext[1];
  gchar text[1000];

  gtk_clist_get_text(GTK_CLIST(functions_list), row, 0, &ctext[0]);

  list = functions;
  while(list){
    aux_data = (SGdataset *)list->data;

    if(strcmp(((GtkPlotData *)aux_data->real_data)->name, ctext[0]) == 0) break;
       
    list = list->next;
  } 

  sprintf(text, "%s = %s",ctext[0], aux_data->exp);
  gtk_label_set_text(GTK_LABEL(label), text);
}

static void
select_row(GtkCList *clist, gint row, gint col, GdkEvent *event)
{
  update_label(row);
}

static gint
new_function(GtkWidget *widget, gpointer data)
{
  SGdataset *aux_data1, *aux_data2;
  gchar text[1000];
  gchar *ctext[1];

  aux_data1 = sg_dataset_new_function(NULL);
  sprintf(text, "f%d(x)", last_function+1);
  sg_dataset_set_name(aux_data1, text);

  aux_data2 = open_function_dialog(aux_data1);

  if(aux_data2){
    SGdataset *new_data;

    new_data = sg_project_new_function(aux_data2->exp);
    ctext[0] = new_data->real_data->name;
    gtk_clist_append(GTK_CLIST(functions_list), ctext);
    sprintf(text, "%s = %s", ctext[0], new_data->exp);
    gtk_label_set_text(GTK_LABEL(label), text);

    gtk_object_destroy(GTK_OBJECT(aux_data2));
  }

  gtk_object_destroy(GTK_OBJECT(aux_data1));

  return TRUE;
}

static gint
edit_function(GtkWidget *widget, gpointer data)
{
  SGdataset *aux_data = NULL;
  SGdataset *new_data = NULL;
  gchar *ctext[1];
  gboolean new_function;
  GList *selection;
  GList *list;
  gint row;
  gchar text[1000];

  selection = GTK_CLIST(functions_list)->selection;
  if(!selection) return TRUE;

  row = GPOINTER_TO_INT(selection->data);

  gtk_clist_get_text(GTK_CLIST(functions_list), row, 0, &ctext[0]);

  list = functions;
  while(list){
    aux_data = (SGdataset *)list->data;

    if(strcmp(((GtkPlotData *)aux_data->real_data)->name, ctext[0]) == 0) break;
       
    list = list->next;
  } 

  new_data = open_function_dialog(aux_data);

  if(new_function){
    sg_dataset_set_exp(aux_data, new_data->exp);
    sprintf(text, "%s = %s", ctext[0], aux_data->exp);
    gtk_label_set_text(GTK_LABEL(label), text);
  }

  gtk_object_destroy(GTK_OBJECT(new_data));

  return TRUE;
}


static gint
delete_function(GtkWidget *widget, gpointer data)
{
  SGdataset *aux_data;
  GList *selection;
  GList *list;
  gchar *ctext[1];
  gint row;
  gboolean veto;

  selection = GTK_CLIST(functions_list)->selection;
  if(!selection) return TRUE;

  row = GPOINTER_TO_INT(selection->data);
  gtk_clist_get_text(GTK_CLIST(functions_list), row, 0, &ctext[0]);

  list = functions;
  while(list){

    aux_data = (SGdataset *)list->data;

    if(strcmp(((GtkPlotData *)aux_data->real_data)->name, ctext[0]) == 0) break;
       
    list = list->next;
  } 

  veto = sg_project_remove_dataset(aux_data, FALSE);

  if(!veto) return TRUE;

  gtk_clist_remove(GTK_CLIST(functions_list), row);

  gtk_label_set_text(GTK_LABEL(label), "");

  return TRUE;
}

void
sg_function_dialog_new ()
{
  GtkWidget *window;
  GtkWidget *frame;
  GtkWidget *main_box;
  GtkWidget *sw;
  GtkWidget *action_area;
  GtkWidget *new_button, *delete_button, *edit_button, *close_button;
  GList *list;
  SGdataset *dataset;
  gchar *text[1];

  if(functions_dialog){
      gdk_window_raise(functions_dialog->window);
      return;
  }

  /* Create widgets */
  functions_dialog = window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW(window),"Function Datasets");

  sg_dialog_new(window);
/*
  gtk_window_set_modal (GTK_WINDOW(window),TRUE);
*/

  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
  gtk_container_add (GTK_CONTAINER (window), main_box);

  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_start (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);

  close_button = sg_stock_button ("Button_Ok");
  gtk_box_pack_start (GTK_BOX (action_area), close_button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(close_button);
  gtk_widget_show (close_button);

/********************************************************************/
  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start (GTK_BOX (main_box), frame, FALSE, FALSE, 0);

  gtk_container_add(GTK_CONTAINER(frame), sg_get_function_dialog());
/**************************************************************/  
  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_start (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);

  new_button = gtk_button_new_with_label ("New");
  gtk_box_pack_start (GTK_BOX (action_area), new_button, TRUE, TRUE, 0);
  gtk_widget_show (new_button);

  delete_button = gtk_button_new_with_label ("Delete");
  gtk_box_pack_start (GTK_BOX (action_area), delete_button, TRUE, TRUE, 0);
  gtk_widget_show (delete_button);

  edit_button = gtk_button_new_with_label ("Edit");
  gtk_box_pack_start (GTK_BOX (action_area), edit_button, TRUE, TRUE, 0);
  gtk_widget_show (edit_button);

  /* connect signals */

  gtk_signal_connect(GTK_OBJECT(new_button), "clicked",
                     (GtkSignalFunc) new_function, NULL);

  gtk_signal_connect(GTK_OBJECT(delete_button), "clicked",
                     (GtkSignalFunc) delete_function, NULL);

  gtk_signal_connect(GTK_OBJECT(edit_button), "clicked",
                     (GtkSignalFunc) edit_function, NULL);

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (mw_destroy),NULL);

  gtk_signal_connect_object (GTK_OBJECT (close_button), "clicked",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT(window));

  /* show widgets */

  gtk_widget_show_all(window);

  /* wait until dialog get destroyed */
/*
  gtk_main();
*/
  return;
}

static void
end_ok(GtkWidget *widget, gpointer data)
{
  new_dataset = sg_edit_function_update();
  gtk_widget_destroy(widget);
}

static SGdataset * 
open_function_dialog(SGdataset *function)
{
  GtkWidget *window = NULL;
  GtkWidget *frame;
  GtkWidget *main_box;
  GtkWidget *ok_button, *cancel_button;
  GtkWidget *action_area;
  GtkWidget *table;
  GtkWidget *label;

  new_dataset = NULL;

  window=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW(window),"Edit Function");

  gtk_window_set_modal (GTK_WINDOW(window),TRUE);

  sg_dialog_new(window);

  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
  gtk_container_add (GTK_CONTAINER (window), main_box);

  gtk_box_pack_start (GTK_BOX (main_box), sg_edit_function_dialog(function), FALSE, FALSE, 0);

  /* Action Area */
  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_end (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);
  gtk_widget_show (action_area);

  ok_button = sg_stock_button ("Button_Ok");
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), ok_button, TRUE, TRUE, 0);
  gtk_widget_grab_default (ok_button);
  gtk_widget_show (ok_button);

  cancel_button = sg_stock_button ("Button_Cancel");
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), cancel_button, TRUE, TRUE, 0);
  gtk_widget_show (cancel_button);

  /* connect signals */
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (window));
  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (end_ok),
                             GTK_OBJECT (window));

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (mw_destroy2),NULL);

  /* Show widgets */

  gtk_widget_show_all (window);

  /* wait until dialog get destroyed */
  gtk_main();

  return new_dataset;
}

GtkWidget *
sg_get_function_dialog()
{
  GtkWidget *main_box;
  GtkWidget *sw;
  GList *list;
  gchar *titles[] = {"  Functions   ", NULL };

  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);

  sw = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_set_border_width(GTK_CONTAINER(sw), 5);
  gtk_widget_set_usize(sw, 120, 160);
  gtk_box_pack_start (GTK_BOX (main_box), sw, FALSE, FALSE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
                                 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  functions_list = gtk_clist_new_with_titles(1, titles);
  gtk_container_add(GTK_CONTAINER(sw), functions_list);

  label = gtk_label_new("");
  gtk_misc_set_alignment(GTK_MISC(label), 0., .5);
  gtk_box_pack_start (GTK_BOX (main_box), label, FALSE, FALSE, 0);

  list = functions;
  while(list){
    SGdataset *dataset;

    dataset = SG_DATASET(list->data);
    if(dataset->real_data->is_function){
        gchar *text[1];
        text[0] = dataset->real_data->name;
        gtk_clist_append(GTK_CLIST(functions_list), text);
    }

    list = list->next;
  }

  gtk_signal_connect (GTK_OBJECT (functions_list), "select_row",
                      GTK_SIGNAL_FUNC (select_row),NULL);

  return main_box;
}
