/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <math.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_project_menu.h"
#include "sg.h"
#include "sg_dialogs.h"
#include "sg_menu.h"
#include "../pixmaps/pixmaps.h"
#include "python/python_main.h"


static char *popup_items[]={
                "Open",
                "Rename",
                "Remove",
};

static GtkWidget *worksheet_popup;
static GtkWidget *plot_popup;


static void sg_menu_new_project				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_new_plot				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_new_plot_3d				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_new_plot_polar			(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_new_worksheet			(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_new_matrix				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_new_function                        (GtkWidget *widget,
                                                         gpointer data);
static void sg_menu_open				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_import				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_save				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_save_as				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_load_script                         (GtkWidget *widget,
                                                         gpointer data);
static void sg_menu_preferences				(GtkWidget *widget, 
							 gpointer data);
static void sg_menu_doc					(GtkWidget *widget,
							 gpointer data);
static void sg_menu_example				(GtkWidget *widget,
							 gpointer data);

void
sg_worksheet_popup_show(GtkIconListItem *item, GdkEventButton *event)
{
    active_icon = item;

    gtk_menu_popup(GTK_MENU(worksheet_popup), NULL, NULL, NULL, NULL,
                   event->button, event->time);
}

void
sg_plot_popup_show(GtkIconListItem *item, GdkEventButton *event)
{
    active_icon = item;

    gtk_menu_popup(GTK_MENU(plot_popup), NULL, NULL, NULL, NULL,
                   event->button, event->time);
}


static void
plot_popup_activated(GtkWidget *widget, gpointer data)
{
 gchar *item;
 GtkIconList *iconlist;
 SGplot *plot;

 item = (gchar *)data;
 iconlist = GTK_ICON_LIST(iconlist2);

 plot =  (SGplot *) gtk_icon_list_get_link(active_icon);

 if(strcmp(item,"Open")==0)
   gtk_widget_show(GTK_WIDGET(plot));

 if(strcmp(item,"Remove")==0){
   gchar message[100]; 
   
   sprintf(message,"Remove %s ?", plot->name);
   if( sg_accept_dialog(message, 1) != YES_CLICKED ) return;

   sg_project_remove_plot(plot);
 }

 if(strcmp(item,"Rename")==0)
   gtk_icon_list_set_active_icon(iconlist, active_icon);

}

static void
worksheet_popup_activated(GtkWidget *widget, gpointer data)
{
 gchar *item;
 GtkIconList *iconlist;
 SGworksheet *worksheet;

 item = (gchar *)data;
 iconlist = GTK_ICON_LIST(iconlist1);

 worksheet = (SGworksheet *) gtk_icon_list_get_link(active_icon);

 if(strcmp(item,"Open")==0)
   gtk_widget_show(GTK_WIDGET(worksheet));

 if(strcmp(item,"Remove")==0){
   gchar text[100];

   sprintf(text,"Remove %s ?", worksheet->name);
   if( sg_accept_dialog(text, 1) != YES_CLICKED ) return;

   sg_project_remove_worksheet(worksheet);
 }

 if(strcmp(item,"Rename")==0)
   gtk_icon_list_set_active_icon(iconlist, active_icon);

}


void
sg_project_build_popups()
{
        GtkWidget *item;
        int i;

        worksheet_popup = gtk_menu_new();

        for (i=0; i < (sizeof(popup_items)/sizeof(popup_items[0])) ; i++){
                item=gtk_menu_item_new_with_label(popup_items[i]);
                gtk_signal_connect(GTK_OBJECT(item),"activate",
                                   (GtkSignalFunc) worksheet_popup_activated,
                                   popup_items[i]);
                gtk_widget_show(item);
                gtk_menu_append(GTK_MENU(worksheet_popup),item);
        }

        plot_popup = gtk_menu_new();

        for (i=0; i < (sizeof(popup_items)/sizeof(popup_items[0])) ; i++){
                item=gtk_menu_item_new_with_label(popup_items[i]);
                gtk_signal_connect(GTK_OBJECT(item),"activate",
                                   (GtkSignalFunc) plot_popup_activated,
                                   popup_items[i]);
                gtk_widget_show(item);
                gtk_menu_append(GTK_MENU(plot_popup),item);
        }

}

GtkWidget *
sg_project_build_toolbar(GtkWidget *top_level)
{
  GnomeUIInfo main_toolbar[] =
  {
    GNOMEUIINFO_ITEM("New", "Create new project", sg_menu_new_project,
                     new_xpm),
    GNOMEUIINFO_ITEM("Open", "Open project", sg_menu_open,
                     open_xpm),
    GNOMEUIINFO_ITEM("Save", "Save project", sg_menu_save,
                     save_xpm),
    GNOMEUIINFO_SEPARATOR,

    GNOMEUIINFO_ITEM("Sheet", "Create new worksheet", sg_menu_new_worksheet, 
                      new_sheet_xpm),
    GNOMEUIINFO_ITEM("2D", "Create new 2D plot", sg_menu_new_plot, 
                      new_2d_xpm),
    GNOMEUIINFO_ITEM("3D", "Create new 3D plot", sg_menu_new_plot_3d,
                      new_3d_xpm),
    GNOMEUIINFO_ITEM("Polar", "Create new polar plot", sg_menu_new_plot_polar, 
                      new_polar_xpm),
    GNOMEUIINFO_ITEM("Function", "Create new function", sg_menu_new_function, 
                      new_function_xpm),
    GNOMEUIINFO_END
  };
#ifdef WITH_GNOME
  gnome_app_create_toolbar(GNOME_APP(top_level), main_toolbar);
#else
  sg_ui_create_toolbar(GTK_BIN(top_level)->child, main_toolbar);
#endif
  return NULL;
}

static GnomeUIInfo new_menu[] = {
    GNOMEUIINFO_ITEM("P_roject", "Create new project", sg_menu_new_project,
                     new_small_xpm),

    GNOMEUIINFO_ITEM("_Worksheet", "Create new worksheet", sg_menu_new_worksheet,
                     sheet_small_xpm),

    GNOMEUIINFO_ITEM("_Matrix", "Create new matrix", sg_menu_new_matrix,
                     sheet_small_xpm),

    GNOMEUIINFO_ITEM("2D _Plot", "Create new 2D plot", sg_menu_new_plot,
                     new_2d_small_xpm),

    GNOMEUIINFO_ITEM("3_D Plot", "Create new 3D plot", sg_menu_new_plot_3d,
                     new_3d_small_xpm),

    GNOMEUIINFO_ITEM("Po_lar Plot", "Create new polar plot", sg_menu_new_plot_polar,
                     new_polar_small_xpm),

    GNOMEUIINFO_ITEM("_Function", "Create new function", sg_menu_new_function,
                     function_small_xpm),

   GNOMEUIINFO_END
 };

static GnomeUIInfo open_previous_menu[] = {
    GNOMEUIINFO_ITEM("Rob: List of prev. projects; how?",
                     "Open a previous project", sg_menu_open,
		     open_small_xpm),

   GNOMEUIINFO_END
 };   

static GnomeUIInfo gnome_file_menu[] = {
   GNOMEUIINFO_SUBTREE("_New", new_menu),
   
   GNOMEUIINFO_ITEM("_Open", "Open file", sg_menu_open,
                    open_small_xpm),

/*
   GNOMEUIINFO_SUBTREE("Open _Previous", open_previous_menu),
*/
   
   GNOMEUIINFO_ITEM("_Import", "Import file", sg_menu_import,
                    open_small_xpm),

   GNOMEUIINFO_ITEM("_Save", "Save file", sg_menu_save,
                    save_small_xpm),

   GNOMEUIINFO_ITEM("Save _As...", "Save As", sg_menu_save_as,
                    save_as_small_xpm),

   GNOMEUIINFO_SEPARATOR,

   GNOMEUIINFO_ITEM("E_xit", "Exit program", sg_menu_exit,
                    exit_small_xpm),

   GNOMEUIINFO_END
};

static GnomeUIInfo gnome_edit_menu[] = {
   GNOMEUIINFO_ITEM("Preferences", "Configure user preferences",
                    general_config_dialog, preferences_small_xpm),

   GNOMEUIINFO_END
};

static GnomeUIInfo gnome_win_menu[] = {
    GNOMEUIINFO_ITEM("Python _terminal", "Open Python terminal window",
                     create_python_term, python_small_xpm),

    GNOMEUIINFO_SEPARATOR,

    GNOMEUIINFO_ITEM("_Configure", "Configure modules",
                     python_config_dialog, preferences_small_xpm),

    GNOMEUIINFO_END
 };



static GnomeUIInfo gnome_docs_menu[] = {
  GNOMEUIINFO_ITEM_DATA("_Introduction", "Introduction", sg_menu_doc,
                        "Introduction.html", book_small_xpm), 
		   
  GNOMEUIINFO_ITEM_DATA("_Tutorial", "Tutorial", sg_menu_doc,
                        "Tutorial.html", book_small_xpm),

  GNOMEUIINFO_ITEM_DATA("_User's Guide", "User's Guide", sg_menu_doc,
                        "UserGuide.html", book_small_xpm),

  GNOMEUIINFO_ITEM_DATA("_FAQ", "Frequently Ansked Questions", sg_menu_doc,
                        "FAQ.html", book_small_xpm),

   GNOMEUIINFO_END
 };

static GnomeUIInfo gnome_examples_menu[] = {
  GNOMEUIINFO_ITEM_DATA("_simpletest", "simpletest", sg_menu_example,
                        "simpletest.sg", sg_small_xpm),

  GNOMEUIINFO_ITEM_DATA("_ticks", "ticks", sg_menu_example,
                        "ticks.sg", sg_small_xpm),

  GNOMEUIINFO_ITEM_DATA("_multicolumn", "multicolumn", sg_menu_example,
                        "multicolumn.sg", sg_small_xpm),

  GNOMEUIINFO_ITEM_DATA("t_rigonometric", "trigonometric", sg_menu_example,
                        "trigonometric.sg", sg_small_xpm),

  GNOMEUIINFO_ITEM_DATA("_vectors", "vectors", sg_menu_example,
                        "vectors.sg", sg_small_xpm),

  GNOMEUIINFO_ITEM_DATA("_3d", "3d", sg_menu_example,
                        "3d.sg", sg_small_xpm),

  GNOMEUIINFO_ITEM_DATA("_polar", "polar", sg_menu_example,
                        "polar.sg", sg_small_xpm),

  GNOMEUIINFO_ITEM_DATA("_image", "Image", sg_menu_example,
                        "image.sg", sg_small_xpm),

  GNOMEUIINFO_ITEM_DATA("matri_x", "matrix", sg_menu_example,
                        "matrix.sg", sg_small_xpm),

  GNOMEUIINFO_END
};


static GnomeUIInfo gnome_help_menu[] = {
  GNOMEUIINFO_HELP("scigraphica"),
    
#ifndef WITH_GNOME
  GNOMEUIINFO_SUBTREE("_Documentation", gnome_docs_menu),
#endif
  GNOMEUIINFO_SUBTREE("_Examples", gnome_examples_menu),

  GNOMEUIINFO_SEPARATOR,

  GNOMEUIINFO_ITEM("_About", "About SciGraphica",
                     sg_about_dialog, about_small_xpm),

  GNOMEUIINFO_END
};

static GnomeUIInfo gnome_main_menu[] = {
   GNOMEUIINFO_SUBTREE("_File", gnome_file_menu),
   GNOMEUIINFO_SUBTREE("_Edit", gnome_edit_menu),
   GNOMEUIINFO_SUBTREE("_Script", gnome_win_menu),
   GNOMEUIINFO_SUBTREE("_Help", gnome_help_menu),

   GNOMEUIINFO_END
 };

GtkWidget *
sg_project_build_menu(GtkWidget *app)
{
#ifdef WITH_GNOME
  gnome_app_create_menus(GNOME_APP(app), gnome_main_menu);
#else
  sg_ui_create_menus(GTK_BIN(app)->child, gnome_main_menu);
#endif
  
  return NULL;
}

void
sg_menu_exit(GtkWidget *widget, gpointer data)
{
  sg_dialogs_destroy(widget);

  if(project_changed){
    gchar label[255];
    g_snprintf(label, 255, "Save project \"%s\" before leaving?", last_project_filename);
    switch( sg_accept_dialog(label, 0) ) {
      case YES_CLICKED:
        sg_menu_save(widget, data);
      case NO_CLICKED:
        break;
      case CANCEL_CLICKED:
      case DESTROY_CLICKED:
        return;
    }
  }
  sg_project_autosave_set(0);
  python_config_save();
  main_quit(widget);
}

static void
sg_menu_new_plot(GtkWidget *widget, gpointer data)
{
  sg_project_new_plot_with_layer(SG_LAYER_2D);
}

static void
sg_menu_new_plot_3d(GtkWidget *widget, gpointer data)
{
  sg_project_new_plot_with_layer(SG_LAYER_3D);
}

static void
sg_menu_new_plot_polar(GtkWidget *widget, gpointer data)
{
  sg_project_new_plot_with_layer(SG_LAYER_POLAR);
}

static void
sg_menu_new_worksheet(GtkWidget *widget, gpointer data)
{
  sg_project_new_worksheet();
}

static void
sg_menu_new_matrix(GtkWidget *widget, gpointer data)
{
  sg_project_new_matrix();
}

static void
sg_menu_new_function(GtkWidget *widget, gpointer data)
{
  sg_function_dialog_new();
}

static void
sg_menu_new_project(GtkWidget *widget, gpointer data)
{
  if(project_changed){
    gchar label[80];
    g_snprintf(label, 80, "Save project \"%s\" ?", last_project_filename);
    switch ( sg_accept_dialog(label, 0) ){
      case YES_CLICKED:
         sg_menu_save(widget, data);
         break;
      case NO_CLICKED:
         break;
      case CANCEL_CLICKED:
      case DESTROY_CLICKED:
         return;
    }
  }

  sg_project_close();
  sg_project_new();
  sg_project_new_worksheet();
  sg_project_changed(FALSE);
}

static void
sg_menu_open(GtkWidget *widget, gpointer data)
{
/*
  if(project_changed){
    gchar label[80];
    g_snprintf(label, 80, "Save project \"%s\" ?", last_project_filename);
    switch ( sg_accept_dialog(label, 0) ){
      case YES_CLICKED:
         sg_menu_save(widget, data);
         break;
      case NO_CLICKED:
         break;
      case CANCEL_CLICKED:
      case DESTROY_CLICKED:
         return;
    }
  }
*/

  sg_project_open();
}

static void
sg_menu_import(GtkWidget *widget, gpointer data)
{
  sg_project_import();
}


static void
sg_menu_save(GtkWidget *widget, gpointer data)
{
  sg_project_export();
}

static void
sg_menu_save_as(GtkWidget *widget, gpointer data)
{
  sg_project_export_as();
}

static void
sg_menu_load_script(GtkWidget *widget, gpointer data)
{
  sg_script_import();
}

static void
sg_menu_doc(GtkWidget *widget, gpointer data)
{
 gchar path[250];
 gchar command[250];

 if ( getenv("SG_ROOT") )
    g_snprintf(path, 250, "%s/share/gnome/help/scigraphica/C/%s", getenv("SG_ROOT"), (gchar*)data);
 else
    g_snprintf(path, 250, SG_ROOT "/share/gnome/help/scigraphica/C/%s", (gchar*)data);

 if ( getenv("SG_DOCVIEWER") )
    {gchar string[250];
     g_snprintf(string, 250, "%s &", getenv("SG_DOCVIEWER"));
     g_snprintf(command, 250, string, path, path);
    }
 else
    g_snprintf(command, 250, SG_DOCVIEWER " &", path, path);

 system(command);
}

static void
sg_menu_example(GtkWidget *widget, gpointer data)
{
 gchar path[250];

 if(project_changed){
   g_snprintf(path, 250, "Save project \"%s\" ?", last_project_filename);
   switch ( sg_accept_dialog(path, 0) ){
     case YES_CLICKED:
        sg_menu_save(widget, data);
       break;
     case NO_CLICKED:
       break;
     case CANCEL_CLICKED:
     case DESTROY_CLICKED:
       return;
   }
 }

 if ( getenv("SG_ROOT") )
    g_snprintf(path, 250, "%s/share/scigraphica/examples/%s", getenv("SG_ROOT"), (gchar*)data);
 else
    g_snprintf(path, 250, SG_ROOT "/share/scigraphica/examples/%s", (gchar*)data);

 sg_project_close();
 sg_project_new();
 sg_project_file_import_xml(path, NULL, NULL);
 sg_project_changed(FALSE);
}
