//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.


// Declarations:


// Code:

// Demo file for density exponential model
// Use gp_expDensity to reproduce density
// plot (help figure)

Z = 0:50:100e3;       //altitude in meters
[D] = CL_mod_expDensity(Z);

Z = Z/1000; //convert to km to plot

//PLOT
f = scf();
f.immediate_drawing="off";
f.visible = "off"; 

plot2d(D,Z,2);
a = gca();
a.box = "on"; 
a.x_label.text = 'Density [kg/m3]';
a.y_label.text = 'Altitude [km]';
a.data_bounds = [min(D),min(Z);max(D),max(Z)];
a.sub_ticks = [0,0];
a.grid = [1,1];
a.children.children.thickness = 2;

a.title.text = 'Density exponential model';
a.title.font_size = 3;
a.title.font_size = 3;
a.x_label.font_size = 2;
a.y_label.font_size = 2;

f.immediate_drawing="on";
f.visible = "on"; 


