/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.scilab.modules.renderer;


 /** 
  * Call from the JoGL dislay thread to figure drawing code using JNI 
  * @author Jean-Baptiste Silvy
  * @copyright INRIA 2007 
  */
public class FigureScilabCall {

 /**
  * Constructor. Should not be called.
  */
 protected FigureScilabCall() {
	throw new UnsupportedOperationException();
 }
  
 /**
  * Draw a figure inside the OpenGL context
  * @param figureId index of the figure to redraw
  */
public static void displayFigure(int figureId) {
    FigureScilabCallJNI.displayFigure(figureId);
  }

  
 /**
  * Redraw a figure and its all children inside the OpenGL context
  * @param figureId index of the figure to redraw
  */
public static void redrawFigure(int figureId) {
    FigureScilabCallJNI.redrawFigure(figureId);
  }

  
 /**
  * Redraw all the subwindows inside a figure.
  * This should be called when the figure is resized.
  * @param figureId index of the figure to redraw
  */
public static void redrawSubwins(int figureId) {
    FigureScilabCallJNI.redrawSubwins(figureId);
  }

  
 /**
  * Modify a subwin viewing angles by a certain amount.
  * @param subwinHandle handle of the subwin to modify
  * @param deltaAlpha modify the alpha angle with this value
  * @param deltaTheta modify the theta angle with this value
  */
public static void rotateSubwin(long subwinHandle, double deltaAlpha, double deltaTheta) {
    FigureScilabCallJNI.rotateSubwin(subwinHandle, deltaAlpha, deltaTheta);
  }

  
 /**
  * Modify a subwin viewing angles by a certain amount.
  * @param figureId index of the figure to check
  * @param clickXCoord x coordinate of the mouse click
  * @param clickYCoord y coordinate of the mouse click
  * @return handle of the clicked subwin or 0 if no subwin was clicked
  */
public static long getClickedSubwinHandle(int figureId, int clickXCoord, int clickYCoord) {
    return FigureScilabCallJNI.getClickedSubwinHandle(figureId, clickXCoord, clickYCoord);
  }

  
 /**
  * Zoom a figure or an axis handle using a selection area.
  * @param objectHandle handle of the figure o subwin to modify
  * @param x1 X coordinate of a corner of the selection
  * @param y1 Y coordinate of a corner of the selection
  * @param x2 X coordinate of the oppoiste corner of the selection
  * @param y2 Y coordinate of the opposite corner of the selection
  */
public static void zoomObject(long objectHandle, int x1, int y1, int x2, int y2) {
    FigureScilabCallJNI.zoomObject(objectHandle, x1, y1, x2, y2);
  }

  
 /**
  * Reset zoom of a subwindow.
  * @param subwinHandle handle of the subwin to modify
  */
public static void unzoomSubwinHandle(long subwinHandle) {
    FigureScilabCallJNI.unzoomSubwinHandle(subwinHandle);
  }

}
