/***************************************************************************
                          actions.c  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2001 by Hendrik Sattler
    email                : post@hendrik-sattler.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"

void set_smsc (char* smsnr) {
    char at_command[128];
    char ack[BUFSIZ];
    char buffer;

    memset(at_command,0,sizeof(at_command));
    memset(ack,0,sizeof(ack));
	
    if (!strlen(smsnr)) {
        errexit("No number specified.\n");
    } else if (!is_pnumber(smsnr,1)) {
	errexit("No valid number specified.\n");
    }
    new_at_command(at_command,"+CSCA");
    add_at_command(at_command,"=%s",smsnr);
    buffer=smsnr[1];
    if (buffer=='+') {
	add_at_command(at_command,",145");
    } else {
	add_at_command(at_command,",129");
    }
    com_mytty(at_command,ack);
    if (!strcmp(ack,"OK")) {
        myprintf(0,"SMS server number was set to %s\n",smsnr);
    } else {
        errexit("%s\n",ack);
    }
}

void set_time () {
    char at_command[128];
    char ack[BUFSIZ];
    time_t seconds;
    char timestr[128];
	
    memset(at_command,0,sizeof(at_command));
    memset(ack,0,sizeof(ack));
    memset(timestr,0,sizeof(timestr));
	
    new_at_command(at_command,"+CCLK");
    time(&seconds); //seconds since Unix
    //string formatting with conversion to local time
    strftime(timestr,sizeof(timestr),"%y/%m/%d,%H:%M:%S",localtime(&seconds));
    add_at_command(at_command,"=\"%s\"",timestr);
    com_mytty(at_command,ack);
    if (!strcmp(ack,"OK")) {
	myprintf(0,"Time was synchronized\n");
    } else {
	errexit("Time could not be synchronized\n");
    }
}

char* get_value (char* at) {
    char at_command[128];
    static char ausgabe[BUFSIZ];
    char ack[BUFSIZ];
    
    memset(at_command,0,sizeof(at_command));
    memset(ausgabe,0,sizeof(ausgabe));
    memset(ack,0,sizeof(ack));

    new_at_command(at_command,at);
    write_mytty(at_command);
    read_mytty(at_command,ausgabe);
    if (strstr(ausgabe,"ERROR")==0) {
	read_mytty(at_command,ack);
	return ausgabe;
    } else {
	 return "?";
    }
}

inline char* get_vendor () {
    return get_value("+CGMI");
}

inline char* get_model () {
    return get_value("+CGMM");
}

inline char* get_revision () {
    return get_value("+CGMR");
}

inline char* get_phoneserial () {
    return get_value("+CGSN");
}

inline char* get_simserial () {
    return get_value("+CIMI");
}

char* get_simid () {
    char* ausgabe;

    if(!strcasecmp(get_vendor(),"SIEMENS")) {
	ausgabe=get_value("^SCID");
	if (!strncmp(ausgabe,"^SCID: ",7)) {
	    return ausgabe+7;
	}
    }
    return "?";
}

char* get_operator () {
    char* ausgabe;
    
    ausgabe=get_value("+COPS?");
    if (!strncmp(ausgabe,"+COPS: ",7)) {
	if (ausgabe[strlen(ausgabe)-1]=='"') {
	    memset(&ausgabe[strlen(ausgabe)-1],0,1);
	}
	if ((ausgabe=strstr(ausgabe,",\""))!=NULL) {
	    return ausgabe+2;
	}
    }
    return "?";
}

char* get_smsc () {
    char* ausgabe;
    char* temp;
    
    ausgabe=get_value("+CSCA?");
    if (!strncmp(ausgabe,"+CSCA: \"",8)) {
	ausgabe+=8;
	if ((temp=strstr(ausgabe,"\","))!=NULL) {
	    memset(temp,0,strlen(temp));
	    return ausgabe;
	}
    }
    return "?";
}

char* get_charset () {
    char* ausgabe;
    
    ausgabe=get_value("+CSCS?");
    if (!strncmp(ausgabe,"+CSCS: \"",8)) {
	ausgabe+=8;
	if (ausgabe[strlen(ausgabe)-1]=='"') {
	    memset(&ausgabe[strlen(ausgabe)-1],0,1);
	    return ausgabe;
	}
    }
    return "?";
}

char* get_battery () {
    char* ausgabe;
    
    ausgabe=get_value("+CBC");
    if (!strncmp(ausgabe,"+CBC: ",6)) {
	if ((ausgabe=strstr(ausgabe,","))!=NULL) {
	    return ausgabe+1;
	}
    }
    return "?";
}

char* get_signal_ber () {
    char* ausgabe;
    
    ausgabe=get_value("+CSQ");
    if (!strncmp(ausgabe,"+CSQ: ",6)) {
	return ausgabe+6;
    }
    return "";
}

char* get_time () {
    char* ausgabe;
    
    ausgabe=get_value("+CCLK?");
    if (!strncmp(ausgabe,"+CCLK: \"",8)) {
	ausgabe+=8;
	if (ausgabe[strlen(ausgabe)-1]=='"') {
	    memset(&ausgabe[strlen(ausgabe)-1],0,1);
	    return ausgabe;
	}
    }
    return "?";
}

char* get_filetypes () {
    char* ausgabe;

    if(!strcasecmp(get_vendor(),"SIEMENS")) {
	ausgabe=get_value("^SBNR=?");
	if (!strncmp(ausgabe,"^SBNR: ",7)) {
	    return ausgabe+7;
	}
    }
    return "";
}

char* get_pbtypes () {
    char* ausgabe;

    if(!strcasecmp(get_vendor(),"SIEMENS")) {
	ausgabe=get_value("^SPBS=?");
	if (!strncmp(ausgabe,"^SPBS: ",7)) {
	    return ausgabe+7;
	}
    } else {
	ausgabe=get_value("+CPBS=?");
	if (!strncmp(ausgabe,"+CPBS: ",7)) {
	    return ausgabe+7;
	}
    }
    return "";
}

void info(){
    char *temp;
    int t;
	
    myprintf(0,"Vendor:\t\t%s\n",get_vendor());
    myprintf(0,"Model:\t\t%s\n",get_model());
    myprintf(0,"Revision:\t%s\n",get_revision());
    myprintf(0,"Serial (Phone):\t%s\n",get_phoneserial());
    myprintf(0,"Serial (SIM):\t%s\n",get_simserial());
    myprintf(0,"SIM-ID:\t\t%s\n",get_simid());
    myprintf(0,"Operator:\t%s\n",get_operator());
    myprintf(0,"SMS Server:\t%s\n",get_smsc());
    myprintf(0,"Charset:\t%s\n",get_charset());
    myprintf(0,"Battery:\t%s\%\n",get_battery());
    
    temp=get_signal_ber();
    if (strlen(temp)) {
	t=atoi(temp);
	if (t==99) {
	    myprintf(0,"Signal/BER:\t?/?");
	} else {
	    myprintf(0,"Signal/BER:\t%d dBm",-111+((t-1)*2));
	}
	if ((temp=strstr(temp,","))!=NULL) {
	    t=atoi(++temp);
	    if (t==99) {
		myprintf(0,"/unknown\n");
	    } else {
		myprintf(0,"/%d\n",t);
	    }
	}
    } else {
	myprintf(0,"Signal/BER:\t?/?\n");
    }
	
    myprintf(0,"Time:\t\t%s\n",get_time());

    temp=get_filetypes();
    if (strlen(temp)) {
	myprintf(0,"Avail. Slots:\t");
	temp=(char *)strtok(temp,"()\",");
	while(temp!=0){
	    myprintf(0,"%s: %s",temp,strtok(NULL,"()\","));
	    temp=(char *)strtok(NULL,"()\",");
	    if (temp!=0){myprintf(0,", ");}
	}
	printf ("\n");
    } else {
	myprintf(0,"Avail. Slots:\t?\n");
    }

    temp=get_pbtypes();
    if (strlen(temp)) {
	myprintf(0,"Phonebooks:\t");
	temp=(char *)strtok(temp,"()\",");
	while(temp!=0){
	    myprintf(0,"%s",temp);
	    temp=(char *)strtok(NULL,"()\",");
	    if (temp!=0) {
		myprintf(0,", ");
	    }
	}
	printf ("\n");
    } else {
	myprintf(0,"Phonebooks:\t?\n");
    }
}
