/***************************************************************************
                          s35_files.c  -  description
                             -------------------
    copyright            : (C) 2001 by Hendrik Sattler
    email                : post@hendrik-sattler.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"

void transfer_s35 (int   action,
		   char* file, char* ftype,
		   int   slot, int   minimum, int   maximum,
		   char* pipe) {
    int i,
	k=1,
	fnlength=1;
    static int current_min;
    char* filename;
    
    switch(action){
	default:
	case 0:
		errexit("You must specify exactly one operation.\n");
		break;
			
	case 2: //deleting
		if (slot == -2) {
		    for (i=minimum;i<=maximum;i++) {
			slot=i;
			delete_file_s35(ftype, slot);
		    }
		} else if (slot < 0) {
		    errexit ("You must select a slot.\n");
		} else {
		    delete_file_s35(ftype, slot);
		}
		break;
			
	case 4: //sending
		//limit free slot detection to sensable values
		if (current_min<minimum) {
		    current_min=minimum;
		}
		if (slot < -1) {
		    errexit("Specify a slot or use auto-detection.\n");
		} else if (slot<current_min) {
		    slot=detect_free_s35(ftype,current_min,maximum);
		}
		if (slot >= 0) {
		    myprintf(0,"Detected empty slot %d\n",slot);
		    current_min=slot+1;
		    send_file_s35(file,ftype,slot);
		} else  if (slot == -1){
		    errexit("No free slot found.\n");
		}
		break;
			
	case 8: //getting
		if (slot == -2) {
		    while (maximum>k*10) {
			fnlength++;
			k*=10;
		    }
		    fnlength+=strlen(file)+strlen(ftype)+2;
		    filename=malloc(fnlength);
		    memset(filename,0,fnlength);
		    for (i=minimum;i<=maximum;i++) {
			slot=i;
			if (strcmp(file,"-")) {
			    sprintf(filename,"%s%d.%s",file,slot,ftype);
			    get_file_s35(filename,ftype,slot,pipe);
			} else {
			    get_file_s35(file,ftype,slot,pipe);
			}
		    }
		    free(filename);
		} else if (slot < 0) {
		    errexit ("You must select a slot (either a number or \"all\").\n");
		} else {
		    get_file_s35(file,ftype,slot,pipe);
		}
		break;
    }
}

void delete_file_s35 (char* ftype, int slot) {
    char at_command[128];
    char ausgabe[BUFSIZ];

    memset(at_command,0,sizeof(at_command));
    memset(ausgabe,0,sizeof(ausgabe));

    new_at_command(at_command,"^SBNW");
    add_at_command(at_command,"=\"%s\",%d,0",ftype,slot);
    com_mytty(at_command,ausgabe);
    if (!strcmp(ausgabe,"OK")) {
	myprintf(0,"%s %d deleted.\n",ftype,slot);
    } else {
	errexit("%s %d NOT deleted, something went wrong(%s).\n",ftype,slot,ausgabe);
    }
}

int detect_free_s35 (char* ftype, int minimum, int maximum) {
    char at_command[128];
    char ausgabe[BUFSIZ];
    int i;
    
    memset(at_command,0,sizeof(at_command));
    memset(ausgabe,0,sizeof(ausgabe));
    
    myprintf(0,"Trying to find an empty slot...\n");
    i=minimum;
    while (i<=maximum) {
	new_at_command(at_command,"^SBNR");
	add_at_command(at_command,"=\"%s\",%d",ftype,i);
	write_mytty(at_command);
	read_mytty(at_command,ausgabe);
	if (strcmp(ausgabe,"OK")) {
	    while (strcmp(ausgabe,"OK")) {
		read_mytty(at_command,ausgabe);
	    }
	} else if (strstr(ausgabe,"ERROR")!=NULL) {
	    errexit("\n\"%s\"\n",ausgabe);
	} else {
	    return i;
	}
	i++;
    }
    return -1;
}

void send_file_s35 (char* file, char* ftype, int slot) {
    char at_command[128];
    char ausgabe[BUFSIZ];
    char ack[BUFSIZ];
    int pdusize=176; //max is 176
    char buffer[(2*pdusize)+1];
    char transfer[(2*pdusize)+1];
    int packetnum=1,myfd,i,lastsent=0;
    unsigned char data;
    char datastr[3];

    memset(at_command,0,sizeof(at_command));
    memset(ausgabe,0,sizeof(ausgabe));
    memset(ack,0,sizeof(ack));
    memset(transfer,0,sizeof(transfer));
    memset(datastr,0,sizeof(datastr));

    //trying to open the file
    myfd=open_myFile_ro(file);
    
    //reading for first time
    //read one char more then pdusize to see if there is more than one package
    for(i=0;i<pdusize;i++){
	if (read(myfd,&data,1)!=1) {
	    break;
	}
	sprintf(&transfer[i*2],"%02x",data);
    }
    if (strlen(transfer)==sizeof(transfer)-1) {
	for(i=0;i<pdusize;i++){
	    if (read(myfd,&data,1)!=1) {
		break;
	    }
	    sprintf(&buffer[i*2],"%02x",data);
	}
    }
    myprintf(0,"File transfer...\n");
    while (strlen(transfer)!=0) {
	new_at_command(at_command,"^SBNW");
	if (strlen(buffer)>0) {
	    add_at_command(at_command,"=\"%s\",%d,%d,%d",ftype,slot,packetnum,packetnum+1);
	} else {
	    add_at_command(at_command,"=\"%s\",%d,%d,%d",ftype,slot,packetnum,packetnum);
	}
	write_mytty(at_command);
	myprintf(0,"Waiting for data request... ");
	read_mytty_limited(at_command,ack,2);
	if (!strncmp(ack,"> ",2)) {
	    myprintf(0,"Sending data... ");
	    //sending hex data
	    // \x1a represents Ctrl-Z (represents end of data stream)
	    if (strlen(buffer)==2*pdusize || strlen(buffer)==0) {
		lastsent=strlen(transfer)/2;
	    } else {
		lastsent=(strlen(transfer)+strlen(buffer))/4;
	    }
	    myprintf(1,"\nBuffer1 content: %s (%d)\n",transfer,strlen(transfer));
	    myprintf(1,"\nBuffer2 content: %s (%d)\n",buffer,strlen(buffer));
	    myprintf(1,"Sending %d Bytes in Paket %d\n",lastsent,packetnum);
	    if (write(mytty,transfer,2*lastsent) != 2*lastsent
	          || write(mytty,"\x1a",1) != 1) {
	        close(myfd);
	        errexit("Error on sending data. Aborting.");
	    }
	    read_mytty(at_command,ack);
	    if (!strcmp(ack,"OK")) {
		myprintf(0,"Packet %d sent\n",packetnum);
	    } else if (!strcmp(ack,"+CME ERROR: INV CHAR IN TEXT")) {
		close(myfd);
		errexit("ERROR: Wrong data format\n");
	    } else {
		close(myfd);
		errexit("\n\"%s\"\n",ack);
	    }
	    //now enter the loop if we have to
	    if (strlen(buffer)==2*pdusize) {
		strcpy(transfer,buffer);
	        for (i=0;i<pdusize;i++) {
		    if (read(myfd,&data,1)!=1) {
			break;
		    }
		    sprintf(&buffer[i*2],"%02x",data);
		}
		packetnum++;
	    } else if (strlen(buffer)>0) {
		strcpy(transfer,&transfer[2*lastsent]);
		strcpy(&transfer[strlen(transfer)],buffer);
		memset(buffer,0,sizeof(buffer));
		packetnum++;
	    } else {
		memset(transfer,0,1);
	    }
	} else {
	    read_mytty_limited(at_command,&ack[2],sizeof(ack)-3);
	    if (!strcmp(ack,"+CME ERROR: INVALID INDEX")) {
		myprintf(0,"ERROR\nPacket buffer seems to be filled with something else, clearing...\n");
		new_at_command(at_command,"^SBNW");
		add_at_command(at_command,"=\"%s\",%d",ftype,slot);
		write_mytty(at_command);
		read_mytty(at_command,ausgabe);
		if (strcmp(ausgabe,"OK")) {
		    errexit("%s, aborting\n",ausgabe);
		}
	    } else {
		close(myfd);
		errexit("\n\"%s\"\n",ack);
	    }
	}
    }
    if (packetnum) {
	myprintf(0,"File transfer complete.\n");
    } else {
	myprintf(0,"Nothing to transfer.\n");
    }
    close(myfd);
}

void get_file_s35 (char* file, char* ftype, int slot, char* pipe) {
    char at_command[128];
    char ausgabe[BUFSIZ];
    int packetnum=0,
	maxpackets=0,
	myfd=-1,
	i;
    unsigned char data;
    char datastr[3];
    FILE* pipefd = NULL;

    memset(at_command,0,sizeof(at_command));
    memset(ausgabe,0,sizeof(ausgabe));
    memset(datastr,0,sizeof(datastr));

    //creating at command
    new_at_command(at_command,"^SBNR");
    add_at_command(at_command,"=\"%s\",%d",ftype,slot);

    //sending at command (parsing the answer)
    write_mytty(at_command);
    myprintf(0,"Slot %d...\n",slot);
    do{
	memset(ausgabe,0,sizeof(ausgabe));
	read_mytty(at_command,ausgabe);
	if (!(strcmp(ausgabe,"OK"))) {
	    myprintf(0,"Empty slot: nothing to get\n");
	    close_myFile(myfd);
	    return;
	} else if (strstr(ausgabe,"ERROR")!=NULL) {
	    close_myFile(myfd);
	    errexit("%s, aborting\n",ausgabe);			
	} else {
	    if (strlen(file) && myfd==-1) {
		myfd=open_myFile_rw(file);
	    }
	    if (strlen(pipe) && pipefd==NULL) {
		pipefd=popen(pipe,"w");
	    }
	    strtok(ausgabe,",");
	    strtok(NULL,",");
	    packetnum=atoi((char *)strtok(NULL,","));
	    maxpackets=atoi((char *)strtok(NULL,","));
	    myprintf(0,"Receiving packet %d of %d...\n",packetnum,maxpackets);
	    read_mytty(at_command,ausgabe);
	    for (i=0;i<strlen(ausgabe);i+=2) {	
		sprintf(datastr,"%c%c",ausgabe[i],ausgabe[i+1]);
		data=hexstr2int(datastr);
		if (myfd!=-1) {
		    if (write(myfd,&data,1)!=1) {
		        close_myFile(myfd);
			if (strlen(pipe) && pipefd!=NULL) {
			    pclose(pipefd);
			}
		        errexit("ERROR on writing to %s.\n",file);			
		    }
		}
		if (strlen(pipe) && pipefd!=NULL) {
		    if (fwrite(&data,1,1,pipefd)!=1) {
			close_myFile(myfd);
			pclose(pipefd);
			errexit("ERROR on writing to pipe \"%s\".\n",pipe);					    
		    }
		}
	    }
	}
    } while (packetnum!=maxpackets);
    close_myFile(myfd);
    if (strlen(pipe) && pipefd!=NULL && pclose(pipefd)==-1) {
	close(myfd);
	errexit("ERROR on closing pipe \"%s\".\n",pipe);			
    }
    memset(ausgabe,0,sizeof(ausgabe));
    read_mytty(at_command,ausgabe);
    if (!(strcmp(ausgabe,"OK"))) {
	myprintf(0,"File transfer complete.\n");
    } else {
	errexit("%s, aborting\n",ausgabe);
    }
}

