/***************************************************************************
                          s35_sms.c  -  description
                             -------------------
    copyright            : (C) 2001 by Hendrik Sattler
    email                : post@hendrik-sattler.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"

void sms_s35(int action, char* file, char* pipe,
	     struct datapair mydata, int smsslot,
	     int flashsms){
    switch(action){
	default:
		errexit("You must specify an operation.\n");
		break;
			
	case 2: //deleting
		delete_sms_s35(smsslot);
		break;
			
	case 4: //sending from/to SMS memory
		if (smsslot) {
		    send_smsslot_s35(file,smsslot,mydata.number);
		} else {
		    send_sms_s35(file,mydata.text,mydata.number,0,flashsms);
		}
		break;
	
	case 5: //sending through the phone
		send_sms_s35(file,mydata.text,mydata.number,1,flashsms);
		break;
			
	case 8: //getting messages
		get_sms_s35(file, pipe, smsslot);
		break;

	case 9: //getting messages as unexpected notice from the phone
		 //incmoing messages are NOT STORED IN THE PHONE!!!
		get_direct_sms_s35(file,pipe);
		break;
    }
    memset(mydata.text,0,strlen(mydata.text)); //so we do not submit the same sms multiple times
}

void delete_sms_s35(int smsslot){
    char at_command[128];
    char ausgabe[BUFSIZ];
    char ack[BUFSIZ];

    memset(at_command,0,sizeof(at_command));
    memset(ausgabe,0,sizeof(ausgabe));
    memset(ack,0,sizeof(ack));

    if (smsslot>0) {
        new_at_command(at_command,"+CMGD");
        add_at_command(at_command,"=%d",smsslot);
        com_mytty(at_command,ack);
	if (!strcmp(ack,"OK")) {
	    myprintf(0,"SMS slot %d was deleted.\n",smsslot);
	} else if(!strcmp(ack,"+CMS ERROR: INVALID MEMORY INDEX")) {
	    errexit("This index is not available.\n");
	} else if(strstr(ack,"ERROR")!=NULL) {
	    errexit("%s, aborting.\n",ack);
	}
    } else {
        errexit("You must specify a valid slot number.\n");
    }
}


void send_smsslot_s35(char* file, int smsslot, char* smsnumber){
    char at_command[128];
    char ausgabe[BUFSIZ];
    char ack[BUFSIZ];
    char buffer;

    memset(at_command,0,sizeof(at_command));
    memset(ausgabe,0,sizeof(ausgabe));
    memset(ack,0,sizeof(ack));

    new_at_command(at_command,"+CMSS");
    add_at_command(at_command,"=%d",smsslot);
    if (strlen(smsnumber)>0) {
        add_at_command(at_command,",%s",smsnumber);
        buffer=smsnumber[0];
        if (buffer=='+') {
	    add_at_command(at_command,",145");
	} else {
	    add_at_command(at_command,",129");
	}
    }
    com_mytty(at_command,ausgabe);
    if (!strcmp(ausgabe,"+CMS ERROR: INVALID MEMORY INDEX")) {
	errexit("This index is not available.\n");
    } else if(strstr(ausgabe,"ERROR")!=NULL) {
        errexit("%s, aborting.\n",ausgabe);
    }
    myprintf(0,"The message was sent. Message referrer: %s\n",&ausgabe[7]);
    read_mytty(at_command,ack);
    myprintf(0,"The phone returned: %s\n",ack);
}

void send_sms_s35(char* file, char* smstext, char* smsnumber, int direct, int flashsms){
    char at_command[128];
    char ausgabe[BUFSIZ];
    char ack[BUFSIZ];
    char pdu[BUFSIZ];
    char smsinput[161];
    int myfd,i,eof_present=0,read_ret;

    memset(at_command,0,sizeof(at_command));
    memset(ausgabe,0,sizeof(ausgabe));
    memset(ack,0,sizeof(ack));
    memset(pdu,0,sizeof(pdu));
    memset(smsinput,0,sizeof(smsinput));

    if (strlen(smstext)==0) {// --sms-text was not used, look for other sources
        myfd=open_myFile_ro(file);
        for (i=0;i<sizeof(smsinput)-1;i++) {
            read_ret=read(myfd,&smsinput[i],1);
	    if (read_ret==0) {
	        eof_present=1;
	        break;
	    } else if (read_ret==-1) {
	        errexit("Error while reading from file.\n");
	    }
	}
	if (eof_present==0) {
	    errexit("SMS text is too long (max. %d characters).\n",sizeof(smsinput)-1);
	}
	if (strlen(smsinput)==0) {
	    errexit("No SMS text found (or zero length).\n");
	} else {
	    myprintf(0,"%s has %d bytes.\n",file,strlen(smsinput));
	}
    } else {
	if (strlen(smstext)>=sizeof(smsinput)) {
	    errexit("SMS text is too long (max. %d characters).\n",sizeof(smsinput)-1);
	} else {
	    strcpy(smsinput,smstext);
	}
    }
    myprintf(0,"Creating PDU...\n");
    create_smssubmit_pdu(pdu,smsinput,smsnumber,flashsms);
    myprintf(1,"PDU: %s\n",pdu);

    if (direct) {
	new_at_command(at_command,"+CMGS");
    } else {
	new_at_command(at_command,"+CMGW");
    }
    add_at_command(at_command,"=%d",(strlen(pdu)/2)-1);
    write_mytty(at_command);
    myprintf(0,"Waiting for data request...\n");
    read_mytty_limited(at_command,ack,2);
    if (!strncmp(ack,"> ",2)) {
	myprintf(0,"Sending data...\n");
	if ((write(mytty,pdu,strlen(pdu))!=strlen(pdu))
	      ||(write(mytty,"\x1a",1)!=1)) {
	    errexit("ERROR on sending data...\n");
	}
	read_mytty(at_command,ausgabe);
	if (strstr(ausgabe,"ERROR")!=NULL) {
	    errexit("An error occured on sending the SMS: %s\n",ausgabe);
	}
	if (direct) {
	    myprintf(0,"The message was sent. Message referrer: %s\n",&ausgabe[7]);
	} else {
	    myprintf(0,"The message was saved to SMS memory slot %s\n",&ausgabe[7]);
	}
	read_mytty(at_command,ack);
	myprintf(0,"The phone returned: %s\n",ack);
    } else {
	read_mytty_limited(at_command,&ack[2],sizeof(ack)-3);
	if (!strncmp(ack,"ERROR",5)) {
	    errexit("An unknown error occured.");
	} else {
	    errexit("ERROR: %s\n",&ausgabe[12]);
	}
    }
}

void get_sms_s35(char* file, char* pipe, int smsslot){
    char at_command[128];
    char ausgabe[BUFSIZ];
    char ack[BUFSIZ];
    int myfd=-1,
	slot,
	status;
    FILE *pipefd = NULL;
	
    memset(at_command,0,sizeof(at_command));
    memset(ausgabe,0,sizeof(ausgabe));
    memset(ack,0,sizeof(ack));

    if (smsslot>0) {
        new_at_command(at_command,"+CMGR");
        add_at_command(at_command,"=%d",smsslot);    
    } else { // 0=unread, -1=read, -2=unsent, -3=sent, -4=all
	if (smsslot<(-4)) {
	    smsslot=0;
	}
        new_at_command(at_command,"+CMGL");
	add_at_command(at_command,"=%d",smsslot*(-1));
    }
    if (!strlen(file) && !strlen(pipe) && smsslot==0) {
	errexit("This changes the status of the requested sms from \"unread\" to \"read\" but no output method was specified.\n");
    }
    com_mytty(at_command, ausgabe);
    if (!strcmp(ausgabe,"OK")) {
	errexit("There are no SMS of this type on the phone.\n");
    } else if (!strcmp(ausgabe,"+CMS ERROR: INVALID MEMORY INDEX")) {
	errexit("This index is not available.\n");
    } else if (strstr(ausgabe,"ERROR")!=NULL) {
	errexit("%s, aborting.\n",ausgabe);
    } else {
	if (strlen(file)) {
	    myfd=open_myFile_rw(file);
	} 
	while (strcmp(ausgabe,"OK") && strcmp(ausgabe,"ERROR")) {
	    if (smsslot>0) {
		slot=smsslot;
		status=atoi((char *)strtok(&ausgabe[7],","));
	    } else {
		slot=atoi((char *)strtok(&ausgabe[7],","));
		status=atoi((char *)strtok(NULL,","));
	    }
	    myprintf(0,"Receiving SMS from slot %d with status %d.\n",slot,status);
	    //the value in the last paramater is totally wrong :-((
	    //or it is some number I cannot match to anything
	    memset(ausgabe,0,sizeof(ausgabe));
	    read_mytty(at_command,ausgabe);
	    if (!strcmp(ausgabe,"OK")) {
		close(myfd);
		errexit("This slot is empty.\n");
	    } else {
		//misusing "ack" variable to save some memory
		sprintf(ack,"Slot: %d\n",slot);
		//decode PDU
		decode_smsdeliver_pdu(ausgabe, status);
		//now save it
		if (myfd!=-1) {
		    if (write(myfd,ack,strlen(ack))!=strlen(ack)
			  || write(myfd,ausgabe,strlen(ausgabe))!=strlen(ausgabe)
			  || write(myfd,"\n",1)!=1) {
			close(myfd);
			errexit("\nERROR on writing to %s.\n",file);
		    }
		}
		if (strlen(pipe)) { //also send output (splitted) to a given pipe
		    pipefd=popen(pipe,"w");
		    if (pipefd!=NULL) {
			if (fwrite(ausgabe,1,strlen(ausgabe),pipefd)!=strlen(ausgabe)){
			    close(myfd);
			    pclose(pipefd);
			    errexit("\nERROR on writing to pipe \"%s\".\n",pipe);
			}
			if (pclose(pipefd)==-1) {
			    close(myfd);
			    errexit("\nERROR on closing pipe \"%s\".\n",pipe);
			}
		    }
		}
		memset(ausgabe,0,sizeof(ausgabe));
		read_mytty(at_command,ausgabe);
	    }
	}
	close_myFile(myfd);
    }
}

void get_direct_sms_s35(char* file, char* pipe){
    char at_command[128];
    char ausgabe[BUFSIZ];
    char ack[BUFSIZ];
    int myfd=-1;
    FILE *pipefd = NULL;
	
    memset(at_command,0,sizeof(at_command));
    memset(ausgabe,0,sizeof(ausgabe));
    memset(ack,0,sizeof(ack));

    if (!strlen(file) && !strlen(pipe)) {
        errexit("No output method was specified.\n");
    }
    new_at_command(at_command,"+CSMS=1");
    write_mytty(at_command);
    read_mytty(at_command,ausgabe);
    if (strstr(ausgabe,"ERROR")==NULL) {
        read_mytty(at_command,ack);
    } else {
	errexit("Could not set Phase 2+ compatible mode.\n");
    }
    new_at_command(at_command,"+CNMI=1,2,0,0,1");
    com_mytty(at_command,ack);
    if (strcmp(ack,"OK")) {
	errexit("Could not set direct mode.\n");
    }
    if (strlen(file)) {
        myfd=open_myFile_rw(file);
    }
    while (1) {
	read_mytty("",ausgabe);
	if (strstr(ausgabe,"+CMT: ,")==(char *)ausgabe) {
	    read_mytty("",ausgabe);
	    decode_smsdeliver_pdu(ausgabe,0);
	    if (myfd!=-1) {
		if ((write(myfd,ausgabe,strlen(ausgabe))!=strlen(ausgabe))
		      ||(write(myfd,"\n",1)!=1)) {
		    close(myfd);
		    errexit("\nERROR on writing to %s.\n",file);
		}
	    } else if (strlen(pipe)) { //also send output (splitted) to a given pipe
		pipefd=popen(pipe,"w");
		if (pipefd!=NULL) {
		    if (fwrite(ausgabe,1,strlen(ausgabe),pipefd)!=strlen(ausgabe)){
			close(myfd);
			pclose(pipefd);
			errexit("\nERROR on writing to pipe \"%s\".\n",pipe);
		    }
		    if (pclose(pipefd)==-1) {
			close(myfd);
			errexit("\nERROR on closing pipe \"%s\".\n",pipe);
		    }
		}
	    }
	    //if this is not sent, SMSC will resent the SMS so we would receive it multiple times
	    new_at_command(at_command,"+CNMA=0");
	    com_mytty(at_command,ack);
	    if (strcmp(ack,"OK")) {
		errexit("SMS ack should have been ok but was not.\n");
	    }
	}
    }
}

