;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/backend.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Sep 23 15:01:55 2001                          */
;*    Last change :  Thu Dec 20 14:32:17 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    Scribe back-end handling                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_backend
   
   (import __scribeapi_param)
   
   (export (register-backend! ::symbol ::procedure)
	   (find-backend-processor ::symbol)))

;*---------------------------------------------------------------------*/
;*    *backends* ...                                                   */
;*---------------------------------------------------------------------*/
(define *backends* '())

;*---------------------------------------------------------------------*/
;*    register-backend! ...                                            */
;*---------------------------------------------------------------------*/
(define (register-backend! id processor)
   (set! *backends* (cons (cons id processor) *backends*)))

;*---------------------------------------------------------------------*/
;*    find-backend-processor ...                                       */
;*---------------------------------------------------------------------*/
(define (find-backend-processor id)
   (let* ((lids (let ((cell (assq id *scribe-backend-alist*)))
		   (if (pair? cell)
		       (cdr cell)
		       (list (symbol->string id)))))
	  (lnames (map (lambda (lid)
			  (cond-expand
			     (bigloo-c
			      (string-append "libscribe" lid ".so"))
			     (bigloo-jvm
			      (string-append "bigloo.scribe.scribe"
					     lid
					     "."
					     lid
					     ".class"))))
		       lids))
	  (fnames (map (lambda (lname)
			  (cond-expand
			     (bigloo-c
			      (find-file/path lname *scribe-library-path*))
			     (bigloo-jvm
			      lname)))
		       lnames)))
      (let loop ((fnames fnames)
		 (lnames lnames)
		 (proc (lambda (x) x)))
	 (if (null? fnames)
	     proc
	     (let ((fname (car fnames)))
		(if (not (string? fname))
		    (error "find-backend-processor"
			   "Can't find library"
			   (car lnames))
		    (begin
		       (if (>fx *scribe-verbose* 0)
			   (fprint (current-error-port)
				   "  [loading: " fname "]"))
		       (dynamic-load fname)
		       (let ((cell (assoc id *backends*)))
			  (loop (cdr fnames)
				(cdr lnames)
				(if (and (pair? cell) (procedure? (cdr cell)))
				    (lambda (x)
				       ((cdr cell) (proc x)))
				    proc))))))))))
   
